// Copyright (C) 2024 The Qt Company Ltd.
// Copyright © 2004-2023 Unicode, Inc.
// SPDX-License-Identifier: Unicode-3.0

#ifndef QTIMEZONELOCALE_DATA_P_H
#define QTIMEZONELOCALE_DATA_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not a normal header file.
// It defines data tables for internal use by QTimeZone's L10n code.
// It may change incompatibly between versions, or even be removed.
//
// We mean it.
//

// Only qtimezonelocale.cpp should #include this (after other things it needs),
// and even that only when feature icu is disabled.

QT_REQUIRE_CONFIG(timezone_locale);
#if QT_CONFIG(icu)
#  error "This file should only be needed (or seen) when ICU is not in use"
#endif

QT_BEGIN_NAMESPACE

#ifdef QT_CLDR_ZONE_DEBUG
#  define LOCALE_TAGS(lang, script, land) lang, script, land,
#else
#  define LOCALE_TAGS(lang, script, land)
#endif

namespace QtTimeZoneLocale {

/*
    Locale-specific data for timezone naming.
    https://www.unicode.org/reports/tr35/tr35-68/tr35-dates.html#Time_Zone_Names

    Available data, per locale, from LocaleScanner.timeZoneNames():

        formats: {
            'hour': ('+HH:mm', '-HH:mm'),
            'GMT': 'GMT%0',
            'region': ("%0 Time", std, dst),
            'fallback': "%1 (%0)" }
        zones: { ianaid: {
                'exemplarCity': name,
                'long': (gen, std, dst), 'short': (gen, std, dst) } }
        metazones: { meta: {'long': (gen, std, dst), 'short': (gen, std, dst) } }

    Mapped to C++ data-structures below (defined in QTZL_p.h) and used by
    QTZL.cpp, in conjunction with QTZP_data_p.h's locale-independent data
    conditioned on timezone_locale.
*/

// GENERATED PART STARTS HERE

/*
    This part of the file was generated on 2025-11-13 from the
    Common Locale Data Repository v48

    http://www.unicode.org/cldr/

    Do not edit this section: instead regenerate it using
    cldr2qlocalexml.py and qlocalexml2cpp.py on updated (or
    edited) CLDR data; see qtbase/util/locale_database/.
*/

// Sorted by locale index, then iana name
static inline constexpr LocaleZoneExemplar localeZoneExemplarTable[] = {
    // locInd, ianaInd, xcty{ind, sz}
    {    0,   14,       0,  6, }, // Africa/Asmara C/AnyScript/AnyTerritory
    {    0, 5185,       6,  8, }, // Africa/El_Aaiun
    {    0, 6888,      14,  4, }, // Africa/Lome
    {    0, 5290,      18,  9, }, // Africa/Ndjamena
    {    0, 4454,      27,  8, }, // Africa/Sao_Tome
    {    0, 4573,      35,  9, }, // America/Araguaina
    {    0,  270,      44,  7, }, // America/Argentina/Cordoba
    {    0, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {    0, 7571,      63,  7, }, // America/Argentina/Tucuman
    {    0, 4271,      70,  8, }, // America/Asuncion
    {    0,  237,      78,  8, }, // America/Atikokan
    {    0, 7623,      86, 17, }, // America/Bahia_Banderas
    {    0, 7646,     103,  5, }, // America/Belem
    {    0, 4380,     108,  6, }, // America/Bogota
    {    0, 3887,     114,  6, }, // America/Cancun
    {    0, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    0, 3810,     133,  6, }, // America/Cuiaba
    {    0, 5742,     139,  7, }, // America/Curacao
    {    0, 7887,     146,  8, }, // America/Eirunepe
    {    0,  481,     154, 13, }, // America/Indiana/Knox
    {    0, 7979,     167, 16, }, // America/Indiana/Marengo
    {    0, 8003,     183, 19, }, // America/Indiana/Petersburg
    {    0, 8030,     202, 18, }, // America/Indiana/Tell_City
    {    0, 8056,     220, 14, }, // America/Indiana/Vevay
    {    0, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    0, 8104,     252, 16, }, // America/Indiana/Winamac
    {    0, 8143,     268, 20, }, // America/Kentucky/Monticello
    {    0, 5951,     288, 22, }, // America/Lower_Princes
    {    0, 8171,     310,  6, }, // America/Maceio
    {    0, 2919,     316,  8, }, // America/Mazatlan
    {    0, 8238,     324,  6, }, // America/Merida
    {    0, 2951,     330, 11, }, // America/Mexico_City
    {    0, 4410,     341, 12, }, // America/Miquelon
    {    0, 1852,     353, 19, }, // America/Noronha
    {    0, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {    0, 8347,     392, 20, }, // America/North_Dakota/Center
    {    0, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {    0,  393,     435,  4, }, // America/Nuuk
    {    0, 8495,     439,  8, }, // America/Santarem
    {    0, 1880,     447,  9, }, // America/Sao_Paulo
    {    0, 6918,     456, 16, }, // America/Scoresbysund
    {    0, 8526,     472, 14, }, // America/St_Barthelemy
    {    0, 2063,     486, 10, }, // America/St_Johns
    {    0, 5882,     496,  9, }, // America/St_Kitts
    {    0, 5899,     505,  9, }, // America/St_Lucia
    {    0,  855,     514, 10, }, // America/St_Thomas
    {    0, 5932,     524, 11, }, // America/St_Vincent
    {    0, 6020,     535, 13, }, // Antarctica/Casey
    {    0, 6152,     548, 24, }, // Antarctica/DumontDUrville
    {    0, 8586,     572, 16, }, // Antarctica/Macquarie
    {    0, 7085,     588, 14, }, // Antarctica/Mawson
    {    0,  932,     602, 15, }, // Antarctica/McMurdo
    {    0, 8607,     617, 11, }, // Antarctica/Palmer
    {    0, 7226,     628, 15, }, // Antarctica/Rothera
    {    0, 7295,     643, 13, }, // Antarctica/Syowa
    {    0, 8625,     656, 13, }, // Antarctica/Troll
    {    0, 7374,     669, 14, }, // Antarctica/Vostok
    {    0, 5542,     683,  5, }, // Asia/Aqtau
    {    0, 1261,     688, 16, }, // Asia/Ho_Chi_Minh
    {    0, 4790,     704,  5, }, // Asia/Hovd
    {    0, 1187,     709,  9, }, // Asia/Kathmandu
    {    0,  994,     718,  7, }, // Asia/Kolkata
    {    0, 1213,     725,  5, }, // Asia/Macau
    {    0, 8726,     730,  8, }, // Asia/Qostanay
    {    0, 4288,     738,  9, }, // Asia/Qyzylorda
    {    0, 1161,     747,  6, }, // Asia/Urumqi
    {    0, 1237,     753,  6, }, // Asia/Yangon
    {    0, 6647,     759,  8, }, // Atlantic/Canary
    {    0, 1397,     767,  6, }, // Atlantic/Faroe
    {    0, 6840,     773, 10, }, // Atlantic/St_Helena
    {    0, 1549,     783, 16, }, // Australia/Lord_Howe
    {    0, 8790,     799,  8, }, // Europe/Busingen
    {    0, 2585,     807,  8, }, // Europe/Chisinau
    {    0, 2529,     815,  4, }, // Europe/Kyiv
    {    0, 6221,     819,  6, }, // Europe/Tirane
    {    0, 6966,     825, 18, }, // Indian/Chagos
    {    0, 6065,     843, 16, }, // Indian/Christmas
    {    0, 6082,     859, 13, }, // Indian/Cocos
    {    0, 5048,     872,  7, }, // Indian/Comoro
    {    0, 6680,     879, 17, }, // Indian/Kerguelen
    {    0, 7260,     896,  4, }, // Indian/Mahe
    {    0, 7211,     900,  7, }, // Indian/Reunion
    {    0, 3034,     907, 15, }, // Pacific/Chatham
    {    0, 3176,     922,  5, }, // Pacific/Chuuk
    {    0, 2239,     927, 13, }, // Pacific/Easter
    {    0, 6697,     940, 17, }, // Pacific/Galapagos
    {    0, 3068,     957, 13, }, // Pacific/Kanton
    {    0, 2844,     970, 15, }, // Pacific/Kwajalein
    {    0, 4070,     985, 17, }, // Pacific/Marquesas
    {    0, 8945,    1002, 12, }, // Pacific/Midway
    {    0, 4187,    1014, 14, }, // Pacific/Norfolk
    {    0, 7117,    1028,  6, }, // Pacific/Noumea
    {    0, 7194,    1034, 16, }, // Pacific/Pitcairn
    {    0, 3115,    1050,  7, }, // Pacific/Pohnpei
    {    0, 7392,    1057, 11, }, // Pacific/Wake
    {    0, 7405,    1068, 15, }, // Pacific/Wallis
    {    1, 6807,    1083,  6, }, // Africa/Abidjan Abkhazian/Cyrillic/Georgia
    {    1, 6779,    1089,  5, }, // Africa/Accra
    {    1, 5078,    1094, 11, }, // Africa/Addis_Ababa
    {    1, 7420,    1105,  5, }, // Africa/Algiers
    {    1,   14,    1110,  6, }, // Africa/Asmara
    {    1,   44,    1116,  6, }, // Africa/Bamako
    {    1, 5276,    1122,  5, }, // Africa/Bangui
    {    1, 6765,    1127,  6, }, // Africa/Banjul
    {    1, 7435,    1133,  5, }, // Africa/Bissau
    {    1, 4976,    1138,  8, }, // Africa/Blantyre
    {    1, 5306,    1146,  9, }, // Africa/Brazzaville
    {    1, 4941,    1155,  9, }, // Africa/Bujumbura
    {    1, 2322,    1164,  4, }, // Africa/Cairo
    {    1, 4136,    1168, 10, }, // Africa/Casablanca
    {    1, 7449,    1178,  5, }, // Africa/Ceuta
    {    1, 6792,    1183,  7, }, // Africa/Conakry
    {    1, 6859,    1190,  5, }, // Africa/Dakar
    {    1, 5149,    1195, 12, }, // Africa/Dar_es_Salaam
    {    1, 5062,    1207,  6, }, // Africa/Djibouti
    {    1, 5262,    1213,  5, }, // Africa/Douala
    {    1, 5185,    1218,  7, }, // Africa/El_Aaiun
    {    1, 6872,    1225,  7, }, // Africa/Freetown
    {    1, 4925,    1232,  8, }, // Africa/Gaborone
    {    1, 5034,    1240,  6, }, // Africa/Harare
    {    1, 4498,    1246, 12, }, // Africa/Johannesburg
    {    1, 4518,    1258,  4, }, // Africa/Juba
    {    1, 5170,    1262,  7, }, // Africa/Kampala
    {    1, 4543,    1269,  6, }, // Africa/Khartoum
    {    1, 4992,    1275,  6, }, // Africa/Kigali
    {    1, 5325,    1281,  7, }, // Africa/Kinshasa
    {    1, 4763,    1288,  5, }, // Africa/Lagos
    {    1, 5355,    1293,  8, }, // Africa/Libreville
    {    1, 6888,    1301,  4, }, // Africa/Lome
    {    1, 5230,    1305,  6, }, // Africa/Luanda
    {    1, 4958,    1311,  9, }, // Africa/Lubumbashi
    {    1, 5020,    1320,  6, }, // Africa/Lusaka
    {    1, 5341,    1326,  6, }, // Africa/Malabo
    {    1, 5006,    1332,  6, }, // Africa/Maputo
    {    1, 5216,    1338,  6, }, // Africa/Maseru
    {    1, 5201,    1344,  7, }, // Africa/Mbabane
    {    1, 5132,    1351,  8, }, // Africa/Mogadishu
    {    1, 7053,    1359,  8, }, // Africa/Monrovia
    {    1, 3872,    1367,  7, }, // Africa/Nairobi
    {    1, 5290,    1374,  7, }, // Africa/Ndjamena
    {    1, 5373,    1381,  6, }, // Africa/Niamey
    {    1, 6822,    1387,  7, }, // Africa/Nouakchott
    {    1, 6746,    1394,  8, }, // Africa/Ouagadougou
    {    1, 5244,    1402, 10, }, // Africa/Porto-Novo
    {    1, 4454,    1412,  8, }, // Africa/Sao_Tome
    {    1, 2868,    1420,  7, }, // Africa/Tripoli
    {    1, 6573,    1427,  5, }, // Africa/Tunis
    {    1, 4171,    1432,  7, }, // Africa/Windhoek
    {    1,  132,    1439,  4, }, // America/Adak
    {    1, 3365,    1443,  7, }, // America/Anchorage
    {    1, 5626,    1450,  7, }, // America/Anguilla
    {    1, 5643,    1457,  7, }, // America/Antigua
    {    1, 4573,    1464,  9, }, // America/Araguaina
    {    1,  166,    1473, 12, }, // America/Argentina/Buenos_Aires
    {    1,   91,    1485,  9, }, // America/Argentina/Catamarca
    {    1,  270,    1494,  7, }, // America/Argentina/Cordoba
    {    1,  441,    1501,  5, }, // America/Argentina/Jujuy
    {    1, 7462,    1506,  8, }, // America/Argentina/La_Rioja
    {    1,  565,    1514,  7, }, // America/Argentina/Mendoza
    {    1, 7489,    1521, 11, }, // America/Argentina/Rio_Gallegos
    {    1, 7520,    1532,  5, }, // America/Argentina/Salta
    {    1, 7544,    1537,  8, }, // America/Argentina/San_Juan
    {    1, 5599,    1545,  8, }, // America/Argentina/San_Luis
    {    1, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {    1, 7597,    1560,  6, }, // America/Argentina/Ushuaia
    {    1, 5659,    1566,  5, }, // America/Aruba
    {    1, 4271,    1571,  7, }, // America/Asuncion
    {    1,  237,    1578, 12, }, // America/Atikokan
    {    1, 3698,    1590,  4, }, // America/Bahia
    {    1, 7623,    1594, 16, }, // America/Bahia_Banderas
    {    1, 5673,    1610,  8, }, // America/Barbados
    {    1, 7646,    1618,  5, }, // America/Belem
    {    1, 5426,    1623,  5, }, // America/Belize
    {    1, 7660,    1628, 12, }, // America/Blanc-Sablon
    {    1, 7681,    1640,  9, }, // America/Boa_Vista
    {    1, 4380,    1649,  6, }, // America/Bogota
    {    1, 7699,    1655,  5, }, // America/Boise
    {    1, 7713,    1660, 12, }, // America/Cambridge_Bay
    {    1, 7735,    1672, 12, }, // America/Campo_Grande
    {    1, 3887,    1684,  6, }, // America/Cancun
    {    1, 4713,    1690,  7, }, // America/Caracas
    {    1, 4364,    1697,  7, }, // America/Cayenne
    {    1, 5515,    1704, 22, }, // America/Cayman
    {    1, 2262,    1726,  6, }, // America/Chicago
    {    1, 7756,    1732,  6, }, // America/Chihuahua
    {    1, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    1, 5441,    1738, 10, }, // America/Costa_Rica
    {    1, 7814,    1748,  7, }, // America/Creston
    {    1, 3810,    1755,  6, }, // America/Cuiaba
    {    1, 5742,    1761,  8, }, // America/Curacao
    {    1, 7830,    1769, 12, }, // America/Danmarkshavn
    {    1, 7851,    1781,  6, }, // America/Dawson
    {    1, 7866,    1787, 11, }, // America/Dawson_Creek
    {    1,  805,    1798,  6, }, // America/Denver
    {    1, 3484,    1804,  7, }, // America/Detroit
    {    1, 5758,    1811,  8, }, // America/Dominica
    {    1,  893,    1819,  8, }, // America/Edmonton
    {    1, 7887,    1827,  8, }, // America/Eirunepe
    {    1, 5460,    1835,  8, }, // America/El_Salvador
    {    1, 7904,    1843, 11, }, // America/Fort_Nelson
    {    1, 7924,    1854,  9, }, // America/Fortaleza
    {    1, 7942,    1863,  9, }, // America/Glace_Bay
    {    1, 6900,    1872,  7, }, // America/Goose_Bay
    {    1, 4631,    1879, 10, }, // America/Grand_Turk
    {    1, 5789,    1889,  7, }, // America/Grenada
    {    1, 5805,    1896,  9, }, // America/Guadeloupe
    {    1, 3779,    1905,  9, }, // America/Guatemala
    {    1, 4860,    1914,  8, }, // America/Guayaquil
    {    1, 6951,    1922,  6, }, // America/Guyana
    {    1, 1941,    1928,  8, }, // America/Halifax
    {    1, 2283,    1936,  6, }, // America/Havana
    {    1, 7960,    1942,  8, }, // America/Hermosillo
    {    1,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {    1,  481,    1962, 13, }, // America/Indiana/Knox
    {    1, 7979,    1975, 16, }, // America/Indiana/Marengo
    {    1, 8003,    1991, 19, }, // America/Indiana/Petersburg
    {    1, 8030,    2010,  9, }, // America/Indiana/Tell_City
    {    1, 8056,    2019, 14, }, // America/Indiana/Vevay
    {    1, 8078,    2033,  9, }, // America/Indiana/Vincennes
    {    1, 8104,    2042,  7, }, // America/Indiana/Winamac
    {    1, 8128,    2049,  6, }, // America/Inuvik
    {    1,  660,    2055,  7, }, // America/Iqaluit
    {    1, 2801,    2062,  7, }, // America/Jamaica
    {    1, 5399,    2069,  4, }, // America/Juneau
    {    1,  521,    2073,  8, }, // America/Kentucky/Louisville
    {    1, 8143,    2081, 20, }, // America/Kentucky/Monticello
    {    1, 5723,    2101, 10, }, // America/Kralendijk
    {    1, 4395,    2111,  6, }, // America/La_Paz
    {    1, 7169,    2117,  4, }, // America/Lima
    {    1, 3258,    2121, 11, }, // America/Los_Angeles
    {    1, 5951,    2132, 18, }, // America/Lower_Princes
    {    1, 8171,    2150,  6, }, // America/Maceio
    {    1, 8186,    2156,  7, }, // America/Managua
    {    1, 1910,    2163,  6, }, // America/Manaus
    {    1, 5916,    2169,  6, }, // America/Marigot
    {    1, 5824,    2175,  9, }, // America/Martinique
    {    1, 8202,    2184,  9, }, // America/Matamoros
    {    1, 2919,    2193,  8, }, // America/Mazatlan
    {    1, 8220,    2201,  8, }, // America/Menominee
    {    1, 8238,    2209,  6, }, // America/Merida
    {    1, 8253,    2215, 10, }, // America/Metlakatla
    {    1, 2951,    2225,  6, }, // America/Mexico_City
    {    1, 4410,    2231,  7, }, // America/Miquelon
    {    1, 8272,    2238,  7, }, // America/Moncton
    {    1, 8288,    2245,  9, }, // America/Monterrey
    {    1, 4117,    2254, 10, }, // America/Montevideo
    {    1, 5843,    2264, 10, }, // America/Montserrat
    {    1, 5500,    2274,  6, }, // America/Nassau
    {    1, 2381,    2280,  8, }, // America/New_York
    {    1, 8306,    2288,  3, }, // America/Nome
    {    1, 1852,    2291,  7, }, // America/Noronha
    {    1, 8319,    2298, 22, }, // America/North_Dakota/Beulah
    {    1, 8347,    2320, 22, }, // America/North_Dakota/Center
    {    1, 8375,    2342, 27, }, // America/North_Dakota/New_Salem
    {    1,  393,    2369,  4, }, // America/Nuuk
    {    1, 8406,    2373,  7, }, // America/Ojinaga
    {    1, 2358,    2380,  6, }, // America/Panama
    {    1, 6192,    2386, 10, }, // America/Paramaribo
    {    1, 2975,    2396,  6, }, // America/Phoenix
    {    1, 3964,    2402, 12, }, // America/Port-au-Prince
    {    1, 5973,    2414, 13, }, // America/Port_of_Spain
    {    1, 8422,    2427, 11, }, // America/Porto_Velho
    {    1, 5862,    2438, 11, }, // America/Puerto_Rico
    {    1, 4049,    2449, 12, }, // America/Punta_Arenas
    {    1, 8442,    2461, 12, }, // America/Rankin_Inlet
    {    1, 8463,    2473,  6, }, // America/Recife
    {    1, 1997,    2479,  7, }, // America/Regina
    {    1, 8478,    2486,  8, }, // America/Resolute
    {    1,  695,    2494, 10, }, // America/Rio_Branco
    {    1, 8495,    2504,  8, }, // America/Santarem
    {    1, 2203,    2512,  8, }, // America/Santiago
    {    1, 6130,    2520, 13, }, // America/Santo_Domingo
    {    1, 1880,    2533,  9, }, // America/Sao_Paulo
    {    1, 6918,    2542, 11, }, // America/Scoresbysund
    {    1, 8512,    2553,  5, }, // America/Sitka
    {    1, 8526,    2558, 13, }, // America/St_Barthelemy
    {    1, 2063,    2571,  9, }, // America/St_Johns
    {    1, 5882,    2580,  9, }, // America/St_Kitts
    {    1, 5899,    2589, 11, }, // America/St_Lucia
    {    1,  855,    2600, 10, }, // America/St_Thomas
    {    1, 5932,    2610, 12, }, // America/St_Vincent
    {    1, 8548,    2622, 13, }, // America/Swift_Current
    {    1, 5480,    2635, 11, }, // America/Tegucigalpa
    {    1, 5775,    2646,  4, }, // America/Thule
    {    1,  313,    2650,  7, }, // America/Tijuana
    {    1,  608,    2657,  7, }, // America/Toronto
    {    1, 5707,    2664,  7, }, // America/Tortola
    {    1, 2095,    2671,  8, }, // America/Vancouver
    {    1, 2146,    2679,  8, }, // America/Whitehorse
    {    1,  734,    2687,  8, }, // America/Winnipeg
    {    1, 8570,    2695,  7, }, // America/Yakutat
    {    1, 6020,    2702,  5, }, // Antarctica/Casey
    {    1, 6113,    2707,  6, }, // Antarctica/Davis
    {    1, 6152,    2713, 15, }, // Antarctica/DumontDUrville
    {    1, 8586,    2728,  8, }, // Antarctica/Macquarie
    {    1, 7085,    2736,  6, }, // Antarctica/Mawson
    {    1,  932,    2742,  9, }, // Antarctica/McMurdo
    {    1, 8607,    2751,  6, }, // Antarctica/Palmer
    {    1, 7226,    2757,  6, }, // Antarctica/Rothera
    {    1, 7295,    2763,  5, }, // Antarctica/Syowa
    {    1, 8625,    2768,  5, }, // Antarctica/Troll
    {    1, 7374,    2773, 10, }, // Antarctica/Vostok
    {    1, 1431,    2783,  6, }, // Arctic/Longyearbyen
    {    1, 5589,    2789,  4, }, // Asia/Aden
    {    1, 5414,    2793,  6, }, // Asia/Almaty
    {    1, 3987,    2799,  5, }, // Asia/Amman
    {    1, 5530,    2804,  6, }, // Asia/Anadyr
    {    1, 5542,    2810,  5, }, // Asia/Aqtau
    {    1, 5387,    2815,  6, }, // Asia/Aqtobe
    {    1,  966,    2821,  7, }, // Asia/Ashgabat
    {    1, 8642,    2828,  6, }, // Asia/Atyrau
    {    1, 3626,    2834,  6, }, // Asia/Baghdad
    {    1, 5553,    2840,  7, }, // Asia/Bahrain
    {    1, 3672,    2847,  4, }, // Asia/Baku
    {    1, 4485,    2851,  7, }, // Asia/Bangkok
    {    1, 3590,    2858,  7, }, // Asia/Barnaul
    {    1, 4105,    2865,  6, }, // Asia/Beirut
    {    1, 3797,    2871,  6, }, // Asia/Bishkek
    {    1, 6008,    2877,  6, }, // Asia/Brunei
    {    1, 4620,    2883,  4, }, // Asia/Chita
    {    1, 4530,    2887,  7, }, // Asia/Colombo
    {    1, 4559,    2894,  6, }, // Asia/Damascus
    {    1, 1095,    2900,  5, }, // Asia/Dhaka
    {    1, 6211,    2905,  4, }, // Asia/Dili
    {    1, 3615,    2909,  5, }, // Asia/Dubai
    {    1, 6178,    2914,  7, }, // Asia/Dushanbe
    {    1, 8654,    2921,  9, }, // Asia/Famagusta
    {    1, 8669,    2930,  4, }, // Asia/Gaza
    {    1, 4814,    2934,  6, }, // Asia/Hebron
    {    1, 1261,    2940,  7, }, // Asia/Ho_Chi_Minh
    {    1, 2706,    2947,  7, }, // Asia/Hong_Kong
    {    1, 4790,    2954,  4, }, // Asia/Hovd
    {    1, 4203,    2958,  7, }, // Asia/Irkutsk
    {    1, 7025,    2965,  7, }, // Asia/Jakarta
    {    1, 7011,    2972,  8, }, // Asia/Jayapura
    {    1, 1292,    2980,  9, }, // Asia/Jerusalem
    {    1, 3579,    2989,  5, }, // Asia/Kabul
    {    1, 4335,    2994, 25, }, // Asia/Kamchatka
    {    1, 4258,    3019,  6, }, // Asia/Karachi
    {    1, 1187,    3025,  8, }, // Asia/Kathmandu
    {    1, 8679,    3033,  7, }, // Asia/Khandyga
    {    1,  994,    3040,  8, }, // Asia/Kolkata
    {    1, 4216,    3048, 11, }, // Asia/Krasnoyarsk
    {    1, 4878,    3059, 12, }, // Asia/Kuala_Lumpur
    {    1, 5995,    3071,  6, }, // Asia/Kuching
    {    1, 5566,    3077,  6, }, // Asia/Kuwait
    {    1, 1213,    3083,  5, }, // Asia/Macau
    {    1, 4036,    3088,  7, }, // Asia/Magadan
    {    1, 1351,    3095,  7, }, // Asia/Makassar
    {    1, 7182,    3102,  6, }, // Asia/Manila
    {    1, 6939,    3108,  6, }, // Asia/Muscat
    {    1, 2556,    3114,  7, }, // Asia/Nicosia
    {    1, 8693,    3121, 11, }, // Asia/Novokuznetsk
    {    1, 4154,    3132, 11, }, // Asia/Novosibirsk
    {    1, 4248,    3143,  4, }, // Asia/Omsk
    {    1, 7145,    3147,  6, }, // Asia/Oral
    {    1, 6980,    3153,  7, }, // Asia/Phnom_Penh
    {    1, 8711,    3160,  9, }, // Asia/Pontianak
    {    1, 4233,    3169,  7, }, // Asia/Pyongyang
    {    1, 5578,    3176,  5, }, // Asia/Qatar
    {    1, 8726,    3181,  8, }, // Asia/Qostanay
    {    1, 4288,    3189,  9, }, // Asia/Qyzylorda
    {    1, 3603,    3198,  7, }, // Asia/Riyadh
    {    1, 4427,    3205, 13, }, // Asia/Sakhalin
    {    1, 7245,    3218,  9, }, // Asia/Samarkand
    {    1, 3298,    3227,  4, }, // Asia/Seoul
    {    1, 1055,    3231,  6, }, // Asia/Shanghai
    {    1, 3319,    3237,  8, }, // Asia/Singapore
    {    1, 4316,    3245, 13, }, // Asia/Srednekolymsk
    {    1, 3282,    3258,  6, }, // Asia/Taipei
    {    1, 4800,    3264,  7, }, // Asia/Tashkent
    {    1, 3934,    3271,  4, }, // Asia/Tbilisi
    {    1, 2774,    3275,  7, }, // Asia/Tehran
    {    1, 1319,    3282,  7, }, // Asia/Thimphu
    {    1, 2823,    3289,  5, }, // Asia/Tokyo
    {    1, 4591,    3294,  5, }, // Asia/Tomsk
    {    1, 1023,    3299, 10, }, // Asia/Ulaanbaatar
    {    1, 1161,    3309,  6, }, // Asia/Urumqi
    {    1, 8740,    3315,  8, }, // Asia/Ust-Nera
    {    1, 6996,    3323,  7, }, // Asia/Vientiane
    {    1, 4729,    3330, 11, }, // Asia/Vladivostok
    {    1, 4847,    3341,  7, }, // Asia/Yakutsk
    {    1, 1237,    3348,  6, }, // Asia/Yangon
    {    1, 3902,    3354, 12, }, // Asia/Yekaterinburg
    {    1, 3766,    3366,  6, }, // Asia/Yerevan
    {    1, 3682,    3372, 16, }, // Atlantic/Azores
    {    1, 5690,    3388, 18, }, // Atlantic/Bermuda
    {    1, 6647,    3406, 17, }, // Atlantic/Canary
    {    1, 3746,    3423, 10, }, // Atlantic/Cape_Verde
    {    1, 1397,    3433, 17, }, // Atlantic/Faroe
    {    1, 8754,    3450,  7, }, // Atlantic/Madeira
    {    1, 2750,    3457,  9, }, // Atlantic/Reykjavik
    {    1, 7272,    3466, 16, }, // Atlantic/South_Georgia
    {    1, 6840,    3482, 26, }, // Atlantic/St_Helena
    {    1, 6663,    3508,  6, }, // Atlantic/Stanley
    {    1, 1672,    3514,  8, }, // Australia/Adelaide
    {    1, 1637,    3522,  7, }, // Australia/Brisbane
    {    1, 1801,    3529, 11, }, // Australia/Broken_Hill
    {    1, 1585,    3540,  6, }, // Australia/Darwin
    {    1, 3656,    3546,  5, }, // Australia/Eucla
    {    1, 1518,    3551,  6, }, // Australia/Hobart
    {    1, 8771,    3557,  8, }, // Australia/Lindeman
    {    1, 1549,    3565,  8, }, // Australia/Lord_Howe
    {    1, 1729,    3573,  7, }, // Australia/Melbourne
    {    1, 1764,    3580,  4, }, // Australia/Perth
    {    1, 1465,    3584,  6, }, // Australia/Sydney
    {    1, 6460,    3590,  9, }, // Europe/Amsterdam
    {    1, 6235,    3599,  7, }, // Europe/Andorra
    {    1, 3639,    3606,  8, }, // Europe/Astrakhan
    {    1, 2302,    3614,  4, }, // Europe/Athens
    {    1, 6355,    3618,  7, }, // Europe/Belgrade
    {    1, 4776,    3625,  6, }, // Europe/Berlin
    {    1, 6507,    3631, 10, }, // Europe/Bratislava
    {    1, 2169,    3641,  8, }, // Europe/Brussels
    {    1, 3947,    3649,  8, }, // Europe/Bucharest
    {    1, 3825,    3657,  8, }, // Europe/Budapest
    {    1, 8790,    3665, 23, }, // Europe/Busingen
    {    1, 2585,    3688,  7, }, // Europe/Chisinau
    {    1, 6308,    3695, 10, }, // Europe/Copenhagen
    {    1, 2340,    3705,  6, }, // Europe/Dublin
    {    1, 6326,    3711,  9, }, // Europe/Gibraltar
    {    1, 8806,    3720,  6, }, // Europe/Guernsey
    {    1, 6631,    3726,  8, }, // Europe/Helsinki
    {    1, 8822,    3734,  9, }, // Europe/Isle_of_Man
    {    1, 1132,    3743,  7, }, // Europe/Istanbul
    {    1, 8841,    3750,  5, }, // Europe/Jersey
    {    1, 3998,    3755, 11, }, // Europe/Kaliningrad
    {    1, 8855,    3766,  5, }, // Europe/Kirov
    {    1, 2529,    3771,  4, }, // Europe/Kyiv
    {    1, 3232,    3775,  8, }, // Europe/Lisbon
    {    1, 6525,    3783,  9, }, // Europe/Ljubljana
    {    1, 2503,    3792,  6, }, // Europe/London
    {    1, 6384,    3798, 11, }, // Europe/Luxembourg
    {    1, 4911,    3809,  6, }, // Europe/Madrid
    {    1, 6416,    3815,  5, }, // Europe/Malta
    {    1, 6601,    3820,  9, }, // Europe/Mariehamn
    {    1, 3712,    3829,  5, }, // Europe/Minsk
    {    1, 6429,    3834,  6, }, // Europe/Monaco
    {    1, 3556,    3840,  6, }, // Europe/Moscow
    {    1, 6477,    3846,  4, }, // Europe/Oslo
    {    1, 4303,    3850,  5, }, // Europe/Paris
    {    1, 6443,    3855,  9, }, // Europe/Podgorica
    {    1, 6294,    3864,  5, }, // Europe/Prague
    {    1, 8868,    3869,  4, }, // Europe/Riga
    {    1, 6343,    3873,  3, }, // Europe/Rome
    {    1, 4350,    3876,  6, }, // Europe/Samara
    {    1, 6489,    3882, 10, }, // Europe/San_Marino
    {    1, 6264,    3892,  7, }, // Europe/Sarajevo
    {    1, 4470,    3899,  7, }, // Europe/Saratov
    {    1, 8880,    3906, 10, }, // Europe/Simferopol
    {    1, 6402,    3916,  5, }, // Europe/Skopje
    {    1, 6618,    3921,  5, }, // Europe/Sofia
    {    1, 6542,    3926,  8, }, // Europe/Stockholm
    {    1, 8898,    3934,  6, }, // Europe/Tallinn
    {    1, 6221,    3940,  6, }, // Europe/Tirane
    {    1, 8913,    3946,  9, }, // Europe/Ulyanovsk
    {    1, 6371,    3955,  5, }, // Europe/Vaduz
    {    1, 6586,    3960,  7, }, // Europe/Vatican
    {    1, 6250,    3967,  4, }, // Europe/Vienna
    {    1, 8930,    3971,  7, }, // Europe/Vilnius
    {    1, 4746,    3978,  9, }, // Europe/Volgograd
    {    1, 3209,    3987,  7, }, // Europe/Warsaw
    {    1, 6280,    3994,  6, }, // Europe/Zagreb
    {    1, 6559,    4000,  6, }, // Europe/Zurich
    {    1, 5097,    4006, 12, }, // Indian/Antananarivo
    {    1, 6966,    4018,  5, }, // Indian/Chagos
    {    1, 6065,    4023, 12, }, // Indian/Christmas
    {    1, 6082,    4035, 17, }, // Indian/Cocos
    {    1, 5048,    4052,  5, }, // Indian/Comoro
    {    1, 6680,    4057,  8, }, // Indian/Kerguelen
    {    1, 7260,    4065,  3, }, // Indian/Mahe
    {    1, 7069,    4068,  6, }, // Indian/Maldives
    {    1, 4088,    4074,  7, }, // Indian/Mauritius
    {    1, 5117,    4081,  7, }, // Indian/Mayotte
    {    1, 7211,    4088,  7, }, // Indian/Reunion
    {    1, 4441,    4095,  4, }, // Pacific/Apia
    {    1, 3009,    4099,  6, }, // Pacific/Auckland
    {    1, 3725,    4105,  8, }, // Pacific/Bougainville
    {    1, 3034,    4113,  5, }, // Pacific/Chatham
    {    1, 3176,    4118,  4, }, // Pacific/Chuuk
    {    1, 2239,    4122, 11, }, // Pacific/Easter
    {    1, 7360,    4133,  5, }, // Pacific/Efate
    {    1, 7327,    4138,  7, }, // Pacific/Fakaofo
    {    1, 3921,    4145,  4, }, // Pacific/Fiji
    {    1, 7343,    4149,  8, }, // Pacific/Funafuti
    {    1, 6697,    4157, 21, }, // Pacific/Galapagos
    {    1, 6715,    4178, 14, }, // Pacific/Gambier
    {    1, 3841,    4192, 11, }, // Pacific/Guadalcanal
    {    1, 6037,    4203,  4, }, // Pacific/Guam
    {    1, 3068,    4207,  6, }, // Pacific/Kanton
    {    1, 4017,    4213, 10, }, // Pacific/Kiritimati
    {    1, 7038,    4223,  6, }, // Pacific/Kosrae
    {    1, 2844,    4229,  9, }, // Pacific/Kwajalein
    {    1, 4896,    4238,  6, }, // Pacific/Majuro
    {    1, 4070,    4244, 18, }, // Pacific/Marquesas
    {    1, 8945,    4262, 15, }, // Pacific/Midway
    {    1, 7103,    4277,  5, }, // Pacific/Nauru
    {    1, 7132,    4282,  4, }, // Pacific/Niue
    {    1, 4187,    4286,  7, }, // Pacific/Norfolk
    {    1, 7117,    4293,  5, }, // Pacific/Noumea
    {    1, 3145,    4298,  9, }, // Pacific/Pago_Pago
    {    1, 7155,    4307,  5, }, // Pacific/Palau
    {    1, 7194,    4312,  7, }, // Pacific/Pitcairn
    {    1, 3115,    4319,  6, }, // Pacific/Pohnpei
    {    1, 4826,    4325, 11, }, // Pacific/Port_Moresby
    {    1, 6095,    4336,  9, }, // Pacific/Rarotonga
    {    1, 6050,    4345,  6, }, // Pacific/Saipan
    {    1, 7312,    4351,  5, }, // Pacific/Tahiti
    {    1, 6731,    4356,  6, }, // Pacific/Tarawa
    {    1, 4602,    4362,  9, }, // Pacific/Tongatapu
    {    1, 7392,    4371,  4, }, // Pacific/Wake
    {    1, 7405,    4375,  6, }, // Pacific/Wallis
    {    2,   14,       0,  6, }, // Africa/Asmara Afar/Latin/Ethiopia
    {    2, 5185,       6,  8, }, // Africa/El_Aaiun
    {    2, 6888,      14,  4, }, // Africa/Lome
    {    2, 5290,      18,  9, }, // Africa/Ndjamena
    {    2, 4454,      27,  8, }, // Africa/Sao_Tome
    {    2, 4573,      35,  9, }, // America/Araguaina
    {    2,  270,      44,  7, }, // America/Argentina/Cordoba
    {    2, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {    2, 7571,      63,  7, }, // America/Argentina/Tucuman
    {    2, 4271,      70,  8, }, // America/Asuncion
    {    2,  237,      78,  8, }, // America/Atikokan
    {    2, 7623,      86, 17, }, // America/Bahia_Banderas
    {    2, 7646,     103,  5, }, // America/Belem
    {    2, 4380,     108,  6, }, // America/Bogota
    {    2, 3887,     114,  6, }, // America/Cancun
    {    2, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    2, 3810,     133,  6, }, // America/Cuiaba
    {    2, 5742,     139,  7, }, // America/Curacao
    {    2, 7887,     146,  8, }, // America/Eirunepe
    {    2,  481,     154, 13, }, // America/Indiana/Knox
    {    2, 7979,     167, 16, }, // America/Indiana/Marengo
    {    2, 8003,     183, 19, }, // America/Indiana/Petersburg
    {    2, 8030,     202, 18, }, // America/Indiana/Tell_City
    {    2, 8056,     220, 14, }, // America/Indiana/Vevay
    {    2, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    2, 8104,     252, 16, }, // America/Indiana/Winamac
    {    2, 8143,     268, 20, }, // America/Kentucky/Monticello
    {    2, 5951,     288, 22, }, // America/Lower_Princes
    {    2, 8171,     310,  6, }, // America/Maceio
    {    2, 2919,     316,  8, }, // America/Mazatlan
    {    2, 8238,     324,  6, }, // America/Merida
    {    2, 2951,    4381, 16, }, // America/Mexico_City
    {    2, 4410,     341, 12, }, // America/Miquelon
    {    2, 1852,     353, 19, }, // America/Noronha
    {    2, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {    2, 8347,     392, 20, }, // America/North_Dakota/Center
    {    2, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {    2,  393,     435,  4, }, // America/Nuuk
    {    2, 8495,     439,  8, }, // America/Santarem
    {    2, 1880,     447,  9, }, // America/Sao_Paulo
    {    2, 6918,     456, 16, }, // America/Scoresbysund
    {    2, 8526,     472, 14, }, // America/St_Barthelemy
    {    2, 2063,     486, 10, }, // America/St_Johns
    {    2, 5882,     496,  9, }, // America/St_Kitts
    {    2, 5899,     505,  9, }, // America/St_Lucia
    {    2,  855,     514, 10, }, // America/St_Thomas
    {    2, 5932,     524, 11, }, // America/St_Vincent
    {    2, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {    2, 7295,     643,  5, }, // Antarctica/Syowa
    {    2, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {    2, 4790,     704,  5, }, // Asia/Hovd
    {    2, 1187,     709,  9, }, // Asia/Kathmandu
    {    2,  994,     718,  7, }, // Asia/Kolkata
    {    2, 1213,     725,  5, }, // Asia/Macau
    {    2, 1161,     747,  6, }, // Asia/Urumqi
    {    2, 1237,     753,  6, }, // Asia/Yangon
    {    2, 6647,    4413,  8, }, // Atlantic/Canary
    {    2, 1397,     767,  5, }, // Atlantic/Faroe
    {    2, 6840,     773, 10, }, // Atlantic/St_Helena
    {    2, 8790,     799,  8, }, // Europe/Busingen
    {    2, 2585,     807,  8, }, // Europe/Chisinau
    {    2, 2529,     815,  4, }, // Europe/Kyiv
    {    2, 6221,     819,  6, }, // Europe/Tirane
    {    2, 5048,    4421,  7, }, // Indian/Comoro
    {    2, 7260,     896,  4, }, // Indian/Mahe
    {    2, 7211,     900,  7, }, // Indian/Reunion
    {    2, 3176,     922,  5, }, // Pacific/Chuuk
    {    2, 6697,     940,  9, }, // Pacific/Galapagos
    {    2, 3068,     957,  6, }, // Pacific/Kanton
    {    2, 7117,    1028,  6, }, // Pacific/Noumea
    {    2, 3115,    1050,  7, }, // Pacific/Pohnpei
    {    2, 7405,    1068, 15, }, // Pacific/Wallis
    {    5, 5078,    4428, 11, }, // Africa/Addis_Ababa Afrikaans/Latin/South Africa
    {    5,   14,       0,  6, }, // Africa/Asmara
    {    5, 2322,    4439,  5, }, // Africa/Cairo
    {    5, 5062,    4444,  8, }, // Africa/Djibouti
    {    5, 5185,       6,  8, }, // Africa/El_Aaiun
    {    5, 4543,    4452,  7, }, // Africa/Khartoum
    {    5, 6888,      14,  4, }, // Africa/Lome
    {    5, 5132,    4459, 10, }, // Africa/Mogadishu
    {    5, 5290,      18,  9, }, // Africa/Ndjamena
    {    5, 4454,      27,  8, }, // Africa/Sao_Tome
    {    5, 4573,      35,  9, }, // America/Araguaina
    {    5,  270,      44,  7, }, // America/Argentina/Cordoba
    {    5, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {    5, 7571,      63,  7, }, // America/Argentina/Tucuman
    {    5, 4271,      70,  8, }, // America/Asuncion
    {    5,  237,      78,  8, }, // America/Atikokan
    {    5, 7623,      86, 17, }, // America/Bahia_Banderas
    {    5, 7646,     103,  5, }, // America/Belem
    {    5, 4380,     108,  6, }, // America/Bogota
    {    5, 7713,    4469, 13, }, // America/Cambridge_Bay
    {    5, 3887,     114,  6, }, // America/Cancun
    {    5, 5515,    4482,  7, }, // America/Cayman
    {    5, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    5, 3810,     133,  6, }, // America/Cuiaba
    {    5, 5742,     139,  7, }, // America/Curacao
    {    5, 7887,     146,  8, }, // America/Eirunepe
    {    5, 7942,    4489,  9, }, // America/Glace_Bay
    {    5, 6900,    4498,  9, }, // America/Goose_Bay
    {    5,  481,     154, 13, }, // America/Indiana/Knox
    {    5, 7979,     167, 16, }, // America/Indiana/Marengo
    {    5, 8003,     183, 19, }, // America/Indiana/Petersburg
    {    5, 8030,     202, 18, }, // America/Indiana/Tell_City
    {    5, 8056,     220, 14, }, // America/Indiana/Vevay
    {    5, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    5, 8104,     252, 16, }, // America/Indiana/Winamac
    {    5, 2801,    4507,  7, }, // America/Jamaica
    {    5, 8143,     268, 20, }, // America/Kentucky/Monticello
    {    5, 5951,     288, 22, }, // America/Lower_Princes
    {    5, 8171,     310,  6, }, // America/Maceio
    {    5, 2919,     316,  8, }, // America/Mazatlan
    {    5, 8238,     324,  6, }, // America/Merida
    {    5, 2951,    4514, 11, }, // America/Mexico_City
    {    5, 4410,     341, 12, }, // America/Miquelon
    {    5, 1852,     353, 19, }, // America/Noronha
    {    5, 8319,    4525, 20, }, // America/North_Dakota/Beulah
    {    5, 8347,    4545, 20, }, // America/North_Dakota/Center
    {    5, 8375,    4565, 23, }, // America/North_Dakota/New_Salem
    {    5,  393,     435,  4, }, // America/Nuuk
    {    5, 8495,     439,  8, }, // America/Santarem
    {    5, 1880,     447,  9, }, // America/Sao_Paulo
    {    5, 6918,     456, 16, }, // America/Scoresbysund
    {    5, 8526,    4588, 17, }, // America/St_Barthelemy
    {    5, 2063,    4605, 11, }, // America/St_Johns
    {    5, 5882,    4616, 10, }, // America/St_Kitts
    {    5, 5899,    4626, 10, }, // America/St_Lucia
    {    5,  855,    4636, 11, }, // America/St_Thomas
    {    5, 5932,    4647, 12, }, // America/St_Vincent
    {    5, 6020,    4659, 12, }, // Antarctica/Casey
    {    5, 6113,    4671, 12, }, // Antarctica/Davis
    {    5, 6152,    4683, 23, }, // Antarctica/DumontDUrville
    {    5, 7085,    4706, 13, }, // Antarctica/Mawson
    {    5,  932,    4719, 14, }, // Antarctica/McMurdo
    {    5, 7226,    4733, 23, }, // Antarctica/Rothera
    {    5, 7295,    4756, 12, }, // Antarctica/Syowa
    {    5, 8625,    4768, 12, }, // Antarctica/Troll
    {    5, 7374,    4780, 13, }, // Antarctica/Vostok
    {    5,  966,    4793,  9, }, // Asia/Ashgabat
    {    5, 3626,    4802,  6, }, // Asia/Baghdad
    {    5, 5553,    4808,  7, }, // Asia/Bahrain
    {    5, 3672,    4815,  5, }, // Asia/Baku
    {    5, 4105,    4820,  7, }, // Asia/Beirut
    {    5, 3797,    4827,  7, }, // Asia/Bishkek
    {    5, 6008,    4834,  7, }, // Asia/Brunei
    {    5, 4559,    4841,  8, }, // Asia/Damascus
    {    5, 3615,    4849,  6, }, // Asia/Dubai
    {    5, 1261,    4855, 16, }, // Asia/Ho_Chi_Minh
    {    5, 2706,    4871,  8, }, // Asia/Hong_Kong
    {    5, 4790,     704,  5, }, // Asia/Hovd
    {    5, 4203,    4879,  8, }, // Asia/Irkutsk
    {    5, 7025,    4887,  8, }, // Asia/Jakarta
    {    5, 3579,    4895,  6, }, // Asia/Kabul
    {    5, 4335,    4901, 10, }, // Asia/Kamchatka
    {    5, 4258,    4911,  8, }, // Asia/Karachi
    {    5, 1187,    4919,  9, }, // Asia/Kathmandu
    {    5,  994,     718,  7, }, // Asia/Kolkata
    {    5, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {    5, 4878,    4939, 15, }, // Asia/Kuala_Lumpur
    {    5, 5566,    4954,  7, }, // Asia/Kuwait
    {    5, 1213,    4961,  5, }, // Asia/Macau
    {    5, 6939,    4966,  6, }, // Asia/Muscat
    {    5, 5578,    4972,  5, }, // Asia/Qatar
    {    5, 8726,     730,  8, }, // Asia/Qostanay
    {    5, 3603,    4977,  5, }, // Asia/Riyadh
    {    5, 3298,    4982,  5, }, // Asia/Seoul
    {    5, 3319,    4987,  9, }, // Asia/Singapore
    {    5, 2823,    4996,  5, }, // Asia/Tokyo
    {    5, 1161,     747,  6, }, // Asia/Urumqi
    {    5, 4729,    5001, 11, }, // Asia/Vladivostok
    {    5, 4847,    5012,  8, }, // Asia/Yakutsk
    {    5, 1237,     753,  6, }, // Asia/Yangon
    {    5, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {    5, 3682,    5033,  5, }, // Atlantic/Azores
    {    5, 6647,    5038,  7, }, // Atlantic/Canary
    {    5, 3746,    5045, 10, }, // Atlantic/Cape_Verde
    {    5, 1397,     767,  5, }, // Atlantic/Faroe
    {    5, 7272,    5055, 12, }, // Atlantic/South_Georgia
    {    5, 6840,    5067, 11, }, // Atlantic/St_Helena
    {    5, 2302,    5078,  6, }, // Europe/Athens
    {    5, 4776,    5084,  6, }, // Europe/Berlin
    {    5, 2169,    5090,  7, }, // Europe/Brussels
    {    5, 3947,    5097,  9, }, // Europe/Bucharest
    {    5, 3825,    5106,  9, }, // Europe/Budapest
    {    5, 8790,     799,  8, }, // Europe/Busingen
    {    5, 2585,     807,  8, }, // Europe/Chisinau
    {    5, 6308,    5115, 10, }, // Europe/Copenhagen
    {    5, 8822,    5125, 10, }, // Europe/Isle_of_Man
    {    5, 2529,    5135,  4, }, // Europe/Kyiv
    {    5, 3232,    5139,  8, }, // Europe/Lisbon
    {    5, 2503,    5147,  6, }, // Europe/London
    {    5, 6384,    5153,  9, }, // Europe/Luxembourg
    {    5, 3556,    5162,  6, }, // Europe/Moscow
    {    5, 4303,    5168,  5, }, // Europe/Paris
    {    5, 6294,    5173,  5, }, // Europe/Prague
    {    5, 4470,    5178,  7, }, // Europe/Saratov
    {    5, 6221,     819,  6, }, // Europe/Tirane
    {    5, 6586,    5185, 12, }, // Europe/Vatican
    {    5, 6250,    5197,  4, }, // Europe/Vienna
    {    5, 4746,    5201,  9, }, // Europe/Volgograd
    {    5, 3209,    5210,  7, }, // Europe/Warsaw
    {    5, 6559,    5217,  6, }, // Europe/Zurich
    {    5, 6082,    5223,  5, }, // Indian/Cocos
    {    5, 5048,    4421,  6, }, // Indian/Comoro
    {    5, 7260,     896,  4, }, // Indian/Mahe
    {    5, 7069,    5228,  8, }, // Indian/Maldives
    {    5, 7211,     900,  7, }, // Indian/Reunion
    {    5, 3176,     922,  5, }, // Pacific/Chuuk
    {    5, 2239,    5236, 10, }, // Pacific/Easter
    {    5, 3921,    5246,  5, }, // Pacific/Fiji
    {    5, 6697,     940,  9, }, // Pacific/Galapagos
    {    5, 2725,    5251,  8, }, // Pacific/Honolulu
    {    5, 3068,    5259, 12, }, // Pacific/Kanton
    {    5, 2844,     970, 15, }, // Pacific/Kwajalein
    {    5, 4070,    5271, 17, }, // Pacific/Marquesas
    {    5, 7117,    1028,  6, }, // Pacific/Noumea
    {    5, 7194,    5288, 16, }, // Pacific/Pitcairn
    {    5, 3115,    1050,  7, }, // Pacific/Pohnpei
    {    5, 7392,    5304, 11, }, // Pacific/Wake
    {    5, 7405,    1068, 15, }, // Pacific/Wallis
    {    7,   14,       0,  6, }, // Africa/Asmara Aghem/Latin/Cameroon
    {    7, 5185,       6,  8, }, // Africa/El_Aaiun
    {    7, 6888,      14,  4, }, // Africa/Lome
    {    7, 5290,      18,  9, }, // Africa/Ndjamena
    {    7, 4454,      27,  8, }, // Africa/Sao_Tome
    {    7, 4573,      35,  9, }, // America/Araguaina
    {    7,  270,      44,  7, }, // America/Argentina/Cordoba
    {    7, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {    7, 7571,      63,  7, }, // America/Argentina/Tucuman
    {    7, 4271,      70,  8, }, // America/Asuncion
    {    7,  237,      78,  8, }, // America/Atikokan
    {    7, 7623,      86, 17, }, // America/Bahia_Banderas
    {    7, 7646,     103,  5, }, // America/Belem
    {    7, 4380,     108,  6, }, // America/Bogota
    {    7, 3887,     114,  6, }, // America/Cancun
    {    7, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    7, 3810,     133,  6, }, // America/Cuiaba
    {    7, 5742,     139,  7, }, // America/Curacao
    {    7, 7887,     146,  8, }, // America/Eirunepe
    {    7,  481,     154, 13, }, // America/Indiana/Knox
    {    7, 7979,     167, 16, }, // America/Indiana/Marengo
    {    7, 8003,     183, 19, }, // America/Indiana/Petersburg
    {    7, 8030,     202, 18, }, // America/Indiana/Tell_City
    {    7, 8056,     220, 14, }, // America/Indiana/Vevay
    {    7, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    7, 8104,     252, 16, }, // America/Indiana/Winamac
    {    7, 8143,     268, 20, }, // America/Kentucky/Monticello
    {    7, 5951,     288, 22, }, // America/Lower_Princes
    {    7, 8171,     310,  6, }, // America/Maceio
    {    7, 2919,     316,  8, }, // America/Mazatlan
    {    7, 8238,     324,  6, }, // America/Merida
    {    7, 2951,    4381, 16, }, // America/Mexico_City
    {    7, 4410,     341, 12, }, // America/Miquelon
    {    7, 1852,     353, 19, }, // America/Noronha
    {    7, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {    7, 8347,     392, 20, }, // America/North_Dakota/Center
    {    7, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {    7,  393,     435,  4, }, // America/Nuuk
    {    7, 8495,     439,  8, }, // America/Santarem
    {    7, 1880,     447,  9, }, // America/Sao_Paulo
    {    7, 6918,     456, 16, }, // America/Scoresbysund
    {    7, 8526,     472, 14, }, // America/St_Barthelemy
    {    7, 2063,     486, 10, }, // America/St_Johns
    {    7, 5882,     496,  9, }, // America/St_Kitts
    {    7, 5899,     505,  9, }, // America/St_Lucia
    {    7,  855,     514, 10, }, // America/St_Thomas
    {    7, 5932,     524, 11, }, // America/St_Vincent
    {    7, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {    7, 7295,     643,  5, }, // Antarctica/Syowa
    {    7, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {    7, 4790,     704,  5, }, // Asia/Hovd
    {    7, 1187,     709,  9, }, // Asia/Kathmandu
    {    7,  994,     718,  7, }, // Asia/Kolkata
    {    7, 1213,     725,  5, }, // Asia/Macau
    {    7, 1161,     747,  6, }, // Asia/Urumqi
    {    7, 1237,     753,  6, }, // Asia/Yangon
    {    7, 6647,    4413,  8, }, // Atlantic/Canary
    {    7, 1397,     767,  5, }, // Atlantic/Faroe
    {    7, 6840,     773, 10, }, // Atlantic/St_Helena
    {    7, 8790,     799,  8, }, // Europe/Busingen
    {    7, 2585,     807,  8, }, // Europe/Chisinau
    {    7, 2529,     815,  4, }, // Europe/Kyiv
    {    7, 6221,     819,  6, }, // Europe/Tirane
    {    7, 5048,    4421,  7, }, // Indian/Comoro
    {    7, 7260,     896,  4, }, // Indian/Mahe
    {    7, 7211,     900,  7, }, // Indian/Reunion
    {    7, 3176,     922,  5, }, // Pacific/Chuuk
    {    7, 6697,     940,  9, }, // Pacific/Galapagos
    {    7, 3068,     957,  6, }, // Pacific/Kanton
    {    7, 7117,    1028,  6, }, // Pacific/Noumea
    {    7, 3115,    1050,  7, }, // Pacific/Pohnpei
    {    7, 7405,    1068, 15, }, // Pacific/Wallis
    {    8, 6807,    5315,  7, }, // Africa/Abidjan Akan/Latin/Ghana
    {    8, 6779,    5322,  5, }, // Africa/Accra
    {    8, 7420,    5327,  7, }, // Africa/Algiers
    {    8,   14,       0,  6, }, // Africa/Asmara
    {    8, 6765,    5334,  7, }, // Africa/Banjul
    {    8, 7435,    5341,  5, }, // Africa/Bissau
    {    8, 4976,    5346,  7, }, // Africa/Blantyre
    {    8, 4941,    5353, 10, }, // Africa/Bujumbura
    {    8, 2322,    5363,  5, }, // Africa/Cairo
    {    8, 7449,    5368,  6, }, // Africa/Ceuta
    {    8, 6792,    5374,  7, }, // Africa/Conakry
    {    8, 6859,    5381,  5, }, // Africa/Dakar
    {    8, 5062,    5386,  8, }, // Africa/Djibouti
    {    8, 5185,       6,  8, }, // Africa/El_Aaiun
    {    8, 4518,    5394,  5, }, // Africa/Juba
    {    8, 5325,    5399, 10, }, // Africa/Kinshasa
    {    8, 4763,    5409,  5, }, // Africa/Lagos
    {    8, 6888,      14,  4, }, // Africa/Lome
    {    8, 5290,    5414,  8, }, // Africa/Ndjamena
    {    8, 6746,    5422,  8, }, // Africa/Ouagadougou
    {    8, 4454,      27,  8, }, // Africa/Sao_Tome
    {    8, 3365,    5430,  9, }, // America/Anchorage
    {    8, 5626,    5439,  7, }, // America/Anguilla
    {    8, 4573,      35,  9, }, // America/Araguaina
    {    8,   91,    5446,  9, }, // America/Argentina/Catamarca
    {    8,  270,    5455,  7, }, // America/Argentina/Cordoba
    {    8,  441,    5462,  7, }, // America/Argentina/Jujuy
    {    8, 7462,    5469,  9, }, // America/Argentina/La_Rioja
    {    8,  565,    5478,  7, }, // America/Argentina/Mendoza
    {    8, 7489,    5485, 12, }, // America/Argentina/Rio_Gallegos
    {    8, 7544,    5497,  9, }, // America/Argentina/San_Juan
    {    8, 7571,    5506,  7, }, // America/Argentina/Tucuman
    {    8, 4271,      70,  8, }, // America/Asuncion
    {    8,  237,      78,  8, }, // America/Atikokan
    {    8, 7623,      86, 17, }, // America/Bahia_Banderas
    {    8, 5673,    5513,  8, }, // America/Barbados
    {    8, 7646,    5521,  5, }, // America/Belem
    {    8, 5426,    5526,  6, }, // America/Belize
    {    8, 7660,    5532, 12, }, // America/Blanc-Sablon
    {    8, 4380,     108,  6, }, // America/Bogota
    {    8, 7699,    5544,  5, }, // America/Boise
    {    8, 7713,    5549, 13, }, // America/Cambridge_Bay
    {    8, 7735,    5562, 12, }, // America/Campo_Grande
    {    8, 3887,    5574,  6, }, // America/Cancun
    {    8, 4713,    5580,  7, }, // America/Caracas
    {    8, 4364,    5587,  7, }, // America/Cayenne
    {    8, 2262,    5594,  7, }, // America/Chicago
    {    8, 7756,    5601,  9, }, // America/Chihuahua
    {    8, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    8, 5441,    5610, 10, }, // America/Costa_Rica
    {    8, 7814,    5620,  7, }, // America/Creston
    {    8, 3810,    5627,  6, }, // America/Cuiaba
    {    8, 5742,    5633,  7, }, // America/Curacao
    {    8, 7851,    5640,  6, }, // America/Dawson
    {    8, 7866,    5646, 12, }, // America/Dawson_Creek
    {    8,  805,    5658,  5, }, // America/Denver
    {    8, 3484,    5663,  7, }, // America/Detroit
    {    8, 5758,    5670,  8, }, // America/Dominica
    {    8,  893,    5678,  8, }, // America/Edmonton
    {    8, 7887,     146,  8, }, // America/Eirunepe
    {    8, 5460,    5686, 11, }, // America/El_Salvador
    {    8, 7904,    5697, 10, }, // America/Fort_Nelson
    {    8, 7924,    5707,  9, }, // America/Fortaleza
    {    8, 6900,    5716,  8, }, // America/Goose_Bay
    {    8, 4631,    5724,  9, }, // America/Grand_Turk
    {    8, 5805,    5733,  9, }, // America/Guadeloupe
    {    8, 3779,    5742, 10, }, // America/Guatemala
    {    8, 4860,    5752,  9, }, // America/Guayaquil
    {    8, 6951,    5761,  6, }, // America/Guyana
    {    8, 7960,    5767,  8, }, // America/Hermosillo
    {    8,  348,    5775, 12, }, // America/Indiana/Indianapolis
    {    8,  481,     154, 13, }, // America/Indiana/Knox
    {    8, 7979,     167, 16, }, // America/Indiana/Marengo
    {    8, 8003,    5787, 19, }, // America/Indiana/Petersburg
    {    8, 8030,    5806, 18, }, // America/Indiana/Tell_City
    {    8, 8056,     220, 14, }, // America/Indiana/Vevay
    {    8, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    8, 8104,    5824, 16, }, // America/Indiana/Winamac
    {    8,  660,    5840,  7, }, // America/Iqaluit
    {    8, 2801,    5847,  7, }, // America/Jamaica
    {    8, 8143,    5854, 18, }, // America/Kentucky/Monticello
    {    8, 5723,    5872, 10, }, // America/Kralendijk
    {    8, 3258,    5882, 12, }, // America/Los_Angeles
    {    8, 5951,    5894, 16, }, // America/Lower_Princes
    {    8, 8171,    5910,  6, }, // America/Maceio
    {    8, 5916,    5916,  7, }, // America/Marigot
    {    8, 5824,    5923,  9, }, // America/Martinique
    {    8, 8202,    5932, 10, }, // America/Matamoros
    {    8, 2919,    5942,  8, }, // America/Mazatlan
    {    8, 8220,    5950,  9, }, // America/Menominee
    {    8, 8238,     324,  6, }, // America/Merida
    {    8, 8253,    5959, 10, }, // America/Metlakatla
    {    8, 2951,    5969, 12, }, // America/Mexico_City
    {    8, 4410,     341, 12, }, // America/Miquelon
    {    8, 8272,    5981,  7, }, // America/Moncton
    {    8, 8288,    5988,  8, }, // America/Monterrey
    {    8, 5843,    5996,  9, }, // America/Montserrat
    {    8, 2381,    6005,  7, }, // America/New_York
    {    8, 1852,     353, 19, }, // America/Noronha
    {    8, 8319,    6012, 17, }, // America/North_Dakota/Beulah
    {    8, 8347,    6029, 17, }, // America/North_Dakota/Center
    {    8, 8375,    6046, 21, }, // America/North_Dakota/New_Salem
    {    8,  393,     435,  4, }, // America/Nuuk
    {    8, 8406,    6067,  8, }, // America/Ojinaga
    {    8, 6192,    6075, 10, }, // America/Paramaribo
    {    8, 2975,    6085,  6, }, // America/Phoenix
    {    8, 5973,    6091, 11, }, // America/Port_of_Spain
    {    8, 8422,    6102, 11, }, // America/Porto_Velho
    {    8, 5862,    6113, 10, }, // America/Puerto_Rico
    {    8, 8463,    6123,  6, }, // America/Recife
    {    8, 1997,    6129,  7, }, // America/Regina
    {    8, 8478,    6136,  7, }, // America/Resolute
    {    8,  695,    6143, 10, }, // America/Rio_Branco
    {    8, 8495,     439,  8, }, // America/Santarem
    {    8, 1880,     447,  9, }, // America/Sao_Paulo
    {    8, 6918,    6153, 13, }, // America/Scoresbysund
    {    8, 8526,    6166, 13, }, // America/St_Barthelemy
    {    8, 2063,     486, 10, }, // America/St_Johns
    {    8, 5882,     496,  9, }, // America/St_Kitts
    {    8, 5899,     505,  9, }, // America/St_Lucia
    {    8,  855,     514, 10, }, // America/St_Thomas
    {    8, 5932,     524, 11, }, // America/St_Vincent
    {    8, 8548,    6179, 12, }, // America/Swift_Current
    {    8, 5480,    6191, 11, }, // America/Tegucigalpa
    {    8,  313,    6202,  8, }, // America/Tijuana
    {    8, 5707,    6210,  7, }, // America/Tortola
    {    8,  734,    6217,  7, }, // America/Winnipeg
    {    8, 6020,    6224,  4, }, // Antarctica/Casey
    {    8, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {    8, 8586,    6228,  7, }, // Antarctica/Macquarie
    {    8, 7085,    6235,  6, }, // Antarctica/Mawson
    {    8, 8607,    6241,  5, }, // Antarctica/Palmer
    {    8, 7226,    6246,  6, }, // Antarctica/Rothera
    {    8, 7295,     643,  5, }, // Antarctica/Syowa
    {    8, 8625,    6252,  4, }, // Antarctica/Troll
    {    8, 7374,    6256,  6, }, // Antarctica/Vostok
    {    8, 5414,    6262,  6, }, // Asia/Almaty
    {    8, 3987,    6268,  4, }, // Asia/Amman
    {    8, 5542,     683,  5, }, // Asia/Aqtau
    {    8, 5387,    6272,  6, }, // Asia/Aqtobe
    {    8, 4485,    6278,  6, }, // Asia/Bangkok
    {    8, 4105,    6284,  6, }, // Asia/Beirut
    {    8, 4620,    6290,  5, }, // Asia/Chita
    {    8, 4530,    6295,  7, }, // Asia/Colombo
    {    8, 1095,    5381,  4, }, // Asia/Dhaka
    {    8, 4814,    6302,  6, }, // Asia/Hebron
    {    8, 1261,    6308, 10, }, // Asia/Ho_Chi_Minh
    {    8, 4790,     704,  5, }, // Asia/Hovd
    {    8, 4203,    6318,  7, }, // Asia/Irkutsk
    {    8, 7025,    6325,  8, }, // Asia/Jakarta
    {    8, 7011,    6333,  9, }, // Asia/Jayapura
    {    8, 1292,    6342,  9, }, // Asia/Jerusalem
    {    8, 4335,    6351,  9, }, // Asia/Kamchatka
    {    8, 4258,    6360,  7, }, // Asia/Karachi
    {    8, 1187,    6367,  8, }, // Asia/Kathmandu
    {    8,  994,     718,  7, }, // Asia/Kolkata
    {    8, 5995,    6375,  6, }, // Asia/Kuching
    {    8, 1213,     725,  5, }, // Asia/Macau
    {    8, 1351,    6381,  6, }, // Asia/Makassar
    {    8, 6939,    4966,  6, }, // Asia/Muscat
    {    8, 2556,    6387,  7, }, // Asia/Nicosia
    {    8, 5578,    4972,  4, }, // Asia/Qatar
    {    8, 8726,     730,  8, }, // Asia/Qostanay
    {    8, 3319,    6394,  7, }, // Asia/Singapore
    {    8, 2774,    6401,  6, }, // Asia/Tehran
    {    8, 1319,    6407,  6, }, // Asia/Thimphu
    {    8, 1023,    6413,  9, }, // Asia/Ulaanbaatar
    {    8, 1161,    6422,  7, }, // Asia/Urumqi
    {    8, 6996,    6429, 10, }, // Asia/Vientiane
    {    8, 1237,     753,  6, }, // Asia/Yangon
    {    8, 3902,    6439, 12, }, // Asia/Yekaterinburg
    {    8, 5690,    6451,  6, }, // Atlantic/Bermuda
    {    8, 6647,    5038,  6, }, // Atlantic/Canary
    {    8, 3746,    6457,  7, }, // Atlantic/Cape_Verde
    {    8, 1397,    6464,  6, }, // Atlantic/Faroe
    {    8, 2750,    6470, 10, }, // Atlantic/Reykjavik
    {    8, 7272,    6480, 16, }, // Atlantic/South_Georgia
    {    8, 6840,     773, 10, }, // Atlantic/St_Helena
    {    8, 6663,    6496,  6, }, // Atlantic/Stanley
    {    8, 1801,    6502, 11, }, // Australia/Broken_Hill
    {    8, 1585,    6513,  6, }, // Australia/Darwin
    {    8, 3656,    6519,  5, }, // Australia/Eucla
    {    8, 1518,    6524,  5, }, // Australia/Hobart
    {    8, 1549,    6529,  8, }, // Australia/Lord_Howe
    {    8, 1729,    6537,  6, }, // Australia/Melbourne
    {    8, 1764,    6543,  4, }, // Australia/Perth
    {    8, 1465,    6547,  5, }, // Australia/Sydney
    {    8, 6460,    6552,  8, }, // Europe/Amsterdam
    {    8, 6235,    6560,  6, }, // Europe/Andorra
    {    8, 2302,    6566,  5, }, // Europe/Athens
    {    8, 6355,    6571,  8, }, // Europe/Belgrade
    {    8, 4776,    6579,  6, }, // Europe/Berlin
    {    8, 2169,    6585,  8, }, // Europe/Brussels
    {    8, 3947,    6593,  9, }, // Europe/Bucharest
    {    8, 3825,    6602,  8, }, // Europe/Budapest
    {    8, 8790,    6610,  8, }, // Europe/Busingen
    {    8, 2585,    6618,  8, }, // Europe/Chisinau
    {    8, 6308,    6626,  9, }, // Europe/Copenhagen
    {    8, 2340,    6635,  6, }, // Europe/Dublin
    {    8, 6326,    6641,  8, }, // Europe/Gibraltar
    {    8, 6631,    6649,  8, }, // Europe/Helsinki
    {    8, 8841,    6657,  5, }, // Europe/Jersey
    {    8, 2529,    6662,  5, }, // Europe/Kyiv
    {    8, 3232,    6667,  6, }, // Europe/Lisbon
    {    8, 6525,    6673, 10, }, // Europe/Ljubljana
    {    8, 2503,    6683,  6, }, // Europe/London
    {    8, 6384,    6689,  8, }, // Europe/Luxembourg
    {    8, 6416,    6697,  5, }, // Europe/Malta
    {    8, 3556,    6702,  5, }, // Europe/Moscow
    {    8, 6443,    6707,  9, }, // Europe/Podgorica
    {    8, 6294,    6716,  5, }, // Europe/Prague
    {    8, 6264,    6721,  9, }, // Europe/Sarajevo
    {    8, 6402,    6730,  7, }, // Europe/Skopje
    {    8, 6542,    6737,  7, }, // Europe/Stockholm
    {    8, 6221,     819,  6, }, // Europe/Tirane
    {    8, 6586,    6744,  7, }, // Europe/Vatican
    {    8, 6250,    6751,  5, }, // Europe/Vienna
    {    8, 3209,    6756,  6, }, // Europe/Warsaw
    {    8, 6559,    6762,  7, }, // Europe/Zurich
    {    8, 6966,    6769,  6, }, // Indian/Chagos
    {    8, 6065,    6775,  7, }, // Indian/Christmas
    {    8, 6082,    6782,  6, }, // Indian/Cocos
    {    8, 5048,    6788,  6, }, // Indian/Comoro
    {    8, 6680,    6794,  8, }, // Indian/Kerguelen
    {    8, 7260,     896,  4, }, // Indian/Mahe
    {    8, 4088,    6802, 10, }, // Indian/Mauritius
    {    8, 5117,    6812,  6, }, // Indian/Mayotte
    {    8, 7211,     900,  7, }, // Indian/Reunion
    {    8, 3009,    6818,  7, }, // Pacific/Auckland
    {    8, 3034,    6825,  6, }, // Pacific/Chatham
    {    8, 3176,    6831,  5, }, // Pacific/Chuuk
    {    8, 2239,    6836,  5, }, // Pacific/Easter
    {    8, 3921,    6841,  5, }, // Pacific/Fiji
    {    8, 6697,    6846,  9, }, // Pacific/Galapagos
    {    8, 3068,     957,  6, }, // Pacific/Kanton
    {    8, 2844,    6855, 11, }, // Pacific/Kwajalein
    {    8, 4896,    6866,  7, }, // Pacific/Majuro
    {    8, 4070,    6873, 14, }, // Pacific/Marquesas
    {    8, 4187,    6887,  6, }, // Pacific/Norfolk
    {    8, 7117,    1028,  6, }, // Pacific/Noumea
    {    8, 7194,    6893,  9, }, // Pacific/Pitcairn
    {    8, 3115,    6902,  6, }, // Pacific/Pohnpei
    {    8, 4826,    6908, 11, }, // Pacific/Port_Moresby
    {    8, 7392,    6919,  9, }, // Pacific/Wake
    {    8, 7405,    1068, 15, }, // Pacific/Wallis
    {    9,   14,       0,  6, }, // Africa/Asmara Akoose/Latin/Cameroon
    {    9, 5185,       6,  8, }, // Africa/El_Aaiun
    {    9, 6888,      14,  4, }, // Africa/Lome
    {    9, 5290,      18,  9, }, // Africa/Ndjamena
    {    9, 4454,      27,  8, }, // Africa/Sao_Tome
    {    9, 4573,      35,  9, }, // America/Araguaina
    {    9,  270,      44,  7, }, // America/Argentina/Cordoba
    {    9, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {    9, 7571,      63,  7, }, // America/Argentina/Tucuman
    {    9, 4271,      70,  8, }, // America/Asuncion
    {    9,  237,      78,  8, }, // America/Atikokan
    {    9, 7623,      86, 17, }, // America/Bahia_Banderas
    {    9, 7646,     103,  5, }, // America/Belem
    {    9, 4380,     108,  6, }, // America/Bogota
    {    9, 3887,     114,  6, }, // America/Cancun
    {    9, 7774,     120, 13, }, // America/Ciudad_Juarez
    {    9, 3810,     133,  6, }, // America/Cuiaba
    {    9, 5742,     139,  7, }, // America/Curacao
    {    9, 7887,     146,  8, }, // America/Eirunepe
    {    9,  481,     154, 13, }, // America/Indiana/Knox
    {    9, 7979,     167, 16, }, // America/Indiana/Marengo
    {    9, 8003,     183, 19, }, // America/Indiana/Petersburg
    {    9, 8030,     202, 18, }, // America/Indiana/Tell_City
    {    9, 8056,     220, 14, }, // America/Indiana/Vevay
    {    9, 8078,     234, 18, }, // America/Indiana/Vincennes
    {    9, 8104,     252, 16, }, // America/Indiana/Winamac
    {    9, 8143,     268, 20, }, // America/Kentucky/Monticello
    {    9, 5951,     288, 22, }, // America/Lower_Princes
    {    9, 8171,     310,  6, }, // America/Maceio
    {    9, 2919,     316,  8, }, // America/Mazatlan
    {    9, 8238,     324,  6, }, // America/Merida
    {    9, 2951,    4381, 16, }, // America/Mexico_City
    {    9, 4410,     341, 12, }, // America/Miquelon
    {    9, 1852,     353, 19, }, // America/Noronha
    {    9, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {    9, 8347,     392, 20, }, // America/North_Dakota/Center
    {    9, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {    9,  393,     435,  4, }, // America/Nuuk
    {    9, 8495,     439,  8, }, // America/Santarem
    {    9, 1880,     447,  9, }, // America/Sao_Paulo
    {    9, 6918,     456, 16, }, // America/Scoresbysund
    {    9, 8526,     472, 14, }, // America/St_Barthelemy
    {    9, 2063,     486, 10, }, // America/St_Johns
    {    9, 5882,     496,  9, }, // America/St_Kitts
    {    9, 5899,     505,  9, }, // America/St_Lucia
    {    9,  855,     514, 10, }, // America/St_Thomas
    {    9, 5932,     524, 11, }, // America/St_Vincent
    {    9, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {    9, 7295,     643,  5, }, // Antarctica/Syowa
    {    9, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {    9, 4790,     704,  5, }, // Asia/Hovd
    {    9, 1187,     709,  9, }, // Asia/Kathmandu
    {    9,  994,     718,  7, }, // Asia/Kolkata
    {    9, 1213,     725,  5, }, // Asia/Macau
    {    9, 1161,     747,  6, }, // Asia/Urumqi
    {    9, 1237,     753,  6, }, // Asia/Yangon
    {    9, 6647,    4413,  8, }, // Atlantic/Canary
    {    9, 1397,     767,  5, }, // Atlantic/Faroe
    {    9, 6840,     773, 10, }, // Atlantic/St_Helena
    {    9, 8790,     799,  8, }, // Europe/Busingen
    {    9, 2585,     807,  8, }, // Europe/Chisinau
    {    9, 2529,     815,  4, }, // Europe/Kyiv
    {    9, 6221,     819,  6, }, // Europe/Tirane
    {    9, 5048,    4421,  7, }, // Indian/Comoro
    {    9, 7260,     896,  4, }, // Indian/Mahe
    {    9, 7211,     900,  7, }, // Indian/Reunion
    {    9, 3176,     922,  5, }, // Pacific/Chuuk
    {    9, 6697,     940,  9, }, // Pacific/Galapagos
    {    9, 3068,     957,  6, }, // Pacific/Kanton
    {    9, 7117,    1028,  6, }, // Pacific/Noumea
    {    9, 3115,    1050,  7, }, // Pacific/Pohnpei
    {    9, 7405,    1068, 15, }, // Pacific/Wallis
    {   10, 6807,    6928,  7, }, // Africa/Abidjan Albanian/Latin/Albania
    {   10, 6779,    5322,  4, }, // Africa/Accra
    {   10, 5078,    6935, 10, }, // Africa/Addis_Ababa
    {   10, 7420,    6945,  6, }, // Africa/Algiers
    {   10,   14,    6951,  6, }, // Africa/Asmara
    {   10, 6765,    6957,  7, }, // Africa/Banjul
    {   10, 7435,    6964,  5, }, // Africa/Bissau
    {   10, 4976,    6969,  8, }, // Africa/Blantyre
    {   10, 5306,    6977, 10, }, // Africa/Brazzaville
    {   10, 4941,    6987, 10, }, // Africa/Bujumbura
    {   10, 2322,    6997,  5, }, // Africa/Cairo
    {   10, 4136,    7002, 10, }, // Africa/Casablanca
    {   10, 7449,    7012,  6, }, // Africa/Ceuta
    {   10, 6792,    7018,  7, }, // Africa/Conakry
    {   10, 5149,    7025, 12, }, // Africa/Dar_es_Salaam
    {   10, 5062,    7037,  7, }, // Africa/Djibouti
    {   10, 5185,    7044,  7, }, // Africa/El_Aaiun
    {   10, 6872,    7051,  7, }, // Africa/Freetown
    {   10, 4498,    7058, 11, }, // Africa/Johannesburg
    {   10, 4518,    7069,  5, }, // Africa/Juba
    {   10, 4543,    7074,  6, }, // Africa/Khartoum
    {   10, 5355,    7080,  9, }, // Africa/Libreville
    {   10, 6888,      14,  4, }, // Africa/Lome
    {   10, 5290,      18,  9, }, // Africa/Ndjamena
    {   10, 5373,    7089,  6, }, // Africa/Niamey
    {   10, 6822,    7095,  7, }, // Africa/Nouakchott
    {   10, 6746,    7102,  8, }, // Africa/Ouagadougou
    {   10, 4454,    7110,  8, }, // Africa/Sao_Tome
    {   10, 6573,    7118,  5, }, // Africa/Tunis
    {   10, 4171,    7123,  8, }, // Africa/Windhoek
    {   10, 3365,    7131,  9, }, // America/Anchorage
    {   10, 5626,    7140,  7, }, // America/Anguilla
    {   10, 4573,    7147, 10, }, // America/Araguaina
    {   10,  166,    7157, 12, }, // America/Argentina/Buenos_Aires
    {   10,   91,    7169,  9, }, // America/Argentina/Catamarca
    {   10,  270,    7178,  7, }, // America/Argentina/Cordoba
    {   10,  441,    7185,  5, }, // America/Argentina/Jujuy
    {   10, 7462,    7190,  8, }, // America/Argentina/La_Rioja
    {   10, 7489,    7198, 11, }, // America/Argentina/Rio_Gallegos
    {   10, 7520,    7209,  5, }, // America/Argentina/Salta
    {   10, 7544,    7214,  8, }, // America/Argentina/San_Juan
    {   10, 5599,    7222,  9, }, // America/Argentina/San_Luis
    {   10, 7571,    5506,  7, }, // America/Argentina/Tucuman
    {   10, 7597,    7231,  7, }, // America/Argentina/Ushuaia
    {   10, 5659,    7238,  5, }, // America/Aruba
    {   10, 4271,    7243,  8, }, // America/Asuncion
    {   10,  237,      78,  8, }, // America/Atikokan
    {   10, 7623,    7251, 14, }, // America/Bahia_Banderas
    {   10, 7646,     103,  5, }, // America/Belem
    {   10, 5426,    7265,  6, }, // America/Belize
    {   10, 7660,    7271, 12, }, // America/Blanc-Sablon
    {   10, 7681,    7283,  9, }, // America/Boa_Vista
    {   10, 4380,    7292,  6, }, // America/Bogota
    {   10, 7699,    7298,  5, }, // America/Boise
    {   10, 7713,    7303, 18, }, // America/Cambridge_Bay
    {   10, 7735,    7321, 12, }, // America/Campo_Grande
    {   10, 3887,    5574,  6, }, // America/Cancun
    {   10, 4713,    5580,  7, }, // America/Caracas
    {   10, 4364,    7333,  6, }, // America/Cayenne
    {   10, 5515,    7339,  6, }, // America/Cayman
    {   10, 2262,    7345,  6, }, // America/Chicago
    {   10, 7756,    7351,  7, }, // America/Chihuahua
    {   10, 7774,    7358, 13, }, // America/Ciudad_Juarez
    {   10, 5441,    7371, 10, }, // America/Costa_Rica
    {   10, 7796,    7381,  8, }, // America/Coyhaique
    {   10, 7814,    7389,  7, }, // America/Creston
    {   10, 3810,    7396,  6, }, // America/Cuiaba
    {   10, 5742,    7402,  7, }, // America/Curacao
    {   10, 7830,    7409, 13, }, // America/Danmarkshavn
    {   10, 7851,    7422,  6, }, // America/Dawson
    {   10, 7866,    7428, 16, }, // America/Dawson_Creek
    {   10, 5758,    7444,  8, }, // America/Dominica
    {   10, 7887,    7452,  7, }, // America/Eirunepe
    {   10, 5460,    7459,  8, }, // America/El_Salvador
    {   10, 7904,    7467, 11, }, // America/Fort_Nelson
    {   10, 7942,    7478, 14, }, // America/Glace_Bay
    {   10, 6900,    7492, 13, }, // America/Goose_Bay
    {   10, 4631,    7505, 12, }, // America/Grand_Turk
    {   10, 5789,    7517,  7, }, // America/Grenada
    {   10, 5805,    7524,  9, }, // America/Guadeloupe
    {   10, 3779,    7533,  9, }, // America/Guatemala
    {   10, 4860,    7542,  9, }, // America/Guayaquil
    {   10, 6951,    7551,  7, }, // America/Guyana
    {   10, 1941,    7558,  8, }, // America/Halifax
    {   10, 2283,    7566,  6, }, // America/Havana
    {   10, 7960,    7572,  9, }, // America/Hermosillo
    {   10,  481,    7581, 14, }, // America/Indiana/Knox
    {   10, 7979,     167, 16, }, // America/Indiana/Marengo
    {   10, 8003,    7595, 19, }, // America/Indiana/Petersburg
    {   10, 8030,    7614, 18, }, // America/Indiana/Tell_City
    {   10, 8056,    7632, 14, }, // America/Indiana/Vevay
    {   10, 8078,    7646, 17, }, // America/Indiana/Vincennes
    {   10, 8104,    7663, 16, }, // America/Indiana/Winamac
    {   10,  660,    5840,  7, }, // America/Iqaluit
    {   10, 2801,    7679,  8, }, // America/Jamaica
    {   10, 5399,    7687,  6, }, // America/Juneau
    {   10,  521,    7693,  8, }, // America/Kentucky/Louisville
    {   10, 8143,    7701, 18, }, // America/Kentucky/Monticello
    {   10, 7169,    7719,  4, }, // America/Lima
    {   10, 3258,    7723, 12, }, // America/Los_Angeles
    {   10, 5951,    7735, 21, }, // America/Lower_Princes
    {   10, 8171,    7756,  6, }, // America/Maceio
    {   10, 5824,    7762,  9, }, // America/Martinique
    {   10, 2919,     316,  8, }, // America/Mazatlan
    {   10, 8220,    7771,  8, }, // America/Menominee
    {   10, 8238,    7779,  6, }, // America/Merida
    {   10, 2951,    7785, 17, }, // America/Mexico_City
    {   10, 4410,    7802,  7, }, // America/Miquelon
    {   10, 8272,    7809,  7, }, // America/Moncton
    {   10, 8288,    7816,  9, }, // America/Monterrey
    {   10, 5843,    7825,  9, }, // America/Montserrat
    {   10, 5500,    7834,  5, }, // America/Nassau
    {   10, 2381,    7839,  8, }, // America/New_York
    {   10, 1852,    7847,  7, }, // America/Noronha
    {   10, 8319,    7854, 22, }, // America/North_Dakota/Beulah
    {   10, 8347,    7876, 23, }, // America/North_Dakota/Center
    {   10, 8375,    7899, 26, }, // America/North_Dakota/New_Salem
    {   10,  393,    7925,  4, }, // America/Nuuk
    {   10, 8406,    7929,  7, }, // America/Ojinaga
    {   10, 2975,    7936,  6, }, // America/Phoenix
    {   10, 3964,    7942, 12, }, // America/Port-au-Prince
    {   10, 8422,    7954, 11, }, // America/Porto_Velho
    {   10, 5862,    7965, 10, }, // America/Puerto_Rico
    {   10, 4049,    7975, 12, }, // America/Punta_Arenas
    {   10, 8442,    7987, 11, }, // America/Rankin_Inlet
    {   10, 1997,    7998,  7, }, // America/Regina
    {   10,  695,    8005, 10, }, // America/Rio_Branco
    {   10, 8495,     439,  8, }, // America/Santarem
    {   10, 6130,    8015, 13, }, // America/Santo_Domingo
    {   10, 1880,    8028,  9, }, // America/Sao_Paulo
    {   10, 6918,    8037, 12, }, // America/Scoresbysund
    {   10, 8526,    8049, 13, }, // America/St_Barthelemy
    {   10, 2063,    8062,  9, }, // America/St_Johns
    {   10, 5882,    8071,  9, }, // America/St_Kitts
    {   10, 5899,    8080, 10, }, // America/St_Lucia
    {   10,  855,    8090, 10, }, // America/St_Thomas
    {   10, 5932,    8100, 12, }, // America/St_Vincent
    {   10, 8548,    8112, 15, }, // America/Swift_Current
    {   10, 5480,    6191, 11, }, // America/Tegucigalpa
    {   10, 5775,    8127,  5, }, // America/Thule
    {   10,  313,    8132,  7, }, // America/Tijuana
    {   10, 5707,    8139,  7, }, // America/Tortola
    {   10, 2095,    8146,  8, }, // America/Vancouver
    {   10, 2146,    8154,  9, }, // America/Whitehorse
    {   10,  734,    8163,  7, }, // America/Winnipeg
    {   10, 8570,    8170,  7, }, // America/Yakutat
    {   10, 6020,    8177,  5, }, // Antarctica/Casey
    {   10, 6113,    8182,  6, }, // Antarctica/Davis
    {   10, 6152,    8188, 15, }, // Antarctica/DumontDUrville
    {   10, 8586,    8203,  7, }, // Antarctica/Macquarie
    {   10, 7085,    8210,  6, }, // Antarctica/Mawson
    {   10,  932,    8216,  8, }, // Antarctica/McMurdo
    {   10, 7226,    8224,  7, }, // Antarctica/Rothera
    {   10, 7295,    8231,  5, }, // Antarctica/Syowa
    {   10, 1431,    8236, 11, }, // Arctic/Longyearbyen
    {   10, 5414,    8247,  6, }, // Asia/Almaty
    {   10, 3987,    6268,  4, }, // Asia/Amman
    {   10, 5530,    8253,  6, }, // Asia/Anadyr
    {   10, 5542,     683,  5, }, // Asia/Aqtau
    {   10, 5387,    8259,  6, }, // Asia/Aqtobe
    {   10, 8642,    8265,  6, }, // Asia/Atyrau
    {   10, 3626,    4802,  6, }, // Asia/Baghdad
    {   10, 5553,    8271,  7, }, // Asia/Bahrain
    {   10, 4105,    8278,  6, }, // Asia/Beirut
    {   10, 4620,    8284,  4, }, // Asia/Chita
    {   10, 4530,    6295,  7, }, // Asia/Colombo
    {   10, 4559,    4841,  6, }, // Asia/Damascus
    {   10, 1095,    5381,  4, }, // Asia/Dhaka
    {   10, 8654,    8288,  9, }, // Asia/Famagusta
    {   10, 1261,    8297,  9, }, // Asia/Ho_Chi_Minh
    {   10, 2706,    8306,  9, }, // Asia/Hong_Kong
    {   10, 4790,     704,  5, }, // Asia/Hovd
    {   10, 7025,    8315,  8, }, // Asia/Jakarta
    {   10, 7011,    8323,  9, }, // Asia/Jayapura
    {   10, 4335,    8332,  8, }, // Asia/Kamchatka
    {   10, 4258,    8340,  6, }, // Asia/Karachi
    {   10, 1187,    6367,  8, }, // Asia/Kathmandu
    {   10, 8679,    8346,  7, }, // Asia/Khandyga
    {   10,  994,    8353,  7, }, // Asia/Kolkata
    {   10, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {   10, 4878,    8360, 12, }, // Asia/Kuala_Lumpur
    {   10, 5995,    8372,  6, }, // Asia/Kuching
    {   10, 5566,    8378,  6, }, // Asia/Kuwait
    {   10, 1213,    8384,  5, }, // Asia/Macau
    {   10, 1351,    8389,  7, }, // Asia/Makassar
    {   10, 7182,    8396,  6, }, // Asia/Manila
    {   10, 6939,    4966,  6, }, // Asia/Muscat
    {   10, 2556,    8402,  7, }, // Asia/Nicosia
    {   10, 6980,    8409,  8, }, // Asia/Phnom_Penh
    {   10, 4233,    8417,  6, }, // Asia/Pyongyang
    {   10, 5578,    4972,  5, }, // Asia/Qatar
    {   10, 8726,    8423,  8, }, // Asia/Qostanay
    {   10, 4288,    8431,  9, }, // Asia/Qyzylorda
    {   10, 3603,    8440,  4, }, // Asia/Riyadh
    {   10, 4427,    8444,  7, }, // Asia/Sakhalin
    {   10, 3298,    8451,  4, }, // Asia/Seoul
    {   10, 1055,    8455,  7, }, // Asia/Shanghai
    {   10, 3319,    8462,  8, }, // Asia/Singapore
    {   10, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {   10, 3282,    8483,  6, }, // Asia/Taipei
    {   10, 3934,    8489,  6, }, // Asia/Tbilisi
    {   10, 2774,    8495,  7, }, // Asia/Tehran
    {   10, 1319,    8502,  6, }, // Asia/Thimphu
    {   10, 2823,    4996,  5, }, // Asia/Tokyo
    {   10, 1023,    8508,  9, }, // Asia/Ulaanbaatar
    {   10, 1161,     747,  6, }, // Asia/Urumqi
    {   10, 6996,    8517,  9, }, // Asia/Vientiane
    {   10, 4847,    8526,  7, }, // Asia/Yakutsk
    {   10, 1237,    8533,  6, }, // Asia/Yangon
    {   10, 3902,    8539, 12, }, // Asia/Yekaterinburg
    {   10, 3766,    8551,  7, }, // Asia/Yerevan
    {   10, 3682,    8558,  5, }, // Atlantic/Azores
    {   10, 5690,    8563,  7, }, // Atlantic/Bermuda
    {   10, 6647,    5038,  6, }, // Atlantic/Canary
    {   10, 3746,    8570, 14, }, // Atlantic/Cape_Verde
    {   10, 1397,     767,  5, }, // Atlantic/Faroe
    {   10, 2750,    8584,  9, }, // Atlantic/Reykjavik
    {   10, 7272,    8593, 15, }, // Atlantic/South_Georgia
    {   10, 6840,    8608, 10, }, // Atlantic/St_Helena
    {   10, 6663,    8618,  6, }, // Atlantic/Stanley
    {   10, 1672,    8624,  8, }, // Australia/Adelaide
    {   10, 1637,    8632,  8, }, // Australia/Brisbane
    {   10, 1801,    8640, 11, }, // Australia/Broken_Hill
    {   10, 1585,    8651,  6, }, // Australia/Darwin
    {   10, 3656,    6519,  5, }, // Australia/Eucla
    {   10, 8771,    8657,  8, }, // Australia/Lindeman
    {   10, 1549,    8665,  9, }, // Australia/Lord_Howe
    {   10, 1729,    8674,  7, }, // Australia/Melbourne
    {   10, 1764,    8681,  5, }, // Australia/Perth
    {   10, 1465,    8686,  6, }, // Australia/Sydney
    {   10, 6235,    8692,  7, }, // Europe/Andorra
    {   10, 3639,    8699,  8, }, // Europe/Astrakhan
    {   10, 2302,    8707,  6, }, // Europe/Athens
    {   10, 6355,    8713,  7, }, // Europe/Belgrade
    {   10, 6507,    8720, 10, }, // Europe/Bratislava
    {   10, 2169,    8730,  7, }, // Europe/Brussels
    {   10, 3947,    8737,  9, }, // Europe/Bucharest
    {   10, 8790,     799,  8, }, // Europe/Busingen
    {   10, 2585,    8746,  8, }, // Europe/Chisinau
    {   10, 6308,    5115, 10, }, // Europe/Copenhagen
    {   10, 6326,    8754, 10, }, // Europe/Gibraltar
    {   10, 8806,    8764,  7, }, // Europe/Guernsey
    {   10, 8822,    8771, 15, }, // Europe/Isle_of_Man
    {   10, 1132,    8786,  8, }, // Europe/Istanbul
    {   10, 8841,    8794,  7, }, // Europe/Jersey
    {   10, 2529,    8801,  4, }, // Europe/Kyiv
    {   10, 3232,    8805,  7, }, // Europe/Lisbon
    {   10, 6525,    8812,  7, }, // Europe/Ljubljana
    {   10, 2503,    8819,  6, }, // Europe/London
    {   10, 6384,    8825, 10, }, // Europe/Luxembourg
    {   10, 6416,    8835,  5, }, // Europe/Malta
    {   10, 6429,    8840,  6, }, // Europe/Monaco
    {   10, 3556,    8846,  5, }, // Europe/Moscow
    {   10, 6443,    8851,  9, }, // Europe/Podgorica
    {   10, 6294,    8860,  5, }, // Europe/Prague
    {   10, 8868,    8865,  4, }, // Europe/Riga
    {   10, 6343,    8869,  4, }, // Europe/Rome
    {   10, 6489,    8873, 10, }, // Europe/San_Marino
    {   10, 6264,    8883,  8, }, // Europe/Sarajevo
    {   10, 6402,    8891,  5, }, // Europe/Skopje
    {   10, 6618,    8896,  5, }, // Europe/Sofia
    {   10, 6542,    8901,  8, }, // Europe/Stockholm
    {   10, 8898,    8909,  5, }, // Europe/Tallinn
    {   10, 6221,    8914,  6, }, // Europe/Tirane
    {   10, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {   10, 6586,    6744,  7, }, // Europe/Vatican
    {   10, 6250,    8929,  5, }, // Europe/Vienna
    {   10, 3209,    8934,  8, }, // Europe/Warsaw
    {   10, 6559,    8942,  5, }, // Europe/Zurich
    {   10, 6966,    8947,  5, }, // Indian/Chagos
    {   10, 6065,    8952, 12, }, // Indian/Christmas
    {   10, 6082,    5223,  5, }, // Indian/Cocos
    {   10, 5048,    8964,  6, }, // Indian/Comoro
    {   10, 7260,     896,  4, }, // Indian/Mahe
    {   10, 7069,    8970,  7, }, // Indian/Maldives
    {   10, 5117,    8977,  6, }, // Indian/Mayotte
    {   10, 7211,     900,  7, }, // Indian/Reunion
    {   10, 3009,    8983,  6, }, // Pacific/Auckland
    {   10, 3725,    8989, 10, }, // Pacific/Bougainville
    {   10, 3034,    8999,  6, }, // Pacific/Chatham
    {   10, 3176,    9005,  3, }, // Pacific/Chuuk
    {   10, 2239,    9008,  6, }, // Pacific/Easter
    {   10, 3921,    9014,  5, }, // Pacific/Fiji
    {   10, 6697,     940,  9, }, // Pacific/Galapagos
    {   10, 3841,    9019, 11, }, // Pacific/Guadalcanal
    {   10, 2725,    5251,  8, }, // Pacific/Honolulu
    {   10, 3068,    9030, 18, }, // Pacific/Kanton
    {   10, 4017,    9048,  9, }, // Pacific/Kiritimati
    {   10, 7038,    9057,  5, }, // Pacific/Kosrae
    {   10, 2844,    9062, 10, }, // Pacific/Kwajalein
    {   10, 4896,    9072,  6, }, // Pacific/Majuro
    {   10, 4070,    9078,  6, }, // Pacific/Marquesas
    {   10, 8945,    9084,  6, }, // Pacific/Midway
    {   10, 7117,    1028,  6, }, // Pacific/Noumea
    {   10, 3145,    9090,  9, }, // Pacific/Pago_Pago
    {   10, 7194,    9099,  7, }, // Pacific/Pitcairn
    {   10, 3115,    9106,  7, }, // Pacific/Pohnpei
    {   10, 4826,    9113, 12, }, // Pacific/Port_Moresby
    {   10, 6095,    9125,  9, }, // Pacific/Rarotonga
    {   10, 6731,    9134,  6, }, // Pacific/Tarawa
    {   10, 7392,    9140,  4, }, // Pacific/Wake
    {   10, 7405,    9144,  6, }, // Pacific/Wallis
    {   13, 6807,    9150,  4, }, // Africa/Abidjan Amharic/Ethiopic/Ethiopia
    {   13, 6779,    9154,  3, }, // Africa/Accra
    {   13, 5078,    9157,  7, }, // Africa/Addis_Ababa
    {   13, 7420,    9164,  5, }, // Africa/Algiers
    {   13,   14,    9169,  4, }, // Africa/Asmara
    {   13,   44,    9173,  3, }, // Africa/Bamako
    {   13, 5276,    9176,  4, }, // Africa/Bangui
    {   13, 6765,    9180,  4, }, // Africa/Banjul
    {   13, 7435,    9184,  3, }, // Africa/Bissau
    {   13, 4976,    9187,  6, }, // Africa/Blantyre
    {   13, 5306,    9193,  5, }, // Africa/Brazzaville
    {   13, 4941,    9198,  5, }, // Africa/Bujumbura
    {   13, 2322,    9203,  3, }, // Africa/Cairo
    {   13, 4136,    9206,  6, }, // Africa/Casablanca
    {   13, 7449,    9212,  3, }, // Africa/Ceuta
    {   13, 6792,    9215,  4, }, // Africa/Conakry
    {   13, 6859,    9219,  3, }, // Africa/Dakar
    {   13, 5149,    9222,  6, }, // Africa/Dar_es_Salaam
    {   13, 5062,    9228,  3, }, // Africa/Djibouti
    {   13, 5262,    9231,  3, }, // Africa/Douala
    {   13, 5185,    9234,  7, }, // Africa/El_Aaiun
    {   13, 6872,    9241,  5, }, // Africa/Freetown
    {   13, 4925,    9246,  4, }, // Africa/Gaborone
    {   13, 5034,    9250,  3, }, // Africa/Harare
    {   13, 4498,    9253,  7, }, // Africa/Johannesburg
    {   13, 4518,    9260,  2, }, // Africa/Juba
    {   13, 5170,    9262,  4, }, // Africa/Kampala
    {   13, 4543,    9266,  4, }, // Africa/Khartoum
    {   13, 4992,    9270,  3, }, // Africa/Kigali
    {   13, 5325,    9273,  4, }, // Africa/Kinshasa
    {   13, 4763,    9277,  3, }, // Africa/Lagos
    {   13, 5355,    9280,  5, }, // Africa/Libreville
    {   13, 6888,    9285,  2, }, // Africa/Lome
    {   13, 5230,    9287,  4, }, // Africa/Luanda
    {   13, 4958,    9291,  5, }, // Africa/Lubumbashi
    {   13, 5020,    9296,  3, }, // Africa/Lusaka
    {   13, 5341,    9299,  3, }, // Africa/Malabo
    {   13, 5006,    9302,  3, }, // Africa/Maputo
    {   13, 5216,    9305,  3, }, // Africa/Maseru
    {   13, 5201,    9308,  4, }, // Africa/Mbabane
    {   13, 5132,    9312,  4, }, // Africa/Mogadishu
    {   13, 7053,    9316,  5, }, // Africa/Monrovia
    {   13, 3872,    9321,  4, }, // Africa/Nairobi
    {   13, 5290,    9325,  4, }, // Africa/Ndjamena
    {   13, 5373,    9329,  4, }, // Africa/Niamey
    {   13, 6822,    9333,  5, }, // Africa/Nouakchott
    {   13, 6746,    9338,  4, }, // Africa/Ouagadougou
    {   13, 5244,    9342,  8, }, // Africa/Porto-Novo
    {   13, 4454,    9350,  5, }, // Africa/Sao_Tome
    {   13, 2868,    9355,  4, }, // Africa/Tripoli
    {   13, 6573,    9359,  3, }, // Africa/Tunis
    {   13, 4171,    9362,  5, }, // Africa/Windhoek
    {   13,  132,    9367,  3, }, // America/Adak
    {   13, 3365,    9370,  5, }, // America/Anchorage
    {   13, 5626,    9375,  5, }, // America/Anguilla
    {   13, 5643,    9380,  4, }, // America/Antigua
    {   13, 4573,    9384,  5, }, // America/Araguaina
    {   13,  166,    9389,  8, }, // America/Argentina/Buenos_Aires
    {   13,   91,    9397,  5, }, // America/Argentina/Catamarca
    {   13,  270,    9402,  4, }, // America/Argentina/Cordoba
    {   13,  441,    9406,  3, }, // America/Argentina/Jujuy
    {   13, 7462,    9409,  5, }, // America/Argentina/La_Rioja
    {   13,  565,    9414,  4, }, // America/Argentina/Mendoza
    {   13, 7489,    9418,  7, }, // America/Argentina/Rio_Gallegos
    {   13, 7520,    9425,  3, }, // America/Argentina/Salta
    {   13, 7544,    9428,  6, }, // America/Argentina/San_Juan
    {   13, 5599,    9434,  6, }, // America/Argentina/San_Luis
    {   13, 7571,    9440,  4, }, // America/Argentina/Tucuman
    {   13, 7597,    9444,  4, }, // America/Argentina/Ushuaia
    {   13, 5659,    9448,  3, }, // America/Aruba
    {   13, 4271,    9451,  6, }, // America/Asuncion
    {   13,  237,    9457,  5, }, // America/Atikokan
    {   13, 3698,    9462,  3, }, // America/Bahia
    {   13, 7623,    9465,  9, }, // America/Bahia_Banderas
    {   13, 5673,    9474,  5, }, // America/Barbados
    {   13, 7646,    9479,  3, }, // America/Belem
    {   13, 5426,    9482,  3, }, // America/Belize
    {   13, 7660,    9485, 10, }, // America/Blanc-Sablon
    {   13, 7681,    9495,  6, }, // America/Boa_Vista
    {   13, 4380,    9501,  3, }, // America/Bogota
    {   13, 7699,    9504,  3, }, // America/Boise
    {   13, 7713,    9507,  8, }, // America/Cambridge_Bay
    {   13, 7735,    9515,  8, }, // America/Campo_Grande
    {   13, 3887,    9523,  4, }, // America/Cancun
    {   13, 4713,    9527,  4, }, // America/Caracas
    {   13, 4364,    9531,  4, }, // America/Cayenne
    {   13, 5515,    9535,  4, }, // America/Cayman
    {   13, 2262,    9539,  3, }, // America/Chicago
    {   13, 7756,    9542,  5, }, // America/Chihuahua
    {   13, 7774,    9547,  9, }, // America/Ciudad_Juarez
    {   13, 5441,    9556,  5, }, // America/Costa_Rica
    {   13, 7814,    9561,  5, }, // America/Creston
    {   13, 3810,    9566,  4, }, // America/Cuiaba
    {   13, 5742,    9570,  4, }, // America/Curacao
    {   13, 7830,    9574,  8, }, // America/Danmarkshavn
    {   13, 7851,    9582,  4, }, // America/Dawson
    {   13, 7866,    9586,  8, }, // America/Dawson_Creek
    {   13,  805,    9594,  4, }, // America/Denver
    {   13, 3484,    9598,  5, }, // America/Detroit
    {   13, 5758,    9603,  4, }, // America/Dominica
    {   13,  893,    9607,  6, }, // America/Edmonton
    {   13, 7887,    9613,  4, }, // America/Eirunepe
    {   13, 5460,    9617,  7, }, // America/El_Salvador
    {   13, 7904,    9624,  8, }, // America/Fort_Nelson
    {   13, 7924,    9632,  5, }, // America/Fortaleza
    {   13, 7942,    9637,  6, }, // America/Glace_Bay
    {   13, 6900,    9643,  5, }, // America/Goose_Bay
    {   13, 4631,    9648,  8, }, // America/Grand_Turk
    {   13, 5789,    9656,  4, }, // America/Grenada
    {   13, 5805,    9660,  4, }, // America/Guadeloupe
    {   13, 3779,    9664,  4, }, // America/Guatemala
    {   13, 4860,    9668,  5, }, // America/Guayaquil
    {   13, 6951,    9673,  3, }, // America/Guyana
    {   13, 1941,    9676,  5, }, // America/Halifax
    {   13, 2283,    9681,  3, }, // America/Havana
    {   13, 7960,    9684,  5, }, // America/Hermosillo
    {   13,  348,    9689,  8, }, // America/Indiana/Indianapolis
    {   13,  481,    9697, 10, }, // America/Indiana/Knox
    {   13, 7979,    9707, 11, }, // America/Indiana/Marengo
    {   13, 8003,    9718, 14, }, // America/Indiana/Petersburg
    {   13, 8030,    9732, 13, }, // America/Indiana/Tell_City
    {   13, 8056,    9745, 10, }, // America/Indiana/Vevay
    {   13, 8078,    9755, 12, }, // America/Indiana/Vincennes
    {   13, 8104,    9767, 11, }, // America/Indiana/Winamac
    {   13, 8128,    9778,  4, }, // America/Inuvik
    {   13,  660,    9782,  5, }, // America/Iqaluit
    {   13, 2801,    9787,  4, }, // America/Jamaica
    {   13, 5399,    9791,  3, }, // America/Juneau
    {   13,  521,    9794,  5, }, // America/Kentucky/Louisville
    {   13, 8143,    9799, 11, }, // America/Kentucky/Monticello
    {   13, 5723,    9810,  7, }, // America/Kralendijk
    {   13, 4395,    9817,  4, }, // America/La_Paz
    {   13, 7169,    9821,  2, }, // America/Lima
    {   13, 3258,    9823,  8, }, // America/Los_Angeles
    {   13, 5951,    9831, 12, }, // America/Lower_Princes
    {   13, 8171,    9843,  3, }, // America/Maceio
    {   13, 8186,    9846,  4, }, // America/Managua
    {   13, 1910,    9850,  4, }, // America/Manaus
    {   13, 5916,    9854,  4, }, // America/Marigot
    {   13, 5824,    9858,  5, }, // America/Martinique
    {   13, 8202,    9863,  5, }, // America/Matamoros
    {   13, 2919,    9868,  5, }, // America/Mazatlan
    {   13, 8220,    9873,  4, }, // America/Menominee
    {   13, 8238,    9877,  3, }, // America/Merida
    {   13, 8253,    9880,  6, }, // America/Metlakatla
    {   13, 2951,    9886,  8, }, // America/Mexico_City
    {   13, 4410,    9894,  5, }, // America/Miquelon
    {   13, 8272,    9899,  5, }, // America/Moncton
    {   13, 8288,    9904,  6, }, // America/Monterrey
    {   13, 4117,    9910,  6, }, // America/Montevideo
    {   13, 5843,    9916,  6, }, // America/Montserrat
    {   13, 5500,    9922,  3, }, // America/Nassau
    {   13, 2381,    9925,  5, }, // America/New_York
    {   13, 8306,    9930,  2, }, // America/Nome
    {   13, 1852,    9932,  3, }, // America/Noronha
    {   13, 8319,    9935, 13, }, // America/North_Dakota/Beulah
    {   13, 8347,    9948, 14, }, // America/North_Dakota/Center
    {   13, 8375,    9962, 16, }, // America/North_Dakota/New_Salem
    {   13,  393,    9978,  4, }, // America/Nuuk
    {   13, 8406,    9982,  4, }, // America/Ojinaga
    {   13, 2358,    9986,  3, }, // America/Panama
    {   13, 6192,    9989,  5, }, // America/Paramaribo
    {   13, 2975,    9994,  4, }, // America/Phoenix
    {   13, 3964,    9998, 10, }, // America/Port-au-Prince
    {   13, 5973,   10008,  9, }, // America/Port_of_Spain
    {   13, 8422,   10017,  7, }, // America/Porto_Velho
    {   13, 5862,   10024,  5, }, // America/Puerto_Rico
    {   13, 4049,   10029,  8, }, // America/Punta_Arenas
    {   13, 8442,   10037,  9, }, // America/Rankin_Inlet
    {   13, 8463,   10046,  3, }, // America/Recife
    {   13, 1997,   10049,  3, }, // America/Regina
    {   13, 8478,   10052,  5, }, // America/Resolute
    {   13,  695,   10057,  7, }, // America/Rio_Branco
    {   13, 8495,   10064,  5, }, // America/Santarem
    {   13, 2203,   10069,  5, }, // America/Santiago
    {   13, 6130,   10074,  8, }, // America/Santo_Domingo
    {   13, 1880,   10082,  5, }, // America/Sao_Paulo
    {   13, 6918,   10087,  9, }, // America/Scoresbysund
    {   13, 8512,   10096,  3, }, // America/Sitka
    {   13, 8526,   10099, 10, }, // America/St_Barthelemy
    {   13, 2063,   10109,  8, }, // America/St_Johns
    {   13, 5882,   10117,  7, }, // America/St_Kitts
    {   13, 5899,   10124,  8, }, // America/St_Lucia
    {   13,  855,   10132,  7, }, // America/St_Thomas
    {   13, 5932,   10139,  9, }, // America/St_Vincent
    {   13, 8548,   10148,  9, }, // America/Swift_Current
    {   13, 5480,   10157,  6, }, // America/Tegucigalpa
    {   13, 5775,   10163,  2, }, // America/Thule
    {   13,  313,   10165,  4, }, // America/Tijuana
    {   13,  608,   10169,  4, }, // America/Toronto
    {   13, 5707,   10173,  4, }, // America/Tortola
    {   13, 2095,   10177,  5, }, // America/Vancouver
    {   13, 2146,   10182,  6, }, // America/Whitehorse
    {   13,  734,   10188,  4, }, // America/Winnipeg
    {   13, 8570,   10192,  4, }, // America/Yakutat
    {   13, 6020,   10196,  3, }, // Antarctica/Casey
    {   13, 6113,   10199,  3, }, // Antarctica/Davis
    {   13, 6152,   10202, 10, }, // Antarctica/DumontDUrville
    {   13, 8586,   10212,  3, }, // Antarctica/Macquarie
    {   13, 7085,   10215,  4, }, // Antarctica/Mawson
    {   13,  932,   10219,  5, }, // Antarctica/McMurdo
    {   13, 8607,   10224,  4, }, // Antarctica/Palmer
    {   13, 7226,   10228,  3, }, // Antarctica/Rothera
    {   13, 7295,   10231,  3, }, // Antarctica/Syowa
    {   13, 8625,   10234,  3, }, // Antarctica/Troll
    {   13, 7374,   10237,  4, }, // Antarctica/Vostok
    {   13, 1431,   10241,  8, }, // Arctic/Longyearbyen
    {   13, 5589,   10249,  3, }, // Asia/Aden
    {   13, 5414,   10252,  5, }, // Asia/Almaty
    {   13, 3987,   10257,  3, }, // Asia/Amman
    {   13, 5530,   10260,  5, }, // Asia/Anadyr
    {   13, 5542,   10265,  4, }, // Asia/Aqtau
    {   13, 5387,   10269,  4, }, // Asia/Aqtobe
    {   13,  966,   10273,  5, }, // Asia/Ashgabat
    {   13, 8642,   10278,  5, }, // Asia/Atyrau
    {   13, 3626,   10283,  4, }, // Asia/Baghdad
    {   13, 5553,   10287,  4, }, // Asia/Bahrain
    {   13, 3672,    9569,  2, }, // Asia/Baku
    {   13, 4485,   10291,  4, }, // Asia/Bangkok
    {   13, 3590,   10295,  5, }, // Asia/Barnaul
    {   13, 4105,   10300,  3, }, // Asia/Beirut
    {   13, 3797,   10303,  4, }, // Asia/Bishkek
    {   13, 6008,   10307,  4, }, // Asia/Brunei
    {   13, 4620,   10311,  2, }, // Asia/Chita
    {   13, 4530,   10313,  4, }, // Asia/Colombo
    {   13, 4559,   10317,  4, }, // Asia/Damascus
    {   13, 1095,    9219,  2, }, // Asia/Dhaka
    {   13, 6211,   10321,  2, }, // Asia/Dili
    {   13, 3615,   10323,  3, }, // Asia/Dubai
    {   13, 6178,   10326,  4, }, // Asia/Dushanbe
    {   13, 8654,   10330,  5, }, // Asia/Famagusta
    {   13, 8669,   10335,  2, }, // Asia/Gaza
    {   13, 4814,   10337,  4, }, // Asia/Hebron
    {   13, 1261,   10341, 11, }, // Asia/Ho_Chi_Minh
    {   13, 2706,   10352,  7, }, // Asia/Hong_Kong
    {   13, 4790,   10359,  3, }, // Asia/Hovd
    {   13, 4203,   10362,  6, }, // Asia/Irkutsk
    {   13, 7025,   10368,  4, }, // Asia/Jakarta
    {   13, 7011,   10372,  4, }, // Asia/Jayapura
    {   13, 1292,   10376,  6, }, // Asia/Jerusalem
    {   13, 3579,   10382,  3, }, // Asia/Kabul
    {   13, 4335,   10385,  5, }, // Asia/Kamchatka
    {   13, 4258,   10390,  3, }, // Asia/Karachi
    {   13, 1187,   10393,  5, }, // Asia/Kathmandu
    {   13, 8679,   10398,  4, }, // Asia/Khandyga
    {   13,  994,   10402,  4, }, // Asia/Kolkata
    {   13, 4216,   10406,  8, }, // Asia/Krasnoyarsk
    {   13, 4878,   10414,  8, }, // Asia/Kuala_Lumpur
    {   13, 5995,   10422,  4, }, // Asia/Kuching
    {   13, 5566,   10426,  3, }, // Asia/Kuwait
    {   13, 1213,   10429,  3, }, // Asia/Macau
    {   13, 4036,   10432,  4, }, // Asia/Magadan
    {   13, 1351,   10436,  4, }, // Asia/Makassar
    {   13, 7182,   10440,  3, }, // Asia/Manila
    {   13, 6939,   10443,  4, }, // Asia/Muscat
    {   13, 2556,   10447,  4, }, // Asia/Nicosia
    {   13, 8693,   10451,  7, }, // Asia/Novokuznetsk
    {   13, 4154,   10458,  7, }, // Asia/Novosibirsk
    {   13, 4248,   10465,  4, }, // Asia/Omsk
    {   13, 7145,   10469,  3, }, // Asia/Oral
    {   13, 6980,   10472,  7, }, // Asia/Phnom_Penh
    {   13, 8711,   10479,  6, }, // Asia/Pontianak
    {   13, 4233,   10485,  7, }, // Asia/Pyongyang
    {   13, 5578,   10492,  3, }, // Asia/Qatar
    {   13, 8726,   10495,  5, }, // Asia/Qostanay
    {   13, 4288,   10500,  6, }, // Asia/Qyzylorda
    {   13, 3603,   10506,  3, }, // Asia/Riyadh
    {   13, 4427,   10509,  5, }, // Asia/Sakhalin
    {   13, 7245,   10514,  6, }, // Asia/Samarkand
    {   13, 3298,   10520,  3, }, // Asia/Seoul
    {   13, 1055,   10523,  4, }, // Asia/Shanghai
    {   13, 3319,   10527,  5, }, // Asia/Singapore
    {   13, 4316,   10532, 10, }, // Asia/Srednekolymsk
    {   13, 3282,   10542,  4, }, // Asia/Taipei
    {   13, 4800,   10546,  5, }, // Asia/Tashkent
    {   13, 3934,   10551,  4, }, // Asia/Tbilisi
    {   13, 2774,   10555,  4, }, // Asia/Tehran
    {   13, 1319,   10559,  3, }, // Asia/Thimphu
    {   13, 2823,   10562,  3, }, // Asia/Tokyo
    {   13, 4591,   10565,  4, }, // Asia/Tomsk
    {   13, 1023,   10569,  8, }, // Asia/Ulaanbaatar
    {   13, 1161,   10577,  4, }, // Asia/Urumqi
    {   13, 8740,   10581,  6, }, // Asia/Ust-Nera
    {   13, 6996,   10587,  5, }, // Asia/Vientiane
    {   13, 4729,   10592,  7, }, // Asia/Vladivostok
    {   13, 4847,   10599,  5, }, // Asia/Yakutsk
    {   13, 1237,   10604,  4, }, // Asia/Yangon
    {   13, 3902,   10608,  8, }, // Asia/Yekaterinburg
    {   13, 3766,   10616,  4, }, // Asia/Yerevan
    {   13, 3682,   10620,  4, }, // Atlantic/Azores
    {   13, 5690,   10624,  4, }, // Atlantic/Bermuda
    {   13, 6647,   10628,  3, }, // Atlantic/Canary
    {   13, 3746,   10631,  6, }, // Atlantic/Cape_Verde
    {   13, 1397,   10637,  3, }, // Atlantic/Faroe
    {   13, 8754,   10640,  3, }, // Atlantic/Madeira
    {   13, 2750,   10643,  6, }, // Atlantic/Reykjavik
    {   13, 7272,   10649,  8, }, // Atlantic/South_Georgia
    {   13, 6840,   10657,  8, }, // Atlantic/St_Helena
    {   13, 6663,   10665,  5, }, // Atlantic/Stanley
    {   13, 1672,   10670,  5, }, // Australia/Adelaide
    {   13, 1637,   10675,  5, }, // Australia/Brisbane
    {   13, 1801,   10680,  7, }, // Australia/Broken_Hill
    {   13, 1585,   10687,  4, }, // Australia/Darwin
    {   13, 3656,   10691,  3, }, // Australia/Eucla
    {   13, 1518,   10694,  4, }, // Australia/Hobart
    {   13, 8771,   10698,  5, }, // Australia/Lindeman
    {   13, 1549,   10703,  6, }, // Australia/Lord_Howe
    {   13, 1729,   10709,  5, }, // Australia/Melbourne
    {   13, 1764,   10714,  3, }, // Australia/Perth
    {   13, 1465,   10717,  3, }, // Australia/Sydney
    {   13, 6460,   10720,  7, }, // Europe/Amsterdam
    {   13, 6235,   10727,  4, }, // Europe/Andorra
    {   13, 3639,   10731,  7, }, // Europe/Astrakhan
    {   13, 2302,   10738,  4, }, // Europe/Athens
    {   13, 6355,   10742,  5, }, // Europe/Belgrade
    {   13, 4776,   10747,  4, }, // Europe/Berlin
    {   13, 6507,   10751,  6, }, // Europe/Bratislava
    {   13, 2169,   10757,  5, }, // Europe/Brussels
    {   13, 3947,   10762,  5, }, // Europe/Bucharest
    {   13, 3825,   10767,  5, }, // Europe/Budapest
    {   13, 8790,   10772,  5, }, // Europe/Busingen
    {   13, 2585,   10777,  4, }, // Europe/Chisinau
    {   13, 6308,   10781,  6, }, // Europe/Copenhagen
    {   13, 2340,   10787,  4, }, // Europe/Dublin
    {   13, 6326,   10791,  6, }, // Europe/Gibraltar
    {   13, 8806,   10797,  4, }, // Europe/Guernsey
    {   13, 6631,   10801,  5, }, // Europe/Helsinki
    {   13, 8822,   10806, 10, }, // Europe/Isle_of_Man
    {   13, 1132,   10816,  6, }, // Europe/Istanbul
    {   13, 8841,   10822,  3, }, // Europe/Jersey
    {   13, 3998,   10825,  7, }, // Europe/Kaliningrad
    {   13, 8855,   10832,  3, }, // Europe/Kirov
    {   13, 2529,   10835,  3, }, // Europe/Kyiv
    {   13, 3232,   10838,  4, }, // Europe/Lisbon
    {   13, 6525,   10842,  6, }, // Europe/Ljubljana
    {   13, 2503,   10848,  4, }, // Europe/London
    {   13, 6384,   10852,  7, }, // Europe/Luxembourg
    {   13, 4911,   10859,  4, }, // Europe/Madrid
    {   13, 6416,   10863,  3, }, // Europe/Malta
    {   13, 6601,   10866,  5, }, // Europe/Mariehamn
    {   13, 3712,   10871,  4, }, // Europe/Minsk
    {   13, 6429,   10875,  3, }, // Europe/Monaco
    {   13, 3556,   10878,  3, }, // Europe/Moscow
    {   13, 6477,   10881,  3, }, // Europe/Oslo
    {   13, 4303,   10884,  3, }, // Europe/Paris
    {   13, 6443,   10887,  5, }, // Europe/Podgorica
    {   13, 6294,   10892,  3, }, // Europe/Prague
    {   13, 8868,   10895,  2, }, // Europe/Riga
    {   13, 6343,   10897,  2, }, // Europe/Rome
    {   13, 4350,   10899,  3, }, // Europe/Samara
    {   13, 6489,   10902,  6, }, // Europe/San_Marino
    {   13, 6264,   10908,  4, }, // Europe/Sarajevo
    {   13, 4470,   10912,  4, }, // Europe/Saratov
    {   13, 8880,   10916,  6, }, // Europe/Simferopol
    {   13, 6402,   10922,  4, }, // Europe/Skopje
    {   13, 6618,   10926,  3, }, // Europe/Sofia
    {   13, 6542,   10929,  6, }, // Europe/Stockholm
    {   13, 8898,   10935,  3, }, // Europe/Tallinn
    {   13, 6221,   10938,  3, }, // Europe/Tirane
    {   13, 8913,   10941,  7, }, // Europe/Ulyanovsk
    {   13, 6371,   10948,  3, }, // Europe/Vaduz
    {   13, 6586,   10951,  4, }, // Europe/Vatican
    {   13, 6250,   10955,  3, }, // Europe/Vienna
    {   13, 8930,   10958,  4, }, // Europe/Vilnius
    {   13, 4746,   10962,  5, }, // Europe/Volgograd
    {   13, 3209,   10967,  4, }, // Europe/Warsaw
    {   13, 6280,   10971,  4, }, // Europe/Zagreb
    {   13, 6559,   10975,  3, }, // Europe/Zurich
    {   13, 5097,   10978,  7, }, // Indian/Antananarivo
    {   13, 6966,   10985,  3, }, // Indian/Chagos
    {   13, 6065,   10988,  2, }, // Indian/Christmas
    {   13, 6082,   10990,  3, }, // Indian/Cocos
    {   13, 5048,   10993,  3, }, // Indian/Comoro
    {   13, 6680,   10996,  5, }, // Indian/Kerguelen
    {   13, 7260,   11001,  2, }, // Indian/Mahe
    {   13, 7069,   11003,  4, }, // Indian/Maldives
    {   13, 4088,   11007,  5, }, // Indian/Mauritius
    {   13, 5117,   11012,  3, }, // Indian/Mayotte
    {   13, 7211,   11015,  5, }, // Indian/Reunion
    {   13, 4441,   11020,  3, }, // Pacific/Apia
    {   13, 3009,   11023,  5, }, // Pacific/Auckland
    {   13, 3725,   11028,  6, }, // Pacific/Bougainville
    {   13, 3034,   11034,  3, }, // Pacific/Chatham
    {   13, 3176,   11037,  2, }, // Pacific/Chuuk
    {   13, 2239,   11039,  3, }, // Pacific/Easter
    {   13, 7360,   11042,  3, }, // Pacific/Efate
    {   13, 7327,   11045,  4, }, // Pacific/Fakaofo
    {   13, 3921,   11049,  2, }, // Pacific/Fiji
    {   13, 7343,   11051,  4, }, // Pacific/Funafuti
    {   13, 6697,   11055,  5, }, // Pacific/Galapagos
    {   13, 6715,   11060,  5, }, // Pacific/Gambier
    {   13, 3841,   11065,  7, }, // Pacific/Guadalcanal
    {   13, 6037,   11072,  3, }, // Pacific/Guam
    {   13, 2725,   11075,  4, }, // Pacific/Honolulu
    {   13, 3068,   11079,  4, }, // Pacific/Kanton
    {   13, 4017,   11083,  5, }, // Pacific/Kiritimati
    {   13, 7038,   11088,  3, }, // Pacific/Kosrae
    {   13, 2844,   11091,  5, }, // Pacific/Kwajalein
    {   13, 4896,   11096,  3, }, // Pacific/Majuro
    {   13, 4070,   11099,  6, }, // Pacific/Marquesas
    {   13, 8945,   11105,  4, }, // Pacific/Midway
    {   13, 7103,   11109,  3, }, // Pacific/Nauru
    {   13, 7132,   11112,  2, }, // Pacific/Niue
    {   13, 4187,   11114,  5, }, // Pacific/Norfolk
    {   13, 7117,   11119,  4, }, // Pacific/Noumea
    {   13, 3145,   11123,  5, }, // Pacific/Pago_Pago
    {   13, 7155,   11128,  3, }, // Pacific/Palau
    {   13, 7194,   11131,  6, }, // Pacific/Pitcairn
    {   13, 3115,   11137,  4, }, // Pacific/Pohnpei
    {   13, 4826,   11141,  9, }, // Pacific/Port_Moresby
    {   13, 6095,   11150,  5, }, // Pacific/Rarotonga
    {   13, 6050,   11155,  4, }, // Pacific/Saipan
    {   13, 7312,   11159,  3, }, // Pacific/Tahiti
    {   13, 6731,   11162,  3, }, // Pacific/Tarawa
    {   13, 4602,   11165,  5, }, // Pacific/Tongatapu
    {   13, 7392,   11170,  2, }, // Pacific/Wake
    {   13, 7405,   11172,  3, }, // Pacific/Wallis
    {   14, 6807,   11175,  7, }, // Africa/Abidjan Arabic/Arabic/Egypt
    {   14, 6779,   11182,  4, }, // Africa/Accra
    {   14, 5078,   11186, 10, }, // Africa/Addis_Ababa
    {   14, 7420,   11196,  7, }, // Africa/Algiers
    {   14,   14,   11203,  5, }, // Africa/Asmara
    {   14,   44,   11208,  6, }, // Africa/Bamako
    {   14, 5276,   11214,  6, }, // Africa/Bangui
    {   14, 6765,   11220,  6, }, // Africa/Banjul
    {   14, 7435,   11226,  5, }, // Africa/Bissau
    {   14, 4976,   11231,  8, }, // Africa/Blantyre
    {   14, 5306,   11239,  8, }, // Africa/Brazzaville
    {   14, 4941,   11247,  9, }, // Africa/Bujumbura
    {   14, 2322,   11256,  7, }, // Africa/Cairo
    {   14, 4136,   11263, 13, }, // Africa/Casablanca
    {   14, 7449,   11276,  4, }, // Africa/Ceuta
    {   14, 6792,   11280,  7, }, // Africa/Conakry
    {   14, 6859,   11287,  5, }, // Africa/Dakar
    {   14, 5149,   11292, 10, }, // Africa/Dar_es_Salaam
    {   14, 5062,   11302,  6, }, // Africa/Djibouti
    {   14, 5262,   11308,  5, }, // Africa/Douala
    {   14, 5185,   11313,  6, }, // Africa/El_Aaiun
    {   14, 6872,   11319,  8, }, // Africa/Freetown
    {   14, 4925,   11327,  7, }, // Africa/Gaborone
    {   14, 5034,   11334,  5, }, // Africa/Harare
    {   14, 4498,   11339,  9, }, // Africa/Johannesburg
    {   14, 4518,   11348,  4, }, // Africa/Juba
    {   14, 5170,   11352,  7, }, // Africa/Kampala
    {   14, 4543,   11359,  7, }, // Africa/Khartoum
    {   14, 4992,   11366,  6, }, // Africa/Kigali
    {   14, 5325,   11372,  7, }, // Africa/Kinshasa
    {   14, 4763,   11379,  5, }, // Africa/Lagos
    {   14, 5355,   11384,  7, }, // Africa/Libreville
    {   14, 6888,   11391,  4, }, // Africa/Lome
    {   14, 5230,   11395,  6, }, // Africa/Luanda
    {   14, 4958,   11401,  8, }, // Africa/Lubumbashi
    {   14, 5020,   11409,  6, }, // Africa/Lusaka
    {   14, 5341,   11415,  6, }, // Africa/Malabo
    {   14, 5006,   11421,  6, }, // Africa/Maputo
    {   14, 5216,   11427,  6, }, // Africa/Maseru
    {   14, 5201,   11433,  7, }, // Africa/Mbabane
    {   14, 5132,   11440,  7, }, // Africa/Mogadishu
    {   14, 7053,   11447,  8, }, // Africa/Monrovia
    {   14, 3872,   11455,  6, }, // Africa/Nairobi
    {   14, 5290,   11461,  7, }, // Africa/Ndjamena
    {   14, 5373,   11468,  5, }, // Africa/Niamey
    {   14, 6822,   11473,  7, }, // Africa/Nouakchott
    {   14, 6746,   11480,  8, }, // Africa/Ouagadougou
    {   14, 5244,   11488, 10, }, // Africa/Porto-Novo
    {   14, 4454,   11498,  8, }, // Africa/Sao_Tome
    {   14, 2868,   11506,  6, }, // Africa/Tripoli
    {   14, 6573,   11512,  4, }, // Africa/Tunis
    {   14, 4171,   11516,  7, }, // Africa/Windhoek
    {   14,  132,   11523,  4, }, // America/Adak
    {   14, 3365,   11527,  7, }, // America/Anchorage
    {   14, 5626,   11534,  7, }, // America/Anguilla
    {   14, 5643,   11541,  7, }, // America/Antigua
    {   14, 4573,   11548,  9, }, // America/Araguaina
    {   14,  166,   11557, 11, }, // America/Argentina/Buenos_Aires
    {   14,   91,   11568,  9, }, // America/Argentina/Catamarca
    {   14,  270,   11577,  7, }, // America/Argentina/Cordoba
    {   14,  441,   11584,  4, }, // America/Argentina/Jujuy
    {   14, 7462,   11588,  8, }, // America/Argentina/La_Rioja
    {   14,  565,   11596,  7, }, // America/Argentina/Mendoza
    {   14, 7489,   11603, 11, }, // America/Argentina/Rio_Gallegos
    {   14, 7520,   11614,  5, }, // America/Argentina/Salta
    {   14, 7544,   11619,  8, }, // America/Argentina/San_Juan
    {   14, 5599,   11627,  8, }, // America/Argentina/San_Luis
    {   14, 7571,   11635,  6, }, // America/Argentina/Tucuman
    {   14, 7597,   11641,  4, }, // America/Argentina/Ushuaia
    {   14, 5659,   11645,  5, }, // America/Aruba
    {   14, 4271,   11650,  8, }, // America/Asuncion
    {   14,  237,   11658, 11, }, // America/Atikokan
    {   14, 3698,   11669,  5, }, // America/Bahia
    {   14, 7623,   11674, 14, }, // America/Bahia_Banderas
    {   14, 5673,   11688,  7, }, // America/Barbados
    {   14, 7646,   11695,  3, }, // America/Belem
    {   14, 5426,   11698,  4, }, // America/Belize
    {   14, 7660,   11702, 12, }, // America/Blanc-Sablon
    {   14, 7681,   11714,  9, }, // America/Boa_Vista
    {   14, 4380,   11723,  6, }, // America/Bogota
    {   14, 7699,   11729,  4, }, // America/Boise
    {   14, 7713,   11733, 12, }, // America/Cambridge_Bay
    {   14, 7735,   11745, 11, }, // America/Campo_Grande
    {   14, 3887,   11756,  6, }, // America/Cancun
    {   14, 4713,   11762,  7, }, // America/Caracas
    {   14, 4364,   11769,  5, }, // America/Cayenne
    {   14, 5515,   11774,  6, }, // America/Cayman
    {   14, 2262,   11780,  6, }, // America/Chicago
    {   14, 7756,   11786,  7, }, // America/Chihuahua
    {   14, 7774,   11793, 13, }, // America/Ciudad_Juarez
    {   14, 5441,   11806,  9, }, // America/Costa_Rica
    {   14, 7796,   11815,  9, }, // America/Coyhaique
    {   14, 7814,   11824,  7, }, // America/Creston
    {   14, 3810,   11831,  5, }, // America/Cuiaba
    {   14, 5742,   11836,  7, }, // America/Curacao
    {   14, 7830,   11843, 11, }, // America/Danmarkshavn
    {   14, 7851,   11854,  6, }, // America/Dawson
    {   14, 7866,   11860, 10, }, // America/Dawson_Creek
    {   14,  805,   11870,  4, }, // America/Denver
    {   14, 3484,   11874,  7, }, // America/Detroit
    {   14, 5758,   11881,  8, }, // America/Dominica
    {   14,  893,   11889,  9, }, // America/Edmonton
    {   14, 7887,   11898,  7, }, // America/Eirunepe
    {   14, 5460,   11905,  9, }, // America/El_Salvador
    {   14, 7904,   11914, 11, }, // America/Fort_Nelson
    {   14, 7924,   11925,  9, }, // America/Fortaleza
    {   14, 7942,   11934,  8, }, // America/Glace_Bay
    {   14, 6900,   11942,  7, }, // America/Goose_Bay
    {   14, 4631,   11949,  9, }, // America/Grand_Turk
    {   14, 5789,   11958,  7, }, // America/Grenada
    {   14, 5805,   11965,  7, }, // America/Guadeloupe
    {   14, 3779,   11972,  9, }, // America/Guatemala
    {   14, 4860,   11981,  9, }, // America/Guayaquil
    {   14, 6951,   11990,  5, }, // America/Guyana
    {   14, 1941,   11995,  8, }, // America/Halifax
    {   14, 2283,   12003,  6, }, // America/Havana
    {   14, 7960,   12009,  9, }, // America/Hermosillo
    {   14,  348,   12018, 12, }, // America/Indiana/Indianapolis
    {   14,  481,   12030,  5, }, // America/Indiana/Knox
    {   14, 7979,   12035,  6, }, // America/Indiana/Marengo
    {   14, 8003,   12041,  8, }, // America/Indiana/Petersburg
    {   14, 8030,   12049, 17, }, // America/Indiana/Tell_City
    {   14, 8056,   12066,  5, }, // America/Indiana/Vevay
    {   14, 8078,   12071,  7, }, // America/Indiana/Vincennes
    {   14, 8104,   12078,  7, }, // America/Indiana/Winamac
    {   14, 8128,   12085,  7, }, // America/Inuvik
    {   14,  660,   12092,  6, }, // America/Iqaluit
    {   14, 2801,   12098,  7, }, // America/Jamaica
    {   14, 5399,   12105,  4, }, // America/Juneau
    {   14,  521,   12109,  8, }, // America/Kentucky/Louisville
    {   14, 8143,   12117,  9, }, // America/Kentucky/Monticello
    {   14, 5723,   12126,  8, }, // America/Kralendijk
    {   14, 4395,   12134,  6, }, // America/La_Paz
    {   14, 7169,   12140,  4, }, // America/Lima
    {   14, 3258,   12144, 10, }, // America/Los_Angeles
    {   14, 5951,   12154, 16, }, // America/Lower_Princes
    {   14, 8171,   12170,  5, }, // America/Maceio
    {   14, 8186,   12175,  7, }, // America/Managua
    {   14, 1910,   12182,  6, }, // America/Manaus
    {   14, 5916,   12188,  7, }, // America/Marigot
    {   14, 5824,   12195, 10, }, // America/Martinique
    {   14, 8202,   12205,  9, }, // America/Matamoros
    {   14, 2919,   12214,  8, }, // America/Mazatlan
    {   14, 8220,   12222,  8, }, // America/Menominee
    {   14, 8238,   12230,  6, }, // America/Merida
    {   14, 8253,   12236, 10, }, // America/Metlakatla
    {   14, 2951,   12246, 11, }, // America/Mexico_City
    {   14, 4410,   12257,  7, }, // America/Miquelon
    {   14, 8272,   12264,  7, }, // America/Moncton
    {   14, 8288,   12271,  7, }, // America/Monterrey
    {   14, 4117,   12278,  9, }, // America/Montevideo
    {   14, 5843,   12287,  9, }, // America/Montserrat
    {   14, 5500,   12296,  4, }, // America/Nassau
    {   14, 2381,   12300,  7, }, // America/New_York
    {   14, 8306,   12224,  3, }, // America/Nome
    {   14, 1852,   12307,  7, }, // America/Noronha
    {   14, 8319,   12314, 22, }, // America/North_Dakota/Beulah
    {   14, 8347,   12336,  4, }, // America/North_Dakota/Center
    {   14, 8375,   12340,  9, }, // America/North_Dakota/New_Salem
    {   14,  393,   12349,  6, }, // America/Nuuk
    {   14, 8406,   12355,  8, }, // America/Ojinaga
    {   14, 2358,   12363,  4, }, // America/Panama
    {   14, 6192,   12367, 10, }, // America/Paramaribo
    {   14, 2975,   12377,  5, }, // America/Phoenix
    {   14, 3964,   12382, 12, }, // America/Port-au-Prince
    {   14, 5973,   12394, 13, }, // America/Port_of_Spain
    {   14, 8422,   12407, 10, }, // America/Porto_Velho
    {   14, 5862,   12417,  9, }, // America/Puerto_Rico
    {   14, 4049,   12426, 12, }, // America/Punta_Arenas
    {   14, 8442,   12438, 10, }, // America/Rankin_Inlet
    {   14, 8463,   12448,  5, }, // America/Recife
    {   14, 1997,   12453,  6, }, // America/Regina
    {   14, 8478,   12459,  7, }, // America/Resolute
    {   14,  695,   12466,  9, }, // America/Rio_Branco
    {   14, 8495,   12475,  8, }, // America/Santarem
    {   14, 2203,   12483,  8, }, // America/Santiago
    {   14, 6130,   12491, 13, }, // America/Santo_Domingo
    {   14, 1880,   12504,  9, }, // America/Sao_Paulo
    {   14, 6918,   12513, 10, }, // America/Scoresbysund
    {   14, 8512,   12523,  5, }, // America/Sitka
    {   14, 8526,   12528, 14, }, // America/St_Barthelemy
    {   14, 2063,   12542,  9, }, // America/St_Johns
    {   14, 5882,   12551,  9, }, // America/St_Kitts
    {   14, 5899,   12560, 10, }, // America/St_Lucia
    {   14,  855,   12570, 10, }, // America/St_Thomas
    {   14, 5932,   12580, 10, }, // America/St_Vincent
    {   14, 8548,   12590, 10, }, // America/Swift_Current
    {   14, 5480,   12600, 11, }, // America/Tegucigalpa
    {   14, 5775,   12611,  3, }, // America/Thule
    {   14,  313,   12614,  7, }, // America/Tijuana
    {   14,  608,   12621,  7, }, // America/Toronto
    {   14, 5707,   12628,  7, }, // America/Tortola
    {   14, 2095,   12635,  7, }, // America/Vancouver
    {   14, 2146,   12642,  9, }, // America/Whitehorse
    {   14,  734,   12651,  7, }, // America/Winnipeg
    {   14, 8570,   12658,  7, }, // America/Yakutat
    {   14, 6020,   12665,  5, }, // Antarctica/Casey
    {   14, 6113,   12670,  5, }, // Antarctica/Davis
    {   14, 6152,   12675, 16, }, // Antarctica/DumontDUrville
    {   14, 8586,   12691,  7, }, // Antarctica/Macquarie
    {   14, 7085,   12698,  6, }, // Antarctica/Mawson
    {   14,  932,   12704,  9, }, // Antarctica/McMurdo
    {   14, 8607,   12713,  6, }, // Antarctica/Palmer
    {   14, 7226,   12719,  6, }, // Antarctica/Rothera
    {   14, 7295,   12725,  6, }, // Antarctica/Syowa
    {   14, 8625,   12731,  4, }, // Antarctica/Troll
    {   14, 7374,   12735,  6, }, // Antarctica/Vostok
    {   14, 1431,   12741,  9, }, // Arctic/Longyearbyen
    {   14, 5589,   12750,  3, }, // Asia/Aden
    {   14, 5414,   12753,  6, }, // Asia/Almaty
    {   14, 3987,   12759,  5, }, // Asia/Amman
    {   14, 5530,   12764,  5, }, // Asia/Anadyr
    {   14, 5542,   12769,  5, }, // Asia/Aqtau
    {   14, 5387,   12774,  5, }, // Asia/Aqtobe
    {   14,  966,   12779,  8, }, // Asia/Ashgabat
    {   14, 8642,   12787,  6, }, // Asia/Atyrau
    {   14, 3626,   12793,  5, }, // Asia/Baghdad
    {   14, 5553,   12798,  7, }, // Asia/Bahrain
    {   14, 3672,   11834,  4, }, // Asia/Baku
    {   14, 4485,   12805,  6, }, // Asia/Bangkok
    {   14, 3590,   12811,  7, }, // Asia/Barnaul
    {   14, 4105,   12818,  5, }, // Asia/Beirut
    {   14, 3797,   12823,  5, }, // Asia/Bishkek
    {   14, 6008,   12828,  6, }, // Asia/Brunei
    {   14, 4620,   12834,  5, }, // Asia/Chita
    {   14, 4530,   12839,  7, }, // Asia/Colombo
    {   14, 4559,   12846,  4, }, // Asia/Damascus
    {   14, 1095,   11755,  3, }, // Asia/Dhaka
    {   14, 6211,   12850,  4, }, // Asia/Dili
    {   14, 3615,   12854,  3, }, // Asia/Dubai
    {   14, 6178,   12857,  7, }, // Asia/Dushanbe
    {   14, 8654,   12864,  9, }, // Asia/Famagusta
    {   14, 8669,   12873,  3, }, // Asia/Gaza
    {   14, 4814,   12876, 21, }, // Asia/Hebron
    {   14, 1261,   12897, 16, }, // Asia/Ho_Chi_Minh
    {   14, 2706,   12913,  9, }, // Asia/Hong_Kong
    {   14, 4790,   12922,  4, }, // Asia/Hovd
    {   14, 4203,   12926,  8, }, // Asia/Irkutsk
    {   14, 7025,   12934,  6, }, // Asia/Jakarta
    {   14, 7011,   12940,  9, }, // Asia/Jayapura
    {   14, 1292,   12949,  5, }, // Asia/Jerusalem
    {   14, 3579,   12954,  5, }, // Asia/Kabul
    {   14, 4335,   12959,  9, }, // Asia/Kamchatka
    {   14, 4258,   12968,  6, }, // Asia/Karachi
    {   14, 1187,   12974,  8, }, // Asia/Kathmandu
    {   14, 8679,   12982,  7, }, // Asia/Khandyga
    {   14,  994,   12989,  6, }, // Asia/Kolkata
    {   14, 4216,   12995, 11, }, // Asia/Krasnoyarsk
    {   14, 4878,   13006, 12, }, // Asia/Kuala_Lumpur
    {   14, 5995,   13018,  6, }, // Asia/Kuching
    {   14, 5566,   13024,  6, }, // Asia/Kuwait
    {   14, 1213,   13030,  5, }, // Asia/Macau
    {   14, 4036,   13035,  5, }, // Asia/Magadan
    {   14, 1351,   13040,  6, }, // Asia/Makassar
    {   14, 7182,   13046,  6, }, // Asia/Manila
    {   14, 6939,   13052,  4, }, // Asia/Muscat
    {   14, 2556,   13056,  7, }, // Asia/Nicosia
    {   14, 8693,   13063, 11, }, // Asia/Novokuznetsk
    {   14, 4154,   13074, 10, }, // Asia/Novosibirsk
    {   14, 4248,   13084,  5, }, // Asia/Omsk
    {   14, 7145,   13089,  5, }, // Asia/Oral
    {   14, 6980,   13094,  8, }, // Asia/Phnom_Penh
    {   14, 8711,   13102,  8, }, // Asia/Pontianak
    {   14, 4233,   13110, 10, }, // Asia/Pyongyang
    {   14, 5578,   13120,  3, }, // Asia/Qatar
    {   14, 8726,   13123,  8, }, // Asia/Qostanay
    {   14, 4288,   13131,  9, }, // Asia/Qyzylorda
    {   14, 3603,   13140,  6, }, // Asia/Riyadh
    {   14, 4427,   13146,  6, }, // Asia/Sakhalin
    {   14, 7245,   13152,  6, }, // Asia/Samarkand
    {   14, 3298,   13158,  3, }, // Asia/Seoul
    {   14, 1055,   13161,  6, }, // Asia/Shanghai
    {   14, 3319,   13167,  8, }, // Asia/Singapore
    {   14, 4316,   13175, 12, }, // Asia/Srednekolymsk
    {   14, 3282,   13187,  6, }, // Asia/Taipei
    {   14, 4800,   13193,  5, }, // Asia/Tashkent
    {   14, 3934,   13198,  6, }, // Asia/Tbilisi
    {   14, 2774,   13204,  5, }, // Asia/Tehran
    {   14, 1319,   13209,  5, }, // Asia/Thimphu
    {   14, 2823,   13214,  5, }, // Asia/Tokyo
    {   14, 4591,   13219,  5, }, // Asia/Tomsk
    {   14, 1023,   13224,  9, }, // Asia/Ulaanbaatar
    {   14, 1161,   13233,  6, }, // Asia/Urumqi
    {   14, 8740,   13239,  9, }, // Asia/Ust-Nera
    {   14, 6996,   13248,  8, }, // Asia/Vientiane
    {   14, 4729,   13256, 10, }, // Asia/Vladivostok
    {   14, 4847,   13266,  6, }, // Asia/Yakutsk
    {   14, 1237,   13272,  6, }, // Asia/Yangon
    {   14, 3902,   13278, 10, }, // Asia/Yekaterinburg
    {   14, 3766,   13288,  6, }, // Asia/Yerevan
    {   14, 3682,   13294,  5, }, // Atlantic/Azores
    {   14, 5690,   13299,  6, }, // Atlantic/Bermuda
    {   14, 6647,   13305,  5, }, // Atlantic/Canary
    {   14, 3746,   13310, 12, }, // Atlantic/Cape_Verde
    {   14, 1397,   13322,  4, }, // Atlantic/Faroe
    {   14, 8754,   13326,  6, }, // Atlantic/Madeira
    {   14, 2750,   13332,  8, }, // Atlantic/Reykjavik
    {   14, 7272,   13340, 15, }, // Atlantic/South_Georgia
    {   14, 6840,   13355, 11, }, // Atlantic/St_Helena
    {   14, 6663,   13366,  7, }, // Atlantic/Stanley
    {   14, 1672,   13373,  6, }, // Australia/Adelaide
    {   14, 1637,   13379,  7, }, // Australia/Brisbane
    {   14, 1801,   13386,  9, }, // Australia/Broken_Hill
    {   14, 1585,   13395,  5, }, // Australia/Darwin
    {   14, 3656,   13400,  5, }, // Australia/Eucla
    {   14, 1518,   13405,  6, }, // Australia/Hobart
    {   14, 8771,   13411,  7, }, // Australia/Lindeman
    {   14, 1549,   13418,  8, }, // Australia/Lord_Howe
    {   14, 1729,   13426,  7, }, // Australia/Melbourne
    {   14, 1764,   13433,  4, }, // Australia/Perth
    {   14, 1465,   13437,  5, }, // Australia/Sydney
    {   14, 6460,   13442,  8, }, // Europe/Amsterdam
    {   14, 6235,   13450,  6, }, // Europe/Andorra
    {   14, 3639,   13456,  8, }, // Europe/Astrakhan
    {   14, 2302,   13464,  5, }, // Europe/Athens
    {   14, 6355,   13469,  6, }, // Europe/Belgrade
    {   14, 4776,   13475,  5, }, // Europe/Berlin
    {   14, 6507,   13480, 10, }, // Europe/Bratislava
    {   14, 2169,   13490,  6, }, // Europe/Brussels
    {   14, 3947,   13496,  7, }, // Europe/Bucharest
    {   14, 3825,   13503,  7, }, // Europe/Budapest
    {   14, 8790,   13510,  6, }, // Europe/Busingen
    {   14, 2585,   13516,  8, }, // Europe/Chisinau
    {   14, 6308,   13524,  8, }, // Europe/Copenhagen
    {   14, 2340,   13532,  4, }, // Europe/Dublin
    {   14, 6326,   13536,  8, }, // Europe/Gibraltar
    {   14, 8806,   13544,  6, }, // Europe/Guernsey
    {   14, 6631,   13550,  6, }, // Europe/Helsinki
    {   14, 8822,   13556,  9, }, // Europe/Isle_of_Man
    {   14, 1132,   13565,  7, }, // Europe/Istanbul
    {   14, 8841,   13572,  5, }, // Europe/Jersey
    {   14, 3998,   13577,  9, }, // Europe/Kaliningrad
    {   14, 8855,   13586,  5, }, // Europe/Kirov
    {   14, 2529,   13591,  4, }, // Europe/Kyiv
    {   14, 3232,   13595,  6, }, // Europe/Lisbon
    {   14, 6525,   13601,  9, }, // Europe/Ljubljana
    {   14, 2503,   13610,  4, }, // Europe/London
    {   14, 6384,   13614,  9, }, // Europe/Luxembourg
    {   14, 4911,   13623,  5, }, // Europe/Madrid
    {   14, 6416,   13628,  5, }, // Europe/Malta
    {   14, 6601,   13633,  8, }, // Europe/Mariehamn
    {   14, 3712,   13641,  5, }, // Europe/Minsk
    {   14, 6429,   13646,  6, }, // Europe/Monaco
    {   14, 3556,   13652,  5, }, // Europe/Moscow
    {   14, 6477,   13657,  5, }, // Europe/Oslo
    {   14, 4303,   13662,  5, }, // Europe/Paris
    {   14, 6443,   13667,  9, }, // Europe/Podgorica
    {   14, 6294,   13676,  4, }, // Europe/Prague
    {   14, 8868,   13680,  4, }, // Europe/Riga
    {   14, 6343,   13324,  4, }, // Europe/Rome
    {   14, 4350,   13684,  5, }, // Europe/Samara
    {   14, 6489,   13689, 10, }, // Europe/San_Marino
    {   14, 6264,   13699,  7, }, // Europe/Sarajevo
    {   14, 4470,   13706,  7, }, // Europe/Saratov
    {   14, 8880,   13713,  9, }, // Europe/Simferopol
    {   14, 6402,   13722,  5, }, // Europe/Skopje
    {   14, 6618,   13727,  5, }, // Europe/Sofia
    {   14, 6542,   13732,  8, }, // Europe/Stockholm
    {   14, 8898,   13740,  5, }, // Europe/Tallinn
    {   14, 6221,   13745,  6, }, // Europe/Tirane
    {   14, 8913,   13751, 10, }, // Europe/Ulyanovsk
    {   14, 6371,   13761,  5, }, // Europe/Vaduz
    {   14, 6586,   13766,  9, }, // Europe/Vatican
    {   14, 6250,   13775,  5, }, // Europe/Vienna
    {   14, 8930,   13780,  7, }, // Europe/Vilnius
    {   14, 4746,   13787,  8, }, // Europe/Volgograd
    {   14, 3209,   13795,  5, }, // Europe/Warsaw
    {   14, 6280,   13800,  4, }, // Europe/Zagreb
    {   14, 6559,   13804,  5, }, // Europe/Zurich
    {   14, 5097,   13809, 12, }, // Indian/Antananarivo
    {   14, 6966,   13821,  6, }, // Indian/Chagos
    {   14, 6065,   13827,  7, }, // Indian/Christmas
    {   14, 6082,   13834,  5, }, // Indian/Cocos
    {   14, 5048,   13839,  9, }, // Indian/Comoro
    {   14, 6680,   13848,  9, }, // Indian/Kerguelen
    {   14, 7260,   13857,  4, }, // Indian/Mahe
    {   14, 7069,   13861,  8, }, // Indian/Maldives
    {   14, 4088,   13869,  8, }, // Indian/Mauritius
    {   14, 5117,   13877,  5, }, // Indian/Mayotte
    {   14, 7211,   13882,  7, }, // Indian/Reunion
    {   14, 4441,   13889,  4, }, // Pacific/Apia
    {   14, 3009,   13893,  7, }, // Pacific/Auckland
    {   14, 3725,   13900,  8, }, // Pacific/Bougainville
    {   14, 3034,   13908,  6, }, // Pacific/Chatham
    {   14, 3176,   11955,  3, }, // Pacific/Chuuk
    {   14, 2239,   13914,  4, }, // Pacific/Easter
    {   14, 7360,   13918,  5, }, // Pacific/Efate
    {   14, 7327,   13923,  7, }, // Pacific/Fakaofo
    {   14, 3921,   13930,  4, }, // Pacific/Fiji
    {   14, 7343,   13934,  8, }, // Pacific/Funafuti
    {   14, 6697,   13942,  8, }, // Pacific/Galapagos
    {   14, 6715,   13950,  6, }, // Pacific/Gambier
    {   14, 3841,   13956, 11, }, // Pacific/Guadalcanal
    {   14, 6037,   12179,  4, }, // Pacific/Guam
    {   14, 2725,   13967,  8, }, // Pacific/Honolulu
    {   14, 3068,   13975,  6, }, // Pacific/Kanton
    {   14, 4017,   13981, 11, }, // Pacific/Kiritimati
    {   14, 7038,   13992,  5, }, // Pacific/Kosrae
    {   14, 2844,   13997,  8, }, // Pacific/Kwajalein
    {   14, 4896,   14005,  6, }, // Pacific/Majuro
    {   14, 4070,   14011,  8, }, // Pacific/Marquesas
    {   14, 8945,   14019,  6, }, // Pacific/Midway
    {   14, 7103,   14025,  5, }, // Pacific/Nauru
    {   14, 7132,   12300,  4, }, // Pacific/Niue
    {   14, 4187,   14030,  7, }, // Pacific/Norfolk
    {   14, 7117,   14037,  5, }, // Pacific/Noumea
    {   14, 3145,   14042,  9, }, // Pacific/Pago_Pago
    {   14, 7155,   14051,  5, }, // Pacific/Palau
    {   14, 7194,   14056,  7, }, // Pacific/Pitcairn
    {   14, 3115,   14063,  5, }, // Pacific/Pohnpei
    {   14, 4826,   14068, 10, }, // Pacific/Port_Moresby
    {   14, 6095,   14078,  9, }, // Pacific/Rarotonga
    {   14, 6050,   14087,  6, }, // Pacific/Saipan
    {   14, 7312,   14093,  6, }, // Pacific/Tahiti
    {   14, 6731,   14099,  6, }, // Pacific/Tarawa
    {   14, 4602,   14105,  9, }, // Pacific/Tongatapu
    {   14, 7392,   11474,  3, }, // Pacific/Wake
    {   14, 7405,   14114,  5, }, // Pacific/Wallis
    {   42,   14,       0,  6, }, // Africa/Asmara Aragonese/Latin/Spain
    {   42, 5185,       6,  8, }, // Africa/El_Aaiun
    {   42, 6888,      14,  4, }, // Africa/Lome
    {   42, 5290,      18,  9, }, // Africa/Ndjamena
    {   42, 4454,      27,  8, }, // Africa/Sao_Tome
    {   42, 4573,      35,  9, }, // America/Araguaina
    {   42,  270,      44,  7, }, // America/Argentina/Cordoba
    {   42, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   42, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   42, 4271,      70,  8, }, // America/Asuncion
    {   42,  237,      78,  8, }, // America/Atikokan
    {   42, 7623,      86, 17, }, // America/Bahia_Banderas
    {   42, 7646,     103,  5, }, // America/Belem
    {   42, 4380,     108,  6, }, // America/Bogota
    {   42, 3887,     114,  6, }, // America/Cancun
    {   42, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   42, 3810,     133,  6, }, // America/Cuiaba
    {   42, 5742,     139,  7, }, // America/Curacao
    {   42, 7887,     146,  8, }, // America/Eirunepe
    {   42,  481,     154, 13, }, // America/Indiana/Knox
    {   42, 7979,     167, 16, }, // America/Indiana/Marengo
    {   42, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   42, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   42, 8056,     220, 14, }, // America/Indiana/Vevay
    {   42, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   42, 8104,     252, 16, }, // America/Indiana/Winamac
    {   42, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   42, 5951,     288, 22, }, // America/Lower_Princes
    {   42, 8171,     310,  6, }, // America/Maceio
    {   42, 2919,     316,  8, }, // America/Mazatlan
    {   42, 8238,     324,  6, }, // America/Merida
    {   42, 2951,    4381, 16, }, // America/Mexico_City
    {   42, 4410,     341, 12, }, // America/Miquelon
    {   42, 1852,     353, 19, }, // America/Noronha
    {   42, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   42, 8347,     392, 20, }, // America/North_Dakota/Center
    {   42, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   42,  393,     435,  4, }, // America/Nuuk
    {   42, 8495,     439,  8, }, // America/Santarem
    {   42, 1880,     447,  9, }, // America/Sao_Paulo
    {   42, 6918,     456, 16, }, // America/Scoresbysund
    {   42, 8526,     472, 14, }, // America/St_Barthelemy
    {   42, 2063,     486, 10, }, // America/St_Johns
    {   42, 5882,     496,  9, }, // America/St_Kitts
    {   42, 5899,     505,  9, }, // America/St_Lucia
    {   42,  855,     514, 10, }, // America/St_Thomas
    {   42, 5932,     524, 11, }, // America/St_Vincent
    {   42, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   42, 7295,     643,  5, }, // Antarctica/Syowa
    {   42, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   42, 4790,     704,  5, }, // Asia/Hovd
    {   42, 1187,     709,  9, }, // Asia/Kathmandu
    {   42,  994,     718,  7, }, // Asia/Kolkata
    {   42, 1213,    4961,  5, }, // Asia/Macau
    {   42, 1161,     747,  6, }, // Asia/Urumqi
    {   42, 1237,     753,  6, }, // Asia/Yangon
    {   42, 6647,    4413,  8, }, // Atlantic/Canary
    {   42, 1397,     767,  5, }, // Atlantic/Faroe
    {   42, 6840,     773, 10, }, // Atlantic/St_Helena
    {   42, 8790,     799,  8, }, // Europe/Busingen
    {   42, 2585,     807,  8, }, // Europe/Chisinau
    {   42, 2529,     815,  4, }, // Europe/Kyiv
    {   42, 6221,     819,  6, }, // Europe/Tirane
    {   42, 5048,    4421,  7, }, // Indian/Comoro
    {   42, 7260,     896,  4, }, // Indian/Mahe
    {   42, 7211,     900,  7, }, // Indian/Reunion
    {   42, 3176,     922,  5, }, // Pacific/Chuuk
    {   42, 6697,     940,  9, }, // Pacific/Galapagos
    {   42, 3068,     957,  6, }, // Pacific/Kanton
    {   42, 7117,    1028,  6, }, // Pacific/Noumea
    {   42, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   42, 7405,    1068, 15, }, // Pacific/Wallis
    {   43, 6807,   14119,  6, }, // Africa/Abidjan Armenian/Armenian/Armenia
    {   43, 6779,   14125,  4, }, // Africa/Accra
    {   43, 5078,   14129, 10, }, // Africa/Addis_Ababa
    {   43, 7420,   14139,  5, }, // Africa/Algiers
    {   43,   14,   14144,  6, }, // Africa/Asmara
    {   43,   44,   14150,  6, }, // Africa/Bamako
    {   43, 5276,   14156,  5, }, // Africa/Bangui
    {   43, 6765,   14161,  7, }, // Africa/Banjul
    {   43, 7435,   14168,  6, }, // Africa/Bissau
    {   43, 4976,   14174,  8, }, // Africa/Blantyre
    {   43, 5306,   14182,  8, }, // Africa/Brazzaville
    {   43, 4941,   14190, 12, }, // Africa/Bujumbura
    {   43, 2322,   14202,  6, }, // Africa/Cairo
    {   43, 4136,   14208, 10, }, // Africa/Casablanca
    {   43, 7449,   14218,  6, }, // Africa/Ceuta
    {   43, 6792,   14224,  7, }, // Africa/Conakry
    {   43, 6859,   14231,  5, }, // Africa/Dakar
    {   43, 5149,   14236, 12, }, // Africa/Dar_es_Salaam
    {   43, 5062,   14248,  7, }, // Africa/Djibouti
    {   43, 5262,   14255,  6, }, // Africa/Douala
    {   43, 5185,   14261,  8, }, // Africa/El_Aaiun
    {   43, 6872,   14269,  8, }, // Africa/Freetown
    {   43, 4925,   14277,  8, }, // Africa/Gaborone
    {   43, 5034,   14285,  6, }, // Africa/Harare
    {   43, 4498,   14291, 12, }, // Africa/Johannesburg
    {   43, 4518,   14303,  5, }, // Africa/Juba
    {   43, 5170,   14308,  7, }, // Africa/Kampala
    {   43, 4543,   14315,  7, }, // Africa/Khartoum
    {   43, 4992,   14322,  6, }, // Africa/Kigali
    {   43, 5325,   14328,  7, }, // Africa/Kinshasa
    {   43, 4763,   14335,  5, }, // Africa/Lagos
    {   43, 5355,   14340,  7, }, // Africa/Libreville
    {   43, 6888,   14347,  4, }, // Africa/Lome
    {   43, 5230,   14351,  7, }, // Africa/Luanda
    {   43, 4958,   14358, 11, }, // Africa/Lubumbashi
    {   43, 5020,   14369,  7, }, // Africa/Lusaka
    {   43, 5341,   14376,  6, }, // Africa/Malabo
    {   43, 5006,   14382,  8, }, // Africa/Maputo
    {   43, 5216,   14390,  7, }, // Africa/Maseru
    {   43, 5201,   14397,  7, }, // Africa/Mbabane
    {   43, 5132,   14404,  8, }, // Africa/Mogadishu
    {   43, 7053,   14412,  8, }, // Africa/Monrovia
    {   43, 3872,   14420,  7, }, // Africa/Nairobi
    {   43, 5290,   14427,  7, }, // Africa/Ndjamena
    {   43, 5373,   14434,  6, }, // Africa/Niamey
    {   43, 6822,   14440,  8, }, // Africa/Nouakchott
    {   43, 6746,   14448, 11, }, // Africa/Ouagadougou
    {   43, 5244,   14459, 10, }, // Africa/Porto-Novo
    {   43, 4454,   14469,  8, }, // Africa/Sao_Tome
    {   43, 2868,   14477,  7, }, // Africa/Tripoli
    {   43, 6573,   14484,  6, }, // Africa/Tunis
    {   43, 4171,   14490,  8, }, // Africa/Windhoek
    {   43,  132,   14498,  9, }, // America/Adak
    {   43, 3365,   14507,  7, }, // America/Anchorage
    {   43, 5626,   14514,  8, }, // America/Anguilla
    {   43, 5643,   14522,  8, }, // America/Antigua
    {   43, 4573,   14530, 10, }, // America/Araguaina
    {   43,  166,   14540, 13, }, // America/Argentina/Buenos_Aires
    {   43,   91,   14553,  9, }, // America/Argentina/Catamarca
    {   43,  270,   14562,  7, }, // America/Argentina/Cordoba
    {   43,  441,   14569,  7, }, // America/Argentina/Jujuy
    {   43, 7462,   14576,  8, }, // America/Argentina/La_Rioja
    {   43,  565,   14584,  7, }, // America/Argentina/Mendoza
    {   43, 7489,   14591, 12, }, // America/Argentina/Rio_Gallegos
    {   43, 7520,   14603,  5, }, // America/Argentina/Salta
    {   43, 7544,   14608,  9, }, // America/Argentina/San_Juan
    {   43, 5599,   14617,  9, }, // America/Argentina/San_Luis
    {   43, 7571,   14626,  9, }, // America/Argentina/Tucuman
    {   43, 7597,   14635,  8, }, // America/Argentina/Ushuaia
    {   43, 5659,   14643,  6, }, // America/Aruba
    {   43, 4271,   14649,  9, }, // America/Asuncion
    {   43,  237,   14658,  8, }, // America/Atikokan
    {   43, 3698,   14666,  5, }, // America/Bahia
    {   43, 7623,   14671, 14, }, // America/Bahia_Banderas
    {   43, 5673,   14685,  8, }, // America/Barbados
    {   43, 7646,   14693,  5, }, // America/Belem
    {   43, 5426,   14698,  5, }, // America/Belize
    {   43, 7660,   14703, 12, }, // America/Blanc-Sablon
    {   43, 7681,   14715,  9, }, // America/Boa_Vista
    {   43, 4380,   14724,  6, }, // America/Bogota
    {   43, 7699,   14730,  5, }, // America/Boise
    {   43, 7713,   14735, 11, }, // America/Cambridge_Bay
    {   43, 7735,   14746, 13, }, // America/Campo_Grande
    {   43, 3887,   14759,  7, }, // America/Cancun
    {   43, 4713,   14766,  7, }, // America/Caracas
    {   43, 4364,   14773,  5, }, // America/Cayenne
    {   43, 5515,   14778, 14, }, // America/Cayman
    {   43, 2262,   14792,  6, }, // America/Chicago
    {   43, 7756,   14798,  8, }, // America/Chihuahua
    {   43, 7774,   14806, 15, }, // America/Ciudad_Juarez
    {   43, 5441,   14821, 10, }, // America/Costa_Rica
    {   43, 7796,   14831,  7, }, // America/Coyhaique
    {   43, 7814,   14838,  7, }, // America/Creston
    {   43, 3810,   14845,  7, }, // America/Cuiaba
    {   43, 5742,   14852,  9, }, // America/Curacao
    {   43, 7830,   14861, 12, }, // America/Danmarkshavn
    {   43, 7851,   14873,  7, }, // America/Dawson
    {   43, 7866,   14880, 12, }, // America/Dawson_Creek
    {   43,  805,   14892,  6, }, // America/Denver
    {   43, 3484,   14898,  7, }, // America/Detroit
    {   43, 5758,   14905,  8, }, // America/Dominica
    {   43,  893,   14913,  8, }, // America/Edmonton
    {   43, 7887,   14921,  9, }, // America/Eirunepe
    {   43, 5460,   14930,  8, }, // America/El_Salvador
    {   43, 7904,   14938, 11, }, // America/Fort_Nelson
    {   43, 7924,   14949,  9, }, // America/Fortaleza
    {   43, 7942,   14958,  9, }, // America/Glace_Bay
    {   43, 6900,   14967,  8, }, // America/Goose_Bay
    {   43, 4631,   14975, 11, }, // America/Grand_Turk
    {   43, 5789,   14986,  7, }, // America/Grenada
    {   43, 5805,   14993, 10, }, // America/Guadeloupe
    {   43, 3779,   15003,  9, }, // America/Guatemala
    {   43, 4860,   15012,  9, }, // America/Guayaquil
    {   43, 6951,   15021,  6, }, // America/Guyana
    {   43, 1941,   15027,  8, }, // America/Halifax
    {   43, 2283,   15035,  6, }, // America/Havana
    {   43, 7960,   15041,  9, }, // America/Hermosillo
    {   43,  348,   15050, 12, }, // America/Indiana/Indianapolis
    {   43,  481,   15062, 13, }, // America/Indiana/Knox
    {   43, 7979,   15075, 16, }, // America/Indiana/Marengo
    {   43, 8003,   15091, 20, }, // America/Indiana/Petersburg
    {   43, 8030,   15111, 17, }, // America/Indiana/Tell_City
    {   43, 8056,   15128, 14, }, // America/Indiana/Vevay
    {   43, 8078,   15142, 16, }, // America/Indiana/Vincennes
    {   43, 8104,   15158, 16, }, // America/Indiana/Winamac
    {   43, 8128,   15174,  7, }, // America/Inuvik
    {   43,  660,   15181,  8, }, // America/Iqaluit
    {   43, 2801,   15189,  7, }, // America/Jamaica
    {   43, 5399,   15196,  5, }, // America/Juneau
    {   43,  521,   15201,  8, }, // America/Kentucky/Louisville
    {   43, 8143,   15209, 19, }, // America/Kentucky/Monticello
    {   43, 5723,   15228, 10, }, // America/Kralendijk
    {   43, 4395,   15238,  6, }, // America/La_Paz
    {   43, 7169,   15244,  4, }, // America/Lima
    {   43, 3258,   15248, 11, }, // America/Los_Angeles
    {   43, 5951,   15259, 22, }, // America/Lower_Princes
    {   43, 8171,   15281,  6, }, // America/Maceio
    {   43, 8186,   15287,  8, }, // America/Managua
    {   43, 1910,   15295,  7, }, // America/Manaus
    {   43, 5916,   15302,  6, }, // America/Marigot
    {   43, 5824,   15308,  9, }, // America/Martinique
    {   43, 8202,   15317,  9, }, // America/Matamoros
    {   43, 2919,   15326,  8, }, // America/Mazatlan
    {   43, 8220,   15334,  8, }, // America/Menominee
    {   43, 8238,   15342,  6, }, // America/Merida
    {   43, 8253,   15348, 10, }, // America/Metlakatla
    {   43, 2951,   15358,  6, }, // America/Mexico_City
    {   43, 4410,   15364,  7, }, // America/Miquelon
    {   43, 8272,   15371,  7, }, // America/Moncton
    {   43, 8288,   15378,  8, }, // America/Monterrey
    {   43, 4117,   15386, 10, }, // America/Montevideo
    {   43, 5843,   15396,  8, }, // America/Montserrat
    {   43, 5500,   15404,  6, }, // America/Nassau
    {   43, 2381,   15410,  9, }, // America/New_York
    {   43, 8306,   15419,  3, }, // America/Nome
    {   43, 1852,   15422,  7, }, // America/Noronha
    {   43, 8319,   15429, 25, }, // America/North_Dakota/Beulah
    {   43, 8347,   15454, 28, }, // America/North_Dakota/Center
    {   43, 8375,   15482, 30, }, // America/North_Dakota/New_Salem
    {   43,  393,   15512,  6, }, // America/Nuuk
    {   43, 8406,   15518,  7, }, // America/Ojinaga
    {   43, 2358,   15525,  6, }, // America/Panama
    {   43, 6192,   15531, 10, }, // America/Paramaribo
    {   43, 2975,   15541,  6, }, // America/Phoenix
    {   43, 3964,   15547, 12, }, // America/Port-au-Prince
    {   43, 5973,   15559, 13, }, // America/Port_of_Spain
    {   43, 8422,   15572, 13, }, // America/Porto_Velho
    {   43, 5862,   15585, 12, }, // America/Puerto_Rico
    {   43, 4049,   15597, 13, }, // America/Punta_Arenas
    {   43, 8442,   15610, 12, }, // America/Rankin_Inlet
    {   43, 8463,   15622,  6, }, // America/Recife
    {   43, 1997,   15628,  7, }, // America/Regina
    {   43, 8478,   15635,  9, }, // America/Resolute
    {   43,  695,   15644, 12, }, // America/Rio_Branco
    {   43, 8495,   15656,  8, }, // America/Santarem
    {   43, 2203,   15664,  8, }, // America/Santiago
    {   43, 6130,   15672, 13, }, // America/Santo_Domingo
    {   43, 1880,   15685, 11, }, // America/Sao_Paulo
    {   43, 6918,   15696, 11, }, // America/Scoresbysund
    {   43, 8512,   15707,  5, }, // America/Sitka
    {   43, 8526,   15712, 12, }, // America/St_Barthelemy
    {   43, 2063,   15724,  9, }, // America/St_Johns
    {   43, 5882,   15733,  9, }, // America/St_Kitts
    {   43, 5899,   15742, 12, }, // America/St_Lucia
    {   43,  855,   15754, 10, }, // America/St_Thomas
    {   43, 5932,   15764, 12, }, // America/St_Vincent
    {   43, 8548,   15776, 12, }, // America/Swift_Current
    {   43, 5480,   15788, 12, }, // America/Tegucigalpa
    {   43, 5775,   15800,  5, }, // America/Thule
    {   43,  313,   15805,  8, }, // America/Tijuana
    {   43,  608,   15813,  7, }, // America/Toronto
    {   43, 5707,   15820,  7, }, // America/Tortola
    {   43, 2095,   15827,  9, }, // America/Vancouver
    {   43, 2146,   15836,  9, }, // America/Whitehorse
    {   43,  734,   15845,  7, }, // America/Winnipeg
    {   43, 8570,   15852,  8, }, // America/Yakutat
    {   43, 6020,   15860,  5, }, // Antarctica/Casey
    {   43, 6113,   15865,  6, }, // Antarctica/Davis
    {   43, 6152,   15871, 17, }, // Antarctica/DumontDUrville
    {   43, 8586,   15888, 14, }, // Antarctica/Macquarie
    {   43, 7085,   15902,  7, }, // Antarctica/Mawson
    {   43,  932,   15909,  9, }, // Antarctica/McMurdo
    {   43, 8607,   15918,  6, }, // Antarctica/Palmer
    {   43, 7226,   15924,  6, }, // Antarctica/Rothera
    {   43, 7295,   15930,  5, }, // Antarctica/Syowa
    {   43, 8625,   15935,  5, }, // Antarctica/Troll
    {   43, 7374,   15940,  6, }, // Antarctica/Vostok
    {   43, 1431,   15946,  7, }, // Arctic/Longyearbyen
    {   43, 5589,   15953,  4, }, // Asia/Aden
    {   43, 5414,   15957,  6, }, // Asia/Almaty
    {   43, 3987,   15963,  5, }, // Asia/Amman
    {   43, 5530,   15968,  6, }, // Asia/Anadyr
    {   43, 5542,   15974,  6, }, // Asia/Aqtau
    {   43, 5387,   15980,  6, }, // Asia/Aqtobe
    {   43,  966,   15986,  7, }, // Asia/Ashgabat
    {   43, 8642,   15993,  7, }, // Asia/Atyrau
    {   43, 3626,   16000,  6, }, // Asia/Baghdad
    {   43, 5553,   16006,  7, }, // Asia/Bahrain
    {   43, 3672,   16013,  5, }, // Asia/Baku
    {   43, 4485,   16018,  7, }, // Asia/Bangkok
    {   43, 3590,   16025,  8, }, // Asia/Barnaul
    {   43, 4105,   16033,  7, }, // Asia/Beirut
    {   43, 3797,   16040,  6, }, // Asia/Bishkek
    {   43, 6008,   16046,  7, }, // Asia/Brunei
    {   43, 4620,   16053,  4, }, // Asia/Chita
    {   43, 4530,   16057,  7, }, // Asia/Colombo
    {   43, 4559,   16064,  8, }, // Asia/Damascus
    {   43, 1095,   16072,  5, }, // Asia/Dhaka
    {   43, 6211,   16077,  4, }, // Asia/Dili
    {   43, 3615,   16081,  6, }, // Asia/Dubai
    {   43, 6178,   16087,  8, }, // Asia/Dushanbe
    {   43, 8654,   16095, 10, }, // Asia/Famagusta
    {   43, 8669,   16105,  4, }, // Asia/Gaza
    {   43, 4814,   16109,  6, }, // Asia/Hebron
    {   43, 1261,   16115,  7, }, // Asia/Ho_Chi_Minh
    {   43, 2706,   16122,  7, }, // Asia/Hong_Kong
    {   43, 4790,   16129,  4, }, // Asia/Hovd
    {   43, 4203,   16133,  8, }, // Asia/Irkutsk
    {   43, 7025,   16141,  7, }, // Asia/Jakarta
    {   43, 7011,   16148,  8, }, // Asia/Jayapura
    {   43, 1292,   16156,  9, }, // Asia/Jerusalem
    {   43, 3579,   16165,  6, }, // Asia/Kabul
    {   43, 4335,   16171,  8, }, // Asia/Kamchatka
    {   43, 4258,   16179,  6, }, // Asia/Karachi
    {   43, 1187,   16185,  9, }, // Asia/Kathmandu
    {   43, 8679,   16194,  7, }, // Asia/Khandyga
    {   43,  994,   16201,  8, }, // Asia/Kolkata
    {   43, 4216,   16209, 11, }, // Asia/Krasnoyarsk
    {   43, 4878,   16220, 15, }, // Asia/Kuala_Lumpur
    {   43, 5995,   16235,  7, }, // Asia/Kuching
    {   43, 5566,   16242,  7, }, // Asia/Kuwait
    {   43, 1213,   16249,  5, }, // Asia/Macau
    {   43, 4036,   16254,  7, }, // Asia/Magadan
    {   43, 1351,   16261,  7, }, // Asia/Makassar
    {   43, 7182,   16268,  6, }, // Asia/Manila
    {   43, 6939,   16274,  6, }, // Asia/Muscat
    {   43, 2556,   16280,  7, }, // Asia/Nicosia
    {   43, 8693,   16287, 12, }, // Asia/Novokuznetsk
    {   43, 4154,   16299, 11, }, // Asia/Novosibirsk
    {   43, 4248,   16310,  4, }, // Asia/Omsk
    {   43, 7145,   16314,  7, }, // Asia/Oral
    {   43, 6980,   16321,  7, }, // Asia/Phnom_Penh
    {   43, 8711,   16328,  9, }, // Asia/Pontianak
    {   43, 4233,   16337,  7, }, // Asia/Pyongyang
    {   43, 5578,   16344,  5, }, // Asia/Qatar
    {   43, 8726,   16349,  8, }, // Asia/Qostanay
    {   43, 4288,   16357,  9, }, // Asia/Qyzylorda
    {   43, 3603,   16366,  7, }, // Asia/Riyadh
    {   43, 4427,   16373,  7, }, // Asia/Sakhalin
    {   43, 7245,   16380,  9, }, // Asia/Samarkand
    {   43, 3298,   16389,  5, }, // Asia/Seoul
    {   43, 1055,   16394,  6, }, // Asia/Shanghai
    {   43, 3319,   16400,  9, }, // Asia/Singapore
    {   43, 4316,   16409, 13, }, // Asia/Srednekolymsk
    {   43, 3282,   16422,  6, }, // Asia/Taipei
    {   43, 4800,   16428,  7, }, // Asia/Tashkent
    {   43, 3934,   16435,  7, }, // Asia/Tbilisi
    {   43, 2774,   16442,  6, }, // Asia/Tehran
    {   43, 1319,   16448,  8, }, // Asia/Thimphu
    {   43, 2823,   16456,  5, }, // Asia/Tokyo
    {   43, 4591,   16461,  5, }, // Asia/Tomsk
    {   43, 1023,   16466, 11, }, // Asia/Ulaanbaatar
    {   43, 1161,   16477,  8, }, // Asia/Urumqi
    {   43, 8740,   16485,  9, }, // Asia/Ust-Nera
    {   43, 6996,   16494,  8, }, // Asia/Vientiane
    {   43, 4729,   16502, 11, }, // Asia/Vladivostok
    {   43, 4847,   16513,  8, }, // Asia/Yakutsk
    {   43, 1237,   16521,  7, }, // Asia/Yangon
    {   43, 3902,   16528, 13, }, // Asia/Yekaterinburg
    {   43, 3766,   16541,  5, }, // Asia/Yerevan
    {   43, 3682,   16546, 15, }, // Atlantic/Azores
    {   43, 5690,   16561, 10, }, // Atlantic/Bermuda
    {   43, 6647,   16571, 16, }, // Atlantic/Canary
    {   43, 3746,   16587, 10, }, // Atlantic/Cape_Verde
    {   43, 1397,   16597, 16, }, // Atlantic/Faroe
    {   43, 8754,   16613,  7, }, // Atlantic/Madeira
    {   43, 2750,   16620,  9, }, // Atlantic/Reykjavik
    {   43, 7272,   16629, 16, }, // Atlantic/South_Georgia
    {   43, 6840,   16645, 18, }, // Atlantic/St_Helena
    {   43, 6663,   16663,  6, }, // Atlantic/Stanley
    {   43, 1672,   16669,  8, }, // Australia/Adelaide
    {   43, 1637,   16677,  7, }, // Australia/Brisbane
    {   43, 1801,   16684, 10, }, // Australia/Broken_Hill
    {   43, 1585,   16694,  6, }, // Australia/Darwin
    {   43, 3656,   16700,  6, }, // Australia/Eucla
    {   43, 1518,   16706,  6, }, // Australia/Hobart
    {   43, 8771,   16712,  8, }, // Australia/Lindeman
    {   43, 1549,   16720, 14, }, // Australia/Lord_Howe
    {   43, 1729,   16734,  8, }, // Australia/Melbourne
    {   43, 1764,   16742,  4, }, // Australia/Perth
    {   43, 1465,   16746,  6, }, // Australia/Sydney
    {   43, 6460,   16752,  9, }, // Europe/Amsterdam
    {   43, 6235,   16761,  7, }, // Europe/Andorra
    {   43, 3639,   16768,  8, }, // Europe/Astrakhan
    {   43, 2302,   16776,  5, }, // Europe/Athens
    {   43, 6355,   16781,  7, }, // Europe/Belgrade
    {   43, 4776,   16788,  6, }, // Europe/Berlin
    {   43, 6507,   16794, 10, }, // Europe/Bratislava
    {   43, 2169,   16804,  8, }, // Europe/Brussels
    {   43, 3947,   16812,  9, }, // Europe/Bucharest
    {   43, 3825,   16821,  9, }, // Europe/Budapest
    {   43, 8790,   16830, 10, }, // Europe/Busingen
    {   43, 2585,   16840,  5, }, // Europe/Chisinau
    {   43, 6308,   16845, 10, }, // Europe/Copenhagen
    {   43, 2340,   16855,  7, }, // Europe/Dublin
    {   43, 6326,   16862,  9, }, // Europe/Gibraltar
    {   43, 8806,   16871,  6, }, // Europe/Guernsey
    {   43, 6631,   16877,  8, }, // Europe/Helsinki
    {   43, 8822,   16885,  8, }, // Europe/Isle_of_Man
    {   43, 1132,   16893,  8, }, // Europe/Istanbul
    {   43, 8841,   16901,  5, }, // Europe/Jersey
    {   43, 3998,   16906, 11, }, // Europe/Kaliningrad
    {   43, 8855,   16917,  5, }, // Europe/Kirov
    {   43, 2529,   16922,  3, }, // Europe/Kyiv
    {   43, 3232,   16925,  7, }, // Europe/Lisbon
    {   43, 6525,   16932, 10, }, // Europe/Ljubljana
    {   43, 2503,   16942,  6, }, // Europe/London
    {   43, 6384,   16948, 13, }, // Europe/Luxembourg
    {   43, 4911,   16961,  6, }, // Europe/Madrid
    {   43, 6416,   16967,  5, }, // Europe/Malta
    {   43, 6601,   16972,  9, }, // Europe/Mariehamn
    {   43, 3712,   16981,  5, }, // Europe/Minsk
    {   43, 6429,   16986,  6, }, // Europe/Monaco
    {   43, 3556,   16992,  6, }, // Europe/Moscow
    {   43, 6477,   16998,  4, }, // Europe/Oslo
    {   43, 4303,   17002,  5, }, // Europe/Paris
    {   43, 6443,   17007,  9, }, // Europe/Podgorica
    {   43, 6294,   17016,  5, }, // Europe/Prague
    {   43, 8868,   17021,  4, }, // Europe/Riga
    {   43, 6343,   17025,  4, }, // Europe/Rome
    {   43, 4350,   17029,  6, }, // Europe/Samara
    {   43, 6489,   17035, 10, }, // Europe/San_Marino
    {   43, 6264,   17045,  6, }, // Europe/Sarajevo
    {   43, 4470,   17051,  7, }, // Europe/Saratov
    {   43, 8880,   17058, 10, }, // Europe/Simferopol
    {   43, 6402,   17068,  6, }, // Europe/Skopje
    {   43, 6618,   17074,  5, }, // Europe/Sofia
    {   43, 6542,   17079,  8, }, // Europe/Stockholm
    {   43, 8898,   17087,  6, }, // Europe/Tallinn
    {   43, 6221,   17093,  6, }, // Europe/Tirane
    {   43, 8913,   17099, 10, }, // Europe/Ulyanovsk
    {   43, 6371,   17109,  6, }, // Europe/Vaduz
    {   43, 6586,   17115,  7, }, // Europe/Vatican
    {   43, 6250,   17122,  6, }, // Europe/Vienna
    {   43, 8930,   17128,  8, }, // Europe/Vilnius
    {   43, 4746,   17136,  9, }, // Europe/Volgograd
    {   43, 3209,   17145,  7, }, // Europe/Warsaw
    {   43, 6280,   17152,  6, }, // Europe/Zagreb
    {   43, 6559,   17158,  7, }, // Europe/Zurich
    {   43, 5097,   17165, 13, }, // Indian/Antananarivo
    {   43, 6966,   17178,  5, }, // Indian/Chagos
    {   43, 6065,   17183, 18, }, // Indian/Christmas
    {   43, 6082,   17201, 16, }, // Indian/Cocos
    {   43, 5048,   17217, 16, }, // Indian/Comoro
    {   43, 6680,   17233,  8, }, // Indian/Kerguelen
    {   43, 7260,   17241,  3, }, // Indian/Mahe
    {   43, 7069,   17244,  9, }, // Indian/Maldives
    {   43, 4088,   17253,  9, }, // Indian/Mauritius
    {   43, 5117,   17262,  5, }, // Indian/Mayotte
    {   43, 7211,   17267,  9, }, // Indian/Reunion
    {   43, 4441,   17276,  4, }, // Pacific/Apia
    {   43, 3009,   17280,  6, }, // Pacific/Auckland
    {   43, 3725,   17286,  9, }, // Pacific/Bougainville
    {   43, 3034,   17295, 10, }, // Pacific/Chatham
    {   43, 3176,   17305,  6, }, // Pacific/Chuuk
    {   43, 2239,   17311, 10, }, // Pacific/Easter
    {   43, 7360,   17321,  5, }, // Pacific/Efate
    {   43, 7327,   17326,  7, }, // Pacific/Fakaofo
    {   43, 3921,   17333,  4, }, // Pacific/Fiji
    {   43, 7343,   17337, 10, }, // Pacific/Funafuti
    {   43, 6697,   17347, 20, }, // Pacific/Galapagos
    {   43, 6715,   17367, 14, }, // Pacific/Gambier
    {   43, 3841,   17381, 12, }, // Pacific/Guadalcanal
    {   43, 6037,   17393,  5, }, // Pacific/Guam
    {   43, 2725,   17398, 10, }, // Pacific/Honolulu
    {   43, 3068,   17408,  6, }, // Pacific/Kanton
    {   43, 4017,   17414, 10, }, // Pacific/Kiritimati
    {   43, 7038,   17424,  6, }, // Pacific/Kosrae
    {   43, 2844,   17430,  9, }, // Pacific/Kwajalein
    {   43, 4896,   17439,  7, }, // Pacific/Majuro
    {   43, 4070,   17446, 17, }, // Pacific/Marquesas
    {   43, 8945,   17463, 12, }, // Pacific/Midway
    {   43, 7103,   17475,  7, }, // Pacific/Nauru
    {   43, 7132,   17482,  5, }, // Pacific/Niue
    {   43, 4187,   17487,  7, }, // Pacific/Norfolk
    {   43, 7117,   17494,  6, }, // Pacific/Noumea
    {   43, 3145,   17500,  9, }, // Pacific/Pago_Pago
    {   43, 7155,   17509,  6, }, // Pacific/Palau
    {   43, 7194,   17515,  7, }, // Pacific/Pitcairn
    {   43, 3115,   17522,  6, }, // Pacific/Pohnpei
    {   43, 4826,   17528, 11, }, // Pacific/Port_Moresby
    {   43, 6095,   17539,  9, }, // Pacific/Rarotonga
    {   43, 6050,   17548,  6, }, // Pacific/Saipan
    {   43, 7312,   17554,  5, }, // Pacific/Tahiti
    {   43, 6731,   17559,  6, }, // Pacific/Tarawa
    {   43, 4602,   17565, 10, }, // Pacific/Tongatapu
    {   43, 7392,   17575, 10, }, // Pacific/Wake
    {   43, 7405,   17585,  6, }, // Pacific/Wallis
    {   44, 6807,   17591,  7, }, // Africa/Abidjan Assamese/Bangla/India
    {   44, 6779,   17598,  5, }, // Africa/Accra
    {   44, 5078,   17603, 12, }, // Africa/Addis_Ababa
    {   44, 7420,   17615, 10, }, // Africa/Algiers
    {   44,   14,   17625,  7, }, // Africa/Asmara
    {   44,   44,   17632,  6, }, // Africa/Bamako
    {   44, 5276,   17638,  6, }, // Africa/Bangui
    {   44, 6765,   17644,  7, }, // Africa/Banjul
    {   44, 7435,   17651,  5, }, // Africa/Bissau
    {   44, 4976,   17656, 12, }, // Africa/Blantyre
    {   44, 5306,   17668, 10, }, // Africa/Brazzaville
    {   44, 4941,   17678, 10, }, // Africa/Bujumbura
    {   44, 2322,   17688,  5, }, // Africa/Cairo
    {   44, 4136,   17693, 11, }, // Africa/Casablanca
    {   44, 7449,   17704,  5, }, // Africa/Ceuta
    {   44, 6792,   17709,  8, }, // Africa/Conakry
    {   44, 6859,   17717,  5, }, // Africa/Dakar
    {   44, 5149,   17722, 12, }, // Africa/Dar_es_Salaam
    {   44, 5062,   17734,  6, }, // Africa/Djibouti
    {   44, 5262,   17740,  6, }, // Africa/Douala
    {   44, 5185,   17746,  9, }, // Africa/El_Aaiun
    {   44, 6872,   17755,  8, }, // Africa/Freetown
    {   44, 4925,   17763,  7, }, // Africa/Gaborone
    {   44, 5034,   17770,  6, }, // Africa/Harare
    {   44, 4498,   17776, 12, }, // Africa/Johannesburg
    {   44, 4518,   17788,  4, }, // Africa/Juba
    {   44, 5170,   17792,  8, }, // Africa/Kampala
    {   44, 4543,   17800,  7, }, // Africa/Khartoum
    {   44, 4992,   17807,  6, }, // Africa/Kigali
    {   44, 5325,   17813,  7, }, // Africa/Kinshasa
    {   44, 4763,   17820,  5, }, // Africa/Lagos
    {   44, 5355,   17825, 10, }, // Africa/Libreville
    {   44, 6888,   17835,  3, }, // Africa/Lome
    {   44, 5230,   17838,  8, }, // Africa/Luanda
    {   44, 4958,   17846, 10, }, // Africa/Lubumbashi
    {   44, 5020,   17856,  6, }, // Africa/Lusaka
    {   44, 5341,   17862,  6, }, // Africa/Malabo
    {   44, 5006,   17868,  6, }, // Africa/Maputo
    {   44, 5216,   17874,  6, }, // Africa/Maseru
    {   44, 5201,   17880,  8, }, // Africa/Mbabane
    {   44, 5132,   17888,  8, }, // Africa/Mogadishu
    {   44, 7053,   17896, 10, }, // Africa/Monrovia
    {   44, 3872,   17906,  7, }, // Africa/Nairobi
    {   44, 5290,   17913,  9, }, // Africa/Ndjamena
    {   44, 5373,   17922,  7, }, // Africa/Niamey
    {   44, 6822,   17929,  7, }, // Africa/Nouakchott
    {   44, 6746,   17936,  7, }, // Africa/Ouagadougou
    {   44, 5244,   17943, 11, }, // Africa/Porto-Novo
    {   44, 4454,   17954,  8, }, // Africa/Sao_Tome
    {   44, 2868,   17962,  8, }, // Africa/Tripoli
    {   44, 6573,   17970,  5, }, // Africa/Tunis
    {   44, 4171,   17975,  8, }, // Africa/Windhoek
    {   44,  132,   17983,  4, }, // America/Adak
    {   44, 3365,   17987,  7, }, // America/Anchorage
    {   44, 5626,   17994,  7, }, // America/Anguilla
    {   44, 5643,   18001,  9, }, // America/Antigua
    {   44, 4573,   18010, 10, }, // America/Araguaina
    {   44,  166,   18020, 12, }, // America/Argentina/Buenos_Aires
    {   44,   91,   18032, 10, }, // America/Argentina/Catamarca
    {   44,  270,   18042,  8, }, // America/Argentina/Cordoba
    {   44,  441,   18050,  5, }, // America/Argentina/Jujuy
    {   44, 7462,   18055,  8, }, // America/Argentina/La_Rioja
    {   44,  565,   18063,  8, }, // America/Argentina/Mendoza
    {   44, 7489,   18071, 12, }, // America/Argentina/Rio_Gallegos
    {   44, 7520,   18083,  6, }, // America/Argentina/Salta
    {   44, 7544,   18089,  9, }, // America/Argentina/San_Juan
    {   44, 5599,   18098,  8, }, // America/Argentina/San_Luis
    {   44, 7571,   18106,  6, }, // America/Argentina/Tucuman
    {   44, 7597,   18112,  8, }, // America/Argentina/Ushuaia
    {   44, 5659,   18120,  5, }, // America/Aruba
    {   44, 4271,   18125,  9, }, // America/Asuncion
    {   44,  237,   18134,  8, }, // America/Atikokan
    {   44, 3698,   18142,  7, }, // America/Bahia
    {   44, 7623,   18149, 17, }, // America/Bahia_Banderas
    {   44, 5673,   18166,  9, }, // America/Barbados
    {   44, 7646,   18175,  5, }, // America/Belem
    {   44, 5426,   18180,  5, }, // America/Belize
    {   44, 7660,   18185, 13, }, // America/Blanc-Sablon
    {   44, 7681,   18198, 11, }, // America/Boa_Vista
    {   44, 4380,   18209,  6, }, // America/Bogota
    {   44, 7699,   18215,  5, }, // America/Boise
    {   44, 7713,   18220, 15, }, // America/Cambridge_Bay
    {   44, 7735,   18235, 15, }, // America/Campo_Grande
    {   44, 3887,   18250,  6, }, // America/Cancun
    {   44, 4713,   18256,  7, }, // America/Caracas
    {   44, 4364,   18263,  6, }, // America/Cayenne
    {   44, 5515,   18269,  6, }, // America/Cayman
    {   44, 2262,   18275,  6, }, // America/Chicago
    {   44, 7756,   18281,  9, }, // America/Chihuahua
    {   44, 7774,   18290, 12, }, // America/Ciudad_Juarez
    {   44, 5441,   18302, 11, }, // America/Costa_Rica
    {   44, 7796,   18313,  7, }, // America/Coyhaique
    {   44, 7814,   18320,  8, }, // America/Creston
    {   44, 3810,   18328,  6, }, // America/Cuiaba
    {   44, 5742,   18334,  7, }, // America/Curacao
    {   44, 7830,   18341, 12, }, // America/Danmarkshavn
    {   44, 7851,   18353,  5, }, // America/Dawson
    {   44, 7866,   18358, 11, }, // America/Dawson_Creek
    {   44,  805,   18369,  6, }, // America/Denver
    {   44, 3484,   18375,  8, }, // America/Detroit
    {   44, 5758,   18383,  7, }, // America/Dominica
    {   44,  893,   18390,  7, }, // America/Edmonton
    {   44, 7887,   18397,  7, }, // America/Eirunepe
    {   44, 5460,   18404, 11, }, // America/El_Salvador
    {   44, 7904,   18415, 11, }, // America/Fort_Nelson
    {   44, 7924,   18426, 10, }, // America/Fortaleza
    {   44, 7942,   18436, 12, }, // America/Glace_Bay
    {   44, 6900,   18448, 10, }, // America/Goose_Bay
    {   44, 4631,   18458, 13, }, // America/Grand_Turk
    {   44, 5789,   18471,  8, }, // America/Grenada
    {   44, 5805,   18479,  9, }, // America/Guadeloupe
    {   44, 3779,   18488, 10, }, // America/Guatemala
    {   44, 4860,   18498,  9, }, // America/Guayaquil
    {   44, 6951,   18507,  7, }, // America/Guyana
    {   44, 1941,   18514,  9, }, // America/Halifax
    {   44, 2283,   18523,  6, }, // America/Havana
    {   44, 7960,   18529, 12, }, // America/Hermosillo
    {   44,  348,   18541, 15, }, // America/Indiana/Indianapolis
    {   44,  481,   18556, 16, }, // America/Indiana/Knox
    {   44, 7979,   18572, 19, }, // America/Indiana/Marengo
    {   44, 8003,   18591, 24, }, // America/Indiana/Petersburg
    {   44, 8030,   18615, 20, }, // America/Indiana/Tell_City
    {   44, 8056,   18635, 16, }, // America/Indiana/Vevay
    {   44, 8078,   18651, 20, }, // America/Indiana/Vincennes
    {   44, 8104,   18671, 19, }, // America/Indiana/Winamac
    {   44, 8128,   18690,  6, }, // America/Inuvik
    {   44,  660,   18696,  7, }, // America/Iqaluit
    {   44, 2801,   18703,  7, }, // America/Jamaica
    {   44, 5399,   18710,  5, }, // America/Juneau
    {   44,  521,   18715,  8, }, // America/Kentucky/Louisville
    {   44, 8143,   18723, 19, }, // America/Kentucky/Monticello
    {   44, 5723,   18742, 13, }, // America/Kralendijk
    {   44, 4395,   18755,  6, }, // America/La_Paz
    {   44, 7169,   18761,  4, }, // America/Lima
    {   44, 3258,   18765, 11, }, // America/Los_Angeles
    {   44, 5951,   18776, 25, }, // America/Lower_Princes
    {   44, 8171,   18801,  5, }, // America/Maceio
    {   44, 8186,   18806,  8, }, // America/Managua
    {   44, 1910,   18814,  5, }, // America/Manaus
    {   44, 5916,   18819,  7, }, // America/Marigot
    {   44, 5824,   18826,  9, }, // America/Martinique
    {   44, 8202,   18835,  9, }, // America/Matamoros
    {   44, 2919,   18844, 10, }, // America/Mazatlan
    {   44, 8220,   18854,  8, }, // America/Menominee
    {   44, 8238,   18862,  6, }, // America/Merida
    {   44, 8253,   18868, 12, }, // America/Metlakatla
    {   44, 2951,   18880, 13, }, // America/Mexico_City
    {   44, 4410,   18893,  9, }, // America/Miquelon
    {   44, 8272,   18902,  7, }, // America/Moncton
    {   44, 8288,   18909,  9, }, // America/Monterrey
    {   44, 4117,   18918, 11, }, // America/Montevideo
    {   44, 5843,   18929,  9, }, // America/Montserrat
    {   44, 5500,   18938,  5, }, // America/Nassau
    {   44, 2381,   18943, 10, }, // America/New_York
    {   44, 8306,   18856,  3, }, // America/Nome
    {   44, 1852,   18953,  9, }, // America/Noronha
    {   44, 8319,   18962, 20, }, // America/North_Dakota/Beulah
    {   44, 8347,   18982, 21, }, // America/North_Dakota/Center
    {   44, 8375,   19003, 23, }, // America/North_Dakota/New_Salem
    {   44,  393,   19026,  3, }, // America/Nuuk
    {   44, 8406,   19029,  8, }, // America/Ojinaga
    {   44, 2358,   19037,  6, }, // America/Panama
    {   44, 6192,   19043, 10, }, // America/Paramaribo
    {   44, 2975,   19053,  7, }, // America/Phoenix
    {   44, 3964,   19060, 15, }, // America/Port-au-Prince
    {   44, 5973,   19075, 15, }, // America/Port_of_Spain
    {   44, 8422,   19090, 14, }, // America/Porto_Velho
    {   44, 5862,   19104, 13, }, // America/Puerto_Rico
    {   44, 4049,   19117, 13, }, // America/Punta_Arenas
    {   44, 8442,   19130, 12, }, // America/Rankin_Inlet
    {   44, 8463,   19142,  6, }, // America/Recife
    {   44, 1997,   19148,  6, }, // America/Regina
    {   44, 8478,   19154,  8, }, // America/Resolute
    {   44,  695,   19162, 12, }, // America/Rio_Branco
    {   44, 8495,   19174,  9, }, // America/Santarem
    {   44, 2203,   19183, 11, }, // America/Santiago
    {   44, 6130,   19194, 14, }, // America/Santo_Domingo
    {   44, 1880,   19208,  9, }, // America/Sao_Paulo
    {   44, 6918,   19217, 13, }, // America/Scoresbysund
    {   44, 8512,   19230,  8, }, // America/Sitka
    {   44, 8526,   19238, 16, }, // America/St_Barthelemy
    {   44, 2063,   19254, 11, }, // America/St_Johns
    {   44, 5882,   19265, 11, }, // America/St_Kitts
    {   44, 5899,   19276, 14, }, // America/St_Lucia
    {   44,  855,   19290, 11, }, // America/St_Thomas
    {   44, 5932,   19301, 15, }, // America/St_Vincent
    {   44, 8548,   19316, 14, }, // America/Swift_Current
    {   44, 5480,   19330, 12, }, // America/Tegucigalpa
    {   44, 5775,   19342,  6, }, // America/Thule
    {   44,  313,   19348,  8, }, // America/Tijuana
    {   44,  608,   19356,  8, }, // America/Toronto
    {   44, 5707,   19364,  8, }, // America/Tortola
    {   44, 2095,   19372,  8, }, // America/Vancouver
    {   44, 2146,   19380, 10, }, // America/Whitehorse
    {   44,  734,   19390,  7, }, // America/Winnipeg
    {   44, 8570,   19397,  8, }, // America/Yakutat
    {   44, 6020,   19405,  4, }, // Antarctica/Casey
    {   44, 6113,   19409,  5, }, // Antarctica/Davis
    {   44, 6152,   19414, 18, }, // Antarctica/DumontDUrville
    {   44, 8586,   19432, 11, }, // Antarctica/Macquarie
    {   44, 7085,   19443,  5, }, // Antarctica/Mawson
    {   44,  932,   19448,  9, }, // Antarctica/McMurdo
    {   44, 8607,   19457,  4, }, // Antarctica/Palmer
    {   44, 7226,   19461,  6, }, // Antarctica/Rothera
    {   44, 7295,   19467,  6, }, // Antarctica/Syowa
    {   44, 8625,   19473,  5, }, // Antarctica/Troll
    {   44, 7374,   19478,  6, }, // Antarctica/Vostok
    {   44, 1431,   19484, 12, }, // Arctic/Longyearbyen
    {   44, 5589,   19496,  4, }, // Asia/Aden
    {   44, 5414,   19500,  6, }, // Asia/Almaty
    {   44, 3987,   19506,  6, }, // Asia/Amman
    {   44, 5530,   19512,  6, }, // Asia/Anadyr
    {   44, 5542,   19518, 10, }, // Asia/Aqtau
    {   44, 5387,   19528,  7, }, // Asia/Aqtobe
    {   44,  966,   19535, 11, }, // Asia/Ashgabat
    {   44, 8642,   19546,  5, }, // Asia/Atyrau
    {   44, 3626,   19551,  6, }, // Asia/Baghdad
    {   44, 5553,   19557,  7, }, // Asia/Bahrain
    {   44, 3672,   18332,  4, }, // Asia/Baku
    {   44, 4485,   19564,  5, }, // Asia/Bangkok
    {   44, 3590,   19569,  7, }, // Asia/Barnaul
    {   44, 4105,   19576,  6, }, // Asia/Beirut
    {   44, 3797,   19582, 10, }, // Asia/Bishkek
    {   44, 6008,   19592,  7, }, // Asia/Brunei
    {   44, 4620,   19599,  4, }, // Asia/Chita
    {   44, 4530,   19603,  6, }, // Asia/Colombo
    {   44, 4559,   19609,  9, }, // Asia/Damascus
    {   44, 1095,   19618,  4, }, // Asia/Dhaka
    {   44, 6211,   19622,  4, }, // Asia/Dili
    {   44, 3615,   19626,  5, }, // Asia/Dubai
    {   44, 6178,   19631,  7, }, // Asia/Dushanbe
    {   44, 8654,   19638, 10, }, // Asia/Famagusta
    {   44, 8669,   19648,  4, }, // Asia/Gaza
    {   44, 4814,   19652,  7, }, // Asia/Hebron
    {   44, 1261,   19659, 14, }, // Asia/Ho_Chi_Minh
    {   44, 2706,   19673,  5, }, // Asia/Hong_Kong
    {   44, 4790,   19678,  6, }, // Asia/Hovd
    {   44, 4203,   19684, 10, }, // Asia/Irkutsk
    {   44, 7025,   19694,  8, }, // Asia/Jakarta
    {   44, 7011,   19702,  9, }, // Asia/Jayapura
    {   44, 1292,   19711,  9, }, // Asia/Jerusalem
    {   44, 3579,   19720,  5, }, // Asia/Kabul
    {   44, 4335,   19725,  8, }, // Asia/Kamchatka
    {   44, 4258,   19733,  5, }, // Asia/Karachi
    {   44, 1187,   19738,  9, }, // Asia/Kathmandu
    {   44, 8679,   19747,  8, }, // Asia/Khandyga
    {   44,  994,   19755,  6, }, // Asia/Kolkata
    {   44, 4216,   19761, 15, }, // Asia/Krasnoyarsk
    {   44, 4878,   19776, 12, }, // Asia/Kuala_Lumpur
    {   44, 5995,   19788,  5, }, // Asia/Kuching
    {   44, 5566,   19793,  6, }, // Asia/Kuwait
    {   44, 1213,   19799,  5, }, // Asia/Macau
    {   44, 4036,   19804,  7, }, // Asia/Magadan
    {   44, 1351,   19811,  7, }, // Asia/Makassar
    {   44, 7182,   19818,  6, }, // Asia/Manila
    {   44, 6939,   19824,  7, }, // Asia/Muscat
    {   44, 2556,   19831,  9, }, // Asia/Nicosia
    {   44, 8693,   19840, 14, }, // Asia/Novokuznetsk
    {   44, 4154,   19854, 13, }, // Asia/Novosibirsk
    {   44, 4248,   19867,  5, }, // Asia/Omsk
    {   44, 7145,   19872,  5, }, // Asia/Oral
    {   44, 6980,   19877, 10, }, // Asia/Phnom_Penh
    {   44, 8711,   19887, 11, }, // Asia/Pontianak
    {   44, 4233,   19898,  8, }, // Asia/Pyongyang
    {   44, 5578,   19906,  5, }, // Asia/Qatar
    {   44, 8726,   19911,  8, }, // Asia/Qostanay
    {   44, 4288,   19919, 10, }, // Asia/Qyzylorda
    {   44, 3603,   19929,  6, }, // Asia/Riyadh
    {   44, 4427,   19935,  7, }, // Asia/Sakhalin
    {   44, 7245,   19942, 10, }, // Asia/Samarkand
    {   44, 3298,   19952,  4, }, // Asia/Seoul
    {   44, 1055,   19956,  6, }, // Asia/Shanghai
    {   44, 3319,   19962,  8, }, // Asia/Singapore
    {   44, 4316,   19970, 15, }, // Asia/Srednekolymsk
    {   44, 3282,   19985,  6, }, // Asia/Taipei
    {   44, 4800,   19991,  8, }, // Asia/Tashkent
    {   44, 3934,   19999,  7, }, // Asia/Tbilisi
    {   44, 2774,   20006,  6, }, // Asia/Tehran
    {   44, 1319,   20012,  6, }, // Asia/Thimphu
    {   44, 2823,   20018,  5, }, // Asia/Tokyo
    {   44, 4591,   20023,  8, }, // Asia/Tomsk
    {   44, 1023,   20031,  9, }, // Asia/Ulaanbaatar
    {   44, 1161,   20040,  8, }, // Asia/Urumqi
    {   44, 8740,   20048,  9, }, // Asia/Ust-Nera
    {   44, 6996,   20057, 13, }, // Asia/Vientiane
    {   44, 4729,   20070, 12, }, // Asia/Vladivostok
    {   44, 4847,   20082, 10, }, // Asia/Yakutsk
    {   44, 1237,   20092,  6, }, // Asia/Yangon
    {   44, 3902,   20098, 15, }, // Asia/Yekaterinburg
    {   44, 3766,   20113,  8, }, // Asia/Yerevan
    {   44, 3682,   20121,  6, }, // Atlantic/Azores
    {   44, 5690,   20127,  8, }, // Atlantic/Bermuda
    {   44, 6647,   20135,  6, }, // Atlantic/Canary
    {   44, 3746,   20141, 10, }, // Atlantic/Cape_Verde
    {   44, 1397,   20151,  4, }, // Atlantic/Faroe
    {   44, 8754,   20155,  6, }, // Atlantic/Madeira
    {   44, 2750,   20161,  9, }, // Atlantic/Reykjavik
    {   44, 7272,   20170, 15, }, // Atlantic/South_Georgia
    {   44, 6840,   20185, 13, }, // Atlantic/St_Helena
    {   44, 6663,   20198,  9, }, // Atlantic/Stanley
    {   44, 1672,   20207,  7, }, // Australia/Adelaide
    {   44, 1637,   20214,  8, }, // Australia/Brisbane
    {   44, 1801,   20222, 11, }, // Australia/Broken_Hill
    {   44, 1585,   20233,  6, }, // Australia/Darwin
    {   44, 3656,   20239,  6, }, // Australia/Eucla
    {   44, 1518,   20245,  7, }, // Australia/Hobart
    {   44, 8771,   20252,  8, }, // Australia/Lindeman
    {   44, 1549,   20260,  8, }, // Australia/Lord_Howe
    {   44, 1729,   20268,  8, }, // Australia/Melbourne
    {   44, 1764,   20276,  5, }, // Australia/Perth
    {   44, 1465,   20281,  5, }, // Australia/Sydney
    {   44, 6460,   20286, 10, }, // Europe/Amsterdam
    {   44, 6235,   20296,  7, }, // Europe/Andorra
    {   44, 3639,   20303, 10, }, // Europe/Astrakhan
    {   44, 2302,   20313,  6, }, // Europe/Athens
    {   44, 6355,   20319,  8, }, // Europe/Belgrade
    {   44, 4776,   20327,  7, }, // Europe/Berlin
    {   44, 6507,   20334, 11, }, // Europe/Bratislava
    {   44, 2169,   20345,  8, }, // Europe/Brussels
    {   44, 3947,   20353,  9, }, // Europe/Bucharest
    {   44, 3825,   20362,  9, }, // Europe/Budapest
    {   44, 8790,   20371,  8, }, // Europe/Busingen
    {   44, 2585,   20379,  7, }, // Europe/Chisinau
    {   44, 6308,   20386, 10, }, // Europe/Copenhagen
    {   44, 2340,   20396,  6, }, // Europe/Dublin
    {   44, 6326,   20402, 10, }, // Europe/Gibraltar
    {   44, 8806,   20412,  7, }, // Europe/Guernsey
    {   44, 6631,   20419,  8, }, // Europe/Helsinki
    {   44, 8822,   20427, 10, }, // Europe/Isle_of_Man
    {   44, 1132,   20437,  9, }, // Europe/Istanbul
    {   44, 8841,   20446,  6, }, // Europe/Jersey
    {   44, 3998,   20452, 12, }, // Europe/Kaliningrad
    {   44, 8855,   20464,  5, }, // Europe/Kirov
    {   44, 2529,   20469,  3, }, // Europe/Kyiv
    {   44, 3232,   20472,  5, }, // Europe/Lisbon
    {   44, 6525,   20477, 11, }, // Europe/Ljubljana
    {   44, 2503,   20488,  5, }, // Europe/London
    {   44, 6384,   20493, 12, }, // Europe/Luxembourg
    {   44, 4911,   20505,  7, }, // Europe/Madrid
    {   44, 6416,   20512,  6, }, // Europe/Malta
    {   44, 6601,   20518, 10, }, // Europe/Mariehamn
    {   44, 3712,   20528,  6, }, // Europe/Minsk
    {   44, 6429,   20534,  6, }, // Europe/Monaco
    {   44, 3556,   20540,  5, }, // Europe/Moscow
    {   44, 6477,   20545,  5, }, // Europe/Oslo
    {   44, 4303,   20550,  5, }, // Europe/Paris
    {   44, 6443,   20555,  9, }, // Europe/Podgorica
    {   44, 6294,   20564,  5, }, // Europe/Prague
    {   44, 8868,   20569,  4, }, // Europe/Riga
    {   44, 6343,   20153,  3, }, // Europe/Rome
    {   44, 4350,   20573,  6, }, // Europe/Samara
    {   44, 6489,   20579, 10, }, // Europe/San_Marino
    {   44, 6264,   20589,  8, }, // Europe/Sarajevo
    {   44, 4470,   20597,  7, }, // Europe/Saratov
    {   44, 8880,   20604, 11, }, // Europe/Simferopol
    {   44, 6402,   20615,  8, }, // Europe/Skopje
    {   44, 6618,   20623,  7, }, // Europe/Sofia
    {   44, 6542,   20630,  7, }, // Europe/Stockholm
    {   44, 8898,   20637,  5, }, // Europe/Tallinn
    {   44, 6221,   20642,  6, }, // Europe/Tirane
    {   44, 8913,   20648, 13, }, // Europe/Ulyanovsk
    {   44, 6371,   20661,  5, }, // Europe/Vaduz
    {   44, 6586,   20666,  7, }, // Europe/Vatican
    {   44, 6250,   20673,  7, }, // Europe/Vienna
    {   44, 8930,   20680,  9, }, // Europe/Vilnius
    {   44, 4746,   20689, 11, }, // Europe/Volgograd
    {   44, 3209,   20700,  6, }, // Europe/Warsaw
    {   44, 6280,   20706,  7, }, // Europe/Zagreb
    {   44, 6559,   20713,  5, }, // Europe/Zurich
    {   44, 5097,   20718, 13, }, // Indian/Antananarivo
    {   44, 6966,   20731,  5, }, // Indian/Chagos
    {   44, 6065,   20736, 10, }, // Indian/Christmas
    {   44, 6082,   20746,  5, }, // Indian/Cocos
    {   44, 5048,   20751,  6, }, // Indian/Comoro
    {   44, 6680,   20757,  8, }, // Indian/Kerguelen
    {   44, 7260,   20765,  4, }, // Indian/Mahe
    {   44, 7069,   20769,  8, }, // Indian/Maldives
    {   44, 4088,   20777,  6, }, // Indian/Mauritius
    {   44, 5117,   20783,  9, }, // Indian/Mayotte
    {   44, 7211,   20792,  9, }, // Indian/Reunion
    {   44, 4441,   20801,  6, }, // Pacific/Apia
    {   44, 3009,   20807,  7, }, // Pacific/Auckland
    {   44, 3725,   20814, 10, }, // Pacific/Bougainville
    {   44, 3034,   20824,  5, }, // Pacific/Chatham
    {   44, 3176,   20829,  5, }, // Pacific/Chuuk
    {   44, 2239,   20834,  6, }, // Pacific/Easter
    {   44, 7360,   20840,  4, }, // Pacific/Efate
    {   44, 7327,   20844,  7, }, // Pacific/Fakaofo
    {   44, 3921,   20851,  4, }, // Pacific/Fiji
    {   44, 7343,   20855,  8, }, // Pacific/Funafuti
    {   44, 6697,   20863,  9, }, // Pacific/Galapagos
    {   44, 6715,   20872, 10, }, // Pacific/Gambier
    {   44, 3841,   20882, 11, }, // Pacific/Guadalcanal
    {   44, 6037,   18810,  5, }, // Pacific/Guam
    {   44, 3068,   20893,  6, }, // Pacific/Kanton
    {   44, 4017,   20899, 10, }, // Pacific/Kiritimati
    {   44, 7038,   20909,  8, }, // Pacific/Kosrae
    {   44, 2844,   20917,  9, }, // Pacific/Kwajalein
    {   44, 4896,   20926,  6, }, // Pacific/Majuro
    {   44, 4070,   20932,  8, }, // Pacific/Marquesas
    {   44, 8945,   20940,  5, }, // Pacific/Midway
    {   44, 7103,   20945,  4, }, // Pacific/Nauru
    {   44, 7132,   20949,  5, }, // Pacific/Niue
    {   44, 4187,   20954,  6, }, // Pacific/Norfolk
    {   44, 7117,   20960,  7, }, // Pacific/Noumea
    {   44, 3145,   20967,  9, }, // Pacific/Pago_Pago
    {   44, 7155,   20976,  5, }, // Pacific/Palau
    {   44, 7194,   20981,  9, }, // Pacific/Pitcairn
    {   44, 3115,   20990,  6, }, // Pacific/Pohnpei
    {   44, 4826,   20996, 15, }, // Pacific/Port_Moresby
    {   44, 6095,   21011, 10, }, // Pacific/Rarotonga
    {   44, 6050,   21021,  6, }, // Pacific/Saipan
    {   44, 7312,   21027,  6, }, // Pacific/Tahiti
    {   44, 6731,   21033,  6, }, // Pacific/Tarawa
    {   44, 4602,   21039,  8, }, // Pacific/Tongatapu
    {   44, 7392,   21047,  3, }, // Pacific/Wake
    {   44, 7405,   21050,  5, }, // Pacific/Wallis
    {   45, 5078,   21055, 10, }, // Africa/Addis_Ababa Asturian/Latin/Spain
    {   45, 7420,   21065,  5, }, // Africa/Algiers
    {   45,   14,       0,  6, }, // Africa/Asmara
    {   45, 2322,   21070,  8, }, // Africa/Cairo
    {   45, 5062,   21078,  6, }, // Africa/Djibouti
    {   45, 5185,       6,  8, }, // Africa/El_Aaiun
    {   45, 4498,   21084, 13, }, // Africa/Johannesburg
    {   45, 4543,   21097,  6, }, // Africa/Khartoum
    {   45, 6888,      14,  4, }, // Africa/Lome
    {   45, 5132,   21103,  8, }, // Africa/Mogadishu
    {   45, 5290,   21111,  6, }, // Africa/Ndjamena
    {   45, 5373,   21117,  6, }, // Africa/Niamey
    {   45, 6822,   21123,  7, }, // Africa/Nouakchott
    {   45, 6746,   21130,  8, }, // Africa/Ouagadougou
    {   45, 4454,   21138, 10, }, // Africa/Sao_Tome
    {   45, 2868,   21148,  7, }, // Africa/Tripoli
    {   45, 6573,   21155,  5, }, // Africa/Tunis
    {   45, 5626,    5439,  7, }, // America/Anguilla
    {   45, 4573,      35,  9, }, // America/Araguaina
    {   45,  270,      44,  7, }, // America/Argentina/Cordoba
    {   45, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   45, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   45, 4271,      70,  8, }, // America/Asuncion
    {   45,  237,      78,  8, }, // America/Atikokan
    {   45, 3698,      86,  5, }, // America/Bahia
    {   45, 7623,   21160, 14, }, // America/Bahia_Banderas
    {   45, 7646,     103,  5, }, // America/Belem
    {   45, 4380,     108,  6, }, // America/Bogota
    {   45, 3887,     114,  6, }, // America/Cancun
    {   45, 5515,   21174,  6, }, // America/Cayman
    {   45, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   45, 3810,     133,  6, }, // America/Cuiaba
    {   45, 5742,     139,  7, }, // America/Curacao
    {   45, 7887,     146,  8, }, // America/Eirunepe
    {   45, 5789,   21180,  7, }, // America/Grenada
    {   45, 5805,   21187,  9, }, // America/Guadeloupe
    {   45, 2283,   21196,  9, }, // America/Havana
    {   45,  481,     154, 13, }, // America/Indiana/Knox
    {   45, 7979,     167, 16, }, // America/Indiana/Marengo
    {   45, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   45, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   45, 8056,     220, 14, }, // America/Indiana/Vevay
    {   45, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   45, 8104,     252, 16, }, // America/Indiana/Winamac
    {   45, 2801,   21205,  7, }, // America/Jamaica
    {   45, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   45, 5951,     288, 22, }, // America/Lower_Princes
    {   45, 8171,     310,  6, }, // America/Maceio
    {   45, 5824,   21212, 12, }, // America/Martinique
    {   45, 2919,     316,  8, }, // America/Mazatlan
    {   45, 8238,     324,  6, }, // America/Merida
    {   45, 2951,   21224, 15, }, // America/Mexico_City
    {   45, 4410,     341, 12, }, // America/Miquelon
    {   45, 2381,   21239, 10, }, // America/New_York
    {   45, 1852,     353, 19, }, // America/Noronha
    {   45, 8319,   21249, 24, }, // America/North_Dakota/Beulah
    {   45, 8347,   21273, 24, }, // America/North_Dakota/Center
    {   45, 8375,   21297, 29, }, // America/North_Dakota/New_Salem
    {   45,  393,     435,  4, }, // America/Nuuk
    {   45, 2358,   21326,  6, }, // America/Panama
    {   45, 3964,   21332, 15, }, // America/Port-au-Prince
    {   45, 5973,   21347, 13, }, // America/Port_of_Spain
    {   45, 5862,   21360, 11, }, // America/Puerto_Rico
    {   45, 8495,     439,  8, }, // America/Santarem
    {   45, 6130,   21371, 13, }, // America/Santo_Domingo
    {   45, 1880,     447,  9, }, // America/Sao_Paulo
    {   45, 6918,     456, 16, }, // America/Scoresbysund
    {   45, 8526,     472, 14, }, // America/St_Barthelemy
    {   45, 2063,     486, 10, }, // America/St_Johns
    {   45, 5882,     496,  9, }, // America/St_Kitts
    {   45, 5899,     505,  9, }, // America/St_Lucia
    {   45,  855,     514, 10, }, // America/St_Thomas
    {   45, 5932,     524, 11, }, // America/St_Vincent
    {   45, 5707,   21384,  7, }, // America/Tortola
    {   45, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   45, 7295,     643,  5, }, // Antarctica/Syowa
    {   45, 3987,   21391,  4, }, // Asia/Amman
    {   45, 3626,   21395,  6, }, // Asia/Baghdad
    {   45, 5553,   21401,  7, }, // Asia/Bahrain
    {   45, 3672,   21408,  4, }, // Asia/Baku
    {   45, 6008,   21412,  6, }, // Asia/Brunei
    {   45, 4559,   21418,  7, }, // Asia/Damascus
    {   45, 6178,   21425,  7, }, // Asia/Dushanbe
    {   45, 4814,   21432,  6, }, // Asia/Hebron
    {   45, 1261,   21438, 20, }, // Asia/Ho_Chi_Minh
    {   45, 2706,   21458,  9, }, // Asia/Hong_Kong
    {   45, 4790,     704,  5, }, // Asia/Hovd
    {   45, 7025,   21467,  7, }, // Asia/Jakarta
    {   45, 7011,   21474,  8, }, // Asia/Jayapura
    {   45, 1292,   21482,  9, }, // Asia/Jerusalem
    {   45, 1187,   21491,  8, }, // Asia/Kathmandu
    {   45,  994,   21499,  7, }, // Asia/Kolkata
    {   45, 1213,   21506,  5, }, // Asia/Macau
    {   45, 4036,   21511,  7, }, // Asia/Magadan
    {   45, 6939,   21518,  7, }, // Asia/Muscat
    {   45, 4233,   21525, 10, }, // Asia/Pyongyang
    {   45, 3603,   21535,  5, }, // Asia/Riyadh
    {   45, 4427,   21540,  7, }, // Asia/Sakhalin
    {   45, 7245,   21547, 10, }, // Asia/Samarkand
    {   45, 3298,   21557,  4, }, // Asia/Seoul
    {   45, 3319,   21561,  8, }, // Asia/Singapore
    {   45, 2774,   21569,  6, }, // Asia/Tehran
    {   45, 2823,   21575,  5, }, // Asia/Tokyo
    {   45, 1023,   21580, 10, }, // Asia/Ulaanbaatar
    {   45, 1161,     747,  6, }, // Asia/Urumqi
    {   45, 6996,   21590,  8, }, // Asia/Vientiane
    {   45, 1237,   21598,  6, }, // Asia/Yangon
    {   45, 3902,   21604, 14, }, // Asia/Yekaterinburg
    {   45, 3682,   21618, 10, }, // Atlantic/Azores
    {   45, 6647,     759,  8, }, // Atlantic/Canary
    {   45, 3746,   21628, 10, }, // Atlantic/Cape_Verde
    {   45, 1397,   21638, 12, }, // Atlantic/Faroe
    {   45, 2750,   21650,  9, }, // Atlantic/Reykjavik
    {   45, 7272,   21659, 14, }, // Atlantic/South_Georgia
    {   45, 6840,   21673, 10, }, // Atlantic/St_Helena
    {   45, 1672,   21683,  8, }, // Australia/Adelaide
    {   45, 3639,   21691,  8, }, // Europe/Astrakhan
    {   45, 2302,   21699,  6, }, // Europe/Athens
    {   45, 6355,   21705,  7, }, // Europe/Belgrade
    {   45, 4776,   21712,  6, }, // Europe/Berlin
    {   45, 2169,   21718,  8, }, // Europe/Brussels
    {   45, 3947,   21726,  8, }, // Europe/Bucharest
    {   45, 8790,     799,  8, }, // Europe/Busingen
    {   45, 2585,     807,  8, }, // Europe/Chisinau
    {   45, 6308,   21734, 10, }, // Europe/Copenhagen
    {   45, 2340,   21744,  6, }, // Europe/Dublin
    {   45, 6326,   21750,  9, }, // Europe/Gibraltar
    {   45, 6631,   21759,  8, }, // Europe/Helsinki
    {   45, 8822,   21767, 12, }, // Europe/Isle_of_Man
    {   45, 3998,   21779, 11, }, // Europe/Kaliningrad
    {   45, 2529,    8801,  4, }, // Europe/Kyiv
    {   45, 3232,   21790,  6, }, // Europe/Lisbon
    {   45, 6525,   21796,  9, }, // Europe/Ljubljana
    {   45, 2503,   21805,  7, }, // Europe/London
    {   45, 6384,   21812, 10, }, // Europe/Luxembourg
    {   45, 6429,   21822,  6, }, // Europe/Monaco
    {   45, 3556,   21828,  5, }, // Europe/Moscow
    {   45, 4303,   21833,  5, }, // Europe/Paris
    {   45, 6294,   21838,  5, }, // Europe/Prague
    {   45, 6343,   21843,  4, }, // Europe/Rome
    {   45, 6489,   21847,  9, }, // Europe/San_Marino
    {   45, 6618,   21856,  5, }, // Europe/Sofia
    {   45, 6542,   21861,  9, }, // Europe/Stockholm
    {   45, 6221,     819,  6, }, // Europe/Tirane
    {   45, 6586,   21870, 11, }, // Europe/Vatican
    {   45, 6250,   21881,  5, }, // Europe/Vienna
    {   45, 4746,   21886,  9, }, // Europe/Volgograd
    {   45, 3209,   21895,  8, }, // Europe/Warsaw
    {   45, 5048,    4421,  7, }, // Indian/Comoro
    {   45, 7260,     896,  4, }, // Indian/Mahe
    {   45, 4088,   21903,  8, }, // Indian/Mauritius
    {   45, 7211,   21911,  7, }, // Indian/Reunion
    {   45, 3176,     922,  5, }, // Pacific/Chuuk
    {   45, 2239,   21918,  6, }, // Pacific/Easter
    {   45, 3921,   21924,  4, }, // Pacific/Fiji
    {   45, 6697,     940,  9, }, // Pacific/Galapagos
    {   45, 2725,    5251,  8, }, // Pacific/Honolulu
    {   45, 3068,     957,  6, }, // Pacific/Kanton
    {   45, 7117,    1028,  6, }, // Pacific/Noumea
    {   45, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   45, 7405,    1068, 15, }, // Pacific/Wallis
    {   46,   14,       0,  6, }, // Africa/Asmara Asu/Latin/Tanzania
    {   46, 5185,       6,  8, }, // Africa/El_Aaiun
    {   46, 6888,      14,  4, }, // Africa/Lome
    {   46, 5290,      18,  9, }, // Africa/Ndjamena
    {   46, 4454,      27,  8, }, // Africa/Sao_Tome
    {   46, 4573,      35,  9, }, // America/Araguaina
    {   46,  270,      44,  7, }, // America/Argentina/Cordoba
    {   46, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   46, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   46, 4271,      70,  8, }, // America/Asuncion
    {   46,  237,      78,  8, }, // America/Atikokan
    {   46, 7623,      86, 17, }, // America/Bahia_Banderas
    {   46, 7646,     103,  5, }, // America/Belem
    {   46, 4380,     108,  6, }, // America/Bogota
    {   46, 3887,     114,  6, }, // America/Cancun
    {   46, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   46, 3810,     133,  6, }, // America/Cuiaba
    {   46, 5742,     139,  7, }, // America/Curacao
    {   46, 7887,     146,  8, }, // America/Eirunepe
    {   46,  481,     154, 13, }, // America/Indiana/Knox
    {   46, 7979,     167, 16, }, // America/Indiana/Marengo
    {   46, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   46, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   46, 8056,     220, 14, }, // America/Indiana/Vevay
    {   46, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   46, 8104,     252, 16, }, // America/Indiana/Winamac
    {   46, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   46, 5951,     288, 22, }, // America/Lower_Princes
    {   46, 8171,     310,  6, }, // America/Maceio
    {   46, 2919,     316,  8, }, // America/Mazatlan
    {   46, 8238,     324,  6, }, // America/Merida
    {   46, 2951,    4381, 16, }, // America/Mexico_City
    {   46, 4410,     341, 12, }, // America/Miquelon
    {   46, 1852,     353, 19, }, // America/Noronha
    {   46, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   46, 8347,     392, 20, }, // America/North_Dakota/Center
    {   46, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   46,  393,     435,  4, }, // America/Nuuk
    {   46, 8495,     439,  8, }, // America/Santarem
    {   46, 1880,     447,  9, }, // America/Sao_Paulo
    {   46, 6918,     456, 16, }, // America/Scoresbysund
    {   46, 8526,     472, 14, }, // America/St_Barthelemy
    {   46, 2063,     486, 10, }, // America/St_Johns
    {   46, 5882,     496,  9, }, // America/St_Kitts
    {   46, 5899,     505,  9, }, // America/St_Lucia
    {   46,  855,     514, 10, }, // America/St_Thomas
    {   46, 5932,     524, 11, }, // America/St_Vincent
    {   46, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   46, 7295,     643,  5, }, // Antarctica/Syowa
    {   46, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   46, 4790,     704,  5, }, // Asia/Hovd
    {   46, 1187,     709,  9, }, // Asia/Kathmandu
    {   46,  994,     718,  7, }, // Asia/Kolkata
    {   46, 1213,     725,  5, }, // Asia/Macau
    {   46, 1161,     747,  6, }, // Asia/Urumqi
    {   46, 1237,     753,  6, }, // Asia/Yangon
    {   46, 6647,    4413,  8, }, // Atlantic/Canary
    {   46, 1397,     767,  5, }, // Atlantic/Faroe
    {   46, 6840,     773, 10, }, // Atlantic/St_Helena
    {   46, 8790,     799,  8, }, // Europe/Busingen
    {   46, 2585,     807,  8, }, // Europe/Chisinau
    {   46, 2529,     815,  4, }, // Europe/Kyiv
    {   46, 6221,     819,  6, }, // Europe/Tirane
    {   46, 5048,    4421,  7, }, // Indian/Comoro
    {   46, 7260,     896,  4, }, // Indian/Mahe
    {   46, 7211,     900,  7, }, // Indian/Reunion
    {   46, 3176,     922,  5, }, // Pacific/Chuuk
    {   46, 6697,     940,  9, }, // Pacific/Galapagos
    {   46, 3068,     957,  6, }, // Pacific/Kanton
    {   46, 7117,    1028,  6, }, // Pacific/Noumea
    {   46, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   46, 7405,    1068, 15, }, // Pacific/Wallis
    {   47,   14,       0,  6, }, // Africa/Asmara Atsam/Latin/Nigeria
    {   47, 5185,       6,  8, }, // Africa/El_Aaiun
    {   47, 6888,      14,  4, }, // Africa/Lome
    {   47, 5290,      18,  9, }, // Africa/Ndjamena
    {   47, 4454,      27,  8, }, // Africa/Sao_Tome
    {   47, 4573,      35,  9, }, // America/Araguaina
    {   47,  270,      44,  7, }, // America/Argentina/Cordoba
    {   47, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   47, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   47, 4271,      70,  8, }, // America/Asuncion
    {   47,  237,      78,  8, }, // America/Atikokan
    {   47, 7623,      86, 17, }, // America/Bahia_Banderas
    {   47, 7646,     103,  5, }, // America/Belem
    {   47, 4380,     108,  6, }, // America/Bogota
    {   47, 3887,     114,  6, }, // America/Cancun
    {   47, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   47, 3810,     133,  6, }, // America/Cuiaba
    {   47, 5742,     139,  7, }, // America/Curacao
    {   47, 7887,     146,  8, }, // America/Eirunepe
    {   47,  481,     154, 13, }, // America/Indiana/Knox
    {   47, 7979,     167, 16, }, // America/Indiana/Marengo
    {   47, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   47, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   47, 8056,     220, 14, }, // America/Indiana/Vevay
    {   47, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   47, 8104,     252, 16, }, // America/Indiana/Winamac
    {   47, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   47, 5951,     288, 22, }, // America/Lower_Princes
    {   47, 8171,     310,  6, }, // America/Maceio
    {   47, 2919,     316,  8, }, // America/Mazatlan
    {   47, 8238,     324,  6, }, // America/Merida
    {   47, 2951,    4381, 16, }, // America/Mexico_City
    {   47, 4410,     341, 12, }, // America/Miquelon
    {   47, 1852,     353, 19, }, // America/Noronha
    {   47, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   47, 8347,     392, 20, }, // America/North_Dakota/Center
    {   47, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   47,  393,     435,  4, }, // America/Nuuk
    {   47, 8495,     439,  8, }, // America/Santarem
    {   47, 1880,     447,  9, }, // America/Sao_Paulo
    {   47, 6918,     456, 16, }, // America/Scoresbysund
    {   47, 8526,     472, 14, }, // America/St_Barthelemy
    {   47, 2063,     486, 10, }, // America/St_Johns
    {   47, 5882,     496,  9, }, // America/St_Kitts
    {   47, 5899,     505,  9, }, // America/St_Lucia
    {   47,  855,     514, 10, }, // America/St_Thomas
    {   47, 5932,     524, 11, }, // America/St_Vincent
    {   47, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   47, 7295,     643,  5, }, // Antarctica/Syowa
    {   47, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   47, 4790,     704,  5, }, // Asia/Hovd
    {   47, 1187,     709,  9, }, // Asia/Kathmandu
    {   47,  994,     718,  7, }, // Asia/Kolkata
    {   47, 1213,     725,  5, }, // Asia/Macau
    {   47, 1161,     747,  6, }, // Asia/Urumqi
    {   47, 1237,     753,  6, }, // Asia/Yangon
    {   47, 6647,    4413,  8, }, // Atlantic/Canary
    {   47, 1397,     767,  5, }, // Atlantic/Faroe
    {   47, 6840,     773, 10, }, // Atlantic/St_Helena
    {   47, 8790,     799,  8, }, // Europe/Busingen
    {   47, 2585,     807,  8, }, // Europe/Chisinau
    {   47, 2529,     815,  4, }, // Europe/Kyiv
    {   47, 6221,     819,  6, }, // Europe/Tirane
    {   47, 5048,    4421,  7, }, // Indian/Comoro
    {   47, 7260,     896,  4, }, // Indian/Mahe
    {   47, 7211,     900,  7, }, // Indian/Reunion
    {   47, 3176,     922,  5, }, // Pacific/Chuuk
    {   47, 6697,     940,  9, }, // Pacific/Galapagos
    {   47, 3068,     957,  6, }, // Pacific/Kanton
    {   47, 7117,    1028,  6, }, // Pacific/Noumea
    {   47, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   47, 7405,    1068, 15, }, // Pacific/Wallis
    {   48, 6807,   21928,  6, }, // Africa/Abidjan Azerbaijani/Latin/Azerbaijan
    {   48, 6779,   21934,  5, }, // Africa/Accra
    {   48, 5078,   21939, 11, }, // Africa/Addis_Ababa
    {   48, 7420,   21950,  8, }, // Africa/Algiers
    {   48,   14,   21958,  6, }, // Africa/Asmara
    {   48, 5276,   21964,  6, }, // Africa/Bangui
    {   48, 6765,   21970,  6, }, // Africa/Banjul
    {   48, 4976,    6969,  7, }, // Africa/Blantyre
    {   48, 5306,   21976,  9, }, // Africa/Brazzaville
    {   48, 2322,   21985,  6, }, // Africa/Cairo
    {   48, 4136,   21991, 10, }, // Africa/Casablanca
    {   48, 7449,   22001,  5, }, // Africa/Ceuta
    {   48, 6792,    7018,  7, }, // Africa/Conakry
    {   48, 5149,   22006, 12, }, // Africa/Dar_es_Salaam
    {   48, 5062,   22018,  6, }, // Africa/Djibouti
    {   48, 5262,   22024,  5, }, // Africa/Douala
    {   48, 5185,   22029,  7, }, // Africa/El_Aaiun
    {   48, 6872,    7051,  7, }, // Africa/Freetown
    {   48, 4925,   22036,  7, }, // Africa/Gaborone
    {   48, 4498,   22043, 11, }, // Africa/Johannesburg
    {   48, 4543,   22054,  6, }, // Africa/Khartoum
    {   48, 4992,   22060,  6, }, // Africa/Kigali
    {   48, 5325,   22066,  7, }, // Africa/Kinshasa
    {   48, 4763,   22073,  5, }, // Africa/Lagos
    {   48, 5355,    7080,  8, }, // Africa/Libreville
    {   48, 6888,      14,  4, }, // Africa/Lome
    {   48, 4958,   22078,  9, }, // Africa/Lubumbashi
    {   48, 5132,   22087,  8, }, // Africa/Mogadishu
    {   48, 5290,   22095,  7, }, // Africa/Ndjamena
    {   48, 6822,   22102,  8, }, // Africa/Nouakchott
    {   48, 6746,   22110,  7, }, // Africa/Ouagadougou
    {   48, 4454,   22117,  7, }, // Africa/Sao_Tome
    {   48, 4171,   22124,  7, }, // Africa/Windhoek
    {   48, 3365,   22131,  7, }, // America/Anchorage
    {   48, 5626,   22138,  7, }, // America/Anguilla
    {   48, 5643,   22145,  7, }, // America/Antigua
    {   48, 4573,   22152,  9, }, // America/Araguaina
    {   48,  166,   22161, 12, }, // America/Argentina/Buenos_Aires
    {   48,   91,    7169,  9, }, // America/Argentina/Catamarca
    {   48,  270,    7178,  7, }, // America/Argentina/Cordoba
    {   48, 7462,   22173,  5, }, // America/Argentina/La_Rioja
    {   48, 7489,   22178, 12, }, // America/Argentina/Rio_Gallegos
    {   48, 7544,   22190,  8, }, // America/Argentina/San_Juan
    {   48, 7571,    5506,  7, }, // America/Argentina/Tucuman
    {   48, 7597,   22198,  6, }, // America/Argentina/Ushuaia
    {   48, 4271,    7243,  8, }, // America/Asuncion
    {   48,  237,      78,  8, }, // America/Atikokan
    {   48, 3698,   22204,  6, }, // America/Bahia
    {   48, 7623,   22210, 14, }, // America/Bahia_Banderas
    {   48, 7646,     103,  5, }, // America/Belem
    {   48, 5426,    7265,  5, }, // America/Belize
    {   48, 7660,    7271, 12, }, // America/Blanc-Sablon
    {   48, 4380,   22224,  6, }, // America/Bogota
    {   48, 7699,   22230,  5, }, // America/Boise
    {   48, 7713,   22235, 15, }, // America/Cambridge_Bay
    {   48, 7735,   22250, 12, }, // America/Campo_Grande
    {   48, 3887,    5574,  6, }, // America/Cancun
    {   48, 4713,    5580,  7, }, // America/Caracas
    {   48, 4364,   22262,  5, }, // America/Cayenne
    {   48, 5515,   22267,  6, }, // America/Cayman
    {   48, 2262,   22273,  6, }, // America/Chicago
    {   48, 7756,   22279,  8, }, // America/Chihuahua
    {   48, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   48, 5441,   22287, 10, }, // America/Costa_Rica
    {   48, 7796,   22297,  7, }, // America/Coyhaique
    {   48, 7814,    7389,  7, }, // America/Creston
    {   48, 3810,   22304,  6, }, // America/Cuiaba
    {   48, 5742,    7402,  7, }, // America/Curacao
    {   48, 7830,   22310, 11, }, // America/Danmarkshavn
    {   48, 7851,    7422,  6, }, // America/Dawson
    {   48, 7866,   22321, 11, }, // America/Dawson_Creek
    {   48, 3484,   22332,  7, }, // America/Detroit
    {   48, 5758,   22339,  8, }, // America/Dominica
    {   48,  893,   22347,  9, }, // America/Edmonton
    {   48, 7887,   22356,  7, }, // America/Eirunepe
    {   48, 5460,    7459,  8, }, // America/El_Salvador
    {   48, 7942,   22363, 13, }, // America/Glace_Bay
    {   48, 6900,   22376, 11, }, // America/Goose_Bay
    {   48, 4631,   22387, 10, }, // America/Grand_Turk
    {   48, 5789,   22397,  7, }, // America/Grenada
    {   48, 5805,   22404,  9, }, // America/Guadeloupe
    {   48, 3779,   22413,  9, }, // America/Guatemala
    {   48, 4860,   22422,  8, }, // America/Guayaquil
    {   48, 6951,   22430,  6, }, // America/Guyana
    {   48, 1941,    7558,  8, }, // America/Halifax
    {   48, 7960,   22436,  9, }, // America/Hermosillo
    {   48,  348,   22445, 12, }, // America/Indiana/Indianapolis
    {   48,  481,   22457,  4, }, // America/Indiana/Knox
    {   48, 7979,   22461,  7, }, // America/Indiana/Marengo
    {   48, 8003,   22468, 10, }, // America/Indiana/Petersburg
    {   48, 8030,     202,  4, }, // America/Indiana/Tell_City
    {   48, 8056,   22478,  5, }, // America/Indiana/Vevay
    {   48, 8078,   22483,  6, }, // America/Indiana/Vincennes
    {   48, 8104,   22489,  7, }, // America/Indiana/Winamac
    {   48, 8128,   22496,  6, }, // America/Inuvik
    {   48,  660,   22502,  7, }, // America/Iqaluit
    {   48, 2801,   22509,  7, }, // America/Jamaica
    {   48, 5399,   22516,  4, }, // America/Juneau
    {   48,  521,   22520,  7, }, // America/Kentucky/Louisville
    {   48, 8143,   22527, 10, }, // America/Kentucky/Monticello
    {   48, 5723,   22537,  9, }, // America/Kralendijk
    {   48, 4395,   22546,  6, }, // America/La_Paz
    {   48, 3258,   22552, 11, }, // America/Los_Angeles
    {   48, 5951,   22563, 20, }, // America/Lower_Princes
    {   48, 8171,   22583,  6, }, // America/Maceio
    {   48, 8186,   22589,  7, }, // America/Managua
    {   48, 5916,   22596,  7, }, // America/Marigot
    {   48, 5824,    5923,  8, }, // America/Martinique
    {   48, 2919,   22603,  8, }, // America/Mazatlan
    {   48, 8220,    7771,  8, }, // America/Menominee
    {   48, 8238,    7779,  6, }, // America/Merida
    {   48, 2951,   22611,  6, }, // America/Mexico_City
    {   48, 4410,    7802,  7, }, // America/Miquelon
    {   48, 8272,    7809,  7, }, // America/Moncton
    {   48, 8288,   22617,  8, }, // America/Monterrey
    {   48, 5843,   22625,  8, }, // America/Montserrat
    {   48, 2381,   22633,  8, }, // America/New_York
    {   48, 8306,   22641,  3, }, // America/Nome
    {   48, 1852,   22644,  7, }, // America/Noronha
    {   48, 8319,   22651, 21, }, // America/North_Dakota/Beulah
    {   48, 8347,   22672, 20, }, // America/North_Dakota/Center
    {   48, 8375,   22692,  9, }, // America/North_Dakota/New_Salem
    {   48,  393,     435,  4, }, // America/Nuuk
    {   48, 8406,   22701,  7, }, // America/Ojinaga
    {   48, 2975,    7936,  6, }, // America/Phoenix
    {   48, 3964,    7942, 12, }, // America/Port-au-Prince
    {   48, 5973,   22708, 12, }, // America/Port_of_Spain
    {   48, 8422,   22720, 11, }, // America/Porto_Velho
    {   48, 5862,   22731, 11, }, // America/Puerto_Rico
    {   48, 8442,   22742, 13, }, // America/Rankin_Inlet
    {   48, 8463,   22755,  5, }, // America/Recife
    {   48, 1997,   22760,  6, }, // America/Regina
    {   48, 8478,   22766,  8, }, // America/Resolute
    {   48,  695,    6143, 10, }, // America/Rio_Branco
    {   48, 8495,     439,  8, }, // America/Santarem
    {   48, 2203,   22774,  8, }, // America/Santiago
    {   48, 6130,   22782, 13, }, // America/Santo_Domingo
    {   48, 1880,   22795,  9, }, // America/Sao_Paulo
    {   48, 6918,   22804, 12, }, // America/Scoresbysund
    {   48, 8526,   22816, 14, }, // America/St_Barthelemy
    {   48, 2063,   22830,  9, }, // America/St_Johns
    {   48, 5882,   22839,  8, }, // America/St_Kitts
    {   48, 5899,   22847, 10, }, // America/St_Lucia
    {   48,  855,   22857,  9, }, // America/St_Thomas
    {   48, 5932,   22866, 11, }, // America/St_Vincent
    {   48, 8548,   22877, 12, }, // America/Swift_Current
    {   48, 5480,   22889, 11, }, // America/Tegucigalpa
    {   48, 5775,   22900,  3, }, // America/Thule
    {   48,  313,   22903,  7, }, // America/Tijuana
    {   48, 2095,    8146,  8, }, // America/Vancouver
    {   48, 2146,   22910,  8, }, // America/Whitehorse
    {   48,  734,   22918,  8, }, // America/Winnipeg
    {   48, 6020,   22926,  5, }, // Antarctica/Casey
    {   48, 6113,   22931,  6, }, // Antarctica/Davis
    {   48, 6152,     548, 14, }, // Antarctica/DumontDUrville
    {   48, 8586,   22937,  7, }, // Antarctica/Macquarie
    {   48, 7085,   22944,  6, }, // Antarctica/Mawson
    {   48,  932,   22950,  9, }, // Antarctica/McMurdo
    {   48, 7295,   22959,  5, }, // Antarctica/Syowa
    {   48, 1431,   22964,  7, }, // Arctic/Longyearbyen
    {   48, 5414,   22971,  6, }, // Asia/Almaty
    {   48, 5530,   22977,  6, }, // Asia/Anadyr
    {   48, 5542,     683,  5, }, // Asia/Aqtau
    {   48,  966,   22983,  7, }, // Asia/Ashgabat
    {   48, 8642,   22990,  6, }, // Asia/Atyrau
    {   48, 3626,   22996,  6, }, // Asia/Baghdad
    {   48, 5553,   23002,  7, }, // Asia/Bahrain
    {   48, 3672,   23009,  4, }, // Asia/Baku
    {   48, 4485,   23013,  7, }, // Asia/Bangkok
    {   48, 4105,   23020,  6, }, // Asia/Beirut
    {   48, 3797,   23026,  6, }, // Asia/Bishkek
    {   48, 6008,   23032,  6, }, // Asia/Brunei
    {   48, 4620,    8284,  4, }, // Asia/Chita
    {   48, 4530,    6295,  7, }, // Asia/Colombo
    {   48, 4559,   23038,  6, }, // Asia/Damascus
    {   48, 1095,   23044,  5, }, // Asia/Dhaka
    {   48, 3615,   23049,  5, }, // Asia/Dubai
    {   48, 6178,   23054,  7, }, // Asia/Dushanbe
    {   48, 8654,   23061,  9, }, // Asia/Famagusta
    {   48, 8669,   23070,  4, }, // Asia/Gaza
    {   48, 1261,   23074,  9, }, // Asia/Ho_Chi_Minh
    {   48, 2706,   23083,  9, }, // Asia/Hong_Kong
    {   48, 4790,     704,  5, }, // Asia/Hovd
    {   48, 4203,   23092,  7, }, // Asia/Irkutsk
    {   48, 7025,   23099,  7, }, // Asia/Jakarta
    {   48, 7011,   23106,  8, }, // Asia/Jayapura
    {   48, 1292,   23114,  9, }, // Asia/Jerusalem
    {   48, 3579,   23123,  5, }, // Asia/Kabul
    {   48, 4335,   23128,  8, }, // Asia/Kamchatka
    {   48, 4258,    8340,  6, }, // Asia/Karachi
    {   48, 1187,    6367,  8, }, // Asia/Kathmandu
    {   48, 8679,   23136,  7, }, // Asia/Khandyga
    {   48,  994,   23143,  7, }, // Asia/Kolkata
    {   48, 5995,   23150,  6, }, // Asia/Kuching
    {   48, 5566,   23156,  6, }, // Asia/Kuwait
    {   48, 1213,    8384,  5, }, // Asia/Macau
    {   48, 4036,   23162,  7, }, // Asia/Magadan
    {   48, 1351,    8389,  7, }, // Asia/Makassar
    {   48, 6939,    4966,  6, }, // Asia/Muscat
    {   48, 2556,   23169,  8, }, // Asia/Nicosia
    {   48, 6980,   23177,  8, }, // Asia/Phnom_Penh
    {   48, 4233,   23185,  7, }, // Asia/Pyongyang
    {   48, 4288,   23192,  9, }, // Asia/Qyzylorda
    {   48, 3603,   21535,  5, }, // Asia/Riyadh
    {   48, 4427,   23201,  7, }, // Asia/Sakhalin
    {   48, 7245,   23208,  9, }, // Asia/Samarkand
    {   48, 3298,    8451,  4, }, // Asia/Seoul
    {   48, 1055,   23217,  6, }, // Asia/Shanghai
    {   48, 3319,   23223,  8, }, // Asia/Singapore
    {   48, 4316,   23231, 13, }, // Asia/Srednekolymsk
    {   48, 3282,   23244,  6, }, // Asia/Taipei
    {   48, 4800,   23250,  7, }, // Asia/Tashkent
    {   48, 1023,   23257,  9, }, // Asia/Ulaanbaatar
    {   48, 1161,   23266,  6, }, // Asia/Urumqi
    {   48, 6996,   23272,  8, }, // Asia/Vientiane
    {   48, 1237,   23280,  6, }, // Asia/Yangon
    {   48, 3902,   23286, 13, }, // Asia/Yekaterinburg
    {   48, 3682,    8558,  4, }, // Atlantic/Azores
    {   48, 5690,   23299, 14, }, // Atlantic/Bermuda
    {   48, 6647,    5038,  5, }, // Atlantic/Canary
    {   48, 3746,   23313, 10, }, // Atlantic/Cape_Verde
    {   48, 1397,   23323,  5, }, // Atlantic/Faroe
    {   48, 8754,   23328,  7, }, // Atlantic/Madeira
    {   48, 2750,   23335,  9, }, // Atlantic/Reykjavik
    {   48, 7272,   23344, 14, }, // Atlantic/South_Georgia
    {   48, 6840,   23358, 15, }, // Atlantic/St_Helena
    {   48, 6663,    8618,  6, }, // Atlantic/Stanley
    {   48, 1672,   21683,  8, }, // Australia/Adelaide
    {   48, 1637,   23373,  8, }, // Australia/Brisbane
    {   48, 1585,    8651,  6, }, // Australia/Darwin
    {   48, 3656,   23381,  5, }, // Australia/Eucla
    {   48, 1549,   23386,  8, }, // Australia/Lord_Howe
    {   48, 1729,    8674,  7, }, // Australia/Melbourne
    {   48, 1764,   23394,  4, }, // Australia/Perth
    {   48, 1465,   23398,  6, }, // Australia/Sydney
    {   48, 3639,   23404,  9, }, // Europe/Astrakhan
    {   48, 2302,   23413,  5, }, // Europe/Athens
    {   48, 6355,   23418,  7, }, // Europe/Belgrade
    {   48, 2169,   23425,  7, }, // Europe/Brussels
    {   48, 3947,   23432,  8, }, // Europe/Bucharest
    {   48, 3825,   23440,  8, }, // Europe/Budapest
    {   48, 8790,     799,  8, }, // Europe/Busingen
    {   48, 2585,   23448,  8, }, // Europe/Chisinau
    {   48, 6308,    5115, 10, }, // Europe/Copenhagen
    {   48, 6326,   23456, 12, }, // Europe/Gibraltar
    {   48, 8806,   23468,  7, }, // Europe/Guernsey
    {   48, 8822,   23475,  9, }, // Europe/Isle_of_Man
    {   48, 1132,   23484,  8, }, // Europe/Istanbul
    {   48, 8841,   23492,  5, }, // Europe/Jersey
    {   48, 3998,   23497, 11, }, // Europe/Kaliningrad
    {   48, 2529,   23508,  5, }, // Europe/Kyiv
    {   48, 3232,    5139,  8, }, // Europe/Lisbon
    {   48, 6525,   23513,  9, }, // Europe/Ljubljana
    {   48, 6384,   23522, 10, }, // Europe/Luxembourg
    {   48, 6601,   23532,  7, }, // Europe/Mariehamn
    {   48, 6429,    8840,  6, }, // Europe/Monaco
    {   48, 3556,   23539,  6, }, // Europe/Moscow
    {   48, 6443,   23545, 10, }, // Europe/Podgorica
    {   48, 6294,   23555,  5, }, // Europe/Prague
    {   48, 8868,   23560,  4, }, // Europe/Riga
    {   48, 6343,   21843,  4, }, // Europe/Rome
    {   48, 6264,   23564,  8, }, // Europe/Sarajevo
    {   48, 6402,   23572,  6, }, // Europe/Skopje
    {   48, 6618,   23578,  6, }, // Europe/Sofia
    {   48, 6542,    8901,  8, }, // Europe/Stockholm
    {   48, 8898,   23584,  6, }, // Europe/Tallinn
    {   48, 6221,     819,  6, }, // Europe/Tirane
    {   48, 6371,   23590,  6, }, // Europe/Vaduz
    {   48, 6586,    6744,  7, }, // Europe/Vatican
    {   48, 6250,   23596,  5, }, // Europe/Vienna
    {   48, 8930,   23601,  6, }, // Europe/Vilnius
    {   48, 4746,   23607,  9, }, // Europe/Volgograd
    {   48, 3209,   23616,  7, }, // Europe/Warsaw
    {   48, 6280,   23623,  6, }, // Europe/Zagreb
    {   48, 6559,   23629,  5, }, // Europe/Zurich
    {   48, 6966,   23634,  5, }, // Indian/Chagos
    {   48, 6065,   23639,  5, }, // Indian/Christmas
    {   48, 6082,    5223,  5, }, // Indian/Cocos
    {   48, 5048,   23644,  6, }, // Indian/Comoro
    {   48, 6680,   23650,  8, }, // Indian/Kerguelen
    {   48, 7260,     896,  4, }, // Indian/Mahe
    {   48, 7069,    8970,  6, }, // Indian/Maldives
    {   48, 4088,   23658,  7, }, // Indian/Mauritius
    {   48, 5117,    6812,  5, }, // Indian/Mayotte
    {   48, 7211,     900,  7, }, // Indian/Reunion
    {   48, 3009,   23665,  6, }, // Pacific/Auckland
    {   48, 3725,   23671,  8, }, // Pacific/Bougainville
    {   48, 3034,   23679,  5, }, // Pacific/Chatham
    {   48, 3176,   23684,  4, }, // Pacific/Chuuk
    {   48, 2239,   23688,  5, }, // Pacific/Easter
    {   48, 3921,   23693,  4, }, // Pacific/Fiji
    {   48, 6697,   23697,  9, }, // Pacific/Galapagos
    {   48, 6715,   23706,  8, }, // Pacific/Gambier
    {   48, 3841,   23714, 11, }, // Pacific/Guadalcanal
    {   48, 6037,   23725,  4, }, // Pacific/Guam
    {   48, 2725,    5251,  8, }, // Pacific/Honolulu
    {   48, 3068,    5259,  6, }, // Pacific/Kanton
    {   48, 4017,   23729,  8, }, // Pacific/Kiritimati
    {   48, 7038,   23737,  7, }, // Pacific/Kosrae
    {   48, 2844,   23744,  9, }, // Pacific/Kwajalein
    {   48, 4896,   23753,  6, }, // Pacific/Majuro
    {   48, 4070,   23759,  8, }, // Pacific/Marquesas
    {   48, 8945,   23767,  6, }, // Pacific/Midway
    {   48, 7117,    1028,  6, }, // Pacific/Noumea
    {   48, 3145,   23773,  9, }, // Pacific/Pago_Pago
    {   48, 7194,    9099,  7, }, // Pacific/Pitcairn
    {   48, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   48, 4826,   23782, 12, }, // Pacific/Port_Moresby
    {   48, 6095,   23794,  9, }, // Pacific/Rarotonga
    {   48, 6050,   23803,  6, }, // Pacific/Saipan
    {   48, 6731,   23809,  6, }, // Pacific/Tarawa
    {   48, 4602,   23815,  9, }, // Pacific/Tongatapu
    {   48, 7392,   23824,  4, }, // Pacific/Wake
    {   48, 7405,    9144,  6, }, // Pacific/Wallis
    {   49,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Arabic/Iran
    {   49, 5185,       6,  8, }, // Africa/El_Aaiun
    {   49, 5290,      18,  9, }, // Africa/Ndjamena
    {   49, 4454,      27,  8, }, // Africa/Sao_Tome
    {   49, 4573,      35,  9, }, // America/Araguaina
    {   49,  270,      44,  7, }, // America/Argentina/Cordoba
    {   49, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   49, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   49, 4271,      70,  8, }, // America/Asuncion
    {   49, 7623,      86, 17, }, // America/Bahia_Banderas
    {   49, 4380,     108,  6, }, // America/Bogota
    {   49, 3887,     114,  6, }, // America/Cancun
    {   49, 3810,     133,  6, }, // America/Cuiaba
    {   49, 5742,     139,  7, }, // America/Curacao
    {   49, 7887,     146,  8, }, // America/Eirunepe
    {   49,  481,     154, 13, }, // America/Indiana/Knox
    {   49, 7979,     167, 16, }, // America/Indiana/Marengo
    {   49, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   49, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   49, 8056,     220, 14, }, // America/Indiana/Vevay
    {   49, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   49, 8104,     252, 16, }, // America/Indiana/Winamac
    {   49, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   49, 5951,     288, 22, }, // America/Lower_Princes
    {   49, 8171,     310,  6, }, // America/Maceio
    {   49, 2919,     316,  8, }, // America/Mazatlan
    {   49, 8238,     324,  6, }, // America/Merida
    {   49, 2951,    4381, 16, }, // America/Mexico_City
    {   49, 4410,     341, 12, }, // America/Miquelon
    {   49, 1852,     353, 19, }, // America/Noronha
    {   49, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   49, 8347,     392, 20, }, // America/North_Dakota/Center
    {   49, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   49, 1880,     447,  9, }, // America/Sao_Paulo
    {   49, 6918,     456, 16, }, // America/Scoresbysund
    {   49, 8526,     472, 14, }, // America/St_Barthelemy
    {   49, 2063,     486, 10, }, // America/St_Johns
    {   49, 5882,     496,  9, }, // America/St_Kitts
    {   49, 5899,     505,  9, }, // America/St_Lucia
    {   49,  855,     514, 10, }, // America/St_Thomas
    {   49, 5932,     524, 11, }, // America/St_Vincent
    {   49, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   49, 7295,     643,  5, }, // Antarctica/Syowa
    {   49, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   49, 1187,     709,  9, }, // Asia/Kathmandu
    {   49,  994,     718,  7, }, // Asia/Kolkata
    {   49, 1213,     725,  5, }, // Asia/Macau
    {   49, 1161,     747,  6, }, // Asia/Urumqi
    {   49, 1237,     753,  6, }, // Asia/Yangon
    {   49, 6647,    4413,  8, }, // Atlantic/Canary
    {   49, 1397,     767,  5, }, // Atlantic/Faroe
    {   49, 6840,     773, 10, }, // Atlantic/St_Helena
    {   49, 2585,     807,  8, }, // Europe/Chisinau
    {   49, 2529,     815,  4, }, // Europe/Kyiv
    {   49, 5048,    4421,  7, }, // Indian/Comoro
    {   49, 3176,     922,  5, }, // Pacific/Chuuk
    {   49, 6697,     940,  9, }, // Pacific/Galapagos
    {   49, 3068,     957,  6, }, // Pacific/Kanton
    {   49, 7405,    1068, 15, }, // Pacific/Wallis
    {   52,   14,       0,  6, }, // Africa/Asmara Azerbaijani/Cyrillic/Azerbaijan
    {   52, 5185,       6,  8, }, // Africa/El_Aaiun
    {   52, 5290,      18,  9, }, // Africa/Ndjamena
    {   52, 4454,      27,  8, }, // Africa/Sao_Tome
    {   52, 4573,      35,  9, }, // America/Araguaina
    {   52,  270,      44,  7, }, // America/Argentina/Cordoba
    {   52, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   52, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   52, 4271,      70,  8, }, // America/Asuncion
    {   52, 7623,      86, 17, }, // America/Bahia_Banderas
    {   52, 4380,     108,  6, }, // America/Bogota
    {   52, 3887,     114,  6, }, // America/Cancun
    {   52, 3810,     133,  6, }, // America/Cuiaba
    {   52, 5742,     139,  7, }, // America/Curacao
    {   52, 7887,     146,  8, }, // America/Eirunepe
    {   52,  481,     154, 13, }, // America/Indiana/Knox
    {   52, 7979,     167, 16, }, // America/Indiana/Marengo
    {   52, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   52, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   52, 8056,     220, 14, }, // America/Indiana/Vevay
    {   52, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   52, 8104,     252, 16, }, // America/Indiana/Winamac
    {   52, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   52, 5951,     288, 22, }, // America/Lower_Princes
    {   52, 8171,     310,  6, }, // America/Maceio
    {   52, 2919,     316,  8, }, // America/Mazatlan
    {   52, 8238,     324,  6, }, // America/Merida
    {   52, 2951,    4381, 16, }, // America/Mexico_City
    {   52, 4410,     341, 12, }, // America/Miquelon
    {   52, 1852,     353, 19, }, // America/Noronha
    {   52, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   52, 8347,     392, 20, }, // America/North_Dakota/Center
    {   52, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   52, 1880,     447,  9, }, // America/Sao_Paulo
    {   52, 6918,     456, 16, }, // America/Scoresbysund
    {   52, 8526,     472, 14, }, // America/St_Barthelemy
    {   52, 2063,     486, 10, }, // America/St_Johns
    {   52, 5882,     496,  9, }, // America/St_Kitts
    {   52, 5899,     505,  9, }, // America/St_Lucia
    {   52,  855,     514, 10, }, // America/St_Thomas
    {   52, 5932,     524, 11, }, // America/St_Vincent
    {   52, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   52, 7295,     643,  5, }, // Antarctica/Syowa
    {   52, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   52, 1187,     709,  9, }, // Asia/Kathmandu
    {   52,  994,     718,  7, }, // Asia/Kolkata
    {   52, 1213,     725,  5, }, // Asia/Macau
    {   52, 1161,     747,  6, }, // Asia/Urumqi
    {   52, 1237,     753,  6, }, // Asia/Yangon
    {   52, 6647,    4413,  8, }, // Atlantic/Canary
    {   52, 1397,     767,  5, }, // Atlantic/Faroe
    {   52, 6840,     773, 10, }, // Atlantic/St_Helena
    {   52, 2585,     807,  8, }, // Europe/Chisinau
    {   52, 2529,     815,  4, }, // Europe/Kyiv
    {   52, 5048,    4421,  7, }, // Indian/Comoro
    {   52, 3176,     922,  5, }, // Pacific/Chuuk
    {   52, 6697,     940,  9, }, // Pacific/Galapagos
    {   52, 3068,     957,  6, }, // Pacific/Kanton
    {   52, 7405,    1068, 15, }, // Pacific/Wallis
    {   53,   14,       0,  6, }, // Africa/Asmara Bafia/Latin/Cameroon
    {   53, 5185,       6,  8, }, // Africa/El_Aaiun
    {   53, 6888,      14,  4, }, // Africa/Lome
    {   53, 5290,      18,  9, }, // Africa/Ndjamena
    {   53, 4454,      27,  8, }, // Africa/Sao_Tome
    {   53, 4573,      35,  9, }, // America/Araguaina
    {   53,  270,      44,  7, }, // America/Argentina/Cordoba
    {   53, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   53, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   53, 4271,      70,  8, }, // America/Asuncion
    {   53,  237,      78,  8, }, // America/Atikokan
    {   53, 7623,      86, 17, }, // America/Bahia_Banderas
    {   53, 7646,     103,  5, }, // America/Belem
    {   53, 4380,     108,  6, }, // America/Bogota
    {   53, 3887,     114,  6, }, // America/Cancun
    {   53, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   53, 3810,     133,  6, }, // America/Cuiaba
    {   53, 5742,     139,  7, }, // America/Curacao
    {   53, 7887,     146,  8, }, // America/Eirunepe
    {   53,  481,     154, 13, }, // America/Indiana/Knox
    {   53, 7979,     167, 16, }, // America/Indiana/Marengo
    {   53, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   53, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   53, 8056,     220, 14, }, // America/Indiana/Vevay
    {   53, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   53, 8104,     252, 16, }, // America/Indiana/Winamac
    {   53, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   53, 5951,     288, 22, }, // America/Lower_Princes
    {   53, 8171,     310,  6, }, // America/Maceio
    {   53, 2919,     316,  8, }, // America/Mazatlan
    {   53, 8238,     324,  6, }, // America/Merida
    {   53, 2951,    4381, 16, }, // America/Mexico_City
    {   53, 4410,     341, 12, }, // America/Miquelon
    {   53, 1852,     353, 19, }, // America/Noronha
    {   53, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   53, 8347,     392, 20, }, // America/North_Dakota/Center
    {   53, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   53,  393,     435,  4, }, // America/Nuuk
    {   53, 8495,     439,  8, }, // America/Santarem
    {   53, 1880,     447,  9, }, // America/Sao_Paulo
    {   53, 6918,     456, 16, }, // America/Scoresbysund
    {   53, 8526,     472, 14, }, // America/St_Barthelemy
    {   53, 2063,     486, 10, }, // America/St_Johns
    {   53, 5882,     496,  9, }, // America/St_Kitts
    {   53, 5899,     505,  9, }, // America/St_Lucia
    {   53,  855,     514, 10, }, // America/St_Thomas
    {   53, 5932,     524, 11, }, // America/St_Vincent
    {   53, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   53, 7295,     643,  5, }, // Antarctica/Syowa
    {   53, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   53, 4790,     704,  5, }, // Asia/Hovd
    {   53, 1187,     709,  9, }, // Asia/Kathmandu
    {   53,  994,     718,  7, }, // Asia/Kolkata
    {   53, 1213,     725,  5, }, // Asia/Macau
    {   53, 1161,     747,  6, }, // Asia/Urumqi
    {   53, 1237,     753,  6, }, // Asia/Yangon
    {   53, 6647,    4413,  8, }, // Atlantic/Canary
    {   53, 1397,     767,  5, }, // Atlantic/Faroe
    {   53, 6840,     773, 10, }, // Atlantic/St_Helena
    {   53, 8790,     799,  8, }, // Europe/Busingen
    {   53, 2585,     807,  8, }, // Europe/Chisinau
    {   53, 2529,     815,  4, }, // Europe/Kyiv
    {   53, 6221,     819,  6, }, // Europe/Tirane
    {   53, 5048,    4421,  7, }, // Indian/Comoro
    {   53, 7260,     896,  4, }, // Indian/Mahe
    {   53, 7211,     900,  7, }, // Indian/Reunion
    {   53, 3176,     922,  5, }, // Pacific/Chuuk
    {   53, 6697,     940,  9, }, // Pacific/Galapagos
    {   53, 3068,     957,  6, }, // Pacific/Kanton
    {   53, 7117,    1028,  6, }, // Pacific/Noumea
    {   53, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   53, 7405,    1068, 15, }, // Pacific/Wallis
    {   54,   14,       0,  6, }, // Africa/Asmara Bambara/Latin/Mali
    {   54, 5185,       6,  8, }, // Africa/El_Aaiun
    {   54, 6888,      14,  4, }, // Africa/Lome
    {   54, 5290,      18,  9, }, // Africa/Ndjamena
    {   54, 4454,      27,  8, }, // Africa/Sao_Tome
    {   54, 4573,      35,  9, }, // America/Araguaina
    {   54,  270,      44,  7, }, // America/Argentina/Cordoba
    {   54, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   54, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   54, 4271,      70,  8, }, // America/Asuncion
    {   54,  237,      78,  8, }, // America/Atikokan
    {   54, 7623,      86, 17, }, // America/Bahia_Banderas
    {   54, 7646,     103,  5, }, // America/Belem
    {   54, 4380,     108,  6, }, // America/Bogota
    {   54, 3887,     114,  6, }, // America/Cancun
    {   54, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   54, 3810,     133,  6, }, // America/Cuiaba
    {   54, 5742,     139,  7, }, // America/Curacao
    {   54, 7887,     146,  8, }, // America/Eirunepe
    {   54,  481,     154, 13, }, // America/Indiana/Knox
    {   54, 7979,     167, 16, }, // America/Indiana/Marengo
    {   54, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   54, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   54, 8056,     220, 14, }, // America/Indiana/Vevay
    {   54, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   54, 8104,     252, 16, }, // America/Indiana/Winamac
    {   54, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   54, 5951,     288, 22, }, // America/Lower_Princes
    {   54, 8171,     310,  6, }, // America/Maceio
    {   54, 2919,     316,  8, }, // America/Mazatlan
    {   54, 8238,     324,  6, }, // America/Merida
    {   54, 2951,    4381, 16, }, // America/Mexico_City
    {   54, 4410,     341, 12, }, // America/Miquelon
    {   54, 1852,     353, 19, }, // America/Noronha
    {   54, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   54, 8347,     392, 20, }, // America/North_Dakota/Center
    {   54, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   54,  393,     435,  4, }, // America/Nuuk
    {   54, 8495,     439,  8, }, // America/Santarem
    {   54, 1880,     447,  9, }, // America/Sao_Paulo
    {   54, 6918,     456, 16, }, // America/Scoresbysund
    {   54, 8526,     472, 14, }, // America/St_Barthelemy
    {   54, 2063,     486, 10, }, // America/St_Johns
    {   54, 5882,     496,  9, }, // America/St_Kitts
    {   54, 5899,     505,  9, }, // America/St_Lucia
    {   54,  855,     514, 10, }, // America/St_Thomas
    {   54, 5932,     524, 11, }, // America/St_Vincent
    {   54, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   54, 7295,     643,  5, }, // Antarctica/Syowa
    {   54, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   54, 4790,     704,  5, }, // Asia/Hovd
    {   54, 1187,     709,  9, }, // Asia/Kathmandu
    {   54,  994,     718,  7, }, // Asia/Kolkata
    {   54, 1213,     725,  5, }, // Asia/Macau
    {   54, 1161,     747,  6, }, // Asia/Urumqi
    {   54, 1237,     753,  6, }, // Asia/Yangon
    {   54, 6647,    4413,  8, }, // Atlantic/Canary
    {   54, 1397,     767,  5, }, // Atlantic/Faroe
    {   54, 6840,     773, 10, }, // Atlantic/St_Helena
    {   54, 8790,     799,  8, }, // Europe/Busingen
    {   54, 2585,     807,  8, }, // Europe/Chisinau
    {   54, 2529,     815,  4, }, // Europe/Kyiv
    {   54, 6221,     819,  6, }, // Europe/Tirane
    {   54, 5048,    4421,  7, }, // Indian/Comoro
    {   54, 7260,     896,  4, }, // Indian/Mahe
    {   54, 7211,     900,  7, }, // Indian/Reunion
    {   54, 3176,     922,  5, }, // Pacific/Chuuk
    {   54, 6697,     940,  9, }, // Pacific/Galapagos
    {   54, 3068,     957,  6, }, // Pacific/Kanton
    {   54, 7117,    1028,  6, }, // Pacific/Noumea
    {   54, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   54, 7405,    1068, 15, }, // Pacific/Wallis
    {   56, 6807,   23828,  7, }, // Africa/Abidjan Bangla/Bangla/Bangladesh
    {   56, 6779,   23835,  5, }, // Africa/Accra
    {   56, 5078,   23840, 12, }, // Africa/Addis_Ababa
    {   56, 7420,   23852, 10, }, // Africa/Algiers
    {   56,   14,   23862, 11, }, // Africa/Asmara
    {   56,   44,   23873,  8, }, // Africa/Bamako
    {   56, 5276,   23881,  7, }, // Africa/Bangui
    {   56, 6765,   23888,  7, }, // Africa/Banjul
    {   56, 7435,   23895,  5, }, // Africa/Bissau
    {   56, 4976,   23900, 13, }, // Africa/Blantyre
    {   56, 5306,   23913, 10, }, // Africa/Brazzaville
    {   56, 4941,   23923, 10, }, // Africa/Bujumbura
    {   56, 2322,   23933,  6, }, // Africa/Cairo
    {   56, 4136,   23939, 12, }, // Africa/Casablanca
    {   56, 7449,   23951,  5, }, // Africa/Ceuta
    {   56, 6792,   23956,  7, }, // Africa/Conakry
    {   56, 6859,   23963,  5, }, // Africa/Dakar
    {   56, 5149,   23968, 12, }, // Africa/Dar_es_Salaam
    {   56, 5062,   17734,  6, }, // Africa/Djibouti
    {   56, 5262,   23980,  7, }, // Africa/Douala
    {   56, 5185,   23987,  8, }, // Africa/El_Aaiun
    {   56, 6872,   23995,  8, }, // Africa/Freetown
    {   56, 4925,   24003,  9, }, // Africa/Gaborone
    {   56, 5034,   24012,  6, }, // Africa/Harare
    {   56, 4498,   24018, 12, }, // Africa/Johannesburg
    {   56, 4518,   17788,  4, }, // Africa/Juba
    {   56, 5170,   24030,  7, }, // Africa/Kampala
    {   56, 4543,   24037,  7, }, // Africa/Khartoum
    {   56, 4992,   24044,  6, }, // Africa/Kigali
    {   56, 5325,   24050,  7, }, // Africa/Kinshasa
    {   56, 4763,   24057,  5, }, // Africa/Lagos
    {   56, 5355,   24062,  9, }, // Africa/Libreville
    {   56, 6888,   24071,  4, }, // Africa/Lome
    {   56, 5230,   24075,  9, }, // Africa/Luanda
    {   56, 4958,   24084, 10, }, // Africa/Lubumbashi
    {   56, 5020,   24094,  6, }, // Africa/Lusaka
    {   56, 5341,   17862,  6, }, // Africa/Malabo
    {   56, 5006,   24100,  6, }, // Africa/Maputo
    {   56, 5216,   24106,  7, }, // Africa/Maseru
    {   56, 5201,   24113,  7, }, // Africa/Mbabane
    {   56, 5132,   24120,  9, }, // Africa/Mogadishu
    {   56, 7053,   24129,  9, }, // Africa/Monrovia
    {   56, 3872,   24138,  7, }, // Africa/Nairobi
    {   56, 5290,   24145,  7, }, // Africa/Ndjamena
    {   56, 5373,   24152,  7, }, // Africa/Niamey
    {   56, 6822,   24159,  8, }, // Africa/Nouakchott
    {   56, 6746,   24167, 11, }, // Africa/Ouagadougou
    {   56, 5244,   24178, 11, }, // Africa/Porto-Novo
    {   56, 4454,   24189,  7, }, // Africa/Sao_Tome
    {   56, 2868,   24196,  8, }, // Africa/Tripoli
    {   56, 6573,   24204,  6, }, // Africa/Tunis
    {   56, 4171,   24210,  6, }, // Africa/Windhoek
    {   56,  132,   24216,  3, }, // America/Adak
    {   56, 3365,   24219,  7, }, // America/Anchorage
    {   56, 5626,   24226, 11, }, // America/Anguilla
    {   56, 5643,   24237, 13, }, // America/Antigua
    {   56, 4573,   24250, 11, }, // America/Araguaina
    {   56,  166,   24261, 16, }, // America/Argentina/Buenos_Aires
    {   56,   91,   24277, 12, }, // America/Argentina/Catamarca
    {   56,  270,   24289,  7, }, // America/Argentina/Cordoba
    {   56,  441,   18050,  5, }, // America/Argentina/Jujuy
    {   56, 7462,   24296,  8, }, // America/Argentina/La_Rioja
    {   56,  565,   24304,  8, }, // America/Argentina/Mendoza
    {   56, 7489,   24312, 12, }, // America/Argentina/Rio_Gallegos
    {   56, 7520,   24324,  7, }, // America/Argentina/Salta
    {   56, 7544,   24331, 10, }, // America/Argentina/San_Juan
    {   56, 5599,   24341,  8, }, // America/Argentina/San_Luis
    {   56, 7571,   24349,  7, }, // America/Argentina/Tucuman
    {   56, 7597,   24356, 10, }, // America/Argentina/Ushuaia
    {   56, 5659,   24366,  5, }, // America/Aruba
    {   56, 4271,   24371,  9, }, // America/Asuncion
    {   56,  237,   18134,  8, }, // America/Atikokan
    {   56, 3698,   18142,  7, }, // America/Bahia
    {   56, 7623,   24380, 17, }, // America/Bahia_Banderas
    {   56, 5673,   24397,  9, }, // America/Barbados
    {   56, 7646,   18175,  5, }, // America/Belem
    {   56, 5426,   18180,  5, }, // America/Belize
    {   56, 7660,   24406, 15, }, // America/Blanc-Sablon
    {   56, 7681,   24421, 12, }, // America/Boa_Vista
    {   56, 4380,   18209,  6, }, // America/Bogota
    {   56, 7699,   24433,  5, }, // America/Boise
    {   56, 7713,   24438, 11, }, // America/Cambridge_Bay
    {   56, 7735,   24449, 15, }, // America/Campo_Grande
    {   56, 3887,   24464,  8, }, // America/Cancun
    {   56, 4713,   24472,  9, }, // America/Caracas
    {   56, 4364,   24481,  5, }, // America/Cayenne
    {   56, 5515,   24486,  5, }, // America/Cayman
    {   56, 2262,   24491,  6, }, // America/Chicago
    {   56, 7756,   24497, 12, }, // America/Chihuahua
    {   56, 7774,   24509, 15, }, // America/Ciudad_Juarez
    {   56, 5441,   24524, 10, }, // America/Costa_Rica
    {   56, 7796,   24534,  8, }, // America/Coyhaique
    {   56, 7814,   24542,  9, }, // America/Creston
    {   56, 3810,   24551,  8, }, // America/Cuiaba
    {   56, 5742,   24559,  7, }, // America/Curacao
    {   56, 7830,   24566, 14, }, // America/Danmarkshavn
    {   56, 7851,   24580,  4, }, // America/Dawson
    {   56, 7866,   24584, 10, }, // America/Dawson_Creek
    {   56,  805,   24594,  6, }, // America/Denver
    {   56, 3484,   24600,  8, }, // America/Detroit
    {   56, 5758,   24608,  8, }, // America/Dominica
    {   56,  893,   24616,  8, }, // America/Edmonton
    {   56, 7887,   24624,  8, }, // America/Eirunepe
    {   56, 5460,   24632, 11, }, // America/El_Salvador
    {   56, 7904,   24643, 11, }, // America/Fort_Nelson
    {   56, 7924,   24654, 10, }, // America/Fortaleza
    {   56, 7942,   24664,  8, }, // America/Glace_Bay
    {   56, 6900,   24672,  6, }, // America/Goose_Bay
    {   56, 4631,   24678, 15, }, // America/Grand_Turk
    {   56, 5789,   24693,  8, }, // America/Grenada
    {   56, 5805,   24701, 10, }, // America/Guadeloupe
    {   56, 3779,   24711, 11, }, // America/Guatemala
    {   56, 4860,   24722, 12, }, // America/Guayaquil
    {   56, 6951,   18507,  7, }, // America/Guyana
    {   56, 1941,   24734, 13, }, // America/Halifax
    {   56, 2283,   18523,  6, }, // America/Havana
    {   56, 7960,   24747, 11, }, // America/Hermosillo
    {   56,  348,   24758, 15, }, // America/Indiana/Indianapolis
    {   56,  481,   24773, 16, }, // America/Indiana/Knox
    {   56, 7979,   24789, 20, }, // America/Indiana/Marengo
    {   56, 8003,   24809, 25, }, // America/Indiana/Petersburg
    {   56, 8030,   24834, 19, }, // America/Indiana/Tell_City
    {   56, 8056,   24853, 18, }, // America/Indiana/Vevay
    {   56, 8078,   24871, 22, }, // America/Indiana/Vincennes
    {   56, 8104,   24893, 21, }, // America/Indiana/Winamac
    {   56, 8128,   24914,  8, }, // America/Inuvik
    {   56,  660,   24922, 10, }, // America/Iqaluit
    {   56, 2801,   18703,  7, }, // America/Jamaica
    {   56, 5399,   24932,  4, }, // America/Juneau
    {   56,  521,   24936,  7, }, // America/Kentucky/Louisville
    {   56, 8143,   24943, 19, }, // America/Kentucky/Monticello
    {   56, 5723,   24962, 13, }, // America/Kralendijk
    {   56, 4395,   18755,  6, }, // America/La_Paz
    {   56, 7169,   18761,  4, }, // America/Lima
    {   56, 3258,   24975, 14, }, // America/Los_Angeles
    {   56, 5951,   24989, 27, }, // America/Lower_Princes
    {   56, 8171,   25016,  7, }, // America/Maceio
    {   56, 8186,   25023,  9, }, // America/Managua
    {   56, 1910,   25032,  6, }, // America/Manaus
    {   56, 5916,   25038,  6, }, // America/Marigot
    {   56, 5824,   25044,  8, }, // America/Martinique
    {   56, 8202,   25052,  8, }, // America/Matamoros
    {   56, 2919,   25060,  8, }, // America/Mazatlan
    {   56, 8220,   25068,  8, }, // America/Menominee
    {   56, 8238,   25076,  6, }, // America/Merida
    {   56, 8253,   25082, 10, }, // America/Metlakatla
    {   56, 2951,   25092, 13, }, // America/Mexico_City
    {   56, 4410,   25105,  6, }, // America/Miquelon
    {   56, 8272,   25111,  7, }, // America/Moncton
    {   56, 8288,   25118,  7, }, // America/Monterrey
    {   56, 4117,   25125, 10, }, // America/Montevideo
    {   56, 5843,   25135,  9, }, // America/Montserrat
    {   56, 5500,   25144,  5, }, // America/Nassau
    {   56, 2381,   25149,  9, }, // America/New_York
    {   56, 8306,   18856,  3, }, // America/Nome
    {   56, 1852,   25158,  8, }, // America/Noronha
    {   56, 8319,   25166, 19, }, // America/North_Dakota/Beulah
    {   56, 8347,   25185, 18, }, // America/North_Dakota/Center
    {   56, 8375,   25203, 23, }, // America/North_Dakota/New_Salem
    {   56,  393,   19026,  3, }, // America/Nuuk
    {   56, 8406,   25226,  7, }, // America/Ojinaga
    {   56, 2358,   19037,  6, }, // America/Panama
    {   56, 6192,   25233, 12, }, // America/Paramaribo
    {   56, 2975,   19053,  7, }, // America/Phoenix
    {   56, 3964,   25245, 16, }, // America/Port-au-Prince
    {   56, 5973,   25261, 14, }, // America/Port_of_Spain
    {   56, 8422,   25275, 14, }, // America/Porto_Velho
    {   56, 5862,   25289, 14, }, // America/Puerto_Rico
    {   56, 4049,   25303, 13, }, // America/Punta_Arenas
    {   56, 8442,   25316, 16, }, // America/Rankin_Inlet
    {   56, 8463,   25332,  6, }, // America/Recife
    {   56, 1997,   25338,  6, }, // America/Regina
    {   56, 8478,   25344,  7, }, // America/Resolute
    {   56,  695,   25351, 12, }, // America/Rio_Branco
    {   56, 8495,   25363,  8, }, // America/Santarem
    {   56, 2203,   25371, 11, }, // America/Santiago
    {   56, 6130,   25382, 16, }, // America/Santo_Domingo
    {   56, 1880,   25398,  9, }, // America/Sao_Paulo
    {   56, 6918,   25407, 16, }, // America/Scoresbysund
    {   56, 8512,   25423,  5, }, // America/Sitka
    {   56, 8526,   25428, 16, }, // America/St_Barthelemy
    {   56, 2063,   25444, 10, }, // America/St_Johns
    {   56, 5882,   25454, 11, }, // America/St_Kitts
    {   56, 5899,   25465, 14, }, // America/St_Lucia
    {   56,  855,   25479, 11, }, // America/St_Thomas
    {   56, 5932,   25490, 15, }, // America/St_Vincent
    {   56, 8548,   25505, 14, }, // America/Swift_Current
    {   56, 5480,   25519, 11, }, // America/Tegucigalpa
    {   56, 5775,   25530,  4, }, // America/Thule
    {   56,  313,   25534,  9, }, // America/Tijuana
    {   56,  608,   25543,  7, }, // America/Toronto
    {   56, 5707,   25550,  6, }, // America/Tortola
    {   56, 2095,   25556, 11, }, // America/Vancouver
    {   56, 2146,   25567, 11, }, // America/Whitehorse
    {   56,  734,   25578,  7, }, // America/Winnipeg
    {   56, 8570,   25585,  9, }, // America/Yakutat
    {   56, 6020,   25594,  5, }, // Antarctica/Casey
    {   56, 6113,   25599,  5, }, // Antarctica/Davis
    {   56, 6152,   25604, 15, }, // Antarctica/DumontDUrville
    {   56, 8586,   25619, 14, }, // Antarctica/Macquarie
    {   56, 7085,   25633,  4, }, // Antarctica/Mawson
    {   56,  932,   25637, 11, }, // Antarctica/McMurdo
    {   56, 8607,   25648,  6, }, // Antarctica/Palmer
    {   56, 7226,   25654,  5, }, // Antarctica/Rothera
    {   56, 7295,   25659,  6, }, // Antarctica/Syowa
    {   56, 8625,   25665,  4, }, // Antarctica/Troll
    {   56, 7374,   25669,  6, }, // Antarctica/Vostok
    {   56, 1431,   25675, 14, }, // Arctic/Longyearbyen
    {   56, 5589,   25689,  5, }, // Asia/Aden
    {   56, 5414,   19500,  6, }, // Asia/Almaty
    {   56, 3987,   19506,  6, }, // Asia/Amman
    {   56, 5530,   25694,  9, }, // Asia/Anadyr
    {   56, 5542,   25703,  5, }, // Asia/Aqtau
    {   56, 5387,   25708,  6, }, // Asia/Aqtobe
    {   56,  966,   25714,  7, }, // Asia/Ashgabat
    {   56, 8642,   25721,  6, }, // Asia/Atyrau
    {   56, 3626,   19551,  6, }, // Asia/Baghdad
    {   56, 5553,   25727,  7, }, // Asia/Bahrain
    {   56, 3672,   18332,  4, }, // Asia/Baku
    {   56, 4485,   25734,  7, }, // Asia/Bangkok
    {   56, 3590,   25741,  7, }, // Asia/Barnaul
    {   56, 4105,   25748,  6, }, // Asia/Beirut
    {   56, 3797,   25754,  6, }, // Asia/Bishkek
    {   56, 6008,   25760,  7, }, // Asia/Brunei
    {   56, 4620,   25767,  4, }, // Asia/Chita
    {   56, 4530,   19603,  6, }, // Asia/Colombo
    {   56, 4559,   25771,  9, }, // Asia/Damascus
    {   56, 1095,   19618,  4, }, // Asia/Dhaka
    {   56, 6211,   25780,  4, }, // Asia/Dili
    {   56, 3615,   25784,  5, }, // Asia/Dubai
    {   56, 6178,   25789,  7, }, // Asia/Dushanbe
    {   56, 8654,   25796, 10, }, // Asia/Famagusta
    {   56, 8669,   19648,  4, }, // Asia/Gaza
    {   56, 4814,   25806,  7, }, // Asia/Hebron
    {   56, 1261,   25813, 13, }, // Asia/Ho_Chi_Minh
    {   56, 2706,   19673,  5, }, // Asia/Hong_Kong
    {   56, 4790,   25826,  5, }, // Asia/Hovd
    {   56, 4203,   25831,  8, }, // Asia/Irkutsk
    {   56, 7025,   25839,  8, }, // Asia/Jakarta
    {   56, 7011,   25847,  8, }, // Asia/Jayapura
    {   56, 1292,   25855,  9, }, // Asia/Jerusalem
    {   56, 3579,   19720,  5, }, // Asia/Kabul
    {   56, 4335,   25864,  8, }, // Asia/Kamchatka
    {   56, 4258,   25872,  5, }, // Asia/Karachi
    {   56, 1187,   25877,  9, }, // Asia/Kathmandu
    {   56, 8679,   25886, 10, }, // Asia/Khandyga
    {   56,  994,   25896,  7, }, // Asia/Kolkata
    {   56, 4216,   25903, 16, }, // Asia/Krasnoyarsk
    {   56, 4878,   25919, 13, }, // Asia/Kuala_Lumpur
    {   56, 5995,   19788,  5, }, // Asia/Kuching
    {   56, 5566,   25932,  6, }, // Asia/Kuwait
    {   56, 1213,   25938,  7, }, // Asia/Macau
    {   56, 4036,   25945,  9, }, // Asia/Magadan
    {   56, 1351,   25954,  8, }, // Asia/Makassar
    {   56, 7182,   25962,  8, }, // Asia/Manila
    {   56, 6939,   25970,  5, }, // Asia/Muscat
    {   56, 2556,   25975,  9, }, // Asia/Nicosia
    {   56, 8693,   25984, 12, }, // Asia/Novokuznetsk
    {   56, 4154,   25996, 12, }, // Asia/Novosibirsk
    {   56, 4248,   26008,  6, }, // Asia/Omsk
    {   56, 7145,   26014,  4, }, // Asia/Oral
    {   56, 6980,   26018,  6, }, // Asia/Phnom_Penh
    {   56, 8711,   26024, 13, }, // Asia/Pontianak
    {   56, 4233,   26037,  9, }, // Asia/Pyongyang
    {   56, 5578,   26046,  5, }, // Asia/Qatar
    {   56, 8726,   26051,  9, }, // Asia/Qostanay
    {   56, 4288,   26060,  9, }, // Asia/Qyzylorda
    {   56, 3603,   26069,  6, }, // Asia/Riyadh
    {   56, 4427,   26075,  7, }, // Asia/Sakhalin
    {   56, 7245,   26082,  7, }, // Asia/Samarkand
    {   56, 3298,   26089,  4, }, // Asia/Seoul
    {   56, 1055,   26093,  6, }, // Asia/Shanghai
    {   56, 3319,   26099,  9, }, // Asia/Singapore
    {   56, 4316,   26108, 16, }, // Asia/Srednekolymsk
    {   56, 3282,   26124,  6, }, // Asia/Taipei
    {   56, 4800,   26130,  7, }, // Asia/Tashkent
    {   56, 3934,   26137,  8, }, // Asia/Tbilisi
    {   56, 2774,   26145,  7, }, // Asia/Tehran
    {   56, 1319,   20012,  6, }, // Asia/Thimphu
    {   56, 2823,   26152,  5, }, // Asia/Tokyo
    {   56, 4591,   26157,  6, }, // Asia/Tomsk
    {   56, 1023,   26163,  9, }, // Asia/Ulaanbaatar
    {   56, 1161,   26172,  6, }, // Asia/Urumqi
    {   56, 8740,   26178, 10, }, // Asia/Ust-Nera
    {   56, 6996,   26188, 12, }, // Asia/Vientiane
    {   56, 4729,   26200, 12, }, // Asia/Vladivostok
    {   56, 4847,   26212, 10, }, // Asia/Yakutsk
    {   56, 1237,   26222,  7, }, // Asia/Yangon
    {   56, 3902,   26229, 16, }, // Asia/Yekaterinburg
    {   56, 3766,   26245,  9, }, // Asia/Yerevan
    {   56, 3682,   26254,  6, }, // Atlantic/Azores
    {   56, 5690,   26260,  7, }, // Atlantic/Bermuda
    {   56, 6647,   26267,  6, }, // Atlantic/Canary
    {   56, 3746,   26273,  9, }, // Atlantic/Cape_Verde
    {   56, 1397,   26282,  6, }, // Atlantic/Faroe
    {   56, 8754,   26288,  7, }, // Atlantic/Madeira
    {   56, 2750,   26295,  8, }, // Atlantic/Reykjavik
    {   56, 7272,   26303, 15, }, // Atlantic/South_Georgia
    {   56, 6840,   26318, 13, }, // Atlantic/St_Helena
    {   56, 6663,   26331,  7, }, // Atlantic/Stanley
    {   56, 1672,   26338, 10, }, // Australia/Adelaide
    {   56, 1637,   26348,  8, }, // Australia/Brisbane
    {   56, 1801,   26356, 11, }, // Australia/Broken_Hill
    {   56, 1585,   26367,  6, }, // Australia/Darwin
    {   56, 3656,   20239,  6, }, // Australia/Eucla
    {   56, 1518,   26373,  7, }, // Australia/Hobart
    {   56, 8771,   26380, 10, }, // Australia/Lindeman
    {   56, 1549,   26390,  8, }, // Australia/Lord_Howe
    {   56, 1729,   26398,  8, }, // Australia/Melbourne
    {   56, 1764,   26406,  5, }, // Australia/Perth
    {   56, 1465,   26411,  5, }, // Australia/Sydney
    {   56, 6460,   26416, 10, }, // Europe/Amsterdam
    {   56, 6235,   26426, 10, }, // Europe/Andorra
    {   56, 3639,   26436,  9, }, // Europe/Astrakhan
    {   56, 2302,   20313,  6, }, // Europe/Athens
    {   56, 6355,   26445,  8, }, // Europe/Belgrade
    {   56, 4776,   26453,  7, }, // Europe/Berlin
    {   56, 6507,   26460, 12, }, // Europe/Bratislava
    {   56, 2169,   26472,  8, }, // Europe/Brussels
    {   56, 3947,   26480,  9, }, // Europe/Bucharest
    {   56, 3825,   26489,  9, }, // Europe/Budapest
    {   56, 8790,   26498,  8, }, // Europe/Busingen
    {   56, 2585,   26506,  8, }, // Europe/Chisinau
    {   56, 6308,   26514, 10, }, // Europe/Copenhagen
    {   56, 2340,   20396,  6, }, // Europe/Dublin
    {   56, 6326,   26524, 11, }, // Europe/Gibraltar
    {   56, 8806,   26535, 10, }, // Europe/Guernsey
    {   56, 6631,   26545,  9, }, // Europe/Helsinki
    {   56, 8822,   26554, 12, }, // Europe/Isle_of_Man
    {   56, 1132,   20437,  9, }, // Europe/Istanbul
    {   56, 8841,   26566,  6, }, // Europe/Jersey
    {   56, 3998,   26572, 12, }, // Europe/Kaliningrad
    {   56, 8855,   26584,  5, }, // Europe/Kirov
    {   56, 2529,   26589,  6, }, // Europe/Kyiv
    {   56, 3232,   26595,  5, }, // Europe/Lisbon
    {   56, 6525,   26600, 10, }, // Europe/Ljubljana
    {   56, 2503,   26610,  5, }, // Europe/London
    {   56, 6384,   26615, 12, }, // Europe/Luxembourg
    {   56, 4911,   26627,  7, }, // Europe/Madrid
    {   56, 6416,   20512,  6, }, // Europe/Malta
    {   56, 6601,   26634, 11, }, // Europe/Mariehamn
    {   56, 3712,   26645,  6, }, // Europe/Minsk
    {   56, 6429,   20534,  6, }, // Europe/Monaco
    {   56, 3556,   20540,  5, }, // Europe/Moscow
    {   56, 6477,   26651,  4, }, // Europe/Oslo
    {   56, 4303,   26655,  7, }, // Europe/Paris
    {   56, 6443,   26662,  9, }, // Europe/Podgorica
    {   56, 6294,   26671,  5, }, // Europe/Prague
    {   56, 8868,   26676,  4, }, // Europe/Riga
    {   56, 6343,   26286,  3, }, // Europe/Rome
    {   56, 4350,   26680,  6, }, // Europe/Samara
    {   56, 6489,   26686, 10, }, // Europe/San_Marino
    {   56, 6264,   26696,  8, }, // Europe/Sarajevo
    {   56, 4470,   26704,  7, }, // Europe/Saratov
    {   56, 8880,   26711, 10, }, // Europe/Simferopol
    {   56, 6402,   26721,  7, }, // Europe/Skopje
    {   56, 6618,   26728,  7, }, // Europe/Sofia
    {   56, 6542,   26735,  7, }, // Europe/Stockholm
    {   56, 8898,   26742,  6, }, // Europe/Tallinn
    {   56, 6221,   26748,  6, }, // Europe/Tirane
    {   56, 8913,   26754, 12, }, // Europe/Ulyanovsk
    {   56, 6371,   20661,  5, }, // Europe/Vaduz
    {   56, 6586,   26766,  7, }, // Europe/Vatican
    {   56, 6250,   20673,  7, }, // Europe/Vienna
    {   56, 8930,   26773,  7, }, // Europe/Vilnius
    {   56, 4746,   26780, 11, }, // Europe/Volgograd
    {   56, 3209,   26791,  6, }, // Europe/Warsaw
    {   56, 6280,   26797,  7, }, // Europe/Zagreb
    {   56, 6559,   26804,  5, }, // Europe/Zurich
    {   56, 5097,   26809, 13, }, // Indian/Antananarivo
    {   56, 6966,   26822,  5, }, // Indian/Chagos
    {   56, 6065,   26827,  8, }, // Indian/Christmas
    {   56, 6082,   26835,  5, }, // Indian/Cocos
    {   56, 5048,   26840,  6, }, // Indian/Comoro
    {   56, 6680,   26846,  9, }, // Indian/Kerguelen
    {   56, 7260,   20765,  4, }, // Indian/Mahe
    {   56, 7069,   20769,  8, }, // Indian/Maldives
    {   56, 4088,   26855,  6, }, // Indian/Mauritius
    {   56, 5117,   26861,  7, }, // Indian/Mayotte
    {   56, 7211,   26868,  9, }, // Indian/Reunion
    {   56, 4441,   20801,  6, }, // Pacific/Apia
    {   56, 3009,   26877,  9, }, // Pacific/Auckland
    {   56, 3725,   26886,  9, }, // Pacific/Bougainville
    {   56, 3034,   26895,  7, }, // Pacific/Chatham
    {   56, 3176,   20831,  3, }, // Pacific/Chuuk
    {   56, 2239,   26902,  6, }, // Pacific/Easter
    {   56, 7360,   26908,  5, }, // Pacific/Efate
    {   56, 7327,   26913,  9, }, // Pacific/Fakaofo
    {   56, 3921,   20851,  4, }, // Pacific/Fiji
    {   56, 7343,   20855,  8, }, // Pacific/Funafuti
    {   56, 6697,   26922, 13, }, // Pacific/Galapagos
    {   56, 6715,   26935, 10, }, // Pacific/Gambier
    {   56, 3841,   26945, 13, }, // Pacific/Guadalcanal
    {   56, 6037,   25027,  6, }, // Pacific/Guam
    {   56, 2725,   26958,  7, }, // Pacific/Honolulu
    {   56, 3068,   26965,  8, }, // Pacific/Kanton
    {   56, 4017,   26973, 10, }, // Pacific/Kiritimati
    {   56, 7038,   26983,  7, }, // Pacific/Kosrae
    {   56, 2844,   26990, 11, }, // Pacific/Kwajalein
    {   56, 4896,   27001,  6, }, // Pacific/Majuro
    {   56, 4070,   27007,  9, }, // Pacific/Marquesas
    {   56, 8945,   27016,  7, }, // Pacific/Midway
    {   56, 7103,   27023,  5, }, // Pacific/Nauru
    {   56, 7132,   27028,  6, }, // Pacific/Niue
    {   56, 4187,   27034,  4, }, // Pacific/Norfolk
    {   56, 7117,   27038,  7, }, // Pacific/Noumea
    {   56, 3145,   27045, 13, }, // Pacific/Pago_Pago
    {   56, 7155,   20976,  5, }, // Pacific/Palau
    {   56, 7194,   27058, 11, }, // Pacific/Pitcairn
    {   56, 3115,   27069,  6, }, // Pacific/Pohnpei
    {   56, 4826,   27075, 12, }, // Pacific/Port_Moresby
    {   56, 6095,   27087, 11, }, // Pacific/Rarotonga
    {   56, 6050,   27098,  6, }, // Pacific/Saipan
    {   56, 7312,   21027,  6, }, // Pacific/Tahiti
    {   56, 6731,   27104,  8, }, // Pacific/Tarawa
    {   56, 4602,   27112, 10, }, // Pacific/Tongatapu
    {   56, 7392,   27122,  5, }, // Pacific/Wake
    {   56, 7405,   27127,  4, }, // Pacific/Wallis
    {   58,   14,       0,  6, }, // Africa/Asmara Basaa/Latin/Cameroon
    {   58, 5185,       6,  8, }, // Africa/El_Aaiun
    {   58, 6888,      14,  4, }, // Africa/Lome
    {   58, 5290,      18,  9, }, // Africa/Ndjamena
    {   58, 4454,      27,  8, }, // Africa/Sao_Tome
    {   58, 4573,      35,  9, }, // America/Araguaina
    {   58,  270,      44,  7, }, // America/Argentina/Cordoba
    {   58, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   58, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   58, 4271,      70,  8, }, // America/Asuncion
    {   58,  237,      78,  8, }, // America/Atikokan
    {   58, 7623,      86, 17, }, // America/Bahia_Banderas
    {   58, 7646,     103,  5, }, // America/Belem
    {   58, 4380,     108,  6, }, // America/Bogota
    {   58, 3887,     114,  6, }, // America/Cancun
    {   58, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   58, 3810,     133,  6, }, // America/Cuiaba
    {   58, 5742,     139,  7, }, // America/Curacao
    {   58, 7887,     146,  8, }, // America/Eirunepe
    {   58,  481,     154, 13, }, // America/Indiana/Knox
    {   58, 7979,     167, 16, }, // America/Indiana/Marengo
    {   58, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   58, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   58, 8056,     220, 14, }, // America/Indiana/Vevay
    {   58, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   58, 8104,     252, 16, }, // America/Indiana/Winamac
    {   58, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   58, 5951,     288, 22, }, // America/Lower_Princes
    {   58, 8171,     310,  6, }, // America/Maceio
    {   58, 2919,     316,  8, }, // America/Mazatlan
    {   58, 8238,     324,  6, }, // America/Merida
    {   58, 2951,    4381, 16, }, // America/Mexico_City
    {   58, 4410,     341, 12, }, // America/Miquelon
    {   58, 1852,     353, 19, }, // America/Noronha
    {   58, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   58, 8347,     392, 20, }, // America/North_Dakota/Center
    {   58, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   58,  393,     435,  4, }, // America/Nuuk
    {   58, 8495,     439,  8, }, // America/Santarem
    {   58, 1880,     447,  9, }, // America/Sao_Paulo
    {   58, 6918,     456, 16, }, // America/Scoresbysund
    {   58, 8526,     472, 14, }, // America/St_Barthelemy
    {   58, 2063,     486, 10, }, // America/St_Johns
    {   58, 5882,     496,  9, }, // America/St_Kitts
    {   58, 5899,     505,  9, }, // America/St_Lucia
    {   58,  855,     514, 10, }, // America/St_Thomas
    {   58, 5932,     524, 11, }, // America/St_Vincent
    {   58, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   58, 7295,     643,  5, }, // Antarctica/Syowa
    {   58, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   58, 4790,     704,  5, }, // Asia/Hovd
    {   58, 1187,     709,  9, }, // Asia/Kathmandu
    {   58,  994,     718,  7, }, // Asia/Kolkata
    {   58, 1213,     725,  5, }, // Asia/Macau
    {   58, 1161,     747,  6, }, // Asia/Urumqi
    {   58, 1237,     753,  6, }, // Asia/Yangon
    {   58, 6647,    4413,  8, }, // Atlantic/Canary
    {   58, 1397,     767,  5, }, // Atlantic/Faroe
    {   58, 6840,     773, 10, }, // Atlantic/St_Helena
    {   58, 8790,     799,  8, }, // Europe/Busingen
    {   58, 2585,     807,  8, }, // Europe/Chisinau
    {   58, 2529,     815,  4, }, // Europe/Kyiv
    {   58, 6221,     819,  6, }, // Europe/Tirane
    {   58, 5048,    4421,  7, }, // Indian/Comoro
    {   58, 7260,     896,  4, }, // Indian/Mahe
    {   58, 7211,     900,  7, }, // Indian/Reunion
    {   58, 3176,     922,  5, }, // Pacific/Chuuk
    {   58, 6697,     940,  9, }, // Pacific/Galapagos
    {   58, 3068,     957,  6, }, // Pacific/Kanton
    {   58, 7117,    1028,  6, }, // Pacific/Noumea
    {   58, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   58, 7405,    1068, 15, }, // Pacific/Wallis
    {   59, 6807,   27131,  7, }, // Africa/Abidjan Bashkir/Cyrillic/Russia
    {   59, 6779,    1089,  5, }, // Africa/Accra
    {   59, 5078,    1094, 11, }, // Africa/Addis_Ababa
    {   59, 7420,    1105,  5, }, // Africa/Algiers
    {   59,   14,   27138,  6, }, // Africa/Asmara
    {   59,   44,    1116,  6, }, // Africa/Bamako
    {   59, 5276,    1122,  5, }, // Africa/Bangui
    {   59, 6765,    1127,  6, }, // Africa/Banjul
    {   59, 7435,    1133,  5, }, // Africa/Bissau
    {   59, 4976,   27144,  8, }, // Africa/Blantyre
    {   59, 5306,   27152, 10, }, // Africa/Brazzaville
    {   59, 4941,    1155,  9, }, // Africa/Bujumbura
    {   59, 2322,   27162,  6, }, // Africa/Cairo
    {   59, 4136,    1168, 10, }, // Africa/Casablanca
    {   59, 7449,    1178,  5, }, // Africa/Ceuta
    {   59, 6792,    1183,  7, }, // Africa/Conakry
    {   59, 6859,    1190,  5, }, // Africa/Dakar
    {   59, 5149,   27168, 12, }, // Africa/Dar_es_Salaam
    {   59, 5062,   27180,  7, }, // Africa/Djibouti
    {   59, 5262,    1213,  5, }, // Africa/Douala
    {   59, 5185,   27187,  7, }, // Africa/El_Aaiun
    {   59, 6872,    1225,  7, }, // Africa/Freetown
    {   59, 4925,    1232,  8, }, // Africa/Gaborone
    {   59, 5034,   27194,  6, }, // Africa/Harare
    {   59, 4498,   27200, 12, }, // Africa/Johannesburg
    {   59, 4518,   27212,  5, }, // Africa/Juba
    {   59, 5170,    1262,  7, }, // Africa/Kampala
    {   59, 4543,    1269,  6, }, // Africa/Khartoum
    {   59, 4992,    1275,  6, }, // Africa/Kigali
    {   59, 5325,    1281,  7, }, // Africa/Kinshasa
    {   59, 4763,    1288,  5, }, // Africa/Lagos
    {   59, 5355,   27217,  9, }, // Africa/Libreville
    {   59, 6888,    1301,  4, }, // Africa/Lome
    {   59, 5230,    1305,  6, }, // Africa/Luanda
    {   59, 4958,    1311,  9, }, // Africa/Lubumbashi
    {   59, 5020,    1320,  6, }, // Africa/Lusaka
    {   59, 5341,    1326,  6, }, // Africa/Malabo
    {   59, 5006,    1332,  6, }, // Africa/Maputo
    {   59, 5216,    1338,  6, }, // Africa/Maseru
    {   59, 5201,    1344,  7, }, // Africa/Mbabane
    {   59, 5132,    1351,  8, }, // Africa/Mogadishu
    {   59, 7053,   27226,  8, }, // Africa/Monrovia
    {   59, 3872,   27234,  7, }, // Africa/Nairobi
    {   59, 5290,   27241,  8, }, // Africa/Ndjamena
    {   59, 5373,   27249,  6, }, // Africa/Niamey
    {   59, 6822,    1387,  7, }, // Africa/Nouakchott
    {   59, 6746,    1394,  8, }, // Africa/Ouagadougou
    {   59, 5244,    1402, 10, }, // Africa/Porto-Novo
    {   59, 4454,    1412,  8, }, // Africa/Sao_Tome
    {   59, 2868,    1420,  7, }, // Africa/Tripoli
    {   59, 6573,    1427,  5, }, // Africa/Tunis
    {   59, 4171,    1432,  7, }, // Africa/Windhoek
    {   59,  132,    1439,  4, }, // America/Adak
    {   59, 3365,   27255,  8, }, // America/Anchorage
    {   59, 5626,   27263,  7, }, // America/Anguilla
    {   59, 5643,    1457,  7, }, // America/Antigua
    {   59, 4573,    1464,  9, }, // America/Araguaina
    {   59,  166,   27270, 12, }, // America/Argentina/Buenos_Aires
    {   59,   91,    1485,  9, }, // America/Argentina/Catamarca
    {   59,  270,    1494,  7, }, // America/Argentina/Cordoba
    {   59,  441,   27282,  5, }, // America/Argentina/Jujuy
    {   59, 7462,    1506,  8, }, // America/Argentina/La_Rioja
    {   59,  565,    1514,  7, }, // America/Argentina/Mendoza
    {   59, 7489,   27287, 12, }, // America/Argentina/Rio_Gallegos
    {   59, 7520,   27299,  6, }, // America/Argentina/Salta
    {   59, 7544,    1537,  8, }, // America/Argentina/San_Juan
    {   59, 5599,    1545,  8, }, // America/Argentina/San_Luis
    {   59, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {   59, 7597,   27305,  5, }, // America/Argentina/Ushuaia
    {   59, 5659,    1566,  5, }, // America/Aruba
    {   59, 4271,   27310,  8, }, // America/Asuncion
    {   59,  237,   27318,  8, }, // America/Atikokan
    {   59, 3698,   27326,  4, }, // America/Bahia
    {   59, 7623,   27330, 16, }, // America/Bahia_Banderas
    {   59, 5673,    1610,  8, }, // America/Barbados
    {   59, 7646,    1618,  5, }, // America/Belem
    {   59, 5426,    1623,  5, }, // America/Belize
    {   59, 7660,   27346, 11, }, // America/Blanc-Sablon
    {   59, 7681,    1640,  9, }, // America/Boa_Vista
    {   59, 4380,    1649,  6, }, // America/Bogota
    {   59, 7699,   27357,  5, }, // America/Boise
    {   59, 7713,   27362, 13, }, // America/Cambridge_Bay
    {   59, 7735,    1672, 12, }, // America/Campo_Grande
    {   59, 3887,    1684,  6, }, // America/Cancun
    {   59, 4713,    1690,  7, }, // America/Caracas
    {   59, 4364,   27375,  7, }, // America/Cayenne
    {   59, 5515,   27382, 16, }, // America/Cayman
    {   59, 2262,    1726,  6, }, // America/Chicago
    {   59, 7756,    1732,  6, }, // America/Chihuahua
    {   59, 7774,   27398, 13, }, // America/Ciudad_Juarez
    {   59, 5441,    1738, 10, }, // America/Costa_Rica
    {   59, 7796,   27411,  8, }, // America/Coyhaique
    {   59, 7814,    1748,  7, }, // America/Creston
    {   59, 3810,   27419,  5, }, // America/Cuiaba
    {   59, 5742,   27424,  7, }, // America/Curacao
    {   59, 7830,    1769, 12, }, // America/Danmarkshavn
    {   59, 7851,    1781,  6, }, // America/Dawson
    {   59, 7866,    1787, 11, }, // America/Dawson_Creek
    {   59,  805,    1798,  6, }, // America/Denver
    {   59, 3484,   27431,  7, }, // America/Detroit
    {   59, 5758,    1811,  8, }, // America/Dominica
    {   59,  893,   27438,  8, }, // America/Edmonton
    {   59, 7887,   27446,  8, }, // America/Eirunepe
    {   59, 5460,   27454,  9, }, // America/El_Salvador
    {   59, 7904,   27463, 12, }, // America/Fort_Nelson
    {   59, 7924,    1854,  9, }, // America/Fortaleza
    {   59, 7942,   27475,  9, }, // America/Glace_Bay
    {   59, 6900,   27484,  7, }, // America/Goose_Bay
    {   59, 4631,    1879, 10, }, // America/Grand_Turk
    {   59, 5789,    1889,  7, }, // America/Grenada
    {   59, 5805,    1896,  9, }, // America/Guadeloupe
    {   59, 3779,    1905,  9, }, // America/Guatemala
    {   59, 4860,   27491,  8, }, // America/Guayaquil
    {   59, 6951,   27499,  6, }, // America/Guyana
    {   59, 1941,   27505,  8, }, // America/Halifax
    {   59, 2283,    1936,  6, }, // America/Havana
    {   59, 7960,   27513,  9, }, // America/Hermosillo
    {   59,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {   59,  481,    1962, 13, }, // America/Indiana/Knox
    {   59, 7979,    1975, 16, }, // America/Indiana/Marengo
    {   59, 8003,    1991, 19, }, // America/Indiana/Petersburg
    {   59, 8030,    2010,  9, }, // America/Indiana/Tell_City
    {   59, 8056,   27522, 14, }, // America/Indiana/Vevay
    {   59, 8078,   27536, 18, }, // America/Indiana/Vincennes
    {   59, 8104,   27554, 16, }, // America/Indiana/Winamac
    {   59, 8128,    2049,  6, }, // America/Inuvik
    {   59,  660,    2055,  7, }, // America/Iqaluit
    {   59, 2801,   27570,  6, }, // America/Jamaica
    {   59, 5399,   27576,  5, }, // America/Juneau
    {   59,  521,    2073,  8, }, // America/Kentucky/Louisville
    {   59, 8143,    2081, 20, }, // America/Kentucky/Monticello
    {   59, 5723,   27581, 10, }, // America/Kralendijk
    {   59, 4395,    2111,  6, }, // America/La_Paz
    {   59, 7169,    2117,  4, }, // America/Lima
    {   59, 3258,   27591, 12, }, // America/Los_Angeles
    {   59, 5951,   27603, 18, }, // America/Lower_Princes
    {   59, 8171,   27621,  6, }, // America/Maceio
    {   59, 8186,    2156,  7, }, // America/Managua
    {   59, 1910,    2163,  6, }, // America/Manaus
    {   59, 5916,    2169,  6, }, // America/Marigot
    {   59, 5824,    2175,  9, }, // America/Martinique
    {   59, 8202,    2184,  9, }, // America/Matamoros
    {   59, 2919,    2193,  8, }, // America/Mazatlan
    {   59, 8220,    2201,  8, }, // America/Menominee
    {   59, 8238,    2209,  6, }, // America/Merida
    {   59, 8253,    2215, 10, }, // America/Metlakatla
    {   59, 2951,    2225,  6, }, // America/Mexico_City
    {   59, 4410,   27627,  8, }, // America/Miquelon
    {   59, 8272,    2238,  7, }, // America/Moncton
    {   59, 8288,   27635,  9, }, // America/Monterrey
    {   59, 4117,    2254, 10, }, // America/Montevideo
    {   59, 5843,    2264, 10, }, // America/Montserrat
    {   59, 5500,    2274,  6, }, // America/Nassau
    {   59, 2381,   27644,  8, }, // America/New_York
    {   59, 8306,    2288,  3, }, // America/Nome
    {   59, 1852,   27652, 19, }, // America/Noronha
    {   59, 8319,   27671, 20, }, // America/North_Dakota/Beulah
    {   59, 8347,   27691, 19, }, // America/North_Dakota/Center
    {   59, 8375,   27710, 24, }, // America/North_Dakota/New_Salem
    {   59,  393,    2369,  4, }, // America/Nuuk
    {   59, 8406,    2373,  7, }, // America/Ojinaga
    {   59, 2358,    2380,  6, }, // America/Panama
    {   59, 6192,    2386, 10, }, // America/Paramaribo
    {   59, 2975,    2396,  6, }, // America/Phoenix
    {   59, 3964,    2402, 12, }, // America/Port-au-Prince
    {   59, 5973,   27734, 13, }, // America/Port_of_Spain
    {   59, 8422,   27747, 11, }, // America/Porto_Velho
    {   59, 5862,   27758, 11, }, // America/Puerto_Rico
    {   59, 4049,    2449, 12, }, // America/Punta_Arenas
    {   59, 8442,    2461, 12, }, // America/Rankin_Inlet
    {   59, 8463,    2473,  6, }, // America/Recife
    {   59, 1997,   27769,  6, }, // America/Regina
    {   59, 8478,   27775,  8, }, // America/Resolute
    {   59,  695,    2494, 10, }, // America/Rio_Branco
    {   59, 8495,    2504,  8, }, // America/Santarem
    {   59, 2203,   27783,  8, }, // America/Santiago
    {   59, 6130,    2520, 13, }, // America/Santo_Domingo
    {   59, 1880,    2533,  9, }, // America/Sao_Paulo
    {   59, 6918,    2542, 11, }, // America/Scoresbysund
    {   59, 8512,    2553,  5, }, // America/Sitka
    {   59, 8526,    2558, 13, }, // America/St_Barthelemy
    {   59, 2063,   27791, 10, }, // America/St_Johns
    {   59, 5882,    2580,  9, }, // America/St_Kitts
    {   59, 5899,   27801, 10, }, // America/St_Lucia
    {   59,  855,    2600, 10, }, // America/St_Thomas
    {   59, 5932,    2610, 12, }, // America/St_Vincent
    {   59, 8548,    2622, 13, }, // America/Swift_Current
    {   59, 5480,   27811, 12, }, // America/Tegucigalpa
    {   59, 5775,    2646,  4, }, // America/Thule
    {   59,  313,    2650,  7, }, // America/Tijuana
    {   59,  608,    2657,  7, }, // America/Toronto
    {   59, 5707,    2664,  7, }, // America/Tortola
    {   59, 2095,    2671,  8, }, // America/Vancouver
    {   59, 2146,   27823,  8, }, // America/Whitehorse
    {   59,  734,    2687,  8, }, // America/Winnipeg
    {   59, 8570,   27831,  6, }, // America/Yakutat
    {   59, 6020,   27837, 15, }, // Antarctica/Casey
    {   59, 6113,   27852,  6, }, // Antarctica/Davis
    {   59, 6152,   27858, 24, }, // Antarctica/DumontDUrville
    {   59, 8586,   27882, 15, }, // Antarctica/Macquarie
    {   59, 7085,   27897, 16, }, // Antarctica/Mawson
    {   59,  932,   27913, 19, }, // Antarctica/McMurdo
    {   59, 8607,    2751,  6, }, // Antarctica/Palmer
    {   59, 7226,   27932, 16, }, // Antarctica/Rothera
    {   59, 7295,   27948, 14, }, // Antarctica/Syowa
    {   59, 8625,   27962, 16, }, // Antarctica/Troll
    {   59, 7374,   27978, 16, }, // Antarctica/Vostok
    {   59, 1431,   27994,  7, }, // Arctic/Longyearbyen
    {   59, 5589,    2789,  4, }, // Asia/Aden
    {   59, 5414,    2793,  6, }, // Asia/Almaty
    {   59, 3987,    2799,  5, }, // Asia/Amman
    {   59, 5530,   28001,  7, }, // Asia/Anadyr
    {   59, 5542,   28008,  5, }, // Asia/Aqtau
    {   59, 5387,   28013,  6, }, // Asia/Aqtobe
    {   59,  966,    2821,  7, }, // Asia/Ashgabat
    {   59, 8642,    2828,  6, }, // Asia/Atyrau
    {   59, 3626,   28019,  6, }, // Asia/Baghdad
    {   59, 5553,   28025,  7, }, // Asia/Bahrain
    {   59, 3672,   28032,  4, }, // Asia/Baku
    {   59, 4485,    2851,  7, }, // Asia/Bangkok
    {   59, 3590,    2858,  7, }, // Asia/Barnaul
    {   59, 4105,   28036,  6, }, // Asia/Beirut
    {   59, 3797,   28042,  6, }, // Asia/Bishkek
    {   59, 6008,   28048,  6, }, // Asia/Brunei
    {   59, 4620,    2883,  4, }, // Asia/Chita
    {   59, 4530,    2887,  7, }, // Asia/Colombo
    {   59, 4559,   28054,  6, }, // Asia/Damascus
    {   59, 1095,    2900,  5, }, // Asia/Dhaka
    {   59, 6211,    2905,  4, }, // Asia/Dili
    {   59, 3615,   28060,  5, }, // Asia/Dubai
    {   59, 6178,   28065,  7, }, // Asia/Dushanbe
    {   59, 8654,    2921,  9, }, // Asia/Famagusta
    {   59, 8669,    2930,  4, }, // Asia/Gaza
    {   59, 4814,    2934,  6, }, // Asia/Hebron
    {   59, 1261,    2940,  7, }, // Asia/Ho_Chi_Minh
    {   59, 2706,   28072,  7, }, // Asia/Hong_Kong
    {   59, 4790,    2954,  4, }, // Asia/Hovd
    {   59, 4203,    2958,  7, }, // Asia/Irkutsk
    {   59, 7025,   28079,  8, }, // Asia/Jakarta
    {   59, 7011,   28087,  8, }, // Asia/Jayapura
    {   59, 1292,    2980,  9, }, // Asia/Jerusalem
    {   59, 3579,    2989,  5, }, // Asia/Kabul
    {   59, 4335,    3008,  8, }, // Asia/Kamchatka
    {   59, 4258,    3019,  6, }, // Asia/Karachi
    {   59, 1187,    3025,  8, }, // Asia/Kathmandu
    {   59, 8679,    3033,  7, }, // Asia/Khandyga
    {   59,  994,   28095,  9, }, // Asia/Kolkata
    {   59, 4216,   28104, 10, }, // Asia/Krasnoyarsk
    {   59, 4878,    3059, 12, }, // Asia/Kuala_Lumpur
    {   59, 5995,    3071,  6, }, // Asia/Kuching
    {   59, 5566,   28114,  6, }, // Asia/Kuwait
    {   59, 1213,    3083,  5, }, // Asia/Macau
    {   59, 4036,    3088,  7, }, // Asia/Magadan
    {   59, 1351,    3095,  7, }, // Asia/Makassar
    {   59, 7182,    3102,  6, }, // Asia/Manila
    {   59, 6939,    3108,  6, }, // Asia/Muscat
    {   59, 2556,   28120,  7, }, // Asia/Nicosia
    {   59, 8693,    3121, 11, }, // Asia/Novokuznetsk
    {   59, 4154,    3132, 11, }, // Asia/Novosibirsk
    {   59, 4248,    3143,  4, }, // Asia/Omsk
    {   59, 7145,   28127,  7, }, // Asia/Oral
    {   59, 6980,   28134,  8, }, // Asia/Phnom_Penh
    {   59, 8711,    3160,  9, }, // Asia/Pontianak
    {   59, 4233,   28142,  7, }, // Asia/Pyongyang
    {   59, 5578,    3176,  5, }, // Asia/Qatar
    {   59, 8726,   28149,  8, }, // Asia/Qostanay
    {   59, 4288,   28157,  9, }, // Asia/Qyzylorda
    {   59, 3603,   28166,  7, }, // Asia/Riyadh
    {   59, 4427,    3211,  7, }, // Asia/Sakhalin
    {   59, 7245,   28173,  9, }, // Asia/Samarkand
    {   59, 3298,    3227,  4, }, // Asia/Seoul
    {   59, 1055,   28182,  6, }, // Asia/Shanghai
    {   59, 3319,    3237,  8, }, // Asia/Singapore
    {   59, 4316,    3245, 13, }, // Asia/Srednekolymsk
    {   59, 3282,   28188,  6, }, // Asia/Taipei
    {   59, 4800,    3264,  7, }, // Asia/Tashkent
    {   59, 3934,   28194,  7, }, // Asia/Tbilisi
    {   59, 2774,   28201,  6, }, // Asia/Tehran
    {   59, 1319,    3282,  7, }, // Asia/Thimphu
    {   59, 2823,    3289,  5, }, // Asia/Tokyo
    {   59, 4591,    3294,  5, }, // Asia/Tomsk
    {   59, 1023,    3299, 10, }, // Asia/Ulaanbaatar
    {   59, 1161,   28207,  6, }, // Asia/Urumqi
    {   59, 8740,   28213,  9, }, // Asia/Ust-Nera
    {   59, 6996,   28222,  8, }, // Asia/Vientiane
    {   59, 4729,    3330, 11, }, // Asia/Vladivostok
    {   59, 4847,   28230,  6, }, // Asia/Yakutsk
    {   59, 1237,   28236,  5, }, // Asia/Yangon
    {   59, 3902,    3354, 12, }, // Asia/Yekaterinburg
    {   59, 3766,    3366,  6, }, // Asia/Yerevan
    {   59, 3682,   28241, 14, }, // Atlantic/Azores
    {   59, 5690,    3388,  6, }, // Atlantic/Bermuda
    {   59, 6647,   28255, 15, }, // Atlantic/Canary
    {   59, 3746,    3423, 10, }, // Atlantic/Cape_Verde
    {   59, 1397,   28270, 15, }, // Atlantic/Faroe
    {   59, 8754,   28285,  7, }, // Atlantic/Madeira
    {   59, 2750,   28292,  9, }, // Atlantic/Reykjavik
    {   59, 7272,   28301, 14, }, // Atlantic/South_Georgia
    {   59, 6840,   28315, 17, }, // Atlantic/St_Helena
    {   59, 6663,   28332,  6, }, // Atlantic/Stanley
    {   59, 1672,    3514,  8, }, // Australia/Adelaide
    {   59, 1637,    3522,  7, }, // Australia/Brisbane
    {   59, 1801,    3529, 11, }, // Australia/Broken_Hill
    {   59, 1585,    3540,  6, }, // Australia/Darwin
    {   59, 3656,   28338,  4, }, // Australia/Eucla
    {   59, 1518,    3551,  6, }, // Australia/Hobart
    {   59, 8771,    3557,  8, }, // Australia/Lindeman
    {   59, 1549,   28342, 15, }, // Australia/Lord_Howe
    {   59, 1729,   28357,  8, }, // Australia/Melbourne
    {   59, 1764,    3580,  4, }, // Australia/Perth
    {   59, 1465,   28365,  6, }, // Australia/Sydney
    {   59, 6460,    3590,  9, }, // Europe/Amsterdam
    {   59, 6235,    3599,  7, }, // Europe/Andorra
    {   59, 3639,   28371,  8, }, // Europe/Astrakhan
    {   59, 2302,   28379,  5, }, // Europe/Athens
    {   59, 6355,    3618,  7, }, // Europe/Belgrade
    {   59, 4776,    3625,  6, }, // Europe/Berlin
    {   59, 6507,    3631, 10, }, // Europe/Bratislava
    {   59, 2169,   28384,  8, }, // Europe/Brussels
    {   59, 3947,    3649,  8, }, // Europe/Bucharest
    {   59, 3825,    3657,  8, }, // Europe/Budapest
    {   59, 8790,   28392,  8, }, // Europe/Busingen
    {   59, 2585,    3688,  7, }, // Europe/Chisinau
    {   59, 6308,   28400, 10, }, // Europe/Copenhagen
    {   59, 2340,    3705,  6, }, // Europe/Dublin
    {   59, 6326,    3711,  9, }, // Europe/Gibraltar
    {   59, 8806,    3720,  6, }, // Europe/Guernsey
    {   59, 6631,   28410,  9, }, // Europe/Helsinki
    {   59, 8822,   28419, 10, }, // Europe/Isle_of_Man
    {   59, 1132,   28429,  8, }, // Europe/Istanbul
    {   59, 8841,   28437,  6, }, // Europe/Jersey
    {   59, 3998,    3755, 11, }, // Europe/Kaliningrad
    {   59, 8855,    3766,  5, }, // Europe/Kirov
    {   59, 2529,    3771,  4, }, // Europe/Kyiv
    {   59, 3232,    3775,  8, }, // Europe/Lisbon
    {   59, 6525,   28443,  7, }, // Europe/Ljubljana
    {   59, 2503,    3792,  6, }, // Europe/London
    {   59, 6384,   28450, 10, }, // Europe/Luxembourg
    {   59, 4911,    3809,  6, }, // Europe/Madrid
    {   59, 6416,   28460,  6, }, // Europe/Malta
    {   59, 6601,    3820,  9, }, // Europe/Mariehamn
    {   59, 3712,    3829,  5, }, // Europe/Minsk
    {   59, 6429,    3834,  6, }, // Europe/Monaco
    {   59, 3556,   28466,  6, }, // Europe/Moscow
    {   59, 6477,    3846,  4, }, // Europe/Oslo
    {   59, 4303,    3850,  5, }, // Europe/Paris
    {   59, 6443,    3855,  9, }, // Europe/Podgorica
    {   59, 6294,    3864,  5, }, // Europe/Prague
    {   59, 8868,    3869,  4, }, // Europe/Riga
    {   59, 6343,    3873,  3, }, // Europe/Rome
    {   59, 4350,   28472,  5, }, // Europe/Samara
    {   59, 6489,    3882, 10, }, // Europe/San_Marino
    {   59, 6264,    3892,  7, }, // Europe/Sarajevo
    {   59, 4470,   28477,  7, }, // Europe/Saratov
    {   59, 8880,   28484, 11, }, // Europe/Simferopol
    {   59, 6402,   28495,  6, }, // Europe/Skopje
    {   59, 6618,   28501,  5, }, // Europe/Sofia
    {   59, 6542,   28506,  9, }, // Europe/Stockholm
    {   59, 8898,    3934,  6, }, // Europe/Tallinn
    {   59, 6221,    3940,  6, }, // Europe/Tirane
    {   59, 8913,   28515,  9, }, // Europe/Ulyanovsk
    {   59, 6371,    3955,  5, }, // Europe/Vaduz
    {   59, 6586,    3960,  7, }, // Europe/Vatican
    {   59, 6250,    3967,  4, }, // Europe/Vienna
    {   59, 8930,   28524,  7, }, // Europe/Vilnius
    {   59, 4746,    3978,  9, }, // Europe/Volgograd
    {   59, 3209,    3987,  7, }, // Europe/Warsaw
    {   59, 6280,    3994,  6, }, // Europe/Zagreb
    {   59, 6559,   28531,  5, }, // Europe/Zurich
    {   59, 5097,    4006, 12, }, // Indian/Antananarivo
    {   59, 6966,    4018,  5, }, // Indian/Chagos
    {   59, 6065,   28536, 14, }, // Indian/Christmas
    {   59, 6082,   28550, 15, }, // Indian/Cocos
    {   59, 5048,   28565, 15, }, // Indian/Comoro
    {   59, 6680,   28580, 18, }, // Indian/Kerguelen
    {   59, 7260,   28598,  3, }, // Indian/Mahe
    {   59, 7069,   28601, 17, }, // Indian/Maldives
    {   59, 4088,   28618,  8, }, // Indian/Mauritius
    {   59, 5117,   28626,  7, }, // Indian/Mayotte
    {   59, 7211,   28633,  7, }, // Indian/Reunion
    {   59, 4441,    4095,  4, }, // Pacific/Apia
    {   59, 3009,    4099,  6, }, // Pacific/Auckland
    {   59, 3725,   28640,  9, }, // Pacific/Bougainville
    {   59, 3034,   28649, 15, }, // Pacific/Chatham
    {   59, 3176,    4118,  4, }, // Pacific/Chuuk
    {   59, 2239,   28664, 12, }, // Pacific/Easter
    {   59, 7360,   28676,  5, }, // Pacific/Efate
    {   59, 7327,    4138,  7, }, // Pacific/Fakaofo
    {   59, 3921,   28681,  5, }, // Pacific/Fiji
    {   59, 7343,    4149,  8, }, // Pacific/Funafuti
    {   59, 6697,   28686, 19, }, // Pacific/Galapagos
    {   59, 6715,   28705, 16, }, // Pacific/Gambier
    {   59, 3841,    4192, 11, }, // Pacific/Guadalcanal
    {   59, 6037,    4203,  4, }, // Pacific/Guam
    {   59, 3068,   28721, 13, }, // Pacific/Kanton
    {   59, 4017,    4213, 10, }, // Pacific/Kiritimati
    {   59, 7038,    4223,  6, }, // Pacific/Kosrae
    {   59, 2844,   28734, 10, }, // Pacific/Kwajalein
    {   59, 4896,   28744,  7, }, // Pacific/Majuro
    {   59, 4070,   28751, 16, }, // Pacific/Marquesas
    {   59, 8945,   28767, 13, }, // Pacific/Midway
    {   59, 7103,    4277,  5, }, // Pacific/Nauru
    {   59, 7132,   28780,  4, }, // Pacific/Niue
    {   59, 4187,   28784, 14, }, // Pacific/Norfolk
    {   59, 7117,    4293,  5, }, // Pacific/Noumea
    {   59, 3145,    4298,  9, }, // Pacific/Pago_Pago
    {   59, 7155,    4307,  5, }, // Pacific/Palau
    {   59, 7194,   28798, 17, }, // Pacific/Pitcairn
    {   59, 3115,    4319,  6, }, // Pacific/Pohnpei
    {   59, 4826,    4325, 11, }, // Pacific/Port_Moresby
    {   59, 6095,    4336,  9, }, // Pacific/Rarotonga
    {   59, 6050,   28815,  6, }, // Pacific/Saipan
    {   59, 7312,    4351,  5, }, // Pacific/Tahiti
    {   59, 6731,    4356,  6, }, // Pacific/Tarawa
    {   59, 4602,    4362,  9, }, // Pacific/Tongatapu
    {   59, 7392,   28821, 11, }, // Pacific/Wake
    {   59, 7405,   28832, 17, }, // Pacific/Wallis
    {   60, 6779,   21934,  5, }, // Africa/Accra Basque/Latin/Spain
    {   60, 5078,    4428, 11, }, // Africa/Addis_Ababa
    {   60, 7420,   28849,  5, }, // Africa/Algiers
    {   60,   14,       0,  6, }, // Africa/Asmara
    {   60, 5276,   28854,  5, }, // Africa/Bangui
    {   60, 2322,    5363,  5, }, // Africa/Cairo
    {   60, 6792,   28859,  7, }, // Africa/Conakry
    {   60, 5062,   28866,  7, }, // Africa/Djibouti
    {   60, 5262,   22024,  5, }, // Africa/Douala
    {   60, 5185,   28873,  5, }, // Africa/El_Aaiun
    {   60, 4543,   28878,  7, }, // Africa/Khartoum
    {   60, 6888,      14,  4, }, // Africa/Lome
    {   60, 5132,   28885,  8, }, // Africa/Mogadishu
    {   60, 5290,   28893,  9, }, // Africa/Ndjamena
    {   60, 5373,   28902,  6, }, // Africa/Niamey
    {   60, 6822,   21123,  7, }, // Africa/Nouakchott
    {   60, 6746,   28908,  8, }, // Africa/Ouagadougou
    {   60, 5244,   28916, 10, }, // Africa/Porto-Novo
    {   60, 4454,      27,  8, }, // Africa/Sao_Tome
    {   60, 5626,   28926,  7, }, // America/Anguilla
    {   60, 4573,      35,  9, }, // America/Araguaina
    {   60,  270,      44,  7, }, // America/Argentina/Cordoba
    {   60, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   60, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   60, 4271,      70,  8, }, // America/Asuncion
    {   60,  237,      78,  8, }, // America/Atikokan
    {   60, 7623,      86, 17, }, // America/Bahia_Banderas
    {   60, 7646,     103,  5, }, // America/Belem
    {   60, 4380,     108,  6, }, // America/Bogota
    {   60, 3887,     114,  6, }, // America/Cancun
    {   60, 5515,   28933,  6, }, // America/Cayman
    {   60, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   60, 3810,     133,  6, }, // America/Cuiaba
    {   60, 5742,     139,  7, }, // America/Curacao
    {   60, 5758,   22339,  8, }, // America/Dominica
    {   60, 7887,     146,  8, }, // America/Eirunepe
    {   60, 5805,   21187,  9, }, // America/Guadeloupe
    {   60, 2283,   21199,  6, }, // America/Havana
    {   60,  481,     154, 13, }, // America/Indiana/Knox
    {   60, 7979,     167, 16, }, // America/Indiana/Marengo
    {   60, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   60, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   60, 8056,     220, 14, }, // America/Indiana/Vevay
    {   60, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   60, 8104,     252, 16, }, // America/Indiana/Winamac
    {   60, 2801,    4507,  7, }, // America/Jamaica
    {   60, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   60, 5951,     288, 22, }, // America/Lower_Princes
    {   60, 8171,     310,  6, }, // America/Maceio
    {   60, 5824,   28939,  9, }, // America/Martinique
    {   60, 2919,     316,  8, }, // America/Mazatlan
    {   60, 8238,     324,  6, }, // America/Merida
    {   60, 2951,   28948, 12, }, // America/Mexico_City
    {   60, 4410,   28960,  8, }, // America/Miquelon
    {   60, 1852,     353, 19, }, // America/Noronha
    {   60, 8319,   28968, 19, }, // America/North_Dakota/Beulah
    {   60, 8347,   28987, 19, }, // America/North_Dakota/Center
    {   60, 8375,   29006, 22, }, // America/North_Dakota/New_Salem
    {   60,  393,     435,  4, }, // America/Nuuk
    {   60, 5973,   29028, 13, }, // America/Port_of_Spain
    {   60, 8495,     439,  8, }, // America/Santarem
    {   60, 1880,     447,  9, }, // America/Sao_Paulo
    {   60, 6918,     456, 16, }, // America/Scoresbysund
    {   60, 8526,   29041, 16, }, // America/St_Barthelemy
    {   60, 2063,   29057, 12, }, // America/St_Johns
    {   60, 5882,   29069, 11, }, // America/St_Kitts
    {   60, 5899,   29080, 11, }, // America/St_Lucia
    {   60,  855,   29091, 12, }, // America/St_Thomas
    {   60, 5932,   29103, 13, }, // America/St_Vincent
    {   60, 5775,   29116,  7, }, // America/Thule
    {   60, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   60, 7295,     643,  5, }, // Antarctica/Syowa
    {   60, 5542,     683,  5, }, // Asia/Aqtau
    {   60, 5387,    8259,  6, }, // Asia/Aqtobe
    {   60,  966,   29123,  7, }, // Asia/Ashgabat
    {   60, 3626,    4802,  6, }, // Asia/Baghdad
    {   60, 3797,   29130,  6, }, // Asia/Bishkek
    {   60, 4620,   29136,  5, }, // Asia/Chita
    {   60, 4530,    6295,  7, }, // Asia/Colombo
    {   60, 4559,   29141,  7, }, // Asia/Damascus
    {   60, 6178,   29148,  7, }, // Asia/Dushanbe
    {   60, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   60, 4790,     704,  5, }, // Asia/Hovd
    {   60, 4335,   29155,  9, }, // Asia/Kamchatka
    {   60, 4258,   29164,  7, }, // Asia/Karachi
    {   60, 1187,    6367,  8, }, // Asia/Kathmandu
    {   60, 8679,   29171,  8, }, // Asia/Khandyga
    {   60,  994,   29179,  7, }, // Asia/Kolkata
    {   60, 4216,   29186, 11, }, // Asia/Krasnoyarsk
    {   60, 1213,    4961,  5, }, // Asia/Macau
    {   60, 6939,   29197,  6, }, // Asia/Muscat
    {   60, 2556,    6387,  7, }, // Asia/Nicosia
    {   60, 4233,   29203,  9, }, // Asia/Pyongyang
    {   60, 8726,     730,  8, }, // Asia/Qostanay
    {   60, 4288,     738,  9, }, // Asia/Qyzylorda
    {   60, 3603,    8440,  4, }, // Asia/Riyadh
    {   60, 7245,   29212, 10, }, // Asia/Samarkand
    {   60, 3298,    8451,  4, }, // Asia/Seoul
    {   60, 3319,   21561,  8, }, // Asia/Singapore
    {   60, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {   60, 4800,   29222,  7, }, // Asia/Tashkent
    {   60, 2774,    8495,  7, }, // Asia/Tehran
    {   60, 2823,    4996,  5, }, // Asia/Tokyo
    {   60, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {   60, 1161,     747,  6, }, // Asia/Urumqi
    {   60, 6996,   29239,  8, }, // Asia/Vientiane
    {   60, 4847,    8526,  7, }, // Asia/Yakutsk
    {   60, 1237,     753,  6, }, // Asia/Yangon
    {   60, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {   60, 3766,   29247,  6, }, // Asia/Yerevan
    {   60, 3682,   29253,  7, }, // Atlantic/Azores
    {   60, 6647,   29260,  8, }, // Atlantic/Canary
    {   60, 3746,   29268, 10, }, // Atlantic/Cape_Verde
    {   60, 1397,     767,  5, }, // Atlantic/Faroe
    {   60, 7272,   29278, 19, }, // Atlantic/South_Georgia
    {   60, 6840,   29297, 12, }, // Atlantic/St_Helena
    {   60, 2302,   29309,  6, }, // Europe/Athens
    {   60, 6355,   29315,  7, }, // Europe/Belgrade
    {   60, 2169,   29322,  7, }, // Europe/Brussels
    {   60, 3947,   29329,  8, }, // Europe/Bucharest
    {   60, 8790,     799,  8, }, // Europe/Busingen
    {   60, 2585,     807,  8, }, // Europe/Chisinau
    {   60, 6308,    5115,  9, }, // Europe/Copenhagen
    {   60, 8806,   29337,  9, }, // Europe/Guernsey
    {   60, 8822,   29346, 11, }, // Europe/Isle_of_Man
    {   60, 2529,    8801,  4, }, // Europe/Kyiv
    {   60, 3232,   21790,  6, }, // Europe/Lisbon
    {   60, 2503,   21805,  7, }, // Europe/London
    {   60, 6384,   29357, 10, }, // Europe/Luxembourg
    {   60, 4911,   29367,  6, }, // Europe/Madrid
    {   60, 6429,    8840,  6, }, // Europe/Monaco
    {   60, 3556,   29373,  5, }, // Europe/Moscow
    {   60, 6294,   21838,  5, }, // Europe/Prague
    {   60, 6343,   29378,  6, }, // Europe/Rome
    {   60, 6221,     819,  6, }, // Europe/Tirane
    {   60, 8913,   29384,  9, }, // Europe/Ulyanovsk
    {   60, 6586,   29393, 14, }, // Europe/Vatican
    {   60, 6250,   21881,  5, }, // Europe/Vienna
    {   60, 3209,   21895,  8, }, // Europe/Warsaw
    {   60, 6559,    5217,  6, }, // Europe/Zurich
    {   60, 5048,    4421,  7, }, // Indian/Comoro
    {   60, 7260,     896,  4, }, // Indian/Mahe
    {   60, 7069,   29407,  8, }, // Indian/Maldives
    {   60, 4088,   29415,  8, }, // Indian/Mauritius
    {   60, 7211,     900,  7, }, // Indian/Reunion
    {   60, 3176,     922,  5, }, // Pacific/Chuuk
    {   60, 2239,   29423, 13, }, // Pacific/Easter
    {   60, 7360,   29436,  5, }, // Pacific/Efate
    {   60, 6697,   29441, 10, }, // Pacific/Galapagos
    {   60, 2725,    5251,  8, }, // Pacific/Honolulu
    {   60, 3068,     957,  6, }, // Pacific/Kanton
    {   60, 4070,   29451,  8, }, // Pacific/Marquesas
    {   60, 7117,    1028,  6, }, // Pacific/Noumea
    {   60, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   60, 7405,    1068, 15, }, // Pacific/Wallis
    {   61, 6807,   29459,  7, }, // Africa/Abidjan Belarusian/Cyrillic/Belarus
    {   61, 6779,   29466,  4, }, // Africa/Accra
    {   61, 5078,   29470, 10, }, // Africa/Addis_Ababa
    {   61, 7420,   29480,  5, }, // Africa/Algiers
    {   61,   14,   29485,  6, }, // Africa/Asmara
    {   61,   44,    1116,  6, }, // Africa/Bamako
    {   61, 5276,   29491,  5, }, // Africa/Bangui
    {   61, 6765,   29496,  7, }, // Africa/Banjul
    {   61, 7435,   29503,  5, }, // Africa/Bissau
    {   61, 4976,   27144,  8, }, // Africa/Blantyre
    {   61, 5306,   29508,  9, }, // Africa/Brazzaville
    {   61, 4941,    1155,  9, }, // Africa/Bujumbura
    {   61, 2322,   29517,  4, }, // Africa/Cairo
    {   61, 4136,    1168, 10, }, // Africa/Casablanca
    {   61, 7449,    1178,  5, }, // Africa/Ceuta
    {   61, 6792,   29521,  7, }, // Africa/Conakry
    {   61, 6859,    1190,  5, }, // Africa/Dakar
    {   61, 5149,   27168, 12, }, // Africa/Dar_es_Salaam
    {   61, 5062,   29528,  7, }, // Africa/Djibouti
    {   61, 5262,    1213,  5, }, // Africa/Douala
    {   61, 5185,   27187,  7, }, // Africa/El_Aaiun
    {   61, 6872,   29535,  7, }, // Africa/Freetown
    {   61, 4925,   29542,  8, }, // Africa/Gaborone
    {   61, 5034,   29550,  6, }, // Africa/Harare
    {   61, 4498,   29556, 10, }, // Africa/Johannesburg
    {   61, 4518,   27212,  5, }, // Africa/Juba
    {   61, 5170,    1262,  7, }, // Africa/Kampala
    {   61, 4543,    1269,  6, }, // Africa/Khartoum
    {   61, 4992,   29566,  6, }, // Africa/Kigali
    {   61, 5325,   29572,  7, }, // Africa/Kinshasa
    {   61, 4763,   29579,  5, }, // Africa/Lagos
    {   61, 5355,   29584,  9, }, // Africa/Libreville
    {   61, 6888,   29593,  4, }, // Africa/Lome
    {   61, 5230,    1305,  6, }, // Africa/Luanda
    {   61, 4958,   29597,  9, }, // Africa/Lubumbashi
    {   61, 5020,    1320,  6, }, // Africa/Lusaka
    {   61, 5341,   29606,  6, }, // Africa/Malabo
    {   61, 5006,    1332,  6, }, // Africa/Maputo
    {   61, 5216,    1338,  6, }, // Africa/Maseru
    {   61, 5201,   29612,  7, }, // Africa/Mbabane
    {   61, 5132,   29619,  8, }, // Africa/Mogadishu
    {   61, 7053,   29627,  8, }, // Africa/Monrovia
    {   61, 3872,   29635,  7, }, // Africa/Nairobi
    {   61, 5290,   27241,  8, }, // Africa/Ndjamena
    {   61, 5373,   29642,  6, }, // Africa/Niamey
    {   61, 6822,    1387,  7, }, // Africa/Nouakchott
    {   61, 6746,    1394,  8, }, // Africa/Ouagadougou
    {   61, 5244,   29648, 10, }, // Africa/Porto-Novo
    {   61, 4454,   29658,  8, }, // Africa/Sao_Tome
    {   61, 2868,   29666,  7, }, // Africa/Tripoli
    {   61, 6573,   29673,  5, }, // Africa/Tunis
    {   61, 4171,   29678,  7, }, // Africa/Windhoek
    {   61,  132,    1439,  4, }, // America/Adak
    {   61, 3365,   29685,  8, }, // America/Anchorage
    {   61, 5626,   29693,  7, }, // America/Anguilla
    {   61, 5643,   29700,  7, }, // America/Antigua
    {   61, 4573,   29707,  9, }, // America/Araguaina
    {   61,  166,   29716, 12, }, // America/Argentina/Buenos_Aires
    {   61,   91,    1485,  9, }, // America/Argentina/Catamarca
    {   61,  270,   29728,  7, }, // America/Argentina/Cordoba
    {   61,  441,   27282,  5, }, // America/Argentina/Jujuy
    {   61, 7462,   29735,  8, }, // America/Argentina/La_Rioja
    {   61,  565,    1514,  7, }, // America/Argentina/Mendoza
    {   61, 7489,   29743, 12, }, // America/Argentina/Rio_Gallegos
    {   61, 7520,   27299,  6, }, // America/Argentina/Salta
    {   61, 7544,    1537,  8, }, // America/Argentina/San_Juan
    {   61, 5599,   29755,  8, }, // America/Argentina/San_Luis
    {   61, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {   61, 7597,   27305,  5, }, // America/Argentina/Ushuaia
    {   61, 5659,    1566,  5, }, // America/Aruba
    {   61, 4271,   29763,  8, }, // America/Asuncion
    {   61,  237,   29771,  8, }, // America/Atikokan
    {   61, 3698,   29779,  4, }, // America/Bahia
    {   61, 7623,   29783, 16, }, // America/Bahia_Banderas
    {   61, 5673,   29799,  8, }, // America/Barbados
    {   61, 7646,    1618,  5, }, // America/Belem
    {   61, 5426,   29807,  5, }, // America/Belize
    {   61, 7660,    1628, 12, }, // America/Blanc-Sablon
    {   61, 7681,   29812,  9, }, // America/Boa_Vista
    {   61, 4380,   29821,  6, }, // America/Bogota
    {   61, 7699,   29827,  5, }, // America/Boise
    {   61, 7713,   29832, 12, }, // America/Cambridge_Bay
    {   61, 7735,   29844, 12, }, // America/Campo_Grande
    {   61, 3887,    1684,  6, }, // America/Cancun
    {   61, 4713,    1690,  7, }, // America/Caracas
    {   61, 4364,   29856,  5, }, // America/Cayenne
    {   61, 5515,   29861, 17, }, // America/Cayman
    {   61, 2262,   29878,  6, }, // America/Chicago
    {   61, 7756,   29884,  6, }, // America/Chihuahua
    {   61, 7774,   29890, 13, }, // America/Ciudad_Juarez
    {   61, 5441,   29903, 10, }, // America/Costa_Rica
    {   61, 7796,   29913,  7, }, // America/Coyhaique
    {   61, 7814,   29920,  7, }, // America/Creston
    {   61, 3810,   27419,  5, }, // America/Cuiaba
    {   61, 5742,   29927,  7, }, // America/Curacao
    {   61, 7830,   29934, 12, }, // America/Danmarkshavn
    {   61, 7851,   29946,  6, }, // America/Dawson
    {   61, 7866,   29952, 10, }, // America/Dawson_Creek
    {   61,  805,   29962,  6, }, // America/Denver
    {   61, 3484,   29968,  7, }, // America/Detroit
    {   61, 5758,   29975,  8, }, // America/Dominica
    {   61,  893,   29983,  8, }, // America/Edmonton
    {   61, 7887,   29991,  8, }, // America/Eirunepe
    {   61, 5460,   27454,  9, }, // America/El_Salvador
    {   61, 7904,   29999, 12, }, // America/Fort_Nelson
    {   61, 7924,   30011,  9, }, // America/Fortaleza
    {   61, 7942,   30020,  9, }, // America/Glace_Bay
    {   61, 6900,   30029,  7, }, // America/Goose_Bay
    {   61, 4631,   30036, 10, }, // America/Grand_Turk
    {   61, 5789,   30046,  7, }, // America/Grenada
    {   61, 5805,   30053,  9, }, // America/Guadeloupe
    {   61, 3779,   30062,  9, }, // America/Guatemala
    {   61, 4860,   30071,  8, }, // America/Guayaquil
    {   61, 6951,   30079,  5, }, // America/Guyana
    {   61, 1941,   30084,  8, }, // America/Halifax
    {   61, 2283,    1936,  6, }, // America/Havana
    {   61, 7960,   30092,  9, }, // America/Hermosillo
    {   61,  348,   30101, 12, }, // America/Indiana/Indianapolis
    {   61,  481,   30113, 13, }, // America/Indiana/Knox
    {   61, 7979,   30126, 16, }, // America/Indiana/Marengo
    {   61, 8003,   30142, 19, }, // America/Indiana/Petersburg
    {   61, 8030,   30161, 17, }, // America/Indiana/Tell_City
    {   61, 8056,   30178, 13, }, // America/Indiana/Vevay
    {   61, 8078,   30191, 16, }, // America/Indiana/Vincennes
    {   61, 8104,   30207, 16, }, // America/Indiana/Winamac
    {   61, 8128,   30223,  6, }, // America/Inuvik
    {   61,  660,   30229,  7, }, // America/Iqaluit
    {   61, 2801,   27570,  6, }, // America/Jamaica
    {   61, 5399,   30236,  5, }, // America/Juneau
    {   61,  521,   30241,  7, }, // America/Kentucky/Louisville
    {   61, 8143,   30248, 18, }, // America/Kentucky/Monticello
    {   61, 5723,   30266, 10, }, // America/Kralendijk
    {   61, 4395,    2111,  6, }, // America/La_Paz
    {   61, 7169,   30276,  4, }, // America/Lima
    {   61, 3258,   30280, 12, }, // America/Los_Angeles
    {   61, 5951,   30292, 20, }, // America/Lower_Princes
    {   61, 8171,   30312,  5, }, // America/Maceio
    {   61, 8186,    2156,  7, }, // America/Managua
    {   61, 1910,   30317,  6, }, // America/Manaus
    {   61, 5916,   30323,  6, }, // America/Marigot
    {   61, 5824,   30329,  9, }, // America/Martinique
    {   61, 8202,   30338,  9, }, // America/Matamoros
    {   61, 2919,    2193,  8, }, // America/Mazatlan
    {   61, 8220,   30347,  8, }, // America/Menominee
    {   61, 8238,   30355,  6, }, // America/Merida
    {   61, 8253,    2215, 10, }, // America/Metlakatla
    {   61, 2951,   30361,  6, }, // America/Mexico_City
    {   61, 4410,   30367,  7, }, // America/Miquelon
    {   61, 8272,   30374,  7, }, // America/Moncton
    {   61, 8288,   30381,  8, }, // America/Monterrey
    {   61, 4117,   30389, 10, }, // America/Montevideo
    {   61, 5843,   30399,  9, }, // America/Montserrat
    {   61, 5500,   30408,  5, }, // America/Nassau
    {   61, 2381,   30413,  7, }, // America/New_York
    {   61, 8306,    2288,  3, }, // America/Nome
    {   61, 1852,   30420,  7, }, // America/Noronha
    {   61, 8319,   30427, 23, }, // America/North_Dakota/Beulah
    {   61, 8347,   30450, 24, }, // America/North_Dakota/Center
    {   61, 8375,   30474, 28, }, // America/North_Dakota/New_Salem
    {   61,  393,   30502,  3, }, // America/Nuuk
    {   61, 8406,   30505,  7, }, // America/Ojinaga
    {   61, 2358,    2380,  6, }, // America/Panama
    {   61, 6192,   30512, 10, }, // America/Paramaribo
    {   61, 2975,   30522,  6, }, // America/Phoenix
    {   61, 3964,   30528, 12, }, // America/Port-au-Prince
    {   61, 5973,   27734, 13, }, // America/Port_of_Spain
    {   61, 8422,   27747, 11, }, // America/Porto_Velho
    {   61, 5862,   30540, 11, }, // America/Puerto_Rico
    {   61, 4049,   30551, 12, }, // America/Punta_Arenas
    {   61, 8442,   30563, 12, }, // America/Rankin_Inlet
    {   61, 8463,   30575,  6, }, // America/Recife
    {   61, 1997,   30581,  8, }, // America/Regina
    {   61, 8478,   30589,  8, }, // America/Resolute
    {   61,  695,   30597, 10, }, // America/Rio_Branco
    {   61, 8495,   30607,  8, }, // America/Santarem
    {   61, 2203,   30615,  8, }, // America/Santiago
    {   61, 6130,   30623, 13, }, // America/Santo_Domingo
    {   61, 1880,   30636,  9, }, // America/Sao_Paulo
    {   61, 6918,   30645, 13, }, // America/Scoresbysund
    {   61, 8512,   30658,  5, }, // America/Sitka
    {   61, 8526,   30663, 13, }, // America/St_Barthelemy
    {   61, 2063,   27791, 10, }, // America/St_Johns
    {   61, 5882,   30676,  9, }, // America/St_Kitts
    {   61, 5899,   30685, 10, }, // America/St_Lucia
    {   61,  855,    2600, 10, }, // America/St_Thomas
    {   61, 5932,   30695, 12, }, // America/St_Vincent
    {   61, 8548,   30707, 12, }, // America/Swift_Current
    {   61, 5480,   30719, 12, }, // America/Tegucigalpa
    {   61, 5775,    2646,  4, }, // America/Thule
    {   61,  313,   30731,  7, }, // America/Tijuana
    {   61,  608,   30738,  7, }, // America/Toronto
    {   61, 5707,   30745,  7, }, // America/Tortola
    {   61, 2095,    2671,  8, }, // America/Vancouver
    {   61, 2146,   27823,  8, }, // America/Whitehorse
    {   61,  734,   30752,  7, }, // America/Winnipeg
    {   61, 8570,   27831,  6, }, // America/Yakutat
    {   61, 6020,   30759,  5, }, // Antarctica/Casey
    {   61, 6113,   30764,  6, }, // Antarctica/Davis
    {   61, 6152,   30770, 15, }, // Antarctica/DumontDUrville
    {   61, 8586,   30785,  7, }, // Antarctica/Macquarie
    {   61, 7085,   30792,  6, }, // Antarctica/Mawson
    {   61,  932,   30798,  9, }, // Antarctica/McMurdo
    {   61, 8607,    2751,  6, }, // Antarctica/Palmer
    {   61, 7226,   30807,  6, }, // Antarctica/Rothera
    {   61, 7295,   27948,  4, }, // Antarctica/Syowa
    {   61, 8625,    2768,  4, }, // Antarctica/Troll
    {   61, 7374,   30813,  6, }, // Antarctica/Vostok
    {   61, 1431,   30819,  7, }, // Arctic/Longyearbyen
    {   61, 5589,   30826,  4, }, // Asia/Aden
    {   61, 5414,    2793,  6, }, // Asia/Almaty
    {   61, 3987,   30830, 12, }, // Asia/Amman
    {   61, 5530,    2804,  6, }, // Asia/Anadyr
    {   61, 5542,    2810,  5, }, // Asia/Aqtau
    {   61, 5387,   30842,  6, }, // Asia/Aqtobe
    {   61,  966,   30848,  7, }, // Asia/Ashgabat
    {   61, 8642,    2828,  6, }, // Asia/Atyrau
    {   61, 3626,    2834,  6, }, // Asia/Baghdad
    {   61, 5553,   30855,  7, }, // Asia/Bahrain
    {   61, 3672,    2847,  4, }, // Asia/Baku
    {   61, 4485,    2851,  7, }, // Asia/Bangkok
    {   61, 3590,    2858,  7, }, // Asia/Barnaul
    {   61, 4105,   28036,  6, }, // Asia/Beirut
    {   61, 3797,   30862,  6, }, // Asia/Bishkek
    {   61, 6008,   28048,  6, }, // Asia/Brunei
    {   61, 4620,   30868,  4, }, // Asia/Chita
    {   61, 4530,   30872,  7, }, // Asia/Colombo
    {   61, 4559,    2894,  6, }, // Asia/Damascus
    {   61, 1095,    1190,  4, }, // Asia/Dhaka
    {   61, 6211,   30879,  4, }, // Asia/Dili
    {   61, 3615,   28060,  5, }, // Asia/Dubai
    {   61, 6178,   30883,  7, }, // Asia/Dushanbe
    {   61, 8654,    2921,  9, }, // Asia/Famagusta
    {   61, 8669,    2930,  4, }, // Asia/Gaza
    {   61, 4814,   30890,  6, }, // Asia/Hebron
    {   61, 1261,   30896,  7, }, // Asia/Ho_Chi_Minh
    {   61, 2706,   30903,  7, }, // Asia/Hong_Kong
    {   61, 4790,   30910,  4, }, // Asia/Hovd
    {   61, 4203,   30914,  6, }, // Asia/Irkutsk
    {   61, 7025,   28079,  8, }, // Asia/Jakarta
    {   61, 7011,   28087,  8, }, // Asia/Jayapura
    {   61, 1292,   30920,  9, }, // Asia/Jerusalem
    {   61, 3579,    2989,  5, }, // Asia/Kabul
    {   61, 4335,    3008,  8, }, // Asia/Kamchatka
    {   61, 4258,   30929,  6, }, // Asia/Karachi
    {   61, 1187,    3025,  8, }, // Asia/Kathmandu
    {   61, 8679,    3033,  7, }, // Asia/Khandyga
    {   61,  994,   30935,  8, }, // Asia/Kolkata
    {   61, 4216,   30943, 10, }, // Asia/Krasnoyarsk
    {   61, 4878,    3059, 12, }, // Asia/Kuala_Lumpur
    {   61, 5995,   30953,  6, }, // Asia/Kuching
    {   61, 5566,   28114,  6, }, // Asia/Kuwait
    {   61, 1213,   30959,  5, }, // Asia/Macau
    {   61, 4036,    3088,  7, }, // Asia/Magadan
    {   61, 1351,    3095,  7, }, // Asia/Makassar
    {   61, 7182,   30964,  6, }, // Asia/Manila
    {   61, 6939,    3108,  6, }, // Asia/Muscat
    {   61, 2556,   30970,  7, }, // Asia/Nicosia
    {   61, 8693,   30977, 11, }, // Asia/Novokuznetsk
    {   61, 4154,   30988, 11, }, // Asia/Novosibirsk
    {   61, 4248,    3143,  4, }, // Asia/Omsk
    {   61, 7145,   28127,  7, }, // Asia/Oral
    {   61, 6980,   30999,  8, }, // Asia/Phnom_Penh
    {   61, 8711,   31007,  9, }, // Asia/Pontianak
    {   61, 4233,   28142,  7, }, // Asia/Pyongyang
    {   61, 5578,    3176,  5, }, // Asia/Qatar
    {   61, 8726,   31016,  8, }, // Asia/Qostanay
    {   61, 4288,   31024,  9, }, // Asia/Qyzylorda
    {   61, 3603,   31033,  7, }, // Asia/Riyadh
    {   61, 4427,   31040,  7, }, // Asia/Sakhalin
    {   61, 7245,    3218,  9, }, // Asia/Samarkand
    {   61, 3298,    3227,  4, }, // Asia/Seoul
    {   61, 1055,   28182,  6, }, // Asia/Shanghai
    {   61, 3319,   31047,  8, }, // Asia/Singapore
    {   61, 4316,   31055, 14, }, // Asia/Srednekolymsk
    {   61, 3282,   31069,  6, }, // Asia/Taipei
    {   61, 4800,    3264,  7, }, // Asia/Tashkent
    {   61, 3934,   31075,  7, }, // Asia/Tbilisi
    {   61, 2774,   31082,  7, }, // Asia/Tehran
    {   61, 1319,   31089,  7, }, // Asia/Thimphu
    {   61, 2823,   31096,  5, }, // Asia/Tokyo
    {   61, 4591,    3294,  5, }, // Asia/Tomsk
    {   61, 1023,   31101, 10, }, // Asia/Ulaanbaatar
    {   61, 1161,   31111,  6, }, // Asia/Urumqi
    {   61, 8740,   31117,  9, }, // Asia/Ust-Nera
    {   61, 6996,   31126,  8, }, // Asia/Vientiane
    {   61, 4729,   31134, 12, }, // Asia/Vladivostok
    {   61, 4847,   31146,  5, }, // Asia/Yakutsk
    {   61, 1237,   31151,  6, }, // Asia/Yangon
    {   61, 3902,   31157, 12, }, // Asia/Yekaterinburg
    {   61, 3766,   31169,  6, }, // Asia/Yerevan
    {   61, 3682,   31175, 16, }, // Atlantic/Azores
    {   61, 5690,   31191, 18, }, // Atlantic/Bermuda
    {   61, 6647,   31209, 17, }, // Atlantic/Canary
    {   61, 3746,   31226, 10, }, // Atlantic/Cape_Verde
    {   61, 1397,   31236, 17, }, // Atlantic/Faroe
    {   61, 8754,   31253,  7, }, // Atlantic/Madeira
    {   61, 2750,   31260,  9, }, // Atlantic/Reykjavik
    {   61, 7272,   31269, 17, }, // Atlantic/South_Georgia
    {   61, 6840,   31286, 20, }, // Atlantic/St_Helena
    {   61, 6663,   31306, 11, }, // Atlantic/Stanley
    {   61, 1672,   31317,  8, }, // Australia/Adelaide
    {   61, 1637,   31325,  7, }, // Australia/Brisbane
    {   61, 1801,   31332, 10, }, // Australia/Broken_Hill
    {   61, 1585,   31342,  6, }, // Australia/Darwin
    {   61, 3656,   28338,  4, }, // Australia/Eucla
    {   61, 1518,    3551,  6, }, // Australia/Hobart
    {   61, 8771,   31348,  8, }, // Australia/Lindeman
    {   61, 1549,    3565,  8, }, // Australia/Lord_Howe
    {   61, 1729,   28357,  8, }, // Australia/Melbourne
    {   61, 1764,    3580,  4, }, // Australia/Perth
    {   61, 1465,   31356,  6, }, // Australia/Sydney
    {   61, 6460,   31362,  9, }, // Europe/Amsterdam
    {   61, 6235,   31371,  6, }, // Europe/Andorra
    {   61, 3639,   31377,  9, }, // Europe/Astrakhan
    {   61, 2302,   31386,  5, }, // Europe/Athens
    {   61, 6355,   31391,  7, }, // Europe/Belgrade
    {   61, 4776,   31398,  6, }, // Europe/Berlin
    {   61, 6507,   31404, 10, }, // Europe/Bratislava
    {   61, 2169,   31414,  7, }, // Europe/Brussels
    {   61, 3947,   31421,  8, }, // Europe/Bucharest
    {   61, 3825,    3657,  8, }, // Europe/Budapest
    {   61, 8790,   31429,  8, }, // Europe/Busingen
    {   61, 2585,   31437,  7, }, // Europe/Chisinau
    {   61, 6308,   31444, 10, }, // Europe/Copenhagen
    {   61, 2340,   31454,  6, }, // Europe/Dublin
    {   61, 6326,   31460,  9, }, // Europe/Gibraltar
    {   61, 8806,   31469,  6, }, // Europe/Guernsey
    {   61, 6631,   31475,  9, }, // Europe/Helsinki
    {   61, 8822,   31484, 11, }, // Europe/Isle_of_Man
    {   61, 1132,    3743,  7, }, // Europe/Istanbul
    {   61, 8841,   31495,  6, }, // Europe/Jersey
    {   61, 3998,   31501, 11, }, // Europe/Kaliningrad
    {   61, 8855,   31512,  5, }, // Europe/Kirov
    {   61, 2529,   31517,  4, }, // Europe/Kyiv
    {   61, 3232,   31521,  7, }, // Europe/Lisbon
    {   61, 6525,   28443,  7, }, // Europe/Ljubljana
    {   61, 2503,   31528,  6, }, // Europe/London
    {   61, 6384,   28450, 10, }, // Europe/Luxembourg
    {   61, 4911,   31534,  6, }, // Europe/Madrid
    {   61, 6416,   28460,  6, }, // Europe/Malta
    {   61, 6601,   31540, 12, }, // Europe/Mariehamn
    {   61, 3712,   31552,  5, }, // Europe/Minsk
    {   61, 6429,   31557,  6, }, // Europe/Monaco
    {   61, 3556,   31563,  6, }, // Europe/Moscow
    {   61, 6477,   31569,  4, }, // Europe/Oslo
    {   61, 4303,   31573,  5, }, // Europe/Paris
    {   61, 6443,   31578,  9, }, // Europe/Podgorica
    {   61, 6294,    3864,  5, }, // Europe/Prague
    {   61, 8868,   31587,  4, }, // Europe/Riga
    {   61, 6343,   31591,  3, }, // Europe/Rome
    {   61, 4350,    3876,  6, }, // Europe/Samara
    {   61, 6489,   31594, 10, }, // Europe/San_Marino
    {   61, 6264,   31604,  7, }, // Europe/Sarajevo
    {   61, 4470,   31611,  7, }, // Europe/Saratov
    {   61, 8880,   31618, 11, }, // Europe/Simferopol
    {   61, 6402,   31629,  6, }, // Europe/Skopje
    {   61, 6618,   31635,  5, }, // Europe/Sofia
    {   61, 6542,   31640,  9, }, // Europe/Stockholm
    {   61, 8898,   31649,  5, }, // Europe/Tallinn
    {   61, 6221,   31654,  6, }, // Europe/Tirane
    {   61, 8913,   31660,  9, }, // Europe/Ulyanovsk
    {   61, 6371,    3955,  5, }, // Europe/Vaduz
    {   61, 6586,   31669,  7, }, // Europe/Vatican
    {   61, 6250,    3967,  4, }, // Europe/Vienna
    {   61, 8930,   31676,  7, }, // Europe/Vilnius
    {   61, 4746,   31683,  9, }, // Europe/Volgograd
    {   61, 3209,    3987,  7, }, // Europe/Warsaw
    {   61, 6280,   31692,  6, }, // Europe/Zagreb
    {   61, 6559,   31698,  5, }, // Europe/Zurich
    {   61, 5097,   31703, 12, }, // Indian/Antananarivo
    {   61, 6966,   31715,  5, }, // Indian/Chagos
    {   61, 6065,   31720, 13, }, // Indian/Christmas
    {   61, 6082,   31733, 17, }, // Indian/Cocos
    {   61, 5048,   31750, 17, }, // Indian/Comoro
    {   61, 6680,    4057,  8, }, // Indian/Kerguelen
    {   61, 7260,   28598,  3, }, // Indian/Mahe
    {   61, 7069,   31767,  8, }, // Indian/Maldives
    {   61, 4088,   31775,  8, }, // Indian/Mauritius
    {   61, 5117,   31783,  5, }, // Indian/Mayotte
    {   61, 7211,   31788,  7, }, // Indian/Reunion
    {   61, 4441,   31795,  4, }, // Pacific/Apia
    {   61, 3009,    4099,  6, }, // Pacific/Auckland
    {   61, 3725,   31799,  9, }, // Pacific/Bougainville
    {   61, 3034,   31808,  5, }, // Pacific/Chatham
    {   61, 3176,    4118,  4, }, // Pacific/Chuuk
    {   61, 2239,   31813, 17, }, // Pacific/Easter
    {   61, 7360,   31830,  5, }, // Pacific/Efate
    {   61, 7327,   31835,  7, }, // Pacific/Fakaofo
    {   61, 3921,   31842,  5, }, // Pacific/Fiji
    {   61, 7343,   31847,  8, }, // Pacific/Funafuti
    {   61, 6697,   31855,  9, }, // Pacific/Galapagos
    {   61, 6715,   31864, 14, }, // Pacific/Gambier
    {   61, 3841,    4192, 11, }, // Pacific/Guadalcanal
    {   61, 6037,    4203,  4, }, // Pacific/Guam
    {   61, 2725,   31878,  8, }, // Pacific/Honolulu
    {   61, 3068,    4207,  6, }, // Pacific/Kanton
    {   61, 4017,   31886, 10, }, // Pacific/Kiritimati
    {   61, 7038,   31896,  6, }, // Pacific/Kosrae
    {   61, 2844,   28734, 10, }, // Pacific/Kwajalein
    {   61, 4896,   31902,  7, }, // Pacific/Majuro
    {   61, 4070,   31909, 18, }, // Pacific/Marquesas
    {   61, 8945,   31927,  6, }, // Pacific/Midway
    {   61, 7103,    4277,  5, }, // Pacific/Nauru
    {   61, 7132,   31933,  4, }, // Pacific/Niue
    {   61, 4187,   31937,  7, }, // Pacific/Norfolk
    {   61, 7117,    4293,  5, }, // Pacific/Noumea
    {   61, 3145,   31944,  9, }, // Pacific/Pago_Pago
    {   61, 7155,    4307,  5, }, // Pacific/Palau
    {   61, 7194,   31953,  7, }, // Pacific/Pitcairn
    {   61, 3115,   31960,  6, }, // Pacific/Pohnpei
    {   61, 4826,   31966, 11, }, // Pacific/Port_Moresby
    {   61, 6095,   31977,  9, }, // Pacific/Rarotonga
    {   61, 6050,   28815,  6, }, // Pacific/Saipan
    {   61, 7312,   31986,  5, }, // Pacific/Tahiti
    {   61, 6731,    4356,  6, }, // Pacific/Tarawa
    {   61, 4602,   31991,  9, }, // Pacific/Tongatapu
    {   61, 7392,   28821,  4, }, // Pacific/Wake
    {   61, 7405,   32000,  5, }, // Pacific/Wallis
    {   62,   14,       0,  6, }, // Africa/Asmara Bemba/Latin/Zambia
    {   62, 5185,       6,  8, }, // Africa/El_Aaiun
    {   62, 6888,      14,  4, }, // Africa/Lome
    {   62, 5290,      18,  9, }, // Africa/Ndjamena
    {   62, 4454,      27,  8, }, // Africa/Sao_Tome
    {   62, 4573,      35,  9, }, // America/Araguaina
    {   62,  270,      44,  7, }, // America/Argentina/Cordoba
    {   62, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   62, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   62, 4271,      70,  8, }, // America/Asuncion
    {   62,  237,      78,  8, }, // America/Atikokan
    {   62, 7623,      86, 17, }, // America/Bahia_Banderas
    {   62, 7646,     103,  5, }, // America/Belem
    {   62, 4380,     108,  6, }, // America/Bogota
    {   62, 3887,     114,  6, }, // America/Cancun
    {   62, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   62, 3810,     133,  6, }, // America/Cuiaba
    {   62, 5742,     139,  7, }, // America/Curacao
    {   62, 7887,     146,  8, }, // America/Eirunepe
    {   62,  481,     154, 13, }, // America/Indiana/Knox
    {   62, 7979,     167, 16, }, // America/Indiana/Marengo
    {   62, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   62, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   62, 8056,     220, 14, }, // America/Indiana/Vevay
    {   62, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   62, 8104,     252, 16, }, // America/Indiana/Winamac
    {   62, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   62, 5951,     288, 22, }, // America/Lower_Princes
    {   62, 8171,     310,  6, }, // America/Maceio
    {   62, 2919,     316,  8, }, // America/Mazatlan
    {   62, 8238,     324,  6, }, // America/Merida
    {   62, 2951,    4381, 16, }, // America/Mexico_City
    {   62, 4410,     341, 12, }, // America/Miquelon
    {   62, 1852,     353, 19, }, // America/Noronha
    {   62, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   62, 8347,     392, 20, }, // America/North_Dakota/Center
    {   62, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   62,  393,     435,  4, }, // America/Nuuk
    {   62, 8495,     439,  8, }, // America/Santarem
    {   62, 1880,     447,  9, }, // America/Sao_Paulo
    {   62, 6918,     456, 16, }, // America/Scoresbysund
    {   62, 8526,     472, 14, }, // America/St_Barthelemy
    {   62, 2063,     486, 10, }, // America/St_Johns
    {   62, 5882,     496,  9, }, // America/St_Kitts
    {   62, 5899,     505,  9, }, // America/St_Lucia
    {   62,  855,     514, 10, }, // America/St_Thomas
    {   62, 5932,     524, 11, }, // America/St_Vincent
    {   62, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   62, 7295,     643,  5, }, // Antarctica/Syowa
    {   62, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   62, 4790,     704,  5, }, // Asia/Hovd
    {   62, 1187,     709,  9, }, // Asia/Kathmandu
    {   62,  994,     718,  7, }, // Asia/Kolkata
    {   62, 1213,     725,  5, }, // Asia/Macau
    {   62, 1161,     747,  6, }, // Asia/Urumqi
    {   62, 1237,     753,  6, }, // Asia/Yangon
    {   62, 6647,    4413,  8, }, // Atlantic/Canary
    {   62, 1397,     767,  5, }, // Atlantic/Faroe
    {   62, 6840,     773, 10, }, // Atlantic/St_Helena
    {   62, 8790,     799,  8, }, // Europe/Busingen
    {   62, 2585,     807,  8, }, // Europe/Chisinau
    {   62, 2529,     815,  4, }, // Europe/Kyiv
    {   62, 6221,     819,  6, }, // Europe/Tirane
    {   62, 5048,    4421,  7, }, // Indian/Comoro
    {   62, 7260,     896,  4, }, // Indian/Mahe
    {   62, 7211,     900,  7, }, // Indian/Reunion
    {   62, 3176,     922,  5, }, // Pacific/Chuuk
    {   62, 6697,     940,  9, }, // Pacific/Galapagos
    {   62, 3068,     957,  6, }, // Pacific/Kanton
    {   62, 7117,    1028,  6, }, // Pacific/Noumea
    {   62, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   62, 7405,    1068, 15, }, // Pacific/Wallis
    {   63,   14,       0,  6, }, // Africa/Asmara Bena/Latin/Tanzania
    {   63, 5185,       6,  8, }, // Africa/El_Aaiun
    {   63, 6888,      14,  4, }, // Africa/Lome
    {   63, 5290,      18,  9, }, // Africa/Ndjamena
    {   63, 4454,      27,  8, }, // Africa/Sao_Tome
    {   63, 4573,      35,  9, }, // America/Araguaina
    {   63,  270,      44,  7, }, // America/Argentina/Cordoba
    {   63, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   63, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   63, 4271,      70,  8, }, // America/Asuncion
    {   63,  237,      78,  8, }, // America/Atikokan
    {   63, 7623,      86, 17, }, // America/Bahia_Banderas
    {   63, 7646,     103,  5, }, // America/Belem
    {   63, 4380,     108,  6, }, // America/Bogota
    {   63, 3887,     114,  6, }, // America/Cancun
    {   63, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   63, 3810,     133,  6, }, // America/Cuiaba
    {   63, 5742,     139,  7, }, // America/Curacao
    {   63, 7887,     146,  8, }, // America/Eirunepe
    {   63,  481,     154, 13, }, // America/Indiana/Knox
    {   63, 7979,     167, 16, }, // America/Indiana/Marengo
    {   63, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   63, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   63, 8056,     220, 14, }, // America/Indiana/Vevay
    {   63, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   63, 8104,     252, 16, }, // America/Indiana/Winamac
    {   63, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   63, 5951,     288, 22, }, // America/Lower_Princes
    {   63, 8171,     310,  6, }, // America/Maceio
    {   63, 2919,     316,  8, }, // America/Mazatlan
    {   63, 8238,     324,  6, }, // America/Merida
    {   63, 2951,    4381, 16, }, // America/Mexico_City
    {   63, 4410,     341, 12, }, // America/Miquelon
    {   63, 1852,     353, 19, }, // America/Noronha
    {   63, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   63, 8347,     392, 20, }, // America/North_Dakota/Center
    {   63, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   63,  393,     435,  4, }, // America/Nuuk
    {   63, 8495,     439,  8, }, // America/Santarem
    {   63, 1880,     447,  9, }, // America/Sao_Paulo
    {   63, 6918,     456, 16, }, // America/Scoresbysund
    {   63, 8526,     472, 14, }, // America/St_Barthelemy
    {   63, 2063,     486, 10, }, // America/St_Johns
    {   63, 5882,     496,  9, }, // America/St_Kitts
    {   63, 5899,     505,  9, }, // America/St_Lucia
    {   63,  855,     514, 10, }, // America/St_Thomas
    {   63, 5932,     524, 11, }, // America/St_Vincent
    {   63, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   63, 7295,     643,  5, }, // Antarctica/Syowa
    {   63, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   63, 4790,     704,  5, }, // Asia/Hovd
    {   63, 1187,     709,  9, }, // Asia/Kathmandu
    {   63,  994,     718,  7, }, // Asia/Kolkata
    {   63, 1213,     725,  5, }, // Asia/Macau
    {   63, 1161,     747,  6, }, // Asia/Urumqi
    {   63, 1237,     753,  6, }, // Asia/Yangon
    {   63, 6647,    4413,  8, }, // Atlantic/Canary
    {   63, 1397,     767,  5, }, // Atlantic/Faroe
    {   63, 6840,     773, 10, }, // Atlantic/St_Helena
    {   63, 8790,     799,  8, }, // Europe/Busingen
    {   63, 2585,     807,  8, }, // Europe/Chisinau
    {   63, 2529,     815,  4, }, // Europe/Kyiv
    {   63, 6221,     819,  6, }, // Europe/Tirane
    {   63, 5048,    4421,  7, }, // Indian/Comoro
    {   63, 7260,     896,  4, }, // Indian/Mahe
    {   63, 7211,     900,  7, }, // Indian/Reunion
    {   63, 3176,     922,  5, }, // Pacific/Chuuk
    {   63, 6697,     940,  9, }, // Pacific/Galapagos
    {   63, 3068,     957,  6, }, // Pacific/Kanton
    {   63, 7117,    1028,  6, }, // Pacific/Noumea
    {   63, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   63, 7405,    1068, 15, }, // Pacific/Wallis
    {   64,   14,       0,  6, }, // Africa/Asmara Bhojpuri/Devanagari/India
    {   64, 5185,       6,  8, }, // Africa/El_Aaiun
    {   64, 6888,      14,  4, }, // Africa/Lome
    {   64, 5290,      18,  9, }, // Africa/Ndjamena
    {   64, 4454,      27,  8, }, // Africa/Sao_Tome
    {   64, 4573,      35,  9, }, // America/Araguaina
    {   64,  270,      44,  7, }, // America/Argentina/Cordoba
    {   64, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   64, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   64, 4271,      70,  8, }, // America/Asuncion
    {   64,  237,      78,  8, }, // America/Atikokan
    {   64, 7623,      86, 17, }, // America/Bahia_Banderas
    {   64, 7646,     103,  5, }, // America/Belem
    {   64, 4380,     108,  6, }, // America/Bogota
    {   64, 3887,     114,  6, }, // America/Cancun
    {   64, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   64, 3810,     133,  6, }, // America/Cuiaba
    {   64, 5742,     139,  7, }, // America/Curacao
    {   64, 7887,     146,  8, }, // America/Eirunepe
    {   64,  481,     154, 13, }, // America/Indiana/Knox
    {   64, 7979,     167, 16, }, // America/Indiana/Marengo
    {   64, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   64, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   64, 8056,     220, 14, }, // America/Indiana/Vevay
    {   64, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   64, 8104,     252, 16, }, // America/Indiana/Winamac
    {   64, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   64, 5951,     288, 22, }, // America/Lower_Princes
    {   64, 8171,     310,  6, }, // America/Maceio
    {   64, 2919,     316,  8, }, // America/Mazatlan
    {   64, 8238,     324,  6, }, // America/Merida
    {   64, 2951,    4381, 16, }, // America/Mexico_City
    {   64, 4410,     341, 12, }, // America/Miquelon
    {   64, 1852,     353, 19, }, // America/Noronha
    {   64, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   64, 8347,     392, 20, }, // America/North_Dakota/Center
    {   64, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   64,  393,     435,  4, }, // America/Nuuk
    {   64, 8495,     439,  8, }, // America/Santarem
    {   64, 1880,     447,  9, }, // America/Sao_Paulo
    {   64, 6918,     456, 16, }, // America/Scoresbysund
    {   64, 8526,     472, 14, }, // America/St_Barthelemy
    {   64, 2063,     486, 10, }, // America/St_Johns
    {   64, 5882,     496,  9, }, // America/St_Kitts
    {   64, 5899,     505,  9, }, // America/St_Lucia
    {   64,  855,     514, 10, }, // America/St_Thomas
    {   64, 5932,     524, 11, }, // America/St_Vincent
    {   64, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   64, 7295,     643,  5, }, // Antarctica/Syowa
    {   64, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   64, 4790,     704,  5, }, // Asia/Hovd
    {   64, 1187,     709,  9, }, // Asia/Kathmandu
    {   64,  994,     718,  7, }, // Asia/Kolkata
    {   64, 1213,     725,  5, }, // Asia/Macau
    {   64, 1161,     747,  6, }, // Asia/Urumqi
    {   64, 1237,     753,  6, }, // Asia/Yangon
    {   64, 6647,    4413,  8, }, // Atlantic/Canary
    {   64, 1397,     767,  5, }, // Atlantic/Faroe
    {   64, 6840,     773, 10, }, // Atlantic/St_Helena
    {   64, 8790,     799,  8, }, // Europe/Busingen
    {   64, 2585,     807,  8, }, // Europe/Chisinau
    {   64, 2529,     815,  4, }, // Europe/Kyiv
    {   64, 6221,     819,  6, }, // Europe/Tirane
    {   64, 5048,    4421,  7, }, // Indian/Comoro
    {   64, 7260,     896,  4, }, // Indian/Mahe
    {   64, 7211,     900,  7, }, // Indian/Reunion
    {   64, 3176,     922,  5, }, // Pacific/Chuuk
    {   64, 6697,     940,  9, }, // Pacific/Galapagos
    {   64, 3068,     957,  6, }, // Pacific/Kanton
    {   64, 7117,    1028,  6, }, // Pacific/Noumea
    {   64, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   64, 7405,    1068, 15, }, // Pacific/Wallis
    {   65,   14,       0,  6, }, // Africa/Asmara Blin/Ethiopic/Eritrea
    {   65, 5185,       6,  8, }, // Africa/El_Aaiun
    {   65, 6888,      14,  4, }, // Africa/Lome
    {   65, 5290,      18,  9, }, // Africa/Ndjamena
    {   65, 4454,      27,  8, }, // Africa/Sao_Tome
    {   65, 4573,      35,  9, }, // America/Araguaina
    {   65,  270,      44,  7, }, // America/Argentina/Cordoba
    {   65, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   65, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   65, 4271,      70,  8, }, // America/Asuncion
    {   65,  237,      78,  8, }, // America/Atikokan
    {   65, 7623,      86, 17, }, // America/Bahia_Banderas
    {   65, 7646,     103,  5, }, // America/Belem
    {   65, 4380,     108,  6, }, // America/Bogota
    {   65, 3887,     114,  6, }, // America/Cancun
    {   65, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   65, 3810,     133,  6, }, // America/Cuiaba
    {   65, 5742,     139,  7, }, // America/Curacao
    {   65, 7887,     146,  8, }, // America/Eirunepe
    {   65,  481,     154, 13, }, // America/Indiana/Knox
    {   65, 7979,     167, 16, }, // America/Indiana/Marengo
    {   65, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   65, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   65, 8056,     220, 14, }, // America/Indiana/Vevay
    {   65, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   65, 8104,     252, 16, }, // America/Indiana/Winamac
    {   65, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   65, 5951,     288, 22, }, // America/Lower_Princes
    {   65, 8171,     310,  6, }, // America/Maceio
    {   65, 2919,     316,  8, }, // America/Mazatlan
    {   65, 8238,     324,  6, }, // America/Merida
    {   65, 2951,    4381, 16, }, // America/Mexico_City
    {   65, 4410,     341, 12, }, // America/Miquelon
    {   65, 1852,     353, 19, }, // America/Noronha
    {   65, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   65, 8347,     392, 20, }, // America/North_Dakota/Center
    {   65, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   65,  393,     435,  4, }, // America/Nuuk
    {   65, 8495,     439,  8, }, // America/Santarem
    {   65, 1880,     447,  9, }, // America/Sao_Paulo
    {   65, 6918,     456, 16, }, // America/Scoresbysund
    {   65, 8526,     472, 14, }, // America/St_Barthelemy
    {   65, 2063,     486, 10, }, // America/St_Johns
    {   65, 5882,     496,  9, }, // America/St_Kitts
    {   65, 5899,     505,  9, }, // America/St_Lucia
    {   65,  855,     514, 10, }, // America/St_Thomas
    {   65, 5932,     524, 11, }, // America/St_Vincent
    {   65, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   65, 7295,     643,  5, }, // Antarctica/Syowa
    {   65, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   65, 4790,     704,  5, }, // Asia/Hovd
    {   65, 1187,     709,  9, }, // Asia/Kathmandu
    {   65,  994,     718,  7, }, // Asia/Kolkata
    {   65, 1213,     725,  5, }, // Asia/Macau
    {   65, 1161,     747,  6, }, // Asia/Urumqi
    {   65, 1237,     753,  6, }, // Asia/Yangon
    {   65, 6647,    4413,  8, }, // Atlantic/Canary
    {   65, 1397,     767,  5, }, // Atlantic/Faroe
    {   65, 6840,     773, 10, }, // Atlantic/St_Helena
    {   65, 8790,     799,  8, }, // Europe/Busingen
    {   65, 2585,     807,  8, }, // Europe/Chisinau
    {   65, 2529,     815,  4, }, // Europe/Kyiv
    {   65, 6221,     819,  6, }, // Europe/Tirane
    {   65, 5048,    4421,  7, }, // Indian/Comoro
    {   65, 7260,     896,  4, }, // Indian/Mahe
    {   65, 7211,     900,  7, }, // Indian/Reunion
    {   65, 3176,     922,  5, }, // Pacific/Chuuk
    {   65, 6697,     940,  9, }, // Pacific/Galapagos
    {   65, 3068,     957,  6, }, // Pacific/Kanton
    {   65, 7117,    1028,  6, }, // Pacific/Noumea
    {   65, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   65, 7405,    1068, 15, }, // Pacific/Wallis
    {   66, 6807,   32005,  7, }, // Africa/Abidjan Bodo/Devanagari/India
    {   66, 6779,   32012,  5, }, // Africa/Accra
    {   66, 5078,   32017, 12, }, // Africa/Addis_Ababa
    {   66, 7420,   32029,  9, }, // Africa/Algiers
    {   66,   14,   32038,  7, }, // Africa/Asmara
    {   66,   44,   32045,  6, }, // Africa/Bamako
    {   66, 5276,   32051,  6, }, // Africa/Bangui
    {   66, 6765,   32057,  6, }, // Africa/Banjul
    {   66, 7435,   32063,  7, }, // Africa/Bissau
    {   66, 4976,   32070, 10, }, // Africa/Blantyre
    {   66, 5306,   32080, 11, }, // Africa/Brazzaville
    {   66, 4941,   32091, 10, }, // Africa/Bujumbura
    {   66, 2322,   32101,  5, }, // Africa/Cairo
    {   66, 4136,   32106, 11, }, // Africa/Casablanca
    {   66, 7449,   32117,  5, }, // Africa/Ceuta
    {   66, 6792,   32122,  7, }, // Africa/Conakry
    {   66, 6859,   32129,  5, }, // Africa/Dakar
    {   66, 5149,   32134, 11, }, // Africa/Dar_es_Salaam
    {   66, 5062,   32145,  6, }, // Africa/Djibouti
    {   66, 5262,   32151,  5, }, // Africa/Douala
    {   66, 5185,   32156,  7, }, // Africa/El_Aaiun
    {   66, 6872,   32163,  8, }, // Africa/Freetown
    {   66, 4925,   32171,  7, }, // Africa/Gaborone
    {   66, 5034,   32178,  6, }, // Africa/Harare
    {   66, 4498,   32184, 11, }, // Africa/Johannesburg
    {   66, 4518,   32195,  4, }, // Africa/Juba
    {   66, 5170,   32199,  8, }, // Africa/Kampala
    {   66, 4543,   32207,  7, }, // Africa/Khartoum
    {   66, 4992,   32214,  6, }, // Africa/Kigali
    {   66, 5325,   32220,  8, }, // Africa/Kinshasa
    {   66, 4763,   32228,  5, }, // Africa/Lagos
    {   66, 5355,   32233,  9, }, // Africa/Libreville
    {   66, 6888,   32242,  3, }, // Africa/Lome
    {   66, 5230,   32245,  7, }, // Africa/Luanda
    {   66, 4958,   32252, 10, }, // Africa/Lubumbashi
    {   66, 5020,   32262,  6, }, // Africa/Lusaka
    {   66, 5341,   32268,  6, }, // Africa/Malabo
    {   66, 5006,   32274,  6, }, // Africa/Maputo
    {   66, 5216,   32280,  6, }, // Africa/Maseru
    {   66, 5201,   32286,  8, }, // Africa/Mbabane
    {   66, 5132,   32294,  7, }, // Africa/Mogadishu
    {   66, 7053,   32301,  9, }, // Africa/Monrovia
    {   66, 3872,   32310,  7, }, // Africa/Nairobi
    {   66, 5290,   32317,  8, }, // Africa/Ndjamena
    {   66, 5373,   32325,  5, }, // Africa/Niamey
    {   66, 6822,   32330,  8, }, // Africa/Nouakchott
    {   66, 6746,   32338,  7, }, // Africa/Ouagadougou
    {   66, 5244,   32345,  9, }, // Africa/Porto-Novo
    {   66, 4454,   32354,  7, }, // Africa/Sao_Tome
    {   66, 2868,   32361,  8, }, // Africa/Tripoli
    {   66, 6573,   32369,  7, }, // Africa/Tunis
    {   66, 4171,   32376,  8, }, // Africa/Windhoek
    {   66,  132,   32384,  4, }, // America/Adak
    {   66, 3365,   32388,  6, }, // America/Anchorage
    {   66, 5626,   32394,  8, }, // America/Anguilla
    {   66, 5643,   32402,  9, }, // America/Antigua
    {   66, 4573,   32411,  9, }, // America/Araguaina
    {   66,  166,   32420, 11, }, // America/Argentina/Buenos_Aires
    {   66,   91,   32431, 10, }, // America/Argentina/Catamarca
    {   66,  270,   32441,  6, }, // America/Argentina/Cordoba
    {   66,  441,   32447,  5, }, // America/Argentina/Jujuy
    {   66, 7462,   32452,  8, }, // America/Argentina/La_Rioja
    {   66,  565,   32460,  8, }, // America/Argentina/Mendoza
    {   66, 7489,   32468, 10, }, // America/Argentina/Rio_Gallegos
    {   66, 7520,   32478,  6, }, // America/Argentina/Salta
    {   66, 7544,   32484,  9, }, // America/Argentina/San_Juan
    {   66, 5599,   32493,  8, }, // America/Argentina/San_Luis
    {   66, 7571,   32501,  7, }, // America/Argentina/Tucuman
    {   66, 7597,   32508,  8, }, // America/Argentina/Ushuaia
    {   66, 5659,   32516,  5, }, // America/Aruba
    {   66, 4271,   32521,  8, }, // America/Asuncion
    {   66,  237,   32529,  7, }, // America/Atikokan
    {   66, 3698,   32536,  6, }, // America/Bahia
    {   66, 7623,   32542, 16, }, // America/Bahia_Banderas
    {   66, 5673,   32558,  9, }, // America/Barbados
    {   66, 7646,   32567,  5, }, // America/Belem
    {   66, 5426,   32572,  5, }, // America/Belize
    {   66, 7660,   32577, 14, }, // America/Blanc-Sablon
    {   66, 7681,   32591,  9, }, // America/Boa_Vista
    {   66, 4380,   32600,  5, }, // America/Bogota
    {   66, 7699,   32605,  4, }, // America/Boise
    {   66, 7713,   32609, 15, }, // America/Cambridge_Bay
    {   66, 7735,   32624, 13, }, // America/Campo_Grande
    {   66, 3887,   32637,  6, }, // America/Cancun
    {   66, 4713,   32643,  7, }, // America/Caracas
    {   66, 4364,   32650,  5, }, // America/Cayenne
    {   66, 5515,   32655,  5, }, // America/Cayman
    {   66, 2262,   32660,  6, }, // America/Chicago
    {   66, 7756,   32666,  7, }, // America/Chihuahua
    {   66, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   66, 5441,   32673, 10, }, // America/Costa_Rica
    {   66, 7814,   32683,  8, }, // America/Creston
    {   66, 3810,   32691,  6, }, // America/Cuiaba
    {   66, 5742,   32697,  7, }, // America/Curacao
    {   66, 7830,   32704, 13, }, // America/Danmarkshavn
    {   66, 7851,   32717,  6, }, // America/Dawson
    {   66, 7866,   32723, 12, }, // America/Dawson_Creek
    {   66,  805,   32735,  6, }, // America/Denver
    {   66, 3484,   32741,  8, }, // America/Detroit
    {   66, 5758,   32749,  7, }, // America/Dominica
    {   66,  893,   32756,  7, }, // America/Edmonton
    {   66, 7887,   32763,  8, }, // America/Eirunepe
    {   66, 5460,   32771, 11, }, // America/El_Salvador
    {   66, 7904,   32782, 10, }, // America/Fort_Nelson
    {   66, 7924,   32792,  9, }, // America/Fortaleza
    {   66, 7942,   32801,  9, }, // America/Glace_Bay
    {   66, 6900,   32810,  7, }, // America/Goose_Bay
    {   66, 4631,   32817, 13, }, // America/Grand_Turk
    {   66, 5789,   32830,  8, }, // America/Grenada
    {   66, 5805,   32838,  9, }, // America/Guadeloupe
    {   66, 3779,   32847, 10, }, // America/Guatemala
    {   66, 4860,   32857,  8, }, // America/Guayaquil
    {   66, 6951,   32865,  6, }, // America/Guyana
    {   66, 1941,   32871,  9, }, // America/Halifax
    {   66, 2283,   32880,  6, }, // America/Havana
    {   66, 7960,   32886, 12, }, // America/Hermosillo
    {   66,  348,   32898, 13, }, // America/Indiana/Indianapolis
    {   66,  481,   32911, 15, }, // America/Indiana/Knox
    {   66, 7979,   32926, 17, }, // America/Indiana/Marengo
    {   66, 8003,   32943, 23, }, // America/Indiana/Petersburg
    {   66, 8030,   32966, 20, }, // America/Indiana/Tell_City
    {   66, 8056,   32986, 15, }, // America/Indiana/Vevay
    {   66, 8078,   33001, 21, }, // America/Indiana/Vincennes
    {   66, 8104,   33022, 18, }, // America/Indiana/Winamac
    {   66, 8128,   33040,  6, }, // America/Inuvik
    {   66,  660,   33046,  7, }, // America/Iqaluit
    {   66, 2801,   33053,  7, }, // America/Jamaica
    {   66, 5399,   33060,  4, }, // America/Juneau
    {   66,  521,   33064,  6, }, // America/Kentucky/Louisville
    {   66, 8143,   33070, 19, }, // America/Kentucky/Monticello
    {   66, 5723,   33089, 10, }, // America/Kralendijk
    {   66, 4395,   33099,  6, }, // America/La_Paz
    {   66, 7169,   33105,  4, }, // America/Lima
    {   66, 3258,   33109, 11, }, // America/Los_Angeles
    {   66, 5951,   33120, 24, }, // America/Lower_Princes
    {   66, 8171,   33144,  6, }, // America/Maceio
    {   66, 8186,   33150,  6, }, // America/Managua
    {   66, 1910,   33156,  5, }, // America/Manaus
    {   66, 5916,   33161,  6, }, // America/Marigot
    {   66, 5824,   33167,  9, }, // America/Martinique
    {   66, 8202,   33176,  7, }, // America/Matamoros
    {   66, 2919,   33183,  8, }, // America/Mazatlan
    {   66, 8220,   33191,  8, }, // America/Menominee
    {   66, 8238,   33199,  6, }, // America/Merida
    {   66, 8253,   33205, 12, }, // America/Metlakatla
    {   66, 2951,   33217, 13, }, // America/Mexico_City
    {   66, 4410,   33230,  9, }, // America/Miquelon
    {   66, 8272,   33239,  6, }, // America/Moncton
    {   66, 8288,   33245,  9, }, // America/Monterrey
    {   66, 4117,   33254, 10, }, // America/Montevideo
    {   66, 5843,   33264,  9, }, // America/Montserrat
    {   66, 5500,   33273,  7, }, // America/Nassau
    {   66, 2381,   33280,  8, }, // America/New_York
    {   66, 8306,   33193,  3, }, // America/Nome
    {   66, 1852,   33288,  7, }, // America/Noronha
    {   66, 8319,   33295, 19, }, // America/North_Dakota/Beulah
    {   66, 8347,   33314, 20, }, // America/North_Dakota/Center
    {   66, 8375,   33334, 22, }, // America/North_Dakota/New_Salem
    {   66,  393,   33356,  3, }, // America/Nuuk
    {   66, 8406,   33359,  7, }, // America/Ojinaga
    {   66, 2358,   33366,  6, }, // America/Panama
    {   66, 6192,   33372, 10, }, // America/Paramaribo
    {   66, 2975,   33382,  7, }, // America/Phoenix
    {   66, 3964,   33389, 15, }, // America/Port-au-Prince
    {   66, 5973,   33404, 13, }, // America/Port_of_Spain
    {   66, 8422,   33417, 12, }, // America/Porto_Velho
    {   66, 5862,   33429, 12, }, // America/Puerto_Rico
    {   66, 4049,   33441, 13, }, // America/Punta_Arenas
    {   66, 8442,   33454, 12, }, // America/Rankin_Inlet
    {   66, 8463,   33466,  6, }, // America/Recife
    {   66, 1997,   33472,  6, }, // America/Regina
    {   66, 8478,   33478,  8, }, // America/Resolute
    {   66,  695,   33486, 12, }, // America/Rio_Branco
    {   66, 8495,   33498,  9, }, // America/Santarem
    {   66, 2203,   33507,  9, }, // America/Santiago
    {   66, 6130,   33516, 12, }, // America/Santo_Domingo
    {   66, 1880,   33528,  9, }, // America/Sao_Paulo
    {   66, 6918,   33537, 14, }, // America/Scoresbysund
    {   66, 8512,   33551,  6, }, // America/Sitka
    {   66, 8526,   33557, 16, }, // America/St_Barthelemy
    {   66, 2063,   33573, 10, }, // America/St_Johns
    {   66, 5882,   33583, 11, }, // America/St_Kitts
    {   66, 5899,   33594, 12, }, // America/St_Lucia
    {   66,  855,   33606, 10, }, // America/St_Thomas
    {   66, 5932,   33616, 15, }, // America/St_Vincent
    {   66, 8548,   33631, 15, }, // America/Swift_Current
    {   66, 5480,   33646, 12, }, // America/Tegucigalpa
    {   66, 5775,   33658,  5, }, // America/Thule
    {   66,  313,   33663,  7, }, // America/Tijuana
    {   66,  608,   33670,  6, }, // America/Toronto
    {   66, 5707,   33676,  7, }, // America/Tortola
    {   66, 2095,   33683,  7, }, // America/Vancouver
    {   66, 2146,   33690, 10, }, // America/Whitehorse
    {   66,  734,   33700,  7, }, // America/Winnipeg
    {   66, 8570,   33707,  7, }, // America/Yakutat
    {   66, 6020,   33714,  4, }, // Antarctica/Casey
    {   66, 6113,   33718,  5, }, // Antarctica/Davis
    {   66, 6152,   33723, 15, }, // Antarctica/DumontDUrville
    {   66, 8586,   33738,  8, }, // Antarctica/Macquarie
    {   66, 7085,   33746,  4, }, // Antarctica/Mawson
    {   66,  932,   33750,  9, }, // Antarctica/McMurdo
    {   66, 8607,   33759,  6, }, // Antarctica/Palmer
    {   66, 7226,   33765,  5, }, // Antarctica/Rothera
    {   66, 7295,   33770,  5, }, // Antarctica/Syowa
    {   66, 8625,   33775,  5, }, // Antarctica/Troll
    {   66, 7374,   33780,  6, }, // Antarctica/Vostok
    {   66, 1431,   33786, 10, }, // Arctic/Longyearbyen
    {   66, 5589,   33796,  4, }, // Asia/Aden
    {   66, 5414,   33800,  7, }, // Asia/Almaty
    {   66, 3987,   33807,  6, }, // Asia/Amman
    {   66, 5530,   33813,  6, }, // Asia/Anadyr
    {   66, 5542,   33819,  6, }, // Asia/Aqtau
    {   66, 5387,   33825,  7, }, // Asia/Aqtobe
    {   66,  966,   33832,  8, }, // Asia/Ashgabat
    {   66, 8642,   33840,  6, }, // Asia/Atyrau
    {   66, 3626,   33846,  6, }, // Asia/Baghdad
    {   66, 5553,   33852,  6, }, // Asia/Bahrain
    {   66, 3672,   32695,  4, }, // Asia/Baku
    {   66, 4485,   33858,  7, }, // Asia/Bangkok
    {   66, 3590,   33865,  7, }, // Asia/Barnaul
    {   66, 4105,   33872,  5, }, // Asia/Beirut
    {   66, 3797,   33877,  7, }, // Asia/Bishkek
    {   66, 6008,   33884,  6, }, // Asia/Brunei
    {   66, 4620,   33890,  4, }, // Asia/Chita
    {   66, 4530,   33894,  6, }, // Asia/Colombo
    {   66, 4559,   33900,  9, }, // Asia/Damascus
    {   66, 1095,   33909,  4, }, // Asia/Dhaka
    {   66, 6211,   33913,  4, }, // Asia/Dili
    {   66, 3615,   33917,  5, }, // Asia/Dubai
    {   66, 6178,   33922,  8, }, // Asia/Dushanbe
    {   66, 8654,   33930, 10, }, // Asia/Famagusta
    {   66, 8669,   33940,  4, }, // Asia/Gaza
    {   66, 4814,   33944,  7, }, // Asia/Hebron
    {   66, 1261,   33951,  6, }, // Asia/Ho_Chi_Minh
    {   66, 2706,   33957,  4, }, // Asia/Hong_Kong
    {   66, 4790,   33961,  5, }, // Asia/Hovd
    {   66, 4203,   33966, 10, }, // Asia/Irkutsk
    {   66, 7025,   33976,  8, }, // Asia/Jakarta
    {   66, 7011,   33984,  7, }, // Asia/Jayapura
    {   66, 1292,   33991,  9, }, // Asia/Jerusalem
    {   66, 3579,   34000,  5, }, // Asia/Kabul
    {   66, 4335,   34005,  8, }, // Asia/Kamchatka
    {   66, 4258,   34013,  5, }, // Asia/Karachi
    {   66, 1187,   34018,  9, }, // Asia/Kathmandu
    {   66, 8679,   34027,  8, }, // Asia/Khandyga
    {   66,  994,   34035,  6, }, // Asia/Kolkata
    {   66, 4216,   34041, 15, }, // Asia/Krasnoyarsk
    {   66, 4878,   34056, 13, }, // Asia/Kuala_Lumpur
    {   66, 5995,   34069,  6, }, // Asia/Kuching
    {   66, 5566,   34075,  5, }, // Asia/Kuwait
    {   66, 1213,   34080,  5, }, // Asia/Macau
    {   66, 4036,   34085,  7, }, // Asia/Magadan
    {   66, 1351,   34092,  9, }, // Asia/Makassar
    {   66, 7182,   34101,  5, }, // Asia/Manila
    {   66, 6939,   34106,  7, }, // Asia/Muscat
    {   66, 2556,   34113,  8, }, // Asia/Nicosia
    {   66, 8693,   34121, 14, }, // Asia/Novokuznetsk
    {   66, 4154,   34135, 12, }, // Asia/Novosibirsk
    {   66, 4248,   34147,  6, }, // Asia/Omsk
    {   66, 7145,   34153,  4, }, // Asia/Oral
    {   66, 6980,   34157,  7, }, // Asia/Phnom_Penh
    {   66, 8711,   34164,  9, }, // Asia/Pontianak
    {   66, 4233,   34173,  7, }, // Asia/Pyongyang
    {   66, 5578,   34180,  5, }, // Asia/Qatar
    {   66, 8726,   34185,  7, }, // Asia/Qostanay
    {   66, 4288,   34192,  9, }, // Asia/Qyzylorda
    {   66, 3603,   34201,  5, }, // Asia/Riyadh
    {   66, 4427,   34206,  7, }, // Asia/Sakhalin
    {   66, 7245,   34213,  8, }, // Asia/Samarkand
    {   66, 3298,   34221,  4, }, // Asia/Seoul
    {   66, 1055,   34225,  6, }, // Asia/Shanghai
    {   66, 3319,   34231,  8, }, // Asia/Singapore
    {   66, 4316,   34239, 16, }, // Asia/Srednekolymsk
    {   66, 3282,   34255,  6, }, // Asia/Taipei
    {   66, 4800,   34261,  8, }, // Asia/Tashkent
    {   66, 3934,   34269,  8, }, // Asia/Tbilisi
    {   66, 2774,   34277,  6, }, // Asia/Tehran
    {   66, 1319,   34283,  6, }, // Asia/Thimphu
    {   66, 2823,   34289,  6, }, // Asia/Tokyo
    {   66, 4591,   34295,  6, }, // Asia/Tomsk
    {   66, 1023,   34301,  9, }, // Asia/Ulaanbaatar
    {   66, 1161,   34310,  6, }, // Asia/Urumqi
    {   66, 8740,   34316,  9, }, // Asia/Ust-Nera
    {   66, 6996,   34325,  9, }, // Asia/Vientiane
    {   66, 4729,   34334, 12, }, // Asia/Vladivostok
    {   66, 4847,   34346,  9, }, // Asia/Yakutsk
    {   66, 1237,   34355,  5, }, // Asia/Yangon
    {   66, 3902,   34360, 15, }, // Asia/Yekaterinburg
    {   66, 3766,   34375,  7, }, // Asia/Yerevan
    {   66, 3682,   34382,  6, }, // Atlantic/Azores
    {   66, 5690,   34388,  8, }, // Atlantic/Bermuda
    {   66, 6647,   34396,  6, }, // Atlantic/Canary
    {   66, 3746,   34402, 10, }, // Atlantic/Cape_Verde
    {   66, 1397,   34412,  4, }, // Atlantic/Faroe
    {   66, 8754,   34416,  6, }, // Atlantic/Madeira
    {   66, 2750,   34422,  8, }, // Atlantic/Reykjavik
    {   66, 7272,   34430, 12, }, // Atlantic/South_Georgia
    {   66, 6840,   34442, 12, }, // Atlantic/St_Helena
    {   66, 6663,   34454,  7, }, // Atlantic/Stanley
    {   66, 1672,   34461,  6, }, // Australia/Adelaide
    {   66, 1637,   34467,  8, }, // Australia/Brisbane
    {   66, 1801,   34475, 11, }, // Australia/Broken_Hill
    {   66, 1585,   34486,  7, }, // Australia/Darwin
    {   66, 3656,   34493,  6, }, // Australia/Eucla
    {   66, 1518,   34499,  6, }, // Australia/Hobart
    {   66, 8771,   34505,  8, }, // Australia/Lindeman
    {   66, 1549,   34513,  9, }, // Australia/Lord_Howe
    {   66, 1729,   34522,  8, }, // Australia/Melbourne
    {   66, 1764,   34530,  5, }, // Australia/Perth
    {   66, 1465,   34535,  5, }, // Australia/Sydney
    {   66, 6460,   34540, 10, }, // Europe/Amsterdam
    {   66, 6235,   34550,  7, }, // Europe/Andorra
    {   66, 3639,   34557, 10, }, // Europe/Astrakhan
    {   66, 2302,   34567,  6, }, // Europe/Athens
    {   66, 6355,   34573,  8, }, // Europe/Belgrade
    {   66, 4776,   34581,  7, }, // Europe/Berlin
    {   66, 6507,   34588, 12, }, // Europe/Bratislava
    {   66, 2169,   34600, 11, }, // Europe/Brussels
    {   66, 3947,   34611,  9, }, // Europe/Bucharest
    {   66, 3825,   34620,  9, }, // Europe/Budapest
    {   66, 8790,   34629,  8, }, // Europe/Busingen
    {   66, 2585,   34637,  6, }, // Europe/Chisinau
    {   66, 6308,   34643,  9, }, // Europe/Copenhagen
    {   66, 2340,   34652,  6, }, // Europe/Dublin
    {   66, 6326,   34658, 11, }, // Europe/Gibraltar
    {   66, 8806,   34669,  7, }, // Europe/Guernsey
    {   66, 6631,   34676,  9, }, // Europe/Helsinki
    {   66, 8822,   34685, 11, }, // Europe/Isle_of_Man
    {   66, 1132,   34696,  9, }, // Europe/Istanbul
    {   66, 8841,   34705,  6, }, // Europe/Jersey
    {   66, 3998,   34711, 12, }, // Europe/Kaliningrad
    {   66, 8855,   34723,  5, }, // Europe/Kirov
    {   66, 2529,   34728,  3, }, // Europe/Kyiv
    {   66, 3232,   34731,  6, }, // Europe/Lisbon
    {   66, 6525,   34737, 10, }, // Europe/Ljubljana
    {   66, 2503,   34747,  5, }, // Europe/London
    {   66, 6384,   34752, 13, }, // Europe/Luxembourg
    {   66, 4911,   34765,  7, }, // Europe/Madrid
    {   66, 6416,   34772,  6, }, // Europe/Malta
    {   66, 6601,   34778,  7, }, // Europe/Mariehamn
    {   66, 3712,   34785,  7, }, // Europe/Minsk
    {   66, 6429,   34792,  5, }, // Europe/Monaco
    {   66, 3556,   34797,  5, }, // Europe/Moscow
    {   66, 6477,   34802,  5, }, // Europe/Oslo
    {   66, 4303,   34807,  5, }, // Europe/Paris
    {   66, 6443,   34812,  8, }, // Europe/Podgorica
    {   66, 6294,   34820,  5, }, // Europe/Prague
    {   66, 8868,   34825,  4, }, // Europe/Riga
    {   66, 6343,   34829,  3, }, // Europe/Rome
    {   66, 4350,   34832,  6, }, // Europe/Samara
    {   66, 6489,   34838, 10, }, // Europe/San_Marino
    {   66, 6264,   34848,  8, }, // Europe/Sarajevo
    {   66, 4470,   34856,  7, }, // Europe/Saratov
    {   66, 8880,   34863, 11, }, // Europe/Simferopol
    {   66, 6402,   34874,  8, }, // Europe/Skopje
    {   66, 6618,   34882,  5, }, // Europe/Sofia
    {   66, 6542,   34887,  8, }, // Europe/Stockholm
    {   66, 8898,   34895,  5, }, // Europe/Tallinn
    {   66, 6221,   34900,  5, }, // Europe/Tirane
    {   66, 8913,   34905, 12, }, // Europe/Ulyanovsk
    {   66, 6371,   34917,  5, }, // Europe/Vaduz
    {   66, 6586,   34922,  7, }, // Europe/Vatican
    {   66, 6250,   34929,  8, }, // Europe/Vienna
    {   66, 8930,   34937,  8, }, // Europe/Vilnius
    {   66, 4746,   34945, 10, }, // Europe/Volgograd
    {   66, 3209,   34955,  5, }, // Europe/Warsaw
    {   66, 6280,   34960,  7, }, // Europe/Zagreb
    {   66, 6559,   34967,  5, }, // Europe/Zurich
    {   66, 5097,   34972, 13, }, // Indian/Antananarivo
    {   66, 6966,   34985,  5, }, // Indian/Chagos
    {   66, 6065,   34990, 16, }, // Indian/Christmas
    {   66, 6082,   35006,  4, }, // Indian/Cocos
    {   66, 5048,   35010,  5, }, // Indian/Comoro
    {   66, 6680,   35015,  9, }, // Indian/Kerguelen
    {   66, 7260,   35024,  4, }, // Indian/Mahe
    {   66, 7069,   35028,  8, }, // Indian/Maldives
    {   66, 4088,   35036,  8, }, // Indian/Mauritius
    {   66, 5117,   35044,  8, }, // Indian/Mayotte
    {   66, 7211,   35052,  9, }, // Indian/Reunion
    {   66, 4441,   35061,  5, }, // Pacific/Apia
    {   66, 3009,   35066,  7, }, // Pacific/Auckland
    {   66, 3725,   35073,  8, }, // Pacific/Bougainville
    {   66, 3034,   35081,  5, }, // Pacific/Chatham
    {   66, 3176,   35086,  3, }, // Pacific/Chuuk
    {   66, 2239,   35089,  9, }, // Pacific/Easter
    {   66, 7360,   35098,  5, }, // Pacific/Efate
    {   66, 7327,   35103,  7, }, // Pacific/Fakaofo
    {   66, 3921,   35110,  4, }, // Pacific/Fiji
    {   66, 7343,   35114,  8, }, // Pacific/Funafuti
    {   66, 6697,   35122,  9, }, // Pacific/Galapagos
    {   66, 6715,   35131,  9, }, // Pacific/Gambier
    {   66, 3841,   35140, 12, }, // Pacific/Guadalcanal
    {   66, 6037,   35152,  5, }, // Pacific/Guam
    {   66, 2725,   35157,  6, }, // Pacific/Honolulu
    {   66, 3068,   35163,  7, }, // Pacific/Kanton
    {   66, 4017,   35170, 10, }, // Pacific/Kiritimati
    {   66, 7038,   35180,  5, }, // Pacific/Kosrae
    {   66, 2844,   35185,  9, }, // Pacific/Kwajalein
    {   66, 4896,   35194,  6, }, // Pacific/Majuro
    {   66, 4070,   35200,  9, }, // Pacific/Marquesas
    {   66, 8945,   35209,  5, }, // Pacific/Midway
    {   66, 7103,   35214,  5, }, // Pacific/Nauru
    {   66, 7132,   35219,  4, }, // Pacific/Niue
    {   66, 4187,   35223,  5, }, // Pacific/Norfolk
    {   66, 7117,   35228,  6, }, // Pacific/Noumea
    {   66, 3145,   35234,  9, }, // Pacific/Pago_Pago
    {   66, 7155,   35243,  5, }, // Pacific/Palau
    {   66, 7194,   35248,  8, }, // Pacific/Pitcairn
    {   66, 3115,   35256,  5, }, // Pacific/Pohnpei
    {   66, 4826,   35261, 11, }, // Pacific/Port_Moresby
    {   66, 6095,   35272,  8, }, // Pacific/Rarotonga
    {   66, 6050,   35280,  6, }, // Pacific/Saipan
    {   66, 7312,   35286,  6, }, // Pacific/Tahiti
    {   66, 6731,   35292,  6, }, // Pacific/Tarawa
    {   66, 4602,   35298,  8, }, // Pacific/Tongatapu
    {   66, 7392,   35306,  3, }, // Pacific/Wake
    {   66, 7405,   35309,  5, }, // Pacific/Wallis
    {   67,   14,       0,  6, }, // Africa/Asmara Bosnian/Latin/Bosnia and Herzegovina
    {   67, 2322,    5363,  5, }, // Africa/Cairo
    {   67, 4136,   35314, 10, }, // Africa/Casablanca
    {   67, 5062,   35324,  7, }, // Africa/Djibouti
    {   67, 5185,       6,  8, }, // Africa/El_Aaiun
    {   67, 4543,    7074,  6, }, // Africa/Khartoum
    {   67, 6888,      14,  4, }, // Africa/Lome
    {   67, 5132,   35331,  7, }, // Africa/Mogadishu
    {   67, 5290,      18,  9, }, // Africa/Ndjamena
    {   67, 4454,      27,  8, }, // Africa/Sao_Tome
    {   67, 5626,   35338,  7, }, // America/Anguilla
    {   67, 5643,   35345,  7, }, // America/Antigua
    {   67, 4573,      35,  9, }, // America/Araguaina
    {   67,  270,      44,  7, }, // America/Argentina/Cordoba
    {   67, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   67, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   67, 4271,      70,  8, }, // America/Asuncion
    {   67,  237,      78,  8, }, // America/Atikokan
    {   67, 7623,   22210, 14, }, // America/Bahia_Banderas
    {   67, 7646,     103,  5, }, // America/Belem
    {   67, 4380,     108,  6, }, // America/Bogota
    {   67, 3887,   35352,  6, }, // America/Cancun
    {   67, 5515,    7339,  6, }, // America/Cayman
    {   67, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   67, 5441,   35358,  9, }, // America/Costa_Rica
    {   67, 3810,     133,  6, }, // America/Cuiaba
    {   67, 5742,    7402,  7, }, // America/Curacao
    {   67, 5758,   22339,  8, }, // America/Dominica
    {   67, 7887,     146,  8, }, // America/Eirunepe
    {   67, 5460,    7459,  8, }, // America/El_Salvador
    {   67, 5805,   35367,  9, }, // America/Guadeloupe
    {   67, 3779,   35376,  9, }, // America/Guatemala
    {   67,  481,     154, 13, }, // America/Indiana/Knox
    {   67, 7979,     167, 16, }, // America/Indiana/Marengo
    {   67, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   67, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   67, 8056,     220, 14, }, // America/Indiana/Vevay
    {   67, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   67, 8104,     252, 16, }, // America/Indiana/Winamac
    {   67, 2801,   35385,  7, }, // America/Jamaica
    {   67, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   67, 5951,     288, 22, }, // America/Lower_Princes
    {   67, 8171,     310,  6, }, // America/Maceio
    {   67, 2919,     316,  8, }, // America/Mazatlan
    {   67, 8238,    7779,  6, }, // America/Merida
    {   67, 2951,    4381, 16, }, // America/Mexico_City
    {   67, 4410,     341, 12, }, // America/Miquelon
    {   67, 1852,     353, 19, }, // America/Noronha
    {   67, 8319,   35392, 23, }, // America/North_Dakota/Beulah
    {   67, 8347,   35415, 23, }, // America/North_Dakota/Center
    {   67, 8375,   35438, 26, }, // America/North_Dakota/New_Salem
    {   67,  393,     435,  4, }, // America/Nuuk
    {   67, 5862,   35464,  9, }, // America/Puerto_Rico
    {   67, 8495,     439,  8, }, // America/Santarem
    {   67, 1880,     447,  9, }, // America/Sao_Paulo
    {   67, 6918,     456, 16, }, // America/Scoresbysund
    {   67, 8526,     472, 14, }, // America/St_Barthelemy
    {   67, 2063,     486, 10, }, // America/St_Johns
    {   67, 5882,     496,  9, }, // America/St_Kitts
    {   67, 5899,     505,  9, }, // America/St_Lucia
    {   67,  855,     514, 10, }, // America/St_Thomas
    {   67, 5932,     524, 11, }, // America/St_Vincent
    {   67, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   67, 7295,     643,  5, }, // Antarctica/Syowa
    {   67, 5414,    8247,  6, }, // Asia/Almaty
    {   67, 3987,    6268,  4, }, // Asia/Amman
    {   67, 5530,    8253,  6, }, // Asia/Anadyr
    {   67, 5542,     683,  5, }, // Asia/Aqtau
    {   67, 5387,   35473,  7, }, // Asia/Aqtobe
    {   67,  966,   35480,  7, }, // Asia/Ashgabat
    {   67, 8642,   35487,  6, }, // Asia/Atyrau
    {   67, 3626,    4802,  6, }, // Asia/Baghdad
    {   67, 5553,    4808,  7, }, // Asia/Bahrain
    {   67, 4105,    8278,  6, }, // Asia/Beirut
    {   67, 3797,   35493,  6, }, // Asia/Bishkek
    {   67, 6008,   35499,  7, }, // Asia/Brunei
    {   67, 4530,    6295,  7, }, // Asia/Colombo
    {   67, 4559,    4841,  6, }, // Asia/Damascus
    {   67, 1095,    5381,  4, }, // Asia/Dhaka
    {   67, 6178,   35506,  7, }, // Asia/Dushanbe
    {   67, 1261,   35513,  9, }, // Asia/Ho_Chi_Minh
    {   67, 4790,     704,  5, }, // Asia/Hovd
    {   67, 7025,   35522,  8, }, // Asia/Jakarta
    {   67, 7011,   35530,  9, }, // Asia/Jayapura
    {   67, 1292,   35539,  9, }, // Asia/Jerusalem
    {   67, 4335,   35548,  8, }, // Asia/Kamchatka
    {   67, 4258,   35556,  6, }, // Asia/Karachi
    {   67, 1187,    6367,  8, }, // Asia/Kathmandu
    {   67, 8679,   35562,  7, }, // Asia/Khandyga
    {   67,  994,     718,  7, }, // Asia/Kolkata
    {   67, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {   67, 5995,   35569,  6, }, // Asia/Kuching
    {   67, 5566,    8378,  6, }, // Asia/Kuwait
    {   67, 1213,   35575,  5, }, // Asia/Macau
    {   67, 1351,    8389,  7, }, // Asia/Makassar
    {   67, 6939,    4966,  6, }, // Asia/Muscat
    {   67, 2556,   35580,  8, }, // Asia/Nicosia
    {   67, 8693,   35588, 12, }, // Asia/Novokuznetsk
    {   67, 6980,   23177,  8, }, // Asia/Phnom_Penh
    {   67, 4233,   35600,  9, }, // Asia/Pyongyang
    {   67, 5578,    4972,  5, }, // Asia/Qatar
    {   67, 8726,    8423,  8, }, // Asia/Qostanay
    {   67, 4288,    8431,  9, }, // Asia/Qyzylorda
    {   67, 3603,   35609,  5, }, // Asia/Riyadh
    {   67, 4427,   35614,  7, }, // Asia/Sakhalin
    {   67, 3298,    8451,  4, }, // Asia/Seoul
    {   67, 1055,   35621,  6, }, // Asia/Shanghai
    {   67, 3319,   21561,  8, }, // Asia/Singapore
    {   67, 3282,    8483,  6, }, // Asia/Taipei
    {   67, 4800,   35627,  7, }, // Asia/Tashkent
    {   67, 2774,    8495,  7, }, // Asia/Tehran
    {   67, 2823,    4996,  5, }, // Asia/Tokyo
    {   67, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {   67, 1161,   35634,  6, }, // Asia/Urumqi
    {   67, 6996,   35640, 10, }, // Asia/Vientiane
    {   67, 4847,    8526,  7, }, // Asia/Yakutsk
    {   67, 1237,    8533,  6, }, // Asia/Yangon
    {   67, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {   67, 3766,    8551,  7, }, // Asia/Yerevan
    {   67, 3682,   35650,  5, }, // Atlantic/Azores
    {   67, 6647,    5038,  6, }, // Atlantic/Canary
    {   67, 3746,   23313, 10, }, // Atlantic/Cape_Verde
    {   67, 1397,     767,  5, }, // Atlantic/Faroe
    {   67, 2750,   35655,  9, }, // Atlantic/Reykjavik
    {   67, 6840,   35664, 12, }, // Atlantic/St_Helena
    {   67, 1549,   23386,  8, }, // Australia/Lord_Howe
    {   67, 1729,    8674,  7, }, // Australia/Melbourne
    {   67, 1764,   23394,  4, }, // Australia/Perth
    {   67, 1465,    8686,  6, }, // Australia/Sydney
    {   67, 6235,   35676,  6, }, // Europe/Andorra
    {   67, 3639,   35682,  8, }, // Europe/Astrakhan
    {   67, 2302,   35690,  5, }, // Europe/Athens
    {   67, 6355,    8713,  7, }, // Europe/Belgrade
    {   67, 2169,   35695,  6, }, // Europe/Brussels
    {   67, 3947,   35701,  8, }, // Europe/Bucharest
    {   67, 3825,   35709, 10, }, // Europe/Budapest
    {   67, 8790,     799,  8, }, // Europe/Busingen
    {   67, 2585,   35719,  8, }, // Europe/Chisinau
    {   67, 6308,    5115, 10, }, // Europe/Copenhagen
    {   67, 2340,   35727,  6, }, // Europe/Dublin
    {   67, 8806,   35733,  6, }, // Europe/Guernsey
    {   67, 8822,   35739, 10, }, // Europe/Isle_of_Man
    {   67, 3998,   35749, 12, }, // Europe/Kaliningrad
    {   67, 2529,   35761,  5, }, // Europe/Kyiv
    {   67, 3232,   35766,  7, }, // Europe/Lisbon
    {   67, 6384,    8825, 10, }, // Europe/Luxembourg
    {   67, 6429,    8840,  6, }, // Europe/Monaco
    {   67, 3556,   23539,  6, }, // Europe/Moscow
    {   67, 4303,   35773,  5, }, // Europe/Paris
    {   67, 6294,    6716,  4, }, // Europe/Prague
    {   67, 6343,   35778,  3, }, // Europe/Rome
    {   67, 8880,   35781, 11, }, // Europe/Simferopol
    {   67, 6402,   35792,  7, }, // Europe/Skopje
    {   67, 6618,   35799,  6, }, // Europe/Sofia
    {   67, 6542,   35805,  8, }, // Europe/Stockholm
    {   67, 8898,    8909,  5, }, // Europe/Tallinn
    {   67, 6221,     819,  6, }, // Europe/Tirane
    {   67, 6586,    6744,  7, }, // Europe/Vatican
    {   67, 6250,   35813,  3, }, // Europe/Vienna
    {   67, 3209,   35816,  7, }, // Europe/Warsaw
    {   67, 6559,   35823,  5, }, // Europe/Zurich
    {   67, 6065,   35828, 14, }, // Indian/Christmas
    {   67, 6082,   35842, 15, }, // Indian/Cocos
    {   67, 5048,    4421,  7, }, // Indian/Comoro
    {   67, 7260,     896,  4, }, // Indian/Mahe
    {   67, 7069,   35857,  7, }, // Indian/Maldives
    {   67, 4088,   35864, 10, }, // Indian/Mauritius
    {   67, 7211,     900,  7, }, // Indian/Reunion
    {   67, 3176,     922,  5, }, // Pacific/Chuuk
    {   67, 3921,   35874,  5, }, // Pacific/Fiji
    {   67, 6697,     940,  9, }, // Pacific/Galapagos
    {   67, 2725,    5251,  8, }, // Pacific/Honolulu
    {   67, 3068,     957,  6, }, // Pacific/Kanton
    {   67, 7117,    1028,  6, }, // Pacific/Noumea
    {   67, 7194,    9099,  7, }, // Pacific/Pitcairn
    {   67, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   67, 7405,   35879,  5, }, // Pacific/Wallis
    {   68, 6807,    1083,  6, }, // Africa/Abidjan Bosnian/Cyrillic/Bosnia and Herzegovina
    {   68, 6779,   29466,  4, }, // Africa/Accra
    {   68, 5078,   35884, 10, }, // Africa/Addis_Ababa
    {   68, 7420,    1105,  5, }, // Africa/Algiers
    {   68,   14,    1110,  6, }, // Africa/Asmara
    {   68,   44,    1116,  6, }, // Africa/Bamako
    {   68, 5276,   35894,  6, }, // Africa/Bangui
    {   68, 6765,    1127,  6, }, // Africa/Banjul
    {   68, 7435,   35900,  5, }, // Africa/Bissau
    {   68, 4976,   35905,  7, }, // Africa/Blantyre
    {   68, 5306,   35912,  8, }, // Africa/Brazzaville
    {   68, 4941,   35920,  9, }, // Africa/Bujumbura
    {   68, 2322,   35929,  5, }, // Africa/Cairo
    {   68, 4136,   35934, 10, }, // Africa/Casablanca
    {   68, 7449,    1178,  5, }, // Africa/Ceuta
    {   68, 6792,    1183,  7, }, // Africa/Conakry
    {   68, 6859,    1190,  5, }, // Africa/Dakar
    {   68, 5149,    1195, 12, }, // Africa/Dar_es_Salaam
    {   68, 5062,    1207,  6, }, // Africa/Djibouti
    {   68, 5262,    1213,  5, }, // Africa/Douala
    {   68, 5185,   35944,  7, }, // Africa/El_Aaiun
    {   68, 6872,    1225,  7, }, // Africa/Freetown
    {   68, 4925,    1232,  7, }, // Africa/Gaborone
    {   68, 5034,   27194,  6, }, // Africa/Harare
    {   68, 4498,   35951, 11, }, // Africa/Johannesburg
    {   68, 4518,    1258,  4, }, // Africa/Juba
    {   68, 5170,    1262,  7, }, // Africa/Kampala
    {   68, 4543,   35962,  6, }, // Africa/Khartoum
    {   68, 4992,    1275,  6, }, // Africa/Kigali
    {   68, 5325,    1281,  7, }, // Africa/Kinshasa
    {   68, 4763,    1288,  5, }, // Africa/Lagos
    {   68, 5355,    1293,  8, }, // Africa/Libreville
    {   68, 6888,    1301,  4, }, // Africa/Lome
    {   68, 5230,    1305,  6, }, // Africa/Luanda
    {   68, 4958,   35968,  9, }, // Africa/Lubumbashi
    {   68, 5020,    1320,  6, }, // Africa/Lusaka
    {   68, 5341,    1326,  6, }, // Africa/Malabo
    {   68, 5006,   35977,  6, }, // Africa/Maputo
    {   68, 5216,    1338,  6, }, // Africa/Maseru
    {   68, 5201,    1344,  7, }, // Africa/Mbabane
    {   68, 5132,    1351,  7, }, // Africa/Mogadishu
    {   68, 7053,   35983,  9, }, // Africa/Monrovia
    {   68, 3872,   35992,  7, }, // Africa/Nairobi
    {   68, 5290,    1374,  7, }, // Africa/Ndjamena
    {   68, 5373,   35999,  7, }, // Africa/Niamey
    {   68, 6822,    1387,  7, }, // Africa/Nouakchott
    {   68, 6746,    1394,  8, }, // Africa/Ouagadougou
    {   68, 5244,   36006, 10, }, // Africa/Porto-Novo
    {   68, 4454,   36016,  8, }, // Africa/Sao_Tome
    {   68, 2868,    1420,  7, }, // Africa/Tripoli
    {   68, 6573,    1427,  5, }, // Africa/Tunis
    {   68, 4171,    1432,  7, }, // Africa/Windhoek
    {   68,  132,    1439,  4, }, // America/Adak
    {   68, 3365,   36024,  7, }, // America/Anchorage
    {   68, 5626,   36031,  7, }, // America/Anguilla
    {   68, 5643,   36038,  7, }, // America/Antigua
    {   68, 4573,   36045, 10, }, // America/Araguaina
    {   68,  166,   36055, 12, }, // America/Argentina/Buenos_Aires
    {   68,   91,    1485,  9, }, // America/Argentina/Catamarca
    {   68,  270,   36067,  7, }, // America/Argentina/Cordoba
    {   68,  441,   36074,  5, }, // America/Argentina/Jujuy
    {   68, 7462,   36079,  8, }, // America/Argentina/La_Rioja
    {   68,  565,   36087,  7, }, // America/Argentina/Mendoza
    {   68, 7489,   36094, 11, }, // America/Argentina/Rio_Gallegos
    {   68, 7520,    1532,  5, }, // America/Argentina/Salta
    {   68, 7544,   36105,  8, }, // America/Argentina/San_Juan
    {   68, 5599,   36113,  7, }, // America/Argentina/San_Luis
    {   68, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {   68, 7597,   36120,  7, }, // America/Argentina/Ushuaia
    {   68, 5659,    1566,  5, }, // America/Aruba
    {   68, 4271,   36127,  8, }, // America/Asuncion
    {   68,  237,   27318,  8, }, // America/Atikokan
    {   68, 3698,   36135,  5, }, // America/Bahia
    {   68, 7623,   36140, 14, }, // America/Bahia_Banderas
    {   68, 5673,    1610,  8, }, // America/Barbados
    {   68, 7646,   36154,  5, }, // America/Belem
    {   68, 5426,   36159,  6, }, // America/Belize
    {   68, 7660,   36165, 13, }, // America/Blanc-Sablon
    {   68, 7681,   36178,  9, }, // America/Boa_Vista
    {   68, 4380,    1649,  6, }, // America/Bogota
    {   68, 7699,   36187,  5, }, // America/Boise
    {   68, 7713,   36192, 11, }, // America/Cambridge_Bay
    {   68, 7735,   36203, 12, }, // America/Campo_Grande
    {   68, 3887,    1684,  6, }, // America/Cancun
    {   68, 4713,    1690,  7, }, // America/Caracas
    {   68, 4364,   36215,  5, }, // America/Cayenne
    {   68, 5515,   36220, 16, }, // America/Cayman
    {   68, 2262,    1726,  6, }, // America/Chicago
    {   68, 7756,   36236,  6, }, // America/Chihuahua
    {   68, 5441,   36242,  9, }, // America/Costa_Rica
    {   68, 7814,    1748,  7, }, // America/Creston
    {   68, 3810,    1755,  6, }, // America/Cuiaba
    {   68, 5742,   36251,  7, }, // America/Curacao
    {   68, 7830,   36258, 13, }, // America/Danmarkshavn
    {   68, 7851,   36271,  5, }, // America/Dawson
    {   68, 7866,   36276, 10, }, // America/Dawson_Creek
    {   68,  805,    1798,  6, }, // America/Denver
    {   68, 3484,    1804,  7, }, // America/Detroit
    {   68, 5758,    1811,  8, }, // America/Dominica
    {   68,  893,    1819,  8, }, // America/Edmonton
    {   68, 7887,    1827,  8, }, // America/Eirunepe
    {   68, 5460,    1835,  8, }, // America/El_Salvador
    {   68, 7904,    1843, 11, }, // America/Fort_Nelson
    {   68, 7924,    1854,  9, }, // America/Fortaleza
    {   68, 7942,   36286,  9, }, // America/Glace_Bay
    {   68, 6900,   36295,  7, }, // America/Goose_Bay
    {   68, 4631,   36302, 10, }, // America/Grand_Turk
    {   68, 5789,    1889,  7, }, // America/Grenada
    {   68, 5805,   36312,  9, }, // America/Guadeloupe
    {   68, 3779,    1905,  9, }, // America/Guatemala
    {   68, 4860,   36321,  8, }, // America/Guayaquil
    {   68, 6951,   36329,  5, }, // America/Guyana
    {   68, 1941,   36334,  8, }, // America/Halifax
    {   68, 2283,   36342,  6, }, // America/Havana
    {   68, 7960,   36348,  9, }, // America/Hermosillo
    {   68,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {   68,  481,   36357, 15, }, // America/Indiana/Knox
    {   68, 7979,   36372, 17, }, // America/Indiana/Marengo
    {   68, 8003,   36389, 20, }, // America/Indiana/Petersburg
    {   68, 8030,   36409, 18, }, // America/Indiana/Tell_City
    {   68, 8056,   36427, 15, }, // America/Indiana/Vevay
    {   68, 8078,   36442, 18, }, // America/Indiana/Vincennes
    {   68, 8104,   36460, 17, }, // America/Indiana/Winamac
    {   68, 8128,    2049,  6, }, // America/Inuvik
    {   68,  660,   36477,  8, }, // America/Iqaluit
    {   68, 2801,   36485,  7, }, // America/Jamaica
    {   68, 5399,   36492,  4, }, // America/Juneau
    {   68,  521,    2073,  7, }, // America/Kentucky/Louisville
    {   68, 8143,   36496, 18, }, // America/Kentucky/Monticello
    {   68, 5723,   36514, 10, }, // America/Kralendijk
    {   68, 4395,   36524,  6, }, // America/La_Paz
    {   68, 7169,    2117,  4, }, // America/Lima
    {   68, 3258,   36530, 11, }, // America/Los_Angeles
    {   68, 5951,   36541, 19, }, // America/Lower_Princes
    {   68, 8171,   36560,  6, }, // America/Maceio
    {   68, 8186,   36566,  7, }, // America/Managua
    {   68, 1910,    2163,  6, }, // America/Manaus
    {   68, 5916,    2169,  6, }, // America/Marigot
    {   68, 5824,    2175,  8, }, // America/Martinique
    {   68, 8202,    2184,  9, }, // America/Matamoros
    {   68, 2919,   36573,  8, }, // America/Mazatlan
    {   68, 8220,    2201,  8, }, // America/Menominee
    {   68, 8238,    2209,  6, }, // America/Merida
    {   68, 8253,    2215, 10, }, // America/Metlakatla
    {   68, 2951,   36581, 12, }, // America/Mexico_City
    {   68, 4410,    2231,  7, }, // America/Miquelon
    {   68, 8272,    2238,  7, }, // America/Moncton
    {   68, 8288,   36593,  8, }, // America/Monterrey
    {   68, 4117,    2254, 10, }, // America/Montevideo
    {   68, 5843,   36601,  9, }, // America/Montserrat
    {   68, 5500,   36610,  5, }, // America/Nassau
    {   68, 2381,   36615,  6, }, // America/New_York
    {   68, 8306,    2288,  3, }, // America/Nome
    {   68, 1852,   36621,  6, }, // America/Noronha
    {   68, 8319,   36627, 22, }, // America/North_Dakota/Beulah
    {   68, 8347,   36649, 22, }, // America/North_Dakota/Center
    {   68, 8375,   36671, 26, }, // America/North_Dakota/New_Salem
    {   68,  393,   30502,  3, }, // America/Nuuk
    {   68, 8406,    2373,  7, }, // America/Ojinaga
    {   68, 2358,    2380,  6, }, // America/Panama
    {   68, 6192,    2386, 10, }, // America/Paramaribo
    {   68, 2975,   36697,  6, }, // America/Phoenix
    {   68, 3964,    2402, 12, }, // America/Port-au-Prince
    {   68, 5973,   36703, 13, }, // America/Port_of_Spain
    {   68, 8422,   36716, 10, }, // America/Porto_Velho
    {   68, 5862,   36726,  9, }, // America/Puerto_Rico
    {   68, 4049,   36735, 12, }, // America/Punta_Arenas
    {   68, 8442,   36747, 12, }, // America/Rankin_Inlet
    {   68, 8463,   36759,  6, }, // America/Recife
    {   68, 1997,   27769,  6, }, // America/Regina
    {   68, 8478,   36765,  7, }, // America/Resolute
    {   68,  695,   36772, 10, }, // America/Rio_Branco
    {   68, 8495,   36782,  8, }, // America/Santarem
    {   68, 2203,   36790,  9, }, // America/Santiago
    {   68, 6130,   36799, 13, }, // America/Santo_Domingo
    {   68, 1880,   36812,  9, }, // America/Sao_Paulo
    {   68, 6918,   36821, 12, }, // America/Scoresbysund
    {   68, 8512,    2553,  5, }, // America/Sitka
    {   68, 8526,   36833, 14, }, // America/St_Barthelemy
    {   68, 2063,   36847,  7, }, // America/St_Johns
    {   68, 5882,   36854,  9, }, // America/St_Kitts
    {   68, 5899,   36863, 10, }, // America/St_Lucia
    {   68,  855,   36873,  8, }, // America/St_Thomas
    {   68, 5932,   36881, 12, }, // America/St_Vincent
    {   68, 8548,   36893, 12, }, // America/Swift_Current
    {   68, 5480,    2635, 11, }, // America/Tegucigalpa
    {   68, 5775,    2646,  4, }, // America/Thule
    {   68,  313,    2650,  7, }, // America/Tijuana
    {   68,  608,    2657,  7, }, // America/Toronto
    {   68, 5707,    2664,  7, }, // America/Tortola
    {   68, 2095,    2671,  8, }, // America/Vancouver
    {   68, 2146,   36905,  8, }, // America/Whitehorse
    {   68,  734,   36913,  7, }, // America/Winnipeg
    {   68, 8570,   36920,  7, }, // America/Yakutat
    {   68, 6020,   36927,  5, }, // Antarctica/Casey
    {   68, 6113,   36932,  6, }, // Antarctica/Davis
    {   68, 6152,   36938, 13, }, // Antarctica/DumontDUrville
    {   68, 8586,   36951,  7, }, // Antarctica/Macquarie
    {   68, 7085,   36958,  5, }, // Antarctica/Mawson
    {   68,  932,   36963,  8, }, // Antarctica/McMurdo
    {   68, 8607,    2751,  6, }, // Antarctica/Palmer
    {   68, 7226,    2757,  6, }, // Antarctica/Rothera
    {   68, 7295,   36971,  4, }, // Antarctica/Syowa
    {   68, 8625,    2768,  4, }, // Antarctica/Troll
    {   68, 7374,   27978,  6, }, // Antarctica/Vostok
    {   68, 1431,   36975, 11, }, // Arctic/Longyearbyen
    {   68, 5589,    2789,  4, }, // Asia/Aden
    {   68, 5414,   36986,  6, }, // Asia/Almaty
    {   68, 3987,   30830,  4, }, // Asia/Amman
    {   68, 5530,   36992,  6, }, // Asia/Anadyr
    {   68, 5542,    2810,  5, }, // Asia/Aqtau
    {   68, 5387,   36998,  7, }, // Asia/Aqtobe
    {   68,  966,    2821,  7, }, // Asia/Ashgabat
    {   68, 8642,   37005,  6, }, // Asia/Atyrau
    {   68, 3626,    2834,  6, }, // Asia/Baghdad
    {   68, 5553,    2840,  7, }, // Asia/Bahrain
    {   68, 3672,    2847,  4, }, // Asia/Baku
    {   68, 4485,   37011,  6, }, // Asia/Bangkok
    {   68, 3590,    2858,  7, }, // Asia/Barnaul
    {   68, 4105,   37017,  6, }, // Asia/Beirut
    {   68, 3797,    2871,  6, }, // Asia/Bishkek
    {   68, 6008,   37023,  7, }, // Asia/Brunei
    {   68, 4620,    2883,  4, }, // Asia/Chita
    {   68, 4530,    2887,  7, }, // Asia/Colombo
    {   68, 4559,    2894,  6, }, // Asia/Damascus
    {   68, 1095,    1190,  4, }, // Asia/Dhaka
    {   68, 6211,    2905,  4, }, // Asia/Dili
    {   68, 3615,    2909,  5, }, // Asia/Dubai
    {   68, 6178,    2914,  7, }, // Asia/Dushanbe
    {   68, 8654,    2921,  9, }, // Asia/Famagusta
    {   68, 8669,    2930,  4, }, // Asia/Gaza
    {   68, 4814,   37030,  6, }, // Asia/Hebron
    {   68, 1261,   37036,  9, }, // Asia/Ho_Chi_Minh
    {   68, 2706,   37045,  9, }, // Asia/Hong_Kong
    {   68, 4790,    2954,  4, }, // Asia/Hovd
    {   68, 4203,   37054,  6, }, // Asia/Irkutsk
    {   68, 7025,    2965,  7, }, // Asia/Jakarta
    {   68, 7011,   37060,  8, }, // Asia/Jayapura
    {   68, 1292,   37068,  9, }, // Asia/Jerusalem
    {   68, 3579,    2989,  5, }, // Asia/Kabul
    {   68, 4335,    3008,  8, }, // Asia/Kamchatka
    {   68, 4258,    3019,  6, }, // Asia/Karachi
    {   68, 1187,    3025,  8, }, // Asia/Kathmandu
    {   68, 8679,   37077,  7, }, // Asia/Khandyga
    {   68,  994,   37084,  7, }, // Asia/Kolkata
    {   68, 4216,   37091, 11, }, // Asia/Krasnoyarsk
    {   68, 4878,   37102, 12, }, // Asia/Kuala_Lumpur
    {   68, 5995,    3071,  6, }, // Asia/Kuching
    {   68, 5566,   37114,  6, }, // Asia/Kuwait
    {   68, 1213,   37120,  5, }, // Asia/Macau
    {   68, 4036,    3088,  7, }, // Asia/Magadan
    {   68, 1351,    3095,  7, }, // Asia/Makassar
    {   68, 7182,    3102,  6, }, // Asia/Manila
    {   68, 6939,   37125,  6, }, // Asia/Muscat
    {   68, 2556,   37131,  8, }, // Asia/Nicosia
    {   68, 8693,   37139, 11, }, // Asia/Novokuznetsk
    {   68, 4154,    3132, 11, }, // Asia/Novosibirsk
    {   68, 4248,    3143,  4, }, // Asia/Omsk
    {   68, 7145,   37150,  4, }, // Asia/Oral
    {   68, 6980,   37154,  8, }, // Asia/Phnom_Penh
    {   68, 8711,    3160,  9, }, // Asia/Pontianak
    {   68, 4233,   37162,  9, }, // Asia/Pyongyang
    {   68, 5578,    3176,  5, }, // Asia/Qatar
    {   68, 8726,   37171,  8, }, // Asia/Qostanay
    {   68, 4288,   37179,  9, }, // Asia/Qyzylorda
    {   68, 3603,   37188,  5, }, // Asia/Riyadh
    {   68, 4427,    3211,  7, }, // Asia/Sakhalin
    {   68, 7245,    3218,  9, }, // Asia/Samarkand
    {   68, 3298,    3227,  4, }, // Asia/Seoul
    {   68, 1055,   37193,  6, }, // Asia/Shanghai
    {   68, 3319,    3237,  8, }, // Asia/Singapore
    {   68, 4316,   37199, 13, }, // Asia/Srednekolymsk
    {   68, 3282,   37212,  6, }, // Asia/Taipei
    {   68, 4800,    3264,  7, }, // Asia/Tashkent
    {   68, 3934,   28194,  7, }, // Asia/Tbilisi
    {   68, 2774,   37218,  7, }, // Asia/Tehran
    {   68, 1319,   37225,  5, }, // Asia/Thimphu
    {   68, 2823,    3289,  5, }, // Asia/Tokyo
    {   68, 4591,    3294,  5, }, // Asia/Tomsk
    {   68, 1023,   37230, 10, }, // Asia/Ulaanbaatar
    {   68, 1161,   37240,  7, }, // Asia/Urumqi
    {   68, 8740,    3315,  8, }, // Asia/Ust-Nera
    {   68, 6996,   37247, 10, }, // Asia/Vientiane
    {   68, 4729,    3330, 11, }, // Asia/Vladivostok
    {   68, 4847,   37257,  7, }, // Asia/Yakutsk
    {   68, 1237,   31151,  6, }, // Asia/Yangon
    {   68, 3902,   37264, 13, }, // Asia/Yekaterinburg
    {   68, 3766,   37277,  7, }, // Asia/Yerevan
    {   68, 3682,   37284,  5, }, // Atlantic/Azores
    {   68, 5690,   37289,  7, }, // Atlantic/Bermuda
    {   68, 6647,   37296, 15, }, // Atlantic/Canary
    {   68, 3746,   37311, 18, }, // Atlantic/Cape_Verde
    {   68, 1397,   37329, 13, }, // Atlantic/Faroe
    {   68, 8754,    3450,  7, }, // Atlantic/Madeira
    {   68, 2750,   37342,  9, }, // Atlantic/Reykjavik
    {   68, 7272,   37351, 13, }, // Atlantic/South_Georgia
    {   68, 6840,   37364, 10, }, // Atlantic/St_Helena
    {   68, 6663,    3508,  6, }, // Atlantic/Stanley
    {   68, 1672,    3514,  8, }, // Australia/Adelaide
    {   68, 1637,   37374,  8, }, // Australia/Brisbane
    {   68, 1801,   37382, 10, }, // Australia/Broken_Hill
    {   68, 1585,    3540,  6, }, // Australia/Darwin
    {   68, 3656,    3546,  5, }, // Australia/Eucla
    {   68, 1518,    3551,  6, }, // Australia/Hobart
    {   68, 8771,    3557,  8, }, // Australia/Lindeman
    {   68, 1549,   37392,  8, }, // Australia/Lord_Howe
    {   68, 1729,    3573,  7, }, // Australia/Melbourne
    {   68, 1764,    3580,  4, }, // Australia/Perth
    {   68, 1465,   37400,  6, }, // Australia/Sydney
    {   68, 6460,    3590,  9, }, // Europe/Amsterdam
    {   68, 6235,   31371,  6, }, // Europe/Andorra
    {   68, 3639,    3606,  8, }, // Europe/Astrakhan
    {   68, 2302,   37406,  5, }, // Europe/Athens
    {   68, 6355,   37411,  7, }, // Europe/Belgrade
    {   68, 4776,    3625,  6, }, // Europe/Berlin
    {   68, 6507,    3631, 10, }, // Europe/Bratislava
    {   68, 2169,   37418,  6, }, // Europe/Brussels
    {   68, 3947,   37424,  8, }, // Europe/Bucharest
    {   68, 3825,   37432, 10, }, // Europe/Budapest
    {   68, 8790,   37442,  8, }, // Europe/Busingen
    {   68, 2585,   37450,  7, }, // Europe/Chisinau
    {   68, 6308,   37457, 10, }, // Europe/Copenhagen
    {   68, 2340,   37467,  6, }, // Europe/Dublin
    {   68, 6326,    3711,  9, }, // Europe/Gibraltar
    {   68, 8806,   37473,  6, }, // Europe/Guernsey
    {   68, 6631,    3726,  8, }, // Europe/Helsinki
    {   68, 8822,   37479, 10, }, // Europe/Isle_of_Man
    {   68, 1132,   28429,  8, }, // Europe/Istanbul
    {   68, 8841,    3750,  5, }, // Europe/Jersey
    {   68, 3998,   37489, 11, }, // Europe/Kaliningrad
    {   68, 8855,    3766,  5, }, // Europe/Kirov
    {   68, 2529,   37500,  5, }, // Europe/Kyiv
    {   68, 3232,   37505,  7, }, // Europe/Lisbon
    {   68, 6525,   37512,  7, }, // Europe/Ljubljana
    {   68, 2503,    3792,  6, }, // Europe/London
    {   68, 6384,   37519, 10, }, // Europe/Luxembourg
    {   68, 4911,    3809,  6, }, // Europe/Madrid
    {   68, 6416,    3815,  5, }, // Europe/Malta
    {   68, 6601,   37529,  8, }, // Europe/Mariehamn
    {   68, 3712,    3829,  5, }, // Europe/Minsk
    {   68, 6429,    3834,  6, }, // Europe/Monaco
    {   68, 3556,    3840,  6, }, // Europe/Moscow
    {   68, 6477,    3846,  4, }, // Europe/Oslo
    {   68, 4303,   37537,  5, }, // Europe/Paris
    {   68, 6443,    3855,  9, }, // Europe/Podgorica
    {   68, 6294,    3864,  4, }, // Europe/Prague
    {   68, 8868,    3869,  4, }, // Europe/Riga
    {   68, 6343,    3873,  3, }, // Europe/Rome
    {   68, 4350,    3876,  6, }, // Europe/Samara
    {   68, 6489,   37542, 10, }, // Europe/San_Marino
    {   68, 6264,   37552,  8, }, // Europe/Sarajevo
    {   68, 4470,    3899,  7, }, // Europe/Saratov
    {   68, 8880,   37560, 10, }, // Europe/Simferopol
    {   68, 6402,   37570,  6, }, // Europe/Skopje
    {   68, 6618,   37576,  6, }, // Europe/Sofia
    {   68, 6542,   37582,  8, }, // Europe/Stockholm
    {   68, 8898,   37590,  5, }, // Europe/Tallinn
    {   68, 6221,    3940,  6, }, // Europe/Tirane
    {   68, 8913,   37595,  8, }, // Europe/Ulyanovsk
    {   68, 6371,   37603,  5, }, // Europe/Vaduz
    {   68, 6586,    3960,  7, }, // Europe/Vatican
    {   68, 6250,   37608,  3, }, // Europe/Vienna
    {   68, 8930,   37611,  6, }, // Europe/Vilnius
    {   68, 4746,    3978,  9, }, // Europe/Volgograd
    {   68, 3209,    3987,  7, }, // Europe/Warsaw
    {   68, 6280,    3994,  6, }, // Europe/Zagreb
    {   68, 6559,   37617,  5, }, // Europe/Zurich
    {   68, 5097,   37622, 12, }, // Indian/Antananarivo
    {   68, 6966,    4018,  5, }, // Indian/Chagos
    {   68, 6065,   37634,  5, }, // Indian/Christmas
    {   68, 6082,    4035,  5, }, // Indian/Cocos
    {   68, 5048,   37639,  6, }, // Indian/Comoro
    {   68, 6680,    4057,  8, }, // Indian/Kerguelen
    {   68, 7260,   37645,  4, }, // Indian/Mahe
    {   68, 7069,   37649,  7, }, // Indian/Maldives
    {   68, 4088,   37656, 10, }, // Indian/Mauritius
    {   68, 5117,   37666,  5, }, // Indian/Mayotte
    {   68, 7211,   37671,  7, }, // Indian/Reunion
    {   68, 4441,   37678,  5, }, // Pacific/Apia
    {   68, 3009,   37683,  6, }, // Pacific/Auckland
    {   68, 3725,    4105,  8, }, // Pacific/Bougainville
    {   68, 3034,   37689,  6, }, // Pacific/Chatham
    {   68, 3176,    4118,  4, }, // Pacific/Chuuk
    {   68, 2239,   37695, 14, }, // Pacific/Easter
    {   68, 7360,    4133,  4, }, // Pacific/Efate
    {   68, 7327,    4138,  7, }, // Pacific/Fakaofo
    {   68, 3921,    4145,  4, }, // Pacific/Fiji
    {   68, 7343,    4149,  8, }, // Pacific/Funafuti
    {   68, 6697,    4157,  9, }, // Pacific/Galapagos
    {   68, 6715,   37709,  7, }, // Pacific/Gambier
    {   68, 3841,   37716, 11, }, // Pacific/Guadalcanal
    {   68, 6037,    4203,  4, }, // Pacific/Guam
    {   68, 2725,   37727,  8, }, // Pacific/Honolulu
    {   68, 4017,    4213, 10, }, // Pacific/Kiritimati
    {   68, 7038,   37735,  5, }, // Pacific/Kosrae
    {   68, 2844,   37740, 10, }, // Pacific/Kwajalein
    {   68, 4896,   37750,  6, }, // Pacific/Majuro
    {   68, 4070,    4244,  6, }, // Pacific/Marquesas
    {   68, 8945,   37756,  6, }, // Pacific/Midway
    {   68, 7103,    4277,  5, }, // Pacific/Nauru
    {   68, 7132,    4282,  4, }, // Pacific/Niue
    {   68, 4187,    4286,  7, }, // Pacific/Norfolk
    {   68, 7117,    4293,  5, }, // Pacific/Noumea
    {   68, 3145,   37762,  9, }, // Pacific/Pago_Pago
    {   68, 7155,    4307,  5, }, // Pacific/Palau
    {   68, 7194,    4312,  7, }, // Pacific/Pitcairn
    {   68, 3115,   37771,  6, }, // Pacific/Pohnpei
    {   68, 4826,   37777, 11, }, // Pacific/Port_Moresby
    {   68, 6095,    4336,  9, }, // Pacific/Rarotonga
    {   68, 6050,   37788,  6, }, // Pacific/Saipan
    {   68, 7312,   37794,  6, }, // Pacific/Tahiti
    {   68, 6731,    4356,  6, }, // Pacific/Tarawa
    {   68, 4602,    4362,  9, }, // Pacific/Tongatapu
    {   68, 7392,   37800,  4, }, // Pacific/Wake
    {   68, 7405,   37804,  5, }, // Pacific/Wallis
    {   69, 5078,   37809, 10, }, // Africa/Addis_Ababa Breton/Latin/France
    {   69, 7420,   28849,  5, }, // Africa/Algiers
    {   69,   14,       0,  6, }, // Africa/Asmara
    {   69, 2322,   37819,  5, }, // Africa/Cairo
    {   69, 4136,   37824, 25, }, // Africa/Casablanca
    {   69, 5185,   37849,  7, }, // Africa/El_Aaiun
    {   69, 6888,      14,  4, }, // Africa/Lome
    {   69, 5132,   28885,  8, }, // Africa/Mogadishu
    {   69, 5290,   37856,  9, }, // Africa/Ndjamena
    {   69, 4454,      27,  8, }, // Africa/Sao_Tome
    {   69, 2868,   37865, 19, }, // Africa/Tripoli
    {   69, 6573,    7118,  5, }, // Africa/Tunis
    {   69, 4573,      35,  9, }, // America/Araguaina
    {   69,  270,      44,  7, }, // America/Argentina/Cordoba
    {   69, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   69, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   69, 4271,      70,  8, }, // America/Asuncion
    {   69,  237,      78,  8, }, // America/Atikokan
    {   69, 7623,      86, 17, }, // America/Bahia_Banderas
    {   69, 7646,     103,  5, }, // America/Belem
    {   69, 4380,     108,  6, }, // America/Bogota
    {   69, 3887,     114,  6, }, // America/Cancun
    {   69, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   69, 3810,     133,  6, }, // America/Cuiaba
    {   69, 5742,     139,  7, }, // America/Curacao
    {   69, 7887,     146,  8, }, // America/Eirunepe
    {   69, 5460,    7459,  8, }, // America/El_Salvador
    {   69, 5805,   37884,  9, }, // America/Guadeloupe
    {   69, 2283,   21196,  9, }, // America/Havana
    {   69,  481,     154, 13, }, // America/Indiana/Knox
    {   69, 7979,     167, 16, }, // America/Indiana/Marengo
    {   69, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   69, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   69, 8056,     220, 14, }, // America/Indiana/Vevay
    {   69, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   69, 8104,     252, 16, }, // America/Indiana/Winamac
    {   69, 2801,    4507,  7, }, // America/Jamaica
    {   69, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   69, 5951,     288, 22, }, // America/Lower_Princes
    {   69, 8171,     310,  6, }, // America/Maceio
    {   69, 5824,    5923,  8, }, // America/Martinique
    {   69, 2919,     316,  8, }, // America/Mazatlan
    {   69, 8238,     324,  6, }, // America/Merida
    {   69, 2951,   37893, 12, }, // America/Mexico_City
    {   69, 4410,    7802,  7, }, // America/Miquelon
    {   69, 1852,     353, 19, }, // America/Noronha
    {   69, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   69, 8347,     392, 20, }, // America/North_Dakota/Center
    {   69, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   69,  393,   37905, 14, }, // America/Nuuk
    {   69, 2358,   21326,  6, }, // America/Panama
    {   69, 8495,     439,  8, }, // America/Santarem
    {   69, 1880,     447,  9, }, // America/Sao_Paulo
    {   69, 6918,     456, 16, }, // America/Scoresbysund
    {   69, 8526,   37919, 12, }, // America/St_Barthelemy
    {   69, 2063,   37931, 12, }, // America/St_Johns
    {   69, 5882,   29069, 11, }, // America/St_Kitts
    {   69, 5899,   37943, 11, }, // America/St_Lucia
    {   69,  855,     514, 10, }, // America/St_Thomas
    {   69, 5932,   37954, 11, }, // America/St_Vincent
    {   69, 5775,   29116,  7, }, // America/Thule
    {   69, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   69, 7295,     643,  5, }, // Antarctica/Syowa
    {   69, 5530,   37965,  7, }, // Asia/Anadyr
    {   69, 5553,    4808,  7, }, // Asia/Bahrain
    {   69, 3672,   37972,  5, }, // Asia/Baku
    {   69, 4105,   37977,  6, }, // Asia/Beirut
    {   69, 4620,   37983,  6, }, // Asia/Chita
    {   69, 4530,   37989,  7, }, // Asia/Colombo
    {   69, 4559,    4841,  6, }, // Asia/Damascus
    {   69, 1261,   37996, 15, }, // Asia/Ho_Chi_Minh
    {   69, 4790,     704,  5, }, // Asia/Hovd
    {   69, 1292,   35539,  9, }, // Asia/Jerusalem
    {   69, 3579,   38011,  6, }, // Asia/Kabul
    {   69, 4335,   38017, 10, }, // Asia/Kamchatka
    {   69, 1187,     709,  9, }, // Asia/Kathmandu
    {   69,  994,     718,  7, }, // Asia/Kolkata
    {   69, 5566,   38027,  6, }, // Asia/Kuwait
    {   69, 1213,    8384,  5, }, // Asia/Macau
    {   69, 6939,   38033,  6, }, // Asia/Muscat
    {   69, 2556,   38039,  8, }, // Asia/Nicosia
    {   69, 6980,   38047, 10, }, // Asia/Phnom_Penh
    {   69, 3319,   38057,  9, }, // Asia/Singapore
    {   69, 4800,   38066,  8, }, // Asia/Tashkent
    {   69, 1161,     747,  6, }, // Asia/Urumqi
    {   69, 6996,   38074,  9, }, // Asia/Vientiane
    {   69, 1237,     753,  6, }, // Asia/Yangon
    {   69, 3902,   38083, 14, }, // Asia/Yekaterinburg
    {   69, 3682,   38097,  6, }, // Atlantic/Azores
    {   69, 5690,   38103,  8, }, // Atlantic/Bermuda
    {   69, 6647,   38111,  8, }, // Atlantic/Canary
    {   69, 3746,   38119,  8, }, // Atlantic/Cape_Verde
    {   69, 1397,   38127,  5, }, // Atlantic/Faroe
    {   69, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {   69, 7272,   38141, 13, }, // Atlantic/South_Georgia
    {   69, 6840,   38154, 12, }, // Atlantic/St_Helena
    {   69, 2302,    6566,  4, }, // Europe/Athens
    {   69, 6355,    8713,  7, }, // Europe/Belgrade
    {   69, 2169,   29322,  6, }, // Europe/Brussels
    {   69, 3947,   29329,  8, }, // Europe/Bucharest
    {   69, 8790,     799,  8, }, // Europe/Busingen
    {   69, 2585,     807,  8, }, // Europe/Chisinau
    {   69, 6308,    5115, 10, }, // Europe/Copenhagen
    {   69, 2340,   38166,  6, }, // Europe/Dublin
    {   69, 6326,   38172,  9, }, // Europe/Gibraltar
    {   69, 8806,   38181,  9, }, // Europe/Guernsey
    {   69, 8822,   38190,  5, }, // Europe/Isle_of_Man
    {   69, 8841,   38195,  8, }, // Europe/Jersey
    {   69, 2529,   38203,  5, }, // Europe/Kyiv
    {   69, 3232,   21790,  6, }, // Europe/Lisbon
    {   69, 2503,   38208,  7, }, // Europe/London
    {   69, 6384,   38215, 11, }, // Europe/Luxembourg
    {   69, 6601,   38226,  9, }, // Europe/Mariehamn
    {   69, 3712,   38235,  5, }, // Europe/Minsk
    {   69, 3556,   38240,  6, }, // Europe/Moscow
    {   69, 4303,   35773,  5, }, // Europe/Paris
    {   69, 6294,   38246,  5, }, // Europe/Prague
    {   69, 6343,   21843,  4, }, // Europe/Rome
    {   69, 6221,    8914,  6, }, // Europe/Tirane
    {   69, 6586,    6744,  7, }, // Europe/Vatican
    {   69, 3209,   21895,  8, }, // Europe/Warsaw
    {   69, 6082,   38251,  5, }, // Indian/Cocos
    {   69, 5048,   38256,  7, }, // Indian/Comoro
    {   69, 6680,   38263,  9, }, // Indian/Kerguelen
    {   69, 7260,     896,  4, }, // Indian/Mahe
    {   69, 7069,   38272,  8, }, // Indian/Maldives
    {   69, 4088,   38280,  5, }, // Indian/Mauritius
    {   69, 7211,   38285,  7, }, // Indian/Reunion
    {   69, 3176,     922,  5, }, // Pacific/Chuuk
    {   69, 2239,   38292,  9, }, // Pacific/Easter
    {   69, 3921,    5246,  5, }, // Pacific/Fiji
    {   69, 6697,     940,  9, }, // Pacific/Galapagos
    {   69, 2725,    5251,  8, }, // Pacific/Honolulu
    {   69, 3068,     957,  6, }, // Pacific/Kanton
    {   69, 4070,   38301, 12, }, // Pacific/Marquesas
    {   69, 8945,   38313, 12, }, // Pacific/Midway
    {   69, 7117,   38325,  6, }, // Pacific/Noumea
    {   69, 7194,   38331, 14, }, // Pacific/Pitcairn
    {   69, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   69, 7392,   38345,  9, }, // Pacific/Wake
    {   69, 7405,   38354, 16, }, // Pacific/Wallis
    {   70, 6807,   27131,  7, }, // Africa/Abidjan Bulgarian/Cyrillic/Bulgaria
    {   70, 6779,   29466,  4, }, // Africa/Accra
    {   70, 5078,   35884, 10, }, // Africa/Addis_Ababa
    {   70, 7420,    1105,  5, }, // Africa/Algiers
    {   70,   14,   29485,  6, }, // Africa/Asmara
    {   70,   44,    1116,  6, }, // Africa/Bamako
    {   70, 5276,   35894,  6, }, // Africa/Bangui
    {   70, 6765,   29496,  7, }, // Africa/Banjul
    {   70, 7435,    1133,  5, }, // Africa/Bissau
    {   70, 4976,   38370,  9, }, // Africa/Blantyre
    {   70, 5306,   35912,  8, }, // Africa/Brazzaville
    {   70, 4941,    1155,  9, }, // Africa/Bujumbura
    {   70, 2322,   38379,  5, }, // Africa/Cairo
    {   70, 4136,   35934, 10, }, // Africa/Casablanca
    {   70, 7449,    1178,  5, }, // Africa/Ceuta
    {   70, 6792,    1183,  7, }, // Africa/Conakry
    {   70, 6859,    1190,  5, }, // Africa/Dakar
    {   70, 5149,   38384, 12, }, // Africa/Dar_es_Salaam
    {   70, 5062,   27180,  7, }, // Africa/Djibouti
    {   70, 5262,    1213,  5, }, // Africa/Douala
    {   70, 5185,   38396,  6, }, // Africa/El_Aaiun
    {   70, 6872,   38402,  8, }, // Africa/Freetown
    {   70, 4925,    1232,  8, }, // Africa/Gaborone
    {   70, 5034,   27194,  6, }, // Africa/Harare
    {   70, 4498,   38410, 11, }, // Africa/Johannesburg
    {   70, 4518,   27212,  5, }, // Africa/Juba
    {   70, 5170,    1262,  7, }, // Africa/Kampala
    {   70, 4543,    1269,  6, }, // Africa/Khartoum
    {   70, 4992,    1275,  6, }, // Africa/Kigali
    {   70, 5325,    1281,  7, }, // Africa/Kinshasa
    {   70, 4763,    1288,  5, }, // Africa/Lagos
    {   70, 5355,    1293,  8, }, // Africa/Libreville
    {   70, 6888,    1301,  4, }, // Africa/Lome
    {   70, 5230,    1305,  6, }, // Africa/Luanda
    {   70, 4958,    1311,  9, }, // Africa/Lubumbashi
    {   70, 5020,    1320,  6, }, // Africa/Lusaka
    {   70, 5341,    1326,  6, }, // Africa/Malabo
    {   70, 5006,   35977,  6, }, // Africa/Maputo
    {   70, 5216,    1338,  6, }, // Africa/Maseru
    {   70, 5201,    1344,  7, }, // Africa/Mbabane
    {   70, 5132,   38421,  8, }, // Africa/Mogadishu
    {   70, 7053,   27226,  8, }, // Africa/Monrovia
    {   70, 3872,   27234,  7, }, // Africa/Nairobi
    {   70, 5290,   27241,  8, }, // Africa/Ndjamena
    {   70, 5373,   27249,  6, }, // Africa/Niamey
    {   70, 6822,    1387,  7, }, // Africa/Nouakchott
    {   70, 6746,    1394,  8, }, // Africa/Ouagadougou
    {   70, 5244,   36006, 10, }, // Africa/Porto-Novo
    {   70, 4454,   36016,  8, }, // Africa/Sao_Tome
    {   70, 2868,    1420,  7, }, // Africa/Tripoli
    {   70, 6573,    1427,  5, }, // Africa/Tunis
    {   70, 4171,    1432,  7, }, // Africa/Windhoek
    {   70,  132,    1439,  4, }, // America/Adak
    {   70, 3365,   38429,  8, }, // America/Anchorage
    {   70, 5626,   38437,  7, }, // America/Anguilla
    {   70, 5643,    1457,  7, }, // America/Antigua
    {   70, 4573,   38444,  9, }, // America/Araguaina
    {   70,  166,   38453, 12, }, // America/Argentina/Buenos_Aires
    {   70,   91,    1485,  9, }, // America/Argentina/Catamarca
    {   70,  270,   36067,  7, }, // America/Argentina/Cordoba
    {   70,  441,   38465,  5, }, // America/Argentina/Jujuy
    {   70, 7462,   36079,  8, }, // America/Argentina/La_Rioja
    {   70,  565,    1514,  7, }, // America/Argentina/Mendoza
    {   70, 7489,   38470, 11, }, // America/Argentina/Rio_Gallegos
    {   70, 7520,    1532,  5, }, // America/Argentina/Salta
    {   70, 7544,   36105,  8, }, // America/Argentina/San_Juan
    {   70, 5599,   38481,  8, }, // America/Argentina/San_Luis
    {   70, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {   70, 7597,   27305,  5, }, // America/Argentina/Ushuaia
    {   70, 5659,    1566,  5, }, // America/Aruba
    {   70, 4271,   36127,  8, }, // America/Asuncion
    {   70,  237,   27318,  8, }, // America/Atikokan
    {   70, 3698,   27326,  4, }, // America/Bahia
    {   70, 7623,   38489, 16, }, // America/Bahia_Banderas
    {   70, 5673,    1610,  8, }, // America/Barbados
    {   70, 7646,   36154,  5, }, // America/Belem
    {   70, 5426,    1623,  5, }, // America/Belize
    {   70, 7660,   27346, 11, }, // America/Blanc-Sablon
    {   70, 7681,   36178,  9, }, // America/Boa_Vista
    {   70, 4380,    1649,  6, }, // America/Bogota
    {   70, 7699,   38505,  5, }, // America/Boise
    {   70, 7713,   38510, 13, }, // America/Cambridge_Bay
    {   70, 7735,   36203, 12, }, // America/Campo_Grande
    {   70, 3887,    1684,  6, }, // America/Cancun
    {   70, 4713,    1690,  7, }, // America/Caracas
    {   70, 4364,   27375,  5, }, // America/Cayenne
    {   70, 5515,   38523, 17, }, // America/Cayman
    {   70, 2262,    1726,  6, }, // America/Chicago
    {   70, 7756,    1732,  6, }, // America/Chihuahua
    {   70, 7774,   38540, 13, }, // America/Ciudad_Juarez
    {   70, 5441,   38553, 10, }, // America/Costa_Rica
    {   70, 7796,   38563,  7, }, // America/Coyhaique
    {   70, 7814,   38570,  7, }, // America/Creston
    {   70, 3810,   38577,  5, }, // America/Cuiaba
    {   70, 5742,   27424,  7, }, // America/Curacao
    {   70, 7830,   38582, 12, }, // America/Danmarkshavn
    {   70, 7851,   38594,  6, }, // America/Dawson
    {   70, 7866,   38600, 12, }, // America/Dawson_Creek
    {   70,  805,   38612,  6, }, // America/Denver
    {   70, 3484,   27431,  7, }, // America/Detroit
    {   70, 5758,    1811,  8, }, // America/Dominica
    {   70,  893,   38618,  8, }, // America/Edmonton
    {   70, 7887,   38626,  8, }, // America/Eirunepe
    {   70, 5460,    1835,  8, }, // America/El_Salvador
    {   70, 7904,   38634, 11, }, // America/Fort_Nelson
    {   70, 7924,    1854,  9, }, // America/Fortaleza
    {   70, 7942,   38645,  9, }, // America/Glace_Bay
    {   70, 6900,   38654,  7, }, // America/Goose_Bay
    {   70, 4631,   38661, 10, }, // America/Grand_Turk
    {   70, 5789,    1889,  7, }, // America/Grenada
    {   70, 5805,    1896,  9, }, // America/Guadeloupe
    {   70, 3779,    1905,  9, }, // America/Guatemala
    {   70, 4860,   27491,  7, }, // America/Guayaquil
    {   70, 6951,   30079,  5, }, // America/Guyana
    {   70, 1941,   36334,  8, }, // America/Halifax
    {   70, 2283,   36342,  6, }, // America/Havana
    {   70, 7960,   38671,  9, }, // America/Hermosillo
    {   70,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {   70,  481,    1962,  4, }, // America/Indiana/Knox
    {   70, 7979,    1975,  7, }, // America/Indiana/Marengo
    {   70, 8003,   38680, 10, }, // America/Indiana/Petersburg
    {   70, 8030,   36409,  8, }, // America/Indiana/Tell_City
    {   70, 8056,   38690,  4, }, // America/Indiana/Vevay
    {   70, 8078,   38694,  7, }, // America/Indiana/Vincennes
    {   70, 8104,    2042,  7, }, // America/Indiana/Winamac
    {   70, 8128,    2049,  6, }, // America/Inuvik
    {   70,  660,   36477,  8, }, // America/Iqaluit
    {   70, 2801,   27570,  6, }, // America/Jamaica
    {   70, 5399,   27576,  5, }, // America/Juneau
    {   70,  521,    2073,  7, }, // America/Kentucky/Louisville
    {   70, 8143,   36496,  9, }, // America/Kentucky/Monticello
    {   70, 5723,   27581, 10, }, // America/Kralendijk
    {   70, 4395,   38701,  6, }, // America/La_Paz
    {   70, 7169,    2117,  4, }, // America/Lima
    {   70, 3258,   38707, 12, }, // America/Los_Angeles
    {   70, 5951,   38719, 20, }, // America/Lower_Princes
    {   70, 8171,   27621,  6, }, // America/Maceio
    {   70, 8186,    2156,  7, }, // America/Managua
    {   70, 1910,    2163,  6, }, // America/Manaus
    {   70, 5916,    2169,  6, }, // America/Marigot
    {   70, 5824,    2175,  9, }, // America/Martinique
    {   70, 8202,    2184,  9, }, // America/Matamoros
    {   70, 2919,    2193,  8, }, // America/Mazatlan
    {   70, 8220,    2201,  8, }, // America/Menominee
    {   70, 8238,    2209,  6, }, // America/Merida
    {   70, 8253,    2215, 10, }, // America/Metlakatla
    {   70, 2951,   36581, 12, }, // America/Mexico_City
    {   70, 4410,    2231,  7, }, // America/Miquelon
    {   70, 8272,    2238,  7, }, // America/Moncton
    {   70, 8288,   38739,  8, }, // America/Monterrey
    {   70, 4117,    2254, 10, }, // America/Montevideo
    {   70, 5843,   36601,  9, }, // America/Montserrat
    {   70, 5500,   36610,  5, }, // America/Nassau
    {   70, 2381,   38747,  7, }, // America/New_York
    {   70, 8306,   38754,  4, }, // America/Nome
    {   70, 1852,   38758,  6, }, // America/Noronha
    {   70, 8319,   38764,  4, }, // America/North_Dakota/Beulah
    {   70, 8347,   38768,  6, }, // America/North_Dakota/Center
    {   70, 8375,   38774,  9, }, // America/North_Dakota/New_Salem
    {   70,  393,    2369,  4, }, // America/Nuuk
    {   70, 8406,    2373,  7, }, // America/Ojinaga
    {   70, 2358,    2380,  6, }, // America/Panama
    {   70, 6192,    2386, 10, }, // America/Paramaribo
    {   70, 2975,    2396,  6, }, // America/Phoenix
    {   70, 3964,    2402, 12, }, // America/Port-au-Prince
    {   70, 5973,   38783, 13, }, // America/Port_of_Spain
    {   70, 8422,   38796, 11, }, // America/Porto_Velho
    {   70, 5862,   38807, 11, }, // America/Puerto_Rico
    {   70, 4049,   36735, 12, }, // America/Punta_Arenas
    {   70, 8442,   36747, 12, }, // America/Rankin_Inlet
    {   70, 8463,   36759,  6, }, // America/Recife
    {   70, 1997,   38818,  8, }, // America/Regina
    {   70, 8478,   38826,  7, }, // America/Resolute
    {   70,  695,   36772, 10, }, // America/Rio_Branco
    {   70, 8495,   36782,  8, }, // America/Santarem
    {   70, 2203,   38833,  7, }, // America/Santiago
    {   70, 6130,   36799, 13, }, // America/Santo_Domingo
    {   70, 1880,   38840,  9, }, // America/Sao_Paulo
    {   70, 6918,   38849, 10, }, // America/Scoresbysund
    {   70, 8512,    2553,  5, }, // America/Sitka
    {   70, 8526,   38859, 13, }, // America/St_Barthelemy
    {   70, 2063,   38872, 11, }, // America/St_Johns
    {   70, 5882,   38883, 10, }, // America/St_Kitts
    {   70, 5899,   38893, 11, }, // America/St_Lucia
    {   70,  855,   38904, 11, }, // America/St_Thomas
    {   70, 5932,   38915, 13, }, // America/St_Vincent
    {   70, 8548,   38928, 12, }, // America/Swift_Current
    {   70, 5480,    2635, 11, }, // America/Tegucigalpa
    {   70, 5775,    2646,  4, }, // America/Thule
    {   70,  313,    2650,  7, }, // America/Tijuana
    {   70,  608,    2657,  7, }, // America/Toronto
    {   70, 5707,    2664,  7, }, // America/Tortola
    {   70, 2095,   38940,  8, }, // America/Vancouver
    {   70, 2146,   27823,  8, }, // America/Whitehorse
    {   70,  734,   38948,  7, }, // America/Winnipeg
    {   70, 8570,   27831,  6, }, // America/Yakutat
    {   70, 6020,   27837,  5, }, // Antarctica/Casey
    {   70, 6113,   27852,  6, }, // Antarctica/Davis
    {   70, 6152,   38955, 12, }, // Antarctica/DumontDUrville
    {   70, 8586,    2728,  8, }, // Antarctica/Macquarie
    {   70, 7085,   38967,  6, }, // Antarctica/Mawson
    {   70,  932,   38973,  8, }, // Antarctica/McMurdo
    {   70, 8607,   38981,  6, }, // Antarctica/Palmer
    {   70, 7226,    2757,  6, }, // Antarctica/Rothera
    {   70, 7295,   36971,  4, }, // Antarctica/Syowa
    {   70, 8625,    2768,  4, }, // Antarctica/Troll
    {   70, 7374,   27978,  6, }, // Antarctica/Vostok
    {   70, 1431,   38987, 10, }, // Arctic/Longyearbyen
    {   70, 5589,    2789,  4, }, // Asia/Aden
    {   70, 5414,   36986,  6, }, // Asia/Almaty
    {   70, 3987,   30830,  4, }, // Asia/Amman
    {   70, 5530,   36992,  6, }, // Asia/Anadyr
    {   70, 5542,    2810,  5, }, // Asia/Aqtau
    {   70, 5387,    2815,  6, }, // Asia/Aqtobe
    {   70,  966,    2821,  7, }, // Asia/Ashgabat
    {   70, 8642,   38997,  6, }, // Asia/Atyrau
    {   70, 3626,    2834,  6, }, // Asia/Baghdad
    {   70, 5553,   39003,  7, }, // Asia/Bahrain
    {   70, 3672,    2847,  4, }, // Asia/Baku
    {   70, 4485,   37011,  6, }, // Asia/Bangkok
    {   70, 3590,    2858,  7, }, // Asia/Barnaul
    {   70, 4105,   28036,  6, }, // Asia/Beirut
    {   70, 3797,    2871,  6, }, // Asia/Bishkek
    {   70, 6008,   28048,  6, }, // Asia/Brunei
    {   70, 4620,    2883,  4, }, // Asia/Chita
    {   70, 4530,    2887,  7, }, // Asia/Colombo
    {   70, 4559,    2894,  6, }, // Asia/Damascus
    {   70, 1095,    1190,  4, }, // Asia/Dhaka
    {   70, 6211,    2905,  4, }, // Asia/Dili
    {   70, 3615,   28060,  5, }, // Asia/Dubai
    {   70, 6178,    2914,  7, }, // Asia/Dushanbe
    {   70, 8654,    2921,  9, }, // Asia/Famagusta
    {   70, 8669,    2930,  4, }, // Asia/Gaza
    {   70, 4814,   37030,  6, }, // Asia/Hebron
    {   70, 1261,    2940,  7, }, // Asia/Ho_Chi_Minh
    {   70, 2706,   39010,  7, }, // Asia/Hong_Kong
    {   70, 4790,    2954,  4, }, // Asia/Hovd
    {   70, 4203,    2958,  7, }, // Asia/Irkutsk
    {   70, 7025,   28079,  8, }, // Asia/Jakarta
    {   70, 7011,   28087,  8, }, // Asia/Jayapura
    {   70, 1292,   39017,  9, }, // Asia/Jerusalem
    {   70, 3579,    2989,  5, }, // Asia/Kabul
    {   70, 4335,    3008,  8, }, // Asia/Kamchatka
    {   70, 4258,    3019,  6, }, // Asia/Karachi
    {   70, 1187,    3025,  8, }, // Asia/Kathmandu
    {   70, 8679,   37077,  7, }, // Asia/Khandyga
    {   70,  994,   39026,  7, }, // Asia/Kolkata
    {   70, 4216,   28104, 10, }, // Asia/Krasnoyarsk
    {   70, 4878,   37102, 12, }, // Asia/Kuala_Lumpur
    {   70, 5995,    3071,  5, }, // Asia/Kuching
    {   70, 5566,   28114,  6, }, // Asia/Kuwait
    {   70, 1213,    3083,  5, }, // Asia/Macau
    {   70, 4036,    3088,  7, }, // Asia/Magadan
    {   70, 1351,    3095,  7, }, // Asia/Makassar
    {   70, 7182,    3102,  6, }, // Asia/Manila
    {   70, 6939,   37125,  6, }, // Asia/Muscat
    {   70, 2556,   39033,  7, }, // Asia/Nicosia
    {   70, 8693,    3121, 11, }, // Asia/Novokuznetsk
    {   70, 4154,    3132, 11, }, // Asia/Novosibirsk
    {   70, 4248,    3143,  4, }, // Asia/Omsk
    {   70, 7145,   39040,  4, }, // Asia/Oral
    {   70, 6980,   37154,  8, }, // Asia/Phnom_Penh
    {   70, 8711,    3160,  9, }, // Asia/Pontianak
    {   70, 4233,   39044,  6, }, // Asia/Pyongyang
    {   70, 5578,    3176,  5, }, // Asia/Qatar
    {   70, 8726,   39050,  8, }, // Asia/Qostanay
    {   70, 4288,   39058,  9, }, // Asia/Qyzylorda
    {   70, 3603,   28169,  4, }, // Asia/Riyadh
    {   70, 4427,    3211,  7, }, // Asia/Sakhalin
    {   70, 7245,    3218,  9, }, // Asia/Samarkand
    {   70, 3298,    3227,  4, }, // Asia/Seoul
    {   70, 1055,   28182,  6, }, // Asia/Shanghai
    {   70, 3319,    3237,  8, }, // Asia/Singapore
    {   70, 4316,   39067, 13, }, // Asia/Srednekolymsk
    {   70, 3282,   28188,  5, }, // Asia/Taipei
    {   70, 4800,    3264,  7, }, // Asia/Tashkent
    {   70, 3934,   28194,  7, }, // Asia/Tbilisi
    {   70, 2774,   37218,  7, }, // Asia/Tehran
    {   70, 1319,    3282,  7, }, // Asia/Thimphu
    {   70, 2823,    3289,  5, }, // Asia/Tokyo
    {   70, 4591,    3294,  5, }, // Asia/Tomsk
    {   70, 1023,   37230, 10, }, // Asia/Ulaanbaatar
    {   70, 1161,    3309,  6, }, // Asia/Urumqi
    {   70, 8740,    3315,  8, }, // Asia/Ust-Nera
    {   70, 6996,   39080,  7, }, // Asia/Vientiane
    {   70, 4729,    3330, 11, }, // Asia/Vladivostok
    {   70, 4847,   28230,  6, }, // Asia/Yakutsk
    {   70, 1237,   31151,  6, }, // Asia/Yangon
    {   70, 3902,    3354, 12, }, // Asia/Yekaterinburg
    {   70, 3766,    3366,  6, }, // Asia/Yerevan
    {   70, 3682,   39087, 15, }, // Atlantic/Azores
    {   70, 5690,   39102, 17, }, // Atlantic/Bermuda
    {   70, 6647,   39119, 16, }, // Atlantic/Canary
    {   70, 3746,   39135, 10, }, // Atlantic/Cape_Verde
    {   70, 1397,   39145, 17, }, // Atlantic/Faroe
    {   70, 8754,   28285,  7, }, // Atlantic/Madeira
    {   70, 2750,   39162,  8, }, // Atlantic/Reykjavik
    {   70, 7272,   39170, 13, }, // Atlantic/South_Georgia
    {   70, 6840,   39183, 11, }, // Atlantic/St_Helena
    {   70, 6663,    3508,  6, }, // Atlantic/Stanley
    {   70, 1672,    3514,  8, }, // Australia/Adelaide
    {   70, 1637,   39194,  8, }, // Australia/Brisbane
    {   70, 1801,   39202, 11, }, // Australia/Broken_Hill
    {   70, 1585,    3540,  6, }, // Australia/Darwin
    {   70, 3656,   28338,  4, }, // Australia/Eucla
    {   70, 1518,    3551,  6, }, // Australia/Hobart
    {   70, 8771,    3557,  8, }, // Australia/Lindeman
    {   70, 1549,   39213,  8, }, // Australia/Lord_Howe
    {   70, 1729,   39221,  7, }, // Australia/Melbourne
    {   70, 1764,   39228,  4, }, // Australia/Perth
    {   70, 1465,   39232,  5, }, // Australia/Sydney
    {   70, 6460,    3590,  9, }, // Europe/Amsterdam
    {   70, 6235,   31371,  6, }, // Europe/Andorra
    {   70, 3639,    3606,  8, }, // Europe/Astrakhan
    {   70, 2302,   37406,  5, }, // Europe/Athens
    {   70, 6355,    3618,  7, }, // Europe/Belgrade
    {   70, 4776,    3625,  6, }, // Europe/Berlin
    {   70, 6507,    3631, 10, }, // Europe/Bratislava
    {   70, 2169,   39237,  7, }, // Europe/Brussels
    {   70, 3947,   39244,  7, }, // Europe/Bucharest
    {   70, 3825,   39251,  8, }, // Europe/Budapest
    {   70, 8790,   39259,  8, }, // Europe/Busingen
    {   70, 2585,    3688,  7, }, // Europe/Chisinau
    {   70, 6308,   37457, 10, }, // Europe/Copenhagen
    {   70, 2340,   39267,  6, }, // Europe/Dublin
    {   70, 6326,    3711,  9, }, // Europe/Gibraltar
    {   70, 8806,   39273,  6, }, // Europe/Guernsey
    {   70, 6631,   39279,  8, }, // Europe/Helsinki
    {   70, 8822,   39287, 10, }, // Europe/Isle_of_Man
    {   70, 1132,   28429,  8, }, // Europe/Istanbul
    {   70, 8841,   39297,  6, }, // Europe/Jersey
    {   70, 3998,    3755, 11, }, // Europe/Kaliningrad
    {   70, 8855,    3766,  5, }, // Europe/Kirov
    {   70, 2529,    3771,  4, }, // Europe/Kyiv
    {   70, 3232,   37505,  7, }, // Europe/Lisbon
    {   70, 6525,   28443,  7, }, // Europe/Ljubljana
    {   70, 2503,    3792,  6, }, // Europe/London
    {   70, 6384,   28450, 10, }, // Europe/Luxembourg
    {   70, 4911,    3809,  6, }, // Europe/Madrid
    {   70, 6416,    3815,  5, }, // Europe/Malta
    {   70, 6601,    3820,  9, }, // Europe/Mariehamn
    {   70, 3712,    3829,  5, }, // Europe/Minsk
    {   70, 6429,    3834,  6, }, // Europe/Monaco
    {   70, 3556,    3840,  6, }, // Europe/Moscow
    {   70, 6477,    3846,  4, }, // Europe/Oslo
    {   70, 4303,    3850,  5, }, // Europe/Paris
    {   70, 6443,    3855,  9, }, // Europe/Podgorica
    {   70, 6294,    3864,  5, }, // Europe/Prague
    {   70, 8868,    3869,  4, }, // Europe/Riga
    {   70, 6343,    3873,  3, }, // Europe/Rome
    {   70, 4350,    3876,  6, }, // Europe/Samara
    {   70, 6489,   37542, 10, }, // Europe/San_Marino
    {   70, 6264,    3892,  7, }, // Europe/Sarajevo
    {   70, 4470,    3899,  7, }, // Europe/Saratov
    {   70, 8880,    3906, 10, }, // Europe/Simferopol
    {   70, 6402,   39303,  6, }, // Europe/Skopje
    {   70, 6618,   28501,  5, }, // Europe/Sofia
    {   70, 6542,   37582,  8, }, // Europe/Stockholm
    {   70, 8898,   37590,  5, }, // Europe/Tallinn
    {   70, 6221,    3940,  6, }, // Europe/Tirane
    {   70, 8913,   39309,  8, }, // Europe/Ulyanovsk
    {   70, 6371,    3955,  5, }, // Europe/Vaduz
    {   70, 6586,    3960,  7, }, // Europe/Vatican
    {   70, 6250,   39317,  5, }, // Europe/Vienna
    {   70, 8930,   39322,  6, }, // Europe/Vilnius
    {   70, 4746,    3978,  9, }, // Europe/Volgograd
    {   70, 3209,    3987,  7, }, // Europe/Warsaw
    {   70, 6280,    3994,  6, }, // Europe/Zagreb
    {   70, 6559,   28531,  5, }, // Europe/Zurich
    {   70, 5097,   37622, 12, }, // Indian/Antananarivo
    {   70, 6966,    4018,  5, }, // Indian/Chagos
    {   70, 6065,   39328,  9, }, // Indian/Christmas
    {   70, 6082,   39337, 16, }, // Indian/Cocos
    {   70, 5048,   39353, 16, }, // Indian/Comoro
    {   70, 6680,    4057,  8, }, // Indian/Kerguelen
    {   70, 7260,    4065,  3, }, // Indian/Mahe
    {   70, 7069,   37649,  7, }, // Indian/Maldives
    {   70, 4088,   39369,  8, }, // Indian/Mauritius
    {   70, 5117,   28626,  5, }, // Indian/Mayotte
    {   70, 7211,   39377,  7, }, // Indian/Reunion
    {   70, 4441,   39384,  4, }, // Pacific/Apia
    {   70, 3009,   37683,  6, }, // Pacific/Auckland
    {   70, 3725,    4105,  8, }, // Pacific/Bougainville
    {   70, 3034,   39388,  5, }, // Pacific/Chatham
    {   70, 3176,   39393,  4, }, // Pacific/Chuuk
    {   70, 2239,   39397, 18, }, // Pacific/Easter
    {   70, 7360,    4133,  5, }, // Pacific/Efate
    {   70, 7327,    4138,  7, }, // Pacific/Fakaofo
    {   70, 3921,   28681,  5, }, // Pacific/Fiji
    {   70, 7343,    4149,  8, }, // Pacific/Funafuti
    {   70, 6697,    4157,  9, }, // Pacific/Galapagos
    {   70, 6715,   39415,  6, }, // Pacific/Gambier
    {   70, 3841,    4192, 11, }, // Pacific/Guadalcanal
    {   70, 6037,    4203,  4, }, // Pacific/Guam
    {   70, 2725,   37727,  8, }, // Pacific/Honolulu
    {   70, 3068,    4207,  6, }, // Pacific/Kanton
    {   70, 4017,    4213, 10, }, // Pacific/Kiritimati
    {   70, 7038,   39421,  6, }, // Pacific/Kosrae
    {   70, 2844,   39427,  9, }, // Pacific/Kwajalein
    {   70, 4896,   28744,  7, }, // Pacific/Majuro
    {   70, 4070,   39436, 16, }, // Pacific/Marquesas
    {   70, 8945,   39452,  6, }, // Pacific/Midway
    {   70, 7103,    4277,  5, }, // Pacific/Nauru
    {   70, 7132,    4282,  4, }, // Pacific/Niue
    {   70, 4187,    4286,  7, }, // Pacific/Norfolk
    {   70, 7117,    4293,  5, }, // Pacific/Noumea
    {   70, 3145,   37762,  9, }, // Pacific/Pago_Pago
    {   70, 7155,    4307,  5, }, // Pacific/Palau
    {   70, 7194,    4312,  7, }, // Pacific/Pitcairn
    {   70, 3115,   39458,  6, }, // Pacific/Pohnpei
    {   70, 4826,   39464, 11, }, // Pacific/Port_Moresby
    {   70, 6095,    4336,  9, }, // Pacific/Rarotonga
    {   70, 6050,   28815,  6, }, // Pacific/Saipan
    {   70, 7312,    4351,  5, }, // Pacific/Tahiti
    {   70, 6731,   39475,  6, }, // Pacific/Tarawa
    {   70, 4602,    4362,  9, }, // Pacific/Tongatapu
    {   70, 7392,   39481,  4, }, // Pacific/Wake
    {   70, 7405,   39485,  5, }, // Pacific/Wallis
    {   71, 6807,   39490,  8, }, // Africa/Abidjan Burmese/Myanmar/Myanmar
    {   71, 6779,   39498,  6, }, // Africa/Accra
    {   71, 5078,   39504, 12, }, // Africa/Addis_Ababa
    {   71, 7420,   39516, 15, }, // Africa/Algiers
    {   71,   14,   39531, 10, }, // Africa/Asmara
    {   71,   44,   39541,  7, }, // Africa/Bamako
    {   71, 5276,   39548,  7, }, // Africa/Bangui
    {   71, 6765,   39555,  9, }, // Africa/Banjul
    {   71, 7435,   39564,  7, }, // Africa/Bissau
    {   71, 4976,   39571, 14, }, // Africa/Blantyre
    {   71, 5306,   39585, 11, }, // Africa/Brazzaville
    {   71, 4941,   39596, 12, }, // Africa/Bujumbura
    {   71, 2322,   39608,  8, }, // Africa/Cairo
    {   71, 4136,   39616, 10, }, // Africa/Casablanca
    {   71, 7449,   39626,  7, }, // Africa/Ceuta
    {   71, 6792,   39633,  9, }, // Africa/Conakry
    {   71, 6859,   39642,  6, }, // Africa/Dakar
    {   71, 5149,   39648, 12, }, // Africa/Dar_es_Salaam
    {   71, 5062,   39660,  7, }, // Africa/Djibouti
    {   71, 5262,   39667,  9, }, // Africa/Douala
    {   71, 5185,   39676, 12, }, // Africa/El_Aaiun
    {   71, 6872,   39688, 12, }, // Africa/Freetown
    {   71, 4925,   39700, 11, }, // Africa/Gaborone
    {   71, 5034,   39711,  9, }, // Africa/Harare
    {   71, 4498,   39720, 15, }, // Africa/Johannesburg
    {   71, 4518,   39735,  5, }, // Africa/Juba
    {   71, 5170,   39740,  7, }, // Africa/Kampala
    {   71, 4543,   39747,  8, }, // Africa/Khartoum
    {   71, 4992,   39755,  7, }, // Africa/Kigali
    {   71, 5325,   39762,  8, }, // Africa/Kinshasa
    {   71, 4763,   39770,  7, }, // Africa/Lagos
    {   71, 5355,   39777, 10, }, // Africa/Libreville
    {   71, 6888,   39787,  5, }, // Africa/Lome
    {   71, 5230,   39792,  7, }, // Africa/Luanda
    {   71, 4958,   39799, 12, }, // Africa/Lubumbashi
    {   71, 5020,   39811,  6, }, // Africa/Lusaka
    {   71, 5341,   39817,  7, }, // Africa/Malabo
    {   71, 5006,   39824,  8, }, // Africa/Maputo
    {   71, 5216,   39832,  7, }, // Africa/Maseru
    {   71, 5201,   39839,  8, }, // Africa/Mbabane
    {   71, 5132,   39847, 13, }, // Africa/Mogadishu
    {   71, 7053,   39860, 14, }, // Africa/Monrovia
    {   71, 3872,   39874, 10, }, // Africa/Nairobi
    {   71, 5290,   39884, 10, }, // Africa/Ndjamena
    {   71, 5373,   39894,  6, }, // Africa/Niamey
    {   71, 6822,   39900, 15, }, // Africa/Nouakchott
    {   71, 6746,   39915,  9, }, // Africa/Ouagadougou
    {   71, 5244,   39924, 13, }, // Africa/Porto-Novo
    {   71, 4454,   39937, 10, }, // Africa/Sao_Tome
    {   71, 2868,   39947,  8, }, // Africa/Tripoli
    {   71, 6573,   39955,  6, }, // Africa/Tunis
    {   71, 4171,   39961,  9, }, // Africa/Windhoek
    {   71,  132,   39970,  5, }, // America/Adak
    {   71, 3365,   39975, 11, }, // America/Anchorage
    {   71, 5626,   39986,  7, }, // America/Anguilla
    {   71, 5643,   39993,  8, }, // America/Antigua
    {   71, 4573,   40001, 11, }, // America/Araguaina
    {   71,  166,   40012, 13, }, // America/Argentina/Buenos_Aires
    {   71,   91,   40025,  9, }, // America/Argentina/Catamarca
    {   71,  270,   40034,  8, }, // America/Argentina/Cordoba
    {   71,  441,   40042,  6, }, // America/Argentina/Jujuy
    {   71, 7462,   40048, 10, }, // America/Argentina/La_Rioja
    {   71,  565,   40058,  8, }, // America/Argentina/Mendoza
    {   71, 7489,   40066, 15, }, // America/Argentina/Rio_Gallegos
    {   71, 7520,   40081,  6, }, // America/Argentina/Salta
    {   71, 7544,   40087,  8, }, // America/Argentina/San_Juan
    {   71, 5599,   40095, 10, }, // America/Argentina/San_Luis
    {   71, 7571,   40105,  7, }, // America/Argentina/Tucuman
    {   71, 7597,   40112,  8, }, // America/Argentina/Ushuaia
    {   71, 5659,   40120,  7, }, // America/Aruba
    {   71, 4271,   40127, 11, }, // America/Asuncion
    {   71,  237,   40138, 10, }, // America/Atikokan
    {   71, 3698,   40148,  6, }, // America/Bahia
    {   71, 7623,   40154, 16, }, // America/Bahia_Banderas
    {   71, 5673,   40170, 11, }, // America/Barbados
    {   71, 7646,   40181,  7, }, // America/Belem
    {   71, 5426,   40188,  5, }, // America/Belize
    {   71, 7660,   40193, 15, }, // America/Blanc-Sablon
    {   71, 7681,   40208, 11, }, // America/Boa_Vista
    {   71, 4380,   40219,  8, }, // America/Bogota
    {   71, 7699,   40227,  8, }, // America/Boise
    {   71, 7713,   40235, 16, }, // America/Cambridge_Bay
    {   71, 7735,   40251, 14, }, // America/Campo_Grande
    {   71, 3887,   40265,  6, }, // America/Cancun
    {   71, 4713,   40271,  8, }, // America/Caracas
    {   71, 4364,   40279,  7, }, // America/Cayenne
    {   71, 5515,   40286,  5, }, // America/Cayman
    {   71, 2262,   40291,  8, }, // America/Chicago
    {   71, 7756,   40299, 11, }, // America/Chihuahua
    {   71, 7774,   40310, 18, }, // America/Ciudad_Juarez
    {   71, 5441,   40328, 11, }, // America/Costa_Rica
    {   71, 7796,   40339, 14, }, // America/Coyhaique
    {   71, 7814,   40353,  9, }, // America/Creston
    {   71, 3810,   40362,  7, }, // America/Cuiaba
    {   71, 5742,   40369, 10, }, // America/Curacao
    {   71, 7830,   40379, 13, }, // America/Danmarkshavn
    {   71, 7851,   40392,  7, }, // America/Dawson
    {   71, 7866,   40399, 13, }, // America/Dawson_Creek
    {   71,  805,   40412,  7, }, // America/Denver
    {   71, 3484,   40419, 10, }, // America/Detroit
    {   71, 5758,   40429,  9, }, // America/Dominica
    {   71,  893,   40438, 12, }, // America/Edmonton
    {   71, 7887,   40450,  8, }, // America/Eirunepe
    {   71, 5460,   40458, 12, }, // America/El_Salvador
    {   71, 7904,   40470, 15, }, // America/Fort_Nelson
    {   71, 7924,   40485, 12, }, // America/Fortaleza
    {   71, 7942,   40497,  8, }, // America/Glace_Bay
    {   71, 6900,   40505,  8, }, // America/Goose_Bay
    {   71, 4631,   40513, 10, }, // America/Grand_Turk
    {   71, 5789,   40523,  7, }, // America/Grenada
    {   71, 5805,   40530,  9, }, // America/Guadeloupe
    {   71, 3779,   40539,  9, }, // America/Guatemala
    {   71, 4860,   40548, 11, }, // America/Guayaquil
    {   71, 6951,   40559,  9, }, // America/Guyana
    {   71, 1941,   40568,  8, }, // America/Halifax
    {   71, 2283,   40576,  6, }, // America/Havana
    {   71, 7960,   40582, 12, }, // America/Hermosillo
    {   71,  348,   40594, 19, }, // America/Indiana/Indianapolis
    {   71,  481,   40613, 22, }, // America/Indiana/Knox
    {   71, 7979,   40635, 21, }, // America/Indiana/Marengo
    {   71, 8003,   40656, 24, }, // America/Indiana/Petersburg
    {   71, 8030,   40680, 23, }, // America/Indiana/Tell_City
    {   71, 8056,   40703, 17, }, // America/Indiana/Vevay
    {   71, 8078,   40720, 22, }, // America/Indiana/Vincennes
    {   71, 8104,   40742, 22, }, // America/Indiana/Winamac
    {   71, 8128,   40764,  8, }, // America/Inuvik
    {   71,  660,   40772, 10, }, // America/Iqaluit
    {   71, 2801,   40782,  6, }, // America/Jamaica
    {   71, 5399,   40788,  9, }, // America/Juneau
    {   71,  521,   40797,  9, }, // America/Kentucky/Louisville
    {   71, 8143,   40806, 23, }, // America/Kentucky/Monticello
    {   71, 5723,   40829, 14, }, // America/Kralendijk
    {   71, 4395,   40843,  6, }, // America/La_Paz
    {   71, 7169,   40849,  4, }, // America/Lima
    {   71, 3258,   40853, 18, }, // America/Los_Angeles
    {   71, 5951,   40871, 18, }, // America/Lower_Princes
    {   71, 8171,   40889,  7, }, // America/Maceio
    {   71, 8186,   40896,  7, }, // America/Managua
    {   71, 1910,   40903,  9, }, // America/Manaus
    {   71, 5916,   40912,  8, }, // America/Marigot
    {   71, 5824,   40920,  8, }, // America/Martinique
    {   71, 8202,   40928, 12, }, // America/Matamoros
    {   71, 2919,   40940,  8, }, // America/Mazatlan
    {   71, 8220,   40948, 10, }, // America/Menominee
    {   71, 8238,   40958,  6, }, // America/Merida
    {   71, 8253,   40964, 12, }, // America/Metlakatla
    {   71, 2951,   40976, 16, }, // America/Mexico_City
    {   71, 4410,   40992,  9, }, // America/Miquelon
    {   71, 8272,   41001, 10, }, // America/Moncton
    {   71, 8288,   41011,  9, }, // America/Monterrey
    {   71, 4117,   41020, 13, }, // America/Montevideo
    {   71, 5843,   41033, 15, }, // America/Montserrat
    {   71, 5500,   41048,  7, }, // America/Nassau
    {   71, 2381,   41055,  9, }, // America/New_York
    {   71, 8306,   40950,  5, }, // America/Nome
    {   71, 1852,   41064,  8, }, // America/Noronha
    {   71, 8319,   41072, 20, }, // America/North_Dakota/Beulah
    {   71, 8347,   41092, 20, }, // America/North_Dakota/Center
    {   71, 8375,   41112, 25, }, // America/North_Dakota/New_Salem
    {   71,  393,   41137,  4, }, // America/Nuuk
    {   71, 8406,   41141,  8, }, // America/Ojinaga
    {   71, 2358,   41149,  7, }, // America/Panama
    {   71, 6192,   41156, 11, }, // America/Paramaribo
    {   71, 2975,   41167,  6, }, // America/Phoenix
    {   71, 3964,   41173, 18, }, // America/Port-au-Prince
    {   71, 5973,   41191, 19, }, // America/Port_of_Spain
    {   71, 8422,   41210, 17, }, // America/Porto_Velho
    {   71, 5862,   41227, 12, }, // America/Puerto_Rico
    {   71, 4049,   41239, 14, }, // America/Punta_Arenas
    {   71, 8442,   41253, 14, }, // America/Rankin_Inlet
    {   71, 8463,   41267,  8, }, // America/Recife
    {   71, 1997,   41275,  8, }, // America/Regina
    {   71, 8478,   41283, 13, }, // America/Resolute
    {   71,  695,   41296, 13, }, // America/Rio_Branco
    {   71, 8495,   41309,  8, }, // America/Santarem
    {   71, 2203,   41317, 10, }, // America/Santiago
    {   71, 6130,   41327, 17, }, // America/Santo_Domingo
    {   71, 1880,   41344, 10, }, // America/Sao_Paulo
    {   71, 6918,   41354, 19, }, // America/Scoresbysund
    {   71, 8512,   41373,  5, }, // America/Sitka
    {   71, 8526,   41378, 13, }, // America/St_Barthelemy
    {   71, 2063,   41391, 11, }, // America/St_Johns
    {   71, 5882,   41402,  9, }, // America/St_Kitts
    {   71, 5899,   41411, 11, }, // America/St_Lucia
    {   71,  855,   41422, 13, }, // America/St_Thomas
    {   71, 5932,   41435, 13, }, // America/St_Vincent
    {   71, 8548,   41448, 16, }, // America/Swift_Current
    {   71, 5480,   41464, 11, }, // America/Tegucigalpa
    {   71, 5775,   41475,  4, }, // America/Thule
    {   71,  313,   41479,  7, }, // America/Tijuana
    {   71,  608,   41486,  9, }, // America/Toronto
    {   71, 5707,   41495,  8, }, // America/Tortola
    {   71, 2095,   41503,  9, }, // America/Vancouver
    {   71, 2146,   41512, 14, }, // America/Whitehorse
    {   71,  734,   41526,  9, }, // America/Winnipeg
    {   71, 8570,   41535,  7, }, // America/Yakutat
    {   71, 6020,   41542,  4, }, // Antarctica/Casey
    {   71, 6113,   41546,  6, }, // Antarctica/Davis
    {   71, 6152,   41552, 19, }, // Antarctica/DumontDUrville
    {   71, 8586,   41571,  9, }, // Antarctica/Macquarie
    {   71, 7085,   41580,  8, }, // Antarctica/Mawson
    {   71,  932,   41588,  9, }, // Antarctica/McMurdo
    {   71, 8607,   41597,  6, }, // Antarctica/Palmer
    {   71, 7226,   41603,  7, }, // Antarctica/Rothera
    {   71, 7295,   41610,  7, }, // Antarctica/Syowa
    {   71, 8625,   41617,  6, }, // Antarctica/Troll
    {   71, 7374,   41623, 10, }, // Antarctica/Vostok
    {   71, 1431,   41633, 13, }, // Arctic/Longyearbyen
    {   71, 5589,   41646,  5, }, // Asia/Aden
    {   71, 5414,   41651,  8, }, // Asia/Almaty
    {   71, 3987,   41659,  7, }, // Asia/Amman
    {   71, 5530,   41666,  9, }, // Asia/Anadyr
    {   71, 5542,   41675,  7, }, // Asia/Aqtau
    {   71, 5387,   41682,  9, }, // Asia/Aqtobe
    {   71,  966,   41691, 11, }, // Asia/Ashgabat
    {   71, 8642,   41702,  7, }, // Asia/Atyrau
    {   71, 3626,   41709,  7, }, // Asia/Baghdad
    {   71, 5553,   41716,  7, }, // Asia/Bahrain
    {   71, 3672,   41723,  4, }, // Asia/Baku
    {   71, 4485,   41727,  8, }, // Asia/Bangkok
    {   71, 3590,   41735,  7, }, // Asia/Barnaul
    {   71, 4105,   41742,  6, }, // Asia/Beirut
    {   71, 3797,   41748,  8, }, // Asia/Bishkek
    {   71, 6008,   41756,  9, }, // Asia/Brunei
    {   71, 4620,   41765,  5, }, // Asia/Chita
    {   71, 4530,   41770,  8, }, // Asia/Colombo
    {   71, 4559,   41778,  8, }, // Asia/Damascus
    {   71, 1095,   41786,  5, }, // Asia/Dhaka
    {   71, 6211,   41791,  5, }, // Asia/Dili
    {   71, 3615,   41796,  8, }, // Asia/Dubai
    {   71, 6178,   41804,  9, }, // Asia/Dushanbe
    {   71, 8654,   41813,  9, }, // Asia/Famagusta
    {   71, 8669,   41822,  4, }, // Asia/Gaza
    {   71, 4814,   41826,  7, }, // Asia/Hebron
    {   71, 1261,   41833, 16, }, // Asia/Ho_Chi_Minh
    {   71, 2706,   41849, 10, }, // Asia/Hong_Kong
    {   71, 4790,   41859,  6, }, // Asia/Hovd
    {   71, 4203,   41865,  8, }, // Asia/Irkutsk
    {   71, 7025,   41873,  6, }, // Asia/Jakarta
    {   71, 7011,   41879,  9, }, // Asia/Jayapura
    {   71, 1292,   41888,  9, }, // Asia/Jerusalem
    {   71, 3579,   41897,  7, }, // Asia/Kabul
    {   71, 4335,   41904,  9, }, // Asia/Kamchatka
    {   71, 4258,   41913,  6, }, // Asia/Karachi
    {   71, 1187,   41919,  9, }, // Asia/Kathmandu
    {   71, 8679,   41928, 10, }, // Asia/Khandyga
    {   71,  994,   41938, 11, }, // Asia/Kolkata
    {   71, 4216,   41949, 13, }, // Asia/Krasnoyarsk
    {   71, 4878,   41962, 10, }, // Asia/Kuala_Lumpur
    {   71, 5995,   41972,  6, }, // Asia/Kuching
    {   71, 5566,   41978,  6, }, // Asia/Kuwait
    {   71, 1213,   41984,  6, }, // Asia/Macau
    {   71, 4036,   41990,  8, }, // Asia/Magadan
    {   71, 1351,   41998,  8, }, // Asia/Makassar
    {   71, 7182,   42006,  5, }, // Asia/Manila
    {   71, 6939,   42011, 10, }, // Asia/Muscat
    {   71, 2556,   42021,  9, }, // Asia/Nicosia
    {   71, 8693,   42030, 15, }, // Asia/Novokuznetsk
    {   71, 4154,   42045, 16, }, // Asia/Novosibirsk
    {   71, 4248,   42061,  9, }, // Asia/Omsk
    {   71, 7145,   42070,  8, }, // Asia/Oral
    {   71, 6980,   42078,  8, }, // Asia/Phnom_Penh
    {   71, 8711,   42086, 14, }, // Asia/Pontianak
    {   71, 4233,   42100,  8, }, // Asia/Pyongyang
    {   71, 5578,   40025,  4, }, // Asia/Qatar
    {   71, 8726,   42108,  9, }, // Asia/Qostanay
    {   71, 4288,   42117,  9, }, // Asia/Qyzylorda
    {   71, 3603,   42126,  7, }, // Asia/Riyadh
    {   71, 4427,   42133,  7, }, // Asia/Sakhalin
    {   71, 7245,   42140, 12, }, // Asia/Samarkand
    {   71, 3298,   42152,  6, }, // Asia/Seoul
    {   71, 1055,   42158, 10, }, // Asia/Shanghai
    {   71, 3319,   42168,  8, }, // Asia/Singapore
    {   71, 4316,   42176, 16, }, // Asia/Srednekolymsk
    {   71, 3282,   42192,  7, }, // Asia/Taipei
    {   71, 4800,   42199, 10, }, // Asia/Tashkent
    {   71, 3934,   42209,  8, }, // Asia/Tbilisi
    {   71, 2774,   42217,  7, }, // Asia/Tehran
    {   71, 1319,   42224,  6, }, // Asia/Thimphu
    {   71, 2823,   42230,  7, }, // Asia/Tokyo
    {   71, 4591,   42237, 10, }, // Asia/Tomsk
    {   71, 1023,   42247,  9, }, // Asia/Ulaanbaatar
    {   71, 1161,   42256,  9, }, // Asia/Urumqi
    {   71, 8740,   42265, 11, }, // Asia/Ust-Nera
    {   71, 6996,   42276, 10, }, // Asia/Vientiane
    {   71, 4729,   42286, 16, }, // Asia/Vladivostok
    {   71, 4847,   42302,  9, }, // Asia/Yakutsk
    {   71, 1237,   42311,  7, }, // Asia/Yangon
    {   71, 3902,   42318, 16, }, // Asia/Yekaterinburg
    {   71, 3766,   42334, 10, }, // Asia/Yerevan
    {   71, 3682,   42344, 11, }, // Atlantic/Azores
    {   71, 5690,   42355,  7, }, // Atlantic/Bermuda
    {   71, 6647,   42362,  5, }, // Atlantic/Canary
    {   71, 3746,   42367, 11, }, // Atlantic/Cape_Verde
    {   71, 1397,   42378,  5, }, // Atlantic/Faroe
    {   71, 8754,   42383,  6, }, // Atlantic/Madeira
    {   71, 2750,   42389, 10, }, // Atlantic/Reykjavik
    {   71, 7272,   42399, 15, }, // Atlantic/South_Georgia
    {   71, 6840,   42414, 13, }, // Atlantic/St_Helena
    {   71, 6663,   42427,  6, }, // Atlantic/Stanley
    {   71, 1672,   42433, 11, }, // Australia/Adelaide
    {   71, 1637,   42444, 10, }, // Australia/Brisbane
    {   71, 1801,   42454, 12, }, // Australia/Broken_Hill
    {   71, 1585,   42466,  5, }, // Australia/Darwin
    {   71, 3656,   42471,  6, }, // Australia/Eucla
    {   71, 1518,   42477,  9, }, // Australia/Hobart
    {   71, 8771,   42486, 10, }, // Australia/Lindeman
    {   71, 1549,   42496, 12, }, // Australia/Lord_Howe
    {   71, 1729,   42508,  9, }, // Australia/Melbourne
    {   71, 1764,   42517,  5, }, // Australia/Perth
    {   71, 1465,   42522,  6, }, // Australia/Sydney
    {   71, 6460,   42528,  9, }, // Europe/Amsterdam
    {   71, 6235,   42537,  8, }, // Europe/Andorra
    {   71, 3639,   42545, 11, }, // Europe/Astrakhan
    {   71, 2302,   42556,  5, }, // Europe/Athens
    {   71, 6355,   42561,  9, }, // Europe/Belgrade
    {   71, 4776,   42570,  5, }, // Europe/Berlin
    {   71, 6507,   42575, 13, }, // Europe/Bratislava
    {   71, 2169,   42588,  8, }, // Europe/Brussels
    {   71, 3947,   42596,  9, }, // Europe/Bucharest
    {   71, 3825,   42605,  9, }, // Europe/Budapest
    {   71, 8790,   42614, 10, }, // Europe/Busingen
    {   71, 2585,   42624, 11, }, // Europe/Chisinau
    {   71, 6308,   42635, 11, }, // Europe/Copenhagen
    {   71, 2340,   42646,  7, }, // Europe/Dublin
    {   71, 6326,   42653, 12, }, // Europe/Gibraltar
    {   71, 8806,   42665,  7, }, // Europe/Guernsey
    {   71, 6631,   42672,  9, }, // Europe/Helsinki
    {   71, 8822,   42681, 10, }, // Europe/Isle_of_Man
    {   71, 1132,   42691, 11, }, // Europe/Istanbul
    {   71, 8841,   42702,  5, }, // Europe/Jersey
    {   71, 3998,   42707, 11, }, // Europe/Kaliningrad
    {   71, 8855,   42718,  7, }, // Europe/Kirov
    {   71, 2529,   42725,  8, }, // Europe/Kyiv
    {   71, 3232,   42733,  9, }, // Europe/Lisbon
    {   71, 6525,   42742, 11, }, // Europe/Ljubljana
    {   71, 2503,   42753,  6, }, // Europe/London
    {   71, 6384,   42759,  8, }, // Europe/Luxembourg
    {   71, 4911,   42767,  5, }, // Europe/Madrid
    {   71, 6416,   42772,  8, }, // Europe/Malta
    {   71, 6601,   42780, 12, }, // Europe/Mariehamn
    {   71, 3712,   42792,  7, }, // Europe/Minsk
    {   71, 6429,   42799,  8, }, // Europe/Monaco
    {   71, 3556,   42807,  8, }, // Europe/Moscow
    {   71, 6477,   42815,  8, }, // Europe/Oslo
    {   71, 4303,   42823,  5, }, // Europe/Paris
    {   71, 6443,   42828, 11, }, // Europe/Podgorica
    {   71, 6294,   42839,  6, }, // Europe/Prague
    {   71, 8868,   42845,  4, }, // Europe/Riga
    {   71, 6343,   42849,  4, }, // Europe/Rome
    {   71, 4350,   42853,  7, }, // Europe/Samara
    {   71, 6489,   42860, 10, }, // Europe/San_Marino
    {   71, 6264,   42870,  9, }, // Europe/Sarajevo
    {   71, 4470,   42879, 10, }, // Europe/Saratov
    {   71, 8880,   42889, 12, }, // Europe/Simferopol
    {   71, 6402,   42901,  9, }, // Europe/Skopje
    {   71, 6618,   42910,  7, }, // Europe/Sofia
    {   71, 6542,   42917, 10, }, // Europe/Stockholm
    {   71, 8898,   42927,  6, }, // Europe/Tallinn
    {   71, 6221,   42933,  6, }, // Europe/Tirane
    {   71, 8913,   42939, 15, }, // Europe/Ulyanovsk
    {   71, 6371,   42954,  7, }, // Europe/Vaduz
    {   71, 6586,   42961,  7, }, // Europe/Vatican
    {   71, 6250,   42968,  7, }, // Europe/Vienna
    {   71, 8930,   42975, 13, }, // Europe/Vilnius
    {   71, 4746,   42988, 12, }, // Europe/Volgograd
    {   71, 3209,   43000,  5, }, // Europe/Warsaw
    {   71, 6280,   43005, 10, }, // Europe/Zagreb
    {   71, 6559,   43015,  9, }, // Europe/Zurich
    {   71, 5097,   43024, 15, }, // Indian/Antananarivo
    {   71, 6966,   43039,  8, }, // Indian/Chagos
    {   71, 6065,   43047,  8, }, // Indian/Christmas
    {   71, 6082,   43055,  9, }, // Indian/Cocos
    {   71, 5048,   43064,  9, }, // Indian/Comoro
    {   71, 6680,   43073,  7, }, // Indian/Kerguelen
    {   71, 7260,   43080,  4, }, // Indian/Mahe
    {   71, 7069,   43084, 10, }, // Indian/Maldives
    {   71, 4088,   43094,  8, }, // Indian/Mauritius
    {   71, 5117,   43102,  7, }, // Indian/Mayotte
    {   71, 7211,   43109,  9, }, // Indian/Reunion
    {   71, 4441,   43118,  8, }, // Pacific/Apia
    {   71, 3009,   43126,  8, }, // Pacific/Auckland
    {   71, 3725,   43134, 14, }, // Pacific/Bougainville
    {   71, 3034,   43148,  7, }, // Pacific/Chatham
    {   71, 3176,   43155,  5, }, // Pacific/Chuuk
    {   71, 2239,   43160,  5, }, // Pacific/Easter
    {   71, 7360,   43165,  6, }, // Pacific/Efate
    {   71, 7327,   43171, 10, }, // Pacific/Fakaofo
    {   71, 3921,   43181,  5, }, // Pacific/Fiji
    {   71, 7343,   43186,  8, }, // Pacific/Funafuti
    {   71, 6697,   43194, 11, }, // Pacific/Galapagos
    {   71, 6715,   43205,  7, }, // Pacific/Gambier
    {   71, 3841,   43212, 10, }, // Pacific/Guadalcanal
    {   71, 6037,   43222,  5, }, // Pacific/Guam
    {   71, 2725,   43227, 10, }, // Pacific/Honolulu
    {   71, 3068,   43237,  7, }, // Pacific/Kanton
    {   71, 4017,   43244,  8, }, // Pacific/Kiritimati
    {   71, 7038,   43252, 10, }, // Pacific/Kosrae
    {   71, 2844,   43262, 10, }, // Pacific/Kwajalein
    {   71, 4896,   43272,  9, }, // Pacific/Majuro
    {   71, 4070,   43281, 10, }, // Pacific/Marquesas
    {   71, 8945,   43291,  8, }, // Pacific/Midway
    {   71, 7103,   43299,  6, }, // Pacific/Nauru
    {   71, 7132,   43305,  6, }, // Pacific/Niue
    {   71, 4187,   43311, 10, }, // Pacific/Norfolk
    {   71, 7117,   43321,  7, }, // Pacific/Noumea
    {   71, 3145,   43328, 10, }, // Pacific/Pago_Pago
    {   71, 7155,   43338,  6, }, // Pacific/Palau
    {   71, 7194,   43344, 10, }, // Pacific/Pitcairn
    {   71, 3115,   43354,  9, }, // Pacific/Pohnpei
    {   71, 4826,   43363, 17, }, // Pacific/Port_Moresby
    {   71, 6095,   43380, 12, }, // Pacific/Rarotonga
    {   71, 6050,   43392,  8, }, // Pacific/Saipan
    {   71, 7312,   43400,  5, }, // Pacific/Tahiti
    {   71, 6731,   43405,  6, }, // Pacific/Tarawa
    {   71, 4602,   43411, 10, }, // Pacific/Tongatapu
    {   71, 7392,   43421,  6, }, // Pacific/Wake
    {   71, 7405,   43427,  7, }, // Pacific/Wallis
    {   72, 6807,   43434,  3, }, // Africa/Abidjan Cantonese/Traditional Han/Hong Kong
    {   72, 6779,   43437,  3, }, // Africa/Accra
    {   72, 5078,   43440,  6, }, // Africa/Addis_Ababa
    {   72, 7420,   43446,  4, }, // Africa/Algiers
    {   72,   14,   43450,  4, }, // Africa/Asmara
    {   72,   44,   43454,  3, }, // Africa/Bamako
    {   72, 5276,   43457,  2, }, // Africa/Bangui
    {   72, 6765,   43459,  2, }, // Africa/Banjul
    {   72, 7435,   43461,  2, }, // Africa/Bissau
    {   72, 4976,   43463,  4, }, // Africa/Blantyre
    {   72, 5306,   43467,  5, }, // Africa/Brazzaville
    {   72, 4941,   43472,  4, }, // Africa/Bujumbura
    {   72, 2322,   43476,  2, }, // Africa/Cairo
    {   72, 4136,   43478,  5, }, // Africa/Casablanca
    {   72, 7449,   43483,  2, }, // Africa/Ceuta
    {   72, 6792,   43485,  4, }, // Africa/Conakry
    {   72, 6859,   43489,  3, }, // Africa/Dakar
    {   72, 5149,   43492,  3, }, // Africa/Dar_es_Salaam
    {   72, 5062,   43495,  3, }, // Africa/Djibouti
    {   72, 5262,   43498,  3, }, // Africa/Douala
    {   72, 5185,   43501,  3, }, // Africa/El_Aaiun
    {   72, 6872,   43504,  3, }, // Africa/Freetown
    {   72, 4925,   43507,  4, }, // Africa/Gaborone
    {   72, 5034,   43511,  3, }, // Africa/Harare
    {   72, 4498,   43514,  5, }, // Africa/Johannesburg
    {   72, 4518,   43519,  2, }, // Africa/Juba
    {   72, 5170,   43521,  3, }, // Africa/Kampala
    {   72, 4543,   43524,  3, }, // Africa/Khartoum
    {   72, 4992,   43527,  3, }, // Africa/Kigali
    {   72, 5325,   43530,  3, }, // Africa/Kinshasa
    {   72, 4763,   43533,  3, }, // Africa/Lagos
    {   72, 5355,   43536,  3, }, // Africa/Libreville
    {   72, 6888,   43539,  2, }, // Africa/Lome
    {   72, 5230,   43541,  3, }, // Africa/Luanda
    {   72, 4958,   43544,  4, }, // Africa/Lubumbashi
    {   72, 5020,   43548,  3, }, // Africa/Lusaka
    {   72, 5341,   43551,  3, }, // Africa/Malabo
    {   72, 5006,   43554,  3, }, // Africa/Maputo
    {   72, 5216,   43557,  3, }, // Africa/Maseru
    {   72, 5201,   43560,  3, }, // Africa/Mbabane
    {   72, 5132,   43563,  4, }, // Africa/Mogadishu
    {   72, 7053,   43567,  4, }, // Africa/Monrovia
    {   72, 3872,   43571,  3, }, // Africa/Nairobi
    {   72, 5290,   43574,  4, }, // Africa/Ndjamena
    {   72, 5373,   43578,  3, }, // Africa/Niamey
    {   72, 6822,   43581,  3, }, // Africa/Nouakchott
    {   72, 6746,   43584,  4, }, // Africa/Ouagadougou
    {   72, 5244,   43588,  4, }, // Africa/Porto-Novo
    {   72, 4454,   43592,  3, }, // Africa/Sao_Tome
    {   72, 2868,   43595,  4, }, // Africa/Tripoli
    {   72, 6573,   43599,  3, }, // Africa/Tunis
    {   72, 4171,   43602,  4, }, // Africa/Windhoek
    {   72,  132,   43606,  3, }, // America/Adak
    {   72, 3365,   43609,  4, }, // America/Anchorage
    {   72, 5626,   43613,  3, }, // America/Anguilla
    {   72, 5643,   43616,  3, }, // America/Antigua
    {   72, 4573,   43619,  4, }, // America/Araguaina
    {   72,  166,   43623,  7, }, // America/Argentina/Buenos_Aires
    {   72,   91,   43630,  4, }, // America/Argentina/Catamarca
    {   72,  270,   43634,  3, }, // America/Argentina/Cordoba
    {   72,  441,   43637,  3, }, // America/Argentina/Jujuy
    {   72, 7462,   43640,  3, }, // America/Argentina/La_Rioja
    {   72,  565,   43643,  3, }, // America/Argentina/Mendoza
    {   72, 7489,   43646,  6, }, // America/Argentina/Rio_Gallegos
    {   72, 7520,   43652,  3, }, // America/Argentina/Salta
    {   72, 7544,   43655,  3, }, // America/Argentina/San_Juan
    {   72, 5599,   43658,  3, }, // America/Argentina/San_Luis
    {   72, 7571,   43661,  3, }, // America/Argentina/Tucuman
    {   72, 7597,   43664,  4, }, // America/Argentina/Ushuaia
    {   72, 5659,   43668,  3, }, // America/Aruba
    {   72, 4271,   43671,  3, }, // America/Asuncion
    {   72,  237,   43674,  4, }, // America/Atikokan
    {   72, 3698,   43678,  3, }, // America/Bahia
    {   72, 7623,   43681,  7, }, // America/Bahia_Banderas
    {   72, 5673,   43688,  3, }, // America/Barbados
    {   72, 7646,   43691,  2, }, // America/Belem
    {   72, 5426,   43693,  3, }, // America/Belize
    {   72, 7660,   43696,  5, }, // America/Blanc-Sablon
    {   72, 7681,   43701,  4, }, // America/Boa_Vista
    {   72, 4380,   43705,  3, }, // America/Bogota
    {   72, 7699,   43708,  2, }, // America/Boise
    {   72, 7713,   43710,  3, }, // America/Cambridge_Bay
    {   72, 7735,   43713,  3, }, // America/Campo_Grande
    {   72, 3887,   43716,  2, }, // America/Cancun
    {   72, 4713,   43718,  4, }, // America/Caracas
    {   72, 4364,   43722,  2, }, // America/Cayenne
    {   72, 5515,   43724,  4, }, // America/Cayman
    {   72, 2262,   43728,  3, }, // America/Chicago
    {   72, 7756,   43731,  3, }, // America/Chihuahua
    {   72, 7774,   43734,  4, }, // America/Ciudad_Juarez
    {   72, 5441,   43738,  5, }, // America/Costa_Rica
    {   72, 7796,   43743,  4, }, // America/Coyhaique
    {   72, 7814,   43747,  4, }, // America/Creston
    {   72, 3810,   43751,  3, }, // America/Cuiaba
    {   72, 5742,   43754,  3, }, // America/Curacao
    {   72, 7830,   43757,  4, }, // America/Danmarkshavn
    {   72, 7851,   43761,  2, }, // America/Dawson
    {   72, 7866,   43763,  5, }, // America/Dawson_Creek
    {   72,  805,   43768,  2, }, // America/Denver
    {   72, 3484,   43770,  3, }, // America/Detroit
    {   72, 5758,   43773,  4, }, // America/Dominica
    {   72,  893,   43777,  4, }, // America/Edmonton
    {   72, 7887,   43781,  4, }, // America/Eirunepe
    {   72, 5460,   43785,  4, }, // America/El_Salvador
    {   72, 7904,   43789,  4, }, // America/Fort_Nelson
    {   72, 7924,   43793,  4, }, // America/Fortaleza
    {   72, 7942,   43797,  4, }, // America/Glace_Bay
    {   72, 6900,   43801,  2, }, // America/Goose_Bay
    {   72, 4631,   43803,  4, }, // America/Grand_Turk
    {   72, 5789,   43807,  4, }, // America/Grenada
    {   72, 5805,   43811,  4, }, // America/Guadeloupe
    {   72, 3779,   43815,  4, }, // America/Guatemala
    {   72, 4860,   43819,  4, }, // America/Guayaquil
    {   72, 6951,   43823,  3, }, // America/Guyana
    {   72, 1941,   43826,  5, }, // America/Halifax
    {   72, 2283,   43831,  3, }, // America/Havana
    {   72, 7960,   43834,  4, }, // America/Hermosillo
    {   72,  348,   43838,  7, }, // America/Indiana/Indianapolis
    {   72,  481,   43845,  8, }, // America/Indiana/Knox
    {   72, 7979,   43853,  8, }, // America/Indiana/Marengo
    {   72, 8003,   43861,  8, }, // America/Indiana/Petersburg
    {   72, 8030,   43869,  8, }, // America/Indiana/Tell_City
    {   72, 8056,   43877,  7, }, // America/Indiana/Vevay
    {   72, 8078,   43884,  8, }, // America/Indiana/Vincennes
    {   72, 8104,   43892,  9, }, // America/Indiana/Winamac
    {   72, 8128,   43901,  4, }, // America/Inuvik
    {   72,  660,   43905,  3, }, // America/Iqaluit
    {   72, 2801,   43908,  3, }, // America/Jamaica
    {   72, 5399,   43911,  2, }, // America/Juneau
    {   72,  521,   43913,  5, }, // America/Kentucky/Louisville
    {   72, 8143,   43918,  8, }, // America/Kentucky/Monticello
    {   72, 5723,   43926,  5, }, // America/Kralendijk
    {   72, 4395,   43931,  3, }, // America/La_Paz
    {   72, 7169,   43934,  2, }, // America/Lima
    {   72, 3258,   43936,  3, }, // America/Los_Angeles
    {   72, 5951,   43939,  4, }, // America/Lower_Princes
    {   72, 8171,   43943,  3, }, // America/Maceio
    {   72, 8186,   43946,  3, }, // America/Managua
    {   72, 1910,   43949,  3, }, // America/Manaus
    {   72, 5916,   43952,  4, }, // America/Marigot
    {   72, 5824,   43956,  4, }, // America/Martinique
    {   72, 8202,   43960,  5, }, // America/Matamoros
    {   72, 2919,   43965,  4, }, // America/Mazatlan
    {   72, 8220,   43969,  4, }, // America/Menominee
    {   72, 8238,   43973,  3, }, // America/Merida
    {   72, 8253,   43976,  6, }, // America/Metlakatla
    {   72, 2951,   43982,  4, }, // America/Mexico_City
    {   72, 4410,   43986,  3, }, // America/Miquelon
    {   72, 8272,   43989,  3, }, // America/Moncton
    {   72, 8288,   43992,  3, }, // America/Monterrey
    {   72, 4117,   43995,  4, }, // America/Montevideo
    {   72, 5843,   43999,  3, }, // America/Montserrat
    {   72, 5500,   44002,  2, }, // America/Nassau
    {   72, 2381,   44004,  2, }, // America/New_York
    {   72, 8306,   44006,  2, }, // America/Nome
    {   72, 1852,   44008,  3, }, // America/Noronha
    {   72, 8319,   44011,  8, }, // America/North_Dakota/Beulah
    {   72, 8347,   44019,  7, }, // America/North_Dakota/Center
    {   72, 8375,   44026,  8, }, // America/North_Dakota/New_Salem
    {   72,  393,   44034,  2, }, // America/Nuuk
    {   72, 8406,   44036,  4, }, // America/Ojinaga
    {   72, 2358,   44040,  3, }, // America/Panama
    {   72, 6192,   44043,  5, }, // America/Paramaribo
    {   72, 2975,   44048,  3, }, // America/Phoenix
    {   72, 3964,   44051,  3, }, // America/Port-au-Prince
    {   72, 5973,   44054,  4, }, // America/Port_of_Spain
    {   72, 8422,   44058,  3, }, // America/Porto_Velho
    {   72, 5862,   44061,  4, }, // America/Puerto_Rico
    {   72, 4049,   44065,  6, }, // America/Punta_Arenas
    {   72, 8442,   44071,  3, }, // America/Rankin_Inlet
    {   72, 8463,   44074,  3, }, // America/Recife
    {   72, 1997,   44077,  3, }, // America/Regina
    {   72, 8478,   44080,  4, }, // America/Resolute
    {   72,  695,   44084,  4, }, // America/Rio_Branco
    {   72, 8495,   44088,  3, }, // America/Santarem
    {   72, 2203,   44091,  4, }, // America/Santiago
    {   72, 6130,   44095,  4, }, // America/Santo_Domingo
    {   72, 1880,   44099,  3, }, // America/Sao_Paulo
    {   72, 6918,   44102,  7, }, // America/Scoresbysund
    {   72, 8512,   44109,  3, }, // America/Sitka
    {   72, 8526,   44112,  6, }, // America/St_Barthelemy
    {   72, 2063,   44118,  3, }, // America/St_Johns
    {   72, 5882,   44121,  3, }, // America/St_Kitts
    {   72, 5899,   44124,  4, }, // America/St_Lucia
    {   72,  855,   44128,  4, }, // America/St_Thomas
    {   72, 5932,   44132,  3, }, // America/St_Vincent
    {   72, 8548,   44135,  7, }, // America/Swift_Current
    {   72, 5480,   44142,  5, }, // America/Tegucigalpa
    {   72, 5775,   44147,  2, }, // America/Thule
    {   72,  313,   44149,  3, }, // America/Tijuana
    {   72,  608,   44152,  3, }, // America/Toronto
    {   72, 5707,   44155,  4, }, // America/Tortola
    {   72, 2095,   44159,  3, }, // America/Vancouver
    {   72, 2146,   44162,  4, }, // America/Whitehorse
    {   72,  734,   44166,  3, }, // America/Winnipeg
    {   72, 8570,   44169,  3, }, // America/Yakutat
    {   72, 6020,   44172,  2, }, // Antarctica/Casey
    {   72, 6113,   44174,  3, }, // Antarctica/Davis
    {   72, 6152,   44177,  5, }, // Antarctica/DumontDUrville
    {   72, 8586,   44182,  3, }, // Antarctica/Macquarie
    {   72, 7085,   44185,  2, }, // Antarctica/Mawson
    {   72,  932,   44187,  4, }, // Antarctica/McMurdo
    {   72, 8607,   44191,  2, }, // Antarctica/Palmer
    {   72, 7226,   44193,  3, }, // Antarctica/Rothera
    {   72, 7295,   44196,  4, }, // Antarctica/Syowa
    {   72, 8625,   44200,  2, }, // Antarctica/Troll
    {   72, 7374,   44202,  4, }, // Antarctica/Vostok
    {   72, 1431,   44206,  5, }, // Arctic/Longyearbyen
    {   72, 5589,   44211,  2, }, // Asia/Aden
    {   72, 5414,   44213,  4, }, // Asia/Almaty
    {   72, 3987,   44217,  2, }, // Asia/Amman
    {   72, 5530,   44219,  3, }, // Asia/Anadyr
    {   72, 5542,   44222,  3, }, // Asia/Aqtau
    {   72, 5387,   44225,  4, }, // Asia/Aqtobe
    {   72,  966,   44229,  5, }, // Asia/Ashgabat
    {   72, 8642,   44234,  3, }, // Asia/Atyrau
    {   72, 3626,   44237,  3, }, // Asia/Baghdad
    {   72, 5553,   44240,  2, }, // Asia/Bahrain
    {   72, 3672,   43753,  2, }, // Asia/Baku
    {   72, 4485,   44242,  2, }, // Asia/Bangkok
    {   72, 3590,   44244,  4, }, // Asia/Barnaul
    {   72, 4105,   44248,  3, }, // Asia/Beirut
    {   72, 3797,   44251,  4, }, // Asia/Bishkek
    {   72, 6008,   44255,  2, }, // Asia/Brunei
    {   72, 4620,   44257,  2, }, // Asia/Chita
    {   72, 4530,   44259,  3, }, // Asia/Colombo
    {   72, 4559,   44262,  4, }, // Asia/Damascus
    {   72, 1095,   44266,  2, }, // Asia/Dhaka
    {   72, 6211,   44268,  2, }, // Asia/Dili
    {   72, 3615,   44270,  2, }, // Asia/Dubai
    {   72, 6178,   44272,  3, }, // Asia/Dushanbe
    {   72, 8654,   44275,  5, }, // Asia/Famagusta
    {   72, 8669,   44280,  2, }, // Asia/Gaza
    {   72, 4814,   44282,  3, }, // Asia/Hebron
    {   72, 1261,   44285,  4, }, // Asia/Ho_Chi_Minh
    {   72, 2706,   44289, 14, }, // Asia/Hong_Kong
    {   72, 4790,   44303,  3, }, // Asia/Hovd
    {   72, 4203,   44306,  5, }, // Asia/Irkutsk
    {   72, 7025,   44311,  3, }, // Asia/Jakarta
    {   72, 7011,   44314,  4, }, // Asia/Jayapura
    {   72, 1292,   44318,  4, }, // Asia/Jerusalem
    {   72, 3579,   44322,  3, }, // Asia/Kabul
    {   72, 4335,   44325,  3, }, // Asia/Kamchatka
    {   72, 4258,   44328,  3, }, // Asia/Karachi
    {   72, 1187,   44331,  4, }, // Asia/Kathmandu
    {   72, 8679,   44335,  3, }, // Asia/Khandyga
    {   72,  994,   44338,  4, }, // Asia/Kolkata
    {   72, 4216,   44342,  8, }, // Asia/Krasnoyarsk
    {   72, 4878,   44350,  3, }, // Asia/Kuala_Lumpur
    {   72, 5995,   44353,  2, }, // Asia/Kuching
    {   72, 5566,   44355,  3, }, // Asia/Kuwait
    {   72, 1213,   44358, 14, }, // Asia/Macau
    {   72, 4036,   44372,  3, }, // Asia/Magadan
    {   72, 1351,   44375,  4, }, // Asia/Makassar
    {   72, 7182,   44379,  3, }, // Asia/Manila
    {   72, 6939,   44382,  4, }, // Asia/Muscat
    {   72, 2556,   44386,  4, }, // Asia/Nicosia
    {   72, 8693,   44390,  6, }, // Asia/Novokuznetsk
    {   72, 4154,   44396,  5, }, // Asia/Novosibirsk
    {   72, 4248,   44401,  4, }, // Asia/Omsk
    {   72, 7145,   44405,  3, }, // Asia/Oral
    {   72, 6980,   44408,  2, }, // Asia/Phnom_Penh
    {   72, 8711,   44410,  2, }, // Asia/Pontianak
    {   72, 4233,   44412,  2, }, // Asia/Pyongyang
    {   72, 5578,   44414,  2, }, // Asia/Qatar
    {   72, 8726,   44416,  4, }, // Asia/Qostanay
    {   72, 4288,   44420,  6, }, // Asia/Qyzylorda
    {   72, 3603,   44426,  3, }, // Asia/Riyadh
    {   72, 4427,   44429,  3, }, // Asia/Sakhalin
    {   72, 7245,   44432,  4, }, // Asia/Samarkand
    {   72, 3298,   44436,  2, }, // Asia/Seoul
    {   72, 1055,   44438,  2, }, // Asia/Shanghai
    {   72, 3319,   44440,  3, }, // Asia/Singapore
    {   72, 4316,   44443,  6, }, // Asia/Srednekolymsk
    {   72, 3282,   44449,  2, }, // Asia/Taipei
    {   72, 4800,   44451,  3, }, // Asia/Tashkent
    {   72, 3934,   44454,  4, }, // Asia/Tbilisi
    {   72, 2774,   44458,  3, }, // Asia/Tehran
    {   72, 1319,   44461,  2, }, // Asia/Thimphu
    {   72, 2823,   44463,  2, }, // Asia/Tokyo
    {   72, 4591,   44465,  4, }, // Asia/Tomsk
    {   72, 1023,   44469,  4, }, // Asia/Ulaanbaatar
    {   72, 1161,   44473,  4, }, // Asia/Urumqi
    {   72, 8740,   44477,  4, }, // Asia/Ust-Nera
    {   72, 6996,   44481,  2, }, // Asia/Vientiane
    {   72, 4729,   44483,  3, }, // Asia/Vladivostok
    {   72, 4847,   44486,  4, }, // Asia/Yakutsk
    {   72, 1237,   44490,  2, }, // Asia/Yangon
    {   72, 3902,   44492,  5, }, // Asia/Yekaterinburg
    {   72, 3766,   44497,  3, }, // Asia/Yerevan
    {   72, 3682,   44500,  5, }, // Atlantic/Azores
    {   72, 5690,   44505,  3, }, // Atlantic/Bermuda
    {   72, 6647,   44508,  3, }, // Atlantic/Canary
    {   72, 3746,   44511,  3, }, // Atlantic/Cape_Verde
    {   72, 1397,   44514,  4, }, // Atlantic/Faroe
    {   72, 8754,   44518,  5, }, // Atlantic/Madeira
    {   72, 2750,   44523,  5, }, // Atlantic/Reykjavik
    {   72, 7272,   44528,  4, }, // Atlantic/South_Georgia
    {   72, 6840,   44532,  5, }, // Atlantic/St_Helena
    {   72, 6663,   44537,  3, }, // Atlantic/Stanley
    {   72, 1672,   44540,  4, }, // Australia/Adelaide
    {   72, 1637,   44544,  4, }, // Australia/Brisbane
    {   72, 1801,   44548,  5, }, // Australia/Broken_Hill
    {   72, 1585,   44553,  3, }, // Australia/Darwin
    {   72, 3656,   44556,  3, }, // Australia/Eucla
    {   72, 1518,   44559,  3, }, // Australia/Hobart
    {   72, 8771,   44562,  3, }, // Australia/Lindeman
    {   72, 1549,   44565,  4, }, // Australia/Lord_Howe
    {   72, 1729,   44569,  3, }, // Australia/Melbourne
    {   72, 1764,   44572,  2, }, // Australia/Perth
    {   72, 1465,   44574,  2, }, // Australia/Sydney
    {   72, 6460,   44576,  5, }, // Europe/Amsterdam
    {   72, 6235,   44581,  3, }, // Europe/Andorra
    {   72, 3639,   44584,  5, }, // Europe/Astrakhan
    {   72, 2302,   44589,  2, }, // Europe/Athens
    {   72, 6355,   44591,  4, }, // Europe/Belgrade
    {   72, 4776,   44595,  2, }, // Europe/Berlin
    {   72, 6507,   44597,  6, }, // Europe/Bratislava
    {   72, 2169,   44603,  4, }, // Europe/Brussels
    {   72, 3947,   44607,  5, }, // Europe/Bucharest
    {   72, 3825,   44612,  4, }, // Europe/Budapest
    {   72, 8790,   44616,  3, }, // Europe/Busingen
    {   72, 2585,   44619,  3, }, // Europe/Chisinau
    {   72, 6308,   44622,  4, }, // Europe/Copenhagen
    {   72, 2340,   44626,  3, }, // Europe/Dublin
    {   72, 6326,   44629,  4, }, // Europe/Gibraltar
    {   72, 8806,   44633,  3, }, // Europe/Guernsey
    {   72, 6631,   44636,  4, }, // Europe/Helsinki
    {   72, 8822,   44640,  2, }, // Europe/Isle_of_Man
    {   72, 1132,   44642,  4, }, // Europe/Istanbul
    {   72, 8841,   44646,  3, }, // Europe/Jersey
    {   72, 3998,   44649,  5, }, // Europe/Kaliningrad
    {   72, 8855,   44654,  3, }, // Europe/Kirov
    {   72, 2529,   44657,  2, }, // Europe/Kyiv
    {   72, 3232,   44659,  3, }, // Europe/Lisbon
    {   72, 6525,   44662,  4, }, // Europe/Ljubljana
    {   72, 2503,   44666,  2, }, // Europe/London
    {   72, 6384,   44668,  3, }, // Europe/Luxembourg
    {   72, 4911,   44671,  3, }, // Europe/Madrid
    {   72, 6416,   44674,  3, }, // Europe/Malta
    {   72, 6601,   44677,  3, }, // Europe/Mariehamn
    {   72, 3712,   44680,  3, }, // Europe/Minsk
    {   72, 6429,   44683,  3, }, // Europe/Monaco
    {   72, 3556,   44686,  3, }, // Europe/Moscow
    {   72, 6477,   44689,  3, }, // Europe/Oslo
    {   72, 4303,   44692,  2, }, // Europe/Paris
    {   72, 6443,   44694,  4, }, // Europe/Podgorica
    {   72, 6294,   44698,  3, }, // Europe/Prague
    {   72, 8868,   44701,  2, }, // Europe/Riga
    {   72, 6343,   44703,  2, }, // Europe/Rome
    {   72, 4350,   44705,  3, }, // Europe/Samara
    {   72, 6489,   44708,  4, }, // Europe/San_Marino
    {   72, 6264,   44712,  4, }, // Europe/Sarajevo
    {   72, 4470,   44716,  4, }, // Europe/Saratov
    {   72, 8880,   44720,  4, }, // Europe/Simferopol
    {   72, 6402,   44724,  4, }, // Europe/Skopje
    {   72, 6618,   44728,  3, }, // Europe/Sofia
    {   72, 6542,   44731,  5, }, // Europe/Stockholm
    {   72, 8898,   44736,  2, }, // Europe/Tallinn
    {   72, 6221,   44738,  3, }, // Europe/Tirane
    {   72, 8913,   44741,  7, }, // Europe/Ulyanovsk
    {   72, 6371,   44748,  3, }, // Europe/Vaduz
    {   72, 6586,   44751,  3, }, // Europe/Vatican
    {   72, 6250,   44754,  3, }, // Europe/Vienna
    {   72, 8930,   44757,  4, }, // Europe/Vilnius
    {   72, 4746,   44761,  5, }, // Europe/Volgograd
    {   72, 3209,   44766,  2, }, // Europe/Warsaw
    {   72, 6280,   44768,  4, }, // Europe/Zagreb
    {   72, 6559,   44772,  3, }, // Europe/Zurich
    {   72, 5097,   44775,  6, }, // Indian/Antananarivo
    {   72, 6966,   44781,  3, }, // Indian/Chagos
    {   72, 6065,   44784,  3, }, // Indian/Christmas
    {   72, 6082,   44787,  5, }, // Indian/Cocos
    {   72, 5048,   44792,  5, }, // Indian/Comoro
    {   72, 6680,   44797,  5, }, // Indian/Kerguelen
    {   72, 7260,   44802,  3, }, // Indian/Mahe
    {   72, 7069,   44805,  4, }, // Indian/Maldives
    {   72, 4088,   44809,  4, }, // Indian/Mauritius
    {   72, 5117,   44813,  4, }, // Indian/Mayotte
    {   72, 7211,   44817,  4, }, // Indian/Reunion
    {   72, 4441,   44821,  3, }, // Pacific/Apia
    {   72, 3009,   44824,  3, }, // Pacific/Auckland
    {   72, 3725,   44827,  4, }, // Pacific/Bougainville
    {   72, 3034,   44831,  2, }, // Pacific/Chatham
    {   72, 3176,   44833,  2, }, // Pacific/Chuuk
    {   72, 2239,   44835,  3, }, // Pacific/Easter
    {   72, 7360,   44838,  3, }, // Pacific/Efate
    {   72, 7327,   44841,  3, }, // Pacific/Fakaofo
    {   72, 3921,   44844,  2, }, // Pacific/Fiji
    {   72, 7343,   44846,  4, }, // Pacific/Funafuti
    {   72, 6697,   44850,  6, }, // Pacific/Galapagos
    {   72, 6715,   44856,  5, }, // Pacific/Gambier
    {   72, 3841,   44861,  6, }, // Pacific/Guadalcanal
    {   72, 6037,   44867,  2, }, // Pacific/Guam
    {   72, 2725,   44869,  3, }, // Pacific/Honolulu
    {   72, 3068,   44872,  2, }, // Pacific/Kanton
    {   72, 4017,   44874,  6, }, // Pacific/Kiritimati
    {   72, 7038,   44880,  3, }, // Pacific/Kosrae
    {   72, 2844,   44883,  4, }, // Pacific/Kwajalein
    {   72, 4896,   44887,  3, }, // Pacific/Majuro
    {   72, 4070,   44890,  5, }, // Pacific/Marquesas
    {   72, 8945,   44895,  3, }, // Pacific/Midway
    {   72, 7103,   44898,  2, }, // Pacific/Nauru
    {   72, 7132,   44900,  3, }, // Pacific/Niue
    {   72, 4187,   44903,  3, }, // Pacific/Norfolk
    {   72, 7117,   44906,  3, }, // Pacific/Noumea
    {   72, 3145,   44909,  4, }, // Pacific/Pago_Pago
    {   72, 7155,   44913,  2, }, // Pacific/Palau
    {   72, 7194,   44915,  5, }, // Pacific/Pitcairn
    {   72, 3115,   44920,  3, }, // Pacific/Pohnpei
    {   72, 4826,   44923,  4, }, // Pacific/Port_Moresby
    {   72, 6095,   44927,  4, }, // Pacific/Rarotonga
    {   72, 6050,   44931,  2, }, // Pacific/Saipan
    {   72, 7312,   44933,  3, }, // Pacific/Tahiti
    {   72, 6731,   44936,  3, }, // Pacific/Tarawa
    {   72, 4602,   44939,  5, }, // Pacific/Tongatapu
    {   72, 7392,   44944,  2, }, // Pacific/Wake
    {   72, 7405,   44946,  3, }, // Pacific/Wallis
    {   73, 6807,   44949,  3, }, // Africa/Abidjan Cantonese/Simplified Han/China
    {   73, 5078,   44952,  6, }, // Africa/Addis_Ababa
    {   73, 7420,   44958,  4, }, // Africa/Algiers
    {   73,   14,   44962,  4, }, // Africa/Asmara
    {   73,   44,   44966,  3, }, // Africa/Bamako
    {   73, 7435,   44969,  2, }, // Africa/Bissau
    {   73, 4976,   44971,  4, }, // Africa/Blantyre
    {   73, 5306,   44975,  5, }, // Africa/Brazzaville
    {   73, 2322,   44980,  2, }, // Africa/Cairo
    {   73, 4136,   44982,  5, }, // Africa/Casablanca
    {   73, 7449,   44987,  2, }, // Africa/Ceuta
    {   73, 6859,   44989,  3, }, // Africa/Dakar
    {   73, 5149,   44992,  3, }, // Africa/Dar_es_Salaam
    {   73, 4498,   44995,  5, }, // Africa/Johannesburg
    {   73, 5230,   45000,  3, }, // Africa/Luanda
    {   73, 4958,   45003,  4, }, // Africa/Lubumbashi
    {   73, 5341,   45007,  3, }, // Africa/Malabo
    {   73, 5006,   45010,  3, }, // Africa/Maputo
    {   73, 5216,   45013,  3, }, // Africa/Maseru
    {   73, 7053,   45016,  4, }, // Africa/Monrovia
    {   73, 5290,   45020,  4, }, // Africa/Ndjamena
    {   73, 5373,   45024,  3, }, // Africa/Niamey
    {   73, 6822,   45027,  3, }, // Africa/Nouakchott
    {   73, 5244,   45030,  4, }, // Africa/Porto-Novo
    {   73, 4454,   45034,  3, }, // Africa/Sao_Tome
    {   73, 4171,   45037,  4, }, // Africa/Windhoek
    {   73,  132,   45041,  3, }, // America/Adak
    {   73,  166,   45044,  7, }, // America/Argentina/Buenos_Aires
    {   73,   91,   45051,  4, }, // America/Argentina/Catamarca
    {   73,  270,   45055,  3, }, // America/Argentina/Cordoba
    {   73,  565,   45058,  3, }, // America/Argentina/Mendoza
    {   73, 7489,   45061,  6, }, // America/Argentina/Rio_Gallegos
    {   73, 7520,   45067,  3, }, // America/Argentina/Salta
    {   73, 7544,   45070,  3, }, // America/Argentina/San_Juan
    {   73, 5599,   45073,  3, }, // America/Argentina/San_Luis
    {   73, 7571,   45076,  3, }, // America/Argentina/Tucuman
    {   73, 7597,   45079,  4, }, // America/Argentina/Ushuaia
    {   73, 4271,   45083,  3, }, // America/Asuncion
    {   73, 7623,   45086,  7, }, // America/Bahia_Banderas
    {   73, 5673,   45093,  3, }, // America/Barbados
    {   73, 7646,   45096,  2, }, // America/Belem
    {   73, 5426,   45098,  3, }, // America/Belize
    {   73, 7660,   45101,  5, }, // America/Blanc-Sablon
    {   73, 7681,   45106,  4, }, // America/Boa_Vista
    {   73, 7713,   45110,  3, }, // America/Cambridge_Bay
    {   73, 7735,   45113,  3, }, // America/Campo_Grande
    {   73, 4364,   45116,  2, }, // America/Cayenne
    {   73, 5515,   45118,  4, }, // America/Cayman
    {   73, 7756,   45122,  3, }, // America/Chihuahua
    {   73, 7774,   45125,  4, }, // America/Ciudad_Juarez
    {   73, 7814,   45129,  4, }, // America/Creston
    {   73, 5742,   45133,  3, }, // America/Curacao
    {   73, 7830,   45136,  4, }, // America/Danmarkshavn
    {   73, 7887,   45140,  4, }, // America/Eirunepe
    {   73, 5460,   45144,  4, }, // America/El_Salvador
    {   73, 7904,   45148,  4, }, // America/Fort_Nelson
    {   73, 7942,   45152,  4, }, // America/Glace_Bay
    {   73, 6900,   45156,  2, }, // America/Goose_Bay
    {   73, 4631,   45158,  4, }, // America/Grand_Turk
    {   73, 5789,   45162,  4, }, // America/Grenada
    {   73, 3779,   45166,  4, }, // America/Guatemala
    {   73, 4860,   45170,  4, }, // America/Guayaquil
    {   73, 6951,   45174,  3, }, // America/Guyana
    {   73, 7960,   45177,  4, }, // America/Hermosillo
    {   73,  481,   45181,  8, }, // America/Indiana/Knox
    {   73, 7979,   45189,  8, }, // America/Indiana/Marengo
    {   73, 8030,   45197,  8, }, // America/Indiana/Tell_City
    {   73, 8056,   45205,  7, }, // America/Indiana/Vevay
    {   73, 8078,   45212,  8, }, // America/Indiana/Vincennes
    {   73, 8104,   45220,  9, }, // America/Indiana/Winamac
    {   73, 8128,   45229,  4, }, // America/Inuvik
    {   73, 2801,   45233,  3, }, // America/Jamaica
    {   73, 5399,   45236,  2, }, // America/Juneau
    {   73,  521,   45238,  5, }, // America/Kentucky/Louisville
    {   73, 8143,   45243,  8, }, // America/Kentucky/Monticello
    {   73, 5723,   45251,  5, }, // America/Kralendijk
    {   73, 7169,   45256,  2, }, // America/Lima
    {   73, 3258,   45258,  3, }, // America/Los_Angeles
    {   73, 5951,   45261,  4, }, // America/Lower_Princes
    {   73, 8171,   45265,  3, }, // America/Maceio
    {   73, 8186,   45268,  3, }, // America/Managua
    {   73, 1910,   45271,  3, }, // America/Manaus
    {   73, 5916,   45274,  4, }, // America/Marigot
    {   73, 5824,   45278,  4, }, // America/Martinique
    {   73, 8202,   45282,  5, }, // America/Matamoros
    {   73, 2919,   45287,  4, }, // America/Mazatlan
    {   73, 8220,   45291,  4, }, // America/Menominee
    {   73, 8238,   45295,  3, }, // America/Merida
    {   73, 4410,   45298,  3, }, // America/Miquelon
    {   73, 8272,   45301,  3, }, // America/Moncton
    {   73, 4117,   45304,  4, }, // America/Montevideo
    {   73, 5843,   45308,  3, }, // America/Montserrat
    {   73, 2381,   45311,  2, }, // America/New_York
    {   73, 8306,   45313,  2, }, // America/Nome
    {   73, 1852,   45315,  3, }, // America/Noronha
    {   73, 8319,   45318,  8, }, // America/North_Dakota/Beulah
    {   73, 8347,   45326,  7, }, // America/North_Dakota/Center
    {   73, 8375,   45333,  8, }, // America/North_Dakota/New_Salem
    {   73, 8406,   45341,  4, }, // America/Ojinaga
    {   73, 2358,   45345,  3, }, // America/Panama
    {   73, 6192,   45348,  5, }, // America/Paramaribo
    {   73, 2975,   45353,  3, }, // America/Phoenix
    {   73, 8422,   45356,  3, }, // America/Porto_Velho
    {   73, 4049,   45359,  6, }, // America/Punta_Arenas
    {   73, 8442,   45365,  3, }, // America/Rankin_Inlet
    {   73, 1997,   45368,  3, }, // America/Regina
    {   73, 8478,   45371,  4, }, // America/Resolute
    {   73,  695,   45375,  4, }, // America/Rio_Branco
    {   73, 8495,   45379,  3, }, // America/Santarem
    {   73, 2203,   45382,  4, }, // America/Santiago
    {   73, 6130,   45386,  4, }, // America/Santo_Domingo
    {   73, 1880,   45390,  3, }, // America/Sao_Paulo
    {   73, 6918,   45393,  7, }, // America/Scoresbysund
    {   73, 8512,   45400,  3, }, // America/Sitka
    {   73, 8526,   45403,  6, }, // America/St_Barthelemy
    {   73, 2063,   45409,  3, }, // America/St_Johns
    {   73, 5882,   45412,  3, }, // America/St_Kitts
    {   73, 5899,   45415,  4, }, // America/St_Lucia
    {   73,  855,   45419,  4, }, // America/St_Thomas
    {   73, 5932,   45423,  3, }, // America/St_Vincent
    {   73, 8548,   45426,  7, }, // America/Swift_Current
    {   73,  313,   45433,  3, }, // America/Tijuana
    {   73,  608,   45436,  3, }, // America/Toronto
    {   73, 5707,   45439,  4, }, // America/Tortola
    {   73, 2095,   45443,  3, }, // America/Vancouver
    {   73, 2146,   45446,  4, }, // America/Whitehorse
    {   73,  734,   45450,  3, }, // America/Winnipeg
    {   73, 8570,   45453,  3, }, // America/Yakutat
    {   73, 6020,   45456,  2, }, // Antarctica/Casey
    {   73, 6113,   45458,  3, }, // Antarctica/Davis
    {   73, 6152,   45461,  5, }, // Antarctica/DumontDUrville
    {   73, 8586,   45466,  3, }, // Antarctica/Macquarie
    {   73,  932,   45469,  4, }, // Antarctica/McMurdo
    {   73, 8607,   45473,  2, }, // Antarctica/Palmer
    {   73, 7226,   45475,  3, }, // Antarctica/Rothera
    {   73, 8625,   45478,  2, }, // Antarctica/Troll
    {   73, 5589,   45480,  2, }, // Asia/Aden
    {   73, 5414,   45482,  4, }, // Asia/Almaty
    {   73, 8642,   45486,  3, }, // Asia/Atyrau
    {   73, 3626,   45489,  3, }, // Asia/Baghdad
    {   73, 3672,   45492,  2, }, // Asia/Baku
    {   73, 3590,   45494,  4, }, // Asia/Barnaul
    {   73, 4105,   45498,  3, }, // Asia/Beirut
    {   73, 3797,   45501,  4, }, // Asia/Bishkek
    {   73, 6008,   45505,  2, }, // Asia/Brunei
    {   73, 4530,   45507,  3, }, // Asia/Colombo
    {   73, 4559,   45510,  4, }, // Asia/Damascus
    {   73, 1095,   45514,  2, }, // Asia/Dhaka
    {   73, 6178,   45516,  3, }, // Asia/Dushanbe
    {   73, 8654,   45519,  5, }, // Asia/Famagusta
    {   73, 8669,   45524,  2, }, // Asia/Gaza
    {   73, 2706,   45526, 14, }, // Asia/Hong_Kong
    {   73, 4203,   45540,  5, }, // Asia/Irkutsk
    {   73, 7025,   45545,  3, }, // Asia/Jakarta
    {   73, 7011,   45548,  4, }, // Asia/Jayapura
    {   73, 3579,   45552,  3, }, // Asia/Kabul
    {   73, 1187,   45555,  4, }, // Asia/Kathmandu
    {   73,  994,   45559,  4, }, // Asia/Kolkata
    {   73, 4216,   45563,  8, }, // Asia/Krasnoyarsk
    {   73, 5995,   45571,  2, }, // Asia/Kuching
    {   73, 1213,   45573, 14, }, // Asia/Macau
    {   73, 4036,   45587,  3, }, // Asia/Magadan
    {   73, 1351,   45590,  4, }, // Asia/Makassar
    {   73, 7182,   45594,  3, }, // Asia/Manila
    {   73, 6939,   45597,  4, }, // Asia/Muscat
    {   73, 2556,   45601,  4, }, // Asia/Nicosia
    {   73, 8693,   45605,  6, }, // Asia/Novokuznetsk
    {   73, 4154,   45611,  5, }, // Asia/Novosibirsk
    {   73, 7145,   45616,  3, }, // Asia/Oral
    {   73, 6980,   45619,  2, }, // Asia/Phnom_Penh
    {   73, 5578,   45621,  2, }, // Asia/Qatar
    {   73, 4288,   45623,  6, }, // Asia/Qyzylorda
    {   73, 4427,   45629,  3, }, // Asia/Sakhalin
    {   73, 7245,   45632,  4, }, // Asia/Samarkand
    {   73, 3298,   45636,  2, }, // Asia/Seoul
    {   73, 2774,   45638,  3, }, // Asia/Tehran
    {   73, 2823,   45641,  2, }, // Asia/Tokyo
    {   73, 1023,   45643,  4, }, // Asia/Ulaanbaatar
    {   73, 1161,   45647,  4, }, // Asia/Urumqi
    {   73, 8740,   45651,  4, }, // Asia/Ust-Nera
    {   73, 4729,   45655,  3, }, // Asia/Vladivostok
    {   73, 4847,   45658,  4, }, // Asia/Yakutsk
    {   73, 3902,   45662,  5, }, // Asia/Yekaterinburg
    {   73, 3766,   45667,  3, }, // Asia/Yerevan
    {   73, 3682,   45670,  5, }, // Atlantic/Azores
    {   73, 5690,   45675,  3, }, // Atlantic/Bermuda
    {   73, 6647,   45678,  3, }, // Atlantic/Canary
    {   73, 3746,   45681,  3, }, // Atlantic/Cape_Verde
    {   73, 1397,   45684,  4, }, // Atlantic/Faroe
    {   73, 8754,   45688,  5, }, // Atlantic/Madeira
    {   73, 2750,   45693,  5, }, // Atlantic/Reykjavik
    {   73, 7272,   45698,  4, }, // Atlantic/South_Georgia
    {   73, 6840,   45702,  5, }, // Atlantic/St_Helena
    {   73, 1801,   45707,  5, }, // Australia/Broken_Hill
    {   73, 1585,   45712,  3, }, // Australia/Darwin
    {   73, 1549,   45715,  4, }, // Australia/Lord_Howe
    {   73, 1729,   45719,  3, }, // Australia/Melbourne
    {   73, 6235,   45722,  3, }, // Europe/Andorra
    {   73, 6355,   45725,  4, }, // Europe/Belgrade
    {   73, 2169,   45729,  4, }, // Europe/Brussels
    {   73, 3825,   45733,  4, }, // Europe/Budapest
    {   73, 2340,   44626,  3, }, // Europe/Dublin
    {   73, 6326,   45737,  4, }, // Europe/Gibraltar
    {   73, 8806,   45741,  3, }, // Europe/Guernsey
    {   73, 6631,   45744,  4, }, // Europe/Helsinki
    {   73, 8822,   45748,  2, }, // Europe/Isle_of_Man
    {   73, 8841,   45750,  3, }, // Europe/Jersey
    {   73, 3998,   45753,  5, }, // Europe/Kaliningrad
    {   73, 2529,   45758,  2, }, // Europe/Kyiv
    {   73, 6525,   45760,  4, }, // Europe/Ljubljana
    {   73, 2503,   45764,  2, }, // Europe/London
    {   73, 6384,   45766,  3, }, // Europe/Luxembourg
    {   73, 4911,   45769,  3, }, // Europe/Madrid
    {   73, 6416,   45772,  3, }, // Europe/Malta
    {   73, 6601,   45775,  3, }, // Europe/Mariehamn
    {   73, 6429,   45778,  3, }, // Europe/Monaco
    {   73, 6477,   45781,  3, }, // Europe/Oslo
    {   73, 6343,   45784,  2, }, // Europe/Rome
    {   73, 4350,   45786,  3, }, // Europe/Samara
    {   73, 6489,   45789,  4, }, // Europe/San_Marino
    {   73, 4470,   45793,  4, }, // Europe/Saratov
    {   73, 6618,   45797,  3, }, // Europe/Sofia
    {   73, 6542,   45800,  5, }, // Europe/Stockholm
    {   73, 8913,   45805,  7, }, // Europe/Ulyanovsk
    {   73, 6371,   45812,  3, }, // Europe/Vaduz
    {   73, 6586,   45815,  3, }, // Europe/Vatican
    {   73, 6250,   45818,  3, }, // Europe/Vienna
    {   73, 8930,   45821,  4, }, // Europe/Vilnius
    {   73, 4746,   45825,  5, }, // Europe/Volgograd
    {   73, 3209,   45830,  2, }, // Europe/Warsaw
    {   73, 6559,   45832,  3, }, // Europe/Zurich
    {   73, 6065,   45835,  3, }, // Indian/Christmas
    {   73, 6082,   45838,  5, }, // Indian/Cocos
    {   73, 5048,   45843,  5, }, // Indian/Comoro
    {   73, 6680,   45848,  5, }, // Indian/Kerguelen
    {   73, 7260,   45853,  3, }, // Indian/Mahe
    {   73, 7069,   45856,  4, }, // Indian/Maldives
    {   73, 5117,   45860,  4, }, // Indian/Mayotte
    {   73, 7211,   45864,  4, }, // Indian/Reunion
    {   73, 4441,   45868,  3, }, // Pacific/Apia
    {   73, 3009,   45871,  3, }, // Pacific/Auckland
    {   73, 3725,   45874,  4, }, // Pacific/Bougainville
    {   73, 2239,   45878,  3, }, // Pacific/Easter
    {   73, 3921,   45881,  2, }, // Pacific/Fiji
    {   73, 6697,   45883,  6, }, // Pacific/Galapagos
    {   73, 6715,   45889,  5, }, // Pacific/Gambier
    {   73, 3841,   45894,  6, }, // Pacific/Guadalcanal
    {   73, 6037,   45900,  2, }, // Pacific/Guam
    {   73, 3068,   45902,  2, }, // Pacific/Kanton
    {   73, 4017,   45904,  6, }, // Pacific/Kiritimati
    {   73, 2844,   45910,  4, }, // Pacific/Kwajalein
    {   73, 4896,   45914,  3, }, // Pacific/Majuro
    {   73, 4070,   45917,  5, }, // Pacific/Marquesas
    {   73, 8945,   45922,  3, }, // Pacific/Midway
    {   73, 7103,   45925,  2, }, // Pacific/Nauru
    {   73, 7132,   45927,  3, }, // Pacific/Niue
    {   73, 4187,   45930,  3, }, // Pacific/Norfolk
    {   73, 7117,   45933,  3, }, // Pacific/Noumea
    {   73, 7194,   45936,  5, }, // Pacific/Pitcairn
    {   73, 3115,   45941,  3, }, // Pacific/Pohnpei
    {   73, 6095,   45944,  4, }, // Pacific/Rarotonga
    {   73, 4602,   45948,  5, }, // Pacific/Tongatapu
    {   76, 5078,    4428, 11, }, // Africa/Addis_Ababa Catalan/Latin/Spain
    {   76, 7420,   45953,  5, }, // Africa/Algiers
    {   76,   14,       0,  6, }, // Africa/Asmara
    {   76, 2322,   45958,  9, }, // Africa/Cairo
    {   76, 5185,   45967,  8, }, // Africa/El_Aaiun
    {   76, 4543,   28878,  7, }, // Africa/Khartoum
    {   76, 6888,      14,  4, }, // Africa/Lome
    {   76, 5132,   45975, 10, }, // Africa/Mogadishu
    {   76, 7053,   45985,  8, }, // Africa/Monrovia
    {   76, 5290,      18,  9, }, // Africa/Ndjamena
    {   76, 4454,      27,  8, }, // Africa/Sao_Tome
    {   76, 2868,   21148,  7, }, // Africa/Tripoli
    {   76, 4573,      35,  9, }, // America/Araguaina
    {   76,  270,      44,  7, }, // America/Argentina/Cordoba
    {   76, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   76, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   76, 4271,      70,  8, }, // America/Asuncion
    {   76,  237,      78,  8, }, // America/Atikokan
    {   76, 7623,      86, 17, }, // America/Bahia_Banderas
    {   76, 7646,     103,  5, }, // America/Belem
    {   76, 7660,   45993, 12, }, // America/Blanc-Sablon
    {   76, 4380,   46005,  6, }, // America/Bogota
    {   76, 3887,   35352,  6, }, // America/Cancun
    {   76, 4364,   46011,  6, }, // America/Cayenne
    {   76, 5515,   46017,  6, }, // America/Cayman
    {   76, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   76, 3810,     133,  6, }, // America/Cuiaba
    {   76, 5742,     139,  7, }, // America/Curacao
    {   76, 7887,     146,  8, }, // America/Eirunepe
    {   76,  481,     154, 13, }, // America/Indiana/Knox
    {   76, 7979,     167, 16, }, // America/Indiana/Marengo
    {   76, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   76, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   76, 8056,     220, 14, }, // America/Indiana/Vevay
    {   76, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   76, 8104,     252, 16, }, // America/Indiana/Winamac
    {   76, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   76, 5951,     288, 22, }, // America/Lower_Princes
    {   76, 8171,     310,  6, }, // America/Maceio
    {   76, 5824,   21215,  9, }, // America/Martinique
    {   76, 2919,     316,  8, }, // America/Mazatlan
    {   76, 8238,     324,  6, }, // America/Merida
    {   76, 2951,   46023, 15, }, // America/Mexico_City
    {   76, 4410,     341, 12, }, // America/Miquelon
    {   76, 2381,   46038,  9, }, // America/New_York
    {   76, 1852,     353, 19, }, // America/Noronha
    {   76, 8319,   46047, 23, }, // America/North_Dakota/Beulah
    {   76, 8347,   46070, 23, }, // America/North_Dakota/Center
    {   76, 8375,   46093, 26, }, // America/North_Dakota/New_Salem
    {   76,  393,     435,  4, }, // America/Nuuk
    {   76, 2358,   46119,  6, }, // America/Panama
    {   76, 8495,     439,  8, }, // America/Santarem
    {   76, 1880,     447,  9, }, // America/Sao_Paulo
    {   76, 6918,   46125, 12, }, // America/Scoresbysund
    {   76, 8526,   46137, 16, }, // America/St_Barthelemy
    {   76, 2063,   29057, 12, }, // America/St_Johns
    {   76, 5882,   29069, 11, }, // America/St_Kitts
    {   76, 5899,   37943, 11, }, // America/St_Lucia
    {   76,  855,   46153, 12, }, // America/St_Thomas
    {   76, 5932,   29103, 13, }, // America/St_Vincent
    {   76, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   76, 7295,     643,  5, }, // Antarctica/Syowa
    {   76, 5530,   46165,  6, }, // Asia/Anadyr
    {   76, 5542,   46171,  5, }, // Asia/Aqtau
    {   76, 5387,   46176,  6, }, // Asia/Aqtobe
    {   76,  966,   46182,  7, }, // Asia/Ashgabat
    {   76, 8642,   46189,  6, }, // Asia/Atyrau
    {   76, 3626,    4802,  6, }, // Asia/Baghdad
    {   76, 3672,   21408,  4, }, // Asia/Baku
    {   76, 3590,   46195,  7, }, // Asia/Barnaul
    {   76, 4620,   46202,  5, }, // Asia/Chita
    {   76, 4559,   21418,  6, }, // Asia/Damascus
    {   76, 6178,   46207,  8, }, // Asia/Dushanbe
    {   76, 1261,   46215, 11, }, // Asia/Ho_Chi_Minh
    {   76, 4790,     704,  5, }, // Asia/Hovd
    {   76, 7011,   46226,  6, }, // Asia/Jayapura
    {   76, 4335,   29155,  9, }, // Asia/Kamchatka
    {   76, 1187,   21491,  8, }, // Asia/Kathmandu
    {   76,  994,   21499,  7, }, // Asia/Kolkata
    {   76, 4216,   29186, 11, }, // Asia/Krasnoyarsk
    {   76, 1213,    4961,  5, }, // Asia/Macau
    {   76, 6939,   38033,  6, }, // Asia/Muscat
    {   76, 2556,   46232,  7, }, // Asia/Nicosia
    {   76, 4154,   46239, 12, }, // Asia/Novosibirsk
    {   76, 8726,   46251,  8, }, // Asia/Qostanay
    {   76, 3603,    8440,  4, }, // Asia/Riyadh
    {   76, 4427,   46259,  8, }, // Asia/Sakhalin
    {   76, 7245,   21547, 10, }, // Asia/Samarkand
    {   76, 3298,   46267,  4, }, // Asia/Seoul
    {   76, 3319,   21561,  8, }, // Asia/Singapore
    {   76, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {   76, 4800,   46271,  8, }, // Asia/Tashkent
    {   76, 2774,    8495,  7, }, // Asia/Tehran
    {   76, 2823,   46279,  6, }, // Asia/Tokyo
    {   76, 1161,   46285,  7, }, // Asia/Urumqi
    {   76, 8740,   46292,  9, }, // Asia/Ust-Nera
    {   76, 4847,   46301,  7, }, // Asia/Yakutsk
    {   76, 1237,     753,  6, }, // Asia/Yangon
    {   76, 3902,   46308, 13, }, // Asia/Yekaterinburg
    {   76, 3682,   46321,  6, }, // Atlantic/Azores
    {   76, 5690,   46327,  8, }, // Atlantic/Bermuda
    {   76, 6647,   46335, 14, }, // Atlantic/Canary
    {   76, 3746,   46349,  8, }, // Atlantic/Cape_Verde
    {   76, 1397,   46357, 11, }, // Atlantic/Faroe
    {   76, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {   76, 7272,   46368, 15, }, // Atlantic/South_Georgia
    {   76, 6840,   46383, 12, }, // Atlantic/St_Helena
    {   76, 3639,   46395,  8, }, // Europe/Astrakhan
    {   76, 2302,   21699,  6, }, // Europe/Athens
    {   76, 6355,   29315,  7, }, // Europe/Belgrade
    {   76, 4776,   21712,  6, }, // Europe/Berlin
    {   76, 2169,   46403, 11, }, // Europe/Brussels
    {   76, 3947,   21726,  8, }, // Europe/Bucharest
    {   76, 8790,     799,  8, }, // Europe/Busingen
    {   76, 2585,     807,  8, }, // Europe/Chisinau
    {   76, 6308,   46414, 11, }, // Europe/Copenhagen
    {   76, 2340,   21744,  6, }, // Europe/Dublin
    {   76, 6631,   46425,  8, }, // Europe/Helsinki
    {   76, 8822,    5132,  3, }, // Europe/Isle_of_Man
    {   76, 8855,   46433,  5, }, // Europe/Kirov
    {   76, 2529,   46438,  4, }, // Europe/Kyiv
    {   76, 3232,   21790,  6, }, // Europe/Lisbon
    {   76, 2503,   21805,  7, }, // Europe/London
    {   76, 6384,    5153,  9, }, // Europe/Luxembourg
    {   76, 6429,   46442,  6, }, // Europe/Monaco
    {   76, 3556,   46448,  6, }, // Europe/Moscow
    {   76, 4303,   21833,  5, }, // Europe/Paris
    {   76, 6294,   21838,  5, }, // Europe/Prague
    {   76, 6343,   21843,  4, }, // Europe/Rome
    {   76, 4470,   46454,  7, }, // Europe/Saratov
    {   76, 8880,   46461, 10, }, // Europe/Simferopol
    {   76, 6542,   21861,  8, }, // Europe/Stockholm
    {   76, 6221,     819,  6, }, // Europe/Tirane
    {   76, 8913,   46471,  9, }, // Europe/Ulyanovsk
    {   76, 6586,   46480,  6, }, // Europe/Vatican
    {   76, 6250,   21881,  5, }, // Europe/Vienna
    {   76, 8930,   46486,  7, }, // Europe/Vilnius
    {   76, 3209,   46493,  8, }, // Europe/Warsaw
    {   76, 6559,   46501,  5, }, // Europe/Zurich
    {   76, 5048,    4421,  7, }, // Indian/Comoro
    {   76, 7260,     896,  4, }, // Indian/Mahe
    {   76, 4088,   21903,  7, }, // Indian/Mauritius
    {   76, 7211,   21911,  6, }, // Indian/Reunion
    {   76, 3176,     922,  5, }, // Pacific/Chuuk
    {   76, 2239,   46506, 14, }, // Pacific/Easter
    {   76, 6697,     940,  9, }, // Pacific/Galapagos
    {   76, 2725,    5251,  8, }, // Pacific/Honolulu
    {   76, 3068,     957,  6, }, // Pacific/Kanton
    {   76, 4070,   46520,  9, }, // Pacific/Marquesas
    {   76, 7117,    1028,  6, }, // Pacific/Noumea
    {   76, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   76, 7312,   46529,  6, }, // Pacific/Tahiti
    {   76, 7405,    1068, 15, }, // Pacific/Wallis
    {   80,   14,       0,  6, }, // Africa/Asmara Cebuano/Latin/Philippines
    {   80, 5185,       6,  8, }, // Africa/El_Aaiun
    {   80, 6888,      14,  4, }, // Africa/Lome
    {   80, 5290,      18,  9, }, // Africa/Ndjamena
    {   80, 4454,      27,  8, }, // Africa/Sao_Tome
    {   80, 4573,      35,  9, }, // America/Araguaina
    {   80,  270,      44,  7, }, // America/Argentina/Cordoba
    {   80, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   80, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   80, 4271,      70,  8, }, // America/Asuncion
    {   80,  237,      78,  8, }, // America/Atikokan
    {   80, 7623,      86, 17, }, // America/Bahia_Banderas
    {   80, 7646,     103,  5, }, // America/Belem
    {   80, 4380,     108,  6, }, // America/Bogota
    {   80, 3887,     114,  6, }, // America/Cancun
    {   80, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   80, 3810,     133,  6, }, // America/Cuiaba
    {   80, 5742,     139,  7, }, // America/Curacao
    {   80, 7887,     146,  8, }, // America/Eirunepe
    {   80,  481,     154, 13, }, // America/Indiana/Knox
    {   80, 7979,     167, 16, }, // America/Indiana/Marengo
    {   80, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   80, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   80, 8056,     220, 14, }, // America/Indiana/Vevay
    {   80, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   80, 8104,     252, 16, }, // America/Indiana/Winamac
    {   80, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   80, 5951,     288, 22, }, // America/Lower_Princes
    {   80, 8171,     310,  6, }, // America/Maceio
    {   80, 2919,     316,  8, }, // America/Mazatlan
    {   80, 8238,     324,  6, }, // America/Merida
    {   80, 2951,    4381, 16, }, // America/Mexico_City
    {   80, 4410,     341, 12, }, // America/Miquelon
    {   80, 1852,     353, 19, }, // America/Noronha
    {   80, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   80, 8347,     392, 20, }, // America/North_Dakota/Center
    {   80, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   80,  393,     435,  4, }, // America/Nuuk
    {   80, 8495,     439,  8, }, // America/Santarem
    {   80, 1880,     447,  9, }, // America/Sao_Paulo
    {   80, 6918,     456, 16, }, // America/Scoresbysund
    {   80, 8526,     472, 14, }, // America/St_Barthelemy
    {   80, 2063,     486, 10, }, // America/St_Johns
    {   80, 5882,     496,  9, }, // America/St_Kitts
    {   80, 5899,     505,  9, }, // America/St_Lucia
    {   80,  855,     514, 10, }, // America/St_Thomas
    {   80, 5932,     524, 11, }, // America/St_Vincent
    {   80, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   80, 7295,     643,  5, }, // Antarctica/Syowa
    {   80, 1261,     688, 16, }, // Asia/Ho_Chi_Minh
    {   80, 4790,     704,  5, }, // Asia/Hovd
    {   80, 1187,     709,  9, }, // Asia/Kathmandu
    {   80,  994,     718,  7, }, // Asia/Kolkata
    {   80, 1213,     725,  5, }, // Asia/Macau
    {   80, 1161,     747,  6, }, // Asia/Urumqi
    {   80, 1237,     753,  6, }, // Asia/Yangon
    {   80, 6647,    4413,  8, }, // Atlantic/Canary
    {   80, 1397,     767,  5, }, // Atlantic/Faroe
    {   80, 6840,     773, 10, }, // Atlantic/St_Helena
    {   80, 8790,     799,  8, }, // Europe/Busingen
    {   80, 2585,     807,  8, }, // Europe/Chisinau
    {   80, 2529,     815,  4, }, // Europe/Kyiv
    {   80, 6221,     819,  6, }, // Europe/Tirane
    {   80, 5048,    4421,  7, }, // Indian/Comoro
    {   80, 7260,     896,  4, }, // Indian/Mahe
    {   80, 7211,     900,  7, }, // Indian/Reunion
    {   80, 3176,     922,  5, }, // Pacific/Chuuk
    {   80, 6697,     940,  9, }, // Pacific/Galapagos
    {   80, 3068,     957,  6, }, // Pacific/Kanton
    {   80, 7117,    1028,  6, }, // Pacific/Noumea
    {   80, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   80, 7405,    1068, 15, }, // Pacific/Wallis
    {   81,   14,       0,  6, }, // Africa/Asmara Central Atlas Tamazight/Latin/Morocco
    {   81, 5185,       6,  8, }, // Africa/El_Aaiun
    {   81, 6888,      14,  4, }, // Africa/Lome
    {   81, 5290,      18,  9, }, // Africa/Ndjamena
    {   81, 4454,      27,  8, }, // Africa/Sao_Tome
    {   81, 4573,      35,  9, }, // America/Araguaina
    {   81,  270,      44,  7, }, // America/Argentina/Cordoba
    {   81, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   81, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   81, 4271,      70,  8, }, // America/Asuncion
    {   81,  237,      78,  8, }, // America/Atikokan
    {   81, 7623,      86, 17, }, // America/Bahia_Banderas
    {   81, 7646,     103,  5, }, // America/Belem
    {   81, 4380,     108,  6, }, // America/Bogota
    {   81, 3887,     114,  6, }, // America/Cancun
    {   81, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   81, 3810,     133,  6, }, // America/Cuiaba
    {   81, 5742,     139,  7, }, // America/Curacao
    {   81, 7887,     146,  8, }, // America/Eirunepe
    {   81,  481,     154, 13, }, // America/Indiana/Knox
    {   81, 7979,     167, 16, }, // America/Indiana/Marengo
    {   81, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   81, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   81, 8056,     220, 14, }, // America/Indiana/Vevay
    {   81, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   81, 8104,     252, 16, }, // America/Indiana/Winamac
    {   81, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   81, 5951,     288, 22, }, // America/Lower_Princes
    {   81, 8171,     310,  6, }, // America/Maceio
    {   81, 2919,     316,  8, }, // America/Mazatlan
    {   81, 8238,     324,  6, }, // America/Merida
    {   81, 2951,    4381, 16, }, // America/Mexico_City
    {   81, 4410,     341, 12, }, // America/Miquelon
    {   81, 1852,     353, 19, }, // America/Noronha
    {   81, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   81, 8347,     392, 20, }, // America/North_Dakota/Center
    {   81, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   81,  393,     435,  4, }, // America/Nuuk
    {   81, 8495,     439,  8, }, // America/Santarem
    {   81, 1880,     447,  9, }, // America/Sao_Paulo
    {   81, 6918,     456, 16, }, // America/Scoresbysund
    {   81, 8526,     472, 14, }, // America/St_Barthelemy
    {   81, 2063,     486, 10, }, // America/St_Johns
    {   81, 5882,     496,  9, }, // America/St_Kitts
    {   81, 5899,     505,  9, }, // America/St_Lucia
    {   81,  855,     514, 10, }, // America/St_Thomas
    {   81, 5932,     524, 11, }, // America/St_Vincent
    {   81, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   81, 7295,     643,  5, }, // Antarctica/Syowa
    {   81, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   81, 4790,     704,  5, }, // Asia/Hovd
    {   81, 1187,     709,  9, }, // Asia/Kathmandu
    {   81,  994,     718,  7, }, // Asia/Kolkata
    {   81, 1213,     725,  5, }, // Asia/Macau
    {   81, 1161,     747,  6, }, // Asia/Urumqi
    {   81, 1237,     753,  6, }, // Asia/Yangon
    {   81, 6647,    4413,  8, }, // Atlantic/Canary
    {   81, 1397,     767,  5, }, // Atlantic/Faroe
    {   81, 6840,     773, 10, }, // Atlantic/St_Helena
    {   81, 8790,     799,  8, }, // Europe/Busingen
    {   81, 2585,     807,  8, }, // Europe/Chisinau
    {   81, 2529,     815,  4, }, // Europe/Kyiv
    {   81, 6221,     819,  6, }, // Europe/Tirane
    {   81, 5048,    4421,  7, }, // Indian/Comoro
    {   81, 7260,     896,  4, }, // Indian/Mahe
    {   81, 7211,     900,  7, }, // Indian/Reunion
    {   81, 3176,     922,  5, }, // Pacific/Chuuk
    {   81, 6697,     940,  9, }, // Pacific/Galapagos
    {   81, 3068,     957,  6, }, // Pacific/Kanton
    {   81, 7117,    1028,  6, }, // Pacific/Noumea
    {   81, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   81, 7405,    1068, 15, }, // Pacific/Wallis
    {   82,   14,       0,  6, }, // Africa/Asmara Central Kurdish/Arabic/Iraq
    {   82, 5185,       6,  8, }, // Africa/El_Aaiun
    {   82, 6888,      14,  4, }, // Africa/Lome
    {   82, 5290,      18,  9, }, // Africa/Ndjamena
    {   82, 4454,      27,  8, }, // Africa/Sao_Tome
    {   82, 4573,      35,  9, }, // America/Araguaina
    {   82,  270,      44,  7, }, // America/Argentina/Cordoba
    {   82, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   82, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   82, 4271,      70,  8, }, // America/Asuncion
    {   82,  237,      78,  8, }, // America/Atikokan
    {   82, 7623,      86, 17, }, // America/Bahia_Banderas
    {   82, 7646,     103,  5, }, // America/Belem
    {   82, 4380,     108,  6, }, // America/Bogota
    {   82, 3887,     114,  6, }, // America/Cancun
    {   82, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   82, 3810,     133,  6, }, // America/Cuiaba
    {   82, 5742,     139,  7, }, // America/Curacao
    {   82, 7887,     146,  8, }, // America/Eirunepe
    {   82,  481,     154, 13, }, // America/Indiana/Knox
    {   82, 7979,     167, 16, }, // America/Indiana/Marengo
    {   82, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   82, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   82, 8056,     220, 14, }, // America/Indiana/Vevay
    {   82, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   82, 8104,     252, 16, }, // America/Indiana/Winamac
    {   82, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   82, 5951,     288, 22, }, // America/Lower_Princes
    {   82, 8171,     310,  6, }, // America/Maceio
    {   82, 2919,     316,  8, }, // America/Mazatlan
    {   82, 8238,     324,  6, }, // America/Merida
    {   82, 2951,    4381, 16, }, // America/Mexico_City
    {   82, 4410,     341, 12, }, // America/Miquelon
    {   82, 1852,     353, 19, }, // America/Noronha
    {   82, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   82, 8347,     392, 20, }, // America/North_Dakota/Center
    {   82, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   82,  393,     435,  4, }, // America/Nuuk
    {   82, 8495,     439,  8, }, // America/Santarem
    {   82, 1880,     447,  9, }, // America/Sao_Paulo
    {   82, 6918,     456, 16, }, // America/Scoresbysund
    {   82, 8526,     472, 14, }, // America/St_Barthelemy
    {   82, 2063,     486, 10, }, // America/St_Johns
    {   82, 5882,     496,  9, }, // America/St_Kitts
    {   82, 5899,     505,  9, }, // America/St_Lucia
    {   82,  855,     514, 10, }, // America/St_Thomas
    {   82, 5932,     524, 11, }, // America/St_Vincent
    {   82, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   82, 7295,     643,  5, }, // Antarctica/Syowa
    {   82, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   82, 4790,     704,  5, }, // Asia/Hovd
    {   82, 1187,     709,  9, }, // Asia/Kathmandu
    {   82,  994,     718,  7, }, // Asia/Kolkata
    {   82, 1213,     725,  5, }, // Asia/Macau
    {   82, 1161,     747,  6, }, // Asia/Urumqi
    {   82, 1237,     753,  6, }, // Asia/Yangon
    {   82, 6647,    4413,  8, }, // Atlantic/Canary
    {   82, 1397,     767,  5, }, // Atlantic/Faroe
    {   82, 6840,     773, 10, }, // Atlantic/St_Helena
    {   82, 8790,     799,  8, }, // Europe/Busingen
    {   82, 2585,     807,  8, }, // Europe/Chisinau
    {   82, 2529,     815,  4, }, // Europe/Kyiv
    {   82, 6221,     819,  6, }, // Europe/Tirane
    {   82, 5048,    4421,  7, }, // Indian/Comoro
    {   82, 7260,     896,  4, }, // Indian/Mahe
    {   82, 7211,     900,  7, }, // Indian/Reunion
    {   82, 3176,     922,  5, }, // Pacific/Chuuk
    {   82, 6697,     940,  9, }, // Pacific/Galapagos
    {   82, 3068,     957,  6, }, // Pacific/Kanton
    {   82, 7117,    1028,  6, }, // Pacific/Noumea
    {   82, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   82, 7405,    1068, 15, }, // Pacific/Wallis
    {   84, 6807,   46535, 16, }, // Africa/Abidjan Chakma/Chakma/Bangladesh
    {   84, 6779,   46551,  8, }, // Africa/Accra
    {   84, 5078,   46559, 21, }, // Africa/Addis_Ababa
    {   84, 7420,   46580, 20, }, // Africa/Algiers
    {   84,   14,   46600, 16, }, // Africa/Asmara
    {   84,   44,   46616, 12, }, // Africa/Bamako
    {   84, 5276,   46628, 12, }, // Africa/Bangui
    {   84, 6765,   46640, 12, }, // Africa/Banjul
    {   84, 7435,   46652,  8, }, // Africa/Bissau
    {   84, 4976,   46660, 24, }, // Africa/Blantyre
    {   84, 5306,   46684, 18, }, // Africa/Brazzaville
    {   84, 4941,   46702, 24, }, // Africa/Bujumbura
    {   84, 2322,   46726, 10, }, // Africa/Cairo
    {   84, 4136,   46736, 14, }, // Africa/Casablanca
    {   84, 7449,   46750, 10, }, // Africa/Ceuta
    {   84, 6792,   46760, 14, }, // Africa/Conakry
    {   84, 6859,   46774,  8, }, // Africa/Dakar
    {   84, 5149,   46782, 24, }, // Africa/Dar_es_Salaam
    {   84, 5062,   46806, 12, }, // Africa/Djibouti
    {   84, 5262,   46818,  8, }, // Africa/Douala
    {   84, 5185,   46826, 27, }, // Africa/El_Aaiun
    {   84, 6872,   46853, 18, }, // Africa/Freetown
    {   84, 4925,   46871, 18, }, // Africa/Gaborone
    {   84, 5034,   46889,  8, }, // Africa/Harare
    {   84, 4498,   46897, 24, }, // Africa/Johannesburg
    {   84, 4518,   46921,  6, }, // Africa/Juba
    {   84, 5170,   46927, 10, }, // Africa/Kampala
    {   84, 4543,   46937, 14, }, // Africa/Khartoum
    {   84, 4992,   46951, 10, }, // Africa/Kigali
    {   84, 5325,   46961, 12, }, // Africa/Kinshasa
    {   84, 4763,   46973, 10, }, // Africa/Lagos
    {   84, 5355,   46983, 20, }, // Africa/Libreville
    {   84, 6888,   47003,  8, }, // Africa/Lome
    {   84, 5230,   47011, 12, }, // Africa/Luanda
    {   84, 4958,   47023, 18, }, // Africa/Lubumbashi
    {   84, 5020,   47041,  8, }, // Africa/Lusaka
    {   84, 5341,   47049,  8, }, // Africa/Malabo
    {   84, 5006,   47057, 10, }, // Africa/Maputo
    {   84, 5216,   47067, 14, }, // Africa/Maseru
    {   84, 5201,   47081, 16, }, // Africa/Mbabane
    {   84, 5132,   47097, 14, }, // Africa/Mogadishu
    {   84, 7053,   47111, 18, }, // Africa/Monrovia
    {   84, 3872,   47129, 12, }, // Africa/Nairobi
    {   84, 5290,   47141, 18, }, // Africa/Ndjamena
    {   84, 5373,   47159, 10, }, // Africa/Niamey
    {   84, 6822,   47169, 18, }, // Africa/Nouakchott
    {   84, 6746,   47187, 18, }, // Africa/Ouagadougou
    {   84, 5244,   47205, 21, }, // Africa/Porto-Novo
    {   84, 4454,   47226, 15, }, // Africa/Sao_Tome
    {   84, 2868,   47241, 16, }, // Africa/Tripoli
    {   84, 6573,   47257, 16, }, // Africa/Tunis
    {   84, 4171,   47273, 20, }, // Africa/Windhoek
    {   84,  132,   47293,  8, }, // America/Adak
    {   84, 3365,   47301, 20, }, // America/Anchorage
    {   84, 5626,   47321, 20, }, // America/Anguilla
    {   84, 5643,   47341, 22, }, // America/Antigua
    {   84, 4573,   47363, 14, }, // America/Araguaina
    {   84,  166,   47377, 31, }, // America/Argentina/Buenos_Aires
    {   84,   91,   47408, 16, }, // America/Argentina/Catamarca
    {   84,  270,   47424, 14, }, // America/Argentina/Cordoba
    {   84,  441,   47438, 12, }, // America/Argentina/Jujuy
    {   84, 7462,   47450, 13, }, // America/Argentina/La_Rioja
    {   84,  565,   47463, 14, }, // America/Argentina/Mendoza
    {   84, 7489,   47477, 23, }, // America/Argentina/Rio_Gallegos
    {   84, 7520,   47500, 12, }, // America/Argentina/Salta
    {   84, 7544,   47512, 17, }, // America/Argentina/San_Juan
    {   84, 5599,   47529, 17, }, // America/Argentina/San_Luis
    {   84, 7571,   47546, 14, }, // America/Argentina/Tucuman
    {   84, 7597,   47560, 12, }, // America/Argentina/Ushuaia
    {   84, 5659,   47572, 10, }, // America/Aruba
    {   84, 4271,   47582, 22, }, // America/Asuncion
    {   84,  237,   47604, 23, }, // America/Atikokan
    {   84, 3698,   47627,  8, }, // America/Bahia
    {   84, 7623,   47635, 25, }, // America/Bahia_Banderas
    {   84, 5673,   47660, 16, }, // America/Barbados
    {   84, 7646,   47676, 12, }, // America/Belem
    {   84, 5426,   47688, 12, }, // America/Belize
    {   84, 7660,   47700, 27, }, // America/Blanc-Sablon
    {   84, 7681,   47727, 15, }, // America/Boa_Vista
    {   84, 4380,   47742, 10, }, // America/Bogota
    {   84, 7699,   47752, 12, }, // America/Boise
    {   84, 7713,   47764, 25, }, // America/Cambridge_Bay
    {   84, 7735,   47789, 25, }, // America/Campo_Grande
    {   84, 3887,   47814, 18, }, // America/Cancun
    {   84, 4713,   47832, 14, }, // America/Caracas
    {   84, 4364,   47846, 10, }, // America/Cayenne
    {   84, 5515,   47856, 10, }, // America/Cayman
    {   84, 2262,   47866, 10, }, // America/Chicago
    {   84, 7756,   47876, 16, }, // America/Chihuahua
    {   84, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   84, 5441,   47892, 16, }, // America/Costa_Rica
    {   84, 7814,   47908, 18, }, // America/Creston
    {   84, 3810,   47926, 10, }, // America/Cuiaba
    {   84, 5742,   47936, 12, }, // America/Curacao
    {   84, 7830,   47948, 30, }, // America/Danmarkshavn
    {   84, 7851,   47978, 12, }, // America/Dawson
    {   84, 7866,   47990, 25, }, // America/Dawson_Creek
    {   84,  805,   48015, 14, }, // America/Denver
    {   84, 3484,   48029, 20, }, // America/Detroit
    {   84, 5758,   48049, 14, }, // America/Dominica
    {   84,  893,   48063, 24, }, // America/Edmonton
    {   84, 7887,   48087, 16, }, // America/Eirunepe
    {   84, 5460,   48103, 25, }, // America/El_Salvador
    {   84, 7904,   48128, 29, }, // America/Fort_Nelson
    {   84, 7924,   48157, 14, }, // America/Fortaleza
    {   84, 7942,   48171, 15, }, // America/Glace_Bay
    {   84, 6900,   48186, 13, }, // America/Goose_Bay
    {   84, 4631,   48199, 31, }, // America/Grand_Turk
    {   84, 5789,   48230, 12, }, // America/Grenada
    {   84, 5805,   48242, 16, }, // America/Guadeloupe
    {   84, 3779,   48258, 12, }, // America/Guatemala
    {   84, 4860,   48270, 20, }, // America/Guayaquil
    {   84, 6951,   48290,  6, }, // America/Guyana
    {   84, 1941,   48296, 24, }, // America/Halifax
    {   84, 2283,   48320,  6, }, // America/Havana
    {   84, 7960,   48326, 22, }, // America/Hermosillo
    {   84,  348,   48348, 28, }, // America/Indiana/Indianapolis
    {   84,  481,   48376, 30, }, // America/Indiana/Knox
    {   84, 7979,   48406, 32, }, // America/Indiana/Marengo
    {   84, 8003,   48438, 42, }, // America/Indiana/Petersburg
    {   84, 8030,   48480, 34, }, // America/Indiana/Tell_City
    {   84, 8056,   48514, 30, }, // America/Indiana/Vevay
    {   84, 8078,   48544, 42, }, // America/Indiana/Vincennes
    {   84, 8104,   48586, 38, }, // America/Indiana/Winamac
    {   84, 8128,   48624, 18, }, // America/Inuvik
    {   84,  660,   48642, 20, }, // America/Iqaluit
    {   84, 2801,   48662,  8, }, // America/Jamaica
    {   84, 5399,   48670,  8, }, // America/Juneau
    {   84,  521,   48678, 18, }, // America/Kentucky/Louisville
    {   84, 8143,   48696, 36, }, // America/Kentucky/Monticello
    {   84, 5723,   48732, 26, }, // America/Kralendijk
    {   84, 4395,   48758,  9, }, // America/La_Paz
    {   84, 7169,   48767,  6, }, // America/Lima
    {   84, 3258,   48773, 31, }, // America/Los_Angeles
    {   84, 5951,   48804, 48, }, // America/Lower_Princes
    {   84, 8171,   48852, 10, }, // America/Maceio
    {   84, 8186,   48862,  8, }, // America/Managua
    {   84, 1910,   48870, 12, }, // America/Manaus
    {   84, 5916,   48882, 10, }, // America/Marigot
    {   84, 5824,   48892, 18, }, // America/Martinique
    {   84, 8202,   48910, 16, }, // America/Matamoros
    {   84, 2919,   48926, 14, }, // America/Mazatlan
    {   84, 8220,   48940, 16, }, // America/Menominee
    {   84, 8238,   48956, 10, }, // America/Merida
    {   84, 8253,   48966, 16, }, // America/Metlakatla
    {   84, 2951,   48982, 29, }, // America/Mexico_City
    {   84, 4410,   49011, 16, }, // America/Miquelon
    {   84, 8272,   49027, 16, }, // America/Moncton
    {   84, 8288,   49043, 16, }, // America/Monterrey
    {   84, 4117,   49059, 24, }, // America/Montevideo
    {   84, 5843,   49083, 22, }, // America/Montserrat
    {   84, 5500,   49105,  8, }, // America/Nassau
    {   84, 2381,   49113, 24, }, // America/New_York
    {   84, 8306,   49137,  8, }, // America/Nome
    {   84, 1852,   49145, 14, }, // America/Noronha
    {   84, 8319,   49159, 37, }, // America/North_Dakota/Beulah
    {   84, 8347,   49196, 41, }, // America/North_Dakota/Center
    {   84, 8375,   49237, 46, }, // America/North_Dakota/New_Salem
    {   84,  393,   49283,  8, }, // America/Nuuk
    {   84, 8406,   49291, 14, }, // America/Ojinaga
    {   84, 2358,   49305,  6, }, // America/Panama
    {   84, 6192,   49311, 20, }, // America/Paramaribo
    {   84, 2975,   49331, 16, }, // America/Phoenix
    {   84, 3964,   49347, 34, }, // America/Port-au-Prince
    {   84, 5973,   49381, 34, }, // America/Port_of_Spain
    {   84, 8422,   49415, 25, }, // America/Porto_Velho
    {   84, 5862,   49440, 25, }, // America/Puerto_Rico
    {   84, 8442,   49465, 35, }, // America/Rankin_Inlet
    {   84, 8463,   49500, 12, }, // America/Recife
    {   84, 1997,   49512, 10, }, // America/Regina
    {   84, 8478,   49522, 16, }, // America/Resolute
    {   84,  695,   49538, 23, }, // America/Rio_Branco
    {   84, 8495,   49561, 20, }, // America/Santarem
    {   84, 2203,   49581, 16, }, // America/Santiago
    {   84, 6130,   49597, 29, }, // America/Santo_Domingo
    {   84, 1880,   49626, 17, }, // America/Sao_Paulo
    {   84, 6918,   49643, 36, }, // America/Scoresbysund
    {   84, 8512,   49679, 10, }, // America/Sitka
    {   84, 8526,   49689, 32, }, // America/St_Barthelemy
    {   84, 2063,   49721, 25, }, // America/St_Johns
    {   84, 5882,   49746, 26, }, // America/St_Kitts
    {   84, 5899,   49772, 24, }, // America/St_Lucia
    {   84,  855,   49796, 23, }, // America/St_Thomas
    {   84, 5932,   49819, 33, }, // America/St_Vincent
    {   84, 8548,   49852, 29, }, // America/Swift_Current
    {   84, 5480,   49881, 20, }, // America/Tegucigalpa
    {   84, 5775,   49901,  8, }, // America/Thule
    {   84,  313,   49909, 12, }, // America/Tijuana
    {   84,  608,   49921, 16, }, // America/Toronto
    {   84, 5707,   49937, 14, }, // America/Tortola
    {   84, 2095,   49951, 20, }, // America/Vancouver
    {   84, 2146,   49971, 22, }, // America/Whitehorse
    {   84,  734,   49993, 20, }, // America/Winnipeg
    {   84, 8570,   50013, 16, }, // America/Yakutat
    {   84, 6020,   50029, 12, }, // Antarctica/Casey
    {   84, 6113,   50041, 12, }, // Antarctica/Davis
    {   84, 6152,   50053, 37, }, // Antarctica/DumontDUrville
    {   84, 8586,   50090, 22, }, // Antarctica/Macquarie
    {   84, 7085,   50112, 12, }, // Antarctica/Mawson
    {   84,  932,   50124, 22, }, // Antarctica/McMurdo
    {   84, 8607,   50146, 12, }, // Antarctica/Palmer
    {   84, 7226,   50158, 10, }, // Antarctica/Rothera
    {   84, 7295,   50168,  6, }, // Antarctica/Syowa
    {   84, 8625,   50174, 12, }, // Antarctica/Troll
    {   84, 7374,   50186, 16, }, // Antarctica/Vostok
    {   84, 1431,   50202, 28, }, // Arctic/Longyearbyen
    {   84, 5589,   50230, 14, }, // Asia/Aden
    {   84, 5414,   50244, 12, }, // Asia/Almaty
    {   84, 3987,   50256, 14, }, // Asia/Amman
    {   84, 5530,   50270, 16, }, // Asia/Anadyr
    {   84, 5542,   50286, 12, }, // Asia/Aqtau
    {   84, 5387,   50298, 14, }, // Asia/Aqtobe
    {   84,  966,   50312, 16, }, // Asia/Ashgabat
    {   84, 3626,   50328, 12, }, // Asia/Baghdad
    {   84, 5553,   50340, 14, }, // Asia/Bahrain
    {   84, 3672,   47934,  6, }, // Asia/Baku
    {   84, 4485,   50354, 16, }, // Asia/Bangkok
    {   84, 3590,   50370, 14, }, // Asia/Barnaul
    {   84, 4105,   50384, 14, }, // Asia/Beirut
    {   84, 3797,   50398, 16, }, // Asia/Bishkek
    {   84, 6008,   50414, 14, }, // Asia/Brunei
    {   84, 4620,   50428,  6, }, // Asia/Chita
    {   84, 4530,   50434, 22, }, // Asia/Colombo
    {   84, 4559,   50456, 14, }, // Asia/Damascus
    {   84, 1095,   50470,  4, }, // Asia/Dhaka
    {   84, 6211,   50474,  8, }, // Asia/Dili
    {   84, 3615,   50482,  8, }, // Asia/Dubai
    {   84, 6178,   50490, 14, }, // Asia/Dushanbe
    {   84, 8669,   50504,  4, }, // Asia/Gaza
    {   84, 4814,   50508, 16, }, // Asia/Hebron
    {   84, 1261,   50524, 31, }, // Asia/Ho_Chi_Minh
    {   84, 2706,   50555, 13, }, // Asia/Hong_Kong
    {   84, 4790,   50568, 12, }, // Asia/Hovd
    {   84, 4203,   50580, 24, }, // Asia/Irkutsk
    {   84, 7025,   50604, 10, }, // Asia/Jakarta
    {   84, 7011,   50614, 12, }, // Asia/Jayapura
    {   84, 1292,   50626, 18, }, // Asia/Jerusalem
    {   84, 3579,   50644, 10, }, // Asia/Kabul
    {   84, 4335,   50654, 14, }, // Asia/Kamchatka
    {   84, 4258,   50668, 10, }, // Asia/Karachi
    {   84, 1187,   50678, 18, }, // Asia/Kathmandu
    {   84, 8679,   50696, 14, }, // Asia/Khandyga
    {   84,  994,   50710, 12, }, // Asia/Kolkata
    {   84, 4216,   50722, 28, }, // Asia/Krasnoyarsk
    {   84, 4878,   50750, 22, }, // Asia/Kuala_Lumpur
    {   84, 5995,   50772, 10, }, // Asia/Kuching
    {   84, 5566,   50782, 12, }, // Asia/Kuwait
    {   84, 1213,   50794, 12, }, // Asia/Macau
    {   84, 4036,   50806, 14, }, // Asia/Magadan
    {   84, 1351,   50820, 14, }, // Asia/Makassar
    {   84, 7182,   50834, 12, }, // Asia/Manila
    {   84, 6939,   50846, 12, }, // Asia/Muscat
    {   84, 2556,   50858, 14, }, // Asia/Nicosia
    {   84, 8693,   50872, 32, }, // Asia/Novokuznetsk
    {   84, 4154,   50904, 28, }, // Asia/Novosibirsk
    {   84, 4248,   50932, 16, }, // Asia/Omsk
    {   84, 7145,   50948, 10, }, // Asia/Oral
    {   84, 6980,   50958, 17, }, // Asia/Phnom_Penh
    {   84, 8711,   50975, 24, }, // Asia/Pontianak
    {   84, 4233,   50999, 21, }, // Asia/Pyongyang
    {   84, 5578,   51020,  8, }, // Asia/Qatar
    {   84, 4288,   51028, 18, }, // Asia/Qyzylorda
    {   84, 3603,   51046, 10, }, // Asia/Riyadh
    {   84, 4427,   51056, 12, }, // Asia/Sakhalin
    {   84, 7245,   51068, 24, }, // Asia/Samarkand
    {   84, 3298,   51092, 12, }, // Asia/Seoul
    {   84, 1055,   51104,  8, }, // Asia/Shanghai
    {   84, 3319,   51112, 18, }, // Asia/Singapore
    {   84, 4316,   51130, 40, }, // Asia/Srednekolymsk
    {   84, 3282,   51170, 12, }, // Asia/Taipei
    {   84, 4800,   51182, 18, }, // Asia/Tashkent
    {   84, 3934,   51200, 16, }, // Asia/Tbilisi
    {   84, 2774,   51216, 14, }, // Asia/Tehran
    {   84, 1319,   51230, 12, }, // Asia/Thimphu
    {   84, 2823,   51242, 12, }, // Asia/Tokyo
    {   84, 4591,   51254, 16, }, // Asia/Tomsk
    {   84, 1023,   51270, 18, }, // Asia/Ulaanbaatar
    {   84, 1161,   51288, 16, }, // Asia/Urumqi
    {   84, 8740,   51304, 19, }, // Asia/Ust-Nera
    {   84, 6996,   51323, 24, }, // Asia/Vientiane
    {   84, 4729,   51347, 26, }, // Asia/Vladivostok
    {   84, 4847,   51373, 18, }, // Asia/Yakutsk
    {   84, 1237,   51391, 16, }, // Asia/Yangon
    {   84, 3902,   51407, 32, }, // Asia/Yekaterinburg
    {   84, 3766,   51439, 16, }, // Asia/Yerevan
    {   84, 3682,   51455, 14, }, // Atlantic/Azores
    {   84, 5690,   51469, 12, }, // Atlantic/Bermuda
    {   84, 6647,   51481, 10, }, // Atlantic/Canary
    {   84, 3746,   51491, 19, }, // Atlantic/Cape_Verde
    {   84, 1397,   51510, 10, }, // Atlantic/Faroe
    {   84, 8754,   51520, 10, }, // Atlantic/Madeira
    {   84, 2750,   51530, 18, }, // Atlantic/Reykjavik
    {   84, 7272,   51548, 27, }, // Atlantic/South_Georgia
    {   84, 6840,   51575, 23, }, // Atlantic/St_Helena
    {   84, 6663,   51598, 14, }, // Atlantic/Stanley
    {   84, 1672,   51612, 20, }, // Australia/Adelaide
    {   84, 1637,   51632, 20, }, // Australia/Brisbane
    {   84, 1801,   51652, 25, }, // Australia/Broken_Hill
    {   84, 1585,   51677, 18, }, // Australia/Darwin
    {   84, 3656,   51695, 14, }, // Australia/Eucla
    {   84, 1518,   51709, 14, }, // Australia/Hobart
    {   84, 8771,   51723, 22, }, // Australia/Lindeman
    {   84, 1549,   51745, 19, }, // Australia/Lord_Howe
    {   84, 1729,   51764, 18, }, // Australia/Melbourne
    {   84, 1764,   51782, 10, }, // Australia/Perth
    {   84, 1465,   51792, 12, }, // Australia/Sydney
    {   84, 6460,   51804, 22, }, // Europe/Amsterdam
    {   84, 6235,   51826, 16, }, // Europe/Andorra
    {   84, 3639,   51842, 18, }, // Europe/Astrakhan
    {   84, 2302,   51860, 16, }, // Europe/Athens
    {   84, 6355,   51876, 20, }, // Europe/Belgrade
    {   84, 4776,   51896, 14, }, // Europe/Berlin
    {   84, 6507,   51910, 18, }, // Europe/Bratislava
    {   84, 2169,   51928, 18, }, // Europe/Brussels
    {   84, 3947,   51946, 18, }, // Europe/Bucharest
    {   84, 3825,   51964, 18, }, // Europe/Budapest
    {   84, 8790,   51982, 20, }, // Europe/Busingen
    {   84, 2585,   52002, 14, }, // Europe/Chisinau
    {   84, 6308,   52016, 24, }, // Europe/Copenhagen
    {   84, 2340,   52040, 14, }, // Europe/Dublin
    {   84, 6326,   52054, 20, }, // Europe/Gibraltar
    {   84, 8806,   52074, 16, }, // Europe/Guernsey
    {   84, 6631,   52090, 18, }, // Europe/Helsinki
    {   84, 8822,   52108, 28, }, // Europe/Isle_of_Man
    {   84, 1132,   52136, 22, }, // Europe/Istanbul
    {   84, 8841,   52158, 10, }, // Europe/Jersey
    {   84, 3998,   52168, 24, }, // Europe/Kaliningrad
    {   84, 8855,   52192, 12, }, // Europe/Kirov
    {   84, 2529,   52204, 12, }, // Europe/Kyiv
    {   84, 3232,   52216, 16, }, // Europe/Lisbon
    {   84, 6525,   52232, 16, }, // Europe/Ljubljana
    {   84, 2503,   52248, 16, }, // Europe/London
    {   84, 6384,   52264, 26, }, // Europe/Luxembourg
    {   84, 4911,   52290, 14, }, // Europe/Madrid
    {   84, 6416,   52304, 10, }, // Europe/Malta
    {   84, 6601,   52314, 22, }, // Europe/Mariehamn
    {   84, 3712,   52336, 16, }, // Europe/Minsk
    {   84, 6429,   52352, 10, }, // Europe/Monaco
    {   84, 3556,   52362, 12, }, // Europe/Moscow
    {   84, 6477,   52374, 12, }, // Europe/Oslo
    {   84, 4303,   52386, 14, }, // Europe/Paris
    {   84, 6443,   52400, 18, }, // Europe/Podgorica
    {   84, 6294,   52418, 10, }, // Europe/Prague
    {   84, 8868,   48884,  6, }, // Europe/Riga
    {   84, 6343,   52428,  8, }, // Europe/Rome
    {   84, 4350,   52436,  6, }, // Europe/Samara
    {   84, 6489,   52442, 19, }, // Europe/San_Marino
    {   84, 6264,   52461, 12, }, // Europe/Sarajevo
    {   84, 8880,   52473, 24, }, // Europe/Simferopol
    {   84, 6402,   52497, 16, }, // Europe/Skopje
    {   84, 6618,   52513, 10, }, // Europe/Sofia
    {   84, 6542,   52523, 20, }, // Europe/Stockholm
    {   84, 8898,   52543, 10, }, // Europe/Tallinn
    {   84, 6221,   52553,  8, }, // Europe/Tirane
    {   84, 8913,   52561, 26, }, // Europe/Ulyanovsk
    {   84, 6371,   52587, 10, }, // Europe/Vaduz
    {   84, 6586,   52597, 12, }, // Europe/Vatican
    {   84, 6250,   51323, 10, }, // Europe/Vienna
    {   84, 8930,   52609, 18, }, // Europe/Vilnius
    {   84, 4746,   52627, 22, }, // Europe/Volgograd
    {   84, 3209,   52649, 10, }, // Europe/Warsaw
    {   84, 6280,   52659, 14, }, // Europe/Zagreb
    {   84, 6559,   52673, 12, }, // Europe/Zurich
    {   84, 5097,   52685, 20, }, // Indian/Antananarivo
    {   84, 6966,   52705, 10, }, // Indian/Chagos
    {   84, 6065,   52715, 33, }, // Indian/Christmas
    {   84, 6082,   52748, 12, }, // Indian/Cocos
    {   84, 5048,   52760, 12, }, // Indian/Comoro
    {   84, 6680,   52772, 18, }, // Indian/Kerguelen
    {   84, 7260,   52790,  6, }, // Indian/Mahe
    {   84, 7069,   52796, 14, }, // Indian/Maldives
    {   84, 4088,   52810, 14, }, // Indian/Mauritius
    {   84, 5117,   52824, 10, }, // Indian/Mayotte
    {   84, 7211,   52834, 24, }, // Indian/Reunion
    {   84, 4441,   52858,  8, }, // Pacific/Apia
    {   84, 3009,   52866, 22, }, // Pacific/Auckland
    {   84, 3725,   52888, 20, }, // Pacific/Bougainville
    {   84, 3034,   52908, 12, }, // Pacific/Chatham
    {   84, 3176,   52920, 12, }, // Pacific/Chuuk
    {   84, 2239,   52932, 14, }, // Pacific/Easter
    {   84, 7360,   52946, 10, }, // Pacific/Efate
    {   84, 7327,   52956, 16, }, // Pacific/Fakaofo
    {   84, 3921,   52972,  8, }, // Pacific/Fiji
    {   84, 7343,   52980, 14, }, // Pacific/Funafuti
    {   84, 6697,   52994, 22, }, // Pacific/Galapagos
    {   84, 6715,   53016, 18, }, // Pacific/Gambier
    {   84, 3841,   53034, 20, }, // Pacific/Guadalcanal
    {   84, 6037,   53054,  8, }, // Pacific/Guam
    {   84, 2725,   53062, 16, }, // Pacific/Honolulu
    {   84, 3068,   53078, 20, }, // Pacific/Kanton
    {   84, 4017,   53098, 18, }, // Pacific/Kiritimati
    {   84, 7038,   53116, 14, }, // Pacific/Kosrae
    {   84, 2844,   53130, 16, }, // Pacific/Kwajalein
    {   84, 4896,   53146, 10, }, // Pacific/Majuro
    {   84, 4070,   53156, 16, }, // Pacific/Marquesas
    {   84, 8945,   53172, 16, }, // Pacific/Midway
    {   84, 7103,   53188, 10, }, // Pacific/Nauru
    {   84, 7132,   53198, 12, }, // Pacific/Niue
    {   84, 4187,   53210, 16, }, // Pacific/Norfolk
    {   84, 7117,   53226, 10, }, // Pacific/Noumea
    {   84, 3145,   53236, 21, }, // Pacific/Pago_Pago
    {   84, 7155,   53257,  8, }, // Pacific/Palau
    {   84, 7194,   53265, 22, }, // Pacific/Pitcairn
    {   84, 3115,   53287, 10, }, // Pacific/Pohnpei
    {   84, 4826,   53297, 29, }, // Pacific/Port_Moresby
    {   84, 6095,   53326, 14, }, // Pacific/Rarotonga
    {   84, 6050,   53340, 10, }, // Pacific/Saipan
    {   84, 7312,   53350, 10, }, // Pacific/Tahiti
    {   84, 6731,   53360,  6, }, // Pacific/Tarawa
    {   84, 4602,   53366, 14, }, // Pacific/Tongatapu
    {   84, 7392,   53380, 12, }, // Pacific/Wake
    {   84, 7405,   53392, 12, }, // Pacific/Wallis
    {   86, 6807,   27131,  7, }, // Africa/Abidjan Chechen/Cyrillic/Russia
    {   86, 6779,    1089,  5, }, // Africa/Accra
    {   86, 5078,    1094, 11, }, // Africa/Addis_Ababa
    {   86, 7420,    1105,  5, }, // Africa/Algiers
    {   86,   14,    1110,  6, }, // Africa/Asmara
    {   86,   44,    1116,  6, }, // Africa/Bamako
    {   86, 5276,    1122,  5, }, // Africa/Bangui
    {   86, 6765,    1127,  6, }, // Africa/Banjul
    {   86, 7435,    1133,  5, }, // Africa/Bissau
    {   86, 4976,   27144,  8, }, // Africa/Blantyre
    {   86, 5306,   27152, 10, }, // Africa/Brazzaville
    {   86, 4941,    1155,  9, }, // Africa/Bujumbura
    {   86, 2322,   53404,  8, }, // Africa/Cairo
    {   86, 4136,    1168, 10, }, // Africa/Casablanca
    {   86, 7449,    1178,  5, }, // Africa/Ceuta
    {   86, 6792,    1183,  7, }, // Africa/Conakry
    {   86, 6859,    1190,  5, }, // Africa/Dakar
    {   86, 5149,   27168, 12, }, // Africa/Dar_es_Salaam
    {   86, 5062,   27180,  7, }, // Africa/Djibouti
    {   86, 5262,    1213,  5, }, // Africa/Douala
    {   86, 5185,   27187,  7, }, // Africa/El_Aaiun
    {   86, 6872,    1225,  7, }, // Africa/Freetown
    {   86, 4925,    1232,  8, }, // Africa/Gaborone
    {   86, 5034,   27194,  6, }, // Africa/Harare
    {   86, 4498,   27200, 12, }, // Africa/Johannesburg
    {   86, 4518,   27212,  5, }, // Africa/Juba
    {   86, 5170,    1262,  7, }, // Africa/Kampala
    {   86, 4543,    1269,  6, }, // Africa/Khartoum
    {   86, 4992,    1275,  6, }, // Africa/Kigali
    {   86, 5325,    1281,  7, }, // Africa/Kinshasa
    {   86, 4763,    1288,  5, }, // Africa/Lagos
    {   86, 5355,   27217,  9, }, // Africa/Libreville
    {   86, 6888,    1301,  4, }, // Africa/Lome
    {   86, 5230,    1305,  6, }, // Africa/Luanda
    {   86, 4958,    1311,  9, }, // Africa/Lubumbashi
    {   86, 5020,    1320,  6, }, // Africa/Lusaka
    {   86, 5341,    1326,  6, }, // Africa/Malabo
    {   86, 5006,    1332,  6, }, // Africa/Maputo
    {   86, 5216,    1338,  6, }, // Africa/Maseru
    {   86, 5201,    1344,  7, }, // Africa/Mbabane
    {   86, 5132,    1351,  8, }, // Africa/Mogadishu
    {   86, 7053,    1359,  7, }, // Africa/Monrovia
    {   86, 3872,   27234,  7, }, // Africa/Nairobi
    {   86, 5290,   27241,  8, }, // Africa/Ndjamena
    {   86, 5373,   27249,  6, }, // Africa/Niamey
    {   86, 6822,    1387,  7, }, // Africa/Nouakchott
    {   86, 6746,    1394,  8, }, // Africa/Ouagadougou
    {   86, 5244,    1402, 10, }, // Africa/Porto-Novo
    {   86, 4454,    1412,  8, }, // Africa/Sao_Tome
    {   86, 2868,    1420,  7, }, // Africa/Tripoli
    {   86, 6573,    1427,  5, }, // Africa/Tunis
    {   86, 4171,    1432,  7, }, // Africa/Windhoek
    {   86,  132,    1439,  4, }, // America/Adak
    {   86, 3365,   27255,  8, }, // America/Anchorage
    {   86, 5626,   27263,  7, }, // America/Anguilla
    {   86, 5643,    1457,  7, }, // America/Antigua
    {   86, 4573,    1464,  9, }, // America/Araguaina
    {   86,  166,   27270, 12, }, // America/Argentina/Buenos_Aires
    {   86,   91,    1485,  9, }, // America/Argentina/Catamarca
    {   86,  270,    1494,  7, }, // America/Argentina/Cordoba
    {   86,  441,   27282,  5, }, // America/Argentina/Jujuy
    {   86, 7462,    1506,  8, }, // America/Argentina/La_Rioja
    {   86,  565,    1514,  7, }, // America/Argentina/Mendoza
    {   86, 7489,   27287, 12, }, // America/Argentina/Rio_Gallegos
    {   86, 7520,   27299,  6, }, // America/Argentina/Salta
    {   86, 7544,    1537,  8, }, // America/Argentina/San_Juan
    {   86, 5599,    1545,  8, }, // America/Argentina/San_Luis
    {   86, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {   86, 7597,   27305,  5, }, // America/Argentina/Ushuaia
    {   86, 5659,    1566,  5, }, // America/Aruba
    {   86, 4271,   27310,  8, }, // America/Asuncion
    {   86,  237,    1578, 12, }, // America/Atikokan
    {   86, 3698,    1590,  3, }, // America/Bahia
    {   86, 7623,   27330, 16, }, // America/Bahia_Banderas
    {   86, 5673,    1610,  8, }, // America/Barbados
    {   86, 7646,    1618,  5, }, // America/Belem
    {   86, 5426,    1623,  5, }, // America/Belize
    {   86, 7660,    1628, 12, }, // America/Blanc-Sablon
    {   86, 7681,    1640,  9, }, // America/Boa_Vista
    {   86, 4380,    1649,  6, }, // America/Bogota
    {   86, 7699,   27357,  5, }, // America/Boise
    {   86, 7713,   27362, 13, }, // America/Cambridge_Bay
    {   86, 7735,    1672, 12, }, // America/Campo_Grande
    {   86, 3887,    1684,  6, }, // America/Cancun
    {   86, 4713,    1690,  7, }, // America/Caracas
    {   86, 4364,   27375,  7, }, // America/Cayenne
    {   86, 5515,   27382,  6, }, // America/Cayman
    {   86, 2262,    1726,  6, }, // America/Chicago
    {   86, 7756,    1732,  6, }, // America/Chihuahua
    {   86, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   86, 5441,    1738, 10, }, // America/Costa_Rica
    {   86, 7814,    1748,  7, }, // America/Creston
    {   86, 3810,   27419,  5, }, // America/Cuiaba
    {   86, 5742,   27424,  7, }, // America/Curacao
    {   86, 7830,    1769, 12, }, // America/Danmarkshavn
    {   86, 7851,    1781,  6, }, // America/Dawson
    {   86, 7866,    1787, 11, }, // America/Dawson_Creek
    {   86,  805,    1798,  6, }, // America/Denver
    {   86, 3484,   27431,  7, }, // America/Detroit
    {   86, 5758,    1811,  8, }, // America/Dominica
    {   86,  893,   27438,  8, }, // America/Edmonton
    {   86, 7887,   27446,  8, }, // America/Eirunepe
    {   86, 5460,   27454,  9, }, // America/El_Salvador
    {   86, 7904,   27463, 12, }, // America/Fort_Nelson
    {   86, 7924,    1854,  9, }, // America/Fortaleza
    {   86, 7942,   27475,  9, }, // America/Glace_Bay
    {   86, 6900,   27484,  7, }, // America/Goose_Bay
    {   86, 4631,   36302, 10, }, // America/Grand_Turk
    {   86, 5789,    1889,  7, }, // America/Grenada
    {   86, 5805,    1896,  9, }, // America/Guadeloupe
    {   86, 3779,    1905,  9, }, // America/Guatemala
    {   86, 4860,   27491,  8, }, // America/Guayaquil
    {   86, 6951,   27499,  6, }, // America/Guyana
    {   86, 1941,   27505,  8, }, // America/Halifax
    {   86, 2283,    1936,  6, }, // America/Havana
    {   86, 7960,   27513,  9, }, // America/Hermosillo
    {   86,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {   86,  481,    1962,  4, }, // America/Indiana/Knox
    {   86, 7979,    1975,  7, }, // America/Indiana/Marengo
    {   86, 8003,   36389, 10, }, // America/Indiana/Petersburg
    {   86, 8030,    2010,  9, }, // America/Indiana/Tell_City
    {   86, 8056,   53412,  5, }, // America/Indiana/Vevay
    {   86, 8078,   38694,  7, }, // America/Indiana/Vincennes
    {   86, 8104,   36460,  7, }, // America/Indiana/Winamac
    {   86, 8128,    2049,  6, }, // America/Inuvik
    {   86,  660,    2055,  7, }, // America/Iqaluit
    {   86, 2801,   27570,  6, }, // America/Jamaica
    {   86, 5399,   27576,  5, }, // America/Juneau
    {   86,  521,    2073,  8, }, // America/Kentucky/Louisville
    {   86, 8143,    2081, 10, }, // America/Kentucky/Monticello
    {   86, 5723,   27581, 10, }, // America/Kralendijk
    {   86, 4395,    2111,  6, }, // America/La_Paz
    {   86, 7169,    2117,  4, }, // America/Lima
    {   86, 3258,   27591, 12, }, // America/Los_Angeles
    {   86, 5951,   53417, 21, }, // America/Lower_Princes
    {   86, 8171,   27621,  6, }, // America/Maceio
    {   86, 8186,    2156,  7, }, // America/Managua
    {   86, 1910,    2163,  6, }, // America/Manaus
    {   86, 5916,    2169,  6, }, // America/Marigot
    {   86, 5824,    2175,  9, }, // America/Martinique
    {   86, 8202,    2184,  9, }, // America/Matamoros
    {   86, 2919,    2193,  8, }, // America/Mazatlan
    {   86, 8220,    2201,  8, }, // America/Menominee
    {   86, 8238,    2209,  6, }, // America/Merida
    {   86, 8253,    2215, 10, }, // America/Metlakatla
    {   86, 2951,    2225,  6, }, // America/Mexico_City
    {   86, 4410,    2231,  7, }, // America/Miquelon
    {   86, 8272,    2238,  7, }, // America/Moncton
    {   86, 8288,   27635,  9, }, // America/Monterrey
    {   86, 4117,    2254, 10, }, // America/Montevideo
    {   86, 5843,   53438,  9, }, // America/Montserrat
    {   86, 5500,    2274,  6, }, // America/Nassau
    {   86, 2381,   27644,  8, }, // America/New_York
    {   86, 8306,    2288,  3, }, // America/Nome
    {   86, 1852,   53447,  7, }, // America/Noronha
    {   86, 8319,   53454, 24, }, // America/North_Dakota/Beulah
    {   86, 8347,   53478, 22, }, // America/North_Dakota/Center
    {   86, 8375,   27710,  9, }, // America/North_Dakota/New_Salem
    {   86,  393,   53500,  6, }, // America/Nuuk
    {   86, 8406,    2373,  7, }, // America/Ojinaga
    {   86, 2358,    2380,  6, }, // America/Panama
    {   86, 6192,    2386, 10, }, // America/Paramaribo
    {   86, 2975,    2396,  6, }, // America/Phoenix
    {   86, 3964,    2402, 12, }, // America/Port-au-Prince
    {   86, 5973,   27734, 13, }, // America/Port_of_Spain
    {   86, 8422,   27747, 11, }, // America/Porto_Velho
    {   86, 5862,   27758, 11, }, // America/Puerto_Rico
    {   86, 4049,    2449, 12, }, // America/Punta_Arenas
    {   86, 8442,    2461, 12, }, // America/Rankin_Inlet
    {   86, 8463,    2473,  6, }, // America/Recife
    {   86, 1997,   53506,  8, }, // America/Regina
    {   86, 8478,   38826,  7, }, // America/Resolute
    {   86,  695,    2494, 10, }, // America/Rio_Branco
    {   86, 8495,    2504,  8, }, // America/Santarem
    {   86, 2203,   27783,  8, }, // America/Santiago
    {   86, 6130,    2520, 13, }, // America/Santo_Domingo
    {   86, 1880,    2533,  9, }, // America/Sao_Paulo
    {   86, 6918,    2542, 11, }, // America/Scoresbysund
    {   86, 8512,    2553,  5, }, // America/Sitka
    {   86, 8526,   53514, 13, }, // America/St_Barthelemy
    {   86, 2063,   27791, 10, }, // America/St_Johns
    {   86, 5882,    2580,  9, }, // America/St_Kitts
    {   86, 5899,   27801,  9, }, // America/St_Lucia
    {   86,  855,    2600, 10, }, // America/St_Thomas
    {   86, 5932,    2610, 12, }, // America/St_Vincent
    {   86, 8548,   53527, 12, }, // America/Swift_Current
    {   86, 5480,   27811, 12, }, // America/Tegucigalpa
    {   86, 5775,    2646,  4, }, // America/Thule
    {   86,  313,    2650,  7, }, // America/Tijuana
    {   86,  608,    2657,  7, }, // America/Toronto
    {   86, 5707,    2664,  7, }, // America/Tortola
    {   86, 2095,    2671,  8, }, // America/Vancouver
    {   86, 2146,   27823,  8, }, // America/Whitehorse
    {   86,  734,    2687,  8, }, // America/Winnipeg
    {   86, 8570,   27831,  6, }, // America/Yakutat
    {   86, 6020,   27837,  5, }, // Antarctica/Casey
    {   86, 6113,   27852,  6, }, // Antarctica/Davis
    {   86, 6152,   27858, 14, }, // Antarctica/DumontDUrville
    {   86, 8586,    2728,  8, }, // Antarctica/Macquarie
    {   86, 7085,    2736,  6, }, // Antarctica/Mawson
    {   86,  932,    2742,  9, }, // Antarctica/McMurdo
    {   86, 8607,    2751,  6, }, // Antarctica/Palmer
    {   86, 7226,    2757,  6, }, // Antarctica/Rothera
    {   86, 7295,   27948,  4, }, // Antarctica/Syowa
    {   86, 8625,   27962,  6, }, // Antarctica/Troll
    {   86, 7374,   27978,  6, }, // Antarctica/Vostok
    {   86, 1431,   27994,  7, }, // Arctic/Longyearbyen
    {   86, 5589,    2789,  4, }, // Asia/Aden
    {   86, 5414,   53539,  8, }, // Asia/Almaty
    {   86, 3987,   53547,  6, }, // Asia/Amman
    {   86, 5530,   28001,  7, }, // Asia/Anadyr
    {   86, 5542,    2810,  5, }, // Asia/Aqtau
    {   86, 5387,    2815,  6, }, // Asia/Aqtobe
    {   86,  966,    2821,  7, }, // Asia/Ashgabat
    {   86, 8642,   53553,  6, }, // Asia/Atyrau
    {   86, 3626,   53559,  7, }, // Asia/Baghdad
    {   86, 5553,   39003,  7, }, // Asia/Bahrain
    {   86, 3672,   53566,  5, }, // Asia/Baku
    {   86, 4485,    2851,  7, }, // Asia/Bangkok
    {   86, 3590,    2858,  7, }, // Asia/Barnaul
    {   86, 4105,   28036,  6, }, // Asia/Beirut
    {   86, 3797,    2871,  6, }, // Asia/Bishkek
    {   86, 6008,   28048,  6, }, // Asia/Brunei
    {   86, 4620,    2883,  4, }, // Asia/Chita
    {   86, 4530,    2887,  7, }, // Asia/Colombo
    {   86, 4559,   53571,  7, }, // Asia/Damascus
    {   86, 1095,    2900,  5, }, // Asia/Dhaka
    {   86, 6211,    2905,  4, }, // Asia/Dili
    {   86, 3615,   28060,  5, }, // Asia/Dubai
    {   86, 6178,    2914,  7, }, // Asia/Dushanbe
    {   86, 8654,    2921,  9, }, // Asia/Famagusta
    {   86, 8669,    2930,  4, }, // Asia/Gaza
    {   86, 4814,    2934,  6, }, // Asia/Hebron
    {   86, 1261,    2940,  7, }, // Asia/Ho_Chi_Minh
    {   86, 2706,   28072,  7, }, // Asia/Hong_Kong
    {   86, 4790,    2954,  4, }, // Asia/Hovd
    {   86, 4203,    2958,  7, }, // Asia/Irkutsk
    {   86, 7025,   28079,  8, }, // Asia/Jakarta
    {   86, 7011,   53578,  7, }, // Asia/Jayapura
    {   86, 1292,   53585, 11, }, // Asia/Jerusalem
    {   86, 3579,    2989,  5, }, // Asia/Kabul
    {   86, 4335,   53596, 23, }, // Asia/Kamchatka
    {   86, 4258,    3019,  6, }, // Asia/Karachi
    {   86, 1187,    3025,  8, }, // Asia/Kathmandu
    {   86, 8679,    3033,  7, }, // Asia/Khandyga
    {   86,  994,   28095,  9, }, // Asia/Kolkata
    {   86, 4216,   28104, 10, }, // Asia/Krasnoyarsk
    {   86, 4878,    3059, 12, }, // Asia/Kuala_Lumpur
    {   86, 5995,    3071,  6, }, // Asia/Kuching
    {   86, 5566,   28114,  6, }, // Asia/Kuwait
    {   86, 1213,    3083,  5, }, // Asia/Macau
    {   86, 4036,    3088,  7, }, // Asia/Magadan
    {   86, 1351,    3095,  7, }, // Asia/Makassar
    {   86, 7182,    3102,  6, }, // Asia/Manila
    {   86, 6939,    3108,  6, }, // Asia/Muscat
    {   86, 2556,    3114,  6, }, // Asia/Nicosia
    {   86, 8693,    3121, 11, }, // Asia/Novokuznetsk
    {   86, 4154,    3132, 11, }, // Asia/Novosibirsk
    {   86, 4248,    3143,  4, }, // Asia/Omsk
    {   86, 7145,   37150,  4, }, // Asia/Oral
    {   86, 6980,   28134,  8, }, // Asia/Phnom_Penh
    {   86, 8711,    3160,  9, }, // Asia/Pontianak
    {   86, 4233,   28142,  7, }, // Asia/Pyongyang
    {   86, 5578,    3176,  5, }, // Asia/Qatar
    {   86, 4288,    3189,  9, }, // Asia/Qyzylorda
    {   86, 3603,   28166,  7, }, // Asia/Riyadh
    {   86, 4427,   53619, 12, }, // Asia/Sakhalin
    {   86, 7245,    3218,  9, }, // Asia/Samarkand
    {   86, 3298,    3227,  4, }, // Asia/Seoul
    {   86, 1055,   28182,  6, }, // Asia/Shanghai
    {   86, 3319,    3237,  8, }, // Asia/Singapore
    {   86, 4316,    3245, 13, }, // Asia/Srednekolymsk
    {   86, 3282,   31069,  6, }, // Asia/Taipei
    {   86, 4800,    3264,  7, }, // Asia/Tashkent
    {   86, 3934,   28194,  7, }, // Asia/Tbilisi
    {   86, 2774,   53631,  7, }, // Asia/Tehran
    {   86, 1319,   37225,  5, }, // Asia/Thimphu
    {   86, 2823,    3289,  5, }, // Asia/Tokyo
    {   86, 4591,    3294,  5, }, // Asia/Tomsk
    {   86, 1023,    3299, 10, }, // Asia/Ulaanbaatar
    {   86, 1161,    3309,  6, }, // Asia/Urumqi
    {   86, 8740,   28213,  9, }, // Asia/Ust-Nera
    {   86, 6996,   28222,  8, }, // Asia/Vientiane
    {   86, 4729,    3330, 11, }, // Asia/Vladivostok
    {   86, 4847,   28230,  6, }, // Asia/Yakutsk
    {   86, 1237,   31151,  6, }, // Asia/Yangon
    {   86, 3902,    3354, 12, }, // Asia/Yekaterinburg
    {   86, 3766,    3366,  6, }, // Asia/Yerevan
    {   86, 3682,   53638, 16, }, // Atlantic/Azores
    {   86, 5690,   53654,  8, }, // Atlantic/Bermuda
    {   86, 6647,   53662, 17, }, // Atlantic/Canary
    {   86, 3746,    3423, 10, }, // Atlantic/Cape_Verde
    {   86, 1397,   53679, 18, }, // Atlantic/Faroe
    {   86, 8754,   53697, 13, }, // Atlantic/Madeira
    {   86, 2750,   28292,  9, }, // Atlantic/Reykjavik
    {   86, 7272,   53710, 14, }, // Atlantic/South_Georgia
    {   86, 6840,   53724, 19, }, // Atlantic/St_Helena
    {   86, 6663,   28332,  6, }, // Atlantic/Stanley
    {   86, 1672,    3514,  8, }, // Australia/Adelaide
    {   86, 1637,    3522,  7, }, // Australia/Brisbane
    {   86, 1801,    3529, 11, }, // Australia/Broken_Hill
    {   86, 1585,    3540,  6, }, // Australia/Darwin
    {   86, 3656,   28338,  4, }, // Australia/Eucla
    {   86, 1518,    3551,  6, }, // Australia/Hobart
    {   86, 8771,    3557,  8, }, // Australia/Lindeman
    {   86, 1549,   53743, 14, }, // Australia/Lord_Howe
    {   86, 1729,   28357,  8, }, // Australia/Melbourne
    {   86, 1764,    3580,  4, }, // Australia/Perth
    {   86, 1465,   28365,  6, }, // Australia/Sydney
    {   86, 6460,    3590,  9, }, // Europe/Amsterdam
    {   86, 6235,    3599,  7, }, // Europe/Andorra
    {   86, 3639,   53757,  9, }, // Europe/Astrakhan
    {   86, 2302,   28379,  5, }, // Europe/Athens
    {   86, 6355,    3618,  7, }, // Europe/Belgrade
    {   86, 4776,    3625,  6, }, // Europe/Berlin
    {   86, 6507,    3631, 10, }, // Europe/Bratislava
    {   86, 2169,   28384,  8, }, // Europe/Brussels
    {   86, 3947,    3649,  8, }, // Europe/Bucharest
    {   86, 3825,    3657,  8, }, // Europe/Budapest
    {   86, 8790,   53766, 19, }, // Europe/Busingen
    {   86, 2585,    3688,  7, }, // Europe/Chisinau
    {   86, 6308,   28400, 10, }, // Europe/Copenhagen
    {   86, 2340,    3705,  6, }, // Europe/Dublin
    {   86, 6326,    3711,  9, }, // Europe/Gibraltar
    {   86, 8806,    3720,  6, }, // Europe/Guernsey
    {   86, 6631,   28410,  9, }, // Europe/Helsinki
    {   86, 8822,   53785,  9, }, // Europe/Isle_of_Man
    {   86, 1132,    3743,  7, }, // Europe/Istanbul
    {   86, 8841,   28437,  6, }, // Europe/Jersey
    {   86, 3998,    3755, 11, }, // Europe/Kaliningrad
    {   86, 8855,    3766,  5, }, // Europe/Kirov
    {   86, 2529,    3771,  4, }, // Europe/Kyiv
    {   86, 3232,    3775,  8, }, // Europe/Lisbon
    {   86, 6525,   28443,  7, }, // Europe/Ljubljana
    {   86, 2503,    3792,  6, }, // Europe/London
    {   86, 6384,   28450, 10, }, // Europe/Luxembourg
    {   86, 4911,    3809,  6, }, // Europe/Madrid
    {   86, 6416,   28460,  6, }, // Europe/Malta
    {   86, 6601,    3820,  9, }, // Europe/Mariehamn
    {   86, 3712,    3829,  5, }, // Europe/Minsk
    {   86, 6429,    3834,  6, }, // Europe/Monaco
    {   86, 3556,    3840,  6, }, // Europe/Moscow
    {   86, 6477,    3846,  4, }, // Europe/Oslo
    {   86, 4303,    3850,  5, }, // Europe/Paris
    {   86, 6443,    3855,  9, }, // Europe/Podgorica
    {   86, 6294,    3864,  5, }, // Europe/Prague
    {   86, 8868,    3869,  4, }, // Europe/Riga
    {   86, 6343,    3873,  3, }, // Europe/Rome
    {   86, 4350,    3876,  6, }, // Europe/Samara
    {   86, 6489,    3882, 10, }, // Europe/San_Marino
    {   86, 6264,    3892,  7, }, // Europe/Sarajevo
    {   86, 4470,    3899,  7, }, // Europe/Saratov
    {   86, 8880,   28484, 11, }, // Europe/Simferopol
    {   86, 6402,   28495,  6, }, // Europe/Skopje
    {   86, 6618,    3921,  4, }, // Europe/Sofia
    {   86, 6542,   28506,  9, }, // Europe/Stockholm
    {   86, 8898,    3934,  6, }, // Europe/Tallinn
    {   86, 6221,    3940,  6, }, // Europe/Tirane
    {   86, 8913,   28515,  9, }, // Europe/Ulyanovsk
    {   86, 6371,    3955,  5, }, // Europe/Vaduz
    {   86, 6586,    3960,  7, }, // Europe/Vatican
    {   86, 6250,    3967,  4, }, // Europe/Vienna
    {   86, 8930,   28524,  7, }, // Europe/Vilnius
    {   86, 4746,    3978,  9, }, // Europe/Volgograd
    {   86, 3209,    3987,  7, }, // Europe/Warsaw
    {   86, 6280,    3994,  6, }, // Europe/Zagreb
    {   86, 6559,   28531,  5, }, // Europe/Zurich
    {   86, 5097,    4006, 12, }, // Indian/Antananarivo
    {   86, 6966,    4018,  5, }, // Indian/Chagos
    {   86, 6065,   53794, 31, }, // Indian/Christmas
    {   86, 6082,   53825, 16, }, // Indian/Cocos
    {   86, 5048,   53841, 18, }, // Indian/Comoro
    {   86, 6680,    4057,  8, }, // Indian/Kerguelen
    {   86, 7260,   28598,  3, }, // Indian/Mahe
    {   86, 7069,   53859,  9, }, // Indian/Maldives
    {   86, 4088,    4074,  7, }, // Indian/Mauritius
    {   86, 5117,   53868,  7, }, // Indian/Mayotte
    {   86, 7211,   28633,  7, }, // Indian/Reunion
    {   86, 4441,    4095,  3, }, // Pacific/Apia
    {   86, 3009,    4099,  6, }, // Pacific/Auckland
    {   86, 3725,   53875, 15, }, // Pacific/Bougainville
    {   86, 3034,   53890, 11, }, // Pacific/Chatham
    {   86, 3176,   53901, 12, }, // Pacific/Chuuk
    {   86, 2239,   53913, 16, }, // Pacific/Easter
    {   86, 7360,   28676,  5, }, // Pacific/Efate
    {   86, 7327,    4138,  7, }, // Pacific/Fakaofo
    {   86, 3921,   28681,  5, }, // Pacific/Fiji
    {   86, 7343,    4149,  8, }, // Pacific/Funafuti
    {   86, 6697,   53929, 21, }, // Pacific/Galapagos
    {   86, 6715,   53950, 15, }, // Pacific/Gambier
    {   86, 3841,   37716, 11, }, // Pacific/Guadalcanal
    {   86, 6037,    4203,  4, }, // Pacific/Guam
    {   86, 2725,   53965,  8, }, // Pacific/Honolulu
    {   86, 3068,     957,  6, }, // Pacific/Kanton
    {   86, 4017,    4213, 10, }, // Pacific/Kiritimati
    {   86, 7038,    4223,  6, }, // Pacific/Kosrae
    {   86, 2844,   28734, 10, }, // Pacific/Kwajalein
    {   86, 4896,   28744,  7, }, // Pacific/Majuro
    {   86, 4070,   53973, 16, }, // Pacific/Marquesas
    {   86, 8945,   53989, 14, }, // Pacific/Midway
    {   86, 7103,    4277,  5, }, // Pacific/Nauru
    {   86, 7132,   28780,  4, }, // Pacific/Niue
    {   86, 4187,    4286,  7, }, // Pacific/Norfolk
    {   86, 7117,    4293,  5, }, // Pacific/Noumea
    {   86, 3145,    4298,  9, }, // Pacific/Pago_Pago
    {   86, 7155,    4307,  5, }, // Pacific/Palau
    {   86, 7194,    4312,  7, }, // Pacific/Pitcairn
    {   86, 3115,   54003, 14, }, // Pacific/Pohnpei
    {   86, 4826,    4325, 11, }, // Pacific/Port_Moresby
    {   86, 6095,    4336,  9, }, // Pacific/Rarotonga
    {   86, 6050,   28815,  6, }, // Pacific/Saipan
    {   86, 7312,   54017, 13, }, // Pacific/Tahiti
    {   86, 6731,    4356,  6, }, // Pacific/Tarawa
    {   86, 4602,    4362,  9, }, // Pacific/Tongatapu
    {   86, 7392,   54030, 10, }, // Pacific/Wake
    {   86, 7405,    4375,  6, }, // Pacific/Wallis
    {   87, 6807,   54040,  4, }, // Africa/Abidjan Cherokee/Cherokee/United States
    {   87, 6779,   54044,  2, }, // Africa/Accra
    {   87, 5078,   54046,  7, }, // Africa/Addis_Ababa
    {   87, 7420,   54053,  4, }, // Africa/Algiers
    {   87,   14,   54057,  4, }, // Africa/Asmara
    {   87,   44,   54061,  3, }, // Africa/Bamako
    {   87, 5276,   54064,  4, }, // Africa/Bangui
    {   87, 6765,   54068,  4, }, // Africa/Banjul
    {   87, 7435,   54072,  3, }, // Africa/Bissau
    {   87, 4976,   54075,  3, }, // Africa/Blantyre
    {   87, 5306,   54078,  4, }, // Africa/Brazzaville
    {   87, 4941,   54082,  5, }, // Africa/Bujumbura
    {   87, 2322,   54087,  3, }, // Africa/Cairo
    {   87, 4136,   54090,  8, }, // Africa/Casablanca
    {   87, 7449,   54098,  2, }, // Africa/Ceuta
    {   87, 6792,   54100,  3, }, // Africa/Conakry
    {   87, 6859,   54103,  3, }, // Africa/Dakar
    {   87, 5149,   54106,  8, }, // Africa/Dar_es_Salaam
    {   87, 5062,   54114,  3, }, // Africa/Djibouti
    {   87, 5262,   54117,  4, }, // Africa/Douala
    {   87, 5185,   54121,  7, }, // Africa/El_Aaiun
    {   87, 6872,   54128,  7, }, // Africa/Freetown
    {   87, 4925,   54135,  4, }, // Africa/Gaborone
    {   87, 5034,   54139,  3, }, // Africa/Harare
    {   87, 4498,   54142,  6, }, // Africa/Johannesburg
    {   87, 4518,   54148,  2, }, // Africa/Juba
    {   87, 5170,   54150,  4, }, // Africa/Kampala
    {   87, 4543,   54154,  3, }, // Africa/Khartoum
    {   87, 4992,   54157,  3, }, // Africa/Kigali
    {   87, 5325,   54160,  4, }, // Africa/Kinshasa
    {   87, 4763,   54164,  3, }, // Africa/Lagos
    {   87, 5355,   54167,  4, }, // Africa/Libreville
    {   87, 6888,   54171,  2, }, // Africa/Lome
    {   87, 5230,   54173,  4, }, // Africa/Luanda
    {   87, 4958,   54177,  4, }, // Africa/Lubumbashi
    {   87, 5020,   54181,  3, }, // Africa/Lusaka
    {   87, 5341,   54184,  3, }, // Africa/Malabo
    {   87, 5006,   54187,  3, }, // Africa/Maputo
    {   87, 5216,   54190,  3, }, // Africa/Maseru
    {   87, 5201,   54193,  3, }, // Africa/Mbabane
    {   87, 5132,   54196,  4, }, // Africa/Mogadishu
    {   87, 7053,   54200,  5, }, // Africa/Monrovia
    {   87, 3872,   54205,  4, }, // Africa/Nairobi
    {   87, 5290,   54209,  4, }, // Africa/Ndjamena
    {   87, 5373,   54213,  3, }, // Africa/Niamey
    {   87, 6822,   54216,  4, }, // Africa/Nouakchott
    {   87, 6746,   54220,  5, }, // Africa/Ouagadougou
    {   87, 5244,   54225, 11, }, // Africa/Porto-Novo
    {   87, 4454,   54236,  4, }, // Africa/Sao_Tome
    {   87, 2868,   54240,  3, }, // Africa/Tripoli
    {   87, 6573,   54243,  3, }, // Africa/Tunis
    {   87, 4171,   54246,  5, }, // Africa/Windhoek
    {   87,  132,   54251,  3, }, // America/Adak
    {   87, 3365,   54254,  5, }, // America/Anchorage
    {   87, 5626,   54259,  4, }, // America/Anguilla
    {   87, 5643,   54263,  3, }, // America/Antigua
    {   87, 4573,   54266,  6, }, // America/Araguaina
    {   87,  166,   54272,  7, }, // America/Argentina/Buenos_Aires
    {   87,   91,   54279,  4, }, // America/Argentina/Catamarca
    {   87,  270,   54283,  3, }, // America/Argentina/Cordoba
    {   87,  441,   54286,  3, }, // America/Argentina/Jujuy
    {   87, 7462,   54289,  5, }, // America/Argentina/La_Rioja
    {   87,  565,   54294,  4, }, // America/Argentina/Mendoza
    {   87, 7489,   54298,  8, }, // America/Argentina/Rio_Gallegos
    {   87, 7520,   54306,  3, }, // America/Argentina/Salta
    {   87, 7544,   54309,  5, }, // America/Argentina/San_Juan
    {   87, 5599,   54314,  8, }, // America/Argentina/San_Luis
    {   87, 7571,   54322,  4, }, // America/Argentina/Tucuman
    {   87, 7597,   54326,  4, }, // America/Argentina/Ushuaia
    {   87, 5659,   54330,  3, }, // America/Aruba
    {   87, 4271,   54333,  5, }, // America/Asuncion
    {   87,  237,   54338,  5, }, // America/Atikokan
    {   87, 3698,   54343,  3, }, // America/Bahia
    {   87, 7623,   54346,  9, }, // America/Bahia_Banderas
    {   87, 5673,   54355,  4, }, // America/Barbados
    {   87, 7646,   54359,  3, }, // America/Belem
    {   87, 5426,   54362,  3, }, // America/Belize
    {   87, 7660,   54365,  6, }, // America/Blanc-Sablon
    {   87, 7681,   54371,  9, }, // America/Boa_Vista
    {   87, 4380,   54380,  3, }, // America/Bogota
    {   87, 7699,   54383,  3, }, // America/Boise
    {   87, 7713,   54386, 10, }, // America/Cambridge_Bay
    {   87, 7735,   54396,  7, }, // America/Campo_Grande
    {   87, 3887,   54403,  4, }, // America/Cancun
    {   87, 4713,   54407,  4, }, // America/Caracas
    {   87, 4364,   54411,  3, }, // America/Cayenne
    {   87, 5515,   54414,  4, }, // America/Cayman
    {   87, 2262,   54418,  3, }, // America/Chicago
    {   87, 7756,   54421,  3, }, // America/Chihuahua
    {   87, 7774,   54424,  7, }, // America/Ciudad_Juarez
    {   87, 5441,   54431,  5, }, // America/Costa_Rica
    {   87, 7796,   54436,  4, }, // America/Coyhaique
    {   87, 7814,   54440,  4, }, // America/Creston
    {   87, 3810,   54444,  3, }, // America/Cuiaba
    {   87, 5742,   54447,  4, }, // America/Curacao
    {   87, 7830,   54451,  7, }, // America/Danmarkshavn
    {   87, 7851,   54458,  3, }, // America/Dawson
    {   87, 7866,   54461,  7, }, // America/Dawson_Creek
    {   87,  805,   54468,  8, }, // America/Denver
    {   87, 3484,   54476,  3, }, // America/Detroit
    {   87, 5758,   54479,  4, }, // America/Dominica
    {   87,  893,   54483,  6, }, // America/Edmonton
    {   87, 7887,   54489,  4, }, // America/Eirunepe
    {   87, 5460,   54493,  8, }, // America/El_Salvador
    {   87, 7904,   54501,  8, }, // America/Fort_Nelson
    {   87, 7924,   54509,  4, }, // America/Fortaleza
    {   87, 7942,   54513,  8, }, // America/Glace_Bay
    {   87, 6900,   54521,  8, }, // America/Goose_Bay
    {   87, 4631,   54529,  8, }, // America/Grand_Turk
    {   87, 5789,   54537,  3, }, // America/Grenada
    {   87, 5805,   54540,  4, }, // America/Guadeloupe
    {   87, 3779,   54544,  4, }, // America/Guatemala
    {   87, 4860,   54548,  4, }, // America/Guayaquil
    {   87, 6951,   54552,  3, }, // America/Guyana
    {   87, 1941,   54555,  5, }, // America/Halifax
    {   87, 2283,   54560,  3, }, // America/Havana
    {   87, 7960,   54563,  4, }, // America/Hermosillo
    {   87,  348,   54567,  9, }, // America/Indiana/Indianapolis
    {   87,  481,   54576, 10, }, // America/Indiana/Knox
    {   87, 7979,   54586, 11, }, // America/Indiana/Marengo
    {   87, 8003,   54597, 11, }, // America/Indiana/Petersburg
    {   87, 8030,   54608, 13, }, // America/Indiana/Tell_City
    {   87, 8056,   54621,  9, }, // America/Indiana/Vevay
    {   87, 8078,   54630, 12, }, // America/Indiana/Vincennes
    {   87, 8104,   54642, 11, }, // America/Indiana/Winamac
    {   87, 8128,   54653,  4, }, // America/Inuvik
    {   87,  660,   54657,  5, }, // America/Iqaluit
    {   87, 2801,   54662,  4, }, // America/Jamaica
    {   87, 5399,   54666,  2, }, // America/Juneau
    {   87,  521,   54668,  4, }, // America/Kentucky/Louisville
    {   87, 8143,   54672, 11, }, // America/Kentucky/Monticello
    {   87, 5723,   54683,  4, }, // America/Kralendijk
    {   87, 4395,   54687,  2, }, // America/La_Paz
    {   87, 7169,   54671,  2, }, // America/Lima
    {   87, 3258,   54689, 12, }, // America/Los_Angeles
    {   87, 5951,   54701, 17, }, // America/Lower_Princes
    {   87, 8171,   54718,  3, }, // America/Maceio
    {   87, 8186,   54721,  3, }, // America/Managua
    {   87, 1910,   54724,  4, }, // America/Manaus
    {   87, 5916,   54728,  4, }, // America/Marigot
    {   87, 5824,   54732,  4, }, // America/Martinique
    {   87, 8202,   54736,  5, }, // America/Matamoros
    {   87, 2919,   54741,  4, }, // America/Mazatlan
    {   87, 8220,   54745,  4, }, // America/Menominee
    {   87, 8238,   54749,  3, }, // America/Merida
    {   87, 8253,   54752,  4, }, // America/Metlakatla
    {   87, 2951,   54756,  9, }, // America/Mexico_City
    {   87, 4410,   54765,  4, }, // America/Miquelon
    {   87, 8272,   54769,  4, }, // America/Moncton
    {   87, 8288,   54773,  3, }, // America/Monterrey
    {   87, 4117,   54776,  6, }, // America/Montevideo
    {   87, 5843,   54782,  6, }, // America/Montserrat
    {   87, 5500,   54788,  3, }, // America/Nassau
    {   87, 2381,   54791,  3, }, // America/New_York
    {   87, 8306,   54794,  2, }, // America/Nome
    {   87, 1852,   54796,  4, }, // America/Noronha
    {   87, 8319,   54800, 12, }, // America/North_Dakota/Beulah
    {   87, 8347,   54812, 12, }, // America/North_Dakota/Center
    {   87, 8375,   54824, 15, }, // America/North_Dakota/New_Salem
    {   87,  393,   54839,  2, }, // America/Nuuk
    {   87, 8406,   54841,  4, }, // America/Ojinaga
    {   87, 2358,   54845,  3, }, // America/Panama
    {   87, 6192,   54848,  5, }, // America/Paramaribo
    {   87, 2975,   54853,  6, }, // America/Phoenix
    {   87, 3964,   54859, 17, }, // America/Port-au-Prince
    {   87, 5973,   54876, 15, }, // America/Port_of_Spain
    {   87, 8422,   54891, 12, }, // America/Porto_Velho
    {   87, 5862,   54903,  7, }, // America/Puerto_Rico
    {   87, 4049,   54910,  7, }, // America/Punta_Arenas
    {   87, 8442,   54917,  9, }, // America/Rankin_Inlet
    {   87, 8463,   54926,  3, }, // America/Recife
    {   87, 1997,   54929,  3, }, // America/Regina
    {   87, 8478,   54932,  4, }, // America/Resolute
    {   87,  695,   54936,  7, }, // America/Rio_Branco
    {   87, 8495,   54943,  5, }, // America/Santarem
    {   87, 2203,   54948,  5, }, // America/Santiago
    {   87, 6130,   54953,  7, }, // America/Santo_Domingo
    {   87, 1880,   54960,  5, }, // America/Sao_Paulo
    {   87, 6918,   54965,  6, }, // America/Scoresbysund
    {   87, 8512,   54971,  3, }, // America/Sitka
    {   87, 8526,   54974, 10, }, // America/St_Barthelemy
    {   87, 2063,   54984, 11, }, // America/St_Johns
    {   87, 5882,   54995,  8, }, // America/St_Kitts
    {   87, 5899,   55003,  8, }, // America/St_Lucia
    {   87,  855,   55011,  8, }, // America/St_Thomas
    {   87, 5932,   55019,  9, }, // America/St_Vincent
    {   87, 8548,   55028,  8, }, // America/Swift_Current
    {   87, 5480,   55036,  6, }, // America/Tegucigalpa
    {   87, 5775,   55042,  2, }, // America/Thule
    {   87,  313,   55044,  4, }, // America/Tijuana
    {   87,  608,   55048,  4, }, // America/Toronto
    {   87, 5707,   55052,  3, }, // America/Tortola
    {   87, 2095,   55055,  5, }, // America/Vancouver
    {   87, 2146,   55060,  7, }, // America/Whitehorse
    {   87,  734,   55067,  4, }, // America/Winnipeg
    {   87, 8570,   55071,  4, }, // America/Yakutat
    {   87, 6020,   54401,  2, }, // Antarctica/Casey
    {   87, 6113,   55075,  3, }, // Antarctica/Davis
    {   87, 6152,   55078, 11, }, // Antarctica/DumontDUrville
    {   87, 8586,   55089,  3, }, // Antarctica/Macquarie
    {   87, 7085,   55092,  3, }, // Antarctica/Mawson
    {   87,  932,   55095,  4, }, // Antarctica/McMurdo
    {   87, 8607,   55099,  4, }, // Antarctica/Palmer
    {   87, 7226,   55103,  3, }, // Antarctica/Rothera
    {   87, 7295,   55106,  3, }, // Antarctica/Syowa
    {   87, 8625,   55109,  2, }, // Antarctica/Troll
    {   87, 7374,   55111,  4, }, // Antarctica/Vostok
    {   87, 1431,   55115, 17, }, // Arctic/Longyearbyen
    {   87, 5589,   55132,  3, }, // Asia/Aden
    {   87, 5414,   55135,  4, }, // Asia/Almaty
    {   87, 3987,   55139,  3, }, // Asia/Amman
    {   87, 5530,   55142,  4, }, // Asia/Anadyr
    {   87, 5542,   55146,  4, }, // Asia/Aqtau
    {   87, 5387,   55150,  4, }, // Asia/Aqtobe
    {   87,  966,   55154,  5, }, // Asia/Ashgabat
    {   87, 8642,   55159,  4, }, // Asia/Atyrau
    {   87, 3626,   55163,  4, }, // Asia/Baghdad
    {   87, 5553,   55167,  5, }, // Asia/Bahrain
    {   87, 3672,   54446,  2, }, // Asia/Baku
    {   87, 4485,   55172,  5, }, // Asia/Bangkok
    {   87, 3590,   55177,  4, }, // Asia/Barnaul
    {   87, 4105,   55181,  3, }, // Asia/Beirut
    {   87, 3797,   55184,  4, }, // Asia/Bishkek
    {   87, 6008,   55188,  3, }, // Asia/Brunei
    {   87, 4620,   55191,  2, }, // Asia/Chita
    {   87, 4530,   55193,  4, }, // Asia/Colombo
    {   87, 4559,   55197,  5, }, // Asia/Damascus
    {   87, 1095,   54103,  2, }, // Asia/Dhaka
    {   87, 6211,   55144,  2, }, // Asia/Dili
    {   87, 3615,   55202,  3, }, // Asia/Dubai
    {   87, 6178,   55205,  4, }, // Asia/Dushanbe
    {   87, 8654,   55209,  5, }, // Asia/Famagusta
    {   87, 8669,   55214,  2, }, // Asia/Gaza
    {   87, 4814,   55216,  3, }, // Asia/Hebron
    {   87, 1261,   55219, 10, }, // Asia/Ho_Chi_Minh
    {   87, 2706,   55229,  7, }, // Asia/Hong_Kong
    {   87, 4790,   55236,  3, }, // Asia/Hovd
    {   87, 4203,   55239,  4, }, // Asia/Irkutsk
    {   87, 7025,   55243,  3, }, // Asia/Jakarta
    {   87, 7011,   55246,  4, }, // Asia/Jayapura
    {   87, 1292,   55250,  5, }, // Asia/Jerusalem
    {   87, 3579,   55255,  3, }, // Asia/Kabul
    {   87, 4335,   55258,  4, }, // Asia/Kamchatka
    {   87, 4258,   55262,  3, }, // Asia/Karachi
    {   87, 1187,   55265,  5, }, // Asia/Kathmandu
    {   87, 8679,   55270,  4, }, // Asia/Khandyga
    {   87,  994,   55274,  4, }, // Asia/Kolkata
    {   87, 4216,   55278,  6, }, // Asia/Krasnoyarsk
    {   87, 4878,   55284,  7, }, // Asia/Kuala_Lumpur
    {   87, 5995,   55291,  4, }, // Asia/Kuching
    {   87, 5566,   55295,  3, }, // Asia/Kuwait
    {   87, 1213,   55298,  3, }, // Asia/Macau
    {   87, 4036,   55301,  4, }, // Asia/Magadan
    {   87, 1351,   55305,  4, }, // Asia/Makassar
    {   87, 7182,   55309,  3, }, // Asia/Manila
    {   87, 6939,   55312,  4, }, // Asia/Muscat
    {   87, 2556,   55316,  4, }, // Asia/Nicosia
    {   87, 8693,   55320,  7, }, // Asia/Novokuznetsk
    {   87, 4154,   55327,  6, }, // Asia/Novosibirsk
    {   87, 4248,   55333,  4, }, // Asia/Omsk
    {   87, 7145,   55337,  3, }, // Asia/Oral
    {   87, 6980,   55340,  5, }, // Asia/Phnom_Penh
    {   87, 8711,   55345,  6, }, // Asia/Pontianak
    {   87, 4233,   55351,  7, }, // Asia/Pyongyang
    {   87, 5578,   55358,  3, }, // Asia/Qatar
    {   87, 8726,   55361,  4, }, // Asia/Qostanay
    {   87, 4288,   55365,  5, }, // Asia/Qyzylorda
    {   87, 3603,   55370,  3, }, // Asia/Riyadh
    {   87, 4427,   55373,  4, }, // Asia/Sakhalin
    {   87, 7245,   55377,  5, }, // Asia/Samarkand
    {   87, 3298,   55382,  2, }, // Asia/Seoul
    {   87, 1055,   55384,  5, }, // Asia/Shanghai
    {   87, 3319,   55389,  5, }, // Asia/Singapore
    {   87, 4316,   55394,  9, }, // Asia/Srednekolymsk
    {   87, 3282,   55403,  3, }, // Asia/Taipei
    {   87, 4800,   55406,  5, }, // Asia/Tashkent
    {   87, 3934,   55411,  4, }, // Asia/Tbilisi
    {   87, 2774,   55415,  3, }, // Asia/Tehran
    {   87, 1319,   55418,  3, }, // Asia/Thimphu
    {   87, 2823,   55421,  3, }, // Asia/Tokyo
    {   87, 4591,   55424,  4, }, // Asia/Tomsk
    {   87, 1023,   55428,  5, }, // Asia/Ulaanbaatar
    {   87, 1161,   55433,  4, }, // Asia/Urumqi
    {   87, 8740,   55437,  6, }, // Asia/Ust-Nera
    {   87, 6996,   55443,  6, }, // Asia/Vientiane
    {   87, 4729,   55449,  7, }, // Asia/Vladivostok
    {   87, 4847,   55456,  4, }, // Asia/Yakutsk
    {   87, 1237,   55460,  4, }, // Asia/Yangon
    {   87, 3902,   55464,  7, }, // Asia/Yekaterinburg
    {   87, 3766,   55471,  4, }, // Asia/Yerevan
    {   87, 3682,   55475,  4, }, // Atlantic/Azores
    {   87, 5690,   55479,  3, }, // Atlantic/Bermuda
    {   87, 6647,   55482,  3, }, // Atlantic/Canary
    {   87, 3746,   55485, 11, }, // Atlantic/Cape_Verde
    {   87, 1397,   55496,  2, }, // Atlantic/Faroe
    {   87, 8754,   55498,  3, }, // Atlantic/Madeira
    {   87, 2750,   55501,  4, }, // Atlantic/Reykjavik
    {   87, 7272,   55505,  9, }, // Atlantic/South_Georgia
    {   87, 6840,   55514,  8, }, // Atlantic/St_Helena
    {   87, 6663,   55522,  4, }, // Atlantic/Stanley
    {   87, 1672,   55526,  4, }, // Australia/Adelaide
    {   87, 1637,   55530,  4, }, // Australia/Brisbane
    {   87, 1801,   55534,  8, }, // Australia/Broken_Hill
    {   87, 1585,   55542,  3, }, // Australia/Darwin
    {   87, 3656,   55545,  2, }, // Australia/Eucla
    {   87, 1518,   55547,  3, }, // Australia/Hobart
    {   87, 8771,   55550,  5, }, // Australia/Lindeman
    {   87, 1549,   55555,  8, }, // Australia/Lord_Howe
    {   87, 1729,   55563,  4, }, // Australia/Melbourne
    {   87, 1764,   55567,  3, }, // Australia/Perth
    {   87, 1465,   55570,  3, }, // Australia/Sydney
    {   87, 6460,   55573,  6, }, // Europe/Amsterdam
    {   87, 6235,   55579,  4, }, // Europe/Andorra
    {   87, 3639,   55583,  4, }, // Europe/Astrakhan
    {   87, 2302,   55587,  4, }, // Europe/Athens
    {   87, 6355,   55591,  4, }, // Europe/Belgrade
    {   87, 4776,   55595,  3, }, // Europe/Berlin
    {   87, 6507,   55598,  5, }, // Europe/Bratislava
    {   87, 2169,   55603,  4, }, // Europe/Brussels
    {   87, 3947,   55607,  5, }, // Europe/Bucharest
    {   87, 3825,   55612,  5, }, // Europe/Budapest
    {   87, 8790,   55617,  5, }, // Europe/Busingen
    {   87, 2585,   55622,  4, }, // Europe/Chisinau
    {   87, 6308,   55626,  6, }, // Europe/Copenhagen
    {   87, 2340,   55632,  3, }, // Europe/Dublin
    {   87, 6326,   55635,  4, }, // Europe/Gibraltar
    {   87, 8806,   55639,  3, }, // Europe/Guernsey
    {   87, 6631,   55642,  5, }, // Europe/Helsinki
    {   87, 8822,   55647, 15, }, // Europe/Isle_of_Man
    {   87, 1132,   55662,  6, }, // Europe/Istanbul
    {   87, 8841,   55668,  3, }, // Europe/Jersey
    {   87, 3998,   55671,  5, }, // Europe/Kaliningrad
    {   87, 8855,   55676,  3, }, // Europe/Kirov
    {   87, 2529,   55679,  2, }, // Europe/Kyiv
    {   87, 3232,   55681,  4, }, // Europe/Lisbon
    {   87, 6525,   55685,  3, }, // Europe/Ljubljana
    {   87, 2503,   55688,  4, }, // Europe/London
    {   87, 6384,   55692,  5, }, // Europe/Luxembourg
    {   87, 4911,   55697,  3, }, // Europe/Madrid
    {   87, 6416,   55700,  3, }, // Europe/Malta
    {   87, 6601,   55703,  4, }, // Europe/Mariehamn
    {   87, 3712,   55707,  4, }, // Europe/Minsk
    {   87, 6429,   55711,  3, }, // Europe/Monaco
    {   87, 3556,   55714,  4, }, // Europe/Moscow
    {   87, 6477,   55718,  3, }, // Europe/Oslo
    {   87, 4303,   55721,  3, }, // Europe/Paris
    {   87, 6443,   55724,  4, }, // Europe/Podgorica
    {   87, 6294,   54193,  2, }, // Europe/Prague
    {   87, 8868,   54551,  2, }, // Europe/Riga
    {   87, 6343,   55194,  2, }, // Europe/Rome
    {   87, 4350,   55728,  3, }, // Europe/Samara
    {   87, 6489,   55731,  3, }, // Europe/San_Marino
    {   87, 6264,   55734,  4, }, // Europe/Sarajevo
    {   87, 4470,   55738,  4, }, // Europe/Saratov
    {   87, 8880,   55742,  6, }, // Europe/Simferopol
    {   87, 6402,   55748,  3, }, // Europe/Skopje
    {   87, 6618,   55751,  3, }, // Europe/Sofia
    {   87, 6542,   55754,  5, }, // Europe/Stockholm
    {   87, 8898,   55759,  3, }, // Europe/Tallinn
    {   87, 6221,   55762,  3, }, // Europe/Tirane
    {   87, 8913,   55765,  7, }, // Europe/Ulyanovsk
    {   87, 6371,   55772,  3, }, // Europe/Vaduz
    {   87, 6586,   55775,  5, }, // Europe/Vatican
    {   87, 6250,   55780,  3, }, // Europe/Vienna
    {   87, 8930,   55783,  5, }, // Europe/Vilnius
    {   87, 4746,   55788,  5, }, // Europe/Volgograd
    {   87, 3209,   55793,  8, }, // Europe/Warsaw
    {   87, 6280,   55801,  3, }, // Europe/Zagreb
    {   87, 6559,   55804,  3, }, // Europe/Zurich
    {   87, 5097,   55807,  7, }, // Indian/Antananarivo
    {   87, 6966,   55814,  3, }, // Indian/Chagos
    {   87, 6065,   55817,  7, }, // Indian/Christmas
    {   87, 6082,   55824,  3, }, // Indian/Cocos
    {   87, 5048,   55827,  3, }, // Indian/Comoro
    {   87, 6680,   55830,  6, }, // Indian/Kerguelen
    {   87, 7260,   55836,  2, }, // Indian/Mahe
    {   87, 7069,   55838,  5, }, // Indian/Maldives
    {   87, 4088,   55843,  5, }, // Indian/Mauritius
    {   87, 5117,   55848,  3, }, // Indian/Mayotte
    {   87, 7211,   55851,  5, }, // Indian/Reunion
    {   87, 4441,   55856,  3, }, // Pacific/Apia
    {   87, 3009,   55859,  5, }, // Pacific/Auckland
    {   87, 3725,   55864,  5, }, // Pacific/Bougainville
    {   87, 3034,   55869,  3, }, // Pacific/Chatham
    {   87, 3176,   55872,  2, }, // Pacific/Chuuk
    {   87, 2239,   55874,  7, }, // Pacific/Easter
    {   87, 7360,   55881,  3, }, // Pacific/Efate
    {   87, 7327,   55884,  4, }, // Pacific/Fakaofo
    {   87, 3921,   55888,  2, }, // Pacific/Fiji
    {   87, 7343,   55890,  4, }, // Pacific/Funafuti
    {   87, 6697,   55894, 12, }, // Pacific/Galapagos
    {   87, 6715,   55906,  4, }, // Pacific/Gambier
    {   87, 3841,   55910,  6, }, // Pacific/Guadalcanal
    {   87, 6037,   55916,  2, }, // Pacific/Guam
    {   87, 2725,   55918,  4, }, // Pacific/Honolulu
    {   87, 3068,   55922,  3, }, // Pacific/Kanton
    {   87, 4017,   55925,  5, }, // Pacific/Kiritimati
    {   87, 7038,   55930,  3, }, // Pacific/Kosrae
    {   87, 2844,   55933,  5, }, // Pacific/Kwajalein
    {   87, 4896,   55938,  3, }, // Pacific/Majuro
    {   87, 4070,   55941,  5, }, // Pacific/Marquesas
    {   87, 8945,   55946,  5, }, // Pacific/Midway
    {   87, 7103,   55951,  3, }, // Pacific/Nauru
    {   87, 7132,   55544,  2, }, // Pacific/Niue
    {   87, 4187,   55954,  5, }, // Pacific/Norfolk
    {   87, 7117,   55959,  4, }, // Pacific/Noumea
    {   87, 3145,   55963,  5, }, // Pacific/Pago_Pago
    {   87, 7155,   55968,  4, }, // Pacific/Palau
    {   87, 7194,   55972,  5, }, // Pacific/Pitcairn
    {   87, 3115,   55977,  3, }, // Pacific/Pohnpei
    {   87, 4826,   55980, 13, }, // Pacific/Port_Moresby
    {   87, 6095,   55993,  5, }, // Pacific/Rarotonga
    {   87, 6050,   55998,  4, }, // Pacific/Saipan
    {   87, 7312,   56002,  3, }, // Pacific/Tahiti
    {   87, 6731,   56005,  3, }, // Pacific/Tarawa
    {   87, 4602,   56008,  5, }, // Pacific/Tongatapu
    {   87, 7392,   56013,  3, }, // Pacific/Wake
    {   87, 7405,   56016,  3, }, // Pacific/Wallis
    {   88,   14,       0,  6, }, // Africa/Asmara Chickasaw/Latin/United States
    {   88, 5185,       6,  8, }, // Africa/El_Aaiun
    {   88, 6888,      14,  4, }, // Africa/Lome
    {   88, 5290,      18,  9, }, // Africa/Ndjamena
    {   88, 4454,      27,  8, }, // Africa/Sao_Tome
    {   88, 4573,      35,  9, }, // America/Araguaina
    {   88,  270,      44,  7, }, // America/Argentina/Cordoba
    {   88, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   88, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   88, 4271,      70,  8, }, // America/Asuncion
    {   88,  237,      78,  8, }, // America/Atikokan
    {   88, 7623,      86, 17, }, // America/Bahia_Banderas
    {   88, 7646,     103,  5, }, // America/Belem
    {   88, 4380,     108,  6, }, // America/Bogota
    {   88, 3887,     114,  6, }, // America/Cancun
    {   88, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   88, 3810,     133,  6, }, // America/Cuiaba
    {   88, 5742,     139,  7, }, // America/Curacao
    {   88, 7887,     146,  8, }, // America/Eirunepe
    {   88,  481,     154, 13, }, // America/Indiana/Knox
    {   88, 7979,     167, 16, }, // America/Indiana/Marengo
    {   88, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   88, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   88, 8056,     220, 14, }, // America/Indiana/Vevay
    {   88, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   88, 8104,     252, 16, }, // America/Indiana/Winamac
    {   88, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   88, 5951,     288, 22, }, // America/Lower_Princes
    {   88, 8171,     310,  6, }, // America/Maceio
    {   88, 2919,     316,  8, }, // America/Mazatlan
    {   88, 8238,     324,  6, }, // America/Merida
    {   88, 2951,    4381, 16, }, // America/Mexico_City
    {   88, 4410,     341, 12, }, // America/Miquelon
    {   88, 1852,     353, 19, }, // America/Noronha
    {   88, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   88, 8347,     392, 20, }, // America/North_Dakota/Center
    {   88, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   88,  393,     435,  4, }, // America/Nuuk
    {   88, 8495,     439,  8, }, // America/Santarem
    {   88, 1880,     447,  9, }, // America/Sao_Paulo
    {   88, 6918,     456, 16, }, // America/Scoresbysund
    {   88, 8526,     472, 14, }, // America/St_Barthelemy
    {   88, 2063,     486, 10, }, // America/St_Johns
    {   88, 5882,     496,  9, }, // America/St_Kitts
    {   88, 5899,     505,  9, }, // America/St_Lucia
    {   88,  855,     514, 10, }, // America/St_Thomas
    {   88, 5932,     524, 11, }, // America/St_Vincent
    {   88, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   88, 7295,     643,  5, }, // Antarctica/Syowa
    {   88, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   88, 4790,     704,  5, }, // Asia/Hovd
    {   88, 1187,     709,  9, }, // Asia/Kathmandu
    {   88,  994,     718,  7, }, // Asia/Kolkata
    {   88, 1213,     725,  5, }, // Asia/Macau
    {   88, 1161,     747,  6, }, // Asia/Urumqi
    {   88, 1237,     753,  6, }, // Asia/Yangon
    {   88, 6647,    4413,  8, }, // Atlantic/Canary
    {   88, 1397,     767,  5, }, // Atlantic/Faroe
    {   88, 6840,     773, 10, }, // Atlantic/St_Helena
    {   88, 8790,     799,  8, }, // Europe/Busingen
    {   88, 2585,     807,  8, }, // Europe/Chisinau
    {   88, 2529,     815,  4, }, // Europe/Kyiv
    {   88, 6221,     819,  6, }, // Europe/Tirane
    {   88, 5048,    4421,  7, }, // Indian/Comoro
    {   88, 7260,     896,  4, }, // Indian/Mahe
    {   88, 7211,     900,  7, }, // Indian/Reunion
    {   88, 3176,     922,  5, }, // Pacific/Chuuk
    {   88, 6697,     940,  9, }, // Pacific/Galapagos
    {   88, 3068,     957,  6, }, // Pacific/Kanton
    {   88, 7117,    1028,  6, }, // Pacific/Noumea
    {   88, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   88, 7405,    1068, 15, }, // Pacific/Wallis
    {   89,   14,       0,  6, }, // Africa/Asmara Chiga/Latin/Uganda
    {   89, 5185,       6,  8, }, // Africa/El_Aaiun
    {   89, 6888,      14,  4, }, // Africa/Lome
    {   89, 5290,      18,  9, }, // Africa/Ndjamena
    {   89, 4454,      27,  8, }, // Africa/Sao_Tome
    {   89, 4573,      35,  9, }, // America/Araguaina
    {   89,  270,      44,  7, }, // America/Argentina/Cordoba
    {   89, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {   89, 7571,      63,  7, }, // America/Argentina/Tucuman
    {   89, 4271,      70,  8, }, // America/Asuncion
    {   89,  237,      78,  8, }, // America/Atikokan
    {   89, 7623,      86, 17, }, // America/Bahia_Banderas
    {   89, 7646,     103,  5, }, // America/Belem
    {   89, 4380,     108,  6, }, // America/Bogota
    {   89, 3887,     114,  6, }, // America/Cancun
    {   89, 7774,     120, 13, }, // America/Ciudad_Juarez
    {   89, 3810,     133,  6, }, // America/Cuiaba
    {   89, 5742,     139,  7, }, // America/Curacao
    {   89, 7887,     146,  8, }, // America/Eirunepe
    {   89,  481,     154, 13, }, // America/Indiana/Knox
    {   89, 7979,     167, 16, }, // America/Indiana/Marengo
    {   89, 8003,     183, 19, }, // America/Indiana/Petersburg
    {   89, 8030,     202, 18, }, // America/Indiana/Tell_City
    {   89, 8056,     220, 14, }, // America/Indiana/Vevay
    {   89, 8078,     234, 18, }, // America/Indiana/Vincennes
    {   89, 8104,     252, 16, }, // America/Indiana/Winamac
    {   89, 8143,     268, 20, }, // America/Kentucky/Monticello
    {   89, 5951,     288, 22, }, // America/Lower_Princes
    {   89, 8171,     310,  6, }, // America/Maceio
    {   89, 2919,     316,  8, }, // America/Mazatlan
    {   89, 8238,     324,  6, }, // America/Merida
    {   89, 2951,    4381, 16, }, // America/Mexico_City
    {   89, 4410,     341, 12, }, // America/Miquelon
    {   89, 1852,     353, 19, }, // America/Noronha
    {   89, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {   89, 8347,     392, 20, }, // America/North_Dakota/Center
    {   89, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {   89,  393,     435,  4, }, // America/Nuuk
    {   89, 8495,     439,  8, }, // America/Santarem
    {   89, 1880,     447,  9, }, // America/Sao_Paulo
    {   89, 6918,     456, 16, }, // America/Scoresbysund
    {   89, 8526,     472, 14, }, // America/St_Barthelemy
    {   89, 2063,     486, 10, }, // America/St_Johns
    {   89, 5882,     496,  9, }, // America/St_Kitts
    {   89, 5899,     505,  9, }, // America/St_Lucia
    {   89,  855,     514, 10, }, // America/St_Thomas
    {   89, 5932,     524, 11, }, // America/St_Vincent
    {   89, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {   89, 7295,     643,  5, }, // Antarctica/Syowa
    {   89, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {   89, 4790,     704,  5, }, // Asia/Hovd
    {   89, 1187,     709,  9, }, // Asia/Kathmandu
    {   89,  994,     718,  7, }, // Asia/Kolkata
    {   89, 1213,     725,  5, }, // Asia/Macau
    {   89, 1161,     747,  6, }, // Asia/Urumqi
    {   89, 1237,     753,  6, }, // Asia/Yangon
    {   89, 6647,    4413,  8, }, // Atlantic/Canary
    {   89, 1397,     767,  5, }, // Atlantic/Faroe
    {   89, 6840,     773, 10, }, // Atlantic/St_Helena
    {   89, 8790,     799,  8, }, // Europe/Busingen
    {   89, 2585,     807,  8, }, // Europe/Chisinau
    {   89, 2529,     815,  4, }, // Europe/Kyiv
    {   89, 6221,     819,  6, }, // Europe/Tirane
    {   89, 5048,    4421,  7, }, // Indian/Comoro
    {   89, 7260,     896,  4, }, // Indian/Mahe
    {   89, 7211,     900,  7, }, // Indian/Reunion
    {   89, 3176,     922,  5, }, // Pacific/Chuuk
    {   89, 6697,     940,  9, }, // Pacific/Galapagos
    {   89, 3068,     957,  6, }, // Pacific/Kanton
    {   89, 7117,    1028,  6, }, // Pacific/Noumea
    {   89, 3115,    1050,  7, }, // Pacific/Pohnpei
    {   89, 7405,    1068, 15, }, // Pacific/Wallis
    {   90, 6807,   44949,  3, }, // Africa/Abidjan Chinese/Simplified Han/China
    {   90, 6779,   43437,  3, }, // Africa/Accra
    {   90, 5078,   56019,  6, }, // Africa/Addis_Ababa
    {   90, 7420,   44958,  4, }, // Africa/Algiers
    {   90,   14,   56025,  4, }, // Africa/Asmara
    {   90,   44,   44966,  3, }, // Africa/Bamako
    {   90, 5276,   43457,  2, }, // Africa/Bangui
    {   90, 6765,   56029,  3, }, // Africa/Banjul
    {   90, 7435,   44969,  2, }, // Africa/Bissau
    {   90, 4976,   44971,  4, }, // Africa/Blantyre
    {   90, 5306,   44975,  5, }, // Africa/Brazzaville
    {   90, 4941,   56032,  4, }, // Africa/Bujumbura
    {   90, 2322,   44980,  2, }, // Africa/Cairo
    {   90, 4136,   44982,  5, }, // Africa/Casablanca
    {   90, 7449,   44987,  2, }, // Africa/Ceuta
    {   90, 6792,   56036,  4, }, // Africa/Conakry
    {   90, 6859,   44989,  3, }, // Africa/Dakar
    {   90, 5149,   56040,  6, }, // Africa/Dar_es_Salaam
    {   90, 5062,   56046,  3, }, // Africa/Djibouti
    {   90, 5262,   43498,  3, }, // Africa/Douala
    {   90, 5185,   43501,  3, }, // Africa/El_Aaiun
    {   90, 6872,   56049,  3, }, // Africa/Freetown
    {   90, 4925,   56052,  4, }, // Africa/Gaborone
    {   90, 5034,   43511,  3, }, // Africa/Harare
    {   90, 4498,   56056,  5, }, // Africa/Johannesburg
    {   90, 4518,   43519,  2, }, // Africa/Juba
    {   90, 5170,   43521,  3, }, // Africa/Kampala
    {   90, 4543,   43524,  3, }, // Africa/Khartoum
    {   90, 4992,   43527,  3, }, // Africa/Kigali
    {   90, 5325,   56061,  3, }, // Africa/Kinshasa
    {   90, 4763,   56064,  3, }, // Africa/Lagos
    {   90, 5355,   56067,  4, }, // Africa/Libreville
    {   90, 6888,   43539,  2, }, // Africa/Lome
    {   90, 5230,   45000,  3, }, // Africa/Luanda
    {   90, 4958,   45003,  4, }, // Africa/Lubumbashi
    {   90, 5020,   56071,  3, }, // Africa/Lusaka
    {   90, 5341,   45007,  3, }, // Africa/Malabo
    {   90, 5006,   45010,  3, }, // Africa/Maputo
    {   90, 5216,   56074,  3, }, // Africa/Maseru
    {   90, 5201,   56077,  4, }, // Africa/Mbabane
    {   90, 5132,   56081,  4, }, // Africa/Mogadishu
    {   90, 7053,   45016,  4, }, // Africa/Monrovia
    {   90, 3872,   56085,  3, }, // Africa/Nairobi
    {   90, 5290,   45020,  4, }, // Africa/Ndjamena
    {   90, 5373,   45024,  3, }, // Africa/Niamey
    {   90, 6822,   56088,  5, }, // Africa/Nouakchott
    {   90, 6746,   43584,  4, }, // Africa/Ouagadougou
    {   90, 5244,   56093,  4, }, // Africa/Porto-Novo
    {   90, 4454,   45034,  3, }, // Africa/Sao_Tome
    {   90, 2868,   43595,  4, }, // Africa/Tripoli
    {   90, 6573,   43599,  3, }, // Africa/Tunis
    {   90, 4171,   45037,  4, }, // Africa/Windhoek
    {   90,  132,   56097,  3, }, // America/Adak
    {   90, 3365,   56100,  4, }, // America/Anchorage
    {   90, 5626,   56104,  3, }, // America/Anguilla
    {   90, 5643,   56107,  3, }, // America/Antigua
    {   90, 4573,   56110,  5, }, // America/Araguaina
    {   90,  166,   45044,  7, }, // America/Argentina/Buenos_Aires
    {   90,   91,   45051,  4, }, // America/Argentina/Catamarca
    {   90,  270,   56115,  4, }, // America/Argentina/Cordoba
    {   90,  441,   43637,  3, }, // America/Argentina/Jujuy
    {   90, 7462,   56119,  4, }, // America/Argentina/La_Rioja
    {   90,  565,   45058,  3, }, // America/Argentina/Mendoza
    {   90, 7489,   45061,  6, }, // America/Argentina/Rio_Gallegos
    {   90, 7520,   45067,  3, }, // America/Argentina/Salta
    {   90, 7544,   45070,  3, }, // America/Argentina/San_Juan
    {   90, 5599,   56123,  4, }, // America/Argentina/San_Luis
    {   90, 7571,   56127,  3, }, // America/Argentina/Tucuman
    {   90, 7597,   45079,  4, }, // America/Argentina/Ushuaia
    {   90, 5659,   56130,  3, }, // America/Aruba
    {   90, 4271,   45083,  3, }, // America/Asuncion
    {   90,  237,   43674,  4, }, // America/Atikokan
    {   90, 3698,   45086,  3, }, // America/Bahia
    {   90, 7623,   45086,  7, }, // America/Bahia_Banderas
    {   90, 5673,   56133,  4, }, // America/Barbados
    {   90, 7646,   45096,  2, }, // America/Belem
    {   90, 5426,   56137,  3, }, // America/Belize
    {   90, 7660,   56140,  6, }, // America/Blanc-Sablon
    {   90, 7681,   56146,  5, }, // America/Boa_Vista
    {   90, 4380,   43705,  3, }, // America/Bogota
    {   90, 7699,   56151,  3, }, // America/Boise
    {   90, 7713,   45110,  3, }, // America/Cambridge_Bay
    {   90, 7735,   56154,  3, }, // America/Campo_Grande
    {   90, 3887,   43716,  2, }, // America/Cancun
    {   90, 4713,   56157,  4, }, // America/Caracas
    {   90, 4364,   56161,  2, }, // America/Cayenne
    {   90, 5515,   45118,  2, }, // America/Cayman
    {   90, 2262,   43728,  3, }, // America/Chicago
    {   90, 7756,   56163,  3, }, // America/Chihuahua
    {   90, 7774,   45125,  4, }, // America/Ciudad_Juarez
    {   90, 5441,   56166,  5, }, // America/Costa_Rica
    {   90, 7796,   43743,  4, }, // America/Coyhaique
    {   90, 7814,   45129,  4, }, // America/Creston
    {   90, 3810,   56171,  3, }, // America/Cuiaba
    {   90, 5742,   45133,  3, }, // America/Curacao
    {   90, 7830,   45136,  4, }, // America/Danmarkshavn
    {   90, 7851,   43761,  2, }, // America/Dawson
    {   90, 7866,   43763,  5, }, // America/Dawson_Creek
    {   90,  805,   43768,  2, }, // America/Denver
    {   90, 3484,   43770,  3, }, // America/Detroit
    {   90, 5758,   56174,  4, }, // America/Dominica
    {   90,  893,   56178,  4, }, // America/Edmonton
    {   90, 7887,   56182,  4, }, // America/Eirunepe
    {   90, 5460,   45144,  4, }, // America/El_Salvador
    {   90, 7904,   45148,  4, }, // America/Fort_Nelson
    {   90, 7924,   56186,  4, }, // America/Fortaleza
    {   90, 7942,   56190,  4, }, // America/Glace_Bay
    {   90, 6900,   56194,  3, }, // America/Goose_Bay
    {   90, 4631,   43803,  3, }, // America/Grand_Turk
    {   90, 5789,   56197,  4, }, // America/Grenada
    {   90, 5805,   56201,  4, }, // America/Guadeloupe
    {   90, 3779,   56205,  4, }, // America/Guatemala
    {   90, 4860,   45170,  4, }, // America/Guayaquil
    {   90, 6951,   56209,  3, }, // America/Guyana
    {   90, 1941,   56212,  5, }, // America/Halifax
    {   90, 2283,   43831,  3, }, // America/Havana
    {   90, 7960,   45177,  4, }, // America/Hermosillo
    {   90,  348,   56217,  7, }, // America/Indiana/Indianapolis
    {   90,  481,   56224,  8, }, // America/Indiana/Knox
    {   90, 7979,   56232,  8, }, // America/Indiana/Marengo
    {   90, 8003,   56240,  9, }, // America/Indiana/Petersburg
    {   90, 8030,   56249,  8, }, // America/Indiana/Tell_City
    {   90, 8056,   56257,  8, }, // America/Indiana/Vevay
    {   90, 8078,   56265,  8, }, // America/Indiana/Vincennes
    {   90, 8104,   56273,  9, }, // America/Indiana/Winamac
    {   90, 8128,   56282,  4, }, // America/Inuvik
    {   90,  660,   43905,  3, }, // America/Iqaluit
    {   90, 2801,   45233,  3, }, // America/Jamaica
    {   90, 5399,   45236,  2, }, // America/Juneau
    {   90,  521,   45238,  5, }, // America/Kentucky/Louisville
    {   90, 8143,   56286,  8, }, // America/Kentucky/Monticello
    {   90, 5723,   45251,  5, }, // America/Kralendijk
    {   90, 4395,   43931,  3, }, // America/La_Paz
    {   90, 7169,   45256,  2, }, // America/Lima
    {   90, 3258,   45258,  3, }, // America/Los_Angeles
    {   90, 5951,   45261,  4, }, // America/Lower_Princes
    {   90, 8171,   56294,  3, }, // America/Maceio
    {   90, 8186,   56297,  3, }, // America/Managua
    {   90, 1910,   56300,  3, }, // America/Manaus
    {   90, 5916,   45274,  4, }, // America/Marigot
    {   90, 5824,   56303,  4, }, // America/Martinique
    {   90, 8202,   45282,  5, }, // America/Matamoros
    {   90, 2919,   45287,  4, }, // America/Mazatlan
    {   90, 8220,   56307,  4, }, // America/Menominee
    {   90, 8238,   45295,  3, }, // America/Merida
    {   90, 8253,   43976,  6, }, // America/Metlakatla
    {   90, 2951,   56311,  4, }, // America/Mexico_City
    {   90, 4410,   56315,  3, }, // America/Miquelon
    {   90, 8272,   45301,  3, }, // America/Moncton
    {   90, 8288,   56318,  3, }, // America/Monterrey
    {   90, 4117,   56321,  5, }, // America/Montevideo
    {   90, 5843,   56326,  5, }, // America/Montserrat
    {   90, 5500,   56331,  2, }, // America/Nassau
    {   90, 2381,   45311,  2, }, // America/New_York
    {   90, 8306,   45313,  2, }, // America/Nome
    {   90, 1852,   56333,  4, }, // America/Noronha
    {   90, 8319,   56337,  8, }, // America/North_Dakota/Beulah
    {   90, 8347,   56345,  7, }, // America/North_Dakota/Center
    {   90, 8375,   56352,  9, }, // America/North_Dakota/New_Salem
    {   90,  393,   44034,  2, }, // America/Nuuk
    {   90, 8406,   45341,  4, }, // America/Ojinaga
    {   90, 2358,   45345,  3, }, // America/Panama
    {   90, 6192,   56361,  5, }, // America/Paramaribo
    {   90, 2975,   45353,  3, }, // America/Phoenix
    {   90, 3964,   44051,  3, }, // America/Port-au-Prince
    {   90, 5973,   44054,  4, }, // America/Port_of_Spain
    {   90, 8422,   56366,  4, }, // America/Porto_Velho
    {   90, 5862,   44061,  4, }, // America/Puerto_Rico
    {   90, 4049,   45359,  6, }, // America/Punta_Arenas
    {   90, 8442,   45365,  3, }, // America/Rankin_Inlet
    {   90, 8463,   56370,  3, }, // America/Recife
    {   90, 1997,   45368,  3, }, // America/Regina
    {   90, 8478,   56373,  4, }, // America/Resolute
    {   90,  695,   56377,  5, }, // America/Rio_Branco
    {   90, 8495,   45379,  3, }, // America/Santarem
    {   90, 2203,   56382,  4, }, // America/Santiago
    {   90, 6130,   56386,  4, }, // America/Santo_Domingo
    {   90, 1880,   45390,  3, }, // America/Sao_Paulo
    {   90, 6918,   56390,  7, }, // America/Scoresbysund
    {   90, 8512,   45400,  3, }, // America/Sitka
    {   90, 8526,   56397,  6, }, // America/St_Barthelemy
    {   90, 2063,   56403,  4, }, // America/St_Johns
    {   90, 5882,   45412,  3, }, // America/St_Kitts
    {   90, 5899,   56407,  4, }, // America/St_Lucia
    {   90,  855,   45419,  4, }, // America/St_Thomas
    {   90, 5932,   56411,  4, }, // America/St_Vincent
    {   90, 8548,   45426,  7, }, // America/Swift_Current
    {   90, 5480,   56415,  6, }, // America/Tegucigalpa
    {   90, 5775,   56421,  2, }, // America/Thule
    {   90,  313,   56423,  3, }, // America/Tijuana
    {   90,  608,   45436,  3, }, // America/Toronto
    {   90, 5707,   45439,  4, }, // America/Tortola
    {   90, 2095,   45443,  3, }, // America/Vancouver
    {   90, 2146,   45446,  4, }, // America/Whitehorse
    {   90,  734,   45450,  3, }, // America/Winnipeg
    {   90, 8570,   56426,  4, }, // America/Yakutat
    {   90, 6020,   56430,  2, }, // Antarctica/Casey
    {   90, 6113,   45458,  3, }, // Antarctica/Davis
    {   90, 6152,   56432,  6, }, // Antarctica/DumontDUrville
    {   90, 8586,   56438,  4, }, // Antarctica/Macquarie
    {   90, 7085,   44185,  2, }, // Antarctica/Mawson
    {   90,  932,   45469,  4, }, // Antarctica/McMurdo
    {   90, 8607,   56442,  3, }, // Antarctica/Palmer
    {   90, 7226,   45475,  3, }, // Antarctica/Rothera
    {   90, 7295,   44196,  2, }, // Antarctica/Syowa
    {   90, 8625,   56445,  3, }, // Antarctica/Troll
    {   90, 7374,   44202,  4, }, // Antarctica/Vostok
    {   90, 1431,   56448,  4, }, // Arctic/Longyearbyen
    {   90, 5589,   45480,  2, }, // Asia/Aden
    {   90, 5414,   45482,  4, }, // Asia/Almaty
    {   90, 3987,   44217,  2, }, // Asia/Amman
    {   90, 5530,   56452,  4, }, // Asia/Anadyr
    {   90, 5542,   44222,  3, }, // Asia/Aqtau
    {   90, 5387,   56456,  4, }, // Asia/Aqtobe
    {   90,  966,   56460,  5, }, // Asia/Ashgabat
    {   90, 8642,   45486,  3, }, // Asia/Atyrau
    {   90, 3626,   45489,  3, }, // Asia/Baghdad
    {   90, 5553,   44240,  2, }, // Asia/Bahrain
    {   90, 3672,   45492,  2, }, // Asia/Baku
    {   90, 4485,   44242,  2, }, // Asia/Bangkok
    {   90, 3590,   45494,  4, }, // Asia/Barnaul
    {   90, 4105,   45498,  3, }, // Asia/Beirut
    {   90, 3797,   45501,  4, }, // Asia/Bishkek
    {   90, 6008,   56465,  2, }, // Asia/Brunei
    {   90, 4620,   44257,  2, }, // Asia/Chita
    {   90, 4530,   56467,  3, }, // Asia/Colombo
    {   90, 4559,   45510,  4, }, // Asia/Damascus
    {   90, 1095,   45514,  2, }, // Asia/Dhaka
    {   90, 6211,   44268,  2, }, // Asia/Dili
    {   90, 3615,   56470,  2, }, // Asia/Dubai
    {   90, 6178,   56472,  3, }, // Asia/Dushanbe
    {   90, 8654,   45519,  5, }, // Asia/Famagusta
    {   90, 8669,   56475,  2, }, // Asia/Gaza
    {   90, 4814,   56477,  3, }, // Asia/Hebron
    {   90, 1261,   44285,  4, }, // Asia/Ho_Chi_Minh
    {   90, 2706,   44296,  2, }, // Asia/Hong_Kong
    {   90, 4790,   44303,  3, }, // Asia/Hovd
    {   90, 4203,   56480,  5, }, // Asia/Irkutsk
    {   90, 7025,   45545,  3, }, // Asia/Jakarta
    {   90, 7011,   56485,  4, }, // Asia/Jayapura
    {   90, 1292,   44318,  4, }, // Asia/Jerusalem
    {   90, 3579,   45552,  3, }, // Asia/Kabul
    {   90, 4335,   44325,  3, }, // Asia/Kamchatka
    {   90, 4258,   56489,  3, }, // Asia/Karachi
    {   90, 1187,   45555,  4, }, // Asia/Kathmandu
    {   90, 8679,   56492,  3, }, // Asia/Khandyga
    {   90,  994,   45559,  4, }, // Asia/Kolkata
    {   90, 4216,   45563,  8, }, // Asia/Krasnoyarsk
    {   90, 4878,   44350,  3, }, // Asia/Kuala_Lumpur
    {   90, 5995,   45571,  2, }, // Asia/Kuching
    {   90, 5566,   44355,  3, }, // Asia/Kuwait
    {   90, 1213,   45580,  2, }, // Asia/Macau
    {   90, 4036,   45587,  3, }, // Asia/Magadan
    {   90, 1351,   56495,  3, }, // Asia/Makassar
    {   90, 7182,   45594,  3, }, // Asia/Manila
    {   90, 6939,   56498,  4, }, // Asia/Muscat
    {   90, 2556,   56502,  4, }, // Asia/Nicosia
    {   90, 8693,   45605,  6, }, // Asia/Novokuznetsk
    {   90, 4154,   45611,  5, }, // Asia/Novosibirsk
    {   90, 4248,   44401,  4, }, // Asia/Omsk
    {   90, 7145,   45616,  3, }, // Asia/Oral
    {   90, 6980,   45619,  2, }, // Asia/Phnom_Penh
    {   90, 8711,   44410,  2, }, // Asia/Pontianak
    {   90, 4233,   44412,  2, }, // Asia/Pyongyang
    {   90, 5578,   56506,  3, }, // Asia/Qatar
    {   90, 8726,   56509,  4, }, // Asia/Qostanay
    {   90, 4288,   56513,  5, }, // Asia/Qyzylorda
    {   90, 3603,   56518,  3, }, // Asia/Riyadh
    {   90, 4427,   56521,  3, }, // Asia/Sakhalin
    {   90, 7245,   45632,  4, }, // Asia/Samarkand
    {   90, 3298,   45636,  2, }, // Asia/Seoul
    {   90, 1055,   44438,  2, }, // Asia/Shanghai
    {   90, 3319,   44440,  3, }, // Asia/Singapore
    {   90, 4316,   44443,  6, }, // Asia/Srednekolymsk
    {   90, 3282,   44449,  2, }, // Asia/Taipei
    {   90, 4800,   44451,  3, }, // Asia/Tashkent
    {   90, 3934,   44454,  4, }, // Asia/Tbilisi
    {   90, 2774,   45638,  3, }, // Asia/Tehran
    {   90, 1319,   44461,  2, }, // Asia/Thimphu
    {   90, 2823,   45641,  2, }, // Asia/Tokyo
    {   90, 4591,   44465,  4, }, // Asia/Tomsk
    {   90, 1023,   45643,  4, }, // Asia/Ulaanbaatar
    {   90, 1161,   45647,  4, }, // Asia/Urumqi
    {   90, 8740,   45651,  4, }, // Asia/Ust-Nera
    {   90, 6996,   56524,  2, }, // Asia/Vientiane
    {   90, 4729,   45655,  3, }, // Asia/Vladivostok
    {   90, 4847,   56526,  4, }, // Asia/Yakutsk
    {   90, 1237,   44490,  2, }, // Asia/Yangon
    {   90, 3902,   56530,  5, }, // Asia/Yekaterinburg
    {   90, 3766,   56535,  3, }, // Asia/Yerevan
    {   90, 3682,   45670,  5, }, // Atlantic/Azores
    {   90, 5690,   56538,  3, }, // Atlantic/Bermuda
    {   90, 6647,   56541,  3, }, // Atlantic/Canary
    {   90, 3746,   56544,  3, }, // Atlantic/Cape_Verde
    {   90, 1397,   45684,  2, }, // Atlantic/Faroe
    {   90, 8754,   56547,  3, }, // Atlantic/Madeira
    {   90, 2750,   56550,  5, }, // Atlantic/Reykjavik
    {   90, 7272,   45698,  4, }, // Atlantic/South_Georgia
    {   90, 6840,   45702,  4, }, // Atlantic/St_Helena
    {   90, 6663,   56555,  3, }, // Atlantic/Stanley
    {   90, 1672,   56558,  4, }, // Australia/Adelaide
    {   90, 1637,   56562,  4, }, // Australia/Brisbane
    {   90, 1801,   45707,  5, }, // Australia/Broken_Hill
    {   90, 1585,   45712,  3, }, // Australia/Darwin
    {   90, 3656,   44556,  3, }, // Australia/Eucla
    {   90, 1518,   56566,  3, }, // Australia/Hobart
    {   90, 8771,   44562,  3, }, // Australia/Lindeman
    {   90, 1549,   45715,  4, }, // Australia/Lord_Howe
    {   90, 1729,   45719,  3, }, // Australia/Melbourne
    {   90, 1764,   56569,  2, }, // Australia/Perth
    {   90, 1465,   56571,  2, }, // Australia/Sydney
    {   90, 6460,   44576,  5, }, // Europe/Amsterdam
    {   90, 6235,   45722,  3, }, // Europe/Andorra
    {   90, 3639,   44584,  5, }, // Europe/Astrakhan
    {   90, 2302,   44589,  2, }, // Europe/Athens
    {   90, 6355,   56573,  5, }, // Europe/Belgrade
    {   90, 4776,   44595,  2, }, // Europe/Berlin
    {   90, 6507,   56578,  6, }, // Europe/Bratislava
    {   90, 2169,   45729,  4, }, // Europe/Brussels
    {   90, 3947,   44607,  5, }, // Europe/Bucharest
    {   90, 3825,   45733,  4, }, // Europe/Budapest
    {   90, 8790,   44616,  3, }, // Europe/Busingen
    {   90, 2585,   56584,  4, }, // Europe/Chisinau
    {   90, 6308,   44622,  4, }, // Europe/Copenhagen
    {   90, 2340,   44626,  3, }, // Europe/Dublin
    {   90, 6326,   45737,  4, }, // Europe/Gibraltar
    {   90, 8806,   56588,  3, }, // Europe/Guernsey
    {   90, 6631,   45744,  4, }, // Europe/Helsinki
    {   90, 8822,   56591,  3, }, // Europe/Isle_of_Man
    {   90, 1132,   56594,  5, }, // Europe/Istanbul
    {   90, 8841,   45750,  3, }, // Europe/Jersey
    {   90, 3998,   45753,  5, }, // Europe/Kaliningrad
    {   90, 8855,   44654,  3, }, // Europe/Kirov
    {   90, 2529,   45758,  2, }, // Europe/Kyiv
    {   90, 3232,   44659,  3, }, // Europe/Lisbon
    {   90, 6525,   56599,  5, }, // Europe/Ljubljana
    {   90, 2503,   45764,  2, }, // Europe/London
    {   90, 6384,   45766,  3, }, // Europe/Luxembourg
    {   90, 4911,   45769,  3, }, // Europe/Madrid
    {   90, 6416,   56604,  3, }, // Europe/Malta
    {   90, 6601,   45775,  3, }, // Europe/Mariehamn
    {   90, 3712,   44680,  3, }, // Europe/Minsk
    {   90, 6429,   45778,  3, }, // Europe/Monaco
    {   90, 3556,   44686,  3, }, // Europe/Moscow
    {   90, 6477,   45781,  3, }, // Europe/Oslo
    {   90, 4303,   44692,  2, }, // Europe/Paris
    {   90, 6443,   56607,  5, }, // Europe/Podgorica
    {   90, 6294,   44698,  3, }, // Europe/Prague
    {   90, 8868,   44701,  2, }, // Europe/Riga
    {   90, 6343,   45784,  2, }, // Europe/Rome
    {   90, 4350,   56612,  3, }, // Europe/Samara
    {   90, 6489,   56615,  4, }, // Europe/San_Marino
    {   90, 6264,   56619,  4, }, // Europe/Sarajevo
    {   90, 4470,   45793,  4, }, // Europe/Saratov
    {   90, 8880,   56623,  5, }, // Europe/Simferopol
    {   90, 6402,   56628,  4, }, // Europe/Skopje
    {   90, 6618,   56632,  3, }, // Europe/Sofia
    {   90, 6542,   45800,  5, }, // Europe/Stockholm
    {   90, 8898,   44736,  2, }, // Europe/Tallinn
    {   90, 6221,   44738,  3, }, // Europe/Tirane
    {   90, 8913,   45805,  7, }, // Europe/Ulyanovsk
    {   90, 6371,   56635,  3, }, // Europe/Vaduz
    {   90, 6586,   45815,  3, }, // Europe/Vatican
    {   90, 6250,   45818,  3, }, // Europe/Vienna
    {   90, 8930,   45821,  4, }, // Europe/Vilnius
    {   90, 4746,   45825,  5, }, // Europe/Volgograd
    {   90, 3209,   45830,  2, }, // Europe/Warsaw
    {   90, 6280,   56638,  4, }, // Europe/Zagreb
    {   90, 6559,   45832,  3, }, // Europe/Zurich
    {   90, 5097,   44775,  6, }, // Indian/Antananarivo
    {   90, 6966,   44781,  3, }, // Indian/Chagos
    {   90, 6065,   45835,  3, }, // Indian/Christmas
    {   90, 6082,   56642,  3, }, // Indian/Cocos
    {   90, 5048,   45843,  3, }, // Indian/Comoro
    {   90, 6680,   45848,  4, }, // Indian/Kerguelen
    {   90, 7260,   45853,  3, }, // Indian/Mahe
    {   90, 7069,   56645,  4, }, // Indian/Maldives
    {   90, 4088,   56649,  4, }, // Indian/Mauritius
    {   90, 5117,   45860,  3, }, // Indian/Mayotte
    {   90, 7211,   56653,  3, }, // Indian/Reunion
    {   90, 4441,   45868,  3, }, // Pacific/Apia
    {   90, 3009,   45871,  3, }, // Pacific/Auckland
    {   90, 3725,   45874,  4, }, // Pacific/Bougainville
    {   90, 3034,   56656,  3, }, // Pacific/Chatham
    {   90, 3176,   56659,  5, }, // Pacific/Chuuk
    {   90, 2239,   56664,  4, }, // Pacific/Easter
    {   90, 7360,   44838,  3, }, // Pacific/Efate
    {   90, 7327,   44841,  3, }, // Pacific/Fakaofo
    {   90, 3921,   45881,  2, }, // Pacific/Fiji
    {   90, 7343,   56668,  4, }, // Pacific/Funafuti
    {   90, 6697,   56672,  4, }, // Pacific/Galapagos
    {   90, 6715,   45889,  3, }, // Pacific/Gambier
    {   90, 3841,   56676,  6, }, // Pacific/Guadalcanal
    {   90, 6037,   45900,  2, }, // Pacific/Guam
    {   90, 2725,   44869,  3, }, // Pacific/Honolulu
    {   90, 3068,   56682,  3, }, // Pacific/Kanton
    {   90, 4017,   45904,  6, }, // Pacific/Kiritimati
    {   90, 7038,   56685,  3, }, // Pacific/Kosrae
    {   90, 2844,   56688,  3, }, // Pacific/Kwajalein
    {   90, 4896,   56691,  3, }, // Pacific/Majuro
    {   90, 4070,   56694,  4, }, // Pacific/Marquesas
    {   90, 8945,   45922,  3, }, // Pacific/Midway
    {   90, 7103,   56698,  2, }, // Pacific/Nauru
    {   90, 7132,   45927,  2, }, // Pacific/Niue
    {   90, 4187,   45930,  3, }, // Pacific/Norfolk
    {   90, 7117,   56700,  3, }, // Pacific/Noumea
    {   90, 3145,   56703,  4, }, // Pacific/Pago_Pago
    {   90, 7155,   56707,  2, }, // Pacific/Palau
    {   90, 7194,   56709,  4, }, // Pacific/Pitcairn
    {   90, 3115,   56713,  4, }, // Pacific/Pohnpei
    {   90, 4826,   56717,  5, }, // Pacific/Port_Moresby
    {   90, 6095,   45944,  4, }, // Pacific/Rarotonga
    {   90, 6050,   44931,  2, }, // Pacific/Saipan
    {   90, 7312,   56722,  3, }, // Pacific/Tahiti
    {   90, 6731,   44936,  3, }, // Pacific/Tarawa
    {   90, 4602,   45948,  4, }, // Pacific/Tongatapu
    {   90, 7392,   44944,  2, }, // Pacific/Wake
    {   90, 7405,   44946,  3, }, // Pacific/Wallis
    {   95, 6918,   56725,  6, }, // America/Scoresbysund Chinese/Simplified Han/Singapore
    {   96, 6807,   56731,  3, }, // Africa/Abidjan Chinese/Traditional Han/Hong Kong
    {   96,   14,   56734,  4, }, // Africa/Asmara
    {   96, 5276,   56738,  2, }, // Africa/Bangui
    {   96, 6792,   56740,  4, }, // Africa/Conakry
    {   96, 5149,   56744,  6, }, // Africa/Dar_es_Salaam
    {   96, 4498,   56750,  5, }, // Africa/Johannesburg
    {   96, 5325,   56755,  3, }, // Africa/Kinshasa
    {   96, 5355,   56758,  3, }, // Africa/Libreville
    {   96, 5230,   56761,  3, }, // Africa/Luanda
    {   96, 5020,   56764,  3, }, // Africa/Lusaka
    {   96, 5216,   56767,  3, }, // Africa/Maseru
    {   96, 3872,   56770,  3, }, // Africa/Nairobi
    {   96, 4171,   56773,  4, }, // Africa/Windhoek
    {   96,  132,   56777,  3, }, // America/Adak
    {   96, 4573,   56780,  5, }, // America/Araguaina
    {   96,  270,   56785,  4, }, // America/Argentina/Cordoba
    {   96, 7462,   56789,  4, }, // America/Argentina/La_Rioja
    {   96, 5659,   56793,  3, }, // America/Aruba
    {   96, 4271,   56796,  3, }, // America/Asuncion
    {   96, 3698,   56799,  3, }, // America/Bahia
    {   96, 7623,   56802,  8, }, // America/Bahia_Banderas
    {   96, 5426,   56810,  3, }, // America/Belize
    {   96, 7681,   56813,  5, }, // America/Boa_Vista
    {   96, 7756,   56818,  3, }, // America/Chihuahua
    {   96, 7774,   43734,  4, }, // America/Ciudad_Juarez
    {   96, 5441,   56821,  5, }, // America/Costa_Rica
    {   96, 3810,   56826,  3, }, // America/Cuiaba
    {   96, 7866,   56829,  3, }, // America/Dawson_Creek
    {   96,  893,   56832,  3, }, // America/Edmonton
    {   96, 7924,   56835,  4, }, // America/Fortaleza
    {   96, 7942,   56839,  4, }, // America/Glace_Bay
    {   96, 5789,   56843,  4, }, // America/Grenada
    {   96, 5805,   56847,  4, }, // America/Guadeloupe
    {   96, 3779,   56851,  4, }, // America/Guatemala
    {   96, 6951,   56855,  3, }, // America/Guyana
    {   96, 2283,   56858,  3, }, // America/Havana
    {   96,  348,   56861,  7, }, // America/Indiana/Indianapolis
    {   96,  481,   56868,  8, }, // America/Indiana/Knox
    {   96, 7979,   56876,  8, }, // America/Indiana/Marengo
    {   96, 8003,   56884,  8, }, // America/Indiana/Petersburg
    {   96, 8030,   56892,  8, }, // America/Indiana/Tell_City
    {   96, 8056,   56900,  7, }, // America/Indiana/Vevay
    {   96, 8078,   56907,  8, }, // America/Indiana/Vincennes
    {   96, 8104,   56915,  9, }, // America/Indiana/Winamac
    {   96, 8128,   56924,  4, }, // America/Inuvik
    {   96,  521,   56928,  4, }, // America/Kentucky/Louisville
    {   96, 8171,   56932,  3, }, // America/Maceio
    {   96, 8186,   56935,  3, }, // America/Managua
    {   96, 5824,   56938,  4, }, // America/Martinique
    {   96, 8220,   56942,  4, }, // America/Menominee
    {   96, 4117,   56946,  5, }, // America/Montevideo
    {   96, 5843,   56951,  5, }, // America/Montserrat
    {   96, 5500,   56956,  2, }, // America/Nassau
    {   96, 1852,   56958,  4, }, // America/Noronha
    {   96, 8319,   56962,  8, }, // America/North_Dakota/Beulah
    {   96, 8347,   56970,  8, }, // America/North_Dakota/Center
    {   96, 8375,   56978,  9, }, // America/North_Dakota/New_Salem
    {   96, 8422,   56987,  3, }, // America/Porto_Velho
    {   96,  695,   56990,  5, }, // America/Rio_Branco
    {   96, 2203,   56995,  4, }, // America/Santiago
    {   96, 6130,   56999,  4, }, // America/Santo_Domingo
    {   96, 8526,   57003,  5, }, // America/St_Barthelemy
    {   96, 2063,   57008,  4, }, // America/St_Johns
    {   96, 5899,   57012,  4, }, // America/St_Lucia
    {   96, 5932,   57016,  4, }, // America/St_Vincent
    {   96, 5480,   57020,  6, }, // America/Tegucigalpa
    {   96, 5775,   57026,  2, }, // America/Thule
    {   96,  313,   57028,  3, }, // America/Tijuana
    {   96, 2146,   57031,  3, }, // America/Whitehorse
    {   96, 8570,   57034,  4, }, // America/Yakutat
    {   96, 6020,   57038,  3, }, // Antarctica/Casey
    {   96, 6113,   57041,  4, }, // Antarctica/Davis
    {   96, 6152,   57045,  6, }, // Antarctica/DumontDUrville
    {   96, 8586,   57051,  3, }, // Antarctica/Macquarie
    {   96, 7085,   57054,  3, }, // Antarctica/Mawson
    {   96,  932,   57057,  5, }, // Antarctica/McMurdo
    {   96, 8607,   57062,  3, }, // Antarctica/Palmer
    {   96, 7226,   57065,  4, }, // Antarctica/Rothera
    {   96, 7295,   57069,  3, }, // Antarctica/Syowa
    {   96, 8625,   57072,  4, }, // Antarctica/Troll
    {   96, 1431,   57076,  4, }, // Arctic/Longyearbyen
    {   96, 5530,   57080,  4, }, // Asia/Anadyr
    {   96, 3797,   57084,  4, }, // Asia/Bishkek
    {   96, 4530,   57088,  3, }, // Asia/Colombo
    {   96, 6178,   57091,  3, }, // Asia/Dushanbe
    {   96, 4814,   57094,  3, }, // Asia/Hebron
    {   96, 4203,   57097,  5, }, // Asia/Irkutsk
    {   96, 7011,   57102,  4, }, // Asia/Jayapura
    {   96, 1351,   57106,  2, }, // Asia/Makassar
    {   96, 6939,   57108,  4, }, // Asia/Muscat
    {   96, 2556,   57112,  4, }, // Asia/Nicosia
    {   96, 5578,   57116,  3, }, // Asia/Qatar
    {   96, 4847,   57119,  4, }, // Asia/Yakutsk
    {   96, 3902,   57123,  5, }, // Asia/Yekaterinburg
    {   96, 8754,   57128,  4, }, // Atlantic/Madeira
    {   96, 6663,   57132,  3, }, // Atlantic/Stanley
    {   96, 1672,   57135,  4, }, // Australia/Adelaide
    {   96, 1637,   57139,  4, }, // Australia/Brisbane
    {   96, 1518,   57143,  3, }, // Australia/Hobart
    {   96, 6355,   57146,  5, }, // Europe/Belgrade
    {   96, 6507,   57151,  6, }, // Europe/Bratislava
    {   96, 2585,   57157,  4, }, // Europe/Chisinau
    {   96, 8806,   57161,  3, }, // Europe/Guernsey
    {   96, 8822,   57164,  3, }, // Europe/Isle_of_Man
    {   96, 6525,   57167,  5, }, // Europe/Ljubljana
    {   96, 6416,   57172,  3, }, // Europe/Malta
    {   96, 6264,   57175,  4, }, // Europe/Sarajevo
    {   96, 6371,   57179,  3, }, // Europe/Vaduz
    {   96, 6280,   57182,  4, }, // Europe/Zagreb
    {   96, 6966,   57186,  5, }, // Indian/Chagos
    {   96, 6082,   57191,  5, }, // Indian/Cocos
    {   96, 5048,   44792,  3, }, // Indian/Comoro
    {   96, 6680,   57196,  6, }, // Indian/Kerguelen
    {   96, 7069,   57202,  4, }, // Indian/Maldives
    {   96, 4088,   57206,  4, }, // Indian/Mauritius
    {   96, 5117,   44813,  3, }, // Indian/Mayotte
    {   96, 7211,   44817,  3, }, // Indian/Reunion
    {   96, 3725,   57210,  5, }, // Pacific/Bougainville
    {   96, 7327,   57215,  5, }, // Pacific/Fakaofo
    {   96, 6715,   44856,  3, }, // Pacific/Gambier
    {   96, 3841,   57220,  7, }, // Pacific/Guadalcanal
    {   96, 7038,   57227,  3, }, // Pacific/Kosrae
    {   96, 2844,   57230,  5, }, // Pacific/Kwajalein
    {   96, 4896,   57235,  3, }, // Pacific/Majuro
    {   96, 4070,   57238,  6, }, // Pacific/Marquesas
    {   96, 7103,   57244,  2, }, // Pacific/Nauru
    {   96, 7194,   57246,  5, }, // Pacific/Pitcairn
    {   96, 4602,   57251,  5, }, // Pacific/Tongatapu
    {   96, 7392,   57256,  3, }, // Pacific/Wake
    {   97, 6807,   56731,  3, }, // Africa/Abidjan Chinese/Traditional Han/Macao
    {   97,   14,   56734,  4, }, // Africa/Asmara
    {   97, 5276,   56738,  2, }, // Africa/Bangui
    {   97, 6792,   56740,  4, }, // Africa/Conakry
    {   97, 5149,   56744,  6, }, // Africa/Dar_es_Salaam
    {   97, 4498,   56750,  5, }, // Africa/Johannesburg
    {   97, 5325,   56755,  3, }, // Africa/Kinshasa
    {   97, 5355,   56758,  3, }, // Africa/Libreville
    {   97, 5230,   56761,  3, }, // Africa/Luanda
    {   97, 5020,   56764,  3, }, // Africa/Lusaka
    {   97, 5216,   56767,  3, }, // Africa/Maseru
    {   97, 3872,   56770,  3, }, // Africa/Nairobi
    {   97, 4171,   56773,  4, }, // Africa/Windhoek
    {   97,  132,   56777,  3, }, // America/Adak
    {   97, 4573,   56780,  5, }, // America/Araguaina
    {   97,  270,   56785,  4, }, // America/Argentina/Cordoba
    {   97, 7462,   56789,  4, }, // America/Argentina/La_Rioja
    {   97, 5659,   56793,  3, }, // America/Aruba
    {   97, 4271,   56796,  3, }, // America/Asuncion
    {   97, 3698,   56799,  3, }, // America/Bahia
    {   97, 7623,   56802,  8, }, // America/Bahia_Banderas
    {   97, 5426,   56810,  3, }, // America/Belize
    {   97, 7681,   56813,  5, }, // America/Boa_Vista
    {   97, 7756,   56818,  3, }, // America/Chihuahua
    {   97, 7774,   43734,  4, }, // America/Ciudad_Juarez
    {   97, 5441,   56821,  5, }, // America/Costa_Rica
    {   97, 3810,   56826,  3, }, // America/Cuiaba
    {   97, 7866,   56829,  3, }, // America/Dawson_Creek
    {   97,  893,   56832,  3, }, // America/Edmonton
    {   97, 7924,   56835,  4, }, // America/Fortaleza
    {   97, 7942,   56839,  4, }, // America/Glace_Bay
    {   97, 5789,   56843,  4, }, // America/Grenada
    {   97, 5805,   56847,  4, }, // America/Guadeloupe
    {   97, 3779,   56851,  4, }, // America/Guatemala
    {   97, 6951,   56855,  3, }, // America/Guyana
    {   97, 2283,   56858,  3, }, // America/Havana
    {   97,  348,   56861,  7, }, // America/Indiana/Indianapolis
    {   97,  481,   56868,  8, }, // America/Indiana/Knox
    {   97, 7979,   56876,  8, }, // America/Indiana/Marengo
    {   97, 8003,   56884,  8, }, // America/Indiana/Petersburg
    {   97, 8030,   56892,  8, }, // America/Indiana/Tell_City
    {   97, 8056,   56900,  7, }, // America/Indiana/Vevay
    {   97, 8078,   56907,  8, }, // America/Indiana/Vincennes
    {   97, 8104,   56915,  9, }, // America/Indiana/Winamac
    {   97, 8128,   56924,  4, }, // America/Inuvik
    {   97,  521,   56928,  4, }, // America/Kentucky/Louisville
    {   97, 8171,   56932,  3, }, // America/Maceio
    {   97, 8186,   56935,  3, }, // America/Managua
    {   97, 5824,   56938,  4, }, // America/Martinique
    {   97, 8220,   56942,  4, }, // America/Menominee
    {   97, 4117,   56946,  5, }, // America/Montevideo
    {   97, 5843,   56951,  5, }, // America/Montserrat
    {   97, 5500,   56956,  2, }, // America/Nassau
    {   97, 1852,   56958,  4, }, // America/Noronha
    {   97, 8319,   56962,  8, }, // America/North_Dakota/Beulah
    {   97, 8347,   56970,  8, }, // America/North_Dakota/Center
    {   97, 8375,   56978,  9, }, // America/North_Dakota/New_Salem
    {   97, 8422,   56987,  3, }, // America/Porto_Velho
    {   97,  695,   56990,  5, }, // America/Rio_Branco
    {   97, 2203,   56995,  4, }, // America/Santiago
    {   97, 6130,   56999,  4, }, // America/Santo_Domingo
    {   97, 8526,   57003,  5, }, // America/St_Barthelemy
    {   97, 2063,   57008,  4, }, // America/St_Johns
    {   97, 5899,   57012,  4, }, // America/St_Lucia
    {   97, 5932,   57016,  4, }, // America/St_Vincent
    {   97, 5480,   57020,  6, }, // America/Tegucigalpa
    {   97, 5775,   57026,  2, }, // America/Thule
    {   97,  313,   57028,  3, }, // America/Tijuana
    {   97, 2146,   57031,  3, }, // America/Whitehorse
    {   97, 8570,   57034,  4, }, // America/Yakutat
    {   97, 6020,   57038,  3, }, // Antarctica/Casey
    {   97, 6113,   57041,  4, }, // Antarctica/Davis
    {   97, 6152,   57045,  6, }, // Antarctica/DumontDUrville
    {   97, 8586,   57051,  3, }, // Antarctica/Macquarie
    {   97, 7085,   57054,  3, }, // Antarctica/Mawson
    {   97,  932,   57057,  5, }, // Antarctica/McMurdo
    {   97, 8607,   57062,  3, }, // Antarctica/Palmer
    {   97, 7226,   57065,  4, }, // Antarctica/Rothera
    {   97, 7295,   57069,  3, }, // Antarctica/Syowa
    {   97, 8625,   57072,  4, }, // Antarctica/Troll
    {   97, 1431,   57076,  4, }, // Arctic/Longyearbyen
    {   97, 5530,   57080,  4, }, // Asia/Anadyr
    {   97, 3797,   57084,  4, }, // Asia/Bishkek
    {   97, 4530,   57088,  3, }, // Asia/Colombo
    {   97, 6178,   57091,  3, }, // Asia/Dushanbe
    {   97, 4814,   57094,  3, }, // Asia/Hebron
    {   97, 4203,   57097,  5, }, // Asia/Irkutsk
    {   97, 7011,   57102,  4, }, // Asia/Jayapura
    {   97, 1351,   57106,  2, }, // Asia/Makassar
    {   97, 6939,   57108,  4, }, // Asia/Muscat
    {   97, 2556,   57112,  4, }, // Asia/Nicosia
    {   97, 5578,   57116,  3, }, // Asia/Qatar
    {   97, 4847,   57119,  4, }, // Asia/Yakutsk
    {   97, 3902,   57123,  5, }, // Asia/Yekaterinburg
    {   97, 8754,   57128,  4, }, // Atlantic/Madeira
    {   97, 6663,   57132,  3, }, // Atlantic/Stanley
    {   97, 1672,   57135,  4, }, // Australia/Adelaide
    {   97, 1637,   57139,  4, }, // Australia/Brisbane
    {   97, 1518,   57143,  3, }, // Australia/Hobart
    {   97, 6355,   57146,  5, }, // Europe/Belgrade
    {   97, 6507,   57151,  6, }, // Europe/Bratislava
    {   97, 2585,   57157,  4, }, // Europe/Chisinau
    {   97, 8806,   57161,  3, }, // Europe/Guernsey
    {   97, 8822,   57164,  3, }, // Europe/Isle_of_Man
    {   97, 6525,   57167,  5, }, // Europe/Ljubljana
    {   97, 6416,   57172,  3, }, // Europe/Malta
    {   97, 6264,   57175,  4, }, // Europe/Sarajevo
    {   97, 6371,   57179,  3, }, // Europe/Vaduz
    {   97, 6280,   57182,  4, }, // Europe/Zagreb
    {   97, 6966,   57186,  5, }, // Indian/Chagos
    {   97, 6082,   57191,  5, }, // Indian/Cocos
    {   97, 5048,   44792,  3, }, // Indian/Comoro
    {   97, 6680,   57196,  6, }, // Indian/Kerguelen
    {   97, 7069,   57202,  4, }, // Indian/Maldives
    {   97, 4088,   57206,  4, }, // Indian/Mauritius
    {   97, 5117,   44813,  3, }, // Indian/Mayotte
    {   97, 7211,   44817,  3, }, // Indian/Reunion
    {   97, 3725,   57210,  5, }, // Pacific/Bougainville
    {   97, 7327,   57215,  5, }, // Pacific/Fakaofo
    {   97, 6715,   44856,  3, }, // Pacific/Gambier
    {   97, 3841,   57220,  7, }, // Pacific/Guadalcanal
    {   97, 7038,   57227,  3, }, // Pacific/Kosrae
    {   97, 2844,   57230,  5, }, // Pacific/Kwajalein
    {   97, 4896,   57235,  3, }, // Pacific/Majuro
    {   97, 4070,   57238,  6, }, // Pacific/Marquesas
    {   97, 7103,   57244,  2, }, // Pacific/Nauru
    {   97, 7194,   57246,  5, }, // Pacific/Pitcairn
    {   97, 4602,   57251,  5, }, // Pacific/Tongatapu
    {   97, 7392,   57256,  3, }, // Pacific/Wake
    {   99, 6807,   43434,  3, }, // Africa/Abidjan Chinese/Traditional Han/Taiwan
    {   99, 5078,   43440,  6, }, // Africa/Addis_Ababa
    {   99, 7420,   43446,  4, }, // Africa/Algiers
    {   99,   14,   43450,  4, }, // Africa/Asmara
    {   99,   44,   43454,  3, }, // Africa/Bamako
    {   99, 6765,   43459,  2, }, // Africa/Banjul
    {   99, 7435,   43461,  2, }, // Africa/Bissau
    {   99, 4976,   43463,  4, }, // Africa/Blantyre
    {   99, 5306,   43467,  5, }, // Africa/Brazzaville
    {   99, 4941,   43472,  4, }, // Africa/Bujumbura
    {   99, 2322,   43476,  2, }, // Africa/Cairo
    {   99, 4136,   43478,  5, }, // Africa/Casablanca
    {   99, 7449,   43483,  2, }, // Africa/Ceuta
    {   99, 6792,   43485,  4, }, // Africa/Conakry
    {   99, 6859,   43489,  3, }, // Africa/Dakar
    {   99, 5149,   43492,  3, }, // Africa/Dar_es_Salaam
    {   99, 5062,   43495,  3, }, // Africa/Djibouti
    {   99, 6872,   43504,  3, }, // Africa/Freetown
    {   99, 4925,   43507,  4, }, // Africa/Gaborone
    {   99, 4498,   43514,  5, }, // Africa/Johannesburg
    {   99, 5325,   43530,  3, }, // Africa/Kinshasa
    {   99, 4763,   43533,  3, }, // Africa/Lagos
    {   99, 5355,   43536,  3, }, // Africa/Libreville
    {   99, 5230,   43541,  3, }, // Africa/Luanda
    {   99, 4958,   43544,  4, }, // Africa/Lubumbashi
    {   99, 5020,   43548,  3, }, // Africa/Lusaka
    {   99, 5341,   43551,  3, }, // Africa/Malabo
    {   99, 5006,   43554,  3, }, // Africa/Maputo
    {   99, 5216,   43557,  3, }, // Africa/Maseru
    {   99, 5201,   43560,  3, }, // Africa/Mbabane
    {   99, 5132,   43563,  4, }, // Africa/Mogadishu
    {   99, 7053,   43567,  4, }, // Africa/Monrovia
    {   99, 3872,   43571,  3, }, // Africa/Nairobi
    {   99, 5290,   43574,  4, }, // Africa/Ndjamena
    {   99, 5373,   43578,  3, }, // Africa/Niamey
    {   99, 6822,   43581,  3, }, // Africa/Nouakchott
    {   99, 5244,   43588,  4, }, // Africa/Porto-Novo
    {   99, 4454,   43592,  3, }, // Africa/Sao_Tome
    {   99, 4171,   43602,  4, }, // Africa/Windhoek
    {   99,  132,   43606,  3, }, // America/Adak
    {   99, 3365,   43609,  4, }, // America/Anchorage
    {   99, 5626,   57259,  3, }, // America/Anguilla
    {   99, 5643,   43616,  3, }, // America/Antigua
    {   99, 4573,   43619,  4, }, // America/Araguaina
    {   99,  166,   43623,  7, }, // America/Argentina/Buenos_Aires
    {   99,   91,   43630,  4, }, // America/Argentina/Catamarca
    {   99,  270,   43634,  3, }, // America/Argentina/Cordoba
    {   99, 7462,   43640,  3, }, // America/Argentina/La_Rioja
    {   99,  565,   43643,  3, }, // America/Argentina/Mendoza
    {   99, 7489,   43646,  6, }, // America/Argentina/Rio_Gallegos
    {   99, 7520,   43652,  3, }, // America/Argentina/Salta
    {   99, 7544,   43655,  3, }, // America/Argentina/San_Juan
    {   99, 5599,   43658,  3, }, // America/Argentina/San_Luis
    {   99, 7571,   43661,  3, }, // America/Argentina/Tucuman
    {   99, 7597,   43664,  4, }, // America/Argentina/Ushuaia
    {   99, 5659,   57262,  5, }, // America/Aruba
    {   99, 4271,   43671,  3, }, // America/Asuncion
    {   99, 3698,   43678,  3, }, // America/Bahia
    {   99, 7623,   43681,  7, }, // America/Bahia_Banderas
    {   99, 5673,   43688,  3, }, // America/Barbados
    {   99, 7646,   43691,  2, }, // America/Belem
    {   99, 5426,   43693,  3, }, // America/Belize
    {   99, 7660,   43696,  5, }, // America/Blanc-Sablon
    {   99, 7681,   43701,  4, }, // America/Boa_Vista
    {   99, 7699,   43708,  2, }, // America/Boise
    {   99, 7713,   43710,  3, }, // America/Cambridge_Bay
    {   99, 7735,   43713,  3, }, // America/Campo_Grande
    {   99, 4713,   43718,  4, }, // America/Caracas
    {   99, 4364,   43722,  2, }, // America/Cayenne
    {   99, 5515,   43724,  4, }, // America/Cayman
    {   99, 7756,   43731,  3, }, // America/Chihuahua
    {   99, 7774,   43734,  3, }, // America/Ciudad_Juarez
    {   99, 5441,   43738,  5, }, // America/Costa_Rica
    {   99, 7814,   43747,  4, }, // America/Creston
    {   99, 3810,   43751,  3, }, // America/Cuiaba
    {   99, 5742,   43754,  3, }, // America/Curacao
    {   99, 7830,   43757,  4, }, // America/Danmarkshavn
    {   99, 5758,   57267,  4, }, // America/Dominica
    {   99,  893,   43777,  4, }, // America/Edmonton
    {   99, 7887,   43781,  4, }, // America/Eirunepe
    {   99, 5460,   43785,  4, }, // America/El_Salvador
    {   99, 7904,   43789,  4, }, // America/Fort_Nelson
    {   99, 7924,   43793,  4, }, // America/Fortaleza
    {   99, 7942,   43797,  4, }, // America/Glace_Bay
    {   99, 6900,   43801,  2, }, // America/Goose_Bay
    {   99, 4631,   43803,  4, }, // America/Grand_Turk
    {   99, 5789,   43807,  4, }, // America/Grenada
    {   99, 5805,   43811,  4, }, // America/Guadeloupe
    {   99, 3779,   43815,  4, }, // America/Guatemala
    {   99, 4860,   43819,  4, }, // America/Guayaquil
    {   99, 6951,   43823,  3, }, // America/Guyana
    {   99, 1941,   43826,  5, }, // America/Halifax
    {   99, 7960,   43834,  4, }, // America/Hermosillo
    {   99,  348,   43838,  7, }, // America/Indiana/Indianapolis
    {   99,  481,   43845,  8, }, // America/Indiana/Knox
    {   99, 7979,   43853,  8, }, // America/Indiana/Marengo
    {   99, 8003,   43861,  8, }, // America/Indiana/Petersburg
    {   99, 8030,   43869,  8, }, // America/Indiana/Tell_City
    {   99, 8056,   43877,  7, }, // America/Indiana/Vevay
    {   99, 8078,   43884,  8, }, // America/Indiana/Vincennes
    {   99, 8104,   43892,  9, }, // America/Indiana/Winamac
    {   99, 8128,   43901,  4, }, // America/Inuvik
    {   99, 2801,   43908,  3, }, // America/Jamaica
    {   99, 5399,   43911,  2, }, // America/Juneau
    {   99,  521,   43913,  5, }, // America/Kentucky/Louisville
    {   99, 8143,   43918,  8, }, // America/Kentucky/Monticello
    {   99, 5723,   43926,  5, }, // America/Kralendijk
    {   99, 7169,   43934,  2, }, // America/Lima
    {   99, 3258,   43936,  3, }, // America/Los_Angeles
    {   99, 5951,   43939,  4, }, // America/Lower_Princes
    {   99, 8171,   43943,  3, }, // America/Maceio
    {   99, 8186,   43946,  3, }, // America/Managua
    {   99, 1910,   43949,  3, }, // America/Manaus
    {   99, 5916,   43952,  4, }, // America/Marigot
    {   99, 5824,   43956,  4, }, // America/Martinique
    {   99, 8202,   43960,  5, }, // America/Matamoros
    {   99, 2919,   43965,  4, }, // America/Mazatlan
    {   99, 8220,   43969,  4, }, // America/Menominee
    {   99, 8238,   43973,  3, }, // America/Merida
    {   99, 2951,   43982,  4, }, // America/Mexico_City
    {   99, 4410,   43986,  3, }, // America/Miquelon
    {   99, 8272,   43989,  3, }, // America/Moncton
    {   99, 8288,   43992,  3, }, // America/Monterrey
    {   99, 4117,   43995,  4, }, // America/Montevideo
    {   99, 5843,   43999,  3, }, // America/Montserrat
    {   99, 5500,   44002,  2, }, // America/Nassau
    {   99, 2381,   44004,  2, }, // America/New_York
    {   99, 8306,   44006,  2, }, // America/Nome
    {   99, 1852,   44008,  3, }, // America/Noronha
    {   99, 8319,   44011,  8, }, // America/North_Dakota/Beulah
    {   99, 8347,   44019,  7, }, // America/North_Dakota/Center
    {   99, 8375,   44026,  8, }, // America/North_Dakota/New_Salem
    {   99, 8406,   44036,  4, }, // America/Ojinaga
    {   99, 2358,   44040,  3, }, // America/Panama
    {   99, 6192,   44043,  5, }, // America/Paramaribo
    {   99, 2975,   44048,  3, }, // America/Phoenix
    {   99, 8422,   44058,  3, }, // America/Porto_Velho
    {   99, 4049,   44065,  6, }, // America/Punta_Arenas
    {   99, 8442,   44071,  3, }, // America/Rankin_Inlet
    {   99, 8463,   44074,  3, }, // America/Recife
    {   99, 1997,   44077,  3, }, // America/Regina
    {   99, 8478,   44080,  4, }, // America/Resolute
    {   99,  695,   44084,  4, }, // America/Rio_Branco
    {   99, 8495,   44088,  3, }, // America/Santarem
    {   99, 2203,   44091,  4, }, // America/Santiago
    {   99, 6130,   44095,  4, }, // America/Santo_Domingo
    {   99, 1880,   44099,  3, }, // America/Sao_Paulo
    {   99, 6918,   44102,  7, }, // America/Scoresbysund
    {   99, 8512,   44109,  3, }, // America/Sitka
    {   99, 8526,   44112,  6, }, // America/St_Barthelemy
    {   99, 2063,   44118,  3, }, // America/St_Johns
    {   99, 5882,   44121,  3, }, // America/St_Kitts
    {   99, 5899,   44124,  4, }, // America/St_Lucia
    {   99,  855,   44128,  4, }, // America/St_Thomas
    {   99, 5932,   44132,  3, }, // America/St_Vincent
    {   99, 8548,   44135,  7, }, // America/Swift_Current
    {   99, 5480,   44142,  5, }, // America/Tegucigalpa
    {   99, 5775,   44147,  2, }, // America/Thule
    {   99,  313,   44149,  3, }, // America/Tijuana
    {   99,  608,   44152,  3, }, // America/Toronto
    {   99, 5707,   44155,  4, }, // America/Tortola
    {   99, 2095,   44159,  3, }, // America/Vancouver
    {   99, 2146,   44162,  4, }, // America/Whitehorse
    {   99,  734,   44166,  3, }, // America/Winnipeg
    {   99, 8570,   44169,  3, }, // America/Yakutat
    {   99, 6020,   44172,  2, }, // Antarctica/Casey
    {   99, 6113,   44174,  3, }, // Antarctica/Davis
    {   99, 6152,   44177,  5, }, // Antarctica/DumontDUrville
    {   99, 8586,   44182,  3, }, // Antarctica/Macquarie
    {   99,  932,   44187,  4, }, // Antarctica/McMurdo
    {   99, 8607,   44191,  2, }, // Antarctica/Palmer
    {   99, 7226,   44193,  3, }, // Antarctica/Rothera
    {   99, 7295,   44196,  4, }, // Antarctica/Syowa
    {   99, 8625,   44200,  2, }, // Antarctica/Troll
    {   99, 1431,   44206,  5, }, // Arctic/Longyearbyen
    {   99, 5589,   44211,  2, }, // Asia/Aden
    {   99, 5414,   44213,  4, }, // Asia/Almaty
    {   99, 5530,   44219,  3, }, // Asia/Anadyr
    {   99, 5387,   44225,  4, }, // Asia/Aqtobe
    {   99,  966,   44229,  5, }, // Asia/Ashgabat
    {   99, 8642,   44234,  3, }, // Asia/Atyrau
    {   99, 3626,   44237,  3, }, // Asia/Baghdad
    {   99, 3672,   43753,  2, }, // Asia/Baku
    {   99, 3590,   44244,  4, }, // Asia/Barnaul
    {   99, 4105,   44248,  3, }, // Asia/Beirut
    {   99, 3797,   44251,  4, }, // Asia/Bishkek
    {   99, 6008,   44255,  2, }, // Asia/Brunei
    {   99, 4530,   44259,  3, }, // Asia/Colombo
    {   99, 4559,   44262,  4, }, // Asia/Damascus
    {   99, 1095,   44266,  2, }, // Asia/Dhaka
    {   99, 3615,   44270,  2, }, // Asia/Dubai
    {   99, 6178,   44272,  3, }, // Asia/Dushanbe
    {   99, 8654,   44275,  5, }, // Asia/Famagusta
    {   99, 8669,   44280,  2, }, // Asia/Gaza
    {   99, 4814,   44282,  3, }, // Asia/Hebron
    {   99, 4203,   44306,  5, }, // Asia/Irkutsk
    {   99, 7025,   44311,  3, }, // Asia/Jakarta
    {   99, 7011,   44314,  4, }, // Asia/Jayapura
    {   99, 3579,   44322,  3, }, // Asia/Kabul
    {   99, 4258,   44328,  3, }, // Asia/Karachi
    {   99, 1187,   44331,  4, }, // Asia/Kathmandu
    {   99, 8679,   44335,  3, }, // Asia/Khandyga
    {   99,  994,   44338,  4, }, // Asia/Kolkata
    {   99, 4216,   44342,  8, }, // Asia/Krasnoyarsk
    {   99, 5995,   44353,  2, }, // Asia/Kuching
    {   99, 1213,   44365,  2, }, // Asia/Macau
    {   99, 4036,   44372,  3, }, // Asia/Magadan
    {   99, 1351,   44375,  4, }, // Asia/Makassar
    {   99, 7182,   44379,  3, }, // Asia/Manila
    {   99, 6939,   44382,  4, }, // Asia/Muscat
    {   99, 2556,   44386,  4, }, // Asia/Nicosia
    {   99, 8693,   44390,  6, }, // Asia/Novokuznetsk
    {   99, 4154,   44396,  5, }, // Asia/Novosibirsk
    {   99, 7145,   44405,  3, }, // Asia/Oral
    {   99, 6980,   44408,  2, }, // Asia/Phnom_Penh
    {   99, 5578,   44414,  2, }, // Asia/Qatar
    {   99, 8726,   57271,  4, }, // Asia/Qostanay
    {   99, 4288,   44420,  6, }, // Asia/Qyzylorda
    {   99, 3603,   44426,  3, }, // Asia/Riyadh
    {   99, 4427,   44429,  3, }, // Asia/Sakhalin
    {   99, 7245,   44432,  4, }, // Asia/Samarkand
    {   99, 3298,   44436,  2, }, // Asia/Seoul
    {   99, 2774,   44458,  3, }, // Asia/Tehran
    {   99, 2823,   44463,  2, }, // Asia/Tokyo
    {   99, 1023,   44469,  4, }, // Asia/Ulaanbaatar
    {   99, 1161,   44473,  4, }, // Asia/Urumqi
    {   99, 8740,   44477,  4, }, // Asia/Ust-Nera
    {   99, 6996,   44481,  2, }, // Asia/Vientiane
    {   99, 4729,   44483,  3, }, // Asia/Vladivostok
    {   99, 4847,   44486,  4, }, // Asia/Yakutsk
    {   99, 3902,   44492,  5, }, // Asia/Yekaterinburg
    {   99, 3766,   44497,  3, }, // Asia/Yerevan
    {   99, 3682,   44500,  5, }, // Atlantic/Azores
    {   99, 5690,   44505,  3, }, // Atlantic/Bermuda
    {   99, 6647,   44508,  3, }, // Atlantic/Canary
    {   99, 3746,   44511,  3, }, // Atlantic/Cape_Verde
    {   99, 1397,   44514,  4, }, // Atlantic/Faroe
    {   99, 8754,   44518,  5, }, // Atlantic/Madeira
    {   99, 2750,   44523,  5, }, // Atlantic/Reykjavik
    {   99, 7272,   44528,  4, }, // Atlantic/South_Georgia
    {   99, 6840,   44532,  5, }, // Atlantic/St_Helena
    {   99, 6663,   44537,  3, }, // Atlantic/Stanley
    {   99, 1672,   44540,  4, }, // Australia/Adelaide
    {   99, 1637,   44544,  4, }, // Australia/Brisbane
    {   99, 1801,   44548,  5, }, // Australia/Broken_Hill
    {   99, 1585,   44553,  3, }, // Australia/Darwin
    {   99, 1518,   44559,  3, }, // Australia/Hobart
    {   99, 1549,   44565,  4, }, // Australia/Lord_Howe
    {   99, 1729,   44569,  3, }, // Australia/Melbourne
    {   99, 1764,   44572,  2, }, // Australia/Perth
    {   99, 1465,   44574,  2, }, // Australia/Sydney
    {   99, 6235,   44581,  3, }, // Europe/Andorra
    {   99, 6355,   44591,  4, }, // Europe/Belgrade
    {   99, 6507,   44597,  6, }, // Europe/Bratislava
    {   99, 2169,   44603,  4, }, // Europe/Brussels
    {   99, 3825,   44612,  4, }, // Europe/Budapest
    {   99, 2585,   57275,  3, }, // Europe/Chisinau
    {   99, 2340,   44626,  3, }, // Europe/Dublin
    {   99, 6326,   44629,  4, }, // Europe/Gibraltar
    {   99, 8806,   44633,  3, }, // Europe/Guernsey
    {   99, 6631,   44636,  4, }, // Europe/Helsinki
    {   99, 8822,   44640,  2, }, // Europe/Isle_of_Man
    {   99, 1132,   44642,  4, }, // Europe/Istanbul
    {   99, 8841,   44646,  3, }, // Europe/Jersey
    {   99, 3998,   44649,  5, }, // Europe/Kaliningrad
    {   99, 2529,   44657,  2, }, // Europe/Kyiv
    {   99, 6525,   44662,  4, }, // Europe/Ljubljana
    {   99, 2503,   44666,  2, }, // Europe/London
    {   99, 6384,   44668,  3, }, // Europe/Luxembourg
    {   99, 4911,   44671,  3, }, // Europe/Madrid
    {   99, 6416,   44674,  3, }, // Europe/Malta
    {   99, 6601,   44677,  3, }, // Europe/Mariehamn
    {   99, 6429,   44683,  3, }, // Europe/Monaco
    {   99, 6477,   44689,  3, }, // Europe/Oslo
    {   99, 6443,   44694,  4, }, // Europe/Podgorica
    {   99, 6343,   44703,  2, }, // Europe/Rome
    {   99, 4350,   44705,  3, }, // Europe/Samara
    {   99, 6489,   44708,  4, }, // Europe/San_Marino
    {   99, 6264,   44712,  4, }, // Europe/Sarajevo
    {   99, 4470,   44716,  4, }, // Europe/Saratov
    {   99, 8880,   44720,  4, }, // Europe/Simferopol
    {   99, 6402,   44724,  4, }, // Europe/Skopje
    {   99, 6618,   44728,  3, }, // Europe/Sofia
    {   99, 6542,   44731,  5, }, // Europe/Stockholm
    {   99, 8913,   44741,  7, }, // Europe/Ulyanovsk
    {   99, 6371,   44748,  3, }, // Europe/Vaduz
    {   99, 6586,   44751,  3, }, // Europe/Vatican
    {   99, 6250,   44754,  3, }, // Europe/Vienna
    {   99, 8930,   44757,  4, }, // Europe/Vilnius
    {   99, 4746,   44761,  5, }, // Europe/Volgograd
    {   99, 3209,   44766,  2, }, // Europe/Warsaw
    {   99, 6280,   44768,  4, }, // Europe/Zagreb
    {   99, 6559,   44772,  3, }, // Europe/Zurich
    {   99, 5097,   57278,  6, }, // Indian/Antananarivo
    {   99, 6065,   44784,  3, }, // Indian/Christmas
    {   99, 6082,   44787,  5, }, // Indian/Cocos
    {   99, 5048,   44792,  5, }, // Indian/Comoro
    {   99, 6680,   44797,  5, }, // Indian/Kerguelen
    {   99, 7260,   44802,  3, }, // Indian/Mahe
    {   99, 7069,   44805,  4, }, // Indian/Maldives
    {   99, 4088,   44809,  4, }, // Indian/Mauritius
    {   99, 5117,   44813,  4, }, // Indian/Mayotte
    {   99, 7211,   44817,  4, }, // Indian/Reunion
    {   99, 4441,   44821,  3, }, // Pacific/Apia
    {   99, 3009,   44824,  3, }, // Pacific/Auckland
    {   99, 3725,   44827,  4, }, // Pacific/Bougainville
    {   99, 3034,   44831,  2, }, // Pacific/Chatham
    {   99, 3176,   44833,  2, }, // Pacific/Chuuk
    {   99, 2239,   44835,  3, }, // Pacific/Easter
    {   99, 3921,   44844,  2, }, // Pacific/Fiji
    {   99, 7343,   44846,  4, }, // Pacific/Funafuti
    {   99, 6697,   44850,  6, }, // Pacific/Galapagos
    {   99, 6715,   44856,  5, }, // Pacific/Gambier
    {   99, 3841,   44861,  6, }, // Pacific/Guadalcanal
    {   99, 6037,   44867,  2, }, // Pacific/Guam
    {   99, 3068,   57284,  3, }, // Pacific/Kanton
    {   99, 4017,   44874,  6, }, // Pacific/Kiritimati
    {   99, 7038,   44880,  3, }, // Pacific/Kosrae
    {   99, 2844,   44883,  4, }, // Pacific/Kwajalein
    {   99, 4896,   44887,  3, }, // Pacific/Majuro
    {   99, 4070,   44890,  5, }, // Pacific/Marquesas
    {   99, 8945,   44895,  3, }, // Pacific/Midway
    {   99, 7103,   44898,  2, }, // Pacific/Nauru
    {   99, 7132,   44900,  3, }, // Pacific/Niue
    {   99, 4187,   44903,  3, }, // Pacific/Norfolk
    {   99, 7117,   44906,  3, }, // Pacific/Noumea
    {   99, 3145,   44909,  4, }, // Pacific/Pago_Pago
    {   99, 7155,   44913,  2, }, // Pacific/Palau
    {   99, 7194,   44915,  5, }, // Pacific/Pitcairn
    {   99, 3115,   44920,  3, }, // Pacific/Pohnpei
    {   99, 4826,   44923,  4, }, // Pacific/Port_Moresby
    {   99, 6095,   44927,  4, }, // Pacific/Rarotonga
    {   99, 7312,   44933,  3, }, // Pacific/Tahiti
    {   99, 4602,   44939,  5, }, // Pacific/Tongatapu
    {  100,   14,       0,  6, }, // Africa/Asmara Church/Cyrillic/Russia
    {  100, 5185,       6,  8, }, // Africa/El_Aaiun
    {  100, 6888,      14,  4, }, // Africa/Lome
    {  100, 5290,      18,  9, }, // Africa/Ndjamena
    {  100, 4454,      27,  8, }, // Africa/Sao_Tome
    {  100, 4573,      35,  9, }, // America/Araguaina
    {  100,  270,      44,  7, }, // America/Argentina/Cordoba
    {  100, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  100, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  100, 4271,      70,  8, }, // America/Asuncion
    {  100,  237,      78,  8, }, // America/Atikokan
    {  100, 7623,      86, 17, }, // America/Bahia_Banderas
    {  100, 7646,     103,  5, }, // America/Belem
    {  100, 4380,     108,  6, }, // America/Bogota
    {  100, 3887,     114,  6, }, // America/Cancun
    {  100, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  100, 3810,     133,  6, }, // America/Cuiaba
    {  100, 5742,     139,  7, }, // America/Curacao
    {  100, 7887,     146,  8, }, // America/Eirunepe
    {  100,  481,     154, 13, }, // America/Indiana/Knox
    {  100, 7979,     167, 16, }, // America/Indiana/Marengo
    {  100, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  100, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  100, 8056,     220, 14, }, // America/Indiana/Vevay
    {  100, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  100, 8104,     252, 16, }, // America/Indiana/Winamac
    {  100, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  100, 5951,     288, 22, }, // America/Lower_Princes
    {  100, 8171,     310,  6, }, // America/Maceio
    {  100, 2919,     316,  8, }, // America/Mazatlan
    {  100, 8238,     324,  6, }, // America/Merida
    {  100, 2951,    4381, 16, }, // America/Mexico_City
    {  100, 4410,     341, 12, }, // America/Miquelon
    {  100, 1852,     353, 19, }, // America/Noronha
    {  100, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  100, 8347,     392, 20, }, // America/North_Dakota/Center
    {  100, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  100,  393,     435,  4, }, // America/Nuuk
    {  100, 8495,     439,  8, }, // America/Santarem
    {  100, 1880,     447,  9, }, // America/Sao_Paulo
    {  100, 6918,     456, 16, }, // America/Scoresbysund
    {  100, 8526,     472, 14, }, // America/St_Barthelemy
    {  100, 2063,     486, 10, }, // America/St_Johns
    {  100, 5882,     496,  9, }, // America/St_Kitts
    {  100, 5899,     505,  9, }, // America/St_Lucia
    {  100,  855,     514, 10, }, // America/St_Thomas
    {  100, 5932,     524, 11, }, // America/St_Vincent
    {  100, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  100, 7295,     643,  5, }, // Antarctica/Syowa
    {  100, 5414,   57287,  8, }, // Asia/Almaty
    {  100, 5530,   57295,  9, }, // Asia/Anadyr
    {  100, 5542,   57304,  7, }, // Asia/Aqtau
    {  100, 5387,   57311, 12, }, // Asia/Aqtobe
    {  100, 3797,   57323,  8, }, // Asia/Bishkek
    {  100, 4620,   57331,  5, }, // Asia/Chita
    {  100, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  100, 4790,     704,  5, }, // Asia/Hovd
    {  100, 4203,   57336, 10, }, // Asia/Irkutsk
    {  100, 4335,   57346, 27, }, // Asia/Kamchatka
    {  100, 1187,     709,  9, }, // Asia/Kathmandu
    {  100, 8679,   57373,  8, }, // Asia/Khandyga
    {  100,  994,     718,  7, }, // Asia/Kolkata
    {  100, 4216,   57381, 12, }, // Asia/Krasnoyarsk
    {  100, 1213,     725,  5, }, // Asia/Macau
    {  100, 4036,   57393,  9, }, // Asia/Magadan
    {  100, 8693,   57402, 13, }, // Asia/Novokuznetsk
    {  100, 4154,   57415, 13, }, // Asia/Novosibirsk
    {  100, 4248,   57428,  7, }, // Asia/Omsk
    {  100, 7145,   57435, 11, }, // Asia/Oral
    {  100, 4288,   57446, 10, }, // Asia/Qyzylorda
    {  100, 4427,   57456,  9, }, // Asia/Sakhalin
    {  100, 4316,   57465, 15, }, // Asia/Srednekolymsk
    {  100, 1161,     747,  6, }, // Asia/Urumqi
    {  100, 8740,   57480, 13, }, // Asia/Ust-Nera
    {  100, 4729,   57493, 13, }, // Asia/Vladivostok
    {  100, 4847,   57506,  9, }, // Asia/Yakutsk
    {  100, 1237,     753,  6, }, // Asia/Yangon
    {  100, 3902,   57515, 15, }, // Asia/Yekaterinburg
    {  100, 6647,    4413,  8, }, // Atlantic/Canary
    {  100, 1397,     767,  5, }, // Atlantic/Faroe
    {  100, 6840,     773, 10, }, // Atlantic/St_Helena
    {  100, 8790,     799,  8, }, // Europe/Busingen
    {  100, 2585,     807,  8, }, // Europe/Chisinau
    {  100, 3998,   57530, 13, }, // Europe/Kaliningrad
    {  100, 2529,   57543,  6, }, // Europe/Kyiv
    {  100, 3712,   57549,  7, }, // Europe/Minsk
    {  100, 3556,   57556,  7, }, // Europe/Moscow
    {  100, 4350,   57563,  7, }, // Europe/Samara
    {  100, 8880,   57570, 12, }, // Europe/Simferopol
    {  100, 6221,     819,  6, }, // Europe/Tirane
    {  100, 4746,   57582, 11, }, // Europe/Volgograd
    {  100, 5048,    4421,  7, }, // Indian/Comoro
    {  100, 7260,     896,  4, }, // Indian/Mahe
    {  100, 7211,     900,  7, }, // Indian/Reunion
    {  100, 3176,     922,  5, }, // Pacific/Chuuk
    {  100, 6697,     940,  9, }, // Pacific/Galapagos
    {  100, 3068,     957,  6, }, // Pacific/Kanton
    {  100, 7117,    1028,  6, }, // Pacific/Noumea
    {  100, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  100, 7405,    1068, 15, }, // Pacific/Wallis
    {  101, 6807,   27131,  7, }, // Africa/Abidjan Chuvash/Cyrillic/Russia
    {  101, 6779,    1089,  5, }, // Africa/Accra
    {  101, 5078,    1094, 11, }, // Africa/Addis_Ababa
    {  101, 7420,    1105,  5, }, // Africa/Algiers
    {  101,   14,   27138,  6, }, // Africa/Asmara
    {  101,   44,    1116,  6, }, // Africa/Bamako
    {  101, 5276,    1122,  5, }, // Africa/Bangui
    {  101, 6765,    1127,  6, }, // Africa/Banjul
    {  101, 7435,    1133,  5, }, // Africa/Bissau
    {  101, 4976,   27144,  8, }, // Africa/Blantyre
    {  101, 5306,   27152, 10, }, // Africa/Brazzaville
    {  101, 4941,    1155,  9, }, // Africa/Bujumbura
    {  101, 2322,    1164,  4, }, // Africa/Cairo
    {  101, 4136,    1168, 10, }, // Africa/Casablanca
    {  101, 7449,    1178,  5, }, // Africa/Ceuta
    {  101, 6792,    1183,  7, }, // Africa/Conakry
    {  101, 6859,    1190,  5, }, // Africa/Dakar
    {  101, 5149,   27168, 12, }, // Africa/Dar_es_Salaam
    {  101, 5062,   27180,  7, }, // Africa/Djibouti
    {  101, 5262,    1213,  5, }, // Africa/Douala
    {  101, 5185,   27187,  7, }, // Africa/El_Aaiun
    {  101, 6872,    1225,  7, }, // Africa/Freetown
    {  101, 4925,    1232,  8, }, // Africa/Gaborone
    {  101, 5034,   27194,  6, }, // Africa/Harare
    {  101, 4498,   27200, 12, }, // Africa/Johannesburg
    {  101, 4518,   27212,  5, }, // Africa/Juba
    {  101, 5170,    1262,  7, }, // Africa/Kampala
    {  101, 4543,    1269,  6, }, // Africa/Khartoum
    {  101, 4992,    1275,  6, }, // Africa/Kigali
    {  101, 5325,    1281,  7, }, // Africa/Kinshasa
    {  101, 4763,    1288,  5, }, // Africa/Lagos
    {  101, 5355,   27217,  9, }, // Africa/Libreville
    {  101, 6888,    1301,  4, }, // Africa/Lome
    {  101, 5230,    1305,  6, }, // Africa/Luanda
    {  101, 4958,    1311,  9, }, // Africa/Lubumbashi
    {  101, 5020,    1320,  6, }, // Africa/Lusaka
    {  101, 5341,    1326,  6, }, // Africa/Malabo
    {  101, 5006,    1332,  6, }, // Africa/Maputo
    {  101, 5216,    1338,  6, }, // Africa/Maseru
    {  101, 5201,    1344,  7, }, // Africa/Mbabane
    {  101, 5132,    1351,  8, }, // Africa/Mogadishu
    {  101, 7053,    1359,  7, }, // Africa/Monrovia
    {  101, 3872,   27234,  7, }, // Africa/Nairobi
    {  101, 5290,   27241,  8, }, // Africa/Ndjamena
    {  101, 5373,   27249,  6, }, // Africa/Niamey
    {  101, 6822,    1387,  7, }, // Africa/Nouakchott
    {  101, 6746,    1394,  8, }, // Africa/Ouagadougou
    {  101, 5244,    1402, 10, }, // Africa/Porto-Novo
    {  101, 4454,    1412,  8, }, // Africa/Sao_Tome
    {  101, 2868,    1420,  7, }, // Africa/Tripoli
    {  101, 6573,    1427,  5, }, // Africa/Tunis
    {  101, 4171,    1432,  7, }, // Africa/Windhoek
    {  101,  132,    1439,  4, }, // America/Adak
    {  101, 3365,   27255,  8, }, // America/Anchorage
    {  101, 5626,   27263,  7, }, // America/Anguilla
    {  101, 5643,    1457,  7, }, // America/Antigua
    {  101, 4573,    1464,  9, }, // America/Araguaina
    {  101,  166,   27270, 12, }, // America/Argentina/Buenos_Aires
    {  101,   91,    1485,  9, }, // America/Argentina/Catamarca
    {  101,  270,    1494,  7, }, // America/Argentina/Cordoba
    {  101,  441,   27282,  5, }, // America/Argentina/Jujuy
    {  101, 7462,    1506,  8, }, // America/Argentina/La_Rioja
    {  101,  565,    1514,  7, }, // America/Argentina/Mendoza
    {  101, 7489,   27287, 12, }, // America/Argentina/Rio_Gallegos
    {  101, 7520,   27299,  6, }, // America/Argentina/Salta
    {  101, 7544,    1537,  8, }, // America/Argentina/San_Juan
    {  101, 5599,    1545,  8, }, // America/Argentina/San_Luis
    {  101, 7571,    1553,  7, }, // America/Argentina/Tucuman
    {  101, 7597,   27305,  5, }, // America/Argentina/Ushuaia
    {  101, 5659,    1566,  5, }, // America/Aruba
    {  101, 4271,   27310,  8, }, // America/Asuncion
    {  101,  237,    1578, 12, }, // America/Atikokan
    {  101, 3698,   27326,  4, }, // America/Bahia
    {  101, 7623,   27330, 16, }, // America/Bahia_Banderas
    {  101, 5673,    1610,  8, }, // America/Barbados
    {  101, 7646,    1618,  5, }, // America/Belem
    {  101, 5426,    1623,  5, }, // America/Belize
    {  101, 7660,    1628, 12, }, // America/Blanc-Sablon
    {  101, 7681,    1640,  9, }, // America/Boa_Vista
    {  101, 4380,    1649,  6, }, // America/Bogota
    {  101, 7699,   27357,  5, }, // America/Boise
    {  101, 7713,   27362, 13, }, // America/Cambridge_Bay
    {  101, 7735,    1672, 12, }, // America/Campo_Grande
    {  101, 3887,    1684,  6, }, // America/Cancun
    {  101, 4713,    1690,  7, }, // America/Caracas
    {  101, 4364,   27375,  7, }, // America/Cayenne
    {  101, 5515,   57593, 16, }, // America/Cayman
    {  101, 2262,    1726,  6, }, // America/Chicago
    {  101, 7756,    1732,  6, }, // America/Chihuahua
    {  101, 7774,   27398, 13, }, // America/Ciudad_Juarez
    {  101, 5441,    1738, 10, }, // America/Costa_Rica
    {  101, 7796,   57609,  6, }, // America/Coyhaique
    {  101, 7814,    1748,  7, }, // America/Creston
    {  101, 3810,   27419,  5, }, // America/Cuiaba
    {  101, 5742,   27424,  7, }, // America/Curacao
    {  101, 7830,    1769, 12, }, // America/Danmarkshavn
    {  101, 7851,    1781,  6, }, // America/Dawson
    {  101, 7866,    1787, 11, }, // America/Dawson_Creek
    {  101,  805,    1798,  6, }, // America/Denver
    {  101, 3484,   27431,  7, }, // America/Detroit
    {  101, 5758,    1811,  8, }, // America/Dominica
    {  101,  893,   27438,  8, }, // America/Edmonton
    {  101, 7887,   27446,  8, }, // America/Eirunepe
    {  101, 5460,   27454,  9, }, // America/El_Salvador
    {  101, 7904,   57615, 12, }, // America/Fort_Nelson
    {  101, 7924,    1854,  9, }, // America/Fortaleza
    {  101, 7942,   27475,  9, }, // America/Glace_Bay
    {  101, 6900,   27484,  7, }, // America/Goose_Bay
    {  101, 4631,    1879, 10, }, // America/Grand_Turk
    {  101, 5789,    1889,  7, }, // America/Grenada
    {  101, 5805,    1896,  9, }, // America/Guadeloupe
    {  101, 3779,    1905,  9, }, // America/Guatemala
    {  101, 4860,   27491,  8, }, // America/Guayaquil
    {  101, 6951,   27499,  6, }, // America/Guyana
    {  101, 1941,   27505,  8, }, // America/Halifax
    {  101, 2283,    1936,  6, }, // America/Havana
    {  101, 7960,   27513,  9, }, // America/Hermosillo
    {  101,  348,    1950, 12, }, // America/Indiana/Indianapolis
    {  101,  481,    1962, 13, }, // America/Indiana/Knox
    {  101, 7979,    1975, 16, }, // America/Indiana/Marengo
    {  101, 8003,    1991, 19, }, // America/Indiana/Petersburg
    {  101, 8030,   57627, 18, }, // America/Indiana/Tell_City
    {  101, 8056,   27522, 14, }, // America/Indiana/Vevay
    {  101, 8078,   27536, 18, }, // America/Indiana/Vincennes
    {  101, 8104,   27554, 16, }, // America/Indiana/Winamac
    {  101, 8128,    2049,  6, }, // America/Inuvik
    {  101,  660,    2055,  7, }, // America/Iqaluit
    {  101, 2801,   27570,  6, }, // America/Jamaica
    {  101, 5399,   27576,  5, }, // America/Juneau
    {  101,  521,    2073,  8, }, // America/Kentucky/Louisville
    {  101, 8143,    2081, 20, }, // America/Kentucky/Monticello
    {  101, 5723,   27581, 10, }, // America/Kralendijk
    {  101, 4395,    2111,  6, }, // America/La_Paz
    {  101, 7169,    2117,  4, }, // America/Lima
    {  101, 3258,   27591, 12, }, // America/Los_Angeles
    {  101, 5951,   27603, 18, }, // America/Lower_Princes
    {  101, 8171,   27621,  6, }, // America/Maceio
    {  101, 8186,    2156,  7, }, // America/Managua
    {  101, 1910,    2163,  6, }, // America/Manaus
    {  101, 5916,    2169,  6, }, // America/Marigot
    {  101, 5824,    2175,  9, }, // America/Martinique
    {  101, 8202,    2184,  9, }, // America/Matamoros
    {  101, 2919,    2193,  8, }, // America/Mazatlan
    {  101, 8220,    2201,  8, }, // America/Menominee
    {  101, 8238,    2209,  6, }, // America/Merida
    {  101, 8253,    2215, 10, }, // America/Metlakatla
    {  101, 2951,    2225,  6, }, // America/Mexico_City
    {  101, 4410,    2231,  7, }, // America/Miquelon
    {  101, 8272,    2238,  7, }, // America/Moncton
    {  101, 8288,   27635,  9, }, // America/Monterrey
    {  101, 4117,    2254, 10, }, // America/Montevideo
    {  101, 5843,    2264, 10, }, // America/Montserrat
    {  101, 5500,    2274,  6, }, // America/Nassau
    {  101, 2381,   27644,  8, }, // America/New_York
    {  101, 8306,    2288,  3, }, // America/Nome
    {  101, 1852,   27664,  7, }, // America/Noronha
    {  101, 8319,   57645, 21, }, // America/North_Dakota/Beulah
    {  101, 8347,   57666, 21, }, // America/North_Dakota/Center
    {  101, 8375,   57687, 26, }, // America/North_Dakota/New_Salem
    {  101,  393,    2369,  4, }, // America/Nuuk
    {  101, 8406,    2373,  7, }, // America/Ojinaga
    {  101, 2358,    2380,  6, }, // America/Panama
    {  101, 6192,    2386, 10, }, // America/Paramaribo
    {  101, 2975,    2396,  6, }, // America/Phoenix
    {  101, 3964,    2402, 12, }, // America/Port-au-Prince
    {  101, 5973,   27734, 13, }, // America/Port_of_Spain
    {  101, 8422,   27747, 11, }, // America/Porto_Velho
    {  101, 5862,   27758, 11, }, // America/Puerto_Rico
    {  101, 4049,    2449, 12, }, // America/Punta_Arenas
    {  101, 8442,    2461, 12, }, // America/Rankin_Inlet
    {  101, 8463,    2473,  6, }, // America/Recife
    {  101, 1997,   53506,  8, }, // America/Regina
    {  101, 8478,   27775,  8, }, // America/Resolute
    {  101,  695,    2494, 10, }, // America/Rio_Branco
    {  101, 8495,    2504,  8, }, // America/Santarem
    {  101, 2203,   27783,  8, }, // America/Santiago
    {  101, 6130,    2520, 13, }, // America/Santo_Domingo
    {  101, 1880,    2533,  9, }, // America/Sao_Paulo
    {  101, 6918,    2542, 11, }, // America/Scoresbysund
    {  101, 8512,    2553,  5, }, // America/Sitka
    {  101, 8526,    2558, 13, }, // America/St_Barthelemy
    {  101, 2063,   27791, 10, }, // America/St_Johns
    {  101, 5882,    2580,  9, }, // America/St_Kitts
    {  101, 5899,   27801, 10, }, // America/St_Lucia
    {  101,  855,    2600, 10, }, // America/St_Thomas
    {  101, 5932,    2610, 12, }, // America/St_Vincent
    {  101, 8548,    2622, 13, }, // America/Swift_Current
    {  101, 5480,   27811, 12, }, // America/Tegucigalpa
    {  101, 5775,    2646,  4, }, // America/Thule
    {  101,  313,    2650,  7, }, // America/Tijuana
    {  101,  608,    2657,  7, }, // America/Toronto
    {  101, 5707,    2664,  7, }, // America/Tortola
    {  101, 2095,    2671,  8, }, // America/Vancouver
    {  101, 2146,   27823,  8, }, // America/Whitehorse
    {  101,  734,    2687,  8, }, // America/Winnipeg
    {  101, 8570,   27831,  6, }, // America/Yakutat
    {  101, 6020,   27837,  5, }, // Antarctica/Casey
    {  101, 6113,   27852,  6, }, // Antarctica/Davis
    {  101, 6152,   27858, 14, }, // Antarctica/DumontDUrville
    {  101, 8586,    2728,  8, }, // Antarctica/Macquarie
    {  101, 7085,    2736,  6, }, // Antarctica/Mawson
    {  101,  932,    2742,  9, }, // Antarctica/McMurdo
    {  101, 8607,    2751,  6, }, // Antarctica/Palmer
    {  101, 7226,    2757,  6, }, // Antarctica/Rothera
    {  101, 7295,   27948,  4, }, // Antarctica/Syowa
    {  101, 8625,   27962,  6, }, // Antarctica/Troll
    {  101, 7374,   27978,  6, }, // Antarctica/Vostok
    {  101, 1431,   27994,  7, }, // Arctic/Longyearbyen
    {  101, 5589,    2789,  4, }, // Asia/Aden
    {  101, 5414,    2793,  6, }, // Asia/Almaty
    {  101, 3987,    2799,  5, }, // Asia/Amman
    {  101, 5530,   28001,  7, }, // Asia/Anadyr
    {  101, 5542,    2810,  5, }, // Asia/Aqtau
    {  101, 5387,    2815,  6, }, // Asia/Aqtobe
    {  101,  966,    2821,  7, }, // Asia/Ashgabat
    {  101, 8642,    2828,  6, }, // Asia/Atyrau
    {  101, 3626,    2834,  6, }, // Asia/Baghdad
    {  101, 5553,   39003,  7, }, // Asia/Bahrain
    {  101, 3672,    2847,  4, }, // Asia/Baku
    {  101, 4485,    2851,  7, }, // Asia/Bangkok
    {  101, 3590,    2858,  7, }, // Asia/Barnaul
    {  101, 4105,   28036,  6, }, // Asia/Beirut
    {  101, 3797,    2871,  6, }, // Asia/Bishkek
    {  101, 6008,   28048,  6, }, // Asia/Brunei
    {  101, 4620,    2883,  4, }, // Asia/Chita
    {  101, 4530,    2887,  7, }, // Asia/Colombo
    {  101, 4559,    2894,  6, }, // Asia/Damascus
    {  101, 1095,    2900,  5, }, // Asia/Dhaka
    {  101, 6211,    2905,  4, }, // Asia/Dili
    {  101, 3615,   28060,  5, }, // Asia/Dubai
    {  101, 6178,    2914,  7, }, // Asia/Dushanbe
    {  101, 8654,    2921,  9, }, // Asia/Famagusta
    {  101, 8669,    2930,  4, }, // Asia/Gaza
    {  101, 4814,    2934,  6, }, // Asia/Hebron
    {  101, 1261,    2940,  7, }, // Asia/Ho_Chi_Minh
    {  101, 2706,   28072,  7, }, // Asia/Hong_Kong
    {  101, 4790,    2954,  4, }, // Asia/Hovd
    {  101, 4203,    2958,  7, }, // Asia/Irkutsk
    {  101, 7025,   28079,  8, }, // Asia/Jakarta
    {  101, 7011,   28087,  8, }, // Asia/Jayapura
    {  101, 1292,    2980,  9, }, // Asia/Jerusalem
    {  101, 3579,    2989,  5, }, // Asia/Kabul
    {  101, 4335,   57713, 24, }, // Asia/Kamchatka
    {  101, 4258,    3019,  6, }, // Asia/Karachi
    {  101, 1187,    3025,  8, }, // Asia/Kathmandu
    {  101, 8679,    3033,  7, }, // Asia/Khandyga
    {  101,  994,   28095,  9, }, // Asia/Kolkata
    {  101, 4216,   28104, 10, }, // Asia/Krasnoyarsk
    {  101, 4878,    3059, 12, }, // Asia/Kuala_Lumpur
    {  101, 5995,    3071,  6, }, // Asia/Kuching
    {  101, 5566,   28114,  6, }, // Asia/Kuwait
    {  101, 1213,    3083,  5, }, // Asia/Macau
    {  101, 4036,    3088,  7, }, // Asia/Magadan
    {  101, 1351,    3095,  7, }, // Asia/Makassar
    {  101, 7182,    3102,  6, }, // Asia/Manila
    {  101, 6939,    3108,  6, }, // Asia/Muscat
    {  101, 2556,    3114,  6, }, // Asia/Nicosia
    {  101, 8693,    3121, 11, }, // Asia/Novokuznetsk
    {  101, 4154,    3132, 11, }, // Asia/Novosibirsk
    {  101, 4248,    3143,  4, }, // Asia/Omsk
    {  101, 7145,   28127,  7, }, // Asia/Oral
    {  101, 6980,   28134,  8, }, // Asia/Phnom_Penh
    {  101, 8711,    3160,  9, }, // Asia/Pontianak
    {  101, 4233,   28142,  7, }, // Asia/Pyongyang
    {  101, 5578,    3176,  5, }, // Asia/Qatar
    {  101, 8726,   39050,  8, }, // Asia/Qostanay
    {  101, 4288,    3189,  9, }, // Asia/Qyzylorda
    {  101, 3603,   28166,  7, }, // Asia/Riyadh
    {  101, 4427,    3211,  7, }, // Asia/Sakhalin
    {  101, 7245,    3218,  9, }, // Asia/Samarkand
    {  101, 3298,    3227,  4, }, // Asia/Seoul
    {  101, 1055,   28182,  6, }, // Asia/Shanghai
    {  101, 3319,    3237,  8, }, // Asia/Singapore
    {  101, 4316,    3245, 13, }, // Asia/Srednekolymsk
    {  101, 3282,   31069,  6, }, // Asia/Taipei
    {  101, 4800,    3264,  7, }, // Asia/Tashkent
    {  101, 3934,   28194,  7, }, // Asia/Tbilisi
    {  101, 2774,    3275,  7, }, // Asia/Tehran
    {  101, 1319,    3282,  7, }, // Asia/Thimphu
    {  101, 2823,    3289,  5, }, // Asia/Tokyo
    {  101, 4591,    3294,  5, }, // Asia/Tomsk
    {  101, 1023,    3299, 10, }, // Asia/Ulaanbaatar
    {  101, 1161,    3309,  6, }, // Asia/Urumqi
    {  101, 8740,   28213,  9, }, // Asia/Ust-Nera
    {  101, 6996,   28222,  8, }, // Asia/Vientiane
    {  101, 4729,    3330, 11, }, // Asia/Vladivostok
    {  101, 4847,   28230,  6, }, // Asia/Yakutsk
    {  101, 1237,   28236,  5, }, // Asia/Yangon
    {  101, 3902,    3354, 12, }, // Asia/Yekaterinburg
    {  101, 3766,    3366,  6, }, // Asia/Yerevan
    {  101, 3682,   57737, 14, }, // Atlantic/Azores
    {  101, 5690,   37289,  7, }, // Atlantic/Bermuda
    {  101, 6647,   57751, 15, }, // Atlantic/Canary
    {  101, 3746,    3423, 10, }, // Atlantic/Cape_Verde
    {  101, 1397,   57766, 15, }, // Atlantic/Faroe
    {  101, 8754,   28285,  7, }, // Atlantic/Madeira
    {  101, 2750,   28292,  9, }, // Atlantic/Reykjavik
    {  101, 7272,   57781, 13, }, // Atlantic/South_Georgia
    {  101, 6840,   57794, 20, }, // Atlantic/St_Helena
    {  101, 6663,   28332,  6, }, // Atlantic/Stanley
    {  101, 1672,    3514,  8, }, // Australia/Adelaide
    {  101, 1637,    3522,  7, }, // Australia/Brisbane
    {  101, 1801,    3529, 11, }, // Australia/Broken_Hill
    {  101, 1585,    3540,  6, }, // Australia/Darwin
    {  101, 3656,   28338,  4, }, // Australia/Eucla
    {  101, 1518,    3551,  6, }, // Australia/Hobart
    {  101, 8771,    3557,  8, }, // Australia/Lindeman
    {  101, 1549,    3565,  8, }, // Australia/Lord_Howe
    {  101, 1729,   28357,  8, }, // Australia/Melbourne
    {  101, 1764,    3580,  4, }, // Australia/Perth
    {  101, 1465,   28365,  6, }, // Australia/Sydney
    {  101, 6460,    3590,  9, }, // Europe/Amsterdam
    {  101, 6235,    3599,  7, }, // Europe/Andorra
    {  101, 3639,   57814,  8, }, // Europe/Astrakhan
    {  101, 2302,   28379,  5, }, // Europe/Athens
    {  101, 6355,    3618,  7, }, // Europe/Belgrade
    {  101, 4776,    3625,  6, }, // Europe/Berlin
    {  101, 6507,    3631, 10, }, // Europe/Bratislava
    {  101, 2169,   28384,  8, }, // Europe/Brussels
    {  101, 3947,    3649,  8, }, // Europe/Bucharest
    {  101, 3825,    3657,  8, }, // Europe/Budapest
    {  101, 8790,   39259,  8, }, // Europe/Busingen
    {  101, 2585,   57822,  7, }, // Europe/Chisinau
    {  101, 6308,   28400, 10, }, // Europe/Copenhagen
    {  101, 2340,    3705,  6, }, // Europe/Dublin
    {  101, 6326,    3711,  9, }, // Europe/Gibraltar
    {  101, 8806,    3720,  6, }, // Europe/Guernsey
    {  101, 6631,   28410,  9, }, // Europe/Helsinki
    {  101, 8822,   57829, 10, }, // Europe/Isle_of_Man
    {  101, 1132,    3743,  7, }, // Europe/Istanbul
    {  101, 8841,   28437,  6, }, // Europe/Jersey
    {  101, 3998,    3755, 11, }, // Europe/Kaliningrad
    {  101, 8855,    3766,  5, }, // Europe/Kirov
    {  101, 2529,   57839,  4, }, // Europe/Kyiv
    {  101, 3232,    3775,  8, }, // Europe/Lisbon
    {  101, 6525,   28443,  7, }, // Europe/Ljubljana
    {  101, 2503,    3792,  6, }, // Europe/London
    {  101, 6384,   28450, 10, }, // Europe/Luxembourg
    {  101, 4911,    3809,  6, }, // Europe/Madrid
    {  101, 6416,   28460,  6, }, // Europe/Malta
    {  101, 6601,    3820,  9, }, // Europe/Mariehamn
    {  101, 3712,    3829,  5, }, // Europe/Minsk
    {  101, 6429,    3834,  6, }, // Europe/Monaco
    {  101, 3556,   57843,  6, }, // Europe/Moscow
    {  101, 6477,    3846,  4, }, // Europe/Oslo
    {  101, 4303,    3850,  5, }, // Europe/Paris
    {  101, 6443,    3855,  9, }, // Europe/Podgorica
    {  101, 6294,    3864,  5, }, // Europe/Prague
    {  101, 8868,    3869,  4, }, // Europe/Riga
    {  101, 6343,    3873,  3, }, // Europe/Rome
    {  101, 4350,    3218,  5, }, // Europe/Samara
    {  101, 6489,    3882, 10, }, // Europe/San_Marino
    {  101, 6264,    3892,  7, }, // Europe/Sarajevo
    {  101, 4470,   57849,  6, }, // Europe/Saratov
    {  101, 8880,   28484, 11, }, // Europe/Simferopol
    {  101, 6402,   28495,  6, }, // Europe/Skopje
    {  101, 6618,    3921,  4, }, // Europe/Sofia
    {  101, 6542,   28506,  9, }, // Europe/Stockholm
    {  101, 8898,    3934,  6, }, // Europe/Tallinn
    {  101, 6221,    3940,  6, }, // Europe/Tirane
    {  101, 8913,   57855,  6, }, // Europe/Ulyanovsk
    {  101, 6371,    3955,  5, }, // Europe/Vaduz
    {  101, 6586,    3960,  7, }, // Europe/Vatican
    {  101, 6250,    3967,  4, }, // Europe/Vienna
    {  101, 8930,   28524,  7, }, // Europe/Vilnius
    {  101, 4746,    3978,  9, }, // Europe/Volgograd
    {  101, 3209,    3987,  7, }, // Europe/Warsaw
    {  101, 6280,    3994,  6, }, // Europe/Zagreb
    {  101, 6559,   28531,  5, }, // Europe/Zurich
    {  101, 5097,    4006, 12, }, // Indian/Antananarivo
    {  101, 6966,    4018,  5, }, // Indian/Chagos
    {  101, 6065,   57861, 13, }, // Indian/Christmas
    {  101, 6082,   57874, 15, }, // Indian/Cocos
    {  101, 5048,   57889, 15, }, // Indian/Comoro
    {  101, 6680,    4057,  8, }, // Indian/Kerguelen
    {  101, 7260,   28598,  3, }, // Indian/Mahe
    {  101, 7069,   53859,  8, }, // Indian/Maldives
    {  101, 4088,    4074,  7, }, // Indian/Mauritius
    {  101, 5117,   28626,  7, }, // Indian/Mayotte
    {  101, 7211,   28633,  7, }, // Indian/Reunion
    {  101, 4441,    4095,  4, }, // Pacific/Apia
    {  101, 3009,    4099,  6, }, // Pacific/Auckland
    {  101, 3725,   28640,  9, }, // Pacific/Bougainville
    {  101, 3034,    4113,  5, }, // Pacific/Chatham
    {  101, 3176,   57904,  4, }, // Pacific/Chuuk
    {  101, 2239,   57908, 14, }, // Pacific/Easter
    {  101, 7360,   28676,  5, }, // Pacific/Efate
    {  101, 7327,    4138,  7, }, // Pacific/Fakaofo
    {  101, 3921,   28681,  5, }, // Pacific/Fiji
    {  101, 7343,    4149,  8, }, // Pacific/Funafuti
    {  101, 6697,   57922, 19, }, // Pacific/Galapagos
    {  101, 6715,   28705,  6, }, // Pacific/Gambier
    {  101, 3841,    4192, 11, }, // Pacific/Guadalcanal
    {  101, 6037,    4203,  4, }, // Pacific/Guam
    {  101, 3068,    4207,  6, }, // Pacific/Kanton
    {  101, 4017,    4213, 10, }, // Pacific/Kiritimati
    {  101, 7038,    4223,  6, }, // Pacific/Kosrae
    {  101, 2844,   28734, 10, }, // Pacific/Kwajalein
    {  101, 4896,   28744,  7, }, // Pacific/Majuro
    {  101, 4070,   57941, 18, }, // Pacific/Marquesas
    {  101, 8945,   28767,  6, }, // Pacific/Midway
    {  101, 7103,    4277,  5, }, // Pacific/Nauru
    {  101, 7132,   28780,  4, }, // Pacific/Niue
    {  101, 4187,    4286,  7, }, // Pacific/Norfolk
    {  101, 7117,    4293,  5, }, // Pacific/Noumea
    {  101, 3145,    4298,  9, }, // Pacific/Pago_Pago
    {  101, 7155,    4307,  5, }, // Pacific/Palau
    {  101, 7194,   28798,  7, }, // Pacific/Pitcairn
    {  101, 3115,    4319,  6, }, // Pacific/Pohnpei
    {  101, 4826,    4325, 11, }, // Pacific/Port_Moresby
    {  101, 6095,    4336,  9, }, // Pacific/Rarotonga
    {  101, 6050,   28815,  6, }, // Pacific/Saipan
    {  101, 7312,    4351,  5, }, // Pacific/Tahiti
    {  101, 6731,    4356,  6, }, // Pacific/Tarawa
    {  101, 4602,    4362,  9, }, // Pacific/Tongatapu
    {  101, 7392,   57959, 11, }, // Pacific/Wake
    {  101, 7405,   57970, 15, }, // Pacific/Wallis
    {  102,   14,       0,  6, }, // Africa/Asmara Colognian/Latin/Germany
    {  102, 2322,   57985,  6, }, // Africa/Cairo
    {  102, 5185,       6,  8, }, // Africa/El_Aaiun
    {  102, 4763,   57991,  6, }, // Africa/Lagos
    {  102, 6888,      14,  4, }, // Africa/Lome
    {  102, 5290,      18,  9, }, // Africa/Ndjamena
    {  102, 4454,      27,  8, }, // Africa/Sao_Tome
    {  102, 4171,   57997,  7, }, // Africa/Windhoek
    {  102, 4573,      35,  9, }, // America/Araguaina
    {  102,  270,      44,  7, }, // America/Argentina/Cordoba
    {  102, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  102, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  102, 4271,      70,  8, }, // America/Asuncion
    {  102,  237,      78,  8, }, // America/Atikokan
    {  102, 7623,      86, 17, }, // America/Bahia_Banderas
    {  102, 7646,     103,  5, }, // America/Belem
    {  102, 4380,     108,  6, }, // America/Bogota
    {  102, 3887,     114,  6, }, // America/Cancun
    {  102, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  102, 5441,   58004, 10, }, // America/Costa_Rica
    {  102, 3810,     133,  6, }, // America/Cuiaba
    {  102, 5742,     139,  7, }, // America/Curacao
    {  102, 7887,     146,  8, }, // America/Eirunepe
    {  102, 4860,   58014,  9, }, // America/Guayaquil
    {  102,  481,   58023, 15, }, // America/Indiana/Knox
    {  102, 7979,   58038, 18, }, // America/Indiana/Marengo
    {  102, 8003,   58056, 21, }, // America/Indiana/Petersburg
    {  102, 8030,   58077, 20, }, // America/Indiana/Tell_City
    {  102, 8056,   58097, 16, }, // America/Indiana/Vevay
    {  102, 8078,   58113, 20, }, // America/Indiana/Vincennes
    {  102, 8104,   58133, 18, }, // America/Indiana/Winamac
    {  102, 8143,   58151, 22, }, // America/Kentucky/Monticello
    {  102, 5951,     288, 22, }, // America/Lower_Princes
    {  102, 8171,     310,  6, }, // America/Maceio
    {  102, 2919,     316,  8, }, // America/Mazatlan
    {  102, 8238,     324,  6, }, // America/Merida
    {  102, 2951,   58173, 14, }, // America/Mexico_City
    {  102, 4410,     341, 12, }, // America/Miquelon
    {  102, 1852,     353, 19, }, // America/Noronha
    {  102, 8319,   58187, 21, }, // America/North_Dakota/Beulah
    {  102, 8347,   58208, 21, }, // America/North_Dakota/Center
    {  102, 8375,   58229, 24, }, // America/North_Dakota/New_Salem
    {  102,  393,     435,  4, }, // America/Nuuk
    {  102, 8495,     439,  8, }, // America/Santarem
    {  102, 1880,     447,  9, }, // America/Sao_Paulo
    {  102, 6918,     456, 16, }, // America/Scoresbysund
    {  102, 8526,   58253, 15, }, // America/St_Barthelemy
    {  102, 2063,   58268, 11, }, // America/St_Johns
    {  102, 5882,   58279, 10, }, // America/St_Kitts
    {  102, 5899,   58289, 16, }, // America/St_Lucia
    {  102,  855,   58305, 11, }, // America/St_Thomas
    {  102, 5932,   58316, 15, }, // America/St_Vincent
    {  102, 8570,    8170,  7, }, // America/Yakutat
    {  102, 6152,   58331, 27, }, // Antarctica/DumontDUrville
    {  102, 7295,   58358, 36, }, // Antarctica/Syowa
    {  102, 7374,    4780,  6, }, // Antarctica/Vostok
    {  102, 5387,   58394,  6, }, // Asia/Aqtobe
    {  102,  966,   58400,  9, }, // Asia/Ashgabat
    {  102, 3626,    4802,  6, }, // Asia/Baghdad
    {  102, 3797,   58409,  8, }, // Asia/Bishkek
    {  102, 4559,    4841,  8, }, // Asia/Damascus
    {  102, 6178,   58417,  9, }, // Asia/Dushanbe
    {  102, 8669,   58426,  5, }, // Asia/Gaza
    {  102, 1261,   58431, 30, }, // Asia/Ho_Chi_Minh
    {  102, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  102, 4790,     704,  5, }, // Asia/Hovd
    {  102, 4335,   58461, 11, }, // Asia/Kamchatka
    {  102, 1187,     709,  9, }, // Asia/Kathmandu
    {  102,  994,     718,  7, }, // Asia/Kolkata
    {  102, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  102, 1213,     725,  5, }, // Asia/Macau
    {  102, 2556,   58472,  8, }, // Asia/Nicosia
    {  102, 6980,   58480,  9, }, // Asia/Phnom_Penh
    {  102, 4288,   58489,  9, }, // Asia/Qyzylorda
    {  102, 3603,   35609,  5, }, // Asia/Riyadh
    {  102, 1055,   58498,  9, }, // Asia/Shanghai
    {  102, 3319,   58507, 10, }, // Asia/Singapore
    {  102, 4800,   58517,  9, }, // Asia/Tashkent
    {  102, 3934,   58526,  6, }, // Asia/Tbilisi
    {  102, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {  102, 1161,   58532, 11, }, // Asia/Urumqi
    {  102, 4729,    5001, 11, }, // Asia/Vladivostok
    {  102, 4847,    8526,  7, }, // Asia/Yakutsk
    {  102, 1237,   58543,  6, }, // Asia/Yangon
    {  102, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  102, 3766,   58549,  6, }, // Asia/Yerevan
    {  102, 3682,   58555,  6, }, // Atlantic/Azores
    {  102, 6647,   58561,  8, }, // Atlantic/Canary
    {  102, 3746,   58569,  9, }, // Atlantic/Cape_Verde
    {  102, 1397,   58578,  5, }, // Atlantic/Faroe
    {  102, 6840,   58583, 11, }, // Atlantic/St_Helena
    {  102, 2302,    5078,  5, }, // Europe/Athens
    {  102, 6355,   58594,  7, }, // Europe/Belgrade
    {  102, 2169,   23425,  7, }, // Europe/Brussels
    {  102, 3947,   29329,  8, }, // Europe/Bucharest
    {  102, 8790,     799,  8, }, // Europe/Busingen
    {  102, 2585,     807,  8, }, // Europe/Chisinau
    {  102, 6308,   58601, 10, }, // Europe/Copenhagen
    {  102, 6326,   58611,  9, }, // Europe/Gibraltar
    {  102, 8806,   58620,  7, }, // Europe/Guernsey
    {  102, 8822,   58627,  9, }, // Europe/Isle_of_Man
    {  102, 1132,   58636,  8, }, // Europe/Istanbul
    {  102, 8841,   58644,  6, }, // Europe/Jersey
    {  102, 3998,   58650, 13, }, // Europe/Kaliningrad
    {  102, 2529,     815,  4, }, // Europe/Kyiv
    {  102, 3232,    5139,  8, }, // Europe/Lisbon
    {  102, 6384,   58663, 11, }, // Europe/Luxembourg
    {  102, 3556,   58674,  6, }, // Europe/Moscow
    {  102, 6294,    6716,  4, }, // Europe/Prague
    {  102, 8868,   58680,  5, }, // Europe/Riga
    {  102, 6343,    8869,  3, }, // Europe/Rome
    {  102, 6221,   58685,  7, }, // Europe/Tirane
    {  102, 6586,   58692, 12, }, // Europe/Vatican
    {  102, 6250,   58704,  4, }, // Europe/Vienna
    {  102, 4746,   58708,  9, }, // Europe/Volgograd
    {  102, 3209,   58717,  8, }, // Europe/Warsaw
    {  102, 6280,   58725,  6, }, // Europe/Zagreb
    {  102, 6559,   58731,  7, }, // Europe/Zurich
    {  102, 5048,    4421,  7, }, // Indian/Comoro
    {  102, 7260,     896,  4, }, // Indian/Mahe
    {  102, 7069,   58738,  8, }, // Indian/Maldives
    {  102, 7211,     900,  7, }, // Indian/Reunion
    {  102, 3176,     922,  5, }, // Pacific/Chuuk
    {  102, 6697,   58746, 10, }, // Pacific/Galapagos
    {  102, 6037,   58756,  4, }, // Pacific/Guam
    {  102, 2725,   58760,  8, }, // Pacific/Honolulu
    {  102, 3068,     957,  6, }, // Pacific/Kanton
    {  102, 7117,    1028,  6, }, // Pacific/Noumea
    {  102, 7194,    9099,  7, }, // Pacific/Pitcairn
    {  102, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  102, 7405,    1068, 15, }, // Pacific/Wallis
    {  103, 6807,   58768,  7, }, // Africa/Abidjan Coptic/Coptic/Egypt
    {  103, 6779,   58775,  4, }, // Africa/Accra
    {  103, 5078,   58779, 10, }, // Africa/Addis_Ababa
    {  103, 7420,   58789,  6, }, // Africa/Algiers
    {  103,   14,   58795,  6, }, // Africa/Asmara
    {  103,   44,   58801,  6, }, // Africa/Bamako
    {  103, 5276,   58807,  7, }, // Africa/Bangui
    {  103, 6765,   58814,  7, }, // Africa/Banjul
    {  103, 7435,   58821,  6, }, // Africa/Bissau
    {  103, 4976,   58827,  7, }, // Africa/Blantyre
    {  103, 5306,   58834,  8, }, // Africa/Brazzaville
    {  103, 4941,   58842, 12, }, // Africa/Bujumbura
    {  103, 2322,   58854,  6, }, // Africa/Cairo
    {  103, 4136,   58860, 10, }, // Africa/Casablanca
    {  103, 7449,   58870,  5, }, // Africa/Ceuta
    {  103, 6792,   58875,  7, }, // Africa/Conakry
    {  103, 6859,   58882,  5, }, // Africa/Dakar
    {  103, 5149,   58887, 12, }, // Africa/Dar_es_Salaam
    {  103, 5062,   58899,  7, }, // Africa/Djibouti
    {  103, 5262,   58906,  6, }, // Africa/Douala
    {  103, 5185,   58912,  8, }, // Africa/El_Aaiun
    {  103, 6872,   58920,  7, }, // Africa/Freetown
    {  103, 4925,   58927,  7, }, // Africa/Gaborone
    {  103, 5034,   58934,  6, }, // Africa/Harare
    {  103, 4498,   58940, 11, }, // Africa/Johannesburg
    {  103, 4518,   58951,  5, }, // Africa/Juba
    {  103, 5170,   58956,  7, }, // Africa/Kampala
    {  103, 4543,   58963,  7, }, // Africa/Khartoum
    {  103, 4992,   58970,  6, }, // Africa/Kigali
    {  103, 5325,   58976,  7, }, // Africa/Kinshasa
    {  103, 4763,   58983,  5, }, // Africa/Lagos
    {  103, 5355,   58988,  8, }, // Africa/Libreville
    {  103, 6888,   58996,  4, }, // Africa/Lome
    {  103, 5230,   59000,  7, }, // Africa/Luanda
    {  103, 4958,   59007, 11, }, // Africa/Lubumbashi
    {  103, 5020,   59018,  7, }, // Africa/Lusaka
    {  103, 5341,   59025,  6, }, // Africa/Malabo
    {  103, 5006,   59031,  7, }, // Africa/Maputo
    {  103, 5216,   59038,  7, }, // Africa/Maseru
    {  103, 5201,   59045,  6, }, // Africa/Mbabane
    {  103, 5132,   59051,  8, }, // Africa/Mogadishu
    {  103, 7053,   59059,  8, }, // Africa/Monrovia
    {  103, 3872,   59067,  7, }, // Africa/Nairobi
    {  103, 5290,   59074,  7, }, // Africa/Ndjamena
    {  103, 5373,   59081,  6, }, // Africa/Niamey
    {  103, 6822,   59087,  8, }, // Africa/Nouakchott
    {  103, 6746,   59095, 11, }, // Africa/Ouagadougou
    {  103, 5244,   59106, 10, }, // Africa/Porto-Novo
    {  103, 4454,   59116,  8, }, // Africa/Sao_Tome
    {  103, 2868,   59124,  8, }, // Africa/Tripoli
    {  103, 6573,   59132,  6, }, // Africa/Tunis
    {  103, 4171,   59138,  8, }, // Africa/Windhoek
    {  103,  132,   59146,  4, }, // America/Adak
    {  103, 3365,   59150,  7, }, // America/Anchorage
    {  103, 5626,   59157,  6, }, // America/Anguilla
    {  103, 5643,   59163,  6, }, // America/Antigua
    {  103, 4573,   59169, 10, }, // America/Araguaina
    {  103,  166,   59179, 13, }, // America/Argentina/Buenos_Aires
    {  103,   91,   59192,  9, }, // America/Argentina/Catamarca
    {  103,  270,   59201,  7, }, // America/Argentina/Cordoba
    {  103,  441,   59208,  7, }, // America/Argentina/Jujuy
    {  103, 7462,   59215,  8, }, // America/Argentina/La_Rioja
    {  103,  565,   59223,  7, }, // America/Argentina/Mendoza
    {  103, 7489,   59230, 12, }, // America/Argentina/Rio_Gallegos
    {  103, 7520,   59242,  5, }, // America/Argentina/Salta
    {  103, 7544,   59247,  9, }, // America/Argentina/San_Juan
    {  103, 5599,   59256,  9, }, // America/Argentina/San_Luis
    {  103, 7571,   59265,  9, }, // America/Argentina/Tucuman
    {  103, 7597,   59274, 10, }, // America/Argentina/Ushuaia
    {  103, 5659,   59284,  6, }, // America/Aruba
    {  103, 4271,   59290,  9, }, // America/Asuncion
    {  103,  237,   59299,  8, }, // America/Atikokan
    {  103, 3698,   59307,  5, }, // America/Bahia
    {  103, 7623,   59312, 16, }, // America/Bahia_Banderas
    {  103, 5673,   59328,  8, }, // America/Barbados
    {  103, 7646,   59336,  5, }, // America/Belem
    {  103, 5426,   59341,  6, }, // America/Belize
    {  103, 7660,   59347, 12, }, // America/Blanc-Sablon
    {  103, 7681,   59359,  9, }, // America/Boa_Vista
    {  103, 4380,   59368,  6, }, // America/Bogota
    {  103, 7699,   59374,  5, }, // America/Boise
    {  103, 7713,   59379, 18, }, // America/Cambridge_Bay
    {  103, 7735,   59397, 12, }, // America/Campo_Grande
    {  103, 3887,   59409,  7, }, // America/Cancun
    {  103, 4713,   59416,  7, }, // America/Caracas
    {  103, 4364,   59423,  7, }, // America/Cayenne
    {  103, 5515,   59430,  6, }, // America/Cayman
    {  103, 2262,   59436,  6, }, // America/Chicago
    {  103, 7756,   59442, 10, }, // America/Chihuahua
    {  103, 7774,   59452, 15, }, // America/Ciudad_Juarez
    {  103, 5441,   59467, 10, }, // America/Costa_Rica
    {  103, 7796,   59477,  7, }, // America/Coyhaique
    {  103, 7814,   59484,  7, }, // America/Creston
    {  103, 3810,   59491,  7, }, // America/Cuiaba
    {  103, 5742,   59498,  8, }, // America/Curacao
    {  103, 7830,   59506, 11, }, // America/Danmarkshavn
    {  103, 7851,   59517,  6, }, // America/Dawson
    {  103, 7866,   59523, 11, }, // America/Dawson_Creek
    {  103,  805,   59534,  6, }, // America/Denver
    {  103, 3484,   59540,  7, }, // America/Detroit
    {  103, 5758,   59547,  8, }, // America/Dominica
    {  103,  893,   59555,  8, }, // America/Edmonton
    {  103, 7887,   59563,  9, }, // America/Eirunepe
    {  103, 5460,   59572, 11, }, // America/El_Salvador
    {  103, 7904,   59583, 11, }, // America/Fort_Nelson
    {  103, 7924,   59594,  9, }, // America/Fortaleza
    {  103, 7942,   59603,  8, }, // America/Glace_Bay
    {  103, 6900,   59611,  8, }, // America/Goose_Bay
    {  103, 4631,   59619, 11, }, // America/Grand_Turk
    {  103, 5789,   59630,  7, }, // America/Grenada
    {  103, 5805,   59637, 10, }, // America/Guadeloupe
    {  103, 3779,   59647, 10, }, // America/Guatemala
    {  103, 4860,   59657,  9, }, // America/Guayaquil
    {  103, 6951,   59666,  5, }, // America/Guyana
    {  103, 1941,   59671,  7, }, // America/Halifax
    {  103, 2283,   59678,  6, }, // America/Havana
    {  103, 7960,   59684, 10, }, // America/Hermosillo
    {  103,  348,   59694, 12, }, // America/Indiana/Indianapolis
    {  103,  481,   59706, 12, }, // America/Indiana/Knox
    {  103, 7979,   59718, 16, }, // America/Indiana/Marengo
    {  103, 8003,   59734, 20, }, // America/Indiana/Petersburg
    {  103, 8030,   59754, 17, }, // America/Indiana/Tell_City
    {  103, 8056,   59771, 15, }, // America/Indiana/Vevay
    {  103, 8078,   59786, 18, }, // America/Indiana/Vincennes
    {  103, 8104,   59804, 17, }, // America/Indiana/Winamac
    {  103, 8128,   59821,  7, }, // America/Inuvik
    {  103,  660,   59828,  8, }, // America/Iqaluit
    {  103, 2801,   59836,  7, }, // America/Jamaica
    {  103, 5399,   59843,  7, }, // America/Juneau
    {  103,  521,   59850,  7, }, // America/Kentucky/Louisville
    {  103, 8143,   59857, 19, }, // America/Kentucky/Monticello
    {  103, 5723,   59876,  9, }, // America/Kralendijk
    {  103, 4395,   59885,  6, }, // America/La_Paz
    {  103, 7169,   59891,  4, }, // America/Lima
    {  103, 3258,   59895, 11, }, // America/Los_Angeles
    {  103, 5951,   59906, 11, }, // America/Lower_Princes
    {  103, 8171,   59917,  6, }, // America/Maceio
    {  103, 8186,   59923,  8, }, // America/Managua
    {  103, 1910,   59931,  6, }, // America/Manaus
    {  103, 5916,   59937,  7, }, // America/Marigot
    {  103, 5824,   59944,  8, }, // America/Martinique
    {  103, 8202,   59952,  9, }, // America/Matamoros
    {  103, 2919,   59961,  8, }, // America/Mazatlan
    {  103, 8220,   59969,  8, }, // America/Menominee
    {  103, 8238,   59977,  6, }, // America/Merida
    {  103, 8253,   59983, 10, }, // America/Metlakatla
    {  103, 2951,   59993, 12, }, // America/Mexico_City
    {  103, 4410,   60005,  8, }, // America/Miquelon
    {  103, 8272,   60013,  7, }, // America/Moncton
    {  103, 8288,   60020,  8, }, // America/Monterrey
    {  103, 4117,   60028, 10, }, // America/Montevideo
    {  103, 5843,   60038,  9, }, // America/Montserrat
    {  103, 5500,   60047,  6, }, // America/Nassau
    {  103, 2381,   60053,  9, }, // America/New_York
    {  103, 8306,   60062,  4, }, // America/Nome
    {  103, 1852,   60066, 19, }, // America/Noronha
    {  103, 8319,   60085, 22, }, // America/North_Dakota/Beulah
    {  103, 8347,   60107, 23, }, // America/North_Dakota/Center
    {  103, 8375,   60130, 27, }, // America/North_Dakota/New_Salem
    {  103,  393,   60157,  6, }, // America/Nuuk
    {  103, 8406,   60163,  7, }, // America/Ojinaga
    {  103, 2358,   60170,  6, }, // America/Panama
    {  103, 6192,   60176, 10, }, // America/Paramaribo
    {  103, 2975,   60186,  5, }, // America/Phoenix
    {  103, 3964,   60191, 13, }, // America/Port-au-Prince
    {  103, 5973,   60204, 14, }, // America/Port_of_Spain
    {  103, 8422,   60218, 11, }, // America/Porto_Velho
    {  103, 5862,   60229, 12, }, // America/Puerto_Rico
    {  103, 4049,   60241, 13, }, // America/Punta_Arenas
    {  103, 8442,   60254, 12, }, // America/Rankin_Inlet
    {  103, 8463,   60266,  6, }, // America/Recife
    {  103, 1997,   60272,  6, }, // America/Regina
    {  103, 8478,   60278,  9, }, // America/Resolute
    {  103,  695,   60287, 10, }, // America/Rio_Branco
    {  103, 8495,   60297,  8, }, // America/Santarem
    {  103, 2203,   60305,  8, }, // America/Santiago
    {  103, 6130,   60313, 13, }, // America/Santo_Domingo
    {  103, 1880,   60326,  9, }, // America/Sao_Paulo
    {  103, 6918,   60335, 12, }, // America/Scoresbysund
    {  103, 8512,   60347,  5, }, // America/Sitka
    {  103, 8526,   60352, 14, }, // America/St_Barthelemy
    {  103, 2063,   60366,  9, }, // America/St_Johns
    {  103, 5882,   60375,  9, }, // America/St_Kitts
    {  103, 5899,   60384, 11, }, // America/St_Lucia
    {  103,  855,   60395, 10, }, // America/St_Thomas
    {  103, 5932,   60405, 12, }, // America/St_Vincent
    {  103, 8548,   60417, 13, }, // America/Swift_Current
    {  103, 5480,   60430, 12, }, // America/Tegucigalpa
    {  103, 5775,   60442,  5, }, // America/Thule
    {  103,  313,   60447,  8, }, // America/Tijuana
    {  103,  608,   60455,  7, }, // America/Toronto
    {  103, 5707,   60462,  6, }, // America/Tortola
    {  103, 2095,   60468,  9, }, // America/Vancouver
    {  103, 2146,   60477,  9, }, // America/Whitehorse
    {  103,  734,   60486,  9, }, // America/Winnipeg
    {  103, 8570,   60495,  8, }, // America/Yakutat
    {  103, 6020,   60503, 17, }, // Antarctica/Casey
    {  103, 6113,   60520,  5, }, // Antarctica/Davis
    {  103, 6152,   60525, 27, }, // Antarctica/DumontDUrville
    {  103, 8586,   60552, 16, }, // Antarctica/Macquarie
    {  103, 7085,   60568, 18, }, // Antarctica/Mawson
    {  103,  932,   60586, 20, }, // Antarctica/McMurdo
    {  103, 8607,   60606, 11, }, // Antarctica/Palmer
    {  103, 7226,   60617, 18, }, // Antarctica/Rothera
    {  103, 7295,   60635, 16, }, // Antarctica/Syowa
    {  103, 8625,   60651, 17, }, // Antarctica/Troll
    {  103, 7374,   60668, 18, }, // Antarctica/Vostok
    {  103, 1431,   60686, 12, }, // Arctic/Longyearbyen
    {  103, 5589,   60698,  4, }, // Asia/Aden
    {  103, 5414,   60702,  6, }, // Asia/Almaty
    {  103, 3987,   60708,  5, }, // Asia/Amman
    {  103, 5530,   60713,  6, }, // Asia/Anadyr
    {  103, 5542,   60719,  5, }, // Asia/Aqtau
    {  103, 5387,   60724,  5, }, // Asia/Aqtobe
    {  103,  966,   60729,  7, }, // Asia/Ashgabat
    {  103, 8642,   60736,  6, }, // Asia/Atyrau
    {  103, 3626,   60742,  6, }, // Asia/Baghdad
    {  103, 5553,   60748,  7, }, // Asia/Bahrain
    {  103, 3672,   59496,  5, }, // Asia/Baku
    {  103, 4485,   60755,  6, }, // Asia/Bangkok
    {  103, 3590,   60761,  7, }, // Asia/Barnaul
    {  103, 4105,   60768,  7, }, // Asia/Beirut
    {  103, 3797,   60775,  6, }, // Asia/Bishkek
    {  103, 6008,   60781,  7, }, // Asia/Brunei
    {  103, 4620,   60788,  4, }, // Asia/Chita
    {  103, 4530,   60792,  7, }, // Asia/Colombo
    {  103, 4559,   60799,  8, }, // Asia/Damascus
    {  103, 1095,   58882,  4, }, // Asia/Dhaka
    {  103, 6211,   60807,  4, }, // Asia/Dili
    {  103, 3615,   60811,  6, }, // Asia/Dubai
    {  103, 6178,   60817,  7, }, // Asia/Dushanbe
    {  103, 8654,   60824, 10, }, // Asia/Famagusta
    {  103, 8669,   60834,  4, }, // Asia/Gaza
    {  103, 4814,   60838,  6, }, // Asia/Hebron
    {  103, 1261,   60844, 10, }, // Asia/Ho_Chi_Minh
    {  103, 2706,   60854,  9, }, // Asia/Hong_Kong
    {  103, 4790,   60863,  4, }, // Asia/Hovd
    {  103, 4203,   60867,  8, }, // Asia/Irkutsk
    {  103, 7025,   60875,  7, }, // Asia/Jakarta
    {  103, 7011,   60882,  9, }, // Asia/Jayapura
    {  103, 1292,   60891, 10, }, // Asia/Jerusalem
    {  103, 3579,   60901,  6, }, // Asia/Kabul
    {  103, 4335,   60907,  8, }, // Asia/Kamchatka
    {  103, 4258,   60915,  6, }, // Asia/Karachi
    {  103, 1187,   60921,  9, }, // Asia/Kathmandu
    {  103, 8679,   60930,  7, }, // Asia/Khandyga
    {  103,  994,   60937,  7, }, // Asia/Kolkata
    {  103, 4216,   60944, 11, }, // Asia/Krasnoyarsk
    {  103, 4878,   60955, 15, }, // Asia/Kuala_Lumpur
    {  103, 5995,   60970,  7, }, // Asia/Kuching
    {  103, 5566,   60977,  6, }, // Asia/Kuwait
    {  103, 1213,   60983,  5, }, // Asia/Macau
    {  103, 4036,   60988,  7, }, // Asia/Magadan
    {  103, 1351,   60995,  8, }, // Asia/Makassar
    {  103, 7182,   61003,  6, }, // Asia/Manila
    {  103, 6939,   61009,  6, }, // Asia/Muscat
    {  103, 2556,   61015,  7, }, // Asia/Nicosia
    {  103, 8693,   61022, 13, }, // Asia/Novokuznetsk
    {  103, 4154,   61035, 11, }, // Asia/Novosibirsk
    {  103, 4248,   61046,  4, }, // Asia/Omsk
    {  103, 7145,   61050,  4, }, // Asia/Oral
    {  103, 6980,   61054,  9, }, // Asia/Phnom_Penh
    {  103, 8711,   61063,  9, }, // Asia/Pontianak
    {  103, 4233,   61072,  9, }, // Asia/Pyongyang
    {  103, 5578,   61081,  5, }, // Asia/Qatar
    {  103, 8726,   61086,  8, }, // Asia/Qostanay
    {  103, 4288,   61094,  9, }, // Asia/Qyzylorda
    {  103, 3603,   61103,  4, }, // Asia/Riyadh
    {  103, 4427,   61107,  7, }, // Asia/Sakhalin
    {  103, 7245,   61114,  9, }, // Asia/Samarkand
    {  103, 3298,   61123,  5, }, // Asia/Seoul
    {  103, 1055,   61128,  6, }, // Asia/Shanghai
    {  103, 3319,   61134,  8, }, // Asia/Singapore
    {  103, 4316,   61142, 13, }, // Asia/Srednekolymsk
    {  103, 3282,   61155,  6, }, // Asia/Taipei
    {  103, 4800,   61161,  7, }, // Asia/Tashkent
    {  103, 3934,   61168,  7, }, // Asia/Tbilisi
    {  103, 2774,   61175,  6, }, // Asia/Tehran
    {  103, 1319,   61181,  6, }, // Asia/Thimphu
    {  103, 2823,   61187,  5, }, // Asia/Tokyo
    {  103, 4591,   61192,  5, }, // Asia/Tomsk
    {  103, 1023,   61197, 10, }, // Asia/Ulaanbaatar
    {  103, 1161,   61207,  8, }, // Asia/Urumqi
    {  103, 8740,   61215,  9, }, // Asia/Ust-Nera
    {  103, 6996,   61224,  8, }, // Asia/Vientiane
    {  103, 4729,   61232, 11, }, // Asia/Vladivostok
    {  103, 4847,   61243,  8, }, // Asia/Yakutsk
    {  103, 1237,   61251,  6, }, // Asia/Yangon
    {  103, 3902,   61257, 13, }, // Asia/Yekaterinburg
    {  103, 3766,   61270,  7, }, // Asia/Yerevan
    {  103, 3682,   61277,  6, }, // Atlantic/Azores
    {  103, 5690,   61283,  8, }, // Atlantic/Bermuda
    {  103, 6647,   61291,  7, }, // Atlantic/Canary
    {  103, 3746,   61298,  8, }, // Atlantic/Cape_Verde
    {  103, 1397,   61306,  6, }, // Atlantic/Faroe
    {  103, 8754,   61312,  7, }, // Atlantic/Madeira
    {  103, 2750,   61319,  8, }, // Atlantic/Reykjavik
    {  103, 7272,   61327, 15, }, // Atlantic/South_Georgia
    {  103, 6840,   61342, 11, }, // Atlantic/St_Helena
    {  103, 6663,   61353,  6, }, // Atlantic/Stanley
    {  103, 1672,   61359,  7, }, // Australia/Adelaide
    {  103, 1637,   61366,  7, }, // Australia/Brisbane
    {  103, 1801,   61373, 10, }, // Australia/Broken_Hill
    {  103, 1585,   61383,  7, }, // Australia/Darwin
    {  103, 3656,   61390,  5, }, // Australia/Eucla
    {  103, 1518,   61395,  6, }, // Australia/Hobart
    {  103, 8771,   61401,  8, }, // Australia/Lindeman
    {  103, 1549,   61409, 17, }, // Australia/Lord_Howe
    {  103, 1729,   61426,  8, }, // Australia/Melbourne
    {  103, 1764,   61434,  4, }, // Australia/Perth
    {  103, 1465,   61438,  6, }, // Australia/Sydney
    {  103, 6460,   61444,  9, }, // Europe/Amsterdam
    {  103, 6235,   61453,  7, }, // Europe/Andorra
    {  103, 3639,   61460,  8, }, // Europe/Astrakhan
    {  103, 2302,   61468,  6, }, // Europe/Athens
    {  103, 6355,   61474,  7, }, // Europe/Belgrade
    {  103, 4776,   61481,  6, }, // Europe/Berlin
    {  103, 6507,   61487, 10, }, // Europe/Bratislava
    {  103, 2169,   61497,  7, }, // Europe/Brussels
    {  103, 3947,   61504,  9, }, // Europe/Bucharest
    {  103, 3825,   61513,  9, }, // Europe/Budapest
    {  103, 8790,   61522,  9, }, // Europe/Busingen
    {  103, 2585,   61531,  7, }, // Europe/Chisinau
    {  103, 6308,   61538, 10, }, // Europe/Copenhagen
    {  103, 2340,   61548,  7, }, // Europe/Dublin
    {  103, 6326,   61555,  9, }, // Europe/Gibraltar
    {  103, 8806,   61564,  8, }, // Europe/Guernsey
    {  103, 6631,   61572,  8, }, // Europe/Helsinki
    {  103, 8822,   61580, 11, }, // Europe/Isle_of_Man
    {  103, 1132,   61591,  9, }, // Europe/Istanbul
    {  103, 8841,   61600,  5, }, // Europe/Jersey
    {  103, 3998,   61605, 11, }, // Europe/Kaliningrad
    {  103, 8855,   61616,  5, }, // Europe/Kirov
    {  103, 2529,   61621,  4, }, // Europe/Kyiv
    {  103, 3232,   61625,  7, }, // Europe/Lisbon
    {  103, 6525,   61632, 10, }, // Europe/Ljubljana
    {  103, 2503,   61642,  6, }, // Europe/London
    {  103, 6384,   61648, 11, }, // Europe/Luxembourg
    {  103, 4911,   61659,  6, }, // Europe/Madrid
    {  103, 6416,   61665,  5, }, // Europe/Malta
    {  103, 6601,   61670,  9, }, // Europe/Mariehamn
    {  103, 3712,   61679,  5, }, // Europe/Minsk
    {  103, 6429,   61684,  6, }, // Europe/Monaco
    {  103, 3556,   61690,  5, }, // Europe/Moscow
    {  103, 6477,   61695,  4, }, // Europe/Oslo
    {  103, 4303,   61699,  5, }, // Europe/Paris
    {  103, 6443,   61704,  9, }, // Europe/Podgorica
    {  103, 6294,   61713,  4, }, // Europe/Prague
    {  103, 8868,   61717,  4, }, // Europe/Riga
    {  103, 6343,   61721,  4, }, // Europe/Rome
    {  103, 4350,   61725,  6, }, // Europe/Samara
    {  103, 6489,   61731, 10, }, // Europe/San_Marino
    {  103, 6264,   61741,  8, }, // Europe/Sarajevo
    {  103, 4470,   61749,  7, }, // Europe/Saratov
    {  103, 8880,   61756, 10, }, // Europe/Simferopol
    {  103, 6402,   61766,  6, }, // Europe/Skopje
    {  103, 6618,   61772,  5, }, // Europe/Sofia
    {  103, 6542,   61777,  8, }, // Europe/Stockholm
    {  103, 8898,   61785,  6, }, // Europe/Tallinn
    {  103, 6221,   61791,  6, }, // Europe/Tirane
    {  103, 8913,   61797, 10, }, // Europe/Ulyanovsk
    {  103, 6371,   61807,  6, }, // Europe/Vaduz
    {  103, 6586,   61813,  7, }, // Europe/Vatican
    {  103, 6250,   61820,  6, }, // Europe/Vienna
    {  103, 8930,   61826,  8, }, // Europe/Vilnius
    {  103, 4746,   61834,  9, }, // Europe/Volgograd
    {  103, 3209,   61843,  6, }, // Europe/Warsaw
    {  103, 6280,   61849,  6, }, // Europe/Zagreb
    {  103, 6559,   61855,  6, }, // Europe/Zurich
    {  103, 5097,   61861, 12, }, // Indian/Antananarivo
    {  103, 6966,   61873,  5, }, // Indian/Chagos
    {  103, 6065,   61878, 17, }, // Indian/Christmas
    {  103, 6082,   61895, 14, }, // Indian/Cocos
    {  103, 5048,   61909,  7, }, // Indian/Comoro
    {  103, 6680,   61916, 15, }, // Indian/Kerguelen
    {  103, 7260,   61931,  4, }, // Indian/Mahe
    {  103, 7069,   61935,  6, }, // Indian/Maldives
    {  103, 4088,   61941, 10, }, // Indian/Mauritius
    {  103, 5117,   61951,  5, }, // Indian/Mayotte
    {  103, 7211,   61956,  9, }, // Indian/Reunion
    {  103, 4441,   61965,  4, }, // Pacific/Apia
    {  103, 3009,   61969,  7, }, // Pacific/Auckland
    {  103, 3725,   61976, 10, }, // Pacific/Bougainville
    {  103, 3034,   61986, 14, }, // Pacific/Chatham
    {  103, 3176,   62000,  4, }, // Pacific/Chuuk
    {  103, 2239,   62004, 12, }, // Pacific/Easter
    {  103, 7360,   62016,  4, }, // Pacific/Efate
    {  103, 7327,   62020,  7, }, // Pacific/Fakaofo
    {  103, 3921,   62027,  4, }, // Pacific/Fiji
    {  103, 7343,   62031, 10, }, // Pacific/Funafuti
    {  103, 6697,   62041, 16, }, // Pacific/Galapagos
    {  103, 6715,   62057,  7, }, // Pacific/Gambier
    {  103, 3841,   62064, 12, }, // Pacific/Guadalcanal
    {  103, 6037,   59927,  5, }, // Pacific/Guam
    {  103, 3068,   62076,  6, }, // Pacific/Kanton
    {  103, 4017,   62082,  9, }, // Pacific/Kiritimati
    {  103, 7038,   62091,  6, }, // Pacific/Kosrae
    {  103, 2844,   62097, 16, }, // Pacific/Kwajalein
    {  103, 4896,   62113,  7, }, // Pacific/Majuro
    {  103, 4070,   62120, 17, }, // Pacific/Marquesas
    {  103, 8945,   62137, 13, }, // Pacific/Midway
    {  103, 7103,   62150,  6, }, // Pacific/Nauru
    {  103, 7132,   62156,  5, }, // Pacific/Niue
    {  103, 4187,   62161, 15, }, // Pacific/Norfolk
    {  103, 7117,   62176,  6, }, // Pacific/Noumea
    {  103, 3145,   62182,  9, }, // Pacific/Pago_Pago
    {  103, 7155,   62191,  5, }, // Pacific/Palau
    {  103, 7194,   62196, 16, }, // Pacific/Pitcairn
    {  103, 3115,   62212,  7, }, // Pacific/Pohnpei
    {  103, 4826,   62219, 12, }, // Pacific/Port_Moresby
    {  103, 6095,   62231,  9, }, // Pacific/Rarotonga
    {  103, 6050,   62240,  6, }, // Pacific/Saipan
    {  103, 7312,   62246,  6, }, // Pacific/Tahiti
    {  103, 6731,   62252,  7, }, // Pacific/Tarawa
    {  103, 4602,   62259, 10, }, // Pacific/Tongatapu
    {  103, 7392,   62269, 12, }, // Pacific/Wake
    {  103, 7405,   62281, 18, }, // Pacific/Wallis
    {  104,   14,       0,  6, }, // Africa/Asmara Cornish/Latin/United Kingdom
    {  104, 5185,       6,  8, }, // Africa/El_Aaiun
    {  104, 6888,      14,  4, }, // Africa/Lome
    {  104, 5290,      18,  9, }, // Africa/Ndjamena
    {  104, 4454,      27,  8, }, // Africa/Sao_Tome
    {  104, 4573,      35,  9, }, // America/Araguaina
    {  104,  270,      44,  7, }, // America/Argentina/Cordoba
    {  104, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  104, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  104, 4271,      70,  8, }, // America/Asuncion
    {  104,  237,      78,  8, }, // America/Atikokan
    {  104, 7623,      86, 17, }, // America/Bahia_Banderas
    {  104, 7646,     103,  5, }, // America/Belem
    {  104, 4380,     108,  6, }, // America/Bogota
    {  104, 3887,     114,  6, }, // America/Cancun
    {  104, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  104, 3810,     133,  6, }, // America/Cuiaba
    {  104, 5742,     139,  7, }, // America/Curacao
    {  104, 7887,     146,  8, }, // America/Eirunepe
    {  104,  481,     154, 13, }, // America/Indiana/Knox
    {  104, 7979,     167, 16, }, // America/Indiana/Marengo
    {  104, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  104, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  104, 8056,     220, 14, }, // America/Indiana/Vevay
    {  104, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  104, 8104,     252, 16, }, // America/Indiana/Winamac
    {  104, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  104, 5951,     288, 22, }, // America/Lower_Princes
    {  104, 8171,     310,  6, }, // America/Maceio
    {  104, 2919,     316,  8, }, // America/Mazatlan
    {  104, 8238,     324,  6, }, // America/Merida
    {  104, 2951,    4381, 16, }, // America/Mexico_City
    {  104, 4410,     341, 12, }, // America/Miquelon
    {  104, 1852,     353, 19, }, // America/Noronha
    {  104, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  104, 8347,     392, 20, }, // America/North_Dakota/Center
    {  104, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  104,  393,     435,  4, }, // America/Nuuk
    {  104, 8495,     439,  8, }, // America/Santarem
    {  104, 1880,     447,  9, }, // America/Sao_Paulo
    {  104, 6918,     456, 16, }, // America/Scoresbysund
    {  104, 8526,     472, 14, }, // America/St_Barthelemy
    {  104, 2063,     486, 10, }, // America/St_Johns
    {  104, 5882,     496,  9, }, // America/St_Kitts
    {  104, 5899,     505,  9, }, // America/St_Lucia
    {  104,  855,     514, 10, }, // America/St_Thomas
    {  104, 5932,     524, 11, }, // America/St_Vincent
    {  104, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  104, 7295,     643,  5, }, // Antarctica/Syowa
    {  104, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  104, 4790,     704,  5, }, // Asia/Hovd
    {  104, 1187,     709,  9, }, // Asia/Kathmandu
    {  104,  994,     718,  7, }, // Asia/Kolkata
    {  104, 1213,     725,  5, }, // Asia/Macau
    {  104, 1161,     747,  6, }, // Asia/Urumqi
    {  104, 1237,     753,  6, }, // Asia/Yangon
    {  104, 6647,    4413,  8, }, // Atlantic/Canary
    {  104, 1397,     767,  5, }, // Atlantic/Faroe
    {  104, 6840,     773, 10, }, // Atlantic/St_Helena
    {  104, 8790,     799,  8, }, // Europe/Busingen
    {  104, 2585,     807,  8, }, // Europe/Chisinau
    {  104, 2529,     815,  4, }, // Europe/Kyiv
    {  104, 6221,     819,  6, }, // Europe/Tirane
    {  104, 5048,    4421,  7, }, // Indian/Comoro
    {  104, 7260,     896,  4, }, // Indian/Mahe
    {  104, 7211,     900,  7, }, // Indian/Reunion
    {  104, 3176,     922,  5, }, // Pacific/Chuuk
    {  104, 6697,     940,  9, }, // Pacific/Galapagos
    {  104, 3068,     957,  6, }, // Pacific/Kanton
    {  104, 7117,    1028,  6, }, // Pacific/Noumea
    {  104, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  104, 7405,    1068, 15, }, // Pacific/Wallis
    {  105,   14,       0,  6, }, // Africa/Asmara Corsican/Latin/France
    {  105, 5185,       6,  8, }, // Africa/El_Aaiun
    {  105, 6888,      14,  4, }, // Africa/Lome
    {  105, 5290,      18,  9, }, // Africa/Ndjamena
    {  105, 4454,      27,  8, }, // Africa/Sao_Tome
    {  105, 4573,      35,  9, }, // America/Araguaina
    {  105,  270,      44,  7, }, // America/Argentina/Cordoba
    {  105, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  105, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  105, 4271,      70,  8, }, // America/Asuncion
    {  105,  237,      78,  8, }, // America/Atikokan
    {  105, 7623,      86, 17, }, // America/Bahia_Banderas
    {  105, 7646,     103,  5, }, // America/Belem
    {  105, 4380,     108,  6, }, // America/Bogota
    {  105, 3887,     114,  6, }, // America/Cancun
    {  105, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  105, 3810,     133,  6, }, // America/Cuiaba
    {  105, 5742,     139,  7, }, // America/Curacao
    {  105, 7887,     146,  8, }, // America/Eirunepe
    {  105,  481,     154, 13, }, // America/Indiana/Knox
    {  105, 7979,     167, 16, }, // America/Indiana/Marengo
    {  105, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  105, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  105, 8056,     220, 14, }, // America/Indiana/Vevay
    {  105, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  105, 8104,     252, 16, }, // America/Indiana/Winamac
    {  105, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  105, 5951,     288, 22, }, // America/Lower_Princes
    {  105, 8171,     310,  6, }, // America/Maceio
    {  105, 2919,     316,  8, }, // America/Mazatlan
    {  105, 8238,     324,  6, }, // America/Merida
    {  105, 2951,    4381, 16, }, // America/Mexico_City
    {  105, 4410,     341, 12, }, // America/Miquelon
    {  105, 1852,     353, 19, }, // America/Noronha
    {  105, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  105, 8347,     392, 20, }, // America/North_Dakota/Center
    {  105, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  105,  393,     435,  4, }, // America/Nuuk
    {  105, 8495,     439,  8, }, // America/Santarem
    {  105, 1880,     447,  9, }, // America/Sao_Paulo
    {  105, 6918,     456, 16, }, // America/Scoresbysund
    {  105, 8526,     472, 14, }, // America/St_Barthelemy
    {  105, 2063,     486, 10, }, // America/St_Johns
    {  105, 5882,     496,  9, }, // America/St_Kitts
    {  105, 5899,     505,  9, }, // America/St_Lucia
    {  105,  855,     514, 10, }, // America/St_Thomas
    {  105, 5932,     524, 11, }, // America/St_Vincent
    {  105, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  105, 7295,     643,  5, }, // Antarctica/Syowa
    {  105, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  105, 4790,     704,  5, }, // Asia/Hovd
    {  105, 1187,     709,  9, }, // Asia/Kathmandu
    {  105,  994,     718,  7, }, // Asia/Kolkata
    {  105, 1213,     725,  5, }, // Asia/Macau
    {  105, 1161,     747,  6, }, // Asia/Urumqi
    {  105, 1237,     753,  6, }, // Asia/Yangon
    {  105, 6647,    4413,  8, }, // Atlantic/Canary
    {  105, 1397,     767,  5, }, // Atlantic/Faroe
    {  105, 6840,     773, 10, }, // Atlantic/St_Helena
    {  105, 8790,     799,  8, }, // Europe/Busingen
    {  105, 2585,     807,  8, }, // Europe/Chisinau
    {  105, 2529,     815,  4, }, // Europe/Kyiv
    {  105, 6221,     819,  6, }, // Europe/Tirane
    {  105, 5048,    4421,  7, }, // Indian/Comoro
    {  105, 7260,     896,  4, }, // Indian/Mahe
    {  105, 7211,     900,  7, }, // Indian/Reunion
    {  105, 3176,     922,  5, }, // Pacific/Chuuk
    {  105, 6697,     940,  9, }, // Pacific/Galapagos
    {  105, 3068,     957,  6, }, // Pacific/Kanton
    {  105, 7117,    1028,  6, }, // Pacific/Noumea
    {  105, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  105, 7405,    1068, 15, }, // Pacific/Wallis
    {  106, 5078,    4428, 11, }, // Africa/Addis_Ababa Croatian/Latin/Croatia
    {  106, 7420,   62299,  5, }, // Africa/Algiers
    {  106,   14,       0,  6, }, // Africa/Asmara
    {  106, 2322,    5363,  5, }, // Africa/Cairo
    {  106, 5062,   35324,  7, }, // Africa/Djibouti
    {  106, 5185,       6,  8, }, // Africa/El_Aaiun
    {  106, 6888,      14,  4, }, // Africa/Lome
    {  106, 5290,      18,  9, }, // Africa/Ndjamena
    {  106, 4454,      27,  8, }, // Africa/Sao_Tome
    {  106, 5626,   35338,  7, }, // America/Anguilla
    {  106, 4573,      35,  9, }, // America/Araguaina
    {  106,  270,      44,  7, }, // America/Argentina/Cordoba
    {  106, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  106, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  106, 4271,      70,  8, }, // America/Asuncion
    {  106,  237,      78,  8, }, // America/Atikokan
    {  106, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  106, 7646,     103,  5, }, // America/Belem
    {  106, 4380,     108,  6, }, // America/Bogota
    {  106, 3887,   35352,  6, }, // America/Cancun
    {  106, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  106, 5441,   35358,  9, }, // America/Costa_Rica
    {  106, 3810,     133,  6, }, // America/Cuiaba
    {  106, 5742,     139,  7, }, // America/Curacao
    {  106, 5758,   22339,  8, }, // America/Dominica
    {  106, 7887,     146,  8, }, // America/Eirunepe
    {  106, 5460,    7459,  8, }, // America/El_Salvador
    {  106, 5805,   21187,  9, }, // America/Guadeloupe
    {  106, 3779,   35376,  9, }, // America/Guatemala
    {  106, 6951,   62304,  7, }, // America/Guyana
    {  106,  481,     154, 13, }, // America/Indiana/Knox
    {  106, 7979,     167, 16, }, // America/Indiana/Marengo
    {  106, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  106, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  106, 8056,     220, 14, }, // America/Indiana/Vevay
    {  106, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  106, 8104,     252, 16, }, // America/Indiana/Winamac
    {  106, 2801,   35385,  7, }, // America/Jamaica
    {  106, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  106, 5951,     288, 22, }, // America/Lower_Princes
    {  106, 8171,     310,  6, }, // America/Maceio
    {  106, 2919,     316,  8, }, // America/Mazatlan
    {  106, 8238,    7779,  6, }, // America/Merida
    {  106, 2951,    4381, 16, }, // America/Mexico_City
    {  106, 4410,     341, 12, }, // America/Miquelon
    {  106, 1852,     353, 19, }, // America/Noronha
    {  106, 8319,   35392, 23, }, // America/North_Dakota/Beulah
    {  106, 8347,   35415, 23, }, // America/North_Dakota/Center
    {  106, 8375,   35438, 26, }, // America/North_Dakota/New_Salem
    {  106,  393,     435,  4, }, // America/Nuuk
    {  106, 5862,   35464,  9, }, // America/Puerto_Rico
    {  106, 8495,     439,  8, }, // America/Santarem
    {  106, 1880,     447,  9, }, // America/Sao_Paulo
    {  106, 6918,     456, 16, }, // America/Scoresbysund
    {  106, 8526,   46137, 16, }, // America/St_Barthelemy
    {  106, 2063,     486, 10, }, // America/St_Johns
    {  106, 5882,     496,  9, }, // America/St_Kitts
    {  106, 5899,     505,  9, }, // America/St_Lucia
    {  106,  855,     514, 10, }, // America/St_Thomas
    {  106, 5932,     524, 11, }, // America/St_Vincent
    {  106, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  106, 7295,     643,  5, }, // Antarctica/Syowa
    {  106, 5414,   62311,  8, }, // Asia/Almaty
    {  106, 5530,    8253,  6, }, // Asia/Anadyr
    {  106, 5542,     683,  5, }, // Asia/Aqtau
    {  106, 5387,    8259,  6, }, // Asia/Aqtobe
    {  106,  966,   62319,  7, }, // Asia/Ashgabat
    {  106, 3626,    4802,  6, }, // Asia/Baghdad
    {  106, 5553,    4808,  7, }, // Asia/Bahrain
    {  106, 3797,   35493,  6, }, // Asia/Bishkek
    {  106, 6008,   35499,  6, }, // Asia/Brunei
    {  106, 4620,   62326,  4, }, // Asia/Chita
    {  106, 4559,    4841,  6, }, // Asia/Damascus
    {  106, 6178,   35506,  7, }, // Asia/Dushanbe
    {  106, 1261,   35513,  9, }, // Asia/Ho_Chi_Minh
    {  106, 4790,     704,  5, }, // Asia/Hovd
    {  106, 7025,   35522,  8, }, // Asia/Jakarta
    {  106, 1292,   35539,  9, }, // Asia/Jerusalem
    {  106, 4335,   35548,  8, }, // Asia/Kamchatka
    {  106, 4258,   35556,  6, }, // Asia/Karachi
    {  106, 1187,    6367,  8, }, // Asia/Kathmandu
    {  106, 8679,   35562,  7, }, // Asia/Khandyga
    {  106,  994,     718,  7, }, // Asia/Kolkata
    {  106, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  106, 5566,    8378,  6, }, // Asia/Kuwait
    {  106, 1213,    8384,  5, }, // Asia/Macau
    {  106, 2556,   35580,  8, }, // Asia/Nicosia
    {  106, 8693,   35588, 12, }, // Asia/Novokuznetsk
    {  106, 4233,   35600,  9, }, // Asia/Pyongyang
    {  106, 5578,    4972,  5, }, // Asia/Qatar
    {  106, 8726,     730,  8, }, // Asia/Qostanay
    {  106, 4288,    8431,  9, }, // Asia/Qyzylorda
    {  106, 3603,   35609,  5, }, // Asia/Riyadh
    {  106, 4427,   35614,  7, }, // Asia/Sakhalin
    {  106, 3298,    8451,  4, }, // Asia/Seoul
    {  106, 1055,   35621,  6, }, // Asia/Shanghai
    {  106, 3319,   21561,  8, }, // Asia/Singapore
    {  106, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {  106, 4800,   35627,  7, }, // Asia/Tashkent
    {  106, 2774,    8495,  7, }, // Asia/Tehran
    {  106, 2823,    4996,  5, }, // Asia/Tokyo
    {  106, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {  106, 1161,   35634,  6, }, // Asia/Urumqi
    {  106, 4847,    8526,  7, }, // Asia/Yakutsk
    {  106, 1237,    8533,  6, }, // Asia/Yangon
    {  106, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  106, 3766,   29247,  6, }, // Asia/Yerevan
    {  106, 3682,   35650,  5, }, // Atlantic/Azores
    {  106, 5690,   62330,  7, }, // Atlantic/Bermuda
    {  106, 6647,    5038,  6, }, // Atlantic/Canary
    {  106, 1397,   62337, 14, }, // Atlantic/Faroe
    {  106, 7272,   62351, 14, }, // Atlantic/South_Georgia
    {  106, 6840,   35664, 12, }, // Atlantic/St_Helena
    {  106, 6235,   35676,  6, }, // Europe/Andorra
    {  106, 3639,   35682,  8, }, // Europe/Astrakhan
    {  106, 2302,   29309,  5, }, // Europe/Athens
    {  106, 6355,    8713,  7, }, // Europe/Belgrade
    {  106, 2169,   62365,  9, }, // Europe/Brussels
    {  106, 3947,   35701,  8, }, // Europe/Bucharest
    {  106, 3825,   35709, 10, }, // Europe/Budapest
    {  106, 8790,     799,  8, }, // Europe/Busingen
    {  106, 2585,   35719,  8, }, // Europe/Chisinau
    {  106, 6308,    5115, 10, }, // Europe/Copenhagen
    {  106, 8822,   62374,  8, }, // Europe/Isle_of_Man
    {  106, 3998,   35749, 12, }, // Europe/Kaliningrad
    {  106, 2529,   35761,  5, }, // Europe/Kyiv
    {  106, 3232,   35766,  7, }, // Europe/Lisbon
    {  106, 6384,    8825, 10, }, // Europe/Luxembourg
    {  106, 6429,    8840,  6, }, // Europe/Monaco
    {  106, 3556,   23539,  6, }, // Europe/Moscow
    {  106, 4303,   35773,  5, }, // Europe/Paris
    {  106, 6294,    6716,  4, }, // Europe/Prague
    {  106, 6343,   35778,  3, }, // Europe/Rome
    {  106, 8880,   35781, 11, }, // Europe/Simferopol
    {  106, 6402,   35792,  7, }, // Europe/Skopje
    {  106, 6618,   35799,  6, }, // Europe/Sofia
    {  106, 6221,     819,  6, }, // Europe/Tirane
    {  106, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {  106, 6586,    6744,  7, }, // Europe/Vatican
    {  106, 6250,   35813,  3, }, // Europe/Vienna
    {  106, 3209,   35816,  7, }, // Europe/Warsaw
    {  106, 6559,    5217,  6, }, // Europe/Zurich
    {  106, 5048,    4421,  7, }, // Indian/Comoro
    {  106, 7260,     896,  4, }, // Indian/Mahe
    {  106, 7069,   35857,  7, }, // Indian/Maldives
    {  106, 4088,   35864, 10, }, // Indian/Mauritius
    {  106, 7211,     900,  7, }, // Indian/Reunion
    {  106, 3176,     922,  5, }, // Pacific/Chuuk
    {  106, 3921,   35874,  5, }, // Pacific/Fiji
    {  106, 6697,     940,  9, }, // Pacific/Galapagos
    {  106, 2725,    5251,  8, }, // Pacific/Honolulu
    {  106, 3068,     957,  6, }, // Pacific/Kanton
    {  106, 4070,   62382, 18, }, // Pacific/Marquesas
    {  106, 7117,    1028,  6, }, // Pacific/Noumea
    {  106, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  106, 7405,    1068, 15, }, // Pacific/Wallis
    {  108, 6807,   62400,  7, }, // Africa/Abidjan Czech/Latin/Czechia
    {  108, 5078,    4428, 11, }, // Africa/Addis_Ababa
    {  108, 7420,   62407,  5, }, // Africa/Algiers
    {  108,   14,       0,  6, }, // Africa/Asmara
    {  108, 2322,   62412,  6, }, // Africa/Cairo
    {  108, 5062,   35324,  7, }, // Africa/Djibouti
    {  108, 5185,       6,  8, }, // Africa/El_Aaiun
    {  108, 4543,   62418,  7, }, // Africa/Khartoum
    {  108, 6888,      14,  4, }, // Africa/Lome
    {  108, 5132,   62425,  8, }, // Africa/Mogadishu
    {  108, 5290,   62433,  8, }, // Africa/Ndjamena
    {  108, 6822,   62441,  8, }, // Africa/Nouakchott
    {  108, 4454,   62449, 11, }, // Africa/Sao_Tome
    {  108, 2868,   62460,  8, }, // Africa/Tripoli
    {  108, 4573,      35,  9, }, // America/Araguaina
    {  108,  270,      44,  7, }, // America/Argentina/Cordoba
    {  108, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  108, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  108, 4271,      70,  8, }, // America/Asuncion
    {  108,  237,      78,  8, }, // America/Atikokan
    {  108, 3698,      86,  5, }, // America/Bahia
    {  108, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  108, 7646,     103,  5, }, // America/Belem
    {  108, 4380,     108,  6, }, // America/Bogota
    {  108, 3887,     114,  6, }, // America/Cancun
    {  108, 5515,   62468, 17, }, // America/Cayman
    {  108, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  108, 5441,   35358,  9, }, // America/Costa_Rica
    {  108, 3810,     133,  6, }, // America/Cuiaba
    {  108, 5742,     139,  7, }, // America/Curacao
    {  108, 5758,   22339,  8, }, // America/Dominica
    {  108, 7887,     146,  8, }, // America/Eirunepe
    {  108, 5460,    7459,  8, }, // America/El_Salvador
    {  108,  481,     154, 13, }, // America/Indiana/Knox
    {  108, 7979,     167, 16, }, // America/Indiana/Marengo
    {  108, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  108, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  108, 8056,     220, 14, }, // America/Indiana/Vevay
    {  108, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  108, 8104,     252, 16, }, // America/Indiana/Winamac
    {  108, 2801,   35385,  7, }, // America/Jamaica
    {  108, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  108, 5951,     288, 22, }, // America/Lower_Princes
    {  108, 8171,     310,  6, }, // America/Maceio
    {  108, 5824,    5923,  8, }, // America/Martinique
    {  108, 2919,     316,  8, }, // America/Mazatlan
    {  108, 8238,    7779,  6, }, // America/Merida
    {  108, 2951,    4381, 16, }, // America/Mexico_City
    {  108, 4410,     341, 12, }, // America/Miquelon
    {  108, 1852,     353, 19, }, // America/Noronha
    {  108, 8319,   62485, 22, }, // America/North_Dakota/Beulah
    {  108, 8347,   62507, 22, }, // America/North_Dakota/Center
    {  108, 8375,   62529, 25, }, // America/North_Dakota/New_Salem
    {  108,  393,     435,  4, }, // America/Nuuk
    {  108, 5862,   35464,  9, }, // America/Puerto_Rico
    {  108, 8495,     439,  8, }, // America/Santarem
    {  108, 1880,     447,  9, }, // America/Sao_Paulo
    {  108, 6918,     456, 16, }, // America/Scoresbysund
    {  108, 8526,   62554, 16, }, // America/St_Barthelemy
    {  108, 2063,     486, 10, }, // America/St_Johns
    {  108, 5882,   62570, 13, }, // America/St_Kitts
    {  108, 5899,   62583, 11, }, // America/St_Lucia
    {  108,  855,   62594, 21, }, // America/St_Thomas
    {  108, 5932,   62615, 13, }, // America/St_Vincent
    {  108, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  108, 7295,     643,  5, }, // Antarctica/Syowa
    {  108, 3987,   62628,  5, }, // Asia/Amman
    {  108, 5542,     683,  5, }, // Asia/Aqtau
    {  108, 5387,    8259,  6, }, // Asia/Aqtobe
    {  108,  966,   62633,  8, }, // Asia/Ashgabat
    {  108, 3626,   62641,  6, }, // Asia/Baghdad
    {  108, 5553,   62647,  7, }, // Asia/Bahrain
    {  108, 4105,   62654,  6, }, // Asia/Beirut
    {  108, 3797,   35493,  6, }, // Asia/Bishkek
    {  108, 6008,   35499,  6, }, // Asia/Brunei
    {  108, 4620,   62326,  4, }, // Asia/Chita
    {  108, 4530,    6295,  7, }, // Asia/Colombo
    {  108, 4559,   62660,  7, }, // Asia/Damascus
    {  108, 1095,   62667,  5, }, // Asia/Dhaka
    {  108, 3615,   62672,  5, }, // Asia/Dubai
    {  108, 6178,   35506,  7, }, // Asia/Dushanbe
    {  108, 1261,   62677, 18, }, // Asia/Ho_Chi_Minh
    {  108, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  108, 4790,     704,  5, }, // Asia/Hovd
    {  108, 1292,   62695,  9, }, // Asia/Jerusalem
    {  108, 3579,   62704,  5, }, // Asia/Kabul
    {  108, 4335,   35548,  8, }, // Asia/Kamchatka
    {  108, 4258,   62709,  6, }, // Asia/Karachi
    {  108, 1187,   62715,  9, }, // Asia/Kathmandu
    {  108, 8679,   62724,  8, }, // Asia/Khandyga
    {  108,  994,   62732,  7, }, // Asia/Kolkata
    {  108, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  108, 5995,   35569,  6, }, // Asia/Kuching
    {  108, 5566,    8378,  6, }, // Asia/Kuwait
    {  108, 1213,     725,  5, }, // Asia/Macau
    {  108, 6939,   29197,  6, }, // Asia/Muscat
    {  108, 2556,   62739,  7, }, // Asia/Nicosia
    {  108, 8693,   62746, 11, }, // Asia/Novokuznetsk
    {  108, 7145,   62757,  6, }, // Asia/Oral
    {  108, 6980,   62763,  9, }, // Asia/Phnom_Penh
    {  108, 4233,   62772, 11, }, // Asia/Pyongyang
    {  108, 5578,    4972,  5, }, // Asia/Qatar
    {  108, 8726,    8423,  8, }, // Asia/Qostanay
    {  108, 4288,     738,  9, }, // Asia/Qyzylorda
    {  108, 3603,   62783,  5, }, // Asia/Riyadh
    {  108, 4427,   62788,  8, }, // Asia/Sakhalin
    {  108, 3298,   62796,  4, }, // Asia/Seoul
    {  108, 1055,   62800,  7, }, // Asia/Shanghai
    {  108, 3319,   21561,  8, }, // Asia/Singapore
    {  108, 4316,   62807, 13, }, // Asia/Srednekolymsk
    {  108, 3282,   62820,  9, }, // Asia/Taipei
    {  108, 4800,   35627,  7, }, // Asia/Tashkent
    {  108, 2774,   62829,  7, }, // Asia/Tehran
    {  108, 1319,   62836,  6, }, // Asia/Thimphu
    {  108, 2823,    4996,  5, }, // Asia/Tokyo
    {  108, 1023,   62842,  9, }, // Asia/Ulaanbaatar
    {  108, 1161,   35634,  6, }, // Asia/Urumqi
    {  108, 4847,    8526,  7, }, // Asia/Yakutsk
    {  108, 1237,   21598,  6, }, // Asia/Yangon
    {  108, 3902,   62851, 13, }, // Asia/Yekaterinburg
    {  108, 3766,    8551,  7, }, // Asia/Yerevan
    {  108, 3682,   62864, 15, }, // Atlantic/Azores
    {  108, 5690,   62879,  7, }, // Atlantic/Bermuda
    {  108, 6647,   62886, 16, }, // Atlantic/Canary
    {  108, 3746,   62902,  8, }, // Atlantic/Cape_Verde
    {  108, 1397,   62910, 15, }, // Atlantic/Faroe
    {  108, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {  108, 7272,   62925, 13, }, // Atlantic/South_Georgia
    {  108, 6840,   62938, 12, }, // Atlantic/St_Helena
    {  108, 3639,   62950,  9, }, // Europe/Astrakhan
    {  108, 2302,   62959,  6, }, // Europe/Athens
    {  108, 6355,   62965,  8, }, // Europe/Belgrade
    {  108, 4776,   21712,  6, }, // Europe/Berlin
    {  108, 2169,   29322,  6, }, // Europe/Brussels
    {  108, 3947,   62973,  8, }, // Europe/Bucharest
    {  108, 3825,   62981,  8, }, // Europe/Budapest
    {  108, 8790,     799,  8, }, // Europe/Busingen
    {  108, 2585,   62989,  7, }, // Europe/Chisinau
    {  108, 6308,   62996,  5, }, // Europe/Copenhagen
    {  108, 6631,   63001,  8, }, // Europe/Helsinki
    {  108, 8822,   63009, 10, }, // Europe/Isle_of_Man
    {  108, 2529,   63019,  5, }, // Europe/Kyiv
    {  108, 3232,   35766,  7, }, // Europe/Lisbon
    {  108, 6525,   63024,  6, }, // Europe/Ljubljana
    {  108, 2503,   63030,  6, }, // Europe/London
    {  108, 6384,   63036,  9, }, // Europe/Luxembourg
    {  108, 6429,    8840,  6, }, // Europe/Monaco
    {  108, 3556,   23539,  6, }, // Europe/Moscow
    {  108, 4303,   63045,  5, }, // Europe/Paris
    {  108, 6294,   38246,  5, }, // Europe/Prague
    {  108, 6343,   63050,  3, }, // Europe/Rome
    {  108, 6618,   63053,  5, }, // Europe/Sofia
    {  108, 6221,     819,  6, }, // Europe/Tirane
    {  108, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {  108, 6586,   63058,  7, }, // Europe/Vatican
    {  108, 6250,   63065,  5, }, // Europe/Vienna
    {  108, 3209,   35816,  7, }, // Europe/Warsaw
    {  108, 6280,   63070,  6, }, // Europe/Zagreb
    {  108, 6559,   63076,  6, }, // Europe/Zurich
    {  108, 6065,   63082, 14, }, // Indian/Christmas
    {  108, 6082,   63096, 16, }, // Indian/Cocos
    {  108, 5048,   63112,  6, }, // Indian/Comoro
    {  108, 6680,   63118, 20, }, // Indian/Kerguelen
    {  108, 7260,     896,  4, }, // Indian/Mahe
    {  108, 7069,   63138,  8, }, // Indian/Maldives
    {  108, 4088,   63146,  9, }, // Indian/Mauritius
    {  108, 7211,     900,  7, }, // Indian/Reunion
    {  108, 3034,   63155, 18, }, // Pacific/Chatham
    {  108, 3176,   63173, 16, }, // Pacific/Chuuk
    {  108, 2239,   63189, 18, }, // Pacific/Easter
    {  108, 7360,   29436,  5, }, // Pacific/Efate
    {  108, 3921,   35874,  5, }, // Pacific/Fiji
    {  108, 6697,   63207,  8, }, // Pacific/Galapagos
    {  108, 6715,   63215, 18, }, // Pacific/Gambier
    {  108, 2725,    5251,  8, }, // Pacific/Honolulu
    {  108, 3068,   63233, 15, }, // Pacific/Kanton
    {  108, 4070,   63248,  7, }, // Pacific/Marquesas
    {  108, 7117,    1028,  6, }, // Pacific/Noumea
    {  108, 7194,   63255, 19, }, // Pacific/Pitcairn
    {  108, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  108, 7405,    1068, 15, }, // Pacific/Wallis
    {  109, 5078,    4428, 11, }, // Africa/Addis_Ababa Danish/Latin/Denmark
    {  109, 7420,   63274,  6, }, // Africa/Algiers
    {  109,   14,       0,  6, }, // Africa/Asmara
    {  109, 5185,       6,  8, }, // Africa/El_Aaiun
    {  109, 6888,      14,  4, }, // Africa/Lome
    {  109, 5290,      18,  9, }, // Africa/Ndjamena
    {  109, 4454,      27,  8, }, // Africa/Sao_Tome
    {  109, 4573,      35,  9, }, // America/Araguaina
    {  109,  270,      44,  7, }, // America/Argentina/Cordoba
    {  109, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  109, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  109, 4271,      70,  8, }, // America/Asuncion
    {  109,  237,      78,  8, }, // America/Atikokan
    {  109, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  109, 7646,     103,  5, }, // America/Belem
    {  109, 4380,     108,  6, }, // America/Bogota
    {  109, 3887,   35352,  6, }, // America/Cancun
    {  109, 5515,   63280, 11, }, // America/Cayman
    {  109, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  109, 3810,     133,  6, }, // America/Cuiaba
    {  109, 5742,     139,  7, }, // America/Curacao
    {  109, 7887,     146,  8, }, // America/Eirunepe
    {  109,  481,     154, 13, }, // America/Indiana/Knox
    {  109, 7979,     167, 16, }, // America/Indiana/Marengo
    {  109, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  109, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  109, 8056,     220, 14, }, // America/Indiana/Vevay
    {  109, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  109, 8104,     252, 16, }, // America/Indiana/Winamac
    {  109, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  109, 5951,     288, 22, }, // America/Lower_Princes
    {  109, 8171,     310,  6, }, // America/Maceio
    {  109, 2919,     316,  8, }, // America/Mazatlan
    {  109, 8238,    7779,  6, }, // America/Merida
    {  109, 2951,    4381, 16, }, // America/Mexico_City
    {  109, 4410,     341, 12, }, // America/Miquelon
    {  109, 1852,     353, 19, }, // America/Noronha
    {  109, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  109, 8347,     392, 20, }, // America/North_Dakota/Center
    {  109, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  109,  393,     435,  4, }, // America/Nuuk
    {  109, 8495,     439,  8, }, // America/Santarem
    {  109, 1880,     447,  9, }, // America/Sao_Paulo
    {  109, 6918,     456, 16, }, // America/Scoresbysund
    {  109, 8526,   29041, 16, }, // America/St_Barthelemy
    {  109, 2063,     486, 10, }, // America/St_Johns
    {  109, 5882,     496,  9, }, // America/St_Kitts
    {  109, 5899,     505,  9, }, // America/St_Lucia
    {  109,  855,     514, 10, }, // America/St_Thomas
    {  109, 5932,     524, 11, }, // America/St_Vincent
    {  109, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  109, 7295,     643,  5, }, // Antarctica/Syowa
    {  109, 5542,     683,  5, }, // Asia/Aqtau
    {  109, 5387,    8259,  6, }, // Asia/Aqtobe
    {  109,  966,   63291,  9, }, // Asia/Ashgabat
    {  109, 3626,    4802,  6, }, // Asia/Baghdad
    {  109, 3797,    4827,  7, }, // Asia/Bishkek
    {  109, 4559,    4841,  8, }, // Asia/Damascus
    {  109, 6178,   63300,  8, }, // Asia/Dushanbe
    {  109, 1261,     688, 16, }, // Asia/Ho_Chi_Minh
    {  109, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  109, 4790,     704,  5, }, // Asia/Hovd
    {  109, 4335,   63308,  9, }, // Asia/Kamchatka
    {  109, 1187,    6367,  8, }, // Asia/Kathmandu
    {  109,  994,     718,  7, }, // Asia/Kolkata
    {  109, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  109, 1213,     725,  5, }, // Asia/Macau
    {  109, 8693,   63317, 12, }, // Asia/Novokuznetsk
    {  109, 8726,     730,  8, }, // Asia/Qostanay
    {  109, 4288,     738,  9, }, // Asia/Qyzylorda
    {  109, 4800,   63329,  8, }, // Asia/Tashkent
    {  109, 2774,    8495,  7, }, // Asia/Tehran
    {  109, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {  109, 1161,     747,  6, }, // Asia/Urumqi
    {  109, 4847,    8526,  7, }, // Asia/Yakutsk
    {  109, 1237,   63337,  7, }, // Asia/Yangon
    {  109, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  109, 3766,    8551,  7, }, // Asia/Yerevan
    {  109, 3682,   63344,  8, }, // Atlantic/Azores
    {  109, 6647,   63352, 16, }, // Atlantic/Canary
    {  109, 3746,   58569,  9, }, // Atlantic/Cape_Verde
    {  109, 1397,   63368,  8, }, // Atlantic/Faroe
    {  109, 6840,     773, 10, }, // Atlantic/St_Helena
    {  109, 2302,    5078,  5, }, // Europe/Athens
    {  109, 6355,    8713,  7, }, // Europe/Belgrade
    {  109, 2169,   62365,  9, }, // Europe/Brussels
    {  109, 3947,   29329,  8, }, // Europe/Bucharest
    {  109, 8790,     799,  8, }, // Europe/Busingen
    {  109, 2585,     807,  8, }, // Europe/Chisinau
    {  109, 6308,   63376,  9, }, // Europe/Copenhagen
    {  109, 2529,    8801,  4, }, // Europe/Kyiv
    {  109, 3232,    5139,  8, }, // Europe/Lisbon
    {  109, 3556,   23539,  6, }, // Europe/Moscow
    {  109, 6294,    6716,  4, }, // Europe/Prague
    {  109, 6343,    8869,  3, }, // Europe/Rome
    {  109, 6221,     819,  6, }, // Europe/Tirane
    {  109, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {  109, 6586,   63385,  9, }, // Europe/Vatican
    {  109, 6250,   58704,  4, }, // Europe/Vienna
    {  109, 3209,   63394,  8, }, // Europe/Warsaw
    {  109, 6559,    5217,  6, }, // Europe/Zurich
    {  109, 6065,   63402,  7, }, // Indian/Christmas
    {  109, 5048,   63409,  9, }, // Indian/Comoro
    {  109, 7260,     896,  4, }, // Indian/Mahe
    {  109, 7069,   63418, 10, }, // Indian/Maldives
    {  109, 7211,     900,  7, }, // Indian/Reunion
    {  109, 3176,     922,  5, }, // Pacific/Chuuk
    {  109, 2239,   63428,  8, }, // Pacific/Easter
    {  109, 6697,     940,  9, }, // Pacific/Galapagos
    {  109, 2725,    5251,  8, }, // Pacific/Honolulu
    {  109, 3068,     957, 13, }, // Pacific/Kanton
    {  109, 7117,    1028,  6, }, // Pacific/Noumea
    {  109, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  109, 7405,    1068, 15, }, // Pacific/Wallis
    {  111,   14,       0,  6, }, // Africa/Asmara Divehi/Thaana/Maldives
    {  111, 5185,       6,  8, }, // Africa/El_Aaiun
    {  111, 6888,      14,  4, }, // Africa/Lome
    {  111, 5290,      18,  9, }, // Africa/Ndjamena
    {  111, 4454,      27,  8, }, // Africa/Sao_Tome
    {  111, 4573,      35,  9, }, // America/Araguaina
    {  111,  270,      44,  7, }, // America/Argentina/Cordoba
    {  111, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  111, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  111, 4271,      70,  8, }, // America/Asuncion
    {  111,  237,      78,  8, }, // America/Atikokan
    {  111, 7623,      86, 17, }, // America/Bahia_Banderas
    {  111, 7646,     103,  5, }, // America/Belem
    {  111, 4380,     108,  6, }, // America/Bogota
    {  111, 3887,     114,  6, }, // America/Cancun
    {  111, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  111, 3810,     133,  6, }, // America/Cuiaba
    {  111, 5742,     139,  7, }, // America/Curacao
    {  111, 7887,     146,  8, }, // America/Eirunepe
    {  111,  481,     154, 13, }, // America/Indiana/Knox
    {  111, 7979,     167, 16, }, // America/Indiana/Marengo
    {  111, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  111, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  111, 8056,     220, 14, }, // America/Indiana/Vevay
    {  111, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  111, 8104,     252, 16, }, // America/Indiana/Winamac
    {  111, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  111, 5951,     288, 22, }, // America/Lower_Princes
    {  111, 8171,     310,  6, }, // America/Maceio
    {  111, 2919,     316,  8, }, // America/Mazatlan
    {  111, 8238,     324,  6, }, // America/Merida
    {  111, 2951,    4381, 16, }, // America/Mexico_City
    {  111, 4410,     341, 12, }, // America/Miquelon
    {  111, 1852,     353, 19, }, // America/Noronha
    {  111, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  111, 8347,     392, 20, }, // America/North_Dakota/Center
    {  111, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  111,  393,     435,  4, }, // America/Nuuk
    {  111, 8495,     439,  8, }, // America/Santarem
    {  111, 1880,     447,  9, }, // America/Sao_Paulo
    {  111, 6918,     456, 16, }, // America/Scoresbysund
    {  111, 8526,     472, 14, }, // America/St_Barthelemy
    {  111, 2063,     486, 10, }, // America/St_Johns
    {  111, 5882,     496,  9, }, // America/St_Kitts
    {  111, 5899,     505,  9, }, // America/St_Lucia
    {  111,  855,     514, 10, }, // America/St_Thomas
    {  111, 5932,     524, 11, }, // America/St_Vincent
    {  111, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  111, 7295,     643,  5, }, // Antarctica/Syowa
    {  111, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  111, 4790,     704,  5, }, // Asia/Hovd
    {  111, 1187,     709,  9, }, // Asia/Kathmandu
    {  111,  994,     718,  7, }, // Asia/Kolkata
    {  111, 1213,     725,  5, }, // Asia/Macau
    {  111, 1161,     747,  6, }, // Asia/Urumqi
    {  111, 1237,     753,  6, }, // Asia/Yangon
    {  111, 6647,    4413,  8, }, // Atlantic/Canary
    {  111, 1397,     767,  5, }, // Atlantic/Faroe
    {  111, 6840,     773, 10, }, // Atlantic/St_Helena
    {  111, 8790,     799,  8, }, // Europe/Busingen
    {  111, 2585,     807,  8, }, // Europe/Chisinau
    {  111, 2529,     815,  4, }, // Europe/Kyiv
    {  111, 6221,     819,  6, }, // Europe/Tirane
    {  111, 5048,    4421,  7, }, // Indian/Comoro
    {  111, 7260,     896,  4, }, // Indian/Mahe
    {  111, 7211,     900,  7, }, // Indian/Reunion
    {  111, 3176,     922,  5, }, // Pacific/Chuuk
    {  111, 6697,     940,  9, }, // Pacific/Galapagos
    {  111, 3068,     957,  6, }, // Pacific/Kanton
    {  111, 7117,    1028,  6, }, // Pacific/Noumea
    {  111, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  111, 7405,    1068, 15, }, // Pacific/Wallis
    {  112,   14,       0,  6, }, // Africa/Asmara Dogri/Devanagari/India
    {  112, 5185,       6,  8, }, // Africa/El_Aaiun
    {  112, 6888,      14,  4, }, // Africa/Lome
    {  112, 5290,      18,  9, }, // Africa/Ndjamena
    {  112, 4454,      27,  8, }, // Africa/Sao_Tome
    {  112, 4573,      35,  9, }, // America/Araguaina
    {  112,  270,      44,  7, }, // America/Argentina/Cordoba
    {  112, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  112, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  112, 4271,      70,  8, }, // America/Asuncion
    {  112,  237,      78,  8, }, // America/Atikokan
    {  112, 7623,      86, 17, }, // America/Bahia_Banderas
    {  112, 7646,     103,  5, }, // America/Belem
    {  112, 4380,     108,  6, }, // America/Bogota
    {  112, 3887,     114,  6, }, // America/Cancun
    {  112, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  112, 3810,     133,  6, }, // America/Cuiaba
    {  112, 5742,     139,  7, }, // America/Curacao
    {  112, 7887,     146,  8, }, // America/Eirunepe
    {  112,  481,     154, 13, }, // America/Indiana/Knox
    {  112, 7979,     167, 16, }, // America/Indiana/Marengo
    {  112, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  112, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  112, 8056,     220, 14, }, // America/Indiana/Vevay
    {  112, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  112, 8104,     252, 16, }, // America/Indiana/Winamac
    {  112, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  112, 5951,     288, 22, }, // America/Lower_Princes
    {  112, 8171,     310,  6, }, // America/Maceio
    {  112, 2919,     316,  8, }, // America/Mazatlan
    {  112, 8238,     324,  6, }, // America/Merida
    {  112, 2951,    4381, 16, }, // America/Mexico_City
    {  112, 4410,     341, 12, }, // America/Miquelon
    {  112, 1852,     353, 19, }, // America/Noronha
    {  112, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  112, 8347,     392, 20, }, // America/North_Dakota/Center
    {  112, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  112,  393,     435,  4, }, // America/Nuuk
    {  112, 8495,     439,  8, }, // America/Santarem
    {  112, 1880,     447,  9, }, // America/Sao_Paulo
    {  112, 6918,     456, 16, }, // America/Scoresbysund
    {  112, 8526,     472, 14, }, // America/St_Barthelemy
    {  112, 2063,     486, 10, }, // America/St_Johns
    {  112, 5882,     496,  9, }, // America/St_Kitts
    {  112, 5899,     505,  9, }, // America/St_Lucia
    {  112,  855,     514, 10, }, // America/St_Thomas
    {  112, 5932,     524, 11, }, // America/St_Vincent
    {  112, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  112, 7295,     643,  5, }, // Antarctica/Syowa
    {  112, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  112, 4790,     704,  5, }, // Asia/Hovd
    {  112, 1187,     709,  9, }, // Asia/Kathmandu
    {  112,  994,     718,  7, }, // Asia/Kolkata
    {  112, 1213,     725,  5, }, // Asia/Macau
    {  112, 1161,     747,  6, }, // Asia/Urumqi
    {  112, 1237,     753,  6, }, // Asia/Yangon
    {  112, 6647,    4413,  8, }, // Atlantic/Canary
    {  112, 1397,     767,  5, }, // Atlantic/Faroe
    {  112, 6840,     773, 10, }, // Atlantic/St_Helena
    {  112, 8790,     799,  8, }, // Europe/Busingen
    {  112, 2585,     807,  8, }, // Europe/Chisinau
    {  112, 2529,     815,  4, }, // Europe/Kyiv
    {  112, 6221,     819,  6, }, // Europe/Tirane
    {  112, 5048,    4421,  7, }, // Indian/Comoro
    {  112, 7260,     896,  4, }, // Indian/Mahe
    {  112, 7211,     900,  7, }, // Indian/Reunion
    {  112, 3176,     922,  5, }, // Pacific/Chuuk
    {  112, 6697,     940,  9, }, // Pacific/Galapagos
    {  112, 3068,     957,  6, }, // Pacific/Kanton
    {  112, 7117,    1028,  6, }, // Pacific/Noumea
    {  112, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  112, 7405,    1068, 15, }, // Pacific/Wallis
    {  113,   14,       0,  6, }, // Africa/Asmara Duala/Latin/Cameroon
    {  113, 5185,       6,  8, }, // Africa/El_Aaiun
    {  113, 6888,      14,  4, }, // Africa/Lome
    {  113, 5290,      18,  9, }, // Africa/Ndjamena
    {  113, 4454,      27,  8, }, // Africa/Sao_Tome
    {  113, 4573,      35,  9, }, // America/Araguaina
    {  113,  270,      44,  7, }, // America/Argentina/Cordoba
    {  113, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  113, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  113, 4271,      70,  8, }, // America/Asuncion
    {  113,  237,      78,  8, }, // America/Atikokan
    {  113, 7623,      86, 17, }, // America/Bahia_Banderas
    {  113, 7646,     103,  5, }, // America/Belem
    {  113, 4380,     108,  6, }, // America/Bogota
    {  113, 3887,     114,  6, }, // America/Cancun
    {  113, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  113, 3810,     133,  6, }, // America/Cuiaba
    {  113, 5742,     139,  7, }, // America/Curacao
    {  113, 7887,     146,  8, }, // America/Eirunepe
    {  113,  481,     154, 13, }, // America/Indiana/Knox
    {  113, 7979,     167, 16, }, // America/Indiana/Marengo
    {  113, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  113, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  113, 8056,     220, 14, }, // America/Indiana/Vevay
    {  113, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  113, 8104,     252, 16, }, // America/Indiana/Winamac
    {  113, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  113, 5951,     288, 22, }, // America/Lower_Princes
    {  113, 8171,     310,  6, }, // America/Maceio
    {  113, 2919,     316,  8, }, // America/Mazatlan
    {  113, 8238,     324,  6, }, // America/Merida
    {  113, 2951,    4381, 16, }, // America/Mexico_City
    {  113, 4410,     341, 12, }, // America/Miquelon
    {  113, 1852,     353, 19, }, // America/Noronha
    {  113, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  113, 8347,     392, 20, }, // America/North_Dakota/Center
    {  113, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  113,  393,     435,  4, }, // America/Nuuk
    {  113, 8495,     439,  8, }, // America/Santarem
    {  113, 1880,     447,  9, }, // America/Sao_Paulo
    {  113, 6918,     456, 16, }, // America/Scoresbysund
    {  113, 8526,     472, 14, }, // America/St_Barthelemy
    {  113, 2063,     486, 10, }, // America/St_Johns
    {  113, 5882,     496,  9, }, // America/St_Kitts
    {  113, 5899,     505,  9, }, // America/St_Lucia
    {  113,  855,     514, 10, }, // America/St_Thomas
    {  113, 5932,     524, 11, }, // America/St_Vincent
    {  113, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  113, 7295,     643,  5, }, // Antarctica/Syowa
    {  113, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  113, 4790,     704,  5, }, // Asia/Hovd
    {  113, 1187,     709,  9, }, // Asia/Kathmandu
    {  113,  994,     718,  7, }, // Asia/Kolkata
    {  113, 1213,     725,  5, }, // Asia/Macau
    {  113, 1161,     747,  6, }, // Asia/Urumqi
    {  113, 1237,     753,  6, }, // Asia/Yangon
    {  113, 6647,    4413,  8, }, // Atlantic/Canary
    {  113, 1397,     767,  5, }, // Atlantic/Faroe
    {  113, 6840,     773, 10, }, // Atlantic/St_Helena
    {  113, 8790,     799,  8, }, // Europe/Busingen
    {  113, 2585,     807,  8, }, // Europe/Chisinau
    {  113, 2529,     815,  4, }, // Europe/Kyiv
    {  113, 6221,     819,  6, }, // Europe/Tirane
    {  113, 5048,    4421,  7, }, // Indian/Comoro
    {  113, 7260,     896,  4, }, // Indian/Mahe
    {  113, 7211,     900,  7, }, // Indian/Reunion
    {  113, 3176,     922,  5, }, // Pacific/Chuuk
    {  113, 6697,     940,  9, }, // Pacific/Galapagos
    {  113, 3068,     957,  6, }, // Pacific/Kanton
    {  113, 7117,    1028,  6, }, // Pacific/Noumea
    {  113, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  113, 7405,    1068, 15, }, // Pacific/Wallis
    {  114, 5078,    4428, 11, }, // Africa/Addis_Ababa Dutch/Latin/Netherlands
    {  114,   14,       0,  6, }, // Africa/Asmara
    {  114, 2322,   63436,  5, }, // Africa/Cairo
    {  114, 5185,       6,  8, }, // Africa/El_Aaiun
    {  114, 4543,   63441,  8, }, // Africa/Khartoum
    {  114, 6888,      14,  4, }, // Africa/Lome
    {  114, 5290,      18,  9, }, // Africa/Ndjamena
    {  114, 4454,   63449,  8, }, // Africa/Sao_Tome
    {  114, 4573,      35,  9, }, // America/Araguaina
    {  114,  270,      44,  7, }, // America/Argentina/Cordoba
    {  114, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  114, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  114, 4271,      70,  8, }, // America/Asuncion
    {  114,  237,      78,  8, }, // America/Atikokan
    {  114, 7623,      86, 17, }, // America/Bahia_Banderas
    {  114, 7646,     103,  5, }, // America/Belem
    {  114, 4380,     108,  6, }, // America/Bogota
    {  114, 3887,   35352,  6, }, // America/Cancun
    {  114, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  114, 3810,     133,  6, }, // America/Cuiaba
    {  114, 5742,     139,  7, }, // America/Curacao
    {  114, 7887,     146,  8, }, // America/Eirunepe
    {  114,  481,     154, 13, }, // America/Indiana/Knox
    {  114, 7979,     167, 16, }, // America/Indiana/Marengo
    {  114, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  114, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  114, 8056,     220, 14, }, // America/Indiana/Vevay
    {  114, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  114, 8104,     252, 16, }, // America/Indiana/Winamac
    {  114, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  114, 5951,   63457, 24, }, // America/Lower_Princes
    {  114, 8171,     310,  6, }, // America/Maceio
    {  114, 2919,     316,  8, }, // America/Mazatlan
    {  114, 8238,     324,  6, }, // America/Merida
    {  114, 2951,   63481, 11, }, // America/Mexico_City
    {  114, 4410,     341, 12, }, // America/Miquelon
    {  114, 1852,     353, 19, }, // America/Noronha
    {  114, 8319,    4525, 20, }, // America/North_Dakota/Beulah
    {  114, 8347,    4545, 20, }, // America/North_Dakota/Center
    {  114, 8375,    4565, 23, }, // America/North_Dakota/New_Salem
    {  114,  393,     435,  4, }, // America/Nuuk
    {  114, 8495,     439,  8, }, // America/Santarem
    {  114, 1880,     447,  9, }, // America/Sao_Paulo
    {  114, 6918,     456, 16, }, // America/Scoresbysund
    {  114, 8526,   29041, 16, }, // America/St_Barthelemy
    {  114, 2063,   29057, 12, }, // America/St_Johns
    {  114, 5882,   29069, 11, }, // America/St_Kitts
    {  114, 5899,   37943, 11, }, // America/St_Lucia
    {  114,  855,   46153, 12, }, // America/St_Thomas
    {  114, 5932,   29103, 13, }, // America/St_Vincent
    {  114, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  114, 7295,     643,  5, }, // Antarctica/Syowa
    {  114, 5414,   63492,  8, }, // Asia/Almaty
    {  114, 5387,   58394,  6, }, // Asia/Aqtobe
    {  114,  966,    4793,  9, }, // Asia/Ashgabat
    {  114, 8642,   63500,  6, }, // Asia/Atyrau
    {  114, 3626,    4802,  6, }, // Asia/Baghdad
    {  114, 5553,    4808,  7, }, // Asia/Bahrain
    {  114, 3672,    4815,  5, }, // Asia/Baku
    {  114, 4105,    4820,  7, }, // Asia/Beirut
    {  114, 3797,    4827,  7, }, // Asia/Bishkek
    {  114, 6178,   63506,  9, }, // Asia/Dushanbe
    {  114, 1261,   63515, 15, }, // Asia/Ho_Chi_Minh
    {  114, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  114, 4790,     704,  5, }, // Asia/Hovd
    {  114, 4203,    4879,  8, }, // Asia/Irkutsk
    {  114, 1292,   35539,  9, }, // Asia/Jerusalem
    {  114, 4335,    4901, 10, }, // Asia/Kamchatka
    {  114, 1187,     709,  9, }, // Asia/Kathmandu
    {  114,  994,   63530,  8, }, // Asia/Kolkata
    {  114, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  114, 5566,    4954,  7, }, // Asia/Kuwait
    {  114, 1213,    4961,  5, }, // Asia/Macau
    {  114, 7182,   63538,  7, }, // Asia/Manila
    {  114, 3603,   21535,  5, }, // Asia/Riyadh
    {  114, 4427,   62788,  8, }, // Asia/Sakhalin
    {  114, 1055,   63545,  8, }, // Asia/Shanghai
    {  114, 4800,   63329,  8, }, // Asia/Tashkent
    {  114, 2774,    8495,  7, }, // Asia/Tehran
    {  114, 2823,    4996,  5, }, // Asia/Tokyo
    {  114, 1161,     747,  6, }, // Asia/Urumqi
    {  114, 4847,    5012,  8, }, // Asia/Yakutsk
    {  114, 1237,   63337,  7, }, // Asia/Yangon
    {  114, 3902,   63553, 15, }, // Asia/Yekaterinburg
    {  114, 3766,    8551,  7, }, // Asia/Yerevan
    {  114, 3682,   63568,  6, }, // Atlantic/Azores
    {  114, 6647,   63574, 19, }, // Atlantic/Canary
    {  114, 3746,   63593, 10, }, // Atlantic/Cape_Verde
    {  114, 1397,   63603,  7, }, // Atlantic/Faroe
    {  114, 7272,   63610, 12, }, // Atlantic/South_Georgia
    {  114, 6840,   63622, 11, }, // Atlantic/St_Helena
    {  114, 2302,    5078,  6, }, // Europe/Athens
    {  114, 6355,   63633,  8, }, // Europe/Belgrade
    {  114, 4776,   63641,  7, }, // Europe/Berlin
    {  114, 2169,    5090,  7, }, // Europe/Brussels
    {  114, 3947,    5097,  9, }, // Europe/Bucharest
    {  114, 3825,    5106,  9, }, // Europe/Budapest
    {  114, 8790,     799,  8, }, // Europe/Busingen
    {  114, 2585,     807,  8, }, // Europe/Chisinau
    {  114, 6308,    5115, 10, }, // Europe/Copenhagen
    {  114, 1132,   63648,  9, }, // Europe/Istanbul
    {  114, 2529,    8801,  4, }, // Europe/Kyiv
    {  114, 3232,    5139,  8, }, // Europe/Lisbon
    {  114, 2503,    5147,  6, }, // Europe/London
    {  114, 6384,    5153,  9, }, // Europe/Luxembourg
    {  114, 3556,    5162,  6, }, // Europe/Moscow
    {  114, 4303,   63657,  6, }, // Europe/Paris
    {  114, 6294,    5173,  5, }, // Europe/Prague
    {  114, 6221,     819,  6, }, // Europe/Tirane
    {  114, 6586,   63663, 12, }, // Europe/Vatican
    {  114, 6250,   63675,  5, }, // Europe/Vienna
    {  114, 4746,    5201,  9, }, // Europe/Volgograd
    {  114, 3209,   58717,  8, }, // Europe/Warsaw
    {  114, 6559,    5217,  6, }, // Europe/Zurich
    {  114, 6966,   63680, 14, }, // Indian/Chagos
    {  114, 6065,   63694, 15, }, // Indian/Christmas
    {  114, 6082,   63709, 13, }, // Indian/Cocos
    {  114, 5048,    4421,  7, }, // Indian/Comoro
    {  114, 7260,     896,  4, }, // Indian/Mahe
    {  114, 7069,   63722,  8, }, // Indian/Maldives
    {  114, 7211,     900,  7, }, // Indian/Reunion
    {  114, 3176,     922,  5, }, // Pacific/Chuuk
    {  114, 2239,    5236, 10, }, // Pacific/Easter
    {  114, 6697,     940,  9, }, // Pacific/Galapagos
    {  114, 6715,   63730, 12, }, // Pacific/Gambier
    {  114, 2725,    5251,  8, }, // Pacific/Honolulu
    {  114, 3068,    5259,  6, }, // Pacific/Kanton
    {  114, 4070,   63742, 17, }, // Pacific/Marquesas
    {  114, 7117,    1028,  6, }, // Pacific/Noumea
    {  114, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  114, 7405,    1068, 15, }, // Pacific/Wallis
    {  121, 6779,   63759,  6, }, // Africa/Accra Dzongkha/Tibetan/Bhutan
    {  121, 5078,   63765, 14, }, // Africa/Addis_Ababa
    {  121, 7420,   63779,  8, }, // Africa/Algiers
    {  121,   14,   63787,  7, }, // Africa/Asmara
    {  121,   44,   63794,  7, }, // Africa/Bamako
    {  121, 5276,   63801,  6, }, // Africa/Bangui
    {  121, 6765,   63807,  8, }, // Africa/Banjul
    {  121, 7435,   63815,  8, }, // Africa/Bissau
    {  121, 5306,   63823,  9, }, // Africa/Brazzaville
    {  121, 4941,   63832, 13, }, // Africa/Bujumbura
    {  121, 2322,   63845,  7, }, // Africa/Cairo
    {  121, 6792,   63852,  8, }, // Africa/Conakry
    {  121, 6859,   63860,  5, }, // Africa/Dakar
    {  121, 5062,   63865,  9, }, // Africa/Djibouti
    {  121, 5185,       6,  8, }, // Africa/El_Aaiun
    {  121, 4925,   63874, 12, }, // Africa/Gaborone
    {  121, 5034,   63886,  7, }, // Africa/Harare
    {  121, 5170,   63893,  7, }, // Africa/Kampala
    {  121, 4543,   63900,  7, }, // Africa/Khartoum
    {  121, 4992,   63907,  8, }, // Africa/Kigali
    {  121, 5325,   63915,  7, }, // Africa/Kinshasa
    {  121, 5355,   63922, 10, }, // Africa/Libreville
    {  121, 6888,   63932,  5, }, // Africa/Lome
    {  121, 5230,   63937,  8, }, // Africa/Luanda
    {  121, 5020,   63945,  7, }, // Africa/Lusaka
    {  121, 5341,   63952,  7, }, // Africa/Malabo
    {  121, 5006,   63959,  7, }, // Africa/Maputo
    {  121, 5216,   63966,  6, }, // Africa/Maseru
    {  121, 5201,   63972, 12, }, // Africa/Mbabane
    {  121, 5132,   63984, 11, }, // Africa/Mogadishu
    {  121, 7053,   63995, 11, }, // Africa/Monrovia
    {  121, 3872,   64006, 10, }, // Africa/Nairobi
    {  121, 5290,      18,  9, }, // Africa/Ndjamena
    {  121, 5373,   64016,  7, }, // Africa/Niamey
    {  121, 6822,   64023, 10, }, // Africa/Nouakchott
    {  121, 6746,   64033, 10, }, // Africa/Ouagadougou
    {  121, 4454,   64043,  9, }, // Africa/Sao_Tome
    {  121, 2868,   64052,  9, }, // Africa/Tripoli
    {  121, 6573,   64061,  7, }, // Africa/Tunis
    {  121, 4171,   64068,  8, }, // Africa/Windhoek
    {  121, 5643,   64076, 11, }, // America/Antigua
    {  121, 4573,      35,  9, }, // America/Araguaina
    {  121,  166,   64087, 18, }, // America/Argentina/Buenos_Aires
    {  121,  270,      44,  7, }, // America/Argentina/Cordoba
    {  121, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  121, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  121, 4271,   64105, 12, }, // America/Asuncion
    {  121,  237,   64117, 11, }, // America/Atikokan
    {  121, 7623,      86, 17, }, // America/Bahia_Banderas
    {  121, 5673,   64128, 10, }, // America/Barbados
    {  121, 7646,     103,  5, }, // America/Belem
    {  121, 5426,   64138,  7, }, // America/Belize
    {  121, 4380,   64145,  7, }, // America/Bogota
    {  121, 7713,   64152, 15, }, // America/Cambridge_Bay
    {  121, 3887,     114,  6, }, // America/Cancun
    {  121, 4713,   64167,  7, }, // America/Caracas
    {  121, 2262,   64174,  8, }, // America/Chicago
    {  121, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  121, 5441,   64182, 10, }, // America/Costa_Rica
    {  121, 3810,     133,  6, }, // America/Cuiaba
    {  121, 5742,     139,  7, }, // America/Curacao
    {  121, 7851,   64192,  8, }, // America/Dawson
    {  121, 7866,   64200, 15, }, // America/Dawson_Creek
    {  121, 5758,   64215, 10, }, // America/Dominica
    {  121,  893,   64225, 12, }, // America/Edmonton
    {  121, 7887,     146,  8, }, // America/Eirunepe
    {  121, 5460,   64237, 13, }, // America/El_Salvador
    {  121, 6900,   64250, 10, }, // America/Goose_Bay
    {  121, 3779,   64260,  9, }, // America/Guatemala
    {  121, 6951,   64269,  6, }, // America/Guyana
    {  121, 1941,   64275, 10, }, // America/Halifax
    {  121,  481,     154, 13, }, // America/Indiana/Knox
    {  121, 7979,     167, 16, }, // America/Indiana/Marengo
    {  121, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  121, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  121, 8056,     220, 14, }, // America/Indiana/Vevay
    {  121, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  121, 8104,     252, 16, }, // America/Indiana/Winamac
    {  121, 8128,   64285,  9, }, // America/Inuvik
    {  121, 2801,   64294,  8, }, // America/Jamaica
    {  121, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  121, 4395,   64302,  6, }, // America/La_Paz
    {  121, 7169,   64308,  4, }, // America/Lima
    {  121, 5951,     288, 22, }, // America/Lower_Princes
    {  121, 8171,     310,  6, }, // America/Maceio
    {  121, 2919,     316,  8, }, // America/Mazatlan
    {  121, 8238,     324,  6, }, // America/Merida
    {  121, 2951,   64312, 16, }, // America/Mexico_City
    {  121, 4410,     341, 12, }, // America/Miquelon
    {  121, 8272,   64328,  9, }, // America/Moncton
    {  121, 4117,   64337, 15, }, // America/Montevideo
    {  121, 5500,   64352,  5, }, // America/Nassau
    {  121, 1852,     353, 19, }, // America/Noronha
    {  121, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  121, 8347,     392, 20, }, // America/North_Dakota/Center
    {  121, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  121,  393,     435,  4, }, // America/Nuuk
    {  121, 2358,   64357,  5, }, // America/Panama
    {  121, 6192,   64362, 12, }, // America/Paramaribo
    {  121, 8442,   64374, 16, }, // America/Rankin_Inlet
    {  121, 1997,   64390,  7, }, // America/Regina
    {  121, 8478,   64397, 11, }, // America/Resolute
    {  121, 8495,     439,  8, }, // America/Santarem
    {  121, 2203,   64408, 12, }, // America/Santiago
    {  121, 6130,   64420, 18, }, // America/Santo_Domingo
    {  121, 1880,     447,  9, }, // America/Sao_Paulo
    {  121, 6918,     456, 16, }, // America/Scoresbysund
    {  121, 8526,     472, 14, }, // America/St_Barthelemy
    {  121, 2063,   64438, 17, }, // America/St_Johns
    {  121, 5882,     496,  9, }, // America/St_Kitts
    {  121, 5899,     505,  9, }, // America/St_Lucia
    {  121,  855,     514, 10, }, // America/St_Thomas
    {  121, 5932,     524, 11, }, // America/St_Vincent
    {  121, 8548,   64455, 14, }, // America/Swift_Current
    {  121, 5480,   64469, 14, }, // America/Tegucigalpa
    {  121,  313,   64483,  8, }, // America/Tijuana
    {  121,  608,   64491,  9, }, // America/Toronto
    {  121, 8570,   64500,  7, }, // America/Yakutat
    {  121, 6113,   64507,  7, }, // Antarctica/Davis
    {  121, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  121, 7085,   64514,  8, }, // Antarctica/Mawson
    {  121, 8607,   64522,  6, }, // Antarctica/Palmer
    {  121, 7226,   64528,  8, }, // Antarctica/Rothera
    {  121, 7295,     643,  5, }, // Antarctica/Syowa
    {  121, 7374,   64536,  8, }, // Antarctica/Vostok
    {  121, 5553,   64544,  7, }, // Asia/Bahrain
    {  121, 6008,   64551,  8, }, // Asia/Brunei
    {  121, 4530,   64559, 10, }, // Asia/Colombo
    {  121, 1095,   63860,  4, }, // Asia/Dhaka
    {  121, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  121, 4790,     704,  5, }, // Asia/Hovd
    {  121, 7025,   64569,  7, }, // Asia/Jakarta
    {  121, 7011,   64576,  8, }, // Asia/Jayapura
    {  121, 3579,   64584,  6, }, // Asia/Kabul
    {  121, 4258,   64590,  6, }, // Asia/Karachi
    {  121, 1187,   64596, 10, }, // Asia/Kathmandu
    {  121,  994,   64606,  8, }, // Asia/Kolkata
    {  121, 4878,   64614, 12, }, // Asia/Kuala_Lumpur
    {  121, 1213,     725,  5, }, // Asia/Macau
    {  121, 8711,   64626, 11, }, // Asia/Pontianak
    {  121, 2774,   64637,  6, }, // Asia/Tehran
    {  121, 1319,   64643,  7, }, // Asia/Thimphu
    {  121, 1161,     747,  6, }, // Asia/Urumqi
    {  121, 6996,   64650, 13, }, // Asia/Vientiane
    {  121, 1237,   64663,  7, }, // Asia/Yangon
    {  121, 5690,   64670,  7, }, // Atlantic/Bermuda
    {  121, 6647,    4413,  8, }, // Atlantic/Canary
    {  121, 3746,   64677,  7, }, // Atlantic/Cape_Verde
    {  121, 1397,   64684,  8, }, // Atlantic/Faroe
    {  121, 2750,   64692, 11, }, // Atlantic/Reykjavik
    {  121, 7272,   64703, 11, }, // Atlantic/South_Georgia
    {  121, 6840,     773, 10, }, // Atlantic/St_Helena
    {  121, 6460,   64714,  9, }, // Europe/Amsterdam
    {  121, 6235,   64723,  8, }, // Europe/Andorra
    {  121, 2302,   64731,  8, }, // Europe/Athens
    {  121, 4776,   64739,  7, }, // Europe/Berlin
    {  121, 2169,   64746,  7, }, // Europe/Brussels
    {  121, 3947,   64753, 10, }, // Europe/Bucharest
    {  121, 3825,   64763, 10, }, // Europe/Budapest
    {  121, 8790,     799,  8, }, // Europe/Busingen
    {  121, 2585,   64773,  9, }, // Europe/Chisinau
    {  121, 6308,   64782, 13, }, // Europe/Copenhagen
    {  121, 2340,   64795,  6, }, // Europe/Dublin
    {  121, 6631,   64801, 10, }, // Europe/Helsinki
    {  121, 2529,     815,  4, }, // Europe/Kyiv
    {  121, 2503,   64811,  7, }, // Europe/London
    {  121, 6384,   64818,  9, }, // Europe/Luxembourg
    {  121, 4911,   64827,  8, }, // Europe/Madrid
    {  121, 3712,   64835,  5, }, // Europe/Minsk
    {  121, 6429,   64840,  7, }, // Europe/Monaco
    {  121, 3556,   64847,  7, }, // Europe/Moscow
    {  121, 6477,   64854,  6, }, // Europe/Oslo
    {  121, 4303,   64860,  6, }, // Europe/Paris
    {  121, 6294,   64866,  3, }, // Europe/Prague
    {  121, 8868,   64869,  5, }, // Europe/Riga
    {  121, 6264,   64874,  9, }, // Europe/Sarajevo
    {  121, 6618,   64883,  7, }, // Europe/Sofia
    {  121, 6542,   64890, 12, }, // Europe/Stockholm
    {  121, 8898,   64902,  7, }, // Europe/Tallinn
    {  121, 6221,   64909,  6, }, // Europe/Tirane
    {  121, 6371,   64915,  6, }, // Europe/Vaduz
    {  121, 6250,   64921,  7, }, // Europe/Vienna
    {  121, 8930,   64928, 10, }, // Europe/Vilnius
    {  121, 3209,   64938,  5, }, // Europe/Warsaw
    {  121, 6559,   64943,  6, }, // Europe/Zurich
    {  121, 5097,   64949, 15, }, // Indian/Antananarivo
    {  121, 6065,   64964, 10, }, // Indian/Christmas
    {  121, 6082,   64974,  7, }, // Indian/Cocos
    {  121, 5048,   64981,  8, }, // Indian/Comoro
    {  121, 6680,   64989, 10, }, // Indian/Kerguelen
    {  121, 7260,     896,  4, }, // Indian/Mahe
    {  121, 7069,   64999,  8, }, // Indian/Maldives
    {  121, 4088,   65007,  9, }, // Indian/Mauritius
    {  121, 7211,     900,  7, }, // Indian/Reunion
    {  121, 4441,   65016,  6, }, // Pacific/Apia
    {  121, 3176,     922,  5, }, // Pacific/Chuuk
    {  121, 7327,   65022,  8, }, // Pacific/Fakaofo
    {  121, 7343,   65030, 10, }, // Pacific/Funafuti
    {  121, 6697,     940,  9, }, // Pacific/Galapagos
    {  121, 6715,   65040,  8, }, // Pacific/Gambier
    {  121, 3068,     957,  6, }, // Pacific/Kanton
    {  121, 4896,   65048,  8, }, // Pacific/Majuro
    {  121, 8945,   65056,  6, }, // Pacific/Midway
    {  121, 7103,   65062,  6, }, // Pacific/Nauru
    {  121, 7117,    1028,  6, }, // Pacific/Noumea
    {  121, 3145,   65068, 10, }, // Pacific/Pago_Pago
    {  121, 7155,   65078,  5, }, // Pacific/Palau
    {  121, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  121, 6095,   65083, 12, }, // Pacific/Rarotonga
    {  121, 6050,   65095,  8, }, // Pacific/Saipan
    {  121, 4602,   65103, 10, }, // Pacific/Tongatapu
    {  121, 7392,   65113,  3, }, // Pacific/Wake
    {  121, 7405,    1068, 15, }, // Pacific/Wallis
    {  122,   14,       0,  6, }, // Africa/Asmara Embu/Latin/Kenya
    {  122, 5185,       6,  8, }, // Africa/El_Aaiun
    {  122, 6888,      14,  4, }, // Africa/Lome
    {  122, 5290,      18,  9, }, // Africa/Ndjamena
    {  122, 4454,      27,  8, }, // Africa/Sao_Tome
    {  122, 4573,      35,  9, }, // America/Araguaina
    {  122,  270,      44,  7, }, // America/Argentina/Cordoba
    {  122, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  122, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  122, 4271,      70,  8, }, // America/Asuncion
    {  122,  237,      78,  8, }, // America/Atikokan
    {  122, 7623,      86, 17, }, // America/Bahia_Banderas
    {  122, 7646,     103,  5, }, // America/Belem
    {  122, 4380,     108,  6, }, // America/Bogota
    {  122, 3887,     114,  6, }, // America/Cancun
    {  122, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  122, 3810,     133,  6, }, // America/Cuiaba
    {  122, 5742,     139,  7, }, // America/Curacao
    {  122, 7887,     146,  8, }, // America/Eirunepe
    {  122,  481,     154, 13, }, // America/Indiana/Knox
    {  122, 7979,     167, 16, }, // America/Indiana/Marengo
    {  122, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  122, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  122, 8056,     220, 14, }, // America/Indiana/Vevay
    {  122, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  122, 8104,     252, 16, }, // America/Indiana/Winamac
    {  122, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  122, 5951,     288, 22, }, // America/Lower_Princes
    {  122, 8171,     310,  6, }, // America/Maceio
    {  122, 2919,     316,  8, }, // America/Mazatlan
    {  122, 8238,     324,  6, }, // America/Merida
    {  122, 2951,    4381, 16, }, // America/Mexico_City
    {  122, 4410,     341, 12, }, // America/Miquelon
    {  122, 1852,     353, 19, }, // America/Noronha
    {  122, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  122, 8347,     392, 20, }, // America/North_Dakota/Center
    {  122, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  122,  393,     435,  4, }, // America/Nuuk
    {  122, 8495,     439,  8, }, // America/Santarem
    {  122, 1880,     447,  9, }, // America/Sao_Paulo
    {  122, 6918,     456, 16, }, // America/Scoresbysund
    {  122, 8526,     472, 14, }, // America/St_Barthelemy
    {  122, 2063,     486, 10, }, // America/St_Johns
    {  122, 5882,     496,  9, }, // America/St_Kitts
    {  122, 5899,     505,  9, }, // America/St_Lucia
    {  122,  855,     514, 10, }, // America/St_Thomas
    {  122, 5932,     524, 11, }, // America/St_Vincent
    {  122, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  122, 7295,     643,  5, }, // Antarctica/Syowa
    {  122, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  122, 4790,     704,  5, }, // Asia/Hovd
    {  122, 1187,     709,  9, }, // Asia/Kathmandu
    {  122,  994,     718,  7, }, // Asia/Kolkata
    {  122, 1213,     725,  5, }, // Asia/Macau
    {  122, 1161,     747,  6, }, // Asia/Urumqi
    {  122, 1237,     753,  6, }, // Asia/Yangon
    {  122, 6647,    4413,  8, }, // Atlantic/Canary
    {  122, 1397,     767,  5, }, // Atlantic/Faroe
    {  122, 6840,     773, 10, }, // Atlantic/St_Helena
    {  122, 8790,     799,  8, }, // Europe/Busingen
    {  122, 2585,     807,  8, }, // Europe/Chisinau
    {  122, 2529,     815,  4, }, // Europe/Kyiv
    {  122, 6221,     819,  6, }, // Europe/Tirane
    {  122, 5048,    4421,  7, }, // Indian/Comoro
    {  122, 7260,     896,  4, }, // Indian/Mahe
    {  122, 7211,     900,  7, }, // Indian/Reunion
    {  122, 3176,     922,  5, }, // Pacific/Chuuk
    {  122, 6697,     940,  9, }, // Pacific/Galapagos
    {  122, 3068,     957,  6, }, // Pacific/Kanton
    {  122, 7117,    1028,  6, }, // Pacific/Noumea
    {  122, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  122, 7405,    1068, 15, }, // Pacific/Wallis
    {  123,   14,       0,  6, }, // Africa/Asmara English/Latin/United States
    {  123, 5185,       6,  8, }, // Africa/El_Aaiun
    {  123, 6888,      14,  4, }, // Africa/Lome
    {  123, 5290,      18,  9, }, // Africa/Ndjamena
    {  123, 4454,      27,  8, }, // Africa/Sao_Tome
    {  123, 4573,      35,  9, }, // America/Araguaina
    {  123,  270,      44,  7, }, // America/Argentina/Cordoba
    {  123, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  123, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  123, 4271,      70,  8, }, // America/Asuncion
    {  123,  237,      78,  8, }, // America/Atikokan
    {  123, 7623,      86, 17, }, // America/Bahia_Banderas
    {  123, 7646,     103,  5, }, // America/Belem
    {  123, 4380,     108,  6, }, // America/Bogota
    {  123, 3887,     114,  6, }, // America/Cancun
    {  123, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  123, 3810,     133,  6, }, // America/Cuiaba
    {  123, 5742,     139,  7, }, // America/Curacao
    {  123, 7887,     146,  8, }, // America/Eirunepe
    {  123,  481,     154, 13, }, // America/Indiana/Knox
    {  123, 7979,     167, 16, }, // America/Indiana/Marengo
    {  123, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  123, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  123, 8056,     220, 14, }, // America/Indiana/Vevay
    {  123, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  123, 8104,     252, 16, }, // America/Indiana/Winamac
    {  123, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  123, 5951,     288, 22, }, // America/Lower_Princes
    {  123, 8171,     310,  6, }, // America/Maceio
    {  123, 2919,     316,  8, }, // America/Mazatlan
    {  123, 8238,     324,  6, }, // America/Merida
    {  123, 2951,     330, 11, }, // America/Mexico_City
    {  123, 4410,     341, 12, }, // America/Miquelon
    {  123, 1852,     353, 19, }, // America/Noronha
    {  123, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  123, 8347,     392, 20, }, // America/North_Dakota/Center
    {  123, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  123,  393,     435,  4, }, // America/Nuuk
    {  123, 8495,     439,  8, }, // America/Santarem
    {  123, 1880,     447,  9, }, // America/Sao_Paulo
    {  123, 6918,     456, 16, }, // America/Scoresbysund
    {  123, 8526,     472, 14, }, // America/St_Barthelemy
    {  123, 2063,     486, 10, }, // America/St_Johns
    {  123, 5882,     496,  9, }, // America/St_Kitts
    {  123, 5899,     505,  9, }, // America/St_Lucia
    {  123,  855,     514, 10, }, // America/St_Thomas
    {  123, 5932,     524, 11, }, // America/St_Vincent
    {  123, 6020,     535, 13, }, // Antarctica/Casey
    {  123, 6152,     548, 24, }, // Antarctica/DumontDUrville
    {  123, 8586,     572, 16, }, // Antarctica/Macquarie
    {  123, 7085,     588, 14, }, // Antarctica/Mawson
    {  123,  932,     602, 15, }, // Antarctica/McMurdo
    {  123, 8607,     617, 11, }, // Antarctica/Palmer
    {  123, 7226,     628, 15, }, // Antarctica/Rothera
    {  123, 7295,     643, 13, }, // Antarctica/Syowa
    {  123, 8625,     656, 13, }, // Antarctica/Troll
    {  123, 7374,     669, 14, }, // Antarctica/Vostok
    {  123, 5542,     683,  5, }, // Asia/Aqtau
    {  123, 1261,     688, 16, }, // Asia/Ho_Chi_Minh
    {  123, 4790,     704,  5, }, // Asia/Hovd
    {  123, 1187,     709,  9, }, // Asia/Kathmandu
    {  123,  994,     718,  7, }, // Asia/Kolkata
    {  123, 1213,     725,  5, }, // Asia/Macau
    {  123, 8726,     730,  8, }, // Asia/Qostanay
    {  123, 4288,     738,  9, }, // Asia/Qyzylorda
    {  123, 1161,     747,  6, }, // Asia/Urumqi
    {  123, 1237,     753,  6, }, // Asia/Yangon
    {  123, 6647,     759,  8, }, // Atlantic/Canary
    {  123, 1397,     767,  6, }, // Atlantic/Faroe
    {  123, 6840,     773, 10, }, // Atlantic/St_Helena
    {  123, 1549,     783, 16, }, // Australia/Lord_Howe
    {  123, 8790,     799,  8, }, // Europe/Busingen
    {  123, 2585,     807,  8, }, // Europe/Chisinau
    {  123, 2529,     815,  4, }, // Europe/Kyiv
    {  123, 6221,     819,  6, }, // Europe/Tirane
    {  123, 6966,     825, 18, }, // Indian/Chagos
    {  123, 6065,     843, 16, }, // Indian/Christmas
    {  123, 6082,     859, 13, }, // Indian/Cocos
    {  123, 5048,     872,  7, }, // Indian/Comoro
    {  123, 6680,     879, 17, }, // Indian/Kerguelen
    {  123, 7260,     896,  4, }, // Indian/Mahe
    {  123, 7211,     900,  7, }, // Indian/Reunion
    {  123, 3034,     907, 15, }, // Pacific/Chatham
    {  123, 3176,     922,  5, }, // Pacific/Chuuk
    {  123, 2239,     927, 13, }, // Pacific/Easter
    {  123, 6697,     940, 17, }, // Pacific/Galapagos
    {  123, 3068,     957, 13, }, // Pacific/Kanton
    {  123, 2844,     970, 15, }, // Pacific/Kwajalein
    {  123, 4070,     985, 17, }, // Pacific/Marquesas
    {  123, 8945,    1002, 12, }, // Pacific/Midway
    {  123, 4187,    1014, 14, }, // Pacific/Norfolk
    {  123, 7117,    1028,  6, }, // Pacific/Noumea
    {  123, 7194,    1034, 16, }, // Pacific/Pitcairn
    {  123, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  123, 7392,    1057, 11, }, // Pacific/Wake
    {  123, 7405,    1068, 15, }, // Pacific/Wallis
    {  124,  132,   65116,  8, }, // America/Adak English/Deseret/United States
    {  124, 3365,   65124, 14, }, // America/Anchorage
    {  124, 7699,   65138, 10, }, // America/Boise
    {  124, 2262,   65148, 12, }, // America/Chicago
    {  124,  805,   65160, 12, }, // America/Denver
    {  124, 3484,   65172, 14, }, // America/Detroit
    {  124,  348,   65186, 24, }, // America/Indiana/Indianapolis
    {  124,  481,   65210, 24, }, // America/Indiana/Knox
    {  124, 7979,   65234, 30, }, // America/Indiana/Marengo
    {  124, 8003,   65264, 36, }, // America/Indiana/Petersburg
    {  124, 8030,   65300, 31, }, // America/Indiana/Tell_City
    {  124, 8056,   65331, 24, }, // America/Indiana/Vevay
    {  124, 8078,   65355, 30, }, // America/Indiana/Vincennes
    {  124, 8104,   65385, 30, }, // America/Indiana/Winamac
    {  124, 5399,   65415,  8, }, // America/Juneau
    {  124,  521,   65423, 14, }, // America/Kentucky/Louisville
    {  124, 8143,   65437, 34, }, // America/Kentucky/Monticello
    {  124, 3258,   65471, 19, }, // America/Los_Angeles
    {  124, 8220,   65490, 16, }, // America/Menominee
    {  124, 2951,    4381, 16, }, // America/Mexico_City
    {  124, 2381,   65506, 13, }, // America/New_York
    {  124, 8306,   65519,  6, }, // America/Nome
    {  124, 8347,   65525, 35, }, // America/North_Dakota/Center
    {  124, 8375,   65560, 38, }, // America/North_Dakota/New_Salem
    {  124, 2975,   65598, 12, }, // America/Phoenix
    {  124, 8570,   65610, 14, }, // America/Yakutat
    {  124, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  124, 7295,     643,  5, }, // Antarctica/Syowa
    {  124, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  124, 6647,    4413,  8, }, // Atlantic/Canary
    {  124, 1397,     767,  5, }, // Atlantic/Faroe
    {  124, 5048,    4421,  7, }, // Indian/Comoro
    {  124, 6697,     940,  9, }, // Pacific/Galapagos
    {  124, 2725,   65624, 16, }, // Pacific/Honolulu
    {  124, 3068,     957,  6, }, // Pacific/Kanton
    {  124, 8945,   65640, 10, }, // Pacific/Midway
    {  124, 7392,   65650,  6, }, // Pacific/Wake
    {  126, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Anguilla
    {  126, 2063,   65669,  9, }, // America/St_Johns
    {  126, 5882,   65678,  8, }, // America/St_Kitts
    {  126, 5899,   65686,  8, }, // America/St_Lucia
    {  126,  855,   65694,  9, }, // America/St_Thomas
    {  126, 5932,   65703, 10, }, // America/St_Vincent
    {  126, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  127, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Antigua and Barbuda
    {  127, 2063,   65669,  9, }, // America/St_Johns
    {  127, 5882,   65678,  8, }, // America/St_Kitts
    {  127, 5899,   65686,  8, }, // America/St_Lucia
    {  127,  855,   65694,  9, }, // America/St_Thomas
    {  127, 5932,   65703, 10, }, // America/St_Vincent
    {  127, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  128, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Australia
    {  128, 2063,   65669,  9, }, // America/St_Johns
    {  128, 5882,   65678,  8, }, // America/St_Kitts
    {  128, 5899,   65686,  8, }, // America/St_Lucia
    {  128,  855,   65694,  9, }, // America/St_Thomas
    {  128, 5932,   65703, 10, }, // America/St_Vincent
    {  128, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  128, 7405,   65722, 17, }, // Pacific/Wallis
    {  129, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Austria
    {  129, 2063,   65669,  9, }, // America/St_Johns
    {  129, 5882,   65678,  8, }, // America/St_Kitts
    {  129, 5899,   65686,  8, }, // America/St_Lucia
    {  129,  855,   65694,  9, }, // America/St_Thomas
    {  129, 5932,   65703, 10, }, // America/St_Vincent
    {  129, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  130, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Bahamas
    {  130, 2063,   65669,  9, }, // America/St_Johns
    {  130, 5882,   65678,  8, }, // America/St_Kitts
    {  130, 5899,   65686,  8, }, // America/St_Lucia
    {  130,  855,   65694,  9, }, // America/St_Thomas
    {  130, 5932,   65703, 10, }, // America/St_Vincent
    {  130, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  131, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Barbados
    {  131, 2063,   65669,  9, }, // America/St_Johns
    {  131, 5882,   65678,  8, }, // America/St_Kitts
    {  131, 5899,   65686,  8, }, // America/St_Lucia
    {  131,  855,   65694,  9, }, // America/St_Thomas
    {  131, 5932,   65703, 10, }, // America/St_Vincent
    {  131, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  132, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Belgium
    {  132, 2063,   65669,  9, }, // America/St_Johns
    {  132, 5882,   65678,  8, }, // America/St_Kitts
    {  132, 5899,   65686,  8, }, // America/St_Lucia
    {  132,  855,   65694,  9, }, // America/St_Thomas
    {  132, 5932,   65703, 10, }, // America/St_Vincent
    {  132, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  133, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Belize
    {  133, 2063,   65669,  9, }, // America/St_Johns
    {  133, 5882,   65678,  8, }, // America/St_Kitts
    {  133, 5899,   65686,  8, }, // America/St_Lucia
    {  133,  855,   65694,  9, }, // America/St_Thomas
    {  133, 5932,   65703, 10, }, // America/St_Vincent
    {  133, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  134, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Bermuda
    {  134, 2063,   65669,  9, }, // America/St_Johns
    {  134, 5882,   65678,  8, }, // America/St_Kitts
    {  134, 5899,   65686,  8, }, // America/St_Lucia
    {  134,  855,   65694,  9, }, // America/St_Thomas
    {  134, 5932,   65703, 10, }, // America/St_Vincent
    {  134, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  135, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Botswana
    {  135, 2063,   65669,  9, }, // America/St_Johns
    {  135, 5882,   65678,  8, }, // America/St_Kitts
    {  135, 5899,   65686,  8, }, // America/St_Lucia
    {  135,  855,   65694,  9, }, // America/St_Thomas
    {  135, 5932,   65703, 10, }, // America/St_Vincent
    {  135, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  136, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/British Indian Ocean Territory
    {  136, 2063,   65669,  9, }, // America/St_Johns
    {  136, 5882,   65678,  8, }, // America/St_Kitts
    {  136, 5899,   65686,  8, }, // America/St_Lucia
    {  136,  855,   65694,  9, }, // America/St_Thomas
    {  136, 5932,   65703, 10, }, // America/St_Vincent
    {  136, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  137, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/British Virgin Islands
    {  137, 2063,   65669,  9, }, // America/St_Johns
    {  137, 5882,   65678,  8, }, // America/St_Kitts
    {  137, 5899,   65686,  8, }, // America/St_Lucia
    {  137,  855,   65694,  9, }, // America/St_Thomas
    {  137, 5932,   65703, 10, }, // America/St_Vincent
    {  137, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  139, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Cameroon
    {  139, 2063,   65669,  9, }, // America/St_Johns
    {  139, 5882,   65678,  8, }, // America/St_Kitts
    {  139, 5899,   65686,  8, }, // America/St_Lucia
    {  139,  855,   65694,  9, }, // America/St_Thomas
    {  139, 5932,   65703, 10, }, // America/St_Vincent
    {  139, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  140, 8526,   29041, 16, }, // America/St_Barthelemy English/Latin/Canada
    {  140, 2063,   29057, 12, }, // America/St_Johns
    {  140, 5882,   29069, 11, }, // America/St_Kitts
    {  140, 5899,   37943, 11, }, // America/St_Lucia
    {  140,  855,   46153, 12, }, // America/St_Thomas
    {  140, 5932,   29103, 13, }, // America/St_Vincent
    {  140, 6840,   46383, 12, }, // Atlantic/St_Helena
    {  141, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Cayman Islands
    {  141, 2063,   65669,  9, }, // America/St_Johns
    {  141, 5882,   65678,  8, }, // America/St_Kitts
    {  141, 5899,   65686,  8, }, // America/St_Lucia
    {  141,  855,   65694,  9, }, // America/St_Thomas
    {  141, 5932,   65703, 10, }, // America/St_Vincent
    {  141, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  142, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Christmas Island
    {  142, 2063,   65669,  9, }, // America/St_Johns
    {  142, 5882,   65678,  8, }, // America/St_Kitts
    {  142, 5899,   65686,  8, }, // America/St_Lucia
    {  142,  855,   65694,  9, }, // America/St_Thomas
    {  142, 5932,   65703, 10, }, // America/St_Vincent
    {  142, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  143, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Cocos Islands
    {  143, 2063,   65669,  9, }, // America/St_Johns
    {  143, 5882,   65678,  8, }, // America/St_Kitts
    {  143, 5899,   65686,  8, }, // America/St_Lucia
    {  143,  855,   65694,  9, }, // America/St_Thomas
    {  143, 5932,   65703, 10, }, // America/St_Vincent
    {  143, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  144, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Cook Islands
    {  144, 2063,   65669,  9, }, // America/St_Johns
    {  144, 5882,   65678,  8, }, // America/St_Kitts
    {  144, 5899,   65686,  8, }, // America/St_Lucia
    {  144,  855,   65694,  9, }, // America/St_Thomas
    {  144, 5932,   65703, 10, }, // America/St_Vincent
    {  144, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  145, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Cyprus
    {  145, 2063,   65669,  9, }, // America/St_Johns
    {  145, 5882,   65678,  8, }, // America/St_Kitts
    {  145, 5899,   65686,  8, }, // America/St_Lucia
    {  145,  855,   65694,  9, }, // America/St_Thomas
    {  145, 5932,   65703, 10, }, // America/St_Vincent
    {  145, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  146, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Czechia
    {  146, 2063,   65669,  9, }, // America/St_Johns
    {  146, 5882,   65678,  8, }, // America/St_Kitts
    {  146, 5899,   65686,  8, }, // America/St_Lucia
    {  146,  855,   65694,  9, }, // America/St_Thomas
    {  146, 5932,   65703, 10, }, // America/St_Vincent
    {  146, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  147, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Denmark
    {  147, 2063,   65669,  9, }, // America/St_Johns
    {  147, 5882,   65678,  8, }, // America/St_Kitts
    {  147, 5899,   65686,  8, }, // America/St_Lucia
    {  147,  855,   65694,  9, }, // America/St_Thomas
    {  147, 5932,   65703, 10, }, // America/St_Vincent
    {  147, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  148, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Diego Garcia
    {  148, 2063,   65669,  9, }, // America/St_Johns
    {  148, 5882,   65678,  8, }, // America/St_Kitts
    {  148, 5899,   65686,  8, }, // America/St_Lucia
    {  148,  855,   65694,  9, }, // America/St_Thomas
    {  148, 5932,   65703, 10, }, // America/St_Vincent
    {  148, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  149, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Dominica
    {  149, 2063,   65669,  9, }, // America/St_Johns
    {  149, 5882,   65678,  8, }, // America/St_Kitts
    {  149, 5899,   65686,  8, }, // America/St_Lucia
    {  149,  855,   65694,  9, }, // America/St_Thomas
    {  149, 5932,   65703, 10, }, // America/St_Vincent
    {  149, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  150, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Eritrea
    {  150, 2063,   65669,  9, }, // America/St_Johns
    {  150, 5882,   65678,  8, }, // America/St_Kitts
    {  150, 5899,   65686,  8, }, // America/St_Lucia
    {  150,  855,   65694,  9, }, // America/St_Thomas
    {  150, 5932,   65703, 10, }, // America/St_Vincent
    {  150, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  151, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Estonia
    {  151, 2063,   65669,  9, }, // America/St_Johns
    {  151, 5882,   65678,  8, }, // America/St_Kitts
    {  151, 5899,   65686,  8, }, // America/St_Lucia
    {  151,  855,   65694,  9, }, // America/St_Thomas
    {  151, 5932,   65703, 10, }, // America/St_Vincent
    {  151, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  152, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Eswatini
    {  152, 2063,   65669,  9, }, // America/St_Johns
    {  152, 5882,   65678,  8, }, // America/St_Kitts
    {  152, 5899,   65686,  8, }, // America/St_Lucia
    {  152,  855,   65694,  9, }, // America/St_Thomas
    {  152, 5932,   65703, 10, }, // America/St_Vincent
    {  152, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  153, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Europe
    {  153, 2063,   65669,  9, }, // America/St_Johns
    {  153, 5882,   65678,  8, }, // America/St_Kitts
    {  153, 5899,   65686,  8, }, // America/St_Lucia
    {  153,  855,   65694,  9, }, // America/St_Thomas
    {  153, 5932,   65703, 10, }, // America/St_Vincent
    {  153, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  154, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Falkland Islands
    {  154, 2063,   65669,  9, }, // America/St_Johns
    {  154, 5882,   65678,  8, }, // America/St_Kitts
    {  154, 5899,   65686,  8, }, // America/St_Lucia
    {  154,  855,   65694,  9, }, // America/St_Thomas
    {  154, 5932,   65703, 10, }, // America/St_Vincent
    {  154, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  155, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Fiji
    {  155, 2063,   65669,  9, }, // America/St_Johns
    {  155, 5882,   65678,  8, }, // America/St_Kitts
    {  155, 5899,   65686,  8, }, // America/St_Lucia
    {  155,  855,   65694,  9, }, // America/St_Thomas
    {  155, 5932,   65703, 10, }, // America/St_Vincent
    {  155, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  156, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Finland
    {  156, 2063,   65669,  9, }, // America/St_Johns
    {  156, 5882,   65678,  8, }, // America/St_Kitts
    {  156, 5899,   65686,  8, }, // America/St_Lucia
    {  156,  855,   65694,  9, }, // America/St_Thomas
    {  156, 5932,   65703, 10, }, // America/St_Vincent
    {  156, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  157, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/France
    {  157, 2063,   65669,  9, }, // America/St_Johns
    {  157, 5882,   65678,  8, }, // America/St_Kitts
    {  157, 5899,   65686,  8, }, // America/St_Lucia
    {  157,  855,   65694,  9, }, // America/St_Thomas
    {  157, 5932,   65703, 10, }, // America/St_Vincent
    {  157, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  158, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Gambia
    {  158, 2063,   65669,  9, }, // America/St_Johns
    {  158, 5882,   65678,  8, }, // America/St_Kitts
    {  158, 5899,   65686,  8, }, // America/St_Lucia
    {  158,  855,   65694,  9, }, // America/St_Thomas
    {  158, 5932,   65703, 10, }, // America/St_Vincent
    {  158, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  159, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Georgia
    {  159, 2063,   65669,  9, }, // America/St_Johns
    {  159, 5882,   65678,  8, }, // America/St_Kitts
    {  159, 5899,   65686,  8, }, // America/St_Lucia
    {  159,  855,   65694,  9, }, // America/St_Thomas
    {  159, 5932,   65703, 10, }, // America/St_Vincent
    {  159, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  160, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Germany
    {  160, 2063,   65669,  9, }, // America/St_Johns
    {  160, 5882,   65678,  8, }, // America/St_Kitts
    {  160, 5899,   65686,  8, }, // America/St_Lucia
    {  160,  855,   65694,  9, }, // America/St_Thomas
    {  160, 5932,   65703, 10, }, // America/St_Vincent
    {  160, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  161, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Ghana
    {  161, 2063,   65669,  9, }, // America/St_Johns
    {  161, 5882,   65678,  8, }, // America/St_Kitts
    {  161, 5899,   65686,  8, }, // America/St_Lucia
    {  161,  855,   65694,  9, }, // America/St_Thomas
    {  161, 5932,   65703, 10, }, // America/St_Vincent
    {  161, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  162, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Gibraltar
    {  162, 2063,   65669,  9, }, // America/St_Johns
    {  162, 5882,   65678,  8, }, // America/St_Kitts
    {  162, 5899,   65686,  8, }, // America/St_Lucia
    {  162,  855,   65694,  9, }, // America/St_Thomas
    {  162, 5932,   65703, 10, }, // America/St_Vincent
    {  162, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  163, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Grenada
    {  163, 2063,   65669,  9, }, // America/St_Johns
    {  163, 5882,   65678,  8, }, // America/St_Kitts
    {  163, 5899,   65686,  8, }, // America/St_Lucia
    {  163,  855,   65694,  9, }, // America/St_Thomas
    {  163, 5932,   65703, 10, }, // America/St_Vincent
    {  163, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  165, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Guernsey
    {  165, 2063,   65669,  9, }, // America/St_Johns
    {  165, 5882,   65678,  8, }, // America/St_Kitts
    {  165, 5899,   65686,  8, }, // America/St_Lucia
    {  165,  855,   65694,  9, }, // America/St_Thomas
    {  165, 5932,   65703, 10, }, // America/St_Vincent
    {  165, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  166, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Guyana
    {  166, 2063,   65669,  9, }, // America/St_Johns
    {  166, 5882,   65678,  8, }, // America/St_Kitts
    {  166, 5899,   65686,  8, }, // America/St_Lucia
    {  166,  855,   65694,  9, }, // America/St_Thomas
    {  166, 5932,   65703, 10, }, // America/St_Vincent
    {  166, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  167, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Hong Kong
    {  167, 2063,   65669,  9, }, // America/St_Johns
    {  167, 5882,   65678,  8, }, // America/St_Kitts
    {  167, 5899,   65686,  8, }, // America/St_Lucia
    {  167,  855,   65694,  9, }, // America/St_Thomas
    {  167, 5932,   65703, 10, }, // America/St_Vincent
    {  167, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  168, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Hungary
    {  168, 2063,   65669,  9, }, // America/St_Johns
    {  168, 5882,   65678,  8, }, // America/St_Kitts
    {  168, 5899,   65686,  8, }, // America/St_Lucia
    {  168,  855,   65694,  9, }, // America/St_Thomas
    {  168, 5932,   65703, 10, }, // America/St_Vincent
    {  168, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  169, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/India
    {  169, 2063,   65669,  9, }, // America/St_Johns
    {  169, 5882,   65678,  8, }, // America/St_Kitts
    {  169, 5899,   65686,  8, }, // America/St_Lucia
    {  169,  855,   65694,  9, }, // America/St_Thomas
    {  169, 5932,   65703, 10, }, // America/St_Vincent
    {  169, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  170, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Indonesia
    {  170, 2063,   65669,  9, }, // America/St_Johns
    {  170, 5882,   65678,  8, }, // America/St_Kitts
    {  170, 5899,   65686,  8, }, // America/St_Lucia
    {  170,  855,   65694,  9, }, // America/St_Thomas
    {  170, 5932,   65703, 10, }, // America/St_Vincent
    {  170, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  171, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Ireland
    {  171, 2063,   65669,  9, }, // America/St_Johns
    {  171, 5882,   65678,  8, }, // America/St_Kitts
    {  171, 5899,   65686,  8, }, // America/St_Lucia
    {  171,  855,   65694,  9, }, // America/St_Thomas
    {  171, 5932,   65703, 10, }, // America/St_Vincent
    {  171, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  172, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Isle of Man
    {  172, 2063,   65669,  9, }, // America/St_Johns
    {  172, 5882,   65678,  8, }, // America/St_Kitts
    {  172, 5899,   65686,  8, }, // America/St_Lucia
    {  172,  855,   65694,  9, }, // America/St_Thomas
    {  172, 5932,   65703, 10, }, // America/St_Vincent
    {  172, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  173, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Israel
    {  173, 2063,   65669,  9, }, // America/St_Johns
    {  173, 5882,   65678,  8, }, // America/St_Kitts
    {  173, 5899,   65686,  8, }, // America/St_Lucia
    {  173,  855,   65694,  9, }, // America/St_Thomas
    {  173, 5932,   65703, 10, }, // America/St_Vincent
    {  173, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  174, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Italy
    {  174, 2063,   65669,  9, }, // America/St_Johns
    {  174, 5882,   65678,  8, }, // America/St_Kitts
    {  174, 5899,   65686,  8, }, // America/St_Lucia
    {  174,  855,   65694,  9, }, // America/St_Thomas
    {  174, 5932,   65703, 10, }, // America/St_Vincent
    {  174, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  175, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Jamaica
    {  175, 2063,   65669,  9, }, // America/St_Johns
    {  175, 5882,   65678,  8, }, // America/St_Kitts
    {  175, 5899,   65686,  8, }, // America/St_Lucia
    {  175,  855,   65694,  9, }, // America/St_Thomas
    {  175, 5932,   65703, 10, }, // America/St_Vincent
    {  175, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  177, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Jersey
    {  177, 2063,   65669,  9, }, // America/St_Johns
    {  177, 5882,   65678,  8, }, // America/St_Kitts
    {  177, 5899,   65686,  8, }, // America/St_Lucia
    {  177,  855,   65694,  9, }, // America/St_Thomas
    {  177, 5932,   65703, 10, }, // America/St_Vincent
    {  177, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  178, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Kenya
    {  178, 2063,   65669,  9, }, // America/St_Johns
    {  178, 5882,   65678,  8, }, // America/St_Kitts
    {  178, 5899,   65686,  8, }, // America/St_Lucia
    {  178,  855,   65694,  9, }, // America/St_Thomas
    {  178, 5932,   65703, 10, }, // America/St_Vincent
    {  178, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  179, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Kiribati
    {  179, 2063,   65669,  9, }, // America/St_Johns
    {  179, 5882,   65678,  8, }, // America/St_Kitts
    {  179, 5899,   65686,  8, }, // America/St_Lucia
    {  179,  855,   65694,  9, }, // America/St_Thomas
    {  179, 5932,   65703, 10, }, // America/St_Vincent
    {  179, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  180, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Latvia
    {  180, 2063,   65669,  9, }, // America/St_Johns
    {  180, 5882,   65678,  8, }, // America/St_Kitts
    {  180, 5899,   65686,  8, }, // America/St_Lucia
    {  180,  855,   65694,  9, }, // America/St_Thomas
    {  180, 5932,   65703, 10, }, // America/St_Vincent
    {  180, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  181, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Lesotho
    {  181, 2063,   65669,  9, }, // America/St_Johns
    {  181, 5882,   65678,  8, }, // America/St_Kitts
    {  181, 5899,   65686,  8, }, // America/St_Lucia
    {  181,  855,   65694,  9, }, // America/St_Thomas
    {  181, 5932,   65703, 10, }, // America/St_Vincent
    {  181, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  182, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Liberia
    {  182, 2063,   65669,  9, }, // America/St_Johns
    {  182, 5882,   65678,  8, }, // America/St_Kitts
    {  182, 5899,   65686,  8, }, // America/St_Lucia
    {  182,  855,   65694,  9, }, // America/St_Thomas
    {  182, 5932,   65703, 10, }, // America/St_Vincent
    {  182, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  183, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Lithuania
    {  183, 2063,   65669,  9, }, // America/St_Johns
    {  183, 5882,   65678,  8, }, // America/St_Kitts
    {  183, 5899,   65686,  8, }, // America/St_Lucia
    {  183,  855,   65694,  9, }, // America/St_Thomas
    {  183, 5932,   65703, 10, }, // America/St_Vincent
    {  183, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  184, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Macao
    {  184, 2063,   65669,  9, }, // America/St_Johns
    {  184, 5882,   65678,  8, }, // America/St_Kitts
    {  184, 5899,   65686,  8, }, // America/St_Lucia
    {  184,  855,   65694,  9, }, // America/St_Thomas
    {  184, 5932,   65703, 10, }, // America/St_Vincent
    {  184, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  185, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Madagascar
    {  185, 2063,   65669,  9, }, // America/St_Johns
    {  185, 5882,   65678,  8, }, // America/St_Kitts
    {  185, 5899,   65686,  8, }, // America/St_Lucia
    {  185,  855,   65694,  9, }, // America/St_Thomas
    {  185, 5932,   65703, 10, }, // America/St_Vincent
    {  185, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  186, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Malawi
    {  186, 2063,   65669,  9, }, // America/St_Johns
    {  186, 5882,   65678,  8, }, // America/St_Kitts
    {  186, 5899,   65686,  8, }, // America/St_Lucia
    {  186,  855,   65694,  9, }, // America/St_Thomas
    {  186, 5932,   65703, 10, }, // America/St_Vincent
    {  186, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  187, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Malaysia
    {  187, 2063,   65669,  9, }, // America/St_Johns
    {  187, 5882,   65678,  8, }, // America/St_Kitts
    {  187, 5899,   65686,  8, }, // America/St_Lucia
    {  187,  855,   65694,  9, }, // America/St_Thomas
    {  187, 5932,   65703, 10, }, // America/St_Vincent
    {  187, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  188, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Maldives
    {  188, 2063,   65669,  9, }, // America/St_Johns
    {  188, 5882,   65678,  8, }, // America/St_Kitts
    {  188, 5899,   65686,  8, }, // America/St_Lucia
    {  188,  855,   65694,  9, }, // America/St_Thomas
    {  188, 5932,   65703, 10, }, // America/St_Vincent
    {  188, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  189, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Malta
    {  189, 2063,   65669,  9, }, // America/St_Johns
    {  189, 5882,   65678,  8, }, // America/St_Kitts
    {  189, 5899,   65686,  8, }, // America/St_Lucia
    {  189,  855,   65694,  9, }, // America/St_Thomas
    {  189, 5932,   65703, 10, }, // America/St_Vincent
    {  189, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  191, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Mauritius
    {  191, 2063,   65669,  9, }, // America/St_Johns
    {  191, 5882,   65678,  8, }, // America/St_Kitts
    {  191, 5899,   65686,  8, }, // America/St_Lucia
    {  191,  855,   65694,  9, }, // America/St_Thomas
    {  191, 5932,   65703, 10, }, // America/St_Vincent
    {  191, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  192, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Micronesia
    {  192, 2063,   65669,  9, }, // America/St_Johns
    {  192, 5882,   65678,  8, }, // America/St_Kitts
    {  192, 5899,   65686,  8, }, // America/St_Lucia
    {  192,  855,   65694,  9, }, // America/St_Thomas
    {  192, 5932,   65703, 10, }, // America/St_Vincent
    {  192, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  193, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Montserrat
    {  193, 2063,   65669,  9, }, // America/St_Johns
    {  193, 5882,   65678,  8, }, // America/St_Kitts
    {  193, 5899,   65686,  8, }, // America/St_Lucia
    {  193,  855,   65694,  9, }, // America/St_Thomas
    {  193, 5932,   65703, 10, }, // America/St_Vincent
    {  193, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  194, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Namibia
    {  194, 2063,   65669,  9, }, // America/St_Johns
    {  194, 5882,   65678,  8, }, // America/St_Kitts
    {  194, 5899,   65686,  8, }, // America/St_Lucia
    {  194,  855,   65694,  9, }, // America/St_Thomas
    {  194, 5932,   65703, 10, }, // America/St_Vincent
    {  194, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  195, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Nauru
    {  195, 2063,   65669,  9, }, // America/St_Johns
    {  195, 5882,   65678,  8, }, // America/St_Kitts
    {  195, 5899,   65686,  8, }, // America/St_Lucia
    {  195,  855,   65694,  9, }, // America/St_Thomas
    {  195, 5932,   65703, 10, }, // America/St_Vincent
    {  195, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  196, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Netherlands
    {  196, 2063,   65669,  9, }, // America/St_Johns
    {  196, 5882,   65678,  8, }, // America/St_Kitts
    {  196, 5899,   65686,  8, }, // America/St_Lucia
    {  196,  855,   65694,  9, }, // America/St_Thomas
    {  196, 5932,   65703, 10, }, // America/St_Vincent
    {  196, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  197, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/New Zealand
    {  197, 2063,   65669,  9, }, // America/St_Johns
    {  197, 5882,   65678,  8, }, // America/St_Kitts
    {  197, 5899,   65686,  8, }, // America/St_Lucia
    {  197,  855,   65694,  9, }, // America/St_Thomas
    {  197, 5932,   65703, 10, }, // America/St_Vincent
    {  197, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  198, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Nigeria
    {  198, 2063,   65669,  9, }, // America/St_Johns
    {  198, 5882,   65678,  8, }, // America/St_Kitts
    {  198, 5899,   65686,  8, }, // America/St_Lucia
    {  198,  855,   65694,  9, }, // America/St_Thomas
    {  198, 5932,   65703, 10, }, // America/St_Vincent
    {  198, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  199, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Niue
    {  199, 2063,   65669,  9, }, // America/St_Johns
    {  199, 5882,   65678,  8, }, // America/St_Kitts
    {  199, 5899,   65686,  8, }, // America/St_Lucia
    {  199,  855,   65694,  9, }, // America/St_Thomas
    {  199, 5932,   65703, 10, }, // America/St_Vincent
    {  199, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  200, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Norfolk Island
    {  200, 2063,   65669,  9, }, // America/St_Johns
    {  200, 5882,   65678,  8, }, // America/St_Kitts
    {  200, 5899,   65686,  8, }, // America/St_Lucia
    {  200,  855,   65694,  9, }, // America/St_Thomas
    {  200, 5932,   65703, 10, }, // America/St_Vincent
    {  200, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  202, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Norway
    {  202, 2063,   65669,  9, }, // America/St_Johns
    {  202, 5882,   65678,  8, }, // America/St_Kitts
    {  202, 5899,   65686,  8, }, // America/St_Lucia
    {  202,  855,   65694,  9, }, // America/St_Thomas
    {  202, 5932,   65703, 10, }, // America/St_Vincent
    {  202, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  203, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Pakistan
    {  203, 2063,   65669,  9, }, // America/St_Johns
    {  203, 5882,   65678,  8, }, // America/St_Kitts
    {  203, 5899,   65686,  8, }, // America/St_Lucia
    {  203,  855,   65694,  9, }, // America/St_Thomas
    {  203, 5932,   65703, 10, }, // America/St_Vincent
    {  203, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  204, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Palau
    {  204, 2063,   65669,  9, }, // America/St_Johns
    {  204, 5882,   65678,  8, }, // America/St_Kitts
    {  204, 5899,   65686,  8, }, // America/St_Lucia
    {  204,  855,   65694,  9, }, // America/St_Thomas
    {  204, 5932,   65703, 10, }, // America/St_Vincent
    {  204, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  205, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Papua New Guinea
    {  205, 2063,   65669,  9, }, // America/St_Johns
    {  205, 5882,   65678,  8, }, // America/St_Kitts
    {  205, 5899,   65686,  8, }, // America/St_Lucia
    {  205,  855,   65694,  9, }, // America/St_Thomas
    {  205, 5932,   65703, 10, }, // America/St_Vincent
    {  205, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  207, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Pitcairn
    {  207, 2063,   65669,  9, }, // America/St_Johns
    {  207, 5882,   65678,  8, }, // America/St_Kitts
    {  207, 5899,   65686,  8, }, // America/St_Lucia
    {  207,  855,   65694,  9, }, // America/St_Thomas
    {  207, 5932,   65703, 10, }, // America/St_Vincent
    {  207, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  208, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Poland
    {  208, 2063,   65669,  9, }, // America/St_Johns
    {  208, 5882,   65678,  8, }, // America/St_Kitts
    {  208, 5899,   65686,  8, }, // America/St_Lucia
    {  208,  855,   65694,  9, }, // America/St_Thomas
    {  208, 5932,   65703, 10, }, // America/St_Vincent
    {  208, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  209, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Portugal
    {  209, 2063,   65669,  9, }, // America/St_Johns
    {  209, 5882,   65678,  8, }, // America/St_Kitts
    {  209, 5899,   65686,  8, }, // America/St_Lucia
    {  209,  855,   65694,  9, }, // America/St_Thomas
    {  209, 5932,   65703, 10, }, // America/St_Vincent
    {  209, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  211, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Romania
    {  211, 2063,   65669,  9, }, // America/St_Johns
    {  211, 5882,   65678,  8, }, // America/St_Kitts
    {  211, 5899,   65686,  8, }, // America/St_Lucia
    {  211,  855,   65694,  9, }, // America/St_Thomas
    {  211, 5932,   65703, 10, }, // America/St_Vincent
    {  211, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  212, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Rwanda
    {  212, 2063,   65669,  9, }, // America/St_Johns
    {  212, 5882,   65678,  8, }, // America/St_Kitts
    {  212, 5899,   65686,  8, }, // America/St_Lucia
    {  212,  855,   65694,  9, }, // America/St_Thomas
    {  212, 5932,   65703, 10, }, // America/St_Vincent
    {  212, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  213, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Saint Helena
    {  213, 2063,   65669,  9, }, // America/St_Johns
    {  213, 5882,   65678,  8, }, // America/St_Kitts
    {  213, 5899,   65686,  8, }, // America/St_Lucia
    {  213,  855,   65694,  9, }, // America/St_Thomas
    {  213, 5932,   65703, 10, }, // America/St_Vincent
    {  213, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  214, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Saint Kitts and Nevis
    {  214, 2063,   65669,  9, }, // America/St_Johns
    {  214, 5882,   65678,  8, }, // America/St_Kitts
    {  214, 5899,   65686,  8, }, // America/St_Lucia
    {  214,  855,   65694,  9, }, // America/St_Thomas
    {  214, 5932,   65703, 10, }, // America/St_Vincent
    {  214, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  215, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Saint Lucia
    {  215, 2063,   65669,  9, }, // America/St_Johns
    {  215, 5882,   65678,  8, }, // America/St_Kitts
    {  215, 5899,   65686,  8, }, // America/St_Lucia
    {  215,  855,   65694,  9, }, // America/St_Thomas
    {  215, 5932,   65703, 10, }, // America/St_Vincent
    {  215, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  216, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Saint Vincent and Grenadines
    {  216, 2063,   65669,  9, }, // America/St_Johns
    {  216, 5882,   65678,  8, }, // America/St_Kitts
    {  216, 5899,   65686,  8, }, // America/St_Lucia
    {  216,  855,   65694,  9, }, // America/St_Thomas
    {  216, 5932,   65703, 10, }, // America/St_Vincent
    {  216, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  217, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Samoa
    {  217, 2063,   65669,  9, }, // America/St_Johns
    {  217, 5882,   65678,  8, }, // America/St_Kitts
    {  217, 5899,   65686,  8, }, // America/St_Lucia
    {  217,  855,   65694,  9, }, // America/St_Thomas
    {  217, 5932,   65703, 10, }, // America/St_Vincent
    {  217, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  218, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Seychelles
    {  218, 2063,   65669,  9, }, // America/St_Johns
    {  218, 5882,   65678,  8, }, // America/St_Kitts
    {  218, 5899,   65686,  8, }, // America/St_Lucia
    {  218,  855,   65694,  9, }, // America/St_Thomas
    {  218, 5932,   65703, 10, }, // America/St_Vincent
    {  218, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  219, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Sierra Leone
    {  219, 2063,   65669,  9, }, // America/St_Johns
    {  219, 5882,   65678,  8, }, // America/St_Kitts
    {  219, 5899,   65686,  8, }, // America/St_Lucia
    {  219,  855,   65694,  9, }, // America/St_Thomas
    {  219, 5932,   65703, 10, }, // America/St_Vincent
    {  219, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  220, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Singapore
    {  220, 2063,   65669,  9, }, // America/St_Johns
    {  220, 5882,   65678,  8, }, // America/St_Kitts
    {  220, 5899,   65686,  8, }, // America/St_Lucia
    {  220,  855,   65694,  9, }, // America/St_Thomas
    {  220, 5932,   65703, 10, }, // America/St_Vincent
    {  220, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  221, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Sint Maarten
    {  221, 2063,   65669,  9, }, // America/St_Johns
    {  221, 5882,   65678,  8, }, // America/St_Kitts
    {  221, 5899,   65686,  8, }, // America/St_Lucia
    {  221,  855,   65694,  9, }, // America/St_Thomas
    {  221, 5932,   65703, 10, }, // America/St_Vincent
    {  221, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  222, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Slovakia
    {  222, 2063,   65669,  9, }, // America/St_Johns
    {  222, 5882,   65678,  8, }, // America/St_Kitts
    {  222, 5899,   65686,  8, }, // America/St_Lucia
    {  222,  855,   65694,  9, }, // America/St_Thomas
    {  222, 5932,   65703, 10, }, // America/St_Vincent
    {  222, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  223, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Slovenia
    {  223, 2063,   65669,  9, }, // America/St_Johns
    {  223, 5882,   65678,  8, }, // America/St_Kitts
    {  223, 5899,   65686,  8, }, // America/St_Lucia
    {  223,  855,   65694,  9, }, // America/St_Thomas
    {  223, 5932,   65703, 10, }, // America/St_Vincent
    {  223, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  224, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Solomon Islands
    {  224, 2063,   65669,  9, }, // America/St_Johns
    {  224, 5882,   65678,  8, }, // America/St_Kitts
    {  224, 5899,   65686,  8, }, // America/St_Lucia
    {  224,  855,   65694,  9, }, // America/St_Thomas
    {  224, 5932,   65703, 10, }, // America/St_Vincent
    {  224, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  225, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/South Africa
    {  225, 2063,   65669,  9, }, // America/St_Johns
    {  225, 5882,   65678,  8, }, // America/St_Kitts
    {  225, 5899,   65686,  8, }, // America/St_Lucia
    {  225,  855,   65694,  9, }, // America/St_Thomas
    {  225, 5932,   65703, 10, }, // America/St_Vincent
    {  225, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  226, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/South Georgia and South Sandwich Islands
    {  226, 2063,   65669,  9, }, // America/St_Johns
    {  226, 5882,   65678,  8, }, // America/St_Kitts
    {  226, 5899,   65686,  8, }, // America/St_Lucia
    {  226,  855,   65694,  9, }, // America/St_Thomas
    {  226, 5932,   65703, 10, }, // America/St_Vincent
    {  226, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  227, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/South Sudan
    {  227, 2063,   65669,  9, }, // America/St_Johns
    {  227, 5882,   65678,  8, }, // America/St_Kitts
    {  227, 5899,   65686,  8, }, // America/St_Lucia
    {  227,  855,   65694,  9, }, // America/St_Thomas
    {  227, 5932,   65703, 10, }, // America/St_Vincent
    {  227, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  228, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Spain
    {  228, 2063,   65669,  9, }, // America/St_Johns
    {  228, 5882,   65678,  8, }, // America/St_Kitts
    {  228, 5899,   65686,  8, }, // America/St_Lucia
    {  228,  855,   65694,  9, }, // America/St_Thomas
    {  228, 5932,   65703, 10, }, // America/St_Vincent
    {  228, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  229, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Sudan
    {  229, 2063,   65669,  9, }, // America/St_Johns
    {  229, 5882,   65678,  8, }, // America/St_Kitts
    {  229, 5899,   65686,  8, }, // America/St_Lucia
    {  229,  855,   65694,  9, }, // America/St_Thomas
    {  229, 5932,   65703, 10, }, // America/St_Vincent
    {  229, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  230, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Sweden
    {  230, 2063,   65669,  9, }, // America/St_Johns
    {  230, 5882,   65678,  8, }, // America/St_Kitts
    {  230, 5899,   65686,  8, }, // America/St_Lucia
    {  230,  855,   65694,  9, }, // America/St_Thomas
    {  230, 5932,   65703, 10, }, // America/St_Vincent
    {  230, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  231, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Switzerland
    {  231, 2063,   65669,  9, }, // America/St_Johns
    {  231, 5882,   65678,  8, }, // America/St_Kitts
    {  231, 5899,   65686,  8, }, // America/St_Lucia
    {  231,  855,   65694,  9, }, // America/St_Thomas
    {  231, 5932,   65703, 10, }, // America/St_Vincent
    {  231, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  232, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Tanzania
    {  232, 2063,   65669,  9, }, // America/St_Johns
    {  232, 5882,   65678,  8, }, // America/St_Kitts
    {  232, 5899,   65686,  8, }, // America/St_Lucia
    {  232,  855,   65694,  9, }, // America/St_Thomas
    {  232, 5932,   65703, 10, }, // America/St_Vincent
    {  232, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  233, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Tokelau
    {  233, 2063,   65669,  9, }, // America/St_Johns
    {  233, 5882,   65678,  8, }, // America/St_Kitts
    {  233, 5899,   65686,  8, }, // America/St_Lucia
    {  233,  855,   65694,  9, }, // America/St_Thomas
    {  233, 5932,   65703, 10, }, // America/St_Vincent
    {  233, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  234, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Tonga
    {  234, 2063,   65669,  9, }, // America/St_Johns
    {  234, 5882,   65678,  8, }, // America/St_Kitts
    {  234, 5899,   65686,  8, }, // America/St_Lucia
    {  234,  855,   65694,  9, }, // America/St_Thomas
    {  234, 5932,   65703, 10, }, // America/St_Vincent
    {  234, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  235, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Trinidad and Tobago
    {  235, 2063,   65669,  9, }, // America/St_Johns
    {  235, 5882,   65678,  8, }, // America/St_Kitts
    {  235, 5899,   65686,  8, }, // America/St_Lucia
    {  235,  855,   65694,  9, }, // America/St_Thomas
    {  235, 5932,   65703, 10, }, // America/St_Vincent
    {  235, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  236, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Turks and Caicos Islands
    {  236, 2063,   65669,  9, }, // America/St_Johns
    {  236, 5882,   65678,  8, }, // America/St_Kitts
    {  236, 5899,   65686,  8, }, // America/St_Lucia
    {  236,  855,   65694,  9, }, // America/St_Thomas
    {  236, 5932,   65703, 10, }, // America/St_Vincent
    {  236, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  237, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Tuvalu
    {  237, 2063,   65669,  9, }, // America/St_Johns
    {  237, 5882,   65678,  8, }, // America/St_Kitts
    {  237, 5899,   65686,  8, }, // America/St_Lucia
    {  237,  855,   65694,  9, }, // America/St_Thomas
    {  237, 5932,   65703, 10, }, // America/St_Vincent
    {  237, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  238, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Uganda
    {  238, 2063,   65669,  9, }, // America/St_Johns
    {  238, 5882,   65678,  8, }, // America/St_Kitts
    {  238, 5899,   65686,  8, }, // America/St_Lucia
    {  238,  855,   65694,  9, }, // America/St_Thomas
    {  238, 5932,   65703, 10, }, // America/St_Vincent
    {  238, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  239, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Ukraine
    {  239, 2063,   65669,  9, }, // America/St_Johns
    {  239, 5882,   65678,  8, }, // America/St_Kitts
    {  239, 5899,   65686,  8, }, // America/St_Lucia
    {  239,  855,   65694,  9, }, // America/St_Thomas
    {  239, 5932,   65703, 10, }, // America/St_Vincent
    {  239, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  241, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/United Kingdom
    {  241, 2063,   65669,  9, }, // America/St_Johns
    {  241, 5882,   65678,  8, }, // America/St_Kitts
    {  241, 5899,   65686,  8, }, // America/St_Lucia
    {  241,  855,   65694,  9, }, // America/St_Thomas
    {  241, 5932,   65703, 10, }, // America/St_Vincent
    {  241, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  244, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Vanuatu
    {  244, 2063,   65669,  9, }, // America/St_Johns
    {  244, 5882,   65678,  8, }, // America/St_Kitts
    {  244, 5899,   65686,  8, }, // America/St_Lucia
    {  244,  855,   65694,  9, }, // America/St_Thomas
    {  244, 5932,   65703, 10, }, // America/St_Vincent
    {  244, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  245, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/world
    {  245, 2063,   65669,  9, }, // America/St_Johns
    {  245, 5882,   65678,  8, }, // America/St_Kitts
    {  245, 5899,   65686,  8, }, // America/St_Lucia
    {  245,  855,   65694,  9, }, // America/St_Thomas
    {  245, 5932,   65703, 10, }, // America/St_Vincent
    {  245, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  246, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Zambia
    {  246, 2063,   65669,  9, }, // America/St_Johns
    {  246, 5882,   65678,  8, }, // America/St_Kitts
    {  246, 5899,   65686,  8, }, // America/St_Lucia
    {  246,  855,   65694,  9, }, // America/St_Thomas
    {  246, 5932,   65703, 10, }, // America/St_Vincent
    {  246, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  247, 8526,   65656, 13, }, // America/St_Barthelemy English/Latin/Zimbabwe
    {  247, 2063,   65669,  9, }, // America/St_Johns
    {  247, 5882,   65678,  8, }, // America/St_Kitts
    {  247, 5899,   65686,  8, }, // America/St_Lucia
    {  247,  855,   65694,  9, }, // America/St_Thomas
    {  247, 5932,   65703, 10, }, // America/St_Vincent
    {  247, 6840,   65713,  9, }, // Atlantic/St_Helena
    {  248, 2951,    4381, 16, }, // America/Mexico_City English/Shavian/United Kingdom
    {  248, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  248, 7295,     643,  5, }, // Antarctica/Syowa
    {  248, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  248, 6647,    4413,  8, }, // Atlantic/Canary
    {  248, 1397,     767,  5, }, // Atlantic/Faroe
    {  248, 5048,    4421,  7, }, // Indian/Comoro
    {  248, 6697,     940,  9, }, // Pacific/Galapagos
    {  248, 3068,     957,  6, }, // Pacific/Kanton
    {  249,   14,       0,  6, }, // Africa/Asmara Erzya/Cyrillic/Russia
    {  249, 5185,       6,  8, }, // Africa/El_Aaiun
    {  249, 6888,      14,  4, }, // Africa/Lome
    {  249, 5290,      18,  9, }, // Africa/Ndjamena
    {  249, 4454,      27,  8, }, // Africa/Sao_Tome
    {  249, 4573,      35,  9, }, // America/Araguaina
    {  249,  270,      44,  7, }, // America/Argentina/Cordoba
    {  249, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  249, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  249, 4271,      70,  8, }, // America/Asuncion
    {  249,  237,      78,  8, }, // America/Atikokan
    {  249, 7623,      86, 17, }, // America/Bahia_Banderas
    {  249, 7646,     103,  5, }, // America/Belem
    {  249, 4380,     108,  6, }, // America/Bogota
    {  249, 7699,   38505,  5, }, // America/Boise
    {  249, 3887,     114,  6, }, // America/Cancun
    {  249, 2262,   65739,  6, }, // America/Chicago
    {  249, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  249, 3810,     133,  6, }, // America/Cuiaba
    {  249, 5742,     139,  7, }, // America/Curacao
    {  249,  805,    1798,  6, }, // America/Denver
    {  249, 7887,     146,  8, }, // America/Eirunepe
    {  249, 5789,    1889,  7, }, // America/Grenada
    {  249,  481,     154, 13, }, // America/Indiana/Knox
    {  249, 7979,     167, 16, }, // America/Indiana/Marengo
    {  249, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  249, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  249, 8056,     220, 14, }, // America/Indiana/Vevay
    {  249, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  249, 8104,     252, 16, }, // America/Indiana/Winamac
    {  249, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  249, 5951,     288, 22, }, // America/Lower_Princes
    {  249, 8171,     310,  6, }, // America/Maceio
    {  249, 2919,     316,  8, }, // America/Mazatlan
    {  249, 8238,     324,  6, }, // America/Merida
    {  249, 2951,    4381, 16, }, // America/Mexico_City
    {  249, 4410,     341, 12, }, // America/Miquelon
    {  249, 1852,     353, 19, }, // America/Noronha
    {  249, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  249, 8347,     392, 20, }, // America/North_Dakota/Center
    {  249, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  249,  393,     435,  4, }, // America/Nuuk
    {  249, 2358,    2380,  6, }, // America/Panama
    {  249, 8495,     439,  8, }, // America/Santarem
    {  249, 1880,     447,  9, }, // America/Sao_Paulo
    {  249, 6918,     456, 16, }, // America/Scoresbysund
    {  249, 8526,     472, 14, }, // America/St_Barthelemy
    {  249, 2063,     486, 10, }, // America/St_Johns
    {  249, 5882,     496,  9, }, // America/St_Kitts
    {  249, 5899,     505,  9, }, // America/St_Lucia
    {  249,  855,     514, 10, }, // America/St_Thomas
    {  249, 5932,     524, 11, }, // America/St_Vincent
    {  249, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  249, 7295,     643,  5, }, // Antarctica/Syowa
    {  249, 1431,   65745, 11, }, // Arctic/Longyearbyen
    {  249, 3626,    2834,  6, }, // Asia/Baghdad
    {  249, 3672,    2847,  4, }, // Asia/Baku
    {  249, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  249, 2706,   28072,  7, }, // Asia/Hong_Kong
    {  249, 4790,     704,  5, }, // Asia/Hovd
    {  249, 1187,     709,  9, }, // Asia/Kathmandu
    {  249,  994,     718,  7, }, // Asia/Kolkata
    {  249, 1213,     725,  5, }, // Asia/Macau
    {  249, 4248,   65756,  6, }, // Asia/Omsk
    {  249, 4427,    3211,  7, }, // Asia/Sakhalin
    {  249, 7245,    3218,  9, }, // Asia/Samarkand
    {  249, 3298,    3227,  4, }, // Asia/Seoul
    {  249, 1055,   28182,  6, }, // Asia/Shanghai
    {  249, 3282,   28188,  6, }, // Asia/Taipei
    {  249, 4800,    3264,  7, }, // Asia/Tashkent
    {  249, 2823,    3289,  5, }, // Asia/Tokyo
    {  249, 4591,   65762,  7, }, // Asia/Tomsk
    {  249, 1023,   65769, 10, }, // Asia/Ulaanbaatar
    {  249, 1161,     747,  6, }, // Asia/Urumqi
    {  249, 1237,     753,  6, }, // Asia/Yangon
    {  249, 5690,   37289,  7, }, // Atlantic/Bermuda
    {  249, 6647,    4413,  8, }, // Atlantic/Canary
    {  249, 1397,     767,  5, }, // Atlantic/Faroe
    {  249, 8754,   28285,  7, }, // Atlantic/Madeira
    {  249, 2750,   28292,  9, }, // Atlantic/Reykjavik
    {  249, 6840,     773, 10, }, // Atlantic/St_Helena
    {  249, 6460,    3590,  9, }, // Europe/Amsterdam
    {  249, 6235,    3599,  7, }, // Europe/Andorra
    {  249, 2302,   65779,  5, }, // Europe/Athens
    {  249, 6355,    3618,  7, }, // Europe/Belgrade
    {  249, 4776,    3625,  6, }, // Europe/Berlin
    {  249, 6507,    3631, 10, }, // Europe/Bratislava
    {  249, 2169,   28384,  8, }, // Europe/Brussels
    {  249, 3947,    3649,  8, }, // Europe/Bucharest
    {  249, 3825,    3657,  8, }, // Europe/Budapest
    {  249, 8790,     799,  8, }, // Europe/Busingen
    {  249, 2585,     807,  8, }, // Europe/Chisinau
    {  249, 6308,   28400, 10, }, // Europe/Copenhagen
    {  249, 2340,    3705,  6, }, // Europe/Dublin
    {  249, 6631,   28410,  9, }, // Europe/Helsinki
    {  249, 8855,    3766,  5, }, // Europe/Kirov
    {  249, 2529,    3771,  4, }, // Europe/Kyiv
    {  249, 3232,    3775,  8, }, // Europe/Lisbon
    {  249, 6525,   28443,  7, }, // Europe/Ljubljana
    {  249, 2503,    3792,  6, }, // Europe/London
    {  249, 6384,   28450, 10, }, // Europe/Luxembourg
    {  249, 4911,    3809,  6, }, // Europe/Madrid
    {  249, 6416,   28460,  6, }, // Europe/Malta
    {  249, 3712,   65784,  7, }, // Europe/Minsk
    {  249, 6429,    3834,  6, }, // Europe/Monaco
    {  249, 3556,   65791,  6, }, // Europe/Moscow
    {  249, 6477,    3846,  4, }, // Europe/Oslo
    {  249, 4303,    3850,  5, }, // Europe/Paris
    {  249, 6443,    3855,  9, }, // Europe/Podgorica
    {  249, 6294,    3864,  5, }, // Europe/Prague
    {  249, 8868,    3869,  4, }, // Europe/Riga
    {  249, 6343,    3873,  3, }, // Europe/Rome
    {  249, 4350,    3876,  6, }, // Europe/Samara
    {  249, 6489,    3882, 10, }, // Europe/San_Marino
    {  249, 6264,    3892,  7, }, // Europe/Sarajevo
    {  249, 4470,    3899,  7, }, // Europe/Saratov
    {  249, 8880,   28484, 11, }, // Europe/Simferopol
    {  249, 6402,   28495,  6, }, // Europe/Skopje
    {  249, 6618,   28501,  5, }, // Europe/Sofia
    {  249, 6542,   28506,  9, }, // Europe/Stockholm
    {  249, 8898,    3934,  6, }, // Europe/Tallinn
    {  249, 6221,    3940,  6, }, // Europe/Tirane
    {  249, 6371,    3955,  5, }, // Europe/Vaduz
    {  249, 6586,    3960,  7, }, // Europe/Vatican
    {  249, 6250,    3967,  4, }, // Europe/Vienna
    {  249, 8930,   28524,  7, }, // Europe/Vilnius
    {  249, 3209,    3987,  7, }, // Europe/Warsaw
    {  249, 6280,    3994,  6, }, // Europe/Zagreb
    {  249, 6559,   28531,  5, }, // Europe/Zurich
    {  249, 5048,    4421,  7, }, // Indian/Comoro
    {  249, 7260,     896,  4, }, // Indian/Mahe
    {  249, 7211,     900,  7, }, // Indian/Reunion
    {  249, 3176,     922,  5, }, // Pacific/Chuuk
    {  249, 6697,     940,  9, }, // Pacific/Galapagos
    {  249, 3068,     957,  6, }, // Pacific/Kanton
    {  249, 7117,    1028,  6, }, // Pacific/Noumea
    {  249, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  249, 7405,    1068, 15, }, // Pacific/Wallis
    {  250, 6807,   65797,  7, }, // Africa/Abidjan Esperanto/Latin/world
    {  250, 6779,   65804,  5, }, // Africa/Accra
    {  250, 5078,   65809,  9, }, // Africa/Addis_Ababa
    {  250, 7420,   65818,  6, }, // Africa/Algiers
    {  250,   14,   65824,  6, }, // Africa/Asmara
    {  250, 5276,   65830,  5, }, // Africa/Bangui
    {  250, 6765,   65835,  7, }, // Africa/Banjul
    {  250, 7435,   65842,  6, }, // Africa/Bissau
    {  250, 5306,   65848,  9, }, // Africa/Brazzaville
    {  250, 4941,   65857,  9, }, // Africa/Bujumbura
    {  250, 2322,    5363,  5, }, // Africa/Cairo
    {  250, 4136,   65866, 10, }, // Africa/Casablanca
    {  250, 7449,   65876,  5, }, // Africa/Ceuta
    {  250, 6792,   65881,  8, }, // Africa/Conakry
    {  250, 6859,   65889,  6, }, // Africa/Dakar
    {  250, 5149,   65895, 10, }, // Africa/Dar_es_Salaam
    {  250, 5062,   65905,  7, }, // Africa/Djibouti
    {  250, 5262,   65912,  6, }, // Africa/Douala
    {  250, 5185,   65918,  5, }, // Africa/El_Aaiun
    {  250, 6872,   65923,  8, }, // Africa/Freetown
    {  250, 4925,   65931,  8, }, // Africa/Gaborone
    {  250, 5034,   65939,  7, }, // Africa/Harare
    {  250, 4498,   65946, 12, }, // Africa/Johannesburg
    {  250, 4518,   65958,  5, }, // Africa/Juba
    {  250, 5170,   65963,  7, }, // Africa/Kampala
    {  250, 4543,   65970,  7, }, // Africa/Khartoum
    {  250, 4992,   65977,  6, }, // Africa/Kigali
    {  250, 5325,   65983,  7, }, // Africa/Kinshasa
    {  250, 4763,   65990,  6, }, // Africa/Lagos
    {  250, 5355,   65996,  9, }, // Africa/Libreville
    {  250, 6888,   66005,  5, }, // Africa/Lome
    {  250, 5230,   66010,  6, }, // Africa/Luanda
    {  250, 4958,   66016,  9, }, // Africa/Lubumbashi
    {  250, 5020,   66025,  6, }, // Africa/Lusaka
    {  250, 5216,   66031,  7, }, // Africa/Maseru
    {  250, 5201,   66038,  7, }, // Africa/Mbabane
    {  250, 5132,   66045,  8, }, // Africa/Mogadishu
    {  250, 7053,   66053,  8, }, // Africa/Monrovia
    {  250, 3872,   66061,  8, }, // Africa/Nairobi
    {  250, 5290,   66069,  8, }, // Africa/Ndjamena
    {  250, 5373,   66077,  7, }, // Africa/Niamey
    {  250, 6822,   66084,  8, }, // Africa/Nouakchott
    {  250, 6746,   66092,  9, }, // Africa/Ouagadougou
    {  250, 5244,   66101,  9, }, // Africa/Porto-Novo
    {  250, 4454,   66110,  8, }, // Africa/Sao_Tome
    {  250, 2868,   66118,  7, }, // Africa/Tripoli
    {  250, 6573,   66125,  6, }, // Africa/Tunis
    {  250, 4171,   66131,  8, }, // Africa/Windhoek
    {  250, 5626,   66139,  7, }, // America/Anguilla
    {  250, 5643,   66146,  7, }, // America/Antigua
    {  250, 4573,      35,  9, }, // America/Araguaina
    {  250,  166,   66153,  7, }, // America/Argentina/Buenos_Aires
    {  250,  270,   66160,  7, }, // America/Argentina/Cordoba
    {  250, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  250, 7520,   66167,  9, }, // America/Argentina/Salta
    {  250, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  250, 5659,   66176,  5, }, // America/Aruba
    {  250, 4271,   66181,  9, }, // America/Asuncion
    {  250,  237,      78,  8, }, // America/Atikokan
    {  250, 3698,   66190,  5, }, // America/Bahia
    {  250, 7623,      86, 17, }, // America/Bahia_Banderas
    {  250, 5673,   66195,  7, }, // America/Barbados
    {  250, 7646,   66202,  6, }, // America/Belem
    {  250, 5426,   66208,  6, }, // America/Belize
    {  250, 4380,   66214,  6, }, // America/Bogota
    {  250, 7713,   66220, 14, }, // America/Cambridge_Bay
    {  250, 3887,   66234,  7, }, // America/Cancun
    {  250, 4713,   66241,  8, }, // America/Caracas
    {  250, 4364,   66249,  6, }, // America/Cayenne
    {  250, 5515,   66255,  8, }, // America/Cayman
    {  250, 2262,   66263,  6, }, // America/Chicago
    {  250, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  250, 5441,   66269,  9, }, // America/Costa_Rica
    {  250, 3810,     133,  6, }, // America/Cuiaba
    {  250, 5742,   66278,  7, }, // America/Curacao
    {  250,  805,   66285,  7, }, // America/Denver
    {  250, 3484,   66292,  8, }, // America/Detroit
    {  250, 5758,   66300,  8, }, // America/Dominica
    {  250,  893,   66308,  9, }, // America/Edmonton
    {  250, 7887,     146,  8, }, // America/Eirunepe
    {  250, 5460,   66317,  9, }, // America/El_Salvador
    {  250, 7924,   66326,  9, }, // America/Fortaleza
    {  250, 4631,   66335, 12, }, // America/Grand_Turk
    {  250, 5789,   66347,  7, }, // America/Grenada
    {  250, 5805,   66354,  9, }, // America/Guadeloupe
    {  250, 3779,   66363,  9, }, // America/Guatemala
    {  250, 6951,   66372,  6, }, // America/Guyana
    {  250, 1941,   66378,  9, }, // America/Halifax
    {  250, 2283,   66387,  6, }, // America/Havana
    {  250,  348,   66393, 21, }, // America/Indiana/Indianapolis
    {  250,  481,   66414, 14, }, // America/Indiana/Knox
    {  250, 7979,   66428, 17, }, // America/Indiana/Marengo
    {  250, 8003,   66445, 20, }, // America/Indiana/Petersburg
    {  250, 8030,   66465, 19, }, // America/Indiana/Tell_City
    {  250, 8056,   66484, 15, }, // America/Indiana/Vevay
    {  250, 8078,   66499, 19, }, // America/Indiana/Vincennes
    {  250, 8104,   66518, 17, }, // America/Indiana/Winamac
    {  250,  660,   66535,  8, }, // America/Iqaluit
    {  250, 2801,   66543,  7, }, // America/Jamaica
    {  250, 8143,   66550, 20, }, // America/Kentucky/Monticello
    {  250, 7169,   66570,  4, }, // America/Lima
    {  250, 3258,   66574, 11, }, // America/Los_Angeles
    {  250, 5951,     288, 22, }, // America/Lower_Princes
    {  250, 8171,     310,  6, }, // America/Maceio
    {  250, 8186,   66585,  7, }, // America/Managua
    {  250, 1910,   66592,  7, }, // America/Manaus
    {  250, 5916,   66599,  8, }, // America/Marigot
    {  250, 5824,   66607,  9, }, // America/Martinique
    {  250, 2919,     316,  8, }, // America/Mazatlan
    {  250, 8238,   66616,  6, }, // America/Merida
    {  250, 2951,   66622, 10, }, // America/Mexico_City
    {  250, 4410,   66632,  8, }, // America/Miquelon
    {  250, 8272,   66640,  8, }, // America/Moncton
    {  250, 8288,   66648,  9, }, // America/Monterrey
    {  250, 5843,   66657,  9, }, // America/Montserrat
    {  250, 5500,   66666,  6, }, // America/Nassau
    {  250, 2381,   66672,  9, }, // America/New_York
    {  250, 1852,     353, 19, }, // America/Noronha
    {  250, 8319,   66681, 20, }, // America/North_Dakota/Beulah
    {  250, 8347,   66701, 20, }, // America/North_Dakota/Center
    {  250, 8375,   66721, 23, }, // America/North_Dakota/New_Salem
    {  250,  393,   66744,  4, }, // America/Nuuk
    {  250, 2358,   66748,  6, }, // America/Panama
    {  250, 2975,   66754,  7, }, // America/Phoenix
    {  250, 3964,   66761, 11, }, // America/Port-au-Prince
    {  250, 5973,   66772, 10, }, // America/Port_of_Spain
    {  250, 5862,   66782, 10, }, // America/Puerto_Rico
    {  250, 8495,     439,  8, }, // America/Santarem
    {  250, 6130,   66792, 14, }, // America/Santo_Domingo
    {  250, 1880,   66806,  8, }, // America/Sao_Paulo
    {  250, 6918,     456, 16, }, // America/Scoresbysund
    {  250, 8526,   66814, 17, }, // America/St_Barthelemy
    {  250, 2063,     486, 10, }, // America/St_Johns
    {  250, 5882,   66831, 17, }, // America/St_Kitts
    {  250, 5899,   66848, 12, }, // America/St_Lucia
    {  250,  855,   66860, 13, }, // America/St_Thomas
    {  250, 5932,   66873, 15, }, // America/St_Vincent
    {  250, 5480,   66888, 11, }, // America/Tegucigalpa
    {  250, 5775,   29116,  7, }, // America/Thule
    {  250, 2095,   66899,  9, }, // America/Vancouver
    {  250,  734,   66908,  8, }, // America/Winnipeg
    {  250, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  250, 8586,   66916, 14, }, // Antarctica/Macquarie
    {  250, 7295,     643,  5, }, // Antarctica/Syowa
    {  250, 1431,   66930, 11, }, // Arctic/Longyearbyen
    {  250, 5589,   66941,  5, }, // Asia/Aden
    {  250, 5414,   66946,  6, }, // Asia/Almaty
    {  250, 3987,   66952,  5, }, // Asia/Amman
    {  250, 5530,    8253,  6, }, // Asia/Anadyr
    {  250, 5542,     683,  5, }, // Asia/Aqtau
    {  250, 5387,    8259,  6, }, // Asia/Aqtobe
    {  250,  966,   66957,  8, }, // Asia/Ashgabat
    {  250, 8642,    8265,  6, }, // Asia/Atyrau
    {  250, 3626,   66965,  7, }, // Asia/Baghdad
    {  250, 5553,   66972,  7, }, // Asia/Bahrain
    {  250, 3672,   66979,  5, }, // Asia/Baku
    {  250, 4485,   66984,  7, }, // Asia/Bangkok
    {  250, 4105,   66991,  7, }, // Asia/Beirut
    {  250, 3797,   66998,  7, }, // Asia/Bishkek
    {  250, 6008,   67005,  7, }, // Asia/Brunei
    {  250, 4620,   67012,  4, }, // Asia/Chita
    {  250, 4530,    6295,  7, }, // Asia/Colombo
    {  250, 4559,   29141,  7, }, // Asia/Damascus
    {  250, 1095,     386,  4, }, // Asia/Dhaka
    {  250, 6211,   67016,  4, }, // Asia/Dili
    {  250, 3615,   67020,  9, }, // Asia/Dubai
    {  250, 6178,   67029,  8, }, // Asia/Dushanbe
    {  250, 8669,   67037,  5, }, // Asia/Gaza
    {  250, 4814,   67042,  7, }, // Asia/Hebron
    {  250, 1261,   67049,  8, }, // Asia/Ho_Chi_Minh
    {  250, 2706,   67057,  8, }, // Asia/Hong_Kong
    {  250, 4790,   67065,  4, }, // Asia/Hovd
    {  250, 4203,   67069,  8, }, // Asia/Irkutsk
    {  250, 7025,   67077,  7, }, // Asia/Jakarta
    {  250, 1292,   67084, 10, }, // Asia/Jerusalem
    {  250, 3579,   67094,  6, }, // Asia/Kabul
    {  250, 4335,   67100,  8, }, // Asia/Kamchatka
    {  250, 4258,   67108,  7, }, // Asia/Karachi
    {  250, 1187,   67115,  9, }, // Asia/Kathmandu
    {  250, 8679,   67124,  7, }, // Asia/Khandyga
    {  250,  994,   67131,  7, }, // Asia/Kolkata
    {  250, 4216,   67138, 12, }, // Asia/Krasnoyarsk
    {  250, 4878,   67150, 12, }, // Asia/Kuala_Lumpur
    {  250, 5566,   67162,  7, }, // Asia/Kuwait
    {  250, 1213,    8384,  5, }, // Asia/Macau
    {  250, 7182,   67169,  6, }, // Asia/Manila
    {  250, 6939,   67175,  7, }, // Asia/Muscat
    {  250, 2556,   67182,  7, }, // Asia/Nicosia
    {  250, 8693,   67189, 12, }, // Asia/Novokuznetsk
    {  250, 4154,   67201, 12, }, // Asia/Novosibirsk
    {  250, 4248,   67213,  5, }, // Asia/Omsk
    {  250, 7145,   67218,  5, }, // Asia/Oral
    {  250, 6980,   67223,  8, }, // Asia/Phnom_Penh
    {  250, 4233,   67231, 10, }, // Asia/Pyongyang
    {  250, 5578,   67241,  6, }, // Asia/Qatar
    {  250, 8726,    8423,  8, }, // Asia/Qostanay
    {  250, 4288,   67247,  9, }, // Asia/Qyzylorda
    {  250, 3603,   67256,  5, }, // Asia/Riyadh
    {  250, 4427,   67261,  8, }, // Asia/Sakhalin
    {  250, 7245,   67269, 10, }, // Asia/Samarkand
    {  250, 3298,   67279,  5, }, // Asia/Seoul
    {  250, 1055,   67284,  7, }, // Asia/Shanghai
    {  250, 3319,   67291,  9, }, // Asia/Singapore
    {  250, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {  250, 3282,   67300,  6, }, // Asia/Taipei
    {  250, 4800,   67306,  8, }, // Asia/Tashkent
    {  250, 3934,   67314,  7, }, // Asia/Tbilisi
    {  250, 2774,   67321,  8, }, // Asia/Tehran
    {  250, 1319,   67329,  6, }, // Asia/Thimphu
    {  250, 2823,    4996,  5, }, // Asia/Tokyo
    {  250, 1023,   67335, 10, }, // Asia/Ulaanbaatar
    {  250, 1161,   67345,  7, }, // Asia/Urumqi
    {  250, 8740,   67352,  7, }, // Asia/Ust-Nera
    {  250, 6996,   67359,  9, }, // Asia/Vientiane
    {  250, 4729,   67368, 12, }, // Asia/Vladivostok
    {  250, 4847,   67380,  8, }, // Asia/Yakutsk
    {  250, 1237,   67388,  7, }, // Asia/Yangon
    {  250, 3902,   67395, 14, }, // Asia/Yekaterinburg
    {  250, 3766,   67409,  7, }, // Asia/Yerevan
    {  250, 3682,   67416,  6, }, // Atlantic/Azores
    {  250, 5690,   67422,  8, }, // Atlantic/Bermuda
    {  250, 6647,   67430,  8, }, // Atlantic/Canary
    {  250, 3746,   67438,  9, }, // Atlantic/Cape_Verde
    {  250, 1397,   67447,  6, }, // Atlantic/Faroe
    {  250, 8754,   67453,  7, }, // Atlantic/Madeira
    {  250, 2750,   67460, 10, }, // Atlantic/Reykjavik
    {  250, 7272,   67470, 11, }, // Atlantic/South_Georgia
    {  250, 6840,   67481, 13, }, // Atlantic/St_Helena
    {  250, 6663,   67494,  8, }, // Atlantic/Stanley
    {  250, 1672,   67502,  8, }, // Australia/Adelaide
    {  250, 1637,   67510,  8, }, // Australia/Brisbane
    {  250, 1585,   67518,  7, }, // Australia/Darwin
    {  250, 1518,   67525,  7, }, // Australia/Hobart
    {  250, 1729,   67532,  8, }, // Australia/Melbourne
    {  250, 1764,   67540,  5, }, // Australia/Perth
    {  250, 1465,   67545,  7, }, // Australia/Sydney
    {  250, 6460,   67552, 10, }, // Europe/Amsterdam
    {  250, 6235,   67562,  6, }, // Europe/Andorra
    {  250, 3639,   67568,  9, }, // Europe/Astrakhan
    {  250, 2302,   67577,  5, }, // Europe/Athens
    {  250, 6355,   67582,  8, }, // Europe/Belgrade
    {  250, 4776,   67590,  7, }, // Europe/Berlin
    {  250, 6507,   67597, 10, }, // Europe/Bratislava
    {  250, 2169,   67607,  7, }, // Europe/Brussels
    {  250, 3947,   67614,  9, }, // Europe/Bucharest
    {  250, 3825,   67623,  9, }, // Europe/Budapest
    {  250, 8790,   67632, 21, }, // Europe/Busingen
    {  250, 2585,   67653,  8, }, // Europe/Chisinau
    {  250, 6308,   67661,  9, }, // Europe/Copenhagen
    {  250, 2340,   67670,  7, }, // Europe/Dublin
    {  250, 6326,   67677, 10, }, // Europe/Gibraltar
    {  250, 8806,   67687,  9, }, // Europe/Guernsey
    {  250, 6631,   67696,  8, }, // Europe/Helsinki
    {  250, 8822,   67704, 11, }, // Europe/Isle_of_Man
    {  250, 1132,   67715,  9, }, // Europe/Istanbul
    {  250, 8841,   67724,  7, }, // Europe/Jersey
    {  250, 3998,   67731, 12, }, // Europe/Kaliningrad
    {  250, 2529,   67743,  5, }, // Europe/Kyiv
    {  250, 3232,   67748,  7, }, // Europe/Lisbon
    {  250, 6525,   67755,  9, }, // Europe/Ljubljana
    {  250, 2503,   67764,  7, }, // Europe/London
    {  250, 6384,   67771, 11, }, // Europe/Luxembourg
    {  250, 4911,   67782,  7, }, // Europe/Madrid
    {  250, 6416,   67789,  5, }, // Europe/Malta
    {  250, 3712,   67794,  6, }, // Europe/Minsk
    {  250, 6429,    8840,  6, }, // Europe/Monaco
    {  250, 3556,   67800,  6, }, // Europe/Moscow
    {  250, 4303,   67806,  6, }, // Europe/Paris
    {  250, 6443,   67812,  9, }, // Europe/Podgorica
    {  250, 6294,   67821,  5, }, // Europe/Prague
    {  250, 8868,   67826,  4, }, // Europe/Riga
    {  250, 6343,   67830,  4, }, // Europe/Rome
    {  250, 6489,   67834,  9, }, // Europe/San_Marino
    {  250, 8880,   67843, 11, }, // Europe/Simferopol
    {  250, 6402,   67854,  6, }, // Europe/Skopje
    {  250, 6618,   67860,  5, }, // Europe/Sofia
    {  250, 6542,   67865,  9, }, // Europe/Stockholm
    {  250, 8898,   67874,  6, }, // Europe/Tallinn
    {  250, 6221,   67880,  6, }, // Europe/Tirane
    {  250, 8913,   67886, 10, }, // Europe/Ulyanovsk
    {  250, 6371,   67896,  6, }, // Europe/Vaduz
    {  250, 6586,   29393,  8, }, // Europe/Vatican
    {  250, 6250,   67902,  5, }, // Europe/Vienna
    {  250, 8930,   67907,  5, }, // Europe/Vilnius
    {  250, 4746,   67912, 10, }, // Europe/Volgograd
    {  250, 3209,   67922,  8, }, // Europe/Warsaw
    {  250, 6280,   67930,  7, }, // Europe/Zagreb
    {  250, 6559,   67937,  6, }, // Europe/Zurich
    {  250, 6966,   67943,  7, }, // Indian/Chagos
    {  250, 6065,   67950, 15, }, // Indian/Christmas
    {  250, 6082,   67965, 12, }, // Indian/Cocos
    {  250, 5048,   67977,  7, }, // Indian/Comoro
    {  250, 6680,   67984, 10, }, // Indian/Kerguelen
    {  250, 7260,     896,  4, }, // Indian/Mahe
    {  250, 7069,   67994,  8, }, // Indian/Maldives
    {  250, 4088,   68002,  8, }, // Indian/Mauritius
    {  250, 5117,   68010,  6, }, // Indian/Mayotte
    {  250, 7211,   68016,  6, }, // Indian/Reunion
    {  250, 4441,   68022,  4, }, // Pacific/Apia
    {  250, 3009,   68026,  8, }, // Pacific/Auckland
    {  250, 3034,   68034,  7, }, // Pacific/Chatham
    {  250, 3176,   68041,  4, }, // Pacific/Chuuk
    {  250, 2239,   68045, 10, }, // Pacific/Easter
    {  250, 3921,   68055,  5, }, // Pacific/Fiji
    {  250, 7343,   68060,  9, }, // Pacific/Funafuti
    {  250, 6697,   68069,  9, }, // Pacific/Galapagos
    {  250, 6037,   68078,  5, }, // Pacific/Guam
    {  250, 3068,   68083, 13, }, // Pacific/Kanton
    {  250, 4070,   68096, 13, }, // Pacific/Marquesas
    {  250, 8945,   68109, 13, }, // Pacific/Midway
    {  250, 7103,   68122,  5, }, // Pacific/Nauru
    {  250, 7132,   68127,  4, }, // Pacific/Niue
    {  250, 4187,   68131, 13, }, // Pacific/Norfolk
    {  250, 7117,   68144,  5, }, // Pacific/Noumea
    {  250, 3145,   68149,  8, }, // Pacific/Pago_Pago
    {  250, 7155,   68157,  6, }, // Pacific/Palau
    {  250, 7194,   68163, 15, }, // Pacific/Pitcairn
    {  250, 3115,    9106,  6, }, // Pacific/Pohnpei
    {  250, 6095,   68178,  9, }, // Pacific/Rarotonga
    {  250, 6050,   68187,  7, }, // Pacific/Saipan
    {  250, 7312,   68194,  7, }, // Pacific/Tahiti
    {  250, 6731,   68201,  6, }, // Pacific/Tarawa
    {  250, 7392,   68207, 10, }, // Pacific/Wake
    {  250, 7405,   68217,  6, }, // Pacific/Wallis
    {  251, 5078,    4428, 11, }, // Africa/Addis_Ababa Estonian/Latin/Estonia
    {  251, 7420,   68223,  6, }, // Africa/Algiers
    {  251,   14,       0,  6, }, // Africa/Asmara
    {  251, 2322,    5363,  5, }, // Africa/Cairo
    {  251, 5185,       6,  8, }, // Africa/El_Aaiun
    {  251, 4543,   68229,  6, }, // Africa/Khartoum
    {  251, 6888,      14,  4, }, // Africa/Lome
    {  251, 5132,   28885,  8, }, // Africa/Mogadishu
    {  251, 5290,      18,  9, }, // Africa/Ndjamena
    {  251, 4454,      27,  8, }, // Africa/Sao_Tome
    {  251, 4573,      35,  9, }, // America/Araguaina
    {  251,  270,      44,  7, }, // America/Argentina/Cordoba
    {  251, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  251, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  251, 4271,      70,  8, }, // America/Asuncion
    {  251,  237,      78,  8, }, // America/Atikokan
    {  251, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  251, 7646,     103,  5, }, // America/Belem
    {  251, 4380,     108,  6, }, // America/Bogota
    {  251, 3887,     114,  6, }, // America/Cancun
    {  251, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  251, 3810,     133,  6, }, // America/Cuiaba
    {  251, 5742,     139,  7, }, // America/Curacao
    {  251, 7887,     146,  8, }, // America/Eirunepe
    {  251, 2283,   68235,  7, }, // America/Havana
    {  251,  481,     154, 13, }, // America/Indiana/Knox
    {  251, 7979,     167, 16, }, // America/Indiana/Marengo
    {  251, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  251, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  251, 8056,     220, 14, }, // America/Indiana/Vevay
    {  251, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  251, 8104,     252, 16, }, // America/Indiana/Winamac
    {  251, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  251, 5951,     288, 22, }, // America/Lower_Princes
    {  251, 8171,     310,  6, }, // America/Maceio
    {  251, 2919,     316,  8, }, // America/Mazatlan
    {  251, 8238,     324,  6, }, // America/Merida
    {  251, 2951,    4391,  6, }, // America/Mexico_City
    {  251, 4410,     341, 12, }, // America/Miquelon
    {  251, 1852,     353, 19, }, // America/Noronha
    {  251, 8319,   68242, 20, }, // America/North_Dakota/Beulah
    {  251, 8347,   68262, 20, }, // America/North_Dakota/Center
    {  251, 8375,   68282, 23, }, // America/North_Dakota/New_Salem
    {  251,  393,     435,  4, }, // America/Nuuk
    {  251, 8495,     439,  8, }, // America/Santarem
    {  251, 1880,     447,  9, }, // America/Sao_Paulo
    {  251, 6918,     456, 16, }, // America/Scoresbysund
    {  251, 8526,   29041, 16, }, // America/St_Barthelemy
    {  251, 2063,   29057, 12, }, // America/St_Johns
    {  251, 5882,   29069, 11, }, // America/St_Kitts
    {  251, 5899,   37943, 11, }, // America/St_Lucia
    {  251,  855,   46153, 12, }, // America/St_Thomas
    {  251, 5932,   29103, 13, }, // America/St_Vincent
    {  251, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  251, 7295,     643,  5, }, // Antarctica/Syowa
    {  251, 5414,   68305,  6, }, // Asia/Almaty
    {  251, 5530,   68311,  6, }, // Asia/Anadyr
    {  251, 5542,     683,  5, }, // Asia/Aqtau
    {  251, 5387,   68317,  6, }, // Asia/Aqtobe
    {  251,  966,   46182,  7, }, // Asia/Ashgabat
    {  251, 8642,   68323,  6, }, // Asia/Atyrau
    {  251, 3626,    4802,  6, }, // Asia/Baghdad
    {  251, 5553,    4808,  7, }, // Asia/Bahrain
    {  251, 3672,   68329,  5, }, // Asia/Baku
    {  251, 3797,   35493,  6, }, // Asia/Bishkek
    {  251, 4620,   68334,  5, }, // Asia/Chita
    {  251, 4559,    4841,  8, }, // Asia/Damascus
    {  251, 6178,   35506,  7, }, // Asia/Dushanbe
    {  251, 1261,   68339, 11, }, // Asia/Ho_Chi_Minh
    {  251, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  251, 4790,     704,  5, }, // Asia/Hovd
    {  251, 1292,   68350, 11, }, // Asia/Jerusalem
    {  251, 4335,   68361,  9, }, // Asia/Kamchatka
    {  251, 1187,    6367,  8, }, // Asia/Kathmandu
    {  251, 8679,   68370,  7, }, // Asia/Khandyga
    {  251,  994,     718,  7, }, // Asia/Kolkata
    {  251, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  251, 5566,   68377,  6, }, // Asia/Kuwait
    {  251, 1213,    4961,  5, }, // Asia/Macau
    {  251, 6939,   68383,  6, }, // Asia/Muscat
    {  251, 2556,    6387,  7, }, // Asia/Nicosia
    {  251, 5578,    4972,  5, }, // Asia/Qatar
    {  251, 8726,    8423,  8, }, // Asia/Qostanay
    {  251, 4288,   68389,  9, }, // Asia/Qyzylorda
    {  251, 3603,   68398,  8, }, // Asia/Riyadh
    {  251, 4427,   68406,  8, }, // Asia/Sakhalin
    {  251, 3298,   62796,  4, }, // Asia/Seoul
    {  251, 3319,   21561,  8, }, // Asia/Singapore
    {  251, 4316,   68414, 13, }, // Asia/Srednekolymsk
    {  251, 4800,   35627,  7, }, // Asia/Tashkent
    {  251, 3934,   68427,  8, }, // Asia/Tbilisi
    {  251, 2774,    8495,  7, }, // Asia/Tehran
    {  251, 2823,   68435,  5, }, // Asia/Tokyo
    {  251, 1161,     747,  6, }, // Asia/Urumqi
    {  251, 4847,    8526,  7, }, // Asia/Yakutsk
    {  251, 1237,     753,  6, }, // Asia/Yangon
    {  251, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  251, 3766,    8551,  7, }, // Asia/Yerevan
    {  251, 3682,   68440,  8, }, // Atlantic/Azores
    {  251, 6647,   68448, 14, }, // Atlantic/Canary
    {  251, 3746,   68462, 15, }, // Atlantic/Cape_Verde
    {  251, 1397,   68477, 12, }, // Atlantic/Faroe
    {  251, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {  251, 7272,   68489, 13, }, // Atlantic/South_Georgia
    {  251, 6840,   46383, 12, }, // Atlantic/St_Helena
    {  251, 3639,   35682,  8, }, // Europe/Astrakhan
    {  251, 2302,   68502,  6, }, // Europe/Athens
    {  251, 6355,   29315,  7, }, // Europe/Belgrade
    {  251, 4776,   68508,  7, }, // Europe/Berlin
    {  251, 2169,   23425,  7, }, // Europe/Brussels
    {  251, 3947,   29329,  8, }, // Europe/Bucharest
    {  251, 8790,     799,  8, }, // Europe/Busingen
    {  251, 2585,     807,  8, }, // Europe/Chisinau
    {  251, 6308,   68515, 11, }, // Europe/Copenhagen
    {  251, 6631,   68526,  8, }, // Europe/Helsinki
    {  251, 8822,   68534,  9, }, // Europe/Isle_of_Man
    {  251, 1132,   23484,  8, }, // Europe/Istanbul
    {  251, 2529,   68543,  5, }, // Europe/Kyiv
    {  251, 3232,    5139,  8, }, // Europe/Lisbon
    {  251, 6601,   68548, 13, }, // Europe/Mariehamn
    {  251, 3556,   23539,  6, }, // Europe/Moscow
    {  251, 4303,   68561,  6, }, // Europe/Paris
    {  251, 6294,   38246,  5, }, // Europe/Prague
    {  251, 8868,   68567,  4, }, // Europe/Riga
    {  251, 6343,   68571,  5, }, // Europe/Rome
    {  251, 6221,     819,  6, }, // Europe/Tirane
    {  251, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {  251, 6586,    6744,  7, }, // Europe/Vatican
    {  251, 6250,   68576,  4, }, // Europe/Vienna
    {  251, 3209,   68580,  8, }, // Europe/Warsaw
    {  251, 6559,    5217,  6, }, // Europe/Zurich
    {  251, 6065,   68588,  9, }, // Indian/Christmas
    {  251, 6082,   68597, 12, }, // Indian/Cocos
    {  251, 5048,    4421,  7, }, // Indian/Comoro
    {  251, 7260,     896,  4, }, // Indian/Mahe
    {  251, 7069,   68609,  9, }, // Indian/Maldives
    {  251, 7211,     900,  7, }, // Indian/Reunion
    {  251, 3176,     922,  5, }, // Pacific/Chuuk
    {  251, 2239,   68618, 13, }, // Pacific/Easter
    {  251, 3921,   35874,  5, }, // Pacific/Fiji
    {  251, 6697,     940,  9, }, // Pacific/Galapagos
    {  251, 2725,    5251,  8, }, // Pacific/Honolulu
    {  251, 3068,   68631, 10, }, // Pacific/Kanton
    {  251, 4070,   68641, 12, }, // Pacific/Marquesas
    {  251, 7117,    1028,  6, }, // Pacific/Noumea
    {  251, 7155,   68653,  5, }, // Pacific/Palau
    {  251, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  251, 7405,    1068, 15, }, // Pacific/Wallis
    {  252,   14,       0,  6, }, // Africa/Asmara Ewe/Latin/Ghana
    {  252, 5185,       6,  8, }, // Africa/El_Aaiun
    {  252, 6888,      14,  4, }, // Africa/Lome
    {  252, 5290,      18,  9, }, // Africa/Ndjamena
    {  252, 4454,      27,  8, }, // Africa/Sao_Tome
    {  252, 4573,      35,  9, }, // America/Araguaina
    {  252,  270,      44,  7, }, // America/Argentina/Cordoba
    {  252, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  252, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  252, 4271,      70,  8, }, // America/Asuncion
    {  252,  237,      78,  8, }, // America/Atikokan
    {  252, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  252, 7646,     103,  5, }, // America/Belem
    {  252, 4380,     108,  6, }, // America/Bogota
    {  252, 3887,   35352,  6, }, // America/Cancun
    {  252, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  252, 3810,     133,  6, }, // America/Cuiaba
    {  252, 5742,     139,  7, }, // America/Curacao
    {  252, 7887,     146,  8, }, // America/Eirunepe
    {  252,  481,     154, 13, }, // America/Indiana/Knox
    {  252, 7979,     167, 16, }, // America/Indiana/Marengo
    {  252, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  252, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  252, 8056,     220, 14, }, // America/Indiana/Vevay
    {  252, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  252, 8104,     252, 16, }, // America/Indiana/Winamac
    {  252, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  252, 5951,     288, 22, }, // America/Lower_Princes
    {  252, 8171,     310,  6, }, // America/Maceio
    {  252, 2919,     316,  8, }, // America/Mazatlan
    {  252, 8238,    7779,  6, }, // America/Merida
    {  252, 2951,    4381, 16, }, // America/Mexico_City
    {  252, 4410,     341, 12, }, // America/Miquelon
    {  252, 1852,     353, 19, }, // America/Noronha
    {  252, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  252, 8347,     392, 20, }, // America/North_Dakota/Center
    {  252, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  252,  393,     435,  4, }, // America/Nuuk
    {  252, 8495,     439,  8, }, // America/Santarem
    {  252, 1880,     447,  9, }, // America/Sao_Paulo
    {  252, 6918,     456, 16, }, // America/Scoresbysund
    {  252, 8526,     472, 14, }, // America/St_Barthelemy
    {  252, 2063,     486, 10, }, // America/St_Johns
    {  252, 5882,     496,  9, }, // America/St_Kitts
    {  252, 5899,     505,  9, }, // America/St_Lucia
    {  252,  855,     514, 10, }, // America/St_Thomas
    {  252, 5932,     524, 11, }, // America/St_Vincent
    {  252, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  252, 7295,     643,  5, }, // Antarctica/Syowa
    {  252, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  252, 4790,     704,  5, }, // Asia/Hovd
    {  252, 1187,   68658, 24, }, // Asia/Kathmandu
    {  252,  994,     718,  7, }, // Asia/Kolkata
    {  252, 1213,    4961,  5, }, // Asia/Macau
    {  252, 1161,     747,  6, }, // Asia/Urumqi
    {  252, 1237,     753,  6, }, // Asia/Yangon
    {  252, 6647,    4413,  8, }, // Atlantic/Canary
    {  252, 1397,     767,  5, }, // Atlantic/Faroe
    {  252, 6840,     773, 10, }, // Atlantic/St_Helena
    {  252, 8790,     799,  8, }, // Europe/Busingen
    {  252, 2585,     807,  8, }, // Europe/Chisinau
    {  252, 2529,    8801,  4, }, // Europe/Kyiv
    {  252, 6221,     819,  6, }, // Europe/Tirane
    {  252, 5048,    4421,  7, }, // Indian/Comoro
    {  252, 7260,     896,  4, }, // Indian/Mahe
    {  252, 7211,     900,  7, }, // Indian/Reunion
    {  252, 3176,     922,  5, }, // Pacific/Chuuk
    {  252, 6697,     940,  9, }, // Pacific/Galapagos
    {  252, 2725,    5251,  8, }, // Pacific/Honolulu
    {  252, 3068,     957,  6, }, // Pacific/Kanton
    {  252, 7117,    1028,  6, }, // Pacific/Noumea
    {  252, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  252, 7405,    1068, 15, }, // Pacific/Wallis
    {  254,   14,       0,  6, }, // Africa/Asmara Ewondo/Latin/Cameroon
    {  254, 5185,       6,  8, }, // Africa/El_Aaiun
    {  254, 6888,      14,  4, }, // Africa/Lome
    {  254, 5290,      18,  9, }, // Africa/Ndjamena
    {  254, 4454,      27,  8, }, // Africa/Sao_Tome
    {  254, 4573,      35,  9, }, // America/Araguaina
    {  254,  270,      44,  7, }, // America/Argentina/Cordoba
    {  254, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  254, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  254, 4271,      70,  8, }, // America/Asuncion
    {  254,  237,      78,  8, }, // America/Atikokan
    {  254, 7623,      86, 17, }, // America/Bahia_Banderas
    {  254, 7646,     103,  5, }, // America/Belem
    {  254, 4380,     108,  6, }, // America/Bogota
    {  254, 3887,     114,  6, }, // America/Cancun
    {  254, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  254, 3810,     133,  6, }, // America/Cuiaba
    {  254, 5742,     139,  7, }, // America/Curacao
    {  254, 7887,     146,  8, }, // America/Eirunepe
    {  254,  481,     154, 13, }, // America/Indiana/Knox
    {  254, 7979,     167, 16, }, // America/Indiana/Marengo
    {  254, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  254, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  254, 8056,     220, 14, }, // America/Indiana/Vevay
    {  254, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  254, 8104,     252, 16, }, // America/Indiana/Winamac
    {  254, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  254, 5951,     288, 22, }, // America/Lower_Princes
    {  254, 8171,     310,  6, }, // America/Maceio
    {  254, 2919,     316,  8, }, // America/Mazatlan
    {  254, 8238,     324,  6, }, // America/Merida
    {  254, 2951,    4381, 16, }, // America/Mexico_City
    {  254, 4410,     341, 12, }, // America/Miquelon
    {  254, 1852,     353, 19, }, // America/Noronha
    {  254, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  254, 8347,     392, 20, }, // America/North_Dakota/Center
    {  254, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  254,  393,     435,  4, }, // America/Nuuk
    {  254, 8495,     439,  8, }, // America/Santarem
    {  254, 1880,     447,  9, }, // America/Sao_Paulo
    {  254, 6918,     456, 16, }, // America/Scoresbysund
    {  254, 8526,     472, 14, }, // America/St_Barthelemy
    {  254, 2063,     486, 10, }, // America/St_Johns
    {  254, 5882,     496,  9, }, // America/St_Kitts
    {  254, 5899,     505,  9, }, // America/St_Lucia
    {  254,  855,     514, 10, }, // America/St_Thomas
    {  254, 5932,     524, 11, }, // America/St_Vincent
    {  254, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  254, 7295,     643,  5, }, // Antarctica/Syowa
    {  254, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  254, 4790,     704,  5, }, // Asia/Hovd
    {  254, 1187,     709,  9, }, // Asia/Kathmandu
    {  254,  994,     718,  7, }, // Asia/Kolkata
    {  254, 1213,     725,  5, }, // Asia/Macau
    {  254, 1161,     747,  6, }, // Asia/Urumqi
    {  254, 1237,     753,  6, }, // Asia/Yangon
    {  254, 6647,    4413,  8, }, // Atlantic/Canary
    {  254, 1397,     767,  5, }, // Atlantic/Faroe
    {  254, 6840,     773, 10, }, // Atlantic/St_Helena
    {  254, 8790,     799,  8, }, // Europe/Busingen
    {  254, 2585,     807,  8, }, // Europe/Chisinau
    {  254, 2529,     815,  4, }, // Europe/Kyiv
    {  254, 6221,     819,  6, }, // Europe/Tirane
    {  254, 5048,    4421,  7, }, // Indian/Comoro
    {  254, 7260,     896,  4, }, // Indian/Mahe
    {  254, 7211,     900,  7, }, // Indian/Reunion
    {  254, 3176,     922,  5, }, // Pacific/Chuuk
    {  254, 6697,     940,  9, }, // Pacific/Galapagos
    {  254, 3068,     957,  6, }, // Pacific/Kanton
    {  254, 7117,    1028,  6, }, // Pacific/Noumea
    {  254, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  254, 7405,    1068, 15, }, // Pacific/Wallis
    {  255,   14,       0,  6, }, // Africa/Asmara Faroese/Latin/Faroe Islands
    {  255, 5062,   28866,  7, }, // Africa/Djibouti
    {  255, 5185,       6,  8, }, // Africa/El_Aaiun
    {  255, 6888,      14,  4, }, // Africa/Lome
    {  255, 5290,      18,  9, }, // Africa/Ndjamena
    {  255, 4454,      27,  8, }, // Africa/Sao_Tome
    {  255, 4573,      35,  9, }, // America/Araguaina
    {  255,  270,      44,  7, }, // America/Argentina/Cordoba
    {  255, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  255, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  255, 4271,      70,  8, }, // America/Asuncion
    {  255,  237,      78,  8, }, // America/Atikokan
    {  255, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  255, 7646,     103,  5, }, // America/Belem
    {  255, 5426,   68682,  5, }, // America/Belize
    {  255, 4380,     108,  6, }, // America/Bogota
    {  255, 3887,   35352,  6, }, // America/Cancun
    {  255, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  255, 5441,   22287, 10, }, // America/Costa_Rica
    {  255, 3810,     133,  6, }, // America/Cuiaba
    {  255, 5742,     139,  7, }, // America/Curacao
    {  255, 7887,     146,  8, }, // America/Eirunepe
    {  255,  481,     154, 13, }, // America/Indiana/Knox
    {  255, 7979,     167, 16, }, // America/Indiana/Marengo
    {  255, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  255, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  255, 8056,     220, 14, }, // America/Indiana/Vevay
    {  255, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  255, 8104,     252, 16, }, // America/Indiana/Winamac
    {  255, 2801,    4507,  7, }, // America/Jamaica
    {  255, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  255, 5951,     288, 22, }, // America/Lower_Princes
    {  255, 8171,     310,  6, }, // America/Maceio
    {  255, 2919,     316,  8, }, // America/Mazatlan
    {  255, 8238,    7779,  6, }, // America/Merida
    {  255, 2951,    4381, 16, }, // America/Mexico_City
    {  255, 4410,     341, 12, }, // America/Miquelon
    {  255, 1852,     353, 19, }, // America/Noronha
    {  255, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  255, 8347,     392, 20, }, // America/North_Dakota/Center
    {  255, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  255,  393,     435,  4, }, // America/Nuuk
    {  255, 5862,   22731, 11, }, // America/Puerto_Rico
    {  255, 8495,     439,  8, }, // America/Santarem
    {  255, 1880,     447,  9, }, // America/Sao_Paulo
    {  255, 6918,     456, 16, }, // America/Scoresbysund
    {  255, 8526,     472, 14, }, // America/St_Barthelemy
    {  255, 2063,     486, 10, }, // America/St_Johns
    {  255, 5882,     496,  9, }, // America/St_Kitts
    {  255, 5899,     505,  9, }, // America/St_Lucia
    {  255,  855,     514, 10, }, // America/St_Thomas
    {  255, 5932,     524, 11, }, // America/St_Vincent
    {  255, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  255, 7295,     643,  5, }, // Antarctica/Syowa
    {  255, 5553,   68687,  6, }, // Asia/Bahrain
    {  255, 8669,   68693,  4, }, // Asia/Gaza
    {  255, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  255, 4790,     704,  5, }, // Asia/Hovd
    {  255, 1187,     709,  9, }, // Asia/Kathmandu
    {  255,  994,     718,  7, }, // Asia/Kolkata
    {  255, 5566,   68697,  6, }, // Asia/Kuwait
    {  255, 1213,    8384,  5, }, // Asia/Macau
    {  255, 8726,     730,  8, }, // Asia/Qostanay
    {  255, 3319,    8462,  8, }, // Asia/Singapore
    {  255, 2774,    8495,  7, }, // Asia/Tehran
    {  255, 1161,     747,  6, }, // Asia/Urumqi
    {  255, 1237,   63337,  7, }, // Asia/Yangon
    {  255, 3682,   68703,  9, }, // Atlantic/Azores
    {  255, 6647,    4413,  8, }, // Atlantic/Canary
    {  255, 3746,   68712, 16, }, // Atlantic/Cape_Verde
    {  255, 1397,   68728,  7, }, // Atlantic/Faroe
    {  255, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {  255, 7272,   68735, 19, }, // Atlantic/South_Georgia
    {  255, 6840,     773, 10, }, // Atlantic/St_Helena
    {  255, 2302,    6566,  4, }, // Europe/Athens
    {  255, 6355,    8713,  7, }, // Europe/Belgrade
    {  255, 2169,   62365,  9, }, // Europe/Brussels
    {  255, 3947,   29329,  8, }, // Europe/Bucharest
    {  255, 8790,     799,  8, }, // Europe/Busingen
    {  255, 2585,     807,  8, }, // Europe/Chisinau
    {  255, 6308,   68754, 13, }, // Europe/Copenhagen
    {  255, 2529,    8801,  4, }, // Europe/Kyiv
    {  255, 3232,    5139,  8, }, // Europe/Lisbon
    {  255, 6384,   68767, 10, }, // Europe/Luxembourg
    {  255, 6429,    8840,  6, }, // Europe/Monaco
    {  255, 3556,   23539,  6, }, // Europe/Moscow
    {  255, 6294,    6716,  4, }, // Europe/Prague
    {  255, 6343,    8869,  3, }, // Europe/Rome
    {  255, 6542,   68777,  9, }, // Europe/Stockholm
    {  255, 6221,     819,  6, }, // Europe/Tirane
    {  255, 6586,   68786,  9, }, // Europe/Vatican
    {  255, 6250,   58704,  4, }, // Europe/Vienna
    {  255, 3209,   68795,  8, }, // Europe/Warsaw
    {  255, 6559,    5217,  6, }, // Europe/Zurich
    {  255, 5048,    4421,  7, }, // Indian/Comoro
    {  255, 7260,     896,  4, }, // Indian/Mahe
    {  255, 7069,   68803, 13, }, // Indian/Maldives
    {  255, 4088,   68816,  8, }, // Indian/Mauritius
    {  255, 7211,     900,  7, }, // Indian/Reunion
    {  255, 3176,     922,  5, }, // Pacific/Chuuk
    {  255, 6697,     940,  9, }, // Pacific/Galapagos
    {  255, 2725,    5251,  8, }, // Pacific/Honolulu
    {  255, 3068,     957,  6, }, // Pacific/Kanton
    {  255, 7117,    1028,  6, }, // Pacific/Noumea
    {  255, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  255, 7405,    1068, 15, }, // Pacific/Wallis
    {  257,   14,       0,  6, }, // Africa/Asmara Filipino/Latin/Philippines
    {  257, 5185,       6,  8, }, // Africa/El_Aaiun
    {  257, 6888,      14,  4, }, // Africa/Lome
    {  257, 5290,      18,  9, }, // Africa/Ndjamena
    {  257, 4454,      27,  8, }, // Africa/Sao_Tome
    {  257, 4573,      35,  9, }, // America/Araguaina
    {  257,  270,      44,  7, }, // America/Argentina/Cordoba
    {  257, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  257, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  257, 4271,      70,  8, }, // America/Asuncion
    {  257,  237,      78,  8, }, // America/Atikokan
    {  257, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  257, 7646,     103,  5, }, // America/Belem
    {  257, 4380,     108,  6, }, // America/Bogota
    {  257, 3887,   35352,  6, }, // America/Cancun
    {  257, 7774,   68824, 17, }, // America/Ciudad_Juarez
    {  257, 3810,     133,  6, }, // America/Cuiaba
    {  257, 5742,     139,  7, }, // America/Curacao
    {  257, 7887,     146,  8, }, // America/Eirunepe
    {  257,  481,     154, 13, }, // America/Indiana/Knox
    {  257, 7979,     167, 16, }, // America/Indiana/Marengo
    {  257, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  257, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  257, 8056,     220, 14, }, // America/Indiana/Vevay
    {  257, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  257, 8104,     252, 16, }, // America/Indiana/Winamac
    {  257, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  257, 5951,     288, 22, }, // America/Lower_Princes
    {  257, 8171,     310,  6, }, // America/Maceio
    {  257, 2919,     316,  8, }, // America/Mazatlan
    {  257, 8238,    7779,  6, }, // America/Merida
    {  257, 2951,   68841, 17, }, // America/Mexico_City
    {  257, 4410,     341, 12, }, // America/Miquelon
    {  257, 1852,     353, 19, }, // America/Noronha
    {  257, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  257, 8347,     392, 20, }, // America/North_Dakota/Center
    {  257, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  257,  393,     435,  4, }, // America/Nuuk
    {  257, 5973,   68858, 18, }, // America/Port_of_Spain
    {  257, 8442,   68876, 25, }, // America/Rankin_Inlet
    {  257, 8495,     439,  8, }, // America/Santarem
    {  257, 1880,     447,  9, }, // America/Sao_Paulo
    {  257, 6918,     456, 16, }, // America/Scoresbysund
    {  257, 8526,     472, 14, }, // America/St_Barthelemy
    {  257, 2063,     486, 10, }, // America/St_Johns
    {  257, 5882,     496,  9, }, // America/St_Kitts
    {  257, 5899,     505,  9, }, // America/St_Lucia
    {  257,  855,     514, 10, }, // America/St_Thomas
    {  257, 5932,     524, 11, }, // America/St_Vincent
    {  257, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  257, 7295,     643,  5, }, // Antarctica/Syowa
    {  257, 1261,   68901, 22, }, // Asia/Ho_Chi_Minh
    {  257, 4790,     704,  5, }, // Asia/Hovd
    {  257, 1187,     709,  9, }, // Asia/Kathmandu
    {  257,  994,     718,  7, }, // Asia/Kolkata
    {  257, 1213,    4961,  5, }, // Asia/Macau
    {  257, 8726,     730,  8, }, // Asia/Qostanay
    {  257, 1161,     747,  6, }, // Asia/Urumqi
    {  257, 1237,     753,  6, }, // Asia/Yangon
    {  257, 6647,    4413,  8, }, // Atlantic/Canary
    {  257, 1397,     767,  5, }, // Atlantic/Faroe
    {  257, 6840,     773, 10, }, // Atlantic/St_Helena
    {  257, 8790,     799,  8, }, // Europe/Busingen
    {  257, 2585,     807,  8, }, // Europe/Chisinau
    {  257, 2529,    8801,  4, }, // Europe/Kyiv
    {  257, 6221,     819,  6, }, // Europe/Tirane
    {  257, 5048,    4421,  7, }, // Indian/Comoro
    {  257, 7260,     896,  4, }, // Indian/Mahe
    {  257, 7211,     900,  7, }, // Indian/Reunion
    {  257, 3176,     922,  5, }, // Pacific/Chuuk
    {  257, 6697,     940,  9, }, // Pacific/Galapagos
    {  257, 2725,    5251,  8, }, // Pacific/Honolulu
    {  257, 3068,     957, 13, }, // Pacific/Kanton
    {  257, 7117,    1028,  6, }, // Pacific/Noumea
    {  257, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  257, 7405,    1068, 15, }, // Pacific/Wallis
    {  258, 5078,    4428, 11, }, // Africa/Addis_Ababa Finnish/Latin/Finland
    {  258, 7420,   45953,  5, }, // Africa/Algiers
    {  258,   14,       0,  6, }, // Africa/Asmara
    {  258, 2322,    5363,  5, }, // Africa/Cairo
    {  258, 5185,       6,  8, }, // Africa/El_Aaiun
    {  258, 4543,   28878,  7, }, // Africa/Khartoum
    {  258, 6888,      14,  4, }, // Africa/Lome
    {  258, 5290,      18,  9, }, // Africa/Ndjamena
    {  258, 4454,      27,  8, }, // Africa/Sao_Tome
    {  258, 4573,      35,  9, }, // America/Araguaina
    {  258,  270,      44,  7, }, // America/Argentina/Cordoba
    {  258, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  258, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  258, 4271,      70,  8, }, // America/Asuncion
    {  258,  237,      78,  8, }, // America/Atikokan
    {  258, 7623,      86, 17, }, // America/Bahia_Banderas
    {  258, 7646,     103,  5, }, // America/Belem
    {  258, 4380,     108,  6, }, // America/Bogota
    {  258, 3887,     114,  6, }, // America/Cancun
    {  258, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  258, 3810,     133,  6, }, // America/Cuiaba
    {  258, 5742,     139,  7, }, // America/Curacao
    {  258, 7887,     146,  8, }, // America/Eirunepe
    {  258, 2283,   68235,  7, }, // America/Havana
    {  258,  481,     154, 13, }, // America/Indiana/Knox
    {  258, 7979,     167, 16, }, // America/Indiana/Marengo
    {  258, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  258, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  258, 8056,     220, 14, }, // America/Indiana/Vevay
    {  258, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  258, 8104,     252, 16, }, // America/Indiana/Winamac
    {  258, 2801,    4507,  7, }, // America/Jamaica
    {  258, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  258, 5951,     288, 22, }, // America/Lower_Princes
    {  258, 8171,     310,  6, }, // America/Maceio
    {  258, 2919,     316,  8, }, // America/Mazatlan
    {  258, 8238,     324,  6, }, // America/Merida
    {  258, 2951,    4381, 16, }, // America/Mexico_City
    {  258, 4410,     341, 12, }, // America/Miquelon
    {  258, 1852,     353, 19, }, // America/Noronha
    {  258, 8319,   68923, 22, }, // America/North_Dakota/Beulah
    {  258, 8347,   68945, 22, }, // America/North_Dakota/Center
    {  258, 8375,   68967, 25, }, // America/North_Dakota/New_Salem
    {  258,  393,   37911,  7, }, // America/Nuuk
    {  258, 8495,     439,  8, }, // America/Santarem
    {  258, 2203,   68992, 17, }, // America/Santiago
    {  258, 1880,     447,  9, }, // America/Sao_Paulo
    {  258, 6918,   46125, 12, }, // America/Scoresbysund
    {  258, 8526,   29041, 16, }, // America/St_Barthelemy
    {  258, 2063,     486, 10, }, // America/St_Johns
    {  258, 5882,   29069, 11, }, // America/St_Kitts
    {  258, 5899,   37943, 11, }, // America/St_Lucia
    {  258,  855,   46153, 12, }, // America/St_Thomas
    {  258, 5932,   29103, 13, }, // America/St_Vincent
    {  258, 5775,   29116,  7, }, // America/Thule
    {  258, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  258, 8586,   69009, 15, }, // Antarctica/Macquarie
    {  258, 7295,     643,  5, }, // Antarctica/Syowa
    {  258, 5542,   69024,  5, }, // Asia/Aqtau
    {  258, 5387,   58394,  6, }, // Asia/Aqtobe
    {  258,  966,   62319,  7, }, // Asia/Ashgabat
    {  258, 8642,   63500,  6, }, // Asia/Atyrau
    {  258, 3626,    4802,  6, }, // Asia/Baghdad
    {  258, 3797,   35493,  6, }, // Asia/Bishkek
    {  258, 4620,   68334,  5, }, // Asia/Chita
    {  258, 4559,   69029,  8, }, // Asia/Damascus
    {  258, 6178,   35506,  7, }, // Asia/Dushanbe
    {  258, 1261,   69037, 22, }, // Asia/Ho_Chi_Minh
    {  258, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  258, 4790,     704,  5, }, // Asia/Hovd
    {  258, 4335,   68361,  9, }, // Asia/Kamchatka
    {  258, 1187,     709,  9, }, // Asia/Kathmandu
    {  258, 8679,   69059,  7, }, // Asia/Khandyga
    {  258,  994,   69066,  8, }, // Asia/Kolkata
    {  258, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  258, 1213,     725,  5, }, // Asia/Macau
    {  258, 6939,   38033,  6, }, // Asia/Muscat
    {  258, 2556,    6387,  7, }, // Asia/Nicosia
    {  258, 7145,   62757,  6, }, // Asia/Oral
    {  258, 4233,   35600,  9, }, // Asia/Pyongyang
    {  258, 8726,   69074,  8, }, // Asia/Qostanay
    {  258, 4288,   23192,  9, }, // Asia/Qyzylorda
    {  258, 3603,    8440,  4, }, // Asia/Riyadh
    {  258, 4427,   35614,  7, }, // Asia/Sakhalin
    {  258, 3298,   62796,  4, }, // Asia/Seoul
    {  258, 4800,   35627,  7, }, // Asia/Tashkent
    {  258, 2774,    8495,  7, }, // Asia/Tehran
    {  258, 2823,    4996,  5, }, // Asia/Tokyo
    {  258, 1023,   29229, 10, }, // Asia/Ulaanbaatar
    {  258, 1161,     747,  6, }, // Asia/Urumqi
    {  258, 4847,    8526,  7, }, // Asia/Yakutsk
    {  258, 1237,     753,  6, }, // Asia/Yangon
    {  258, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  258, 3766,    8551,  7, }, // Asia/Yerevan
    {  258, 3682,   69082,  6, }, // Atlantic/Azores
    {  258, 6647,   69088, 14, }, // Atlantic/Canary
    {  258, 3746,   58569,  9, }, // Atlantic/Cape_Verde
    {  258, 1397,   69102,  9, }, // Atlantic/Faroe
    {  258, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {  258, 7272,   69111, 13, }, // Atlantic/South_Georgia
    {  258, 6840,   46383, 12, }, // Atlantic/St_Helena
    {  258, 3639,   35682,  8, }, // Europe/Astrakhan
    {  258, 2302,   68502,  6, }, // Europe/Athens
    {  258, 6355,   29315,  7, }, // Europe/Belgrade
    {  258, 4776,   69124,  8, }, // Europe/Berlin
    {  258, 2169,   69132,  7, }, // Europe/Brussels
    {  258, 3947,   29329,  8, }, // Europe/Bucharest
    {  258, 8790,     799,  8, }, // Europe/Busingen
    {  258, 2585,   69139,  8, }, // Europe/Chisinau
    {  258, 6308,   69147, 12, }, // Europe/Copenhagen
    {  258, 8822,   69159,  8, }, // Europe/Isle_of_Man
    {  258, 2529,   69167,  5, }, // Europe/Kyiv
    {  258, 3232,    5139,  8, }, // Europe/Lisbon
    {  258, 2503,   69172,  6, }, // Europe/London
    {  258, 6384,    5153,  9, }, // Europe/Luxembourg
    {  258, 6601,   68548, 13, }, // Europe/Mariehamn
    {  258, 3556,   69178,  7, }, // Europe/Moscow
    {  258, 4303,   69185,  7, }, // Europe/Paris
    {  258, 6294,   38246,  5, }, // Europe/Prague
    {  258, 8868,   69192,  5, }, // Europe/Riga
    {  258, 6343,   68571,  5, }, // Europe/Rome
    {  258, 6542,   69197,  8, }, // Europe/Stockholm
    {  258, 8898,   69205,  8, }, // Europe/Tallinn
    {  258, 6221,     819,  6, }, // Europe/Tirane
    {  258, 8913,    8920,  9, }, // Europe/Ulyanovsk
    {  258, 6586,   69213,  9, }, // Europe/Vatican
    {  258, 6250,   58704,  4, }, // Europe/Vienna
    {  258, 8930,   69222,  5, }, // Europe/Vilnius
    {  258, 3209,   69227,  7, }, // Europe/Warsaw
    {  258, 6559,    5217,  6, }, // Europe/Zurich
    {  258, 6065,   69234, 10, }, // Indian/Christmas
    {  258, 6082,   69244, 12, }, // Indian/Cocos
    {  258, 5048,   69256,  7, }, // Indian/Comoro
    {  258, 6680,   69263, 15, }, // Indian/Kerguelen
    {  258, 7260,     896,  4, }, // Indian/Mahe
    {  258, 7069,   69278, 10, }, // Indian/Maldives
    {  258, 7211,     900,  7, }, // Indian/Reunion
    {  258, 3034,   69288, 13, }, // Pacific/Chatham
    {  258, 3176,     922,  5, }, // Pacific/Chuuk
    {  258, 2239,   69301, 13, }, // Pacific/Easter
    {  258, 3921,   35874,  5, }, // Pacific/Fiji
    {  258, 6697,     940,  9, }, // Pacific/Galapagos
    {  258, 6715,   69314, 13, }, // Pacific/Gambier
    {  258, 2725,    5251,  8, }, // Pacific/Honolulu
    {  258, 3068,   68631, 10, }, // Pacific/Kanton
    {  258, 4070,   69327, 15, }, // Pacific/Marquesas
    {  258, 8945,   69342, 12, }, // Pacific/Midway
    {  258, 7117,    1028,  6, }, // Pacific/Noumea
    {  258, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  258, 7405,    1068, 15, }, // Pacific/Wallis
    {  259, 5078,   69354, 11, }, // Africa/Addis_Ababa French/Latin/France
    {  259, 7420,   45953,  5, }, // Africa/Algiers
    {  259,   14,       0,  6, }, // Africa/Asmara
    {  259, 2322,   69365,  8, }, // Africa/Cairo
    {  259, 5185,   69373,  8, }, // Africa/El_Aaiun
    {  259, 6888,      14,  4, }, // Africa/Lome
    {  259, 5132,   45975, 10, }, // Africa/Mogadishu
    {  259, 5290,      18,  9, }, // Africa/Ndjamena
    {  259, 4454,      27,  8, }, // Africa/Sao_Tome
    {  259, 2868,   69381, 15, }, // Africa/Tripoli
    {  259, 4573,      35,  9, }, // America/Araguaina
    {  259,  270,      44,  7, }, // America/Argentina/Cordoba
    {  259, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  259, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  259, 7597,   69396,  7, }, // America/Argentina/Ushuaia
    {  259, 4271,      70,  8, }, // America/Asuncion
    {  259,  237,      78,  8, }, // America/Atikokan
    {  259, 7623,   69403, 17, }, // America/Bahia_Banderas
    {  259, 5673,   69420, 10, }, // America/Barbados
    {  259, 7646,     103,  5, }, // America/Belem
    {  259, 4380,     108,  6, }, // America/Bogota
    {  259, 3887,     114,  6, }, // America/Cancun
    {  259, 5515,   69430,  7, }, // America/Cayman
    {  259, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  259, 3810,     133,  6, }, // America/Cuiaba
    {  259, 5742,     139,  7, }, // America/Curacao
    {  259, 3484,   69437,  7, }, // America/Detroit
    {  259, 5758,   69444,  9, }, // America/Dominica
    {  259, 7887,     146,  8, }, // America/Eirunepe
    {  259, 5789,   69453,  7, }, // America/Grenada
    {  259, 2283,   69460,  9, }, // America/Havana
    {  259,  481,   69469, 14, }, // America/Indiana/Knox
    {  259, 7979,   69483, 17, }, // America/Indiana/Marengo
    {  259, 8003,   69500, 20, }, // America/Indiana/Petersburg
    {  259, 8030,   69520, 19, }, // America/Indiana/Tell_City
    {  259, 8056,   69539, 15, }, // America/Indiana/Vevay
    {  259, 8078,   69554, 19, }, // America/Indiana/Vincennes
    {  259, 8104,   69573, 17, }, // America/Indiana/Winamac
    {  259, 2801,   69590,  8, }, // America/Jamaica
    {  259, 8143,   69598, 21, }, // America/Kentucky/Monticello
    {  259, 5951,     288, 22, }, // America/Lower_Princes
    {  259, 8171,     310,  6, }, // America/Maceio
    {  259, 1910,   69619,  6, }, // America/Manaus
    {  259, 2919,     316,  8, }, // America/Mazatlan
    {  259, 8238,     324,  6, }, // America/Merida
    {  259, 2951,     330,  6, }, // America/Mexico_City
    {  259, 4410,     341, 12, }, // America/Miquelon
    {  259, 1852,     353, 19, }, // America/Noronha
    {  259, 8319,   69625, 23, }, // America/North_Dakota/Beulah
    {  259, 8347,   69648, 23, }, // America/North_Dakota/Center
    {  259, 8375,   69671, 26, }, // America/North_Dakota/New_Salem
    {  259,  393,     435,  4, }, // America/Nuuk
    {  259, 5973,   69697, 14, }, // America/Port_of_Spain
    {  259, 5862,   69711, 10, }, // America/Puerto_Rico
    {  259, 8495,     439,  8, }, // America/Santarem
    {  259, 6130,   69721, 14, }, // America/Santo_Domingo
    {  259, 1880,     447,  9, }, // America/Sao_Paulo
    {  259, 6918,     456, 16, }, // America/Scoresbysund
    {  259, 8526,   29041, 16, }, // America/St_Barthelemy
    {  259, 2063,   69735, 25, }, // America/St_Johns
    {  259, 5882,   69760, 16, }, // America/St_Kitts
    {  259, 5899,   69776, 12, }, // America/St_Lucia
    {  259,  855,   29091, 12, }, // America/St_Thomas
    {  259, 5932,   69788, 13, }, // America/St_Vincent
    {  259, 5775,   69801,  5, }, // America/Thule
    {  259, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  259, 7295,     643,  5, }, // Antarctica/Syowa
    {  259, 5414,   62311,  8, }, // Asia/Almaty
    {  259, 5542,   69806,  6, }, // Asia/Aqtau
    {  259, 5387,   69812, 11, }, // Asia/Aqtobe
    {  259,  966,   69823,  8, }, // Asia/Ashgabat
    {  259, 8642,   69831,  7, }, // Asia/Atyrau
    {  259, 3626,    4802,  6, }, // Asia/Baghdad
    {  259, 5553,   69838,  7, }, // Asia/Bahrain
    {  259, 3672,   37972,  5, }, // Asia/Baku
    {  259, 4105,   69845,  8, }, // Asia/Beirut
    {  259, 3797,   69853,  7, }, // Asia/Bishkek
    {  259, 4620,   37983,  6, }, // Asia/Chita
    {  259, 4559,    4841,  5, }, // Asia/Damascus
    {  259, 3615,   69860,  5, }, // Asia/Dubai
    {  259, 6178,   69865,  9, }, // Asia/Dushanbe
    {  259, 8654,   69874, 10, }, // Asia/Famagusta
    {  259, 4814,   69884,  6, }, // Asia/Hebron
    {  259, 1261,   69890, 17, }, // Asia/Ho_Chi_Minh
    {  259, 4790,     704,  5, }, // Asia/Hovd
    {  259, 4203,   69907,  8, }, // Asia/Irkutsk
    {  259, 1292,   69915,  9, }, // Asia/Jerusalem
    {  259, 3579,   38011,  6, }, // Asia/Kabul
    {  259, 4335,   38017, 10, }, // Asia/Kamchatka
    {  259, 1187,   69924,  9, }, // Asia/Kathmandu
    {  259,  994,   63530,  8, }, // Asia/Kolkata
    {  259, 4216,   69933, 11, }, // Asia/Krasnoyarsk
    {  259, 5566,   69944,  6, }, // Asia/Kuwait
    {  259, 1213,     725,  5, }, // Asia/Macau
    {  259, 1351,   69950,  8, }, // Asia/Makassar
    {  259, 7182,   69958,  7, }, // Asia/Manila
    {  259, 6939,   21518,  7, }, // Asia/Muscat
    {  259, 2556,   69965,  7, }, // Asia/Nicosia
    {  259, 4154,   46239, 12, }, // Asia/Novosibirsk
    {  259, 7145,   69972,  7, }, // Asia/Oral
    {  259, 8726,   69979,  8, }, // Asia/Qostanay
    {  259, 4288,   69987,  9, }, // Asia/Qyzylorda
    {  259, 3603,   21535,  5, }, // Asia/Riyadh
    {  259, 4427,   69996,  9, }, // Asia/Sakhalin
    {  259, 7245,   70005, 10, }, // Asia/Samarkand
    {  259, 3298,   70015,  5, }, // Asia/Seoul
    {  259, 3319,   38057,  9, }, // Asia/Singapore
    {  259, 4800,   70020,  8, }, // Asia/Tashkent
    {  259, 3934,   70028,  8, }, // Asia/Tbilisi
    {  259, 2774,   70036,  7, }, // Asia/Tehran
    {  259, 1023,   70043, 11, }, // Asia/Ulaanbaatar
    {  259, 1161,     747,  6, }, // Asia/Urumqi
    {  259, 4847,   70054,  8, }, // Asia/Yakutsk
    {  259, 1237,   70062,  7, }, // Asia/Yangon
    {  259, 3902,   70069, 13, }, // Asia/Yekaterinburg
    {  259, 3766,   29247,  6, }, // Asia/Yerevan
    {  259, 3682,   46321,  6, }, // Atlantic/Azores
    {  259, 5690,   46327,  8, }, // Atlantic/Bermuda
    {  259, 6647,   70082, 13, }, // Atlantic/Canary
    {  259, 3746,   70095,  8, }, // Atlantic/Cape_Verde
    {  259, 1397,   70103, 10, }, // Atlantic/Faroe
    {  259, 8754,   70113,  6, }, // Atlantic/Madeira
    {  259, 7272,   70119, 14, }, // Atlantic/South_Georgia
    {  259, 6840,   70133, 13, }, // Atlantic/St_Helena
    {  259, 1672,   70146,  8, }, // Australia/Adelaide
    {  259, 6235,   70154,  7, }, // Europe/Andorra
    {  259, 2302,   70161,  7, }, // Europe/Athens
    {  259, 2169,   62365,  9, }, // Europe/Brussels
    {  259, 3947,   21726,  8, }, // Europe/Bucharest
    {  259, 8790,     799,  8, }, // Europe/Busingen
    {  259, 2585,     807,  8, }, // Europe/Chisinau
    {  259, 6308,   21734, 10, }, // Europe/Copenhagen
    {  259, 8806,   29337,  9, }, // Europe/Guernsey
    {  259, 8822,   70168, 10, }, // Europe/Isle_of_Man
    {  259, 2529,    8801,  4, }, // Europe/Kyiv
    {  259, 3232,   70178,  8, }, // Europe/Lisbon
    {  259, 2503,   21805,  7, }, // Europe/London
    {  259, 6416,   70186,  5, }, // Europe/Malta
    {  259, 3556,   46448,  6, }, // Europe/Moscow
    {  259, 6489,   70191, 11, }, // Europe/San_Marino
    {  259, 6221,     819,  6, }, // Europe/Tirane
    {  259, 8913,   70202, 10, }, // Europe/Ulyanovsk
    {  259, 6586,   70212, 10, }, // Europe/Vatican
    {  259, 6250,   70222,  6, }, // Europe/Vienna
    {  259, 3209,   70228,  8, }, // Europe/Warsaw
    {  259, 5048,    4421,  7, }, // Indian/Comoro
    {  259, 7260,     896,  4, }, // Indian/Mahe
    {  259, 4088,   70236,  7, }, // Indian/Mauritius
    {  259, 7211,   70243, 10, }, // Indian/Reunion
    {  259, 3176,     922,  5, }, // Pacific/Chuuk
    {  259, 2239,   70253, 13, }, // Pacific/Easter
    {  259, 7360,   29436,  5, }, // Pacific/Efate
    {  259, 3921,    5246,  5, }, // Pacific/Fiji
    {  259, 6697,     940,  9, }, // Pacific/Galapagos
    {  259, 2725,    5251,  8, }, // Pacific/Honolulu
    {  259, 3068,     957,  6, }, // Pacific/Kanton
    {  259, 4070,   70266,  9, }, // Pacific/Marquesas
    {  259, 7117,    1028,  6, }, // Pacific/Noumea
    {  259, 7155,   70275,  6, }, // Pacific/Palau
    {  259, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  259, 7405,    1068, 15, }, // Pacific/Wallis
    {  266, 5290,   70281,  8, }, // Africa/Ndjamena French/Latin/Canada
    {  266, 2868,   70289, 15, }, // Africa/Tripoli
    {  266, 5673,   70304, 12, }, // America/Barbados
    {  266, 5515,   70316, 12, }, // America/Cayman
    {  266, 8319,   70328, 23, }, // America/North_Dakota/Beulah
    {  266, 8347,   70351, 23, }, // America/North_Dakota/Center
    {  266, 8375,   70374, 26, }, // America/North_Dakota/New_Salem
    {  266, 2063,     486, 10, }, // America/St_Johns
    {  266, 5882,   70400, 26, }, // America/St_Kitts
    {  266,  855,   46153, 12, }, // America/St_Thomas
    {  266, 6152,     548, 16, }, // Antarctica/DumontDUrville
    {  266, 1095,   70426,  5, }, // Asia/Dhaka
    {  266, 1319,   70431,  8, }, // Asia/Thimphu
    {  266, 6647,   70439, 13, }, // Atlantic/Canary
    {  266, 1397,   70452, 10, }, // Atlantic/Faroe
    {  266, 8822,   70462, 10, }, // Europe/Isle_of_Man
    {  266, 2503,   21805,  7, }, // Europe/London
    {  266, 6586,   21873,  7, }, // Europe/Vatican
    {  266, 2239,   70472, 13, }, // Pacific/Easter
    {  266, 7155,   70485,  5, }, // Pacific/Palau
    {  305,   14,       0,  6, }, // Africa/Asmara Friulian/Latin/Italy
    {  305, 5185,       6,  8, }, // Africa/El_Aaiun
    {  305, 6888,      14,  4, }, // Africa/Lome
    {  305, 5290,      18,  9, }, // Africa/Ndjamena
    {  305, 4454,      27,  8, }, // Africa/Sao_Tome
    {  305, 4573,      35,  9, }, // America/Araguaina
    {  305,  270,      44,  7, }, // America/Argentina/Cordoba
    {  305, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  305, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  305, 4271,      70,  8, }, // America/Asuncion
    {  305,  237,      78,  8, }, // America/Atikokan
    {  305, 7623,      86, 17, }, // America/Bahia_Banderas
    {  305, 7646,     103,  5, }, // America/Belem
    {  305, 4380,     108,  6, }, // America/Bogota
    {  305, 3887,     114,  6, }, // America/Cancun
    {  305, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  305, 3810,     133,  6, }, // America/Cuiaba
    {  305, 5742,     139,  7, }, // America/Curacao
    {  305, 7887,     146,  8, }, // America/Eirunepe
    {  305,  481,     154, 13, }, // America/Indiana/Knox
    {  305, 7979,     167, 16, }, // America/Indiana/Marengo
    {  305, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  305, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  305, 8056,     220, 14, }, // America/Indiana/Vevay
    {  305, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  305, 8104,     252, 16, }, // America/Indiana/Winamac
    {  305, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  305, 5951,     288, 22, }, // America/Lower_Princes
    {  305, 8171,     310,  6, }, // America/Maceio
    {  305, 2919,     316,  8, }, // America/Mazatlan
    {  305, 8238,     324,  6, }, // America/Merida
    {  305, 2951,    4381, 16, }, // America/Mexico_City
    {  305, 4410,     341, 12, }, // America/Miquelon
    {  305, 2381,   70490, 10, }, // America/New_York
    {  305, 1852,     353, 19, }, // America/Noronha
    {  305, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  305, 8347,     392, 20, }, // America/North_Dakota/Center
    {  305, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  305,  393,     435,  4, }, // America/Nuuk
    {  305, 8495,     439,  8, }, // America/Santarem
    {  305, 1880,   70500, 20, }, // America/Sao_Paulo
    {  305, 6918,     456, 16, }, // America/Scoresbysund
    {  305, 8526,     472, 14, }, // America/St_Barthelemy
    {  305, 2063,     486, 10, }, // America/St_Johns
    {  305, 5882,     496,  9, }, // America/St_Kitts
    {  305, 5899,     505,  9, }, // America/St_Lucia
    {  305,  855,     514, 10, }, // America/St_Thomas
    {  305, 5932,     524, 11, }, // America/St_Vincent
    {  305, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  305, 7295,     643,  5, }, // Antarctica/Syowa
    {  305, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  305, 4790,     704,  5, }, // Asia/Hovd
    {  305, 1187,     709,  9, }, // Asia/Kathmandu
    {  305,  994,     718,  7, }, // Asia/Kolkata
    {  305, 1213,     725,  5, }, // Asia/Macau
    {  305, 1161,     747,  6, }, // Asia/Urumqi
    {  305, 1237,     753,  6, }, // Asia/Yangon
    {  305, 3682,   70520,  6, }, // Atlantic/Azores
    {  305, 6647,   70526,  8, }, // Atlantic/Canary
    {  305, 1397,     767,  5, }, // Atlantic/Faroe
    {  305, 6840,     773, 10, }, // Atlantic/St_Helena
    {  305, 6355,   70534,  7, }, // Europe/Belgrade
    {  305, 8790,     799,  8, }, // Europe/Busingen
    {  305, 2585,     807,  8, }, // Europe/Chisinau
    {  305, 2529,     815,  4, }, // Europe/Kyiv
    {  305, 3232,   70541,  7, }, // Europe/Lisbon
    {  305, 6525,   70548,  7, }, // Europe/Ljubljana
    {  305, 6384,   70555, 10, }, // Europe/Luxembourg
    {  305, 6416,   70186,  5, }, // Europe/Malta
    {  305, 3556,   70565,  6, }, // Europe/Moscow
    {  305, 6294,   70571,  6, }, // Europe/Prague
    {  305, 6489,   70577,  9, }, // Europe/San_Marino
    {  305, 6221,     819,  6, }, // Europe/Tirane
    {  305, 6250,   70586,  5, }, // Europe/Vienna
    {  305, 5048,    4421,  7, }, // Indian/Comoro
    {  305, 7260,     896,  4, }, // Indian/Mahe
    {  305, 7211,     900,  7, }, // Indian/Reunion
    {  305, 3176,     922,  5, }, // Pacific/Chuuk
    {  305, 6697,     940,  9, }, // Pacific/Galapagos
    {  305, 3068,     957,  6, }, // Pacific/Kanton
    {  305, 7117,    1028,  6, }, // Pacific/Noumea
    {  305, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  305, 7405,    1068, 15, }, // Pacific/Wallis
    {  306,   14,       0,  6, }, // Africa/Asmara Fulah/Latin/Senegal
    {  306, 5185,       6,  8, }, // Africa/El_Aaiun
    {  306, 6888,      14,  4, }, // Africa/Lome
    {  306, 5290,      18,  9, }, // Africa/Ndjamena
    {  306, 4454,      27,  8, }, // Africa/Sao_Tome
    {  306, 4573,      35,  9, }, // America/Araguaina
    {  306,  270,      44,  7, }, // America/Argentina/Cordoba
    {  306, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  306, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  306, 4271,      70,  8, }, // America/Asuncion
    {  306,  237,      78,  8, }, // America/Atikokan
    {  306, 7623,      86, 17, }, // America/Bahia_Banderas
    {  306, 7646,     103,  5, }, // America/Belem
    {  306, 4380,     108,  6, }, // America/Bogota
    {  306, 3887,     114,  6, }, // America/Cancun
    {  306, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  306, 3810,     133,  6, }, // America/Cuiaba
    {  306, 5742,     139,  7, }, // America/Curacao
    {  306, 7887,     146,  8, }, // America/Eirunepe
    {  306,  481,     154, 13, }, // America/Indiana/Knox
    {  306, 7979,     167, 16, }, // America/Indiana/Marengo
    {  306, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  306, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  306, 8056,     220, 14, }, // America/Indiana/Vevay
    {  306, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  306, 8104,     252, 16, }, // America/Indiana/Winamac
    {  306, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  306, 5951,     288, 22, }, // America/Lower_Princes
    {  306, 8171,     310,  6, }, // America/Maceio
    {  306, 2919,     316,  8, }, // America/Mazatlan
    {  306, 8238,     324,  6, }, // America/Merida
    {  306, 2951,    4381, 16, }, // America/Mexico_City
    {  306, 4410,     341, 12, }, // America/Miquelon
    {  306, 1852,     353, 19, }, // America/Noronha
    {  306, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  306, 8347,     392, 20, }, // America/North_Dakota/Center
    {  306, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  306,  393,     435,  4, }, // America/Nuuk
    {  306, 8495,     439,  8, }, // America/Santarem
    {  306, 1880,     447,  9, }, // America/Sao_Paulo
    {  306, 6918,     456, 16, }, // America/Scoresbysund
    {  306, 8526,     472, 14, }, // America/St_Barthelemy
    {  306, 2063,     486, 10, }, // America/St_Johns
    {  306, 5882,     496,  9, }, // America/St_Kitts
    {  306, 5899,     505,  9, }, // America/St_Lucia
    {  306,  855,     514, 10, }, // America/St_Thomas
    {  306, 5932,     524, 11, }, // America/St_Vincent
    {  306, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  306, 7295,     643,  5, }, // Antarctica/Syowa
    {  306, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  306, 4790,     704,  5, }, // Asia/Hovd
    {  306, 1187,     709,  9, }, // Asia/Kathmandu
    {  306,  994,     718,  7, }, // Asia/Kolkata
    {  306, 1213,     725,  5, }, // Asia/Macau
    {  306, 1161,     747,  6, }, // Asia/Urumqi
    {  306, 1237,     753,  6, }, // Asia/Yangon
    {  306, 6647,    4413,  8, }, // Atlantic/Canary
    {  306, 1397,     767,  5, }, // Atlantic/Faroe
    {  306, 6840,     773, 10, }, // Atlantic/St_Helena
    {  306, 8790,     799,  8, }, // Europe/Busingen
    {  306, 2585,     807,  8, }, // Europe/Chisinau
    {  306, 2529,     815,  4, }, // Europe/Kyiv
    {  306, 6221,     819,  6, }, // Europe/Tirane
    {  306, 5048,    4421,  7, }, // Indian/Comoro
    {  306, 7260,     896,  4, }, // Indian/Mahe
    {  306, 7211,     900,  7, }, // Indian/Reunion
    {  306, 3176,     922,  5, }, // Pacific/Chuuk
    {  306, 6697,     940,  9, }, // Pacific/Galapagos
    {  306, 3068,     957,  6, }, // Pacific/Kanton
    {  306, 7117,    1028,  6, }, // Pacific/Noumea
    {  306, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  306, 7405,    1068, 15, }, // Pacific/Wallis
    {  312, 6807,   70591, 12, }, // Africa/Abidjan Fulah/Adlam/Guinea
    {  312, 6779,   70603, 10, }, // Africa/Accra
    {  312, 5078,   70613, 18, }, // Africa/Addis_Ababa
    {  312, 7420,   70631, 14, }, // Africa/Algiers
    {  312,   14,   70645, 12, }, // Africa/Asmara
    {  312,   44,   70657, 14, }, // Africa/Bamako
    {  312, 5276,   70671, 10, }, // Africa/Bangui
    {  312, 6765,   70681, 12, }, // Africa/Banjul
    {  312, 7435,   70693, 12, }, // Africa/Bissau
    {  312, 4976,   70705, 18, }, // Africa/Blantyre
    {  312, 5306,   70723, 16, }, // Africa/Brazzaville
    {  312, 4941,   70739, 18, }, // Africa/Bujumbura
    {  312, 2322,   70757, 10, }, // Africa/Cairo
    {  312, 4136,   70767, 26, }, // Africa/Casablanca
    {  312, 7449,   70793, 10, }, // Africa/Ceuta
    {  312, 6792,   70803, 18, }, // Africa/Conakry
    {  312, 6859,   70821, 12, }, // Africa/Dakar
    {  312, 5149,   70833, 25, }, // Africa/Dar_es_Salaam
    {  312, 5062,   70858, 14, }, // Africa/Djibouti
    {  312, 5262,   70872, 12, }, // Africa/Douala
    {  312, 5185,   70884, 14, }, // Africa/El_Aaiun
    {  312, 6872,   70898, 12, }, // Africa/Freetown
    {  312, 4925,   70910, 16, }, // Africa/Gaborone
    {  312, 5034,   70926, 12, }, // Africa/Harare
    {  312, 4498,   70938, 22, }, // Africa/Johannesburg
    {  312, 4518,   70960,  8, }, // Africa/Juba
    {  312, 5170,   70968, 14, }, // Africa/Kampala
    {  312, 4543,   70982, 14, }, // Africa/Khartoum
    {  312, 4992,   70996, 12, }, // Africa/Kigali
    {  312, 5325,   71008, 14, }, // Africa/Kinshasa
    {  312, 4763,   71022, 12, }, // Africa/Lagos
    {  312, 5355,   71034, 20, }, // Africa/Libreville
    {  312, 6888,   71054,  8, }, // Africa/Lome
    {  312, 5230,   71062, 16, }, // Africa/Luanda
    {  312, 4958,   71078, 18, }, // Africa/Lubumbashi
    {  312, 5020,   71096, 12, }, // Africa/Lusaka
    {  312, 5341,   71108, 14, }, // Africa/Malabo
    {  312, 5006,   71122, 12, }, // Africa/Maputo
    {  312, 5216,   71134, 12, }, // Africa/Maseru
    {  312, 5201,   71146, 18, }, // Africa/Mbabane
    {  312, 5132,   71164, 16, }, // Africa/Mogadishu
    {  312, 7053,   71180, 16, }, // Africa/Monrovia
    {  312, 3872,   71196, 14, }, // Africa/Nairobi
    {  312, 5290,   71210, 16, }, // Africa/Ndjamena
    {  312, 5373,   71226, 12, }, // Africa/Niamey
    {  312, 6822,   71238, 20, }, // Africa/Nouakchott
    {  312, 6746,   71258, 16, }, // Africa/Ouagadougou
    {  312, 5244,   71274, 21, }, // Africa/Porto-Novo
    {  312, 4454,   71295, 19, }, // Africa/Sao_Tome
    {  312, 2868,   71314, 14, }, // Africa/Tripoli
    {  312, 6573,   71328, 12, }, // Africa/Tunis
    {  312, 4171,   71340, 14, }, // Africa/Windhoek
    {  312,  132,   71354,  8, }, // America/Adak
    {  312, 3365,   71362, 18, }, // America/Anchorage
    {  312, 5626,   71380, 14, }, // America/Anguilla
    {  312, 5643,   71394, 12, }, // America/Antigua
    {  312, 4573,   71406, 18, }, // America/Araguaina
    {  312,  166,   71424, 29, }, // America/Argentina/Buenos_Aires
    {  312,   91,   71453, 20, }, // America/Argentina/Catamarca
    {  312,  270,   71473, 16, }, // America/Argentina/Cordoba
    {  312,  441,   71489, 10, }, // America/Argentina/Jujuy
    {  312, 7462,   71499, 17, }, // America/Argentina/La_Rioja
    {  312,  565,   71516, 16, }, // America/Argentina/Mendoza
    {  312, 7489,   71532, 21, }, // America/Argentina/Rio_Gallegos
    {  312, 7520,   71553, 10, }, // America/Argentina/Salta
    {  312, 7544,   71563, 19, }, // America/Argentina/San_Juan
    {  312, 5599,   71582, 19, }, // America/Argentina/San_Luis
    {  312, 7571,   71601, 16, }, // America/Argentina/Tucuman
    {  312, 7597,   71617, 14, }, // America/Argentina/Ushuaia
    {  312, 5659,   71631, 12, }, // America/Aruba
    {  312, 4271,   71643, 18, }, // America/Asuncion
    {  312,  237,   71661, 18, }, // America/Atikokan
    {  312, 3698,   71679, 12, }, // America/Bahia
    {  312, 7623,   71691, 33, }, // America/Bahia_Banderas
    {  312, 5673,   71724, 18, }, // America/Barbados
    {  312, 7646,   71742, 10, }, // America/Belem
    {  312, 5426,   71752, 12, }, // America/Belize
    {  312, 7660,   71764, 25, }, // America/Blanc-Sablon
    {  312, 7681,   71789, 19, }, // America/Boa_Vista
    {  312, 4380,   71808, 12, }, // America/Bogota
    {  312, 7699,   71820, 12, }, // America/Boise
    {  312, 7713,   71832, 25, }, // America/Cambridge_Bay
    {  312, 7735,   71857, 23, }, // America/Campo_Grande
    {  312, 3887,   71880, 14, }, // America/Cancun
    {  312, 4713,   71894, 14, }, // America/Caracas
    {  312, 4364,   71908, 12, }, // America/Cayenne
    {  312, 5515,   71920, 14, }, // America/Cayman
    {  312, 2262,   71934, 16, }, // America/Chicago
    {  312, 7756,   71950, 16, }, // America/Chihuahua
    {  312, 5441,   71966, 21, }, // America/Costa_Rica
    {  312, 7814,   71987, 14, }, // America/Creston
    {  312, 3810,   72001, 14, }, // America/Cuiaba
    {  312, 5742,   72015, 18, }, // America/Curacao
    {  312, 7830,   72033, 26, }, // America/Danmarkshavn
    {  312, 7851,   72059, 12, }, // America/Dawson
    {  312, 7866,   72071, 21, }, // America/Dawson_Creek
    {  312,  805,   72092, 12, }, // America/Denver
    {  312, 3484,   72104, 14, }, // America/Detroit
    {  312, 5758,   72118, 18, }, // America/Dominica
    {  312,  893,   72136, 16, }, // America/Edmonton
    {  312, 7887,   72152, 14, }, // America/Eirunepe
    {  312, 5460,   72166, 23, }, // America/El_Salvador
    {  312, 7904,   72189, 22, }, // America/Fort_Nelson
    {  312, 7924,   72211, 20, }, // America/Fortaleza
    {  312, 7942,   72231, 15, }, // America/Glace_Bay
    {  312, 6900,   72246, 15, }, // America/Goose_Bay
    {  312, 4631,   72261, 19, }, // America/Grand_Turk
    {  312, 5789,   72280, 16, }, // America/Grenada
    {  312, 5805,   72296, 24, }, // America/Guadeloupe
    {  312, 3779,   72320, 20, }, // America/Guatemala
    {  312, 4860,   72340, 14, }, // America/Guayaquil
    {  312, 6951,   72354, 14, }, // America/Guyana
    {  312, 1941,   72368, 18, }, // America/Halifax
    {  312, 2283,   72386, 14, }, // America/Havana
    {  312, 7960,   72400, 24, }, // America/Hermosillo
    {  312,  348,   72424, 28, }, // America/Indiana/Indianapolis
    {  312,  481,   72452, 28, }, // America/Indiana/Knox
    {  312, 7979,   72480, 34, }, // America/Indiana/Marengo
    {  312, 8003,   72514, 40, }, // America/Indiana/Petersburg
    {  312, 8030,   72554, 37, }, // America/Indiana/Tell_City
    {  312, 8056,   72591, 32, }, // America/Indiana/Vevay
    {  312, 8078,   72623, 34, }, // America/Indiana/Vincennes
    {  312, 8104,   72657, 34, }, // America/Indiana/Winamac
    {  312, 8128,   72691, 12, }, // America/Inuvik
    {  312,  660,   72703, 16, }, // America/Iqaluit
    {  312, 2801,   72719, 16, }, // America/Jamaica
    {  312, 5399,   72735, 12, }, // America/Juneau
    {  312,  521,   72747, 12, }, // America/Kentucky/Louisville
    {  312, 8143,   72759, 40, }, // America/Kentucky/Monticello
    {  312, 5723,   72799, 20, }, // America/Kralendijk
    {  312, 4395,   72819, 13, }, // America/La_Paz
    {  312, 7169,   72832, 10, }, // America/Lima
    {  312, 3258,   72842, 21, }, // America/Los_Angeles
    {  312, 5951,   72863, 36, }, // America/Lower_Princes
    {  312, 8171,   72899, 12, }, // America/Maceio
    {  312, 8186,   72911, 14, }, // America/Managua
    {  312, 1910,   72925, 12, }, // America/Manaus
    {  312, 5916,   72937, 14, }, // America/Marigot
    {  312, 5824,   72951, 16, }, // America/Martinique
    {  312, 8202,   72967, 20, }, // America/Matamoros
    {  312, 2919,   72987, 16, }, // America/Mazatlan
    {  312, 8220,   73003, 16, }, // America/Menominee
    {  312, 8238,   73019, 12, }, // America/Merida
    {  312, 8253,   73031, 20, }, // America/Metlakatla
    {  312, 2951,   73051, 27, }, // America/Mexico_City
    {  312, 4410,   73078, 14, }, // America/Miquelon
    {  312, 8272,   73092, 16, }, // America/Moncton
    {  312, 8288,   73108, 18, }, // America/Monterrey
    {  312, 4117,   73126, 24, }, // America/Montevideo
    {  312, 5843,   73150, 20, }, // America/Montserrat
    {  312, 5500,   73170, 10, }, // America/Nassau
    {  312, 2381,   73180, 15, }, // America/New_York
    {  312, 8306,   73195, 10, }, // America/Nome
    {  312, 1852,   73205, 14, }, // America/Noronha
    {  312, 8319,   73219, 33, }, // America/North_Dakota/Beulah
    {  312, 8347,   73252, 37, }, // America/North_Dakota/Center
    {  312, 8375,   73289, 42, }, // America/North_Dakota/New_Salem
    {  312,  393,   73331,  8, }, // America/Nuuk
    {  312, 8406,   73339, 14, }, // America/Ojinaga
    {  312, 2358,   73353, 16, }, // America/Panama
    {  312, 6192,   73369, 20, }, // America/Paramaribo
    {  312, 2975,   73389, 12, }, // America/Phoenix
    {  312, 3964,   73401, 22, }, // America/Port-au-Prince
    {  312, 5973,   73423, 26, }, // America/Port_of_Spain
    {  312, 8422,   73449, 23, }, // America/Porto_Velho
    {  312, 5862,   73472, 19, }, // America/Puerto_Rico
    {  312, 4049,   73491, 23, }, // America/Punta_Arenas
    {  312, 8442,   73514, 23, }, // America/Rankin_Inlet
    {  312, 8463,   73537, 12, }, // America/Recife
    {  312, 1997,   73549, 14, }, // America/Regina
    {  312, 8478,   73563, 16, }, // America/Resolute
    {  312,  695,   73579, 21, }, // America/Rio_Branco
    {  312, 8495,   73600, 18, }, // America/Santarem
    {  312, 2203,   73618, 20, }, // America/Santiago
    {  312, 6130,   73638, 27, }, // America/Santo_Domingo
    {  312, 1880,   73665, 19, }, // America/Sao_Paulo
    {  312, 6918,   73684, 30, }, // America/Scoresbysund
    {  312, 8512,   73714, 10, }, // America/Sitka
    {  312, 8526,   73724, 27, }, // America/St_Barthelemy
    {  312, 2063,   73751, 19, }, // America/St_Johns
    {  312, 5882,   73770, 21, }, // America/St_Kitts
    {  312, 5899,   73791, 19, }, // America/St_Lucia
    {  312,  855,   73810, 21, }, // America/St_Thomas
    {  312, 5932,   73831, 23, }, // America/St_Vincent
    {  312, 8548,   73854, 23, }, // America/Swift_Current
    {  312, 5480,   73877, 22, }, // America/Tegucigalpa
    {  312, 5775,   73899,  8, }, // America/Thule
    {  312,  313,   73907, 18, }, // America/Tijuana
    {  312,  608,   73925, 16, }, // America/Toronto
    {  312, 5707,   73941, 16, }, // America/Tortola
    {  312, 2095,   73957, 16, }, // America/Vancouver
    {  312, 2146,   73973, 18, }, // America/Whitehorse
    {  312,  734,   73991, 16, }, // America/Winnipeg
    {  312, 8570,   74007, 14, }, // America/Yakutat
    {  312, 6020,   74021, 10, }, // Antarctica/Casey
    {  312, 6113,   74031, 12, }, // Antarctica/Davis
    {  312, 6152,   74043, 27, }, // Antarctica/DumontDUrville
    {  312, 8586,   74070, 14, }, // Antarctica/Macquarie
    {  312, 7085,   74084, 12, }, // Antarctica/Mawson
    {  312,  932,   74096, 18, }, // Antarctica/McMurdo
    {  312, 8607,   74114, 14, }, // Antarctica/Palmer
    {  312, 7226,   74128, 12, }, // Antarctica/Rothera
    {  312, 7295,   74140, 14, }, // Antarctica/Syowa
    {  312, 8625,   74154, 12, }, // Antarctica/Troll
    {  312, 7374,   74166, 12, }, // Antarctica/Vostok
    {  312, 1431,   74178, 24, }, // Arctic/Longyearbyen
    {  312, 5589,   74202,  8, }, // Asia/Aden
    {  312, 5414,   74210, 14, }, // Asia/Almaty
    {  312, 3987,   74224, 12, }, // Asia/Amman
    {  312, 5530,   74236, 14, }, // Asia/Anadyr
    {  312, 5542,   74250, 14, }, // Asia/Aqtau
    {  312, 5387,   74264, 14, }, // Asia/Aqtobe
    {  312,  966,   74278, 16, }, // Asia/Ashgabat
    {  312, 8642,   74294, 14, }, // Asia/Atyrau
    {  312, 3626,   74308, 16, }, // Asia/Baghdad
    {  312, 5553,   74324, 16, }, // Asia/Bahrain
    {  312, 3672,   74340, 10, }, // Asia/Baku
    {  312, 4485,   74350, 16, }, // Asia/Bangkok
    {  312, 3590,   74366, 16, }, // Asia/Barnaul
    {  312, 4105,   74382, 16, }, // Asia/Beirut
    {  312, 3797,   74398, 16, }, // Asia/Bishkek
    {  312, 6008,   74414, 12, }, // Asia/Brunei
    {  312, 4620,   74426, 10, }, // Asia/Chita
    {  312, 4530,   74436, 14, }, // Asia/Colombo
    {  312, 4559,   74450, 14, }, // Asia/Damascus
    {  312, 1095,   70821, 10, }, // Asia/Dhaka
    {  312, 6211,   74464, 10, }, // Asia/Dili
    {  312, 3615,   74474, 10, }, // Asia/Dubai
    {  312, 6178,   74484, 14, }, // Asia/Dushanbe
    {  312, 8654,   74498, 18, }, // Asia/Famagusta
    {  312, 8669,   74516, 10, }, // Asia/Gaza
    {  312, 4814,   74526, 14, }, // Asia/Hebron
    {  312, 1261,   74540, 31, }, // Asia/Ho_Chi_Minh
    {  312, 2706,   74571, 17, }, // Asia/Hong_Kong
    {  312, 4790,   74588, 10, }, // Asia/Hovd
    {  312, 4203,   74598, 18, }, // Asia/Irkutsk
    {  312, 7025,   74616, 16, }, // Asia/Jakarta
    {  312, 7011,   74632, 16, }, // Asia/Jayapura
    {  312, 1292,   74648, 12, }, // Asia/Jerusalem
    {  312, 3579,   74660, 10, }, // Asia/Kabul
    {  312, 4335,   74670, 18, }, // Asia/Kamchatka
    {  312, 4258,   74688, 14, }, // Asia/Karachi
    {  312, 1187,   74702, 18, }, // Asia/Kathmandu
    {  312, 8679,   74720, 14, }, // Asia/Khandyga
    {  312,  994,   74734, 14, }, // Asia/Kolkata
    {  312, 4216,   74748, 28, }, // Asia/Krasnoyarsk
    {  312, 4878,   74776, 27, }, // Asia/Kuala_Lumpur
    {  312, 5995,   74803, 10, }, // Asia/Kuching
    {  312, 5566,   74813, 14, }, // Asia/Kuwait
    {  312, 1213,   74827, 12, }, // Asia/Macau
    {  312, 4036,   74839, 14, }, // Asia/Magadan
    {  312, 1351,   74853, 16, }, // Asia/Makassar
    {  312, 7182,   74869, 12, }, // Asia/Manila
    {  312, 6939,   74881, 14, }, // Asia/Muscat
    {  312, 2556,   74895, 16, }, // Asia/Nicosia
    {  312, 8693,   74911, 28, }, // Asia/Novokuznetsk
    {  312, 4154,   74939, 24, }, // Asia/Novosibirsk
    {  312, 4248,   74963, 12, }, // Asia/Omsk
    {  312, 7145,   74975,  8, }, // Asia/Oral
    {  312, 6980,   74983, 17, }, // Asia/Phnom_Penh
    {  312, 8711,   75000, 20, }, // Asia/Pontianak
    {  312, 4233,   75020, 16, }, // Asia/Pyongyang
    {  312, 5578,   75036, 10, }, // Asia/Qatar
    {  312, 8726,   75046, 16, }, // Asia/Qostanay
    {  312, 4288,   75062, 18, }, // Asia/Qyzylorda
    {  312, 3603,   75080, 12, }, // Asia/Riyadh
    {  312, 4427,   75092, 16, }, // Asia/Sakhalin
    {  312, 7245,   75108, 20, }, // Asia/Samarkand
    {  312, 3298,   75128, 10, }, // Asia/Seoul
    {  312, 1055,   75138, 12, }, // Asia/Shanghai
    {  312, 3319,   75150, 18, }, // Asia/Singapore
    {  312, 4316,   75168, 24, }, // Asia/Srednekolymsk
    {  312, 3282,   75192, 12, }, // Asia/Taipei
    {  312, 4800,   75204, 16, }, // Asia/Tashkent
    {  312, 3934,   75220, 18, }, // Asia/Tbilisi
    {  312, 2774,   75238, 16, }, // Asia/Tehran
    {  312, 1319,   75254, 10, }, // Asia/Thimphu
    {  312, 2823,   75264, 12, }, // Asia/Tokyo
    {  312, 4591,   75276, 14, }, // Asia/Tomsk
    {  312, 1023,   75290, 18, }, // Asia/Ulaanbaatar
    {  312, 1161,   75308, 12, }, // Asia/Urumqi
    {  312, 8740,   75320, 17, }, // Asia/Ust-Nera
    {  312, 6996,   75337, 18, }, // Asia/Vientiane
    {  312, 4729,   75355, 28, }, // Asia/Vladivostok
    {  312, 4847,   75383, 18, }, // Asia/Yakutsk
    {  312, 1237,   75401, 14, }, // Asia/Yangon
    {  312, 3902,   75415, 28, }, // Asia/Yekaterinburg
    {  312, 3766,   75443, 16, }, // Asia/Yerevan
    {  312, 3682,   75459, 14, }, // Atlantic/Azores
    {  312, 5690,   75473, 16, }, // Atlantic/Bermuda
    {  312, 6647,   75489, 12, }, // Atlantic/Canary
    {  312, 3746,   75501, 21, }, // Atlantic/Cape_Verde
    {  312, 1397,   75522, 10, }, // Atlantic/Faroe
    {  312, 8754,   75532, 14, }, // Atlantic/Madeira
    {  312, 2750,   75546, 18, }, // Atlantic/Reykjavik
    {  312, 7272,   75564, 25, }, // Atlantic/South_Georgia
    {  312, 6840,   75589, 23, }, // Atlantic/St_Helena
    {  312, 6663,   75612, 16, }, // Atlantic/Stanley
    {  312, 1672,   75628, 16, }, // Australia/Adelaide
    {  312, 1637,   75644, 20, }, // Australia/Brisbane
    {  312, 1801,   75664, 21, }, // Australia/Broken_Hill
    {  312, 1585,   75685, 14, }, // Australia/Darwin
    {  312, 3656,   75699, 12, }, // Australia/Eucla
    {  312, 1518,   75711, 16, }, // Australia/Hobart
    {  312, 8771,   75727, 20, }, // Australia/Lindeman
    {  312, 1549,   75747, 19, }, // Australia/Lord_Howe
    {  312, 1729,   75766, 18, }, // Australia/Melbourne
    {  312, 1764,   75784, 10, }, // Australia/Perth
    {  312, 1465,   75794, 12, }, // Australia/Sydney
    {  312, 6460,   75806, 22, }, // Europe/Amsterdam
    {  312, 6235,   75828, 14, }, // Europe/Andorra
    {  312, 3639,   75842, 18, }, // Europe/Astrakhan
    {  312, 2302,   75860, 12, }, // Europe/Athens
    {  312, 6355,   75872, 18, }, // Europe/Belgrade
    {  312, 4776,   75890, 12, }, // Europe/Berlin
    {  312, 6507,   75902, 22, }, // Europe/Bratislava
    {  312, 2169,   75924, 16, }, // Europe/Brussels
    {  312, 3947,   75940, 18, }, // Europe/Bucharest
    {  312, 3825,   75958, 16, }, // Europe/Budapest
    {  312, 8790,   75974, 16, }, // Europe/Busingen
    {  312, 2585,   75990, 18, }, // Europe/Chisinau
    {  312, 6308,   76008, 18, }, // Europe/Copenhagen
    {  312, 2340,   76026, 14, }, // Europe/Dublin
    {  312, 6326,   76040, 20, }, // Europe/Gibraltar
    {  312, 8806,   76060, 16, }, // Europe/Guernsey
    {  312, 6631,   76076, 16, }, // Europe/Helsinki
    {  312, 8822,   76092, 23, }, // Europe/Isle_of_Man
    {  312, 1132,   76115, 16, }, // Europe/Istanbul
    {  312, 8841,   76131, 12, }, // Europe/Jersey
    {  312, 3998,   76143, 18, }, // Europe/Kaliningrad
    {  312, 8855,   76161, 14, }, // Europe/Kirov
    {  312, 2529,   76175, 12, }, // Europe/Kyiv
    {  312, 3232,   76187, 14, }, // Europe/Lisbon
    {  312, 6525,   76201, 20, }, // Europe/Ljubljana
    {  312, 2503,   76221, 12, }, // Europe/London
    {  312, 6384,   76233, 22, }, // Europe/Luxembourg
    {  312, 4911,   76255, 14, }, // Europe/Madrid
    {  312, 6416,   76269, 10, }, // Europe/Malta
    {  312, 6601,   76279, 26, }, // Europe/Mariehamn
    {  312, 3712,   76305, 14, }, // Europe/Minsk
    {  312, 6429,   76319, 14, }, // Europe/Monaco
    {  312, 3556,   76333, 10, }, // Europe/Moscow
    {  312, 6477,   76343, 10, }, // Europe/Oslo
    {  312, 4303,   76353,  8, }, // Europe/Paris
    {  312, 6443,   76361, 20, }, // Europe/Podgorica
    {  312, 6294,   76381, 14, }, // Europe/Prague
    {  312, 8868,   76395,  8, }, // Europe/Riga
    {  312, 6343,   76403, 10, }, // Europe/Rome
    {  312, 4350,   76413, 12, }, // Europe/Samara
    {  312, 6489,   76425, 19, }, // Europe/San_Marino
    {  312, 6264,   76444, 18, }, // Europe/Sarajevo
    {  312, 4470,   76462, 16, }, // Europe/Saratov
    {  312, 8880,   76478, 20, }, // Europe/Simferopol
    {  312, 6402,   76498, 18, }, // Europe/Skopje
    {  312, 6618,   76516, 12, }, // Europe/Sofia
    {  312, 6542,   76528, 18, }, // Europe/Stockholm
    {  312, 8898,   76546, 14, }, // Europe/Tallinn
    {  312, 6221,   76560, 12, }, // Europe/Tirane
    {  312, 8913,   76572, 22, }, // Europe/Ulyanovsk
    {  312, 6371,   76594, 14, }, // Europe/Vaduz
    {  312, 6586,   76608, 14, }, // Europe/Vatican
    {  312, 6250,   76622, 14, }, // Europe/Vienna
    {  312, 8930,   76636, 14, }, // Europe/Vilnius
    {  312, 4746,   76650, 20, }, // Europe/Volgograd
    {  312, 3209,   76670, 10, }, // Europe/Warsaw
    {  312, 6280,   76680, 14, }, // Europe/Zagreb
    {  312, 6559,   76694, 10, }, // Europe/Zurich
    {  312, 5097,   76704, 28, }, // Indian/Antananarivo
    {  312, 6966,   76732, 10, }, // Indian/Chagos
    {  312, 6065,   76742, 18, }, // Indian/Christmas
    {  312, 6082,   76760, 12, }, // Indian/Cocos
    {  312, 5048,   76772, 14, }, // Indian/Comoro
    {  312, 6680,   76786, 16, }, // Indian/Kerguelen
    {  312, 7260,   76802, 10, }, // Indian/Mahe
    {  312, 7069,   76812, 18, }, // Indian/Maldives
    {  312, 4088,   76830, 14, }, // Indian/Mauritius
    {  312, 5117,   76844, 14, }, // Indian/Mayotte
    {  312, 7211,   76858, 16, }, // Indian/Reunion
    {  312, 4441,   76874, 12, }, // Pacific/Apia
    {  312, 3009,   76886, 14, }, // Pacific/Auckland
    {  312, 3725,   76900, 18, }, // Pacific/Bougainville
    {  312, 3034,   76918, 12, }, // Pacific/Chatham
    {  312, 3176,   76930, 10, }, // Pacific/Chuuk
    {  312, 2239,   76940, 10, }, // Pacific/Easter
    {  312, 7360,   76950, 10, }, // Pacific/Efate
    {  312, 7327,   76960, 14, }, // Pacific/Fakaofo
    {  312, 3921,   76974, 10, }, // Pacific/Fiji
    {  312, 7343,   76984, 18, }, // Pacific/Funafuti
    {  312, 6697,   77002, 18, }, // Pacific/Galapagos
    {  312, 6715,   77020, 16, }, // Pacific/Gambier
    {  312, 3841,   77036, 24, }, // Pacific/Guadalcanal
    {  312, 6037,   77060, 12, }, // Pacific/Guam
    {  312, 3068,   77072, 12, }, // Pacific/Kanton
    {  312, 4017,   77084, 20, }, // Pacific/Kiritimati
    {  312, 7038,   77104, 12, }, // Pacific/Kosrae
    {  312, 2844,   77116, 20, }, // Pacific/Kwajalein
    {  312, 4896,   77136, 14, }, // Pacific/Majuro
    {  312, 4070,   77150, 18, }, // Pacific/Marquesas
    {  312, 8945,   77168, 12, }, // Pacific/Midway
    {  312, 7103,   77180, 10, }, // Pacific/Nauru
    {  312, 7132,   77190, 10, }, // Pacific/Niue
    {  312, 4187,   77200, 16, }, // Pacific/Norfolk
    {  312, 7117,   77216, 12, }, // Pacific/Noumea
    {  312, 3145,   77228, 17, }, // Pacific/Pago_Pago
    {  312, 7155,   77245, 10, }, // Pacific/Palau
    {  312, 7194,   77255, 18, }, // Pacific/Pitcairn
    {  312, 3115,   77273, 12, }, // Pacific/Pohnpei
    {  312, 4826,   77285, 25, }, // Pacific/Port_Moresby
    {  312, 6095,   77310, 18, }, // Pacific/Rarotonga
    {  312, 6050,   77328, 14, }, // Pacific/Saipan
    {  312, 7312,   77342, 14, }, // Pacific/Tahiti
    {  312, 6731,   77356, 14, }, // Pacific/Tarawa
    {  312, 4602,   77370, 20, }, // Pacific/Tongatapu
    {  312, 7392,   77390, 10, }, // Pacific/Wake
    {  312, 7405,   77400, 14, }, // Pacific/Wallis
    {  330, 5078,   77414, 11, }, // Africa/Addis_Ababa Gaelic/Latin/United Kingdom
    {  330,   14,   77425,  6, }, // Africa/Asmara
    {  330, 5149,   77431, 12, }, // Africa/Dar_es_Salaam
    {  330, 5062,   77443, 10, }, // Africa/Djibouti
    {  330, 5185,       6,  8, }, // Africa/El_Aaiun
    {  330, 4498,   77453, 11, }, // Africa/Johannesburg
    {  330, 6888,      14,  4, }, // Africa/Lome
    {  330, 5290,   77464,  9, }, // Africa/Ndjamena
    {  330, 4454,      27,  8, }, // Africa/Sao_Tome
    {  330, 5626,   77473,  9, }, // America/Anguilla
    {  330, 5643,   77482,  8, }, // America/Antigua
    {  330, 4573,      35,  9, }, // America/Araguaina
    {  330,  270,      44,  7, }, // America/Argentina/Cordoba
    {  330, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  330, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  330, 5659,   77490,  5, }, // America/Aruba
    {  330, 4271,      70,  8, }, // America/Asuncion
    {  330,  237,      78,  8, }, // America/Atikokan
    {  330, 7623,      86, 17, }, // America/Bahia_Banderas
    {  330, 7646,     103,  5, }, // America/Belem
    {  330, 5426,   77495, 10, }, // America/Belize
    {  330, 4380,     108,  6, }, // America/Bogota
    {  330, 3887,     114,  6, }, // America/Cancun
    {  330, 5515,   77505,  7, }, // America/Cayman
    {  330, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  330, 5441,   77512, 11, }, // America/Costa_Rica
    {  330, 3810,     133,  6, }, // America/Cuiaba
    {  330, 5742,     139,  7, }, // America/Curacao
    {  330, 5758,   77523, 10, }, // America/Dominica
    {  330, 7887,     146,  8, }, // America/Eirunepe
    {  330, 5460,   77533, 12, }, // America/El_Salvador
    {  330, 7942,   77545,  9, }, // America/Glace_Bay
    {  330, 4631,   77554, 12, }, // America/Grand_Turk
    {  330, 5789,   77566,  8, }, // America/Grenada
    {  330, 5805,   21187,  8, }, // America/Guadeloupe
    {  330, 3779,   77574,  9, }, // America/Guatemala
    {  330, 6951,   77583,  9, }, // America/Guyana
    {  330,  481,     154, 13, }, // America/Indiana/Knox
    {  330, 7979,     167, 16, }, // America/Indiana/Marengo
    {  330, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  330, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  330, 8056,     220, 14, }, // America/Indiana/Vevay
    {  330, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  330, 8104,     252, 16, }, // America/Indiana/Winamac
    {  330, 8128,   77592,  7, }, // America/Inuvik
    {  330, 2801,   77599,  8, }, // America/Jamaica
    {  330, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  330, 5951,     288, 22, }, // America/Lower_Princes
    {  330, 8171,     310,  6, }, // America/Maceio
    {  330, 5824,   77607,  9, }, // America/Martinique
    {  330, 2919,     316,  8, }, // America/Mazatlan
    {  330, 8238,     324,  6, }, // America/Merida
    {  330, 2951,   77616, 17, }, // America/Mexico_City
    {  330, 4410,     341, 12, }, // America/Miquelon
    {  330, 5843,   77633,  9, }, // America/Montserrat
    {  330, 2381,   77642, 13, }, // America/New_York
    {  330, 1852,     353, 19, }, // America/Noronha
    {  330, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  330, 8347,     392, 20, }, // America/North_Dakota/Center
    {  330, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  330,  393,     435,  4, }, // America/Nuuk
    {  330, 5973,   77655, 15, }, // America/Port_of_Spain
    {  330, 5862,   77670, 11, }, // America/Puerto_Rico
    {  330, 8442,   77681, 11, }, // America/Rankin_Inlet
    {  330, 8478,   77692, 10, }, // America/Resolute
    {  330, 8495,     439,  8, }, // America/Santarem
    {  330, 1880,     447,  9, }, // America/Sao_Paulo
    {  330, 6918,     456, 16, }, // America/Scoresbysund
    {  330, 8526,   46137, 16, }, // America/St_Barthelemy
    {  330, 2063,     486, 10, }, // America/St_Johns
    {  330, 5882,   77702, 14, }, // America/St_Kitts
    {  330, 5899,   77716, 12, }, // America/St_Lucia
    {  330,  855,     514, 10, }, // America/St_Thomas
    {  330, 5932,   77728, 15, }, // America/St_Vincent
    {  330, 5775,   29116,  7, }, // America/Thule
    {  330, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  330, 8586,   77743, 17, }, // Antarctica/Macquarie
    {  330, 7295,     643,  5, }, // Antarctica/Syowa
    {  330, 3987,   77760,  5, }, // Asia/Amman
    {  330, 5387,   58394,  6, }, // Asia/Aqtobe
    {  330,  966,   46182,  7, }, // Asia/Ashgabat
    {  330, 3626,   77765,  7, }, // Asia/Baghdad
    {  330, 5553,   77772,  8, }, // Asia/Bahrain
    {  330, 3797,   35493,  6, }, // Asia/Bishkek
    {  330, 6008,   77780,  8, }, // Asia/Brunei
    {  330, 6178,   35506,  7, }, // Asia/Dushanbe
    {  330, 8669,   77788,  4, }, // Asia/Gaza
    {  330, 1261,   77792, 19, }, // Asia/Ho_Chi_Minh
    {  330, 4790,     704,  5, }, // Asia/Hovd
    {  330, 1292,   77811,  9, }, // Asia/Jerusalem
    {  330, 4258,   77820,  6, }, // Asia/Karachi
    {  330, 1187,     709,  9, }, // Asia/Kathmandu
    {  330,  994,     718,  7, }, // Asia/Kolkata
    {  330, 5566,   77826,  8, }, // Asia/Kuwait
    {  330, 1213,   77834,  7, }, // Asia/Macau
    {  330, 4233,   77841, 10, }, // Asia/Pyongyang
    {  330, 5578,   77851,  5, }, // Asia/Qatar
    {  330, 8726,   77856,  8, }, // Asia/Qostanay
    {  330, 4288,   23192,  9, }, // Asia/Qyzylorda
    {  330, 3319,   77864,  9, }, // Asia/Singapore
    {  330, 4800,   77873,  7, }, // Asia/Tashkent
    {  330, 3934,   77880,  8, }, // Asia/Tbilisi
    {  330, 2774,   77888,  6, }, // Asia/Tehran
    {  330, 2823,   68435,  5, }, // Asia/Tokyo
    {  330, 1161,     747,  6, }, // Asia/Urumqi
    {  330, 6996,   77894, 10, }, // Asia/Vientiane
    {  330, 1237,    8533,  6, }, // Asia/Yangon
    {  330, 3682,   77904, 13, }, // Atlantic/Azores
    {  330, 5690,   77917,  8, }, // Atlantic/Bermuda
    {  330, 6647,   77925, 22, }, // Atlantic/Canary
    {  330, 3746,   77947, 13, }, // Atlantic/Cape_Verde
    {  330, 1397,   77960,  4, }, // Atlantic/Faroe
    {  330, 2750,   38132,  9, }, // Atlantic/Reykjavik
    {  330, 7272,   77964, 14, }, // Atlantic/South_Georgia
    {  330, 6840,   77978, 19, }, // Atlantic/St_Helena
    {  330, 1465,    6547,  5, }, // Australia/Sydney
    {  330, 2302,   77997,  9, }, // Europe/Athens
    {  330, 2169,   78006, 12, }, // Europe/Brussels
    {  330, 8790,     799,  8, }, // Europe/Busingen
    {  330, 2585,     807,  8, }, // Europe/Chisinau
    {  330, 6308,   78018,  6, }, // Europe/Copenhagen
    {  330, 2340,   78024, 17, }, // Europe/Dublin
    {  330, 6326,   78041, 10, }, // Europe/Gibraltar
    {  330, 8806,   78051, 10, }, // Europe/Guernsey
    {  330, 8822,   78061, 15, }, // Europe/Isle_of_Man
    {  330, 8841,   78076,  9, }, // Europe/Jersey
    {  330, 2529,    8801,  4, }, // Europe/Kyiv
    {  330, 2503,   78085, 20, }, // Europe/London
    {  330, 6384,   78105, 10, }, // Europe/Luxembourg
    {  330, 3556,   78115,  5, }, // Europe/Moscow
    {  330, 4303,   78120,  5, }, // Europe/Paris
    {  330, 6294,   78125,  4, }, // Europe/Prague
    {  330, 8868,   78129,  4, }, // Europe/Riga
    {  330, 6343,   78133,  8, }, // Europe/Rome
    {  330, 6618,   23578,  6, }, // Europe/Sofia
    {  330, 6221,    8914,  6, }, // Europe/Tirane
    {  330, 6586,   78141, 11, }, // Europe/Vatican
    {  330, 6559,    5217,  6, }, // Europe/Zurich
    {  330, 6065,   78152,  7, }, // Indian/Christmas
    {  330, 5048,    4421,  7, }, // Indian/Comoro
    {  330, 6680,   38263,  9, }, // Indian/Kerguelen
    {  330, 7260,     896,  4, }, // Indian/Mahe
    {  330, 7069,   78159, 24, }, // Indian/Maldives
    {  330, 4088,   78183, 24, }, // Indian/Mauritius
    {  330, 7211,     900,  7, }, // Indian/Reunion
    {  330, 3176,     922,  5, }, // Pacific/Chuuk
    {  330, 2239,   78207,  8, }, // Pacific/Easter
    {  330, 3921,   78215,  4, }, // Pacific/Fiji
    {  330, 6697,     940,  9, }, // Pacific/Galapagos
    {  330, 6715,   78219,  9, }, // Pacific/Gambier
    {  330, 2725,    5251,  8, }, // Pacific/Honolulu
    {  330, 3068,   78228, 13, }, // Pacific/Kanton
    {  330, 4070,   78241, 20, }, // Pacific/Marquesas
    {  330, 7103,   78261,  6, }, // Pacific/Nauru
    {  330, 7117,    1028,  6, }, // Pacific/Noumea
    {  330, 7155,   78267,  6, }, // Pacific/Palau
    {  330, 7194,   78273, 14, }, // Pacific/Pitcairn
    {  330, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  330, 7405,   78287,  6, }, // Pacific/Wallis
    {  331, 6779,      55,  2, }, // Africa/Accra Ga/Latin/Ghana
    {  331,   14,       0,  6, }, // Africa/Asmara
    {  331, 2322,    5363,  5, }, // Africa/Cairo
    {  331, 4136,   21991, 10, }, // Africa/Casablanca
    {  331, 6792,   28859,  7, }, // Africa/Conakry
    {  331, 5185,       6,  8, }, // Africa/El_Aaiun
    {  331, 6888,      14,  4, }, // Africa/Lome
    {  331, 5290,      18,  9, }, // Africa/Ndjamena
    {  331, 6822,   78293, 10, }, // Africa/Nouakchott
    {  331, 4454,      27,  8, }, // Africa/Sao_Tome
    {  331, 3365,   78303,  8, }, // America/Anchorage
    {  331, 4573,      35,  9, }, // America/Araguaina
    {  331,  270,      44,  7, }, // America/Argentina/Cordoba
    {  331, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  331, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  331, 4271,      70,  8, }, // America/Asuncion
    {  331,  237,      78,  8, }, // America/Atikokan
    {  331, 7623,      86, 17, }, // America/Bahia_Banderas
    {  331, 7646,     103,  5, }, // America/Belem
    {  331, 7660,    7271, 12, }, // America/Blanc-Sablon
    {  331, 4380,     108,  6, }, // America/Bogota
    {  331, 7713,   78311, 25, }, // America/Cambridge_Bay
    {  331, 3887,    5574,  6, }, // America/Cancun
    {  331, 5515,   22267,  6, }, // America/Cayman
    {  331, 2262,   78336,  7, }, // America/Chicago
    {  331, 7756,   78343,  9, }, // America/Chihuahua
    {  331, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  331, 5441,   22287, 10, }, // America/Costa_Rica
    {  331, 7814,    7389,  7, }, // America/Creston
    {  331, 3810,     133,  6, }, // America/Cuiaba
    {  331, 5742,    7402,  7, }, // America/Curacao
    {  331, 7866,   78352, 21, }, // America/Dawson_Creek
    {  331, 5758,   22339,  8, }, // America/Dominica
    {  331, 7887,     146,  8, }, // America/Eirunepe
    {  331, 7904,   78373, 10, }, // America/Fort_Nelson
    {  331, 7942,   78383, 21, }, // America/Glace_Bay
    {  331, 6900,   78404, 21, }, // America/Goose_Bay
    {  331, 4631,   78425, 10, }, // America/Grand_Turk
    {  331, 1941,   78435,  7, }, // America/Halifax
    {  331,  481,   78442, 13, }, // America/Indiana/Knox
    {  331, 7979,     167, 16, }, // America/Indiana/Marengo
    {  331, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  331, 8030,   78455, 19, }, // America/Indiana/Tell_City
    {  331, 8056,     220, 14, }, // America/Indiana/Vevay
    {  331, 8078,   78474, 18, }, // America/Indiana/Vincennes
    {  331, 8104,    5824, 16, }, // America/Indiana/Winamac
    {  331,  660,    5840,  7, }, // America/Iqaluit
    {  331, 2801,    4507,  7, }, // America/Jamaica
    {  331, 8143,   78492, 19, }, // America/Kentucky/Monticello
    {  331, 5951,   78511, 26, }, // America/Lower_Princes
    {  331, 8171,     310,  6, }, // America/Maceio
    {  331, 5824,    5923,  8, }, // America/Martinique
    {  331, 2919,     316,  8, }, // America/Mazatlan
    {  331, 8238,     324,  6, }, // America/Merida
    {  331, 2951,   78537, 10, }, // America/Mexico_City
    {  331, 4410,    7802,  7, }, // America/Miquelon
    {  331, 8272,    7809,  7, }, // America/Moncton
    {  331, 1852,     353, 19, }, // America/Noronha
    {  331, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  331, 8347,   78547, 23, }, // America/North_Dakota/Center
    {  331, 8375,   78570, 26, }, // America/North_Dakota/New_Salem
    {  331,  393,     435,  4, }, // America/Nuuk
    {  331, 3964,   78596, 21, }, // America/Port-au-Prince
    {  331, 5973,   78617, 18, }, // America/Port_of_Spain
    {  331, 5862,   22731, 11, }, // America/Puerto_Rico
    {  331, 8442,   78635, 15, }, // America/Rankin_Inlet
    {  331, 8495,     439,  8, }, // America/Santarem
    {  331, 1880,     447,  9, }, // America/Sao_Paulo
    {  331, 6918,   78650, 15, }, // America/Scoresbysund
    {  331, 8526,     472, 14, }, // America/St_Barthelemy
    {  331, 2063,     486, 10, }, // America/St_Johns
    {  331, 5882,     496,  9, }, // America/St_Kitts
    {  331, 5899,   78665,  9, }, // America/St_Lucia
    {  331,  855,     514, 10, }, // America/St_Thomas
    {  331, 5932,   78674, 11, }, // America/St_Vincent
    {  331, 8548,   78685, 12, }, // America/Swift_Current
    {  331, 5480,    6191, 11, }, // America/Tegucigalpa
    {  331, 2095,   78697,  9, }, // America/Vancouver
    {  331, 2146,   78706, 10, }, // America/Whitehorse
    {  331, 6020,   78716,  5, }, // Antarctica/Casey
    {  331, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  331, 8586,   78721,  8, }, // Antarctica/Macquarie
    {  331,  932,   78729,  8, }, // Antarctica/McMurdo
    {  331, 7295,     643,  5, }, // Antarctica/Syowa
    {  331, 5542,     683,  5, }, // Asia/Aqtau
    {  331, 5387,    8259,  6, }, // Asia/Aqtobe
    {  331, 4530,    6295,  7, }, // Asia/Colombo
    {  331, 4559,   29141,  7, }, // Asia/Damascus
    {  331, 1261,   78737, 20, }, // Asia/Ho_Chi_Minh
    {  331, 4790,     704,  5, }, // Asia/Hovd
    {  331, 1292,    6342,  9, }, // Asia/Jerusalem
    {  331, 4258,   78757,  7, }, // Asia/Karachi
    {  331, 1187,     709,  9, }, // Asia/Kathmandu
    {  331,  994,     718,  7, }, // Asia/Kolkata
    {  331, 5995,   78764,  7, }, // Asia/Kuching
    {  331, 1213,    8384,  5, }, // Asia/Macau
    {  331, 6939,    4966,  6, }, // Asia/Muscat
    {  331, 2556,    6387,  7, }, // Asia/Nicosia
    {  331, 5578,    4972,  4, }, // Asia/Qatar
    {  331, 8726,     730,  8, }, // Asia/Qostanay
    {  331, 4288,     738,  9, }, // Asia/Qyzylorda
    {  331, 1161,   78771,  6, }, // Asia/Urumqi
    {  331, 1237,     753,  6, }, // Asia/Yangon
    {  331, 6647,    4413,  8, }, // Atlantic/Canary
    {  331, 3746,   23313, 10, }, // Atlantic/Cape_Verde
    {  331, 1397,     767,  5, }, // Atlantic/Faroe
    {  331, 6840,     773, 10, }, // Atlantic/St_Helena
    {  331, 1801,   78777, 15, }, // Australia/Broken_Hill
    {  331, 3656,   23381,  5, }, // Australia/Eucla
    {  331, 1549,   78792, 11, }, // Australia/Lord_Howe
    {  331, 8790,     799,  8, }, // Europe/Busingen
    {  331, 2585,     807,  8, }, // Europe/Chisinau
    {  331, 2529,     815,  4, }, // Europe/Kyiv
    {  331, 6221,     819,  6, }, // Europe/Tirane
    {  331, 6966,   78803,  6, }, // Indian/Chagos
    {  331, 6065,   78809,  7, }, // Indian/Christmas
    {  331, 6082,    5223,  5, }, // Indian/Cocos
    {  331, 5048,   23644,  6, }, // Indian/Comoro
    {  331, 7260,     896,  4, }, // Indian/Mahe
    {  331, 7211,     900,  7, }, // Indian/Reunion
    {  331, 3009,   78816,  6, }, // Pacific/Auckland
    {  331, 3034,   78822,  7, }, // Pacific/Chatham
    {  331, 3176,   78829,  5, }, // Pacific/Chuuk
    {  331, 6697,     940,  9, }, // Pacific/Galapagos
    {  331, 3841,    9019, 11, }, // Pacific/Guadalcanal
    {  331, 3068,     957,  6, }, // Pacific/Kanton
    {  331, 4070,   78834,  9, }, // Pacific/Marquesas
    {  331, 7117,    1028,  6, }, // Pacific/Noumea
    {  331, 7194,    6893,  8, }, // Pacific/Pitcairn
    {  331, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  331, 7405,    1068, 15, }, // Pacific/Wallis
    {  332, 6779,   78843,  4, }, // Africa/Accra Galician/Latin/Spain
    {  332, 5078,   21055, 10, }, // Africa/Addis_Ababa
    {  332, 7420,   78847,  5, }, // Africa/Algiers
    {  332,   14,       0,  6, }, // Africa/Asmara
    {  332,   44,   78852,  6, }, // Africa/Bamako
    {  332, 2322,   78858,  7, }, // Africa/Cairo
    {  332, 5062,   28866,  7, }, // Africa/Djibouti
    {  332, 5185,   78865,  6, }, // Africa/El_Aaiun
    {  332, 4498,   78871, 12, }, // Africa/Johannesburg
    {  332, 4543,   78883,  7, }, // Africa/Khartoum
    {  332, 6888,      14,  4, }, // Africa/Lome
    {  332, 5020,   78890,  6, }, // Africa/Lusaka
    {  332, 5132,   78896,  8, }, // Africa/Mogadishu
    {  332, 5290,      18,  9, }, // Africa/Ndjamena
    {  332, 6746,   28908,  8, }, // Africa/Ouagadougou
    {  332, 4454,   78904,  8, }, // Africa/Sao_Tome
    {  332, 2868,   21148,  7, }, // Africa/Tripoli
    {  332, 6573,   78912,  5, }, // Africa/Tunis
    {  332, 5626,    5439,  7, }, // America/Anguilla
    {  332, 4573,      35,  9, }, // America/Araguaina
    {  332,  270,      44,  7, }, // America/Argentina/Cordoba
    {  332, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  332, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  332, 4271,      70,  8, }, // America/Asuncion
    {  332,  237,      78,  8, }, // America/Atikokan
    {  332, 3698,   78917,  4, }, // America/Bahia
    {  332, 7623,      86, 17, }, // America/Bahia_Banderas
    {  332, 7646,     103,  5, }, // America/Belem
    {  332, 4380,     108,  6, }, // America/Bogota
    {  332, 3887,     114,  6, }, // America/Cancun
    {  332, 4364,   46011,  6, }, // America/Cayenne
    {  332, 5515,   78921, 12, }, // America/Cayman
    {  332, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  332, 7796,   78933,  9, }, // America/Coyhaique
    {  332, 3810,     133,  6, }, // America/Cuiaba
    {  332, 5742,     139,  7, }, // America/Curacao
    {  332, 7887,     146,  8, }, // America/Eirunepe
    {  332, 5460,   78942, 10, }, // America/El_Salvador
    {  332, 5789,   21180,  7, }, // America/Grenada
    {  332, 5805,   21187,  9, }, // America/Guadeloupe
    {  332, 6951,   78952,  6, }, // America/Guyana
    {  332, 2283,   78958,  8, }, // America/Havana
    {  332,  348,   78966, 12, }, // America/Indiana/Indianapolis
    {  332,  481,     154, 13, }, // America/Indiana/Knox
    {  332, 7979,     167, 16, }, // America/Indiana/Marengo
    {  332, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  332, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  332, 8056,     220, 14, }, // America/Indiana/Vevay
    {  332, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  332, 8104,     252, 16, }, // America/Indiana/Winamac
    {  332, 2801,   21205,  7, }, // America/Jamaica
    {  332, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  332, 4395,   78978,  5, }, // America/La_Paz
    {  332, 3258,   78983, 10, }, // America/Los_Angeles
    {  332, 5951,     288, 22, }, // America/Lower_Princes
    {  332, 8171,     310,  6, }, // America/Maceio
    {  332, 5824,   21215,  9, }, // America/Martinique
    {  332, 2919,     316,  8, }, // America/Mazatlan
    {  332, 8238,     324,  6, }, // America/Merida
    {  332, 2951,   78993, 16, }, // America/Mexico_City
    {  332, 4410,     341, 12, }, // America/Miquelon
    {  332, 2381,   46038,  9, }, // America/New_York
    {  332, 1852,     353, 19, }, // America/Noronha
    {  332, 8319,   79009, 23, }, // America/North_Dakota/Beulah
    {  332, 8347,   79032, 23, }, // America/North_Dakota/Center
    {  332, 8375,   79055, 26, }, // America/North_Dakota/New_Salem
    {  332,  393,     435,  4, }, // America/Nuuk
    {  332, 2358,   21326,  6, }, // America/Panama
    {  332, 3964,   79081, 14, }, // America/Port-au-Prince
    {  332, 5973,   79095, 12, }, // America/Port_of_Spain
    {  332, 5862,   69711, 10, }, // America/Puerto_Rico
    {  332,  695,   79107, 10, }, // America/Rio_Branco
    {  332, 8495,     439,  8, }, // America/Santarem
    {  332, 1880,     447,  9, }, // America/Sao_Paulo
    {  332, 6918,     456, 16, }, // America/Scoresbysund
    {  332, 8526,   46137, 16, }, // America/St_Barthelemy
    {  332, 2063,   29057, 12, }, // America/St_Johns
    {  332, 5882,   29069, 11, }, // America/St_Kitts
    {  332, 5899,   79117, 11, }, // America/St_Lucia
    {  332,  855,   46153, 12, }, // America/St_Thomas
    {  332, 5932,   79128, 11, }, // America/St_Vincent
    {  332, 5707,   21384,  7, }, // America/Tortola
    {  332, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  332, 7295,     643,  5, }, // Antarctica/Syowa
    {  332, 5589,   79139,  4, }, // Asia/Aden
    {  332, 5414,    8247,  6, }, // Asia/Almaty
    {  332, 3987,   21391,  4, }, // Asia/Amman
    {  332, 5542,     683,  5, }, // Asia/Aqtau
    {  332, 5387,    8259,  6, }, // Asia/Aqtobe
    {  332,  966,   79143,  9, }, // Asia/Ashgabat
    {  332, 3626,    4802,  6, }, // Asia/Baghdad
    {  332, 3672,   79152,  4, }, // Asia/Baku
    {  332, 4620,   79156,  5, }, // Asia/Chita
    {  332, 4559,   79161,  7, }, // Asia/Damascus
    {  332, 4814,   21432,  6, }, // Asia/Hebron
    {  332, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  332, 4790,     704,  5, }, // Asia/Hovd
    {  332, 7025,   79168,  7, }, // Asia/Jakarta
    {  332, 1292,   21482,  9, }, // Asia/Jerusalem
    {  332, 3579,   79175,  5, }, // Asia/Kabul
    {  332, 1187,   21491,  8, }, // Asia/Kathmandu
    {  332, 8679,   62724,  8, }, // Asia/Khandyga
    {  332,  994,   21499,  7, }, // Asia/Kolkata
    {  332, 1213,    4961,  5, }, // Asia/Macau
    {  332, 6939,   21518,  7, }, // Asia/Muscat
    {  332, 8726,   46251,  8, }, // Asia/Qostanay
    {  332, 4288,     738,  9, }, // Asia/Qyzylorda
    {  332, 3603,    8440,  4, }, // Asia/Riyadh
    {  332, 4427,   46259,  8, }, // Asia/Sakhalin
    {  332, 7245,   21547, 10, }, // Asia/Samarkand
    {  332, 3298,   21557,  4, }, // Asia/Seoul
    {  332, 3319,   21561,  8, }, // Asia/Singapore
    {  332, 4316,    8470, 13, }, // Asia/Srednekolymsk
    {  332, 2774,   62829,  7, }, // Asia/Tehran
    {  332, 1161,     747,  6, }, // Asia/Urumqi
    {  332, 4847,   46301,  7, }, // Asia/Yakutsk
    {  332, 1237,     753,  6, }, // Asia/Yangon
    {  332, 3902,   79180, 13, }, // Asia/Yekaterinburg
    {  332, 3766,   79193,  7, }, // Asia/Yerevan
    {  332, 5690,   79200, 14, }, // Atlantic/Bermuda
    {  332, 6647,   79214, 14, }, // Atlantic/Canary
    {  332, 3746,   29268, 10, }, // Atlantic/Cape_Verde
    {  332, 1397,   21645,  5, }, // Atlantic/Faroe
    {  332, 2750,   79228, 10, }, // Atlantic/Reykjavik
    {  332, 7272,   79238, 14, }, // Atlantic/South_Georgia
    {  332, 6840,   29297, 12, }, // Atlantic/St_Helena
    {  332, 1672,   21683,  8, }, // Australia/Adelaide
    {  332, 1465,   23398,  6, }, // Australia/Sydney
    {  332, 6460,   79252,  9, }, // Europe/Amsterdam
    {  332, 3639,   79261,  8, }, // Europe/Astrakhan
    {  332, 2302,   29309,  6, }, // Europe/Athens
    {  332, 6355,   63633,  8, }, // Europe/Belgrade
    {  332, 4776,   21712,  6, }, // Europe/Berlin
    {  332, 2169,   79269,  8, }, // Europe/Brussels
    {  332, 3947,   21726,  8, }, // Europe/Bucharest
    {  332, 8790,     799,  8, }, // Europe/Busingen
    {  332, 2585,     807,  8, }, // Europe/Chisinau
    {  332, 6308,   21734, 10, }, // Europe/Copenhagen
    {  332, 2340,   21744,  6, }, // Europe/Dublin
    {  332, 6326,   21750,  9, }, // Europe/Gibraltar
    {  332, 6631,   79277,  9, }, // Europe/Helsinki
    {  332, 8822,   79286, 11, }, // Europe/Isle_of_Man
    {  332, 3998,   67731, 12, }, // Europe/Kaliningrad
    {  332, 2529,   46438,  4, }, // Europe/Kyiv
    {  332, 3232,   21790,  6, }, // Europe/Lisbon
    {  332, 6525,   21796,  9, }, // Europe/Ljubljana
    {  332, 2503,   21805,  7, }, // Europe/London
    {  332, 6384,   79297, 10, }, // Europe/Luxembourg
    {  332, 6429,   79307,  6, }, // Europe/Monaco
    {  332, 3556,   79313,  7, }, // Europe/Moscow
    {  332, 4303,   21833,  5, }, // Europe/Paris
    {  332, 6294,   21838,  5, }, // Europe/Prague
    {  332, 6343,   21843,  4, }, // Europe/Rome
    {  332, 6264,   79320,  8, }, // Europe/Sarajevo
    {  332, 8880,   79328, 10, }, // Europe/Simferopol
    {  332, 6618,   21856,  5, }, // Europe/Sofia
    {  332, 6542,   79338,  9, }, // Europe/Stockholm
    {  332, 6221,     819,  6, }, // Europe/Tirane
    {  332, 8913,   29384,  9, }, // Europe/Ulyanovsk
    {  332, 6586,   79347,  8, }, // Europe/Vatican
    {  332, 6250,   21881,  5, }, // Europe/Vienna
    {  332, 4746,   67912, 10, }, // Europe/Volgograd
    {  332, 3209,   21895,  8, }, // Europe/Warsaw
    {  332, 6559,    5217,  6, }, // Europe/Zurich
    {  332, 6065,   79355, 14, }, // Indian/Christmas
    {  332, 5048,    4421,  7, }, // Indian/Comoro
    {  332, 7260,     896,  4, }, // Indian/Mahe
    {  332, 7069,   79369,  8, }, // Indian/Maldives
    {  332, 4088,   79377,  8, }, // Indian/Mauritius
    {  332, 7211,   21911,  7, }, // Indian/Reunion
    {  332, 3176,     922,  5, }, // Pacific/Chuuk
    {  332, 2239,   79385, 14, }, // Pacific/Easter
    {  332, 3921,   21924,  4, }, // Pacific/Fiji
    {  332, 6697,   79399, 15, }, // Pacific/Galapagos
    {  332, 2725,   79414,  8, }, // Pacific/Honolulu
    {  332, 3068,   79422, 11, }, // Pacific/Kanton
    {  332, 7117,    1028,  6, }, // Pacific/Noumea
    {  332, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  332, 7312,   46529,  6, }, // Pacific/Tahiti
    {  332, 7405,    1068, 15, }, // Pacific/Wallis
    {  333,   14,       0,  6, }, // Africa/Asmara Ganda/Latin/Uganda
    {  333, 5185,       6,  8, }, // Africa/El_Aaiun
    {  333, 6888,      14,  4, }, // Africa/Lome
    {  333, 5290,      18,  9, }, // Africa/Ndjamena
    {  333, 4454,      27,  8, }, // Africa/Sao_Tome
    {  333, 4573,      35,  9, }, // America/Araguaina
    {  333,  270,      44,  7, }, // America/Argentina/Cordoba
    {  333, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  333, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  333, 4271,      70,  8, }, // America/Asuncion
    {  333,  237,      78,  8, }, // America/Atikokan
    {  333, 7623,      86, 17, }, // America/Bahia_Banderas
    {  333, 7646,     103,  5, }, // America/Belem
    {  333, 4380,     108,  6, }, // America/Bogota
    {  333, 3887,     114,  6, }, // America/Cancun
    {  333, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  333, 3810,     133,  6, }, // America/Cuiaba
    {  333, 5742,     139,  7, }, // America/Curacao
    {  333, 7887,     146,  8, }, // America/Eirunepe
    {  333,  481,     154, 13, }, // America/Indiana/Knox
    {  333, 7979,     167, 16, }, // America/Indiana/Marengo
    {  333, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  333, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  333, 8056,     220, 14, }, // America/Indiana/Vevay
    {  333, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  333, 8104,     252, 16, }, // America/Indiana/Winamac
    {  333, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  333, 5951,     288, 22, }, // America/Lower_Princes
    {  333, 8171,     310,  6, }, // America/Maceio
    {  333, 2919,     316,  8, }, // America/Mazatlan
    {  333, 8238,     324,  6, }, // America/Merida
    {  333, 2951,    4381, 16, }, // America/Mexico_City
    {  333, 4410,     341, 12, }, // America/Miquelon
    {  333, 1852,     353, 19, }, // America/Noronha
    {  333, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  333, 8347,     392, 20, }, // America/North_Dakota/Center
    {  333, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  333,  393,     435,  4, }, // America/Nuuk
    {  333, 8495,     439,  8, }, // America/Santarem
    {  333, 1880,     447,  9, }, // America/Sao_Paulo
    {  333, 6918,     456, 16, }, // America/Scoresbysund
    {  333, 8526,     472, 14, }, // America/St_Barthelemy
    {  333, 2063,     486, 10, }, // America/St_Johns
    {  333, 5882,     496,  9, }, // America/St_Kitts
    {  333, 5899,     505,  9, }, // America/St_Lucia
    {  333,  855,     514, 10, }, // America/St_Thomas
    {  333, 5932,     524, 11, }, // America/St_Vincent
    {  333, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  333, 7295,     643,  5, }, // Antarctica/Syowa
    {  333, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  333, 4790,     704,  5, }, // Asia/Hovd
    {  333, 1187,     709,  9, }, // Asia/Kathmandu
    {  333,  994,     718,  7, }, // Asia/Kolkata
    {  333, 1213,     725,  5, }, // Asia/Macau
    {  333, 1161,     747,  6, }, // Asia/Urumqi
    {  333, 1237,     753,  6, }, // Asia/Yangon
    {  333, 6647,    4413,  8, }, // Atlantic/Canary
    {  333, 1397,     767,  5, }, // Atlantic/Faroe
    {  333, 6840,     773, 10, }, // Atlantic/St_Helena
    {  333, 8790,     799,  8, }, // Europe/Busingen
    {  333, 2585,     807,  8, }, // Europe/Chisinau
    {  333, 2529,     815,  4, }, // Europe/Kyiv
    {  333, 6221,     819,  6, }, // Europe/Tirane
    {  333, 5048,    4421,  7, }, // Indian/Comoro
    {  333, 7260,     896,  4, }, // Indian/Mahe
    {  333, 7211,     900,  7, }, // Indian/Reunion
    {  333, 3176,     922,  5, }, // Pacific/Chuuk
    {  333, 6697,     940,  9, }, // Pacific/Galapagos
    {  333, 3068,     957,  6, }, // Pacific/Kanton
    {  333, 7117,    1028,  6, }, // Pacific/Noumea
    {  333, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  333, 7405,    1068, 15, }, // Pacific/Wallis
    {  334,   14,       0,  6, }, // Africa/Asmara Geez/Ethiopic/Ethiopia
    {  334, 5185,       6,  8, }, // Africa/El_Aaiun
    {  334, 6888,      14,  4, }, // Africa/Lome
    {  334, 5290,      18,  9, }, // Africa/Ndjamena
    {  334, 4454,      27,  8, }, // Africa/Sao_Tome
    {  334, 4573,      35,  9, }, // America/Araguaina
    {  334,  270,      44,  7, }, // America/Argentina/Cordoba
    {  334, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  334, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  334, 4271,      70,  8, }, // America/Asuncion
    {  334,  237,      78,  8, }, // America/Atikokan
    {  334, 7623,      86, 17, }, // America/Bahia_Banderas
    {  334, 7646,     103,  5, }, // America/Belem
    {  334, 4380,     108,  6, }, // America/Bogota
    {  334, 3887,     114,  6, }, // America/Cancun
    {  334, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  334, 3810,     133,  6, }, // America/Cuiaba
    {  334, 5742,     139,  7, }, // America/Curacao
    {  334, 7887,     146,  8, }, // America/Eirunepe
    {  334,  481,     154, 13, }, // America/Indiana/Knox
    {  334, 7979,     167, 16, }, // America/Indiana/Marengo
    {  334, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  334, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  334, 8056,     220, 14, }, // America/Indiana/Vevay
    {  334, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  334, 8104,     252, 16, }, // America/Indiana/Winamac
    {  334, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  334, 5951,     288, 22, }, // America/Lower_Princes
    {  334, 8171,     310,  6, }, // America/Maceio
    {  334, 2919,     316,  8, }, // America/Mazatlan
    {  334, 8238,     324,  6, }, // America/Merida
    {  334, 2951,    4381, 16, }, // America/Mexico_City
    {  334, 4410,     341, 12, }, // America/Miquelon
    {  334, 1852,     353, 19, }, // America/Noronha
    {  334, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  334, 8347,     392, 20, }, // America/North_Dakota/Center
    {  334, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  334,  393,     435,  4, }, // America/Nuuk
    {  334, 8495,     439,  8, }, // America/Santarem
    {  334, 1880,     447,  9, }, // America/Sao_Paulo
    {  334, 6918,     456, 16, }, // America/Scoresbysund
    {  334, 8526,     472, 14, }, // America/St_Barthelemy
    {  334, 2063,     486, 10, }, // America/St_Johns
    {  334, 5882,     496,  9, }, // America/St_Kitts
    {  334, 5899,     505,  9, }, // America/St_Lucia
    {  334,  855,     514, 10, }, // America/St_Thomas
    {  334, 5932,     524, 11, }, // America/St_Vincent
    {  334, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  334, 7295,     643,  5, }, // Antarctica/Syowa
    {  334, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  334, 4790,     704,  5, }, // Asia/Hovd
    {  334, 1187,     709,  9, }, // Asia/Kathmandu
    {  334,  994,     718,  7, }, // Asia/Kolkata
    {  334, 1213,     725,  5, }, // Asia/Macau
    {  334, 1161,     747,  6, }, // Asia/Urumqi
    {  334, 1237,     753,  6, }, // Asia/Yangon
    {  334, 6647,    4413,  8, }, // Atlantic/Canary
    {  334, 1397,     767,  5, }, // Atlantic/Faroe
    {  334, 6840,     773, 10, }, // Atlantic/St_Helena
    {  334, 8790,     799,  8, }, // Europe/Busingen
    {  334, 2585,     807,  8, }, // Europe/Chisinau
    {  334, 2529,     815,  4, }, // Europe/Kyiv
    {  334, 6221,     819,  6, }, // Europe/Tirane
    {  334, 5048,    4421,  7, }, // Indian/Comoro
    {  334, 7260,     896,  4, }, // Indian/Mahe
    {  334, 7211,     900,  7, }, // Indian/Reunion
    {  334, 3176,     922,  5, }, // Pacific/Chuuk
    {  334, 6697,     940,  9, }, // Pacific/Galapagos
    {  334, 3068,     957,  6, }, // Pacific/Kanton
    {  334, 7117,    1028,  6, }, // Pacific/Noumea
    {  334, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  334, 7405,    1068, 15, }, // Pacific/Wallis
    {  336, 6807,   79433,  7, }, // Africa/Abidjan Georgian/Georgian/Georgia
    {  336, 6779,   79440,  4, }, // Africa/Accra
    {  336, 5078,   79444, 10, }, // Africa/Addis_Ababa
    {  336, 7420,   79454,  6, }, // Africa/Algiers
    {  336,   14,   79460,  6, }, // Africa/Asmara
    {  336,   44,   79466,  6, }, // Africa/Bamako
    {  336, 5276,   79472,  5, }, // Africa/Bangui
    {  336, 6765,   79477,  7, }, // Africa/Banjul
    {  336, 7435,   79484,  5, }, // Africa/Bissau
    {  336, 4976,   79489,  8, }, // Africa/Blantyre
    {  336, 5306,   79497,  9, }, // Africa/Brazzaville
    {  336, 4941,   79506,  9, }, // Africa/Bujumbura
    {  336, 2322,   79515,  5, }, // Africa/Cairo
    {  336, 4136,   79520, 10, }, // Africa/Casablanca
    {  336, 7449,   79530,  5, }, // Africa/Ceuta
    {  336, 6792,   79535,  7, }, // Africa/Conakry
    {  336, 6859,   79542,  6, }, // Africa/Dakar
    {  336, 5149,   79548, 13, }, // Africa/Dar_es_Salaam
    {  336, 5062,   79561,  6, }, // Africa/Djibouti
    {  336, 5262,   79567,  5, }, // Africa/Douala
    {  336, 5185,   79572,  9, }, // Africa/El_Aaiun
    {  336, 6872,   79581,  8, }, // Africa/Freetown
    {  336, 4925,   79589,  8, }, // Africa/Gaborone
    {  336, 5034,   79597,  6, }, // Africa/Harare
    {  336, 4498,   79603, 12, }, // Africa/Johannesburg
    {  336, 4518,   79615,  4, }, // Africa/Juba
    {  336, 5170,   79619,  7, }, // Africa/Kampala
    {  336, 4543,   79626,  7, }, // Africa/Khartoum
    {  336, 4992,   79633,  6, }, // Africa/Kigali
    {  336, 5325,   79639,  7, }, // Africa/Kinshasa
    {  336, 4763,   79646,  6, }, // Africa/Lagos
    {  336, 5355,   79652,  9, }, // Africa/Libreville
    {  336, 6888,   79661,  4, }, // Africa/Lome
    {  336, 5230,   79665,  6, }, // Africa/Luanda
    {  336, 4958,   79671,  9, }, // Africa/Lubumbashi
    {  336, 5020,   79680,  6, }, // Africa/Lusaka
    {  336, 5341,   79686,  6, }, // Africa/Malabo
    {  336, 5006,   79692,  6, }, // Africa/Maputo
    {  336, 5216,   79698,  6, }, // Africa/Maseru
    {  336, 5201,   79704,  7, }, // Africa/Mbabane
    {  336, 5132,   79711,  8, }, // Africa/Mogadishu
    {  336, 7053,   79719,  8, }, // Africa/Monrovia
    {  336, 3872,   79727,  7, }, // Africa/Nairobi
    {  336, 5290,   79734,  7, }, // Africa/Ndjamena
    {  336, 5373,   79741,  6, }, // Africa/Niamey
    {  336, 6822,   79747,  8, }, // Africa/Nouakchott
    {  336, 6746,   79755,  8, }, // Africa/Ouagadougou
    {  336, 5244,   79763, 10, }, // Africa/Porto-Novo
    {  336, 4454,   79773,  8, }, // Africa/Sao_Tome
    {  336, 2868,   79781,  7, }, // Africa/Tripoli
    {  336, 6573,   79788,  6, }, // Africa/Tunis
    {  336, 4171,   79794,  8, }, // Africa/Windhoek
    {  336,  132,   79802,  5, }, // America/Adak
    {  336, 3365,   79807,  8, }, // America/Anchorage
    {  336, 5626,   79815,  7, }, // America/Anguilla
    {  336, 5643,   79822,  7, }, // America/Antigua
    {  336, 4573,   79829,  9, }, // America/Araguaina
    {  336,  166,   79838, 13, }, // America/Argentina/Buenos_Aires
    {  336,   91,   79851,  9, }, // America/Argentina/Catamarca
    {  336,  270,   79860,  7, }, // America/Argentina/Cordoba
    {  336,  441,   79867,  5, }, // America/Argentina/Jujuy
    {  336, 7462,   79872,  8, }, // America/Argentina/La_Rioja
    {  336,  565,   79880,  7, }, // America/Argentina/Mendoza
    {  336, 7489,   79887, 12, }, // America/Argentina/Rio_Gallegos
    {  336, 7520,   79899,  5, }, // America/Argentina/Salta
    {  336, 7544,   79904,  9, }, // America/Argentina/San_Juan
    {  336, 5599,   79913,  9, }, // America/Argentina/San_Luis
    {  336, 7571,   79922,  8, }, // America/Argentina/Tucuman
    {  336, 7597,   79930,  6, }, // America/Argentina/Ushuaia
    {  336, 5659,   79936,  5, }, // America/Aruba
    {  336, 4271,   79941,  9, }, // America/Asuncion
    {  336,  237,   79950,  9, }, // America/Atikokan
    {  336, 3698,   79959,  4, }, // America/Bahia
    {  336, 7623,   79963, 15, }, // America/Bahia_Banderas
    {  336, 5673,   79978,  9, }, // America/Barbados
    {  336, 7646,   79987,  6, }, // America/Belem
    {  336, 5426,   79993,  6, }, // America/Belize
    {  336, 7660,   79999, 12, }, // America/Blanc-Sablon
    {  336, 7681,   80011,  9, }, // America/Boa_Vista
    {  336, 4380,   80020,  6, }, // America/Bogota
    {  336, 7699,   80026,  5, }, // America/Boise
    {  336, 7713,   80031, 11, }, // America/Cambridge_Bay
    {  336, 7735,   80042, 12, }, // America/Campo_Grande
    {  336, 3887,   80054,  7, }, // America/Cancun
    {  336, 4713,   80061,  8, }, // America/Caracas
    {  336, 4364,   80069,  6, }, // America/Cayenne
    {  336, 5515,   80075,  7, }, // America/Cayman
    {  336, 2262,   80082,  6, }, // America/Chicago
    {  336, 7756,   80088,  8, }, // America/Chihuahua
    {  336, 7774,   80096, 14, }, // America/Ciudad_Juarez
    {  336, 5441,   80110, 10, }, // America/Costa_Rica
    {  336, 7796,   80120,  8, }, // America/Coyhaique
    {  336, 7814,   80128,  8, }, // America/Creston
    {  336, 3810,   80136,  6, }, // America/Cuiaba
    {  336, 5742,   80142,  8, }, // America/Curacao
    {  336, 7830,   80150, 12, }, // America/Danmarkshavn
    {  336, 7851,   80162,  7, }, // America/Dawson
    {  336, 7866,   80169, 12, }, // America/Dawson_Creek
    {  336,  805,   80181,  7, }, // America/Denver
    {  336, 3484,   80188,  8, }, // America/Detroit
    {  336, 5758,   80196,  8, }, // America/Dominica
    {  336,  893,   80204,  9, }, // America/Edmonton
    {  336, 7887,   80213,  8, }, // America/Eirunepe
    {  336, 5460,   80221,  9, }, // America/El_Salvador
    {  336, 7904,   80230, 12, }, // America/Fort_Nelson
    {  336, 7924,   80242,  9, }, // America/Fortaleza
    {  336, 7942,   80251,  9, }, // America/Glace_Bay
    {  336, 6900,   80260,  7, }, // America/Goose_Bay
    {  336, 4631,   80267, 11, }, // America/Grand_Turk
    {  336, 5789,   80278,  7, }, // America/Grenada
    {  336, 5805,   80285,  9, }, // America/Guadeloupe
    {  336, 3779,   80294,  9, }, // America/Guatemala
    {  336, 4860,   80303,  9, }, // America/Guayaquil
    {  336, 6951,   80312,  6, }, // America/Guyana
    {  336, 1941,   80318,  9, }, // America/Halifax
    {  336, 2283,   80327,  6, }, // America/Havana
    {  336, 7960,   80333,  9, }, // America/Hermosillo
    {  336,  348,   80342, 13, }, // America/Indiana/Indianapolis
    {  336,  481,   80355, 14, }, // America/Indiana/Knox
    {  336, 7979,   80369, 16, }, // America/Indiana/Marengo
    {  336, 8003,   80385, 20, }, // America/Indiana/Petersburg
    {  336, 8030,   80405, 17, }, // America/Indiana/Tell_City
    {  336, 8056,   80422, 14, }, // America/Indiana/Vevay
    {  336, 8078,   80436, 16, }, // America/Indiana/Vincennes
    {  336, 8104,   80452, 17, }, // America/Indiana/Winamac
    {  336, 8128,   80469,  7, }, // America/Inuvik
    {  336,  660,   80476,  8, }, // America/Iqaluit
    {  336, 2801,   80484,  7, }, // America/Jamaica
    {  336, 5399,   80491,  4, }, // America/Juneau
    {  336,  521,   80495,  8, }, // America/Kentucky/Louisville
    {  336, 8143,   80503, 18, }, // America/Kentucky/Monticello
    {  336, 5723,   80521, 11, }, // America/Kralendijk
    {  336, 4395,   80532,  7, }, // America/La_Paz
    {  336, 7169,   80539,  4, }, // America/Lima
    {  336, 3258,   80543, 12, }, // America/Los_Angeles
    {  336, 5951,   80555, 19, }, // America/Lower_Princes
    {  336, 8171,   80574,  6, }, // America/Maceio
    {  336, 8186,   80580,  7, }, // America/Managua
    {  336, 1910,   80587,  7, }, // America/Manaus
    {  336, 5916,   80594,  6, }, // America/Marigot
    {  336, 5824,   80600,  9, }, // America/Martinique
    {  336, 8202,   80609, 10, }, // America/Matamoros
    {  336, 2919,   80619,  9, }, // America/Mazatlan
    {  336, 8220,   80628,  8, }, // America/Menominee
    {  336, 8238,   80636,  6, }, // America/Merida
    {  336, 8253,   80642, 10, }, // America/Metlakatla
    {  336, 2951,   80652,  6, }, // America/Mexico_City
    {  336, 4410,   80658,  8, }, // America/Miquelon
    {  336, 8272,   80666,  8, }, // America/Moncton
    {  336, 8288,   80674,  8, }, // America/Monterrey
    {  336, 4117,   80682, 10, }, // America/Montevideo
    {  336, 5843,   80692,  9, }, // America/Montserrat
    {  336, 5500,   80701,  5, }, // America/Nassau
    {  336, 2381,   80706,  9, }, // America/New_York
    {  336, 8306,   80630,  4, }, // America/Nome
    {  336, 1852,   80715,  7, }, // America/Noronha
    {  336, 8319,   80722, 23, }, // America/North_Dakota/Beulah
    {  336, 8347,   80745, 24, }, // America/North_Dakota/Center
    {  336, 8375,   80769, 28, }, // America/North_Dakota/New_Salem
    {  336,  393,   80797,  7, }, // America/Nuuk
    {  336, 8406,   80804,  7, }, // America/Ojinaga
    {  336, 2358,   80811,  6, }, // America/Panama
    {  336, 6192,   80817, 10, }, // America/Paramaribo
    {  336, 2975,   80827,  7, }, // America/Phoenix
    {  336, 3964,   80834, 13, }, // America/Port-au-Prince
    {  336, 5973,   80847, 14, }, // America/Port_of_Spain
    {  336, 8422,   80861, 11, }, // America/Porto_Velho
    {  336, 5862,   80872, 11, }, // America/Puerto_Rico
    {  336, 4049,   80883, 13, }, // America/Punta_Arenas
    {  336, 8442,   80896, 13, }, // America/Rankin_Inlet
    {  336, 8463,   80909,  6, }, // America/Recife
    {  336, 1997,   80915,  6, }, // America/Regina
    {  336, 8478,   80921,  8, }, // America/Resolute
    {  336,  695,   80929, 10, }, // America/Rio_Branco
    {  336, 8495,   80939,  9, }, // America/Santarem
    {  336, 2203,   80948,  8, }, // America/Santiago
    {  336, 6130,   80956, 13, }, // America/Santo_Domingo
    {  336, 1880,   80969,  9, }, // America/Sao_Paulo
    {  336, 6918,   80978, 12, }, // America/Scoresbysund
    {  336, 8512,   80990,  5, }, // America/Sitka
    {  336, 8526,   80995, 13, }, // America/St_Barthelemy
    {  336, 2063,   81008, 10, }, // America/St_Johns
    {  336, 5882,   81018, 10, }, // America/St_Kitts
    {  336, 5899,   81028, 10, }, // America/St_Lucia
    {  336,  855,   81038, 10, }, // America/St_Thomas
    {  336, 5932,   81048, 12, }, // America/St_Vincent
    {  336, 8548,   81060, 13, }, // America/Swift_Current
    {  336, 5480,   81073, 11, }, // America/Tegucigalpa
    {  336, 5775,   81084,  4, }, // America/Thule
    {  336,  313,   81088,  7, }, // America/Tijuana
    {  336,  608,   81095,  7, }, // America/Toronto
    {  336, 5707,   81102,  7, }, // America/Tortola
    {  336, 2095,   81109,  9, }, // America/Vancouver
    {  336, 2146,   81118,  9, }, // America/Whitehorse
    {  336,  734,   81127,  8, }, // America/Winnipeg
    {  336, 8570,   81135,  8, }, // America/Yakutat
    {  336, 6020,   81143,  5, }, // Antarctica/Casey
    {  336, 6113,   81148,  6, }, // Antarctica/Davis
    {  336, 6152,   81154, 15, }, // Antarctica/DumontDUrville
    {  336, 8586,   81169,  7, }, // Antarctica/Macquarie
    {  336, 7085,   81176,  7, }, // Antarctica/Mawson
    {  336,  932,   81183,  8, }, // Antarctica/McMurdo
    {  336, 8607,   81191,  7, }, // Antarctica/Palmer
    {  336, 7226,   81198,  6, }, // Antarctica/Rothera
    {  336, 7295,   81204,  5, }, // Antarctica/Syowa
    {  336, 8625,   81209,  5, }, // Antarctica/Troll
    {  336, 7374,   81214,  7, }, // Antarctica/Vostok
    {  336, 1431,   81221, 11, }, // Arctic/Longyearbyen
    {  336, 5589,   81232,  5, }, // Asia/Aden
    {  336, 5414,   81237,  6, }, // Asia/Almaty
    {  336, 3987,   81243,  5, }, // Asia/Amman
    {  336, 5530,   81248,  7, }, // Asia/Anadyr
    {  336, 5542,   81255,  5, }, // Asia/Aqtau
    {  336, 5387,   81260,  6, }, // Asia/Aqtobe
    {  336,  966,   81266,  8, }, // Asia/Ashgabat
    {  336, 8642,   81274,  6, }, // Asia/Atyrau
    {  336, 3626,   81280,  7, }, // Asia/Baghdad
    {  336, 5553,   81287,  8, }, // Asia/Bahrain
    {  336, 3672,   81295,  4, }, // Asia/Baku
    {  336, 4485,   81299,  8, }, // Asia/Bangkok
    {  336, 3590,   81307,  8, }, // Asia/Barnaul
    {  336, 4105,   81315,  7, }, // Asia/Beirut
    {  336, 3797,   81322,  7, }, // Asia/Bishkek
    {  336, 6008,   81329,  6, }, // Asia/Brunei
    {  336, 4620,   81335,  4, }, // Asia/Chita
    {  336, 4530,   81339,  7, }, // Asia/Colombo
    {  336, 4559,   81346,  7, }, // Asia/Damascus
    {  336, 1095,   79542,  4, }, // Asia/Dhaka
    {  336, 6211,   81353,  4, }, // Asia/Dili
    {  336, 3615,   81357,  5, }, // Asia/Dubai
    {  336, 6178,   81362,  7, }, // Asia/Dushanbe
    {  336, 8654,   81369,  9, }, // Asia/Famagusta
    {  336, 8669,   81378,  4, }, // Asia/Gaza
    {  336, 4814,   81382,  7, }, // Asia/Hebron
    {  336, 1261,   81389,  8, }, // Asia/Ho_Chi_Minh
    {  336, 2706,   81397,  8, }, // Asia/Hong_Kong
    {  336, 4790,   81405,  5, }, // Asia/Hovd
    {  336, 4203,   81410,  8, }, // Asia/Irkutsk
    {  336, 7025,   81418,  7, }, // Asia/Jakarta
    {  336, 7011,   81425,  8, }, // Asia/Jayapura
    {  336, 1292,   81433, 10, }, // Asia/Jerusalem
    {  336, 3579,   81443,  6, }, // Asia/Kabul
    {  336, 4335,   81449,  8, }, // Asia/Kamchatka
    {  336, 4258,   81457,  6, }, // Asia/Karachi
    {  336, 1187,   81463,  8, }, // Asia/Kathmandu
    {  336, 8679,   81471,  7, }, // Asia/Khandyga
    {  336,  994,   81478,  7, }, // Asia/Kolkata
    {  336, 4216,   81485, 12, }, // Asia/Krasnoyarsk
    {  336, 4878,   81497, 13, }, // Asia/Kuala_Lumpur
    {  336, 5995,   81510,  7, }, // Asia/Kuching
    {  336, 5566,   81517,  7, }, // Asia/Kuwait
    {  336, 1213,   81524,  5, }, // Asia/Macau
    {  336, 4036,   81529,  8, }, // Asia/Magadan
    {  336, 1351,   81537,  8, }, // Asia/Makassar
    {  336, 7182,   81545,  6, }, // Asia/Manila
    {  336, 6939,   81551,  7, }, // Asia/Muscat
    {  336, 2556,   81558,  7, }, // Asia/Nicosia
    {  336, 8693,   81565, 12, }, // Asia/Novokuznetsk
    {  336, 4154,   81577, 12, }, // Asia/Novosibirsk
    {  336, 4248,   81589,  5, }, // Asia/Omsk
    {  336, 7145,   81594,  5, }, // Asia/Oral
    {  336, 6980,   81599,  8, }, // Asia/Phnom_Penh
    {  336, 8711,   81607, 10, }, // Asia/Pontianak
    {  336, 4233,   81617,  8, }, // Asia/Pyongyang
    {  336, 5578,   81625,  6, }, // Asia/Qatar
    {  336, 8726,   81631,  8, }, // Asia/Qostanay
    {  336, 4288,   81639,  9, }, // Asia/Qyzylorda
    {  336, 3603,   81648,  8, }, // Asia/Riyadh
    {  336, 4427,   81656,  8, }, // Asia/Sakhalin
    {  336, 7245,   81664, 10, }, // Asia/Samarkand
    {  336, 3298,   81674,  5, }, // Asia/Seoul
    {  336, 1055,   81679,  6, }, // Asia/Shanghai
    {  336, 3319,   81685,  9, }, // Asia/Singapore
    {  336, 4316,   81694, 14, }, // Asia/Srednekolymsk
    {  336, 3282,   81708,  6, }, // Asia/Taipei
    {  336, 4800,   81714,  8, }, // Asia/Tashkent
    {  336, 3934,   81722,  7, }, // Asia/Tbilisi
    {  336, 2774,   81729,  7, }, // Asia/Tehran
    {  336, 1319,   81736,  7, }, // Asia/Thimphu
    {  336, 2823,   81743,  5, }, // Asia/Tokyo
    {  336, 4591,   81748,  6, }, // Asia/Tomsk
    {  336, 1023,   81754, 10, }, // Asia/Ulaanbaatar
    {  336, 1161,   81764,  6, }, // Asia/Urumqi
    {  336, 8740,   81770,  8, }, // Asia/Ust-Nera
    {  336, 6996,   81778,  9, }, // Asia/Vientiane
    {  336, 4729,   81787, 12, }, // Asia/Vladivostok
    {  336, 4847,   81799,  8, }, // Asia/Yakutsk
    {  336, 1237,   81807,  7, }, // Asia/Yangon
    {  336, 3902,   81814, 13, }, // Asia/Yekaterinburg
    {  336, 3766,   81827,  7, }, // Asia/Yerevan
    {  336, 3682,   81834, 16, }, // Atlantic/Azores
    {  336, 5690,   81850,  7, }, // Atlantic/Bermuda
    {  336, 6647,   81857,  6, }, // Atlantic/Canary
    {  336, 3746,   81863, 10, }, // Atlantic/Cape_Verde
    {  336, 1397,   81873, 17, }, // Atlantic/Faroe
    {  336, 8754,   81890,  7, }, // Atlantic/Madeira
    {  336, 2750,   81897, 10, }, // Atlantic/Reykjavik
    {  336, 7272,   81907, 14, }, // Atlantic/South_Georgia
    {  336, 6840,   81921, 18, }, // Atlantic/St_Helena
    {  336, 6663,   81939,  6, }, // Atlantic/Stanley
    {  336, 1672,   81945,  8, }, // Australia/Adelaide
    {  336, 1637,   81953,  9, }, // Australia/Brisbane
    {  336, 1801,   81962, 12, }, // Australia/Broken_Hill
    {  336, 1585,   81974,  7, }, // Australia/Darwin
    {  336, 3656,   81981,  5, }, // Australia/Eucla
    {  336, 1518,   81986,  7, }, // Australia/Hobart
    {  336, 8771,   81993,  8, }, // Australia/Lindeman
    {  336, 1549,   82001,  9, }, // Australia/Lord_Howe
    {  336, 1729,   82010,  8, }, // Australia/Melbourne
    {  336, 1764,   82018,  5, }, // Australia/Perth
    {  336, 1465,   82023,  6, }, // Australia/Sydney
    {  336, 6460,   82029, 10, }, // Europe/Amsterdam
    {  336, 6235,   82039,  6, }, // Europe/Andorra
    {  336, 3639,   82045,  9, }, // Europe/Astrakhan
    {  336, 2302,   82054,  5, }, // Europe/Athens
    {  336, 6355,   82059,  8, }, // Europe/Belgrade
    {  336, 4776,   82067,  7, }, // Europe/Berlin
    {  336, 6507,   82074, 10, }, // Europe/Bratislava
    {  336, 2169,   82084,  8, }, // Europe/Brussels
    {  336, 3947,   82092,  9, }, // Europe/Bucharest
    {  336, 3825,   82101,  9, }, // Europe/Budapest
    {  336, 8790,   82110,  9, }, // Europe/Busingen
    {  336, 2585,   82119,  9, }, // Europe/Chisinau
    {  336, 6308,   82128, 11, }, // Europe/Copenhagen
    {  336, 2340,   82139,  7, }, // Europe/Dublin
    {  336, 6326,   82146, 10, }, // Europe/Gibraltar
    {  336, 8806,   82156,  6, }, // Europe/Guernsey
    {  336, 6631,   82162,  8, }, // Europe/Helsinki
    {  336, 8822,   82170, 13, }, // Europe/Isle_of_Man
    {  336, 1132,   82183,  8, }, // Europe/Istanbul
    {  336, 8841,   82191,  5, }, // Europe/Jersey
    {  336, 3998,   82196, 12, }, // Europe/Kaliningrad
    {  336, 8855,   82208,  6, }, // Europe/Kirov
    {  336, 2529,   82214,  5, }, // Europe/Kyiv
    {  336, 3232,   82219,  8, }, // Europe/Lisbon
    {  336, 6525,   82227,  9, }, // Europe/Ljubljana
    {  336, 2503,   82236,  7, }, // Europe/London
    {  336, 6384,   82243, 11, }, // Europe/Luxembourg
    {  336, 4911,   82254,  7, }, // Europe/Madrid
    {  336, 6416,   82261,  5, }, // Europe/Malta
    {  336, 6601,   82266,  9, }, // Europe/Mariehamn
    {  336, 3712,   82275,  6, }, // Europe/Minsk
    {  336, 6429,   82281,  6, }, // Europe/Monaco
    {  336, 3556,   82287,  7, }, // Europe/Moscow
    {  336, 6477,   82294,  4, }, // Europe/Oslo
    {  336, 4303,   82298,  6, }, // Europe/Paris
    {  336, 6443,   82304,  9, }, // Europe/Podgorica
    {  336, 6294,   82313,  5, }, // Europe/Prague
    {  336, 8868,   82318,  4, }, // Europe/Riga
    {  336, 6343,   82322,  4, }, // Europe/Rome
    {  336, 4350,   82326,  6, }, // Europe/Samara
    {  336, 6489,   82332, 10, }, // Europe/San_Marino
    {  336, 6264,   82342,  7, }, // Europe/Sarajevo
    {  336, 4470,   82349,  8, }, // Europe/Saratov
    {  336, 8880,   82357, 11, }, // Europe/Simferopol
    {  336, 6402,   82368,  6, }, // Europe/Skopje
    {  336, 6618,   82374,  5, }, // Europe/Sofia
    {  336, 6542,   82379,  9, }, // Europe/Stockholm
    {  336, 8898,   82388,  6, }, // Europe/Tallinn
    {  336, 6221,   82394,  6, }, // Europe/Tirane
    {  336, 8913,   82400, 10, }, // Europe/Ulyanovsk
    {  336, 6371,   82410,  6, }, // Europe/Vaduz
    {  336, 6586,   82416,  8, }, // Europe/Vatican
    {  336, 6250,   82424,  4, }, // Europe/Vienna
    {  336, 8930,   82428,  8, }, // Europe/Vilnius
    {  336, 4746,   82436, 10, }, // Europe/Volgograd
    {  336, 3209,   82446,  7, }, // Europe/Warsaw
    {  336, 6280,   82453,  7, }, // Europe/Zagreb
    {  336, 6559,   82460,  7, }, // Europe/Zurich
    {  336, 5097,   82467, 12, }, // Indian/Antananarivo
    {  336, 6966,   82479,  6, }, // Indian/Chagos
    {  336, 6065,   82485, 13, }, // Indian/Christmas
    {  336, 6082,   82498,  6, }, // Indian/Cocos
    {  336, 5048,   82504,  6, }, // Indian/Comoro
    {  336, 6680,   82510,  9, }, // Indian/Kerguelen
    {  336, 7260,   82519,  4, }, // Indian/Mahe
    {  336, 7069,   82523,  9, }, // Indian/Maldives
    {  336, 4088,   82532,  7, }, // Indian/Mauritius
    {  336, 5117,   82539,  6, }, // Indian/Mayotte
    {  336, 7211,   82545,  9, }, // Indian/Reunion
    {  336, 4441,   82554,  4, }, // Pacific/Apia
    {  336, 3009,   82558,  7, }, // Pacific/Auckland
    {  336, 3725,   82565,  9, }, // Pacific/Bougainville
    {  336, 3034,   82574,  6, }, // Pacific/Chatham
    {  336, 3176,   82580,  5, }, // Pacific/Chuuk
    {  336, 2239,   82585,  6, }, // Pacific/Easter
    {  336, 7360,   82591,  5, }, // Pacific/Efate
    {  336, 7327,   82596,  7, }, // Pacific/Fakaofo
    {  336, 3921,   82603,  4, }, // Pacific/Fiji
    {  336, 7343,   82607,  8, }, // Pacific/Funafuti
    {  336, 6697,   82615, 10, }, // Pacific/Galapagos
    {  336, 6715,   82625,  8, }, // Pacific/Gambier
    {  336, 3841,   82633, 12, }, // Pacific/Guadalcanal
    {  336, 6037,   82645,  5, }, // Pacific/Guam
    {  336, 2725,   82650,  8, }, // Pacific/Honolulu
    {  336, 3068,   82658,  7, }, // Pacific/Kanton
    {  336, 4017,   82665, 10, }, // Pacific/Kiritimati
    {  336, 7038,   82675,  6, }, // Pacific/Kosrae
    {  336, 2844,   82681, 10, }, // Pacific/Kwajalein
    {  336, 4896,   82691,  6, }, // Pacific/Majuro
    {  336, 4070,   82697,  9, }, // Pacific/Marquesas
    {  336, 8945,   82706,  6, }, // Pacific/Midway
    {  336, 7103,   82712,  5, }, // Pacific/Nauru
    {  336, 7132,   82717,  4, }, // Pacific/Niue
    {  336, 4187,   82721,  8, }, // Pacific/Norfolk
    {  336, 7117,   82729,  5, }, // Pacific/Noumea
    {  336, 3145,   82734,  9, }, // Pacific/Pago_Pago
    {  336, 7155,   82743,  5, }, // Pacific/Palau
    {  336, 7194,   82748,  8, }, // Pacific/Pitcairn
    {  336, 3115,   82756,  6, }, // Pacific/Pohnpei
    {  336, 4826,   82762, 11, }, // Pacific/Port_Moresby
    {  336, 6095,   82773,  9, }, // Pacific/Rarotonga
    {  336, 6050,   82782,  7, }, // Pacific/Saipan
    {  336, 7312,   82789,  5, }, // Pacific/Tahiti
    {  336, 6731,   82794,  6, }, // Pacific/Tarawa
    {  336, 4602,   82800,  9, }, // Pacific/Tongatapu
    {  336, 7392,   82809,  5, }, // Pacific/Wake
    {  336, 7405,   82814,  6, }, // Pacific/Wallis
    {  337, 5078,    4428, 11, }, // Africa/Addis_Ababa German/Latin/Germany
    {  337, 7420,   63274,  6, }, // Africa/Algiers
    {  337,   14,       0,  6, }, // Africa/Asmara
    {  337, 2322,    5363,  5, }, // Africa/Cairo
    {  337, 5149,   82820, 10, }, // Africa/Dar_es_Salaam
    {  337, 5062,   82830,  9, }, // Africa/Djibouti
    {  337, 5185,       6,  8, }, // Africa/El_Aaiun
    {  337, 4543,   28878,  7, }, // Africa/Khartoum
    {  337, 6888,      14,  4, }, // Africa/Lome
    {  337, 5132,   82839, 10, }, // Africa/Mogadishu
    {  337, 5290,      18,  9, }, // Africa/Ndjamena
    {  337, 5244,   28916, 10, }, // Africa/Porto-Novo
    {  337, 4454,      27,  8, }, // Africa/Sao_Tome
    {  337, 2868,   62460,  8, }, // Africa/Tripoli
    {  337, 4573,      35,  9, }, // America/Araguaina
    {  337,  270,      44,  7, }, // America/Argentina/Cordoba
    {  337, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  337, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  337, 4271,      70,  8, }, // America/Asuncion
    {  337,  237,      78,  8, }, // America/Atikokan
    {  337, 7623,   22210, 14, }, // America/Bahia_Banderas
    {  337, 7646,     103,  5, }, // America/Belem
    {  337, 4380,     108,  6, }, // America/Bogota
    {  337, 3887,     114,  6, }, // America/Cancun
    {  337, 5515,   82849, 12, }, // America/Cayman
    {  337, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  337, 3810,     133,  6, }, // America/Cuiaba
    {  337, 5742,     139,  7, }, // America/Curacao
    {  337, 7887,     146,  8, }, // America/Eirunepe
    {  337, 2283,   68235,  7, }, // America/Havana
    {  337,  481,     154, 13, }, // America/Indiana/Knox
    {  337, 7979,     167, 16, }, // America/Indiana/Marengo
    {  337, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  337, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  337, 8056,     220, 14, }, // America/Indiana/Vevay
    {  337, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  337, 8104,     252, 16, }, // America/Indiana/Winamac
    {  337, 2801,    4507,  7, }, // America/Jamaica
    {  337, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  337, 5951,     288, 22, }, // America/Lower_Princes
    {  337, 8171,     310,  6, }, // America/Maceio
    {  337, 2919,     316,  8, }, // America/Mazatlan
    {  337, 8238,    7779,  6, }, // America/Merida
    {  337, 2951,   82861, 12, }, // America/Mexico_City
    {  337, 4410,     341, 12, }, // America/Miquelon
    {  337, 1852,     353, 19, }, // America/Noronha
    {  337, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  337, 8347,     392, 20, }, // America/North_Dakota/Center
    {  337, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  337,  393,     435,  4, }, // America/Nuuk
    {  337, 8495,     439,  8, }, // America/Santarem
    {  337, 1880,     447,  9, }, // America/Sao_Paulo
    {  337, 6918,     456, 16, }, // America/Scoresbysund
    {  337, 8526,   29041, 16, }, // America/St_Barthelemy
    {  337, 2063,     486, 10, }, // America/St_Johns
    {  337, 5882,     496,  9, }, // America/St_Kitts
    {  337, 5899,     505,  9, }, // America/St_Lucia
    {  337,  855,     514, 10, }, // America/St_Thomas
    {  337, 5932,     524, 11, }, // America/St_Vincent
    {  337, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  337, 7295,     643,  5, }, // Antarctica/Syowa
    {  337, 7374,    4780,  6, }, // Antarctica/Vostok
    {  337, 5387,    8259,  6, }, // Asia/Aqtobe
    {  337,  966,   46182,  7, }, // Asia/Ashgabat
    {  337, 3626,    4802,  6, }, // Asia/Baghdad
    {  337, 3797,   58409,  8, }, // Asia/Bishkek
    {  337, 6008,   82873, 17, }, // Asia/Brunei
    {  337, 4620,   82890,  7, }, // Asia/Chita
    {  337, 4559,    4841,  8, }, // Asia/Damascus
    {  337, 6178,   58417,  9, }, // Asia/Dushanbe
    {  337, 1261,   82897, 17, }, // Asia/Ho_Chi_Minh
    {  337, 2706,    4871,  8, }, // Asia/Hong_Kong
    {  337, 4790,   82914,  5, }, // Asia/Hovd
    {  337, 4335,   82919, 11, }, // Asia/Kamchatka
    {  337, 4258,   82930,  9, }, // Asia/Karachi
    {  337, 1187,     709,  9, }, // Asia/Kathmandu
    {  337, 8679,   62724,  8, }, // Asia/Khandyga
    {  337,  994,   69066,  8, }, // Asia/Kolkata
    {  337, 4216,    4928, 11, }, // Asia/Krasnoyarsk
    {  337, 1213,    4961,  5, }, // Asia/Macau
    {  337, 6939,   29197,  6, }, // Asia/Muscat
    {  337, 2556,    6387,  7, }, // Asia/Nicosia
    {  337, 8693,   82939, 12, }, // Asia/Novokuznetsk
    {  337, 4154,   82951, 11, }, // Asia/Novosibirsk
    {  337, 4233,   82962,  9, }, // Asia/Pyongyang
    {  337, 5578,    4972,  5, }, // Asia/Qatar
    {  337, 8726,   46251,  8, }, // Asia/Qostanay
    {  337, 4288,   58489,  9, }, // Asia/Qyzylorda
    {  337, 3603,    8440,  4, }, // Asia/Riyadh
    {  337, 4427,   62788,  8, }, // Asia/Sakhalin
    {  337, 3319,   21561,  8, }, // Asia/Singapore
    {  337, 3282,   82971,  6, }, // Asia/Taipei
    {  337, 4800,   58517,  9, }, // Asia/Tashkent
    {  337, 3934,   82977,  6, }, // Asia/Tbilisi
    {  337, 2774,    8495,  7, }, // Asia/Tehran
    {  337, 2823,    4996,  5, }, // Asia/Tokyo
    {  337, 1161,     747,  6, }, // Asia/Urumqi
    {  337, 4729,    5001, 11, }, // Asia/Vladivostok
    {  337, 4847,    8526,  7, }, // Asia/Yakutsk
    {  337, 1237,    8533,  6, }, // Asia/Yangon
    {  337, 3902,    5020, 13, }, // Asia/Yekaterinburg
    {  337, 3766,   58549,  6, }, // Asia/Yerevan
    {  337, 3682,   63568,  6, }, // Atlantic/Azores
    {  337, 6647,   82983,  7, }, // Atlantic/Canary
    {  337, 3746,   29268, 10, }, // Atlantic/Cape_Verde
    {  337, 1397,   82990,  6, }, // Atlantic/Faroe
    {  337, 2750,   82996, 11, }, // Atlantic/Reykjavik
    {  337, 7272,   83007, 11, }, // Atlantic/South_Georgia
    {  337, 6840,     773, 10, }, // Atlantic/St_Helena
    {  337, 3639,   83018,  9, }, // Europe/Astrakhan
    {  337, 2302,    5078,  5, }, // Europe/Athens
    {  337, 6355,   29315,  7, }, // Europe/Belgrade
    {  337, 2169,   23425,  7, }, // Europe/Brussels
    {  337, 3947,   29329,  8, }, // Europe/Bucharest
    {  337, 8790,     799,  8, }, // Europe/Busingen
    {  337, 2585,     807,  8, }, // Europe/Chisinau
    {  337, 6308,    5115, 10, }, // Europe/Copenhagen
    {  337, 8855,   83027,  5, }, // Europe/Kirov
    {  337, 2529,   83032,  4, }, // Europe/Kyiv
    {  337, 3232,    5139,  8, }, // Europe/Lisbon
    {  337, 6384,    5153,  9, }, // Europe/Luxembourg
    {  337, 3556,   58674,  6, }, // Europe/Moscow
    {  337, 6294,    6716,  4, }, // Europe/Prague
    {  337, 6343,    8869,  3, }, // Europe/Rome
    {  337, 4470,   83036,  7, }, // Europe/Saratov
    {  337, 6221,     819,  6, }, // Europe/Tirane
    {  337, 8913,   83043,  9, }, // Europe/Ulyanovsk
    {  337, 6586,    6744,  7, }, // Europe/Vatican
    {  337, 6250,   58704,  4, }, // Europe/Vienna
    {  337, 4746,    5201,  9, }, // Europe/Volgograd
    {  337, 3209,   58717,  8, }, // Europe/Warsaw
    {  337, 6559,    5217,  6, }, // Europe/Zurich
    {  337, 6065,   83052, 15, }, // Indian/Christmas
    {  337, 5048,   83067,  7, }, // Indian/Comoro
    {  337, 7260,     896,  4, }, // Indian/Mahe
    {  337, 7069,   83074,  9, }, // Indian/Maldives
    {  337, 7211,     900,  7, }, // Indian/Reunion
    {  337, 3176,     922,  5, }, // Pacific/Chuuk
    {  337, 2239,   83083, 10, }, // Pacific/Easter
    {  337, 3921,   83093,  7, }, // Pacific/Fiji
    {  337, 6697,     940,  9, }, // Pacific/Galapagos
    {  337, 2725,    5251,  8, }, // Pacific/Honolulu
    {  337, 3068,     957,  6, }, // Pacific/Kanton
    {  337, 7117,    1028,  6, }, // Pacific/Noumea
    {  337, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  337, 7405,    1068, 15, }, // Pacific/Wallis
    {  343, 6008,   82873,  6, }, // Asia/Brunei German/Latin/Switzerland
    {  343, 1213,     725,  5, }, // Asia/Macau
    {  343, 4470,   83100,  7, }, // Europe/Saratov
    {  344, 6807,   83107,  8, }, // Africa/Abidjan Greek/Greek/Greece
    {  344, 6779,   83115,  4, }, // Africa/Accra
    {  344, 5078,   83119, 13, }, // Africa/Addis_Ababa
    {  344, 7420,   83132,  6, }, // Africa/Algiers
    {  344,   14,   83138,  6, }, // Africa/Asmara
    {  344,   44,   83144,  7, }, // Africa/Bamako
    {  344, 5276,   83151,  7, }, // Africa/Bangui
    {  344, 6765,   83158,  8, }, // Africa/Banjul
    {  344, 7435,   83166,  7, }, // Africa/Bissau
    {  344, 4976,   83173,  9, }, // Africa/Blantyre
    {  344, 5306,   83182,  9, }, // Africa/Brazzaville
    {  344, 4941,   83191, 13, }, // Africa/Bujumbura
    {  344, 2322,   83204,  5, }, // Africa/Cairo
    {  344, 4136,   83209, 11, }, // Africa/Casablanca
    {  344, 7449,   83220,  6, }, // Africa/Ceuta
    {  344, 6792,   83226,  7, }, // Africa/Conakry
    {  344, 6859,   83233,  6, }, // Africa/Dakar
    {  344, 5149,   83239, 13, }, // Africa/Dar_es_Salaam
    {  344, 5062,   83252,  9, }, // Africa/Djibouti
    {  344, 5262,   83261,  7, }, // Africa/Douala
    {  344, 5185,   83268,  9, }, // Africa/El_Aaiun
    {  344, 6872,   83277,  8, }, // Africa/Freetown
    {  344, 4925,   83285, 10, }, // Africa/Gaborone
    {  344, 5034,   83295,  6, }, // Africa/Harare
    {  344, 4498,   83301, 15, }, // Africa/Johannesburg
    {  344, 4518,   83316,  7, }, // Africa/Juba
    {  344, 5170,   83323,  7, }, // Africa/Kampala
    {  344, 4543,   83330,  7, }, // Africa/Khartoum
    {  344, 4992,   83337,  7, }, // Africa/Kigali
    {  344, 5325,   83344,  7, }, // Africa/Kinshasa
    {  344, 4763,   83351,  6, }, // Africa/Lagos
    {  344, 5355,   83357,  9, }, // Africa/Libreville
    {  344, 6888,   83366,  4, }, // Africa/Lome
    {  344, 5230,   83370,  7, }, // Africa/Luanda
    {  344, 4958,   83377, 12, }, // Africa/Lubumbashi
    {  344, 5020,   83389,  7, }, // Africa/Lusaka
    {  344, 5341,   83396,  7, }, // Africa/Malabo
    {  344, 5006,   83403,  7, }, // Africa/Maputo
    {  344, 5216,   83410,  7, }, // Africa/Maseru
    {  344, 5201,   83417,  8, }, // Africa/Mbabane
    {  344, 5132,   83425, 11, }, // Africa/Mogadishu
    {  344, 7053,   83436,  8, }, // Africa/Monrovia
    {  344, 3872,   83444,  8, }, // Africa/Nairobi
    {  344, 5290,   83452,  8, }, // Africa/Ndjamena
    {  344, 5373,   83460,  6, }, // Africa/Niamey
    {  344, 6822,   83466,  8, }, // Africa/Nouakchott
    {  344, 6746,   83474, 14, }, // Africa/Ouagadougou
    {  344, 5244,   83488, 10, }, // Africa/Porto-Novo
    {  344, 4454,   83498,  8, }, // Africa/Sao_Tome
    {  344, 2868,   83506,  7, }, // Africa/Tripoli
    {  344, 6573,   83513,  6, }, // Africa/Tunis
    {  344, 4171,   83519,  8, }, // Africa/Windhoek
    {  344,  132,   83527,  5, }, // America/Adak
    {  344, 3365,   83532,  8, }, // America/Anchorage
    {  344, 5626,   83540,  9, }, // America/Anguilla
    {  344, 5643,   83549,  9, }, // America/Antigua
    {  344, 4573,   83558, 11, }, // America/Araguaina
    {  344,  166,   83569, 14, }, // America/Argentina/Buenos_Aires
    {  344,   91,   83583,  9, }, // America/Argentina/Catamarca
    {  344,  270,   83592,  7, }, // America/Argentina/Cordoba
    {  344,  441,   83599,  7, }, // America/Argentina/Jujuy
    {  344, 7462,   83606,  8, }, // America/Argentina/La_Rioja
    {  344,  565,   83614,  7, }, // America/Argentina/Mendoza
    {  344, 7489,   83621, 14, }, // America/Argentina/Rio_Gallegos
    {  344, 7520,   83635,  5, }, // America/Argentina/Salta
    {  344, 7544,   83640,  9, }, // America/Argentina/San_Juan
    {  344, 5599,   83649,  9, }, // America/Argentina/San_Luis
    {  344, 7571,   83658,  9, }, // America/Argentina/Tucuman
    {  344, 7597,   83667,  8, }, // America/Argentina/Ushuaia
    {  344, 5659,   83675,  7, }, // America/Aruba
    {  344, 4271,   83682,  9, }, // America/Asuncion
    {  344,  237,   83691,  8, }, // America/Atikokan
    {  344, 3698,   83699,  5, }, // America/Bahia
    {  344, 7623,   83704, 19, }, // America/Bahia_Banderas
    {  344, 5673,   83723, 12, }, // America/Barbados
    {  344, 7646,   83735,  6, }, // America/Belem
    {  344, 5426,   83741,  6, }, // America/Belize
    {  344, 7660,   83747, 13, }, // America/Blanc-Sablon
    {  344, 7681,   83760, 10, }, // America/Boa_Vista
    {  344, 4380,   83770,  8, }, // America/Bogota
    {  344, 7699,   83778,  6, }, // America/Boise
    {  344, 7713,   83784, 13, }, // America/Cambridge_Bay
    {  344, 7735,   83797, 13, }, // America/Campo_Grande
    {  344, 3887,   83810,  7, }, // America/Cancun
    {  344, 4713,   83817,  7, }, // America/Caracas
    {  344, 4364,   83824,  6, }, // America/Cayenne
    {  344, 5515,   83830,  6, }, // America/Cayman
    {  344, 2262,   83836,  6, }, // America/Chicago
    {  344, 7756,   83842,  9, }, // America/Chihuahua
    {  344, 7774,   83851, 15, }, // America/Ciudad_Juarez
    {  344, 5441,   83866, 10, }, // America/Costa_Rica
    {  344, 7796,   83876,  7, }, // America/Coyhaique
    {  344, 7814,   83883,  7, }, // America/Creston
    {  344, 3810,   83890,  8, }, // America/Cuiaba
    {  344, 5742,   83898,  8, }, // America/Curacao
    {  344, 7830,   83906, 12, }, // America/Danmarkshavn
    {  344, 7851,   83918,  6, }, // America/Dawson
    {  344, 7866,   83924, 11, }, // America/Dawson_Creek
    {  344,  805,   83935,  7, }, // America/Denver
    {  344, 3484,   83942,  8, }, // America/Detroit
    {  344, 5758,   83950,  9, }, // America/Dominica
    {  344,  893,   83959,  9, }, // America/Edmonton
    {  344, 7887,   83968,  9, }, // America/Eirunepe
    {  344, 5460,   83977, 11, }, // America/El_Salvador
    {  344, 7904,   83988, 11, }, // America/Fort_Nelson
    {  344, 7924,   83999,  9, }, // America/Fortaleza
    {  344, 7942,   84008, 11, }, // America/Glace_Bay
    {  344, 6900,   84019, 10, }, // America/Goose_Bay
    {  344, 4631,   84029, 12, }, // America/Grand_Turk
    {  344, 5789,   84041,  7, }, // America/Grenada
    {  344, 5805,   84048, 11, }, // America/Guadeloupe
    {  344, 3779,   84059, 10, }, // America/Guatemala
    {  344, 4860,   84069, 11, }, // America/Guayaquil
    {  344, 6951,   84080,  7, }, // America/Guyana
    {  344, 1941,   84087,  7, }, // America/Halifax
    {  344, 2283,   84094,  5, }, // America/Havana
    {  344, 7960,   84099,  9, }, // America/Hermosillo
    {  344,  348,   84108, 12, }, // America/Indiana/Indianapolis
    {  344,  481,   84120, 12, }, // America/Indiana/Knox
    {  344, 7979,   84132, 17, }, // America/Indiana/Marengo
    {  344, 8003,   84149, 21, }, // America/Indiana/Petersburg
    {  344, 8030,   84170, 17, }, // America/Indiana/Tell_City
    {  344, 8056,   84187, 14, }, // America/Indiana/Vevay
    {  344, 8078,   84201, 15, }, // America/Indiana/Vincennes
    {  344, 8104,   84216, 18, }, // America/Indiana/Winamac
    {  344, 8128,   84234,  7, }, // America/Inuvik
    {  344,  660,   84241,  8, }, // America/Iqaluit
    {  344, 2801,   84249,  8, }, // America/Jamaica
    {  344, 5399,   84257,  6, }, // America/Juneau
    {  344,  521,   84263,  7, }, // America/Kentucky/Louisville
    {  344, 8143,   84270, 19, }, // America/Kentucky/Monticello
    {  344, 5723,   84289,  9, }, // America/Kralendijk
    {  344, 4395,   84298,  6, }, // America/La_Paz
    {  344, 7169,   84304,  4, }, // America/Lima
    {  344, 3258,   84308, 12, }, // America/Los_Angeles
    {  344, 5951,     288, 22, }, // America/Lower_Princes
    {  344, 8171,   84320,  6, }, // America/Maceio
    {  344, 8186,   84326,  9, }, // America/Managua
    {  344, 1910,   84335,  7, }, // America/Manaus
    {  344, 5916,   84342,  7, }, // America/Marigot
    {  344, 5824,   84349,  9, }, // America/Martinique
    {  344, 8202,   84358,  9, }, // America/Matamoros
    {  344, 2919,   84367,  8, }, // America/Mazatlan
    {  344, 8220,   84375,  8, }, // America/Menominee
    {  344, 8238,   84383,  6, }, // America/Merida
    {  344, 8253,   84389, 10, }, // America/Metlakatla
    {  344, 2951,   84399, 16, }, // America/Mexico_City
    {  344, 4410,   84415,  7, }, // America/Miquelon
    {  344, 8272,   84422,  7, }, // America/Moncton
    {  344, 8288,   84429,  8, }, // America/Monterrey
    {  344, 4117,   84437, 10, }, // America/Montevideo
    {  344, 5843,   84447,  8, }, // America/Montserrat
    {  344, 5500,   84455,  6, }, // America/Nassau
    {  344, 2381,   84461,  9, }, // America/New_York
    {  344, 8306,   84470,  4, }, // America/Nome
    {  344, 1852,   84474,  7, }, // America/Noronha
    {  344, 8319,   84481, 23, }, // America/North_Dakota/Beulah
    {  344, 8347,   84504, 22, }, // America/North_Dakota/Center
    {  344, 8375,   84526, 27, }, // America/North_Dakota/New_Salem
    {  344,  393,   84553,  6, }, // America/Nuuk
    {  344, 8406,   84559,  8, }, // America/Ojinaga
    {  344, 2358,   84567,  7, }, // America/Panama
    {  344, 6192,   84574, 11, }, // America/Paramaribo
    {  344, 2975,   84585,  6, }, // America/Phoenix
    {  344, 3964,   84591, 12, }, // America/Port-au-Prince
    {  344, 5973,   84603, 13, }, // America/Port_of_Spain
    {  344, 8422,   84616, 11, }, // America/Porto_Velho
    {  344, 5862,   84627, 12, }, // America/Puerto_Rico
    {  344, 4049,   84639, 13, }, // America/Punta_Arenas
    {  344, 8442,   84652, 12, }, // America/Rankin_Inlet
    {  344, 8463,   84664,  6, }, // America/Recife
    {  344, 1997,   84670,  8, }, // America/Regina
    {  344, 8478,   84678,  8, }, // America/Resolute
    {  344,  695,   84686, 11, }, // America/Rio_Branco
    {  344, 8495,   84697,  8, }, // America/Santarem
    {  344, 2203,   84705,  9, }, // America/Santiago
    {  344, 6130,   84714, 15, }, // America/Santo_Domingo
    {  344, 1880,   84729,  9, }, // America/Sao_Paulo
    {  344, 6918,   84738, 14, }, // America/Scoresbysund
    {  344, 8512,   84752,  5, }, // America/Sitka
    {  344, 8526,   84757, 18, }, // America/St_Barthelemy
    {  344, 2063,   84775,  9, }, // America/St_Johns
    {  344, 5882,   84784,  8, }, // America/St_Kitts
    {  344, 5899,   84792, 11, }, // America/St_Lucia
    {  344,  855,   84803, 11, }, // America/St_Thomas
    {  344, 5932,   84814, 15, }, // America/St_Vincent
    {  344, 8548,   84829, 13, }, // America/Swift_Current
    {  344, 5480,   84842, 14, }, // America/Tegucigalpa
    {  344, 5775,   84856,  5, }, // America/Thule
    {  344,  313,   84861,  8, }, // America/Tijuana
    {  344,  608,   84869,  7, }, // America/Toronto
    {  344, 5707,   84876,  7, }, // America/Tortola
    {  344, 2095,   84883,  9, }, // America/Vancouver
    {  344, 2146,   84892, 10, }, // America/Whitehorse
    {  344,  734,   84902, 10, }, // America/Winnipeg
    {  344, 8570,   84912,  9, }, // America/Yakutat
    {  344, 6020,   84921,  5, }, // Antarctica/Casey
    {  344, 6113,   84926,  7, }, // Antarctica/Davis
    {  344, 6152,   84933, 17, }, // Antarctica/DumontDUrville
    {  344, 8586,   84950,  8, }, // Antarctica/Macquarie
    {  344, 7085,   84958,  5, }, // Antarctica/Mawson
    {  344,  932,   84963,  9, }, // Antarctica/McMurdo
    {  344, 8607,   84972,  6, }, // Antarctica/Palmer
    {  344, 7226,   84978,  6, }, // Antarctica/Rothera
    {  344, 7295,   84984,  5, }, // Antarctica/Syowa
    {  344, 8625,   84989,  4, }, // Antarctica/Troll
    {  344, 7374,   84993,  6, }, // Antarctica/Vostok
    {  344, 1431,   84999, 14, }, // Arctic/Longyearbyen
    {  344, 5589,   85013,  5, }, // Asia/Aden
    {  344, 5414,   85018,  6, }, // Asia/Almaty
    {  344, 3987,   85024,  5, }, // Asia/Amman
    {  344, 5530,   85029,  7, }, // Asia/Anadyr
    {  344, 5542,   85036,  6, }, // Asia/Aqtau
    {  344, 5387,   85042,  7, }, // Asia/Aqtobe
    {  344,  966,   85049,  8, }, // Asia/Ashgabat
    {  344, 8642,   85057,  7, }, // Asia/Atyrau
    {  344, 3626,   85064,  7, }, // Asia/Baghdad
    {  344, 5553,   85071,  8, }, // Asia/Bahrain
    {  344, 3672,   85079,  6, }, // Asia/Baku
    {  344, 4485,   85085,  8, }, // Asia/Bangkok
    {  344, 3590,   85093,  9, }, // Asia/Barnaul
    {  344, 4105,   85102,  7, }, // Asia/Beirut
    {  344, 3797,   85109,  7, }, // Asia/Bishkek
    {  344, 6008,   85116,  8, }, // Asia/Brunei
    {  344, 4620,   85124,  5, }, // Asia/Chita
    {  344, 4530,   85129,  7, }, // Asia/Colombo
    {  344, 4559,   85136,  8, }, // Asia/Damascus
    {  344, 1095,   85144,  5, }, // Asia/Dhaka
    {  344, 6211,   85149,  5, }, // Asia/Dili
    {  344, 3615,   85154,  8, }, // Asia/Dubai
    {  344, 6178,   85162, 10, }, // Asia/Dushanbe
    {  344, 8654,   85172, 10, }, // Asia/Famagusta
    {  344, 8669,   85182,  4, }, // Asia/Gaza
    {  344, 4814,   85186,  7, }, // Asia/Hebron
    {  344, 1261,   85193, 16, }, // Asia/Ho_Chi_Minh
    {  344, 2706,   85209, 11, }, // Asia/Hong_Kong
    {  344, 4790,   85220,  5, }, // Asia/Hovd
    {  344, 4203,   85225,  8, }, // Asia/Irkutsk
    {  344, 7025,   85233,  8, }, // Asia/Jakarta
    {  344, 7011,   85241, 11, }, // Asia/Jayapura
    {  344, 1292,   85252, 10, }, // Asia/Jerusalem
    {  344, 3579,   85262,  7, }, // Asia/Kabul
    {  344, 4335,   85269,  9, }, // Asia/Kamchatka
    {  344, 4258,   85278,  7, }, // Asia/Karachi
    {  344, 1187,   85285,  9, }, // Asia/Kathmandu
    {  344, 8679,   85294,  8, }, // Asia/Khandyga
    {  344,  994,   85302,  8, }, // Asia/Kolkata
    {  344, 4216,   85310, 12, }, // Asia/Krasnoyarsk
    {  344, 4878,   85322, 15, }, // Asia/Kuala_Lumpur
    {  344, 5995,   85337,  9, }, // Asia/Kuching
    {  344, 5566,   85346,  7, }, // Asia/Kuwait
    {  344, 1213,   85353,  5, }, // Asia/Macau
    {  344, 4036,   85358,  9, }, // Asia/Magadan
    {  344, 1351,   85367,  7, }, // Asia/Makassar
    {  344, 7182,   85374,  6, }, // Asia/Manila
    {  344, 6939,   85380,  6, }, // Asia/Muscat
    {  344, 2556,   85386,  8, }, // Asia/Nicosia
    {  344, 8693,   85394, 13, }, // Asia/Novokuznetsk
    {  344, 4154,   85407, 12, }, // Asia/Novosibirsk
    {  344, 4248,   85419,  4, }, // Asia/Omsk
    {  344, 7145,   85423,  4, }, // Asia/Oral
    {  344, 6980,   85427,  9, }, // Asia/Phnom_Penh
    {  344, 8711,   85436,  9, }, // Asia/Pontianak
    {  344, 4233,   85445, 12, }, // Asia/Pyongyang
    {  344, 5578,   85457,  5, }, // Asia/Qatar
    {  344, 8726,   85462,  8, }, // Asia/Qostanay
    {  344, 4288,   85470, 10, }, // Asia/Qyzylorda
    {  344, 3603,   85480,  5, }, // Asia/Riyadh
    {  344, 4427,   85485,  8, }, // Asia/Sakhalin
    {  344, 7245,   85493, 10, }, // Asia/Samarkand
    {  344, 3298,   85503,  5, }, // Asia/Seoul
    {  344, 1055,   85508,  7, }, // Asia/Shanghai
    {  344, 3319,   85515, 10, }, // Asia/Singapore
    {  344, 4316,   85525, 14, }, // Asia/Srednekolymsk
    {  344, 3282,   85539,  6, }, // Asia/Taipei
    {  344, 4800,   85545,  8, }, // Asia/Tashkent
    {  344, 3934,   85553,  7, }, // Asia/Tbilisi
    {  344, 2774,   85560,  8, }, // Asia/Tehran
    {  344, 1319,   85568,  6, }, // Asia/Thimphu
    {  344, 2823,   85574,  5, }, // Asia/Tokyo
    {  344, 4591,   85579,  5, }, // Asia/Tomsk
    {  344, 1023,   85584, 12, }, // Asia/Ulaanbaatar
    {  344, 1161,   85596,  9, }, // Asia/Urumqi
    {  344, 8740,   85605,  9, }, // Asia/Ust-Nera
    {  344, 6996,   85614,  8, }, // Asia/Vientiane
    {  344, 4729,   85622, 11, }, // Asia/Vladivostok
    {  344, 4847,   85633,  9, }, // Asia/Yakutsk
    {  344, 1237,   85642,  8, }, // Asia/Yangon
    {  344, 3902,   85650, 15, }, // Asia/Yekaterinburg
    {  344, 3766,   85665,  6, }, // Asia/Yerevan
    {  344, 3682,   85671,  6, }, // Atlantic/Azores
    {  344, 5690,   85677,  9, }, // Atlantic/Bermuda
    {  344, 6647,   85686,  7, }, // Atlantic/Canary
    {  344, 3746,   85693, 17, }, // Atlantic/Cape_Verde
    {  344, 1397,   85710,  6, }, // Atlantic/Faroe
    {  344, 8754,   85716,  6, }, // Atlantic/Madeira
    {  344, 2750,   85722,  9, }, // Atlantic/Reykjavik
    {  344, 7272,   85731, 13, }, // Atlantic/South_Georgia
    {  344, 6840,   85744,  9, }, // Atlantic/St_Helena
    {  344, 6663,   85753,  7, }, // Atlantic/Stanley
    {  344, 1672,   85760,  8, }, // Australia/Adelaide
    {  344, 1637,   85768, 10, }, // Australia/Brisbane
    {  344, 1801,   85778, 11, }, // Australia/Broken_Hill
    {  344, 1585,   85789,  9, }, // Australia/Darwin
    {  344, 3656,   85798,  7, }, // Australia/Eucla
    {  344, 1518,   85805,  7, }, // Australia/Hobart
    {  344, 8771,   85812,  8, }, // Australia/Lindeman
    {  344, 1549,   85820, 10, }, // Australia/Lord_Howe
    {  344, 1729,   85830,  9, }, // Australia/Melbourne
    {  344, 1764,   85839,  4, }, // Australia/Perth
    {  344, 1465,   85843,  6, }, // Australia/Sydney
    {  344, 6460,   85849, 10, }, // Europe/Amsterdam
    {  344, 6235,   85859,  6, }, // Europe/Andorra
    {  344, 3639,   85865,  8, }, // Europe/Astrakhan
    {  344, 2302,   85873,  5, }, // Europe/Athens
    {  344, 6355,   85878,  9, }, // Europe/Belgrade
    {  344, 4776,   85887,  8, }, // Europe/Berlin
    {  344, 6507,   85895, 11, }, // Europe/Bratislava
    {  344, 2169,   85906,  9, }, // Europe/Brussels
    {  344, 3947,   85915, 11, }, // Europe/Bucharest
    {  344, 3825,   85926, 10, }, // Europe/Budapest
    {  344, 8790,   85936, 10, }, // Europe/Busingen
    {  344, 2585,   85946,  8, }, // Europe/Chisinau
    {  344, 6308,   85954,  9, }, // Europe/Copenhagen
    {  344, 2340,   85963,  8, }, // Europe/Dublin
    {  344, 6326,   85971,  9, }, // Europe/Gibraltar
    {  344, 8806,   85980,  7, }, // Europe/Guernsey
    {  344, 6631,   85987,  7, }, // Europe/Helsinki
    {  344, 8822,   85994, 13, }, // Europe/Isle_of_Man
    {  344, 1132,   86007, 16, }, // Europe/Istanbul
    {  344, 8841,   86023,  7, }, // Europe/Jersey
    {  344, 3998,   86030, 13, }, // Europe/Kaliningrad
    {  344, 8855,   86043,  5, }, // Europe/Kirov
    {  344, 2529,   86048,  5, }, // Europe/Kyiv
    {  344, 3232,   86053,  8, }, // Europe/Lisbon
    {  344, 6525,   86061, 11, }, // Europe/Ljubljana
    {  344, 2503,   86072,  7, }, // Europe/London
    {  344, 6384,   86079, 12, }, // Europe/Luxembourg
    {  344, 4911,   86091,  7, }, // Europe/Madrid
    {  344, 6416,   86098,  5, }, // Europe/Malta
    {  344, 6601,   86103,  9, }, // Europe/Mariehamn
    {  344, 3712,   86112,  5, }, // Europe/Minsk
    {  344, 6429,   86117,  6, }, // Europe/Monaco
    {  344, 3556,   86123,  5, }, // Europe/Moscow
    {  344, 6477,   86128,  4, }, // Europe/Oslo
    {  344, 4303,   86132,  6, }, // Europe/Paris
    {  344, 6443,   86138, 12, }, // Europe/Podgorica
    {  344, 6294,   86150,  5, }, // Europe/Prague
    {  344, 8868,   86155,  4, }, // Europe/Riga
    {  344, 6343,   86159,  4, }, // Europe/Rome
    {  344, 4350,   86163,  6, }, // Europe/Samara
    {  344, 6489,   86169, 13, }, // Europe/San_Marino
    {  344, 6264,   86182,  8, }, // Europe/Sarajevo
    {  344, 4470,   86190,  7, }, // Europe/Saratov
    {  344, 8880,   86197, 11, }, // Europe/Simferopol
    {  344, 6402,   86208,  6, }, // Europe/Skopje
    {  344, 6618,   86214,  5, }, // Europe/Sofia
    {  344, 6542,   86219,  9, }, // Europe/Stockholm
    {  344, 8898,   86228,  5, }, // Europe/Tallinn
    {  344, 6221,   86233,  6, }, // Europe/Tirane
    {  344, 8913,   86239, 10, }, // Europe/Ulyanovsk
    {  344, 6371,   86249,  7, }, // Europe/Vaduz
    {  344, 6586,   86256,  8, }, // Europe/Vatican
    {  344, 6250,   86264,  6, }, // Europe/Vienna
    {  344, 8930,   86270,  8, }, // Europe/Vilnius
    {  344, 4746,   86278, 11, }, // Europe/Volgograd
    {  344, 3209,   86289,  8, }, // Europe/Warsaw
    {  344, 6280,   86297,  8, }, // Europe/Zagreb
    {  344, 6559,   86305,  6, }, // Europe/Zurich
    {  344, 5097,   86311, 12, }, // Indian/Antananarivo
    {  344, 6966,   86323,  7, }, // Indian/Chagos
    {  344, 6065,   86330, 19, }, // Indian/Christmas
    {  344, 6082,   86349,  5, }, // Indian/Cocos
    {  344, 5048,   86354,  6, }, // Indian/Comoro
    {  344, 6680,   86360,  9, }, // Indian/Kerguelen
    {  344, 7260,   86369,  4, }, // Indian/Mahe
    {  344, 7069,   86373,  8, }, // Indian/Maldives
    {  344, 4088,   86381,  9, }, // Indian/Mauritius
    {  344, 5117,   86390,  6, }, // Indian/Mayotte
    {  344, 7211,   86396,  7, }, // Indian/Reunion
    {  344, 4441,   86403,  4, }, // Pacific/Apia
    {  344, 3009,   86407,  6, }, // Pacific/Auckland
    {  344, 3725,   86413, 11, }, // Pacific/Bougainville
    {  344, 3034,   86424,  6, }, // Pacific/Chatham
    {  344, 3176,   86430,  5, }, // Pacific/Chuuk
    {  344, 2239,   86435, 11, }, // Pacific/Easter
    {  344, 7360,   86446,  5, }, // Pacific/Efate
    {  344, 7327,   86451,  7, }, // Pacific/Fakaofo
    {  344, 3921,   86458,  5, }, // Pacific/Fiji
    {  344, 7343,   86463, 10, }, // Pacific/Funafuti
    {  344, 6697,   86473, 11, }, // Pacific/Galapagos
    {  344, 6715,   86484,  8, }, // Pacific/Gambier
    {  344, 3841,   86492, 14, }, // Pacific/Guadalcanal
    {  344, 6037,   86506,  6, }, // Pacific/Guam
    {  344, 2725,   86512, 10, }, // Pacific/Honolulu
    {  344, 3068,   86522,  6, }, // Pacific/Kanton
    {  344, 4017,   86528, 10, }, // Pacific/Kiritimati
    {  344, 7038,   86538,  6, }, // Pacific/Kosrae
    {  344, 2844,   86544, 11, }, // Pacific/Kwajalein
    {  344, 4896,   86555,  8, }, // Pacific/Majuro
    {  344, 4070,   86563,  8, }, // Pacific/Marquesas
    {  344, 8945,   86571,  9, }, // Pacific/Midway
    {  344, 7103,   86580,  7, }, // Pacific/Nauru
    {  344, 7132,   86587,  5, }, // Pacific/Niue
    {  344, 4187,   86592,  7, }, // Pacific/Norfolk
    {  344, 7117,   86599,  6, }, // Pacific/Noumea
    {  344, 3145,   86605, 11, }, // Pacific/Pago_Pago
    {  344, 7155,   86616,  6, }, // Pacific/Palau
    {  344, 7194,   86622,  7, }, // Pacific/Pitcairn
    {  344, 3115,   86629,  6, }, // Pacific/Pohnpei
    {  344, 4826,   86635, 13, }, // Pacific/Port_Moresby
    {  344, 6095,   86648, 10, }, // Pacific/Rarotonga
    {  344, 6050,   86658,  6, }, // Pacific/Saipan
    {  344, 7312,   86664,  5, }, // Pacific/Tahiti
    {  344, 6731,   86669,  7, }, // Pacific/Tarawa
    {  344, 4602,   86676, 11, }, // Pacific/Tongatapu
    {  344, 7392,   86687,  6, }, // Pacific/Wake
    {  344, 7405,   86693,  7, }, // Pacific/Wallis
    {  346,   14,       0,  6, }, // Africa/Asmara Guarani/Latin/Paraguay
    {  346, 5185,       6,  8, }, // Africa/El_Aaiun
    {  346, 6888,      14,  4, }, // Africa/Lome
    {  346, 5290,      18,  9, }, // Africa/Ndjamena
    {  346, 4454,      27,  8, }, // Africa/Sao_Tome
    {  346, 4573,      35,  9, }, // America/Araguaina
    {  346,  270,      44,  7, }, // America/Argentina/Cordoba
    {  346, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  346, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  346, 4271,      70,  8, }, // America/Asuncion
    {  346,  237,      78,  8, }, // America/Atikokan
    {  346, 7623,      86, 17, }, // America/Bahia_Banderas
    {  346, 7646,     103,  5, }, // America/Belem
    {  346, 4380,     108,  6, }, // America/Bogota
    {  346, 3887,     114,  6, }, // America/Cancun
    {  346, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  346, 3810,     133,  6, }, // America/Cuiaba
    {  346, 5742,     139,  7, }, // America/Curacao
    {  346, 7887,     146,  8, }, // America/Eirunepe
    {  346,  481,     154, 13, }, // America/Indiana/Knox
    {  346, 7979,     167, 16, }, // America/Indiana/Marengo
    {  346, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  346, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  346, 8056,     220, 14, }, // America/Indiana/Vevay
    {  346, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  346, 8104,     252, 16, }, // America/Indiana/Winamac
    {  346, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  346, 5951,     288, 22, }, // America/Lower_Princes
    {  346, 8171,     310,  6, }, // America/Maceio
    {  346, 2919,     316,  8, }, // America/Mazatlan
    {  346, 8238,     324,  6, }, // America/Merida
    {  346, 2951,    4381, 16, }, // America/Mexico_City
    {  346, 4410,     341, 12, }, // America/Miquelon
    {  346, 1852,     353, 19, }, // America/Noronha
    {  346, 8319,     372, 20, }, // America/North_Dakota/Beulah
    {  346, 8347,     392, 20, }, // America/North_Dakota/Center
    {  346, 8375,     412, 23, }, // America/North_Dakota/New_Salem
    {  346,  393,     435,  4, }, // America/Nuuk
    {  346, 8495,     439,  8, }, // America/Santarem
    {  346, 1880,     447,  9, }, // America/Sao_Paulo
    {  346, 6918,     456, 16, }, // America/Scoresbysund
    {  346, 8526,     472, 14, }, // America/St_Barthelemy
    {  346, 2063,     486, 10, }, // America/St_Johns
    {  346, 5882,     496,  9, }, // America/St_Kitts
    {  346, 5899,     505,  9, }, // America/St_Lucia
    {  346,  855,     514, 10, }, // America/St_Thomas
    {  346, 5932,     524, 11, }, // America/St_Vincent
    {  346, 6152,    4397, 16, }, // Antarctica/DumontDUrville
    {  346, 7295,     643,  5, }, // Antarctica/Syowa
    {  346, 1261,     688, 11, }, // Asia/Ho_Chi_Minh
    {  346, 4790,     704,  5, }, // Asia/Hovd
    {  346, 1187,     709,  9, }, // Asia/Kathmandu
    {  346,  994,     718,  7, }, // Asia/Kolkata
    {  346, 1213,     725,  5, }, // Asia/Macau
    {  346, 1161,     747,  6, }, // Asia/Urumqi
    {  346, 1237,     753,  6, }, // Asia/Yangon
    {  346, 6647,    4413,  8, }, // Atlantic/Canary
    {  346, 1397,     767,  5, }, // Atlantic/Faroe
    {  346, 6840,     773, 10, }, // Atlantic/St_Helena
    {  346, 8790,     799,  8, }, // Europe/Busingen
    {  346, 2585,     807,  8, }, // Europe/Chisinau
    {  346, 2529,     815,  4, }, // Europe/Kyiv
    {  346, 6221,     819,  6, }, // Europe/Tirane
    {  346, 5048,    4421,  7, }, // Indian/Comoro
    {  346, 7260,     896,  4, }, // Indian/Mahe
    {  346, 7211,     900,  7, }, // Indian/Reunion
    {  346, 3176,     922,  5, }, // Pacific/Chuuk
    {  346, 6697,     940,  9, }, // Pacific/Galapagos
    {  346, 3068,     957,  6, }, // Pacific/Kanton
    {  346, 7117,    1028,  6, }, // Pacific/Noumea
    {  346, 3115,    1050,  7, }, // Pacific/Pohnpei
    {  346, 7405,    1068, 15, }, // Pacific/Wallis
    {  347, 6807,   86700,  8, }, // Africa/Abidjan Gujarati/Gujarati/India
    {  347, 6779,   86708,  4, }, // Africa/Accra
    {  347, 5078,   86712, 10, }, // Africa/Addis_Ababa
    {  347, 7420,   86722,  9, }, // Africa/Algiers
    {  347,   14,   86731,  7, }, // Africa/Asmara
    {  347,   44,   86738,  5, }, // Africa/Bamako
    {  347, 5276,   86743,  6, }, // Africa/Bangui
    {  347, 6765,   86749,  6, }, // Africa/Banjul
    {  347, 7435,   86755,  5, }, // Africa/Bissau
    {  347, 4976,   86760,  8, }, // Africa/Blantyre
    {  347, 5306,   86768, 10, }, // Africa/Brazzaville
    {  347, 4941,   86778,  9, }, // Africa/Bujumbura
    {  347, 2322,   86787,  4, }, // Africa/Cairo
    {  347, 4136,   86791, 11, }, // Africa/Casablanca
    {  347, 7449,   86802,  6, }, // Africa/Ceuta
    {  347, 6792,   86808,  8, }, // Africa/Conakry
    {  347, 6859,   86816,  4, }, // Africa/Dakar
    {  347, 5149,   86820, 11, }, // Africa/Dar_es_Salaam
    {  347, 5062,   86831,  6, }, // Africa/Djibouti
    {  347, 5262,   86837,  5, }, // Africa/Douala
    {  347, 5185,   86842,  6, }, // Africa/El_Aaiun
    {  347, 6872,   86848,  8, }, // Africa/Freetown
    {  347, 4925,   86856,  7, }, // Africa/Gaborone
    {  347, 5034,   86863,  5, }, // Africa/Harare
    {  347, 4498,   86868, 11, }, // Africa/Johannesburg
    {  347, 4518,   86879,  4, }, // Africa/Juba
    {  347, 5170,   86883,  7, }, // Africa/Kampala
    {  347, 4543,   86890,  7, }, // Africa/Khartoum
    {  347, 4992,   86897,  6, }, // Africa/Kigali
    {  347, 5325,   86903,  7, }, // Africa/Kinshasa
    {  347, 4763,   86910,  5, }, // Africa/Lagos
    {  347, 5355,   86915, 10, }, // Africa/Libreville
    {  347, 6888,   86925,  3, }, // Africa/Lome
    {  347, 5230,   86928,  9, }, // Africa/Luanda
    {  347, 4958,   86937, 10, }, // Africa/Lubumbashi
    {  347, 5020,   86947,  6, }, // Africa/Lusaka
    {  347, 5341,   86953,  5, }, // Africa/Malabo
    {  347, 5006,   86958,  6, }, // Africa/Maputo
    {  347, 5216,   86964,  5, }, // Africa/Maseru
    {  347, 5201,   86969,  7, }, // Africa/Mbabane
    {  347, 5132,   86976,  8, }, // Africa/Mogadishu
    {  347, 7053,   86984,  9, }, // Africa/Monrovia
    {  347, 3872,   86993,  6, }, // Africa/Nairobi
    {  347, 5290,   86999,  7, }, // Africa/Ndjamena
    {  347, 5373,   87006,  6, }, // Africa/Niamey
    {  347, 6822,   87012,  6, }, // Africa/Nouakchott
    {  347, 6746,   87018,  8, }, // Africa/Ouagadougou
    {  347, 5244,   87026, 11, }, // Africa/Porto-Novo
    {  347, 4454,   87037,  7, }, // Africa/Sao_Tome
    {  347, 2868,   87044,  8, }, // Africa/Tripoli
    {  347, 6573,   87052,  7, }, // Africa/Tunis
    {  347, 4171,   87059,  7, }, // Africa/Windhoek
    {  347,  132,   87066,  3, }, // America/Adak
    {  347, 3365,   87069,  8, }, // America/Anchorage
    {  347, 5626,   87077,  8, }, // America/Anguilla
    {  347, 5643,   87085,  8, }, // America/Antigua
    {  347, 4573,   87093,  8, }, // America/Araguaina
    {  347,  166,   87101, 12, }, // America/Argentina/Buenos_Aires
    {  347,   91,   87113, 10, }, // America/Argentina/Catamarca
    {  347,  270,   87123,  8, }, // America/Argentina/Cordoba
    {  347,  441,   87131,  5, }, // America/Argentina/Jujuy
    {  347, 7462,   87136,  8, }, // America/Argentina/La_Rioja
    {  347,  565,   87144,  8, }, // America/Argentina/Mendoza
    {  347, 7489,   87152, 11, }, // America/Argentina/Rio_Gallegos
    {  347, 7520,   87163,  6, }, // America/Argentina/Salta
    {  347, 7544,   87169,  8, }, // America/Argentina/San_Juan
    {  347, 5599,   87177,  8, }, // America/Argentina/San_Luis
    {  347, 7571,   87185,  7, }, // America/Argentina/Tucuman
    {  347, 7597,   87192,  5, }, // America/Argentina/Ushuaia
    {  347, 5659,   87197,  5, }, // America/Aruba
    {  347, 4271,   87202,  8, }, // America/Asuncion
    {  347,  237,   87210,  8, }, // America/Atikokan
    {  347, 3698,   87218,  6, }, // America/Bahia
    {  347, 7623,   87224, 14, }, // America/Bahia_Banderas
    {  347, 5673,   87238,  8, }, // America/Barbados
    {  347, 7646,   87246,  5, }, // America/Belem
    {  347, 5426,   87251,  5, }, // America/Belize
    {  347, 7660,   87256, 13, }, // America/Blanc-Sablon
    {  347, 7681,   87269, 10, }, // America/Boa_Vista
    {  347, 4380,   87279,  6, }, // America/Bogota
    {  347, 7699,   87285,  4, }, // America/Boise
    {  347, 7713,   87289, 12, }, // America/Cambridge_Bay
    {  347, 7735,   87301, 13, }, // America/Campo_Grande
    {  347, 3887,   87314,  7, }, // America/Cancun
    {  347, 4713,   87321,  6, }, // America/Caracas
    {  347, 4364,   87327,  6, }, // America/Cayenne
    {  347, 5515,   87333,  5, }, // America/Cayman
    {  347, 2262,   87338,  6, }, // America/Chicago
    {  347, 7756,   87344,  8, }, // America/Chihuahua
    {  347, 7774,   87352, 14, }, // America/Ciudad_Juarez
    {  347, 5441,   87366, 11, }, // America/Costa_Rica
    {  347, 7796,   87377,  5, }, // America/Coyhaique
    {  347, 7814,   87382,  8, }, // America/Creston
    {  347, 3810,   87390,  7, }, // America/Cuiaba
    {  347, 5742,   87397,  7, }, // America/Curacao
    {  347, 7830,   87404, 11, }, // America/Danmarkshavn
    {  347, 7851,   87415,  4, }, // America/Dawson
    {  347, 7866,   87419, 10, }, // America/Dawson_Creek
    {  347,  805,   87429,  6, }, // America/Denver
    {  347, 3484,   87435,  8, }, // America/Detroit
    {  347, 5758,   87443,  8, }, // America/Dominica
    {  347,  893,   87451,  8, }, // America/Edmonton
    {  347, 7887,   87459,  6, }, // America/Eirunepe
    {  347, 5460,   87465, 12, }, // America/El_Salvador
    {  347, 7904,   87477, 12, }, // America/Fort_Nelson
    {  347, 7924,   87489, 10, }, // America/Fortaleza
    {  347, 7942,   87499,  8, }, // America/Glace_Bay
    {  347, 6900,   87507,  6, }, // America/Goose_Bay
    {  347, 4631,   87513, 12, }, // America/Grand_Turk
    {  347, 5789,   87525,  8, }, // America/Grenada
    {  347, 5805,   87533,  9, }, // America/Guadeloupe
    {  347, 3779,   87542, 10, }, // America/Guatemala
    {  347, 4860,   87552,  9, }, // America/Guayaquil
    {  347, 6951,   87561,  5, }, // America/Guyana
    {  347, 1941,   87566,  9, }, // America/Halifax
    {  347, 2283,   87575,  5, }, // America/Havana
    {  347, 7960,   87580,  8, }, // America/Hermosillo
    {  347,  348,   87588, 14, }, // America/Indiana/Indianapolis
    {  347,  481,   87602, 16, }, // America/Indiana/Knox
    {  347, 7979,   87618, 18, }, // America/Indiana/Marengo
    {  347, 8003,   87636, 21, }, // America/Indiana/Petersburg
    {  347, 8030,   87657, 19, }, // America/Indiana/Tell_City
    {  347, 8056,   87676, 15, }, // America/Indiana/Vevay
    {  347, 8078,   87691, 20, }, // America/Indiana/Vincennes
    {  347, 8104,   87711, 18, }, // America/Indiana/Winamac
    {  347, 8128,   87729,  6, }, // America/Inuvik
    {  347,  660,   87735,  7, }, // America/Iqaluit
    {  347, 2801,   87742,  5, }, // America/Jamaica
    {  347, 5399,   87747,  5, }, // America/Juneau
    {  347,  521,   87752,  6, }, // America/Kentucky/Louisville
    {  347, 8143,   87758, 20, }, // America/Kentucky/Monticello
    {  347, 5723,   87778, 11, }, // America/Kralendijk
    {  347, 4395,   87789,  6, }, // America/La_Paz
    {  347, 7169,   87795,  4, }, // America/Lima
    {  347, 3258,   87799, 11, }, // America/Los_Angeles
    {  347, 5951,   87810, 24, }, // America/Lower_Princes
    {  347, 8171,   87834,  5, }, // America/Maceio
    {  347, 8186,   87839,  7, }, // America/Managua
    {  347, 1910,   87846,  4, }, // America/Manaus
    {  347, 5916,   87850,  7, }, // America/Marigot
    {  347, 5824,   87857,  9, }, // America/Martinique
    {  347, 8202,   87866,  9, }, // America/Matamoros
    {  347, 2919,   87875,  7, }, // America/Mazatlan
    {  347, 8220,   87882,  8, }, // America/Menominee
    {  347, 8238,   87890,  6, }, // America/Merida
    {  347, 8253,   87896, 12, }, // America/Metlakatla
    {  347, 2951,   87908, 13, }, // America/Mexico_City
    {  347, 4410,   87921,  9, }, // America/Miquelon
    {  347, 8272,   87930,  7, }, // America/Moncton
    {  347, 8288,   87937,  8, }, // America/Monterrey
    {  347, 4117,   87945, 10, }, // America/Montevideo
    {  347, 5843,   87955,  9, }, // America/Montserrat
    {  347, 5500,   87964,  5, }, // America/Nassau
    {  347, 2381,   87969,  9, }, // America/New_York
    {  347, 8306,   87884,  3, }, // America/Nome
    {  347, 1852,   87978,  8, }, // America/Noronha
    {  347, 8319,   87986, 21, }, // America/North_Dakota/Beulah
    {  347, 8347,   88007, 20, }, // America/North_Dakota/Center
    {  347, 8375,   88027, 23, }, // America/North_Dakota/New_Salem
    {  347,  393,   88050,  3, }, // America/Nuuk
    {  347, 8406,   88053,  7, }, // America/Ojinaga
    {  347, 2358,   88060,  5, }, // America/Panama
    {  347, 6192,   88065, 10, }, // America/Paramaribo
    {  347, 2975,   88075,  7, }, // America/Phoenix
    {  347, 3964,   88082, 15, }, // America/Port-au-Prince
    {  347, 5973,   88097, 14, }, // America/Port_of_Spain
    {  347, 8422,   88111, 13, }, // America/Porto_Velho
    {  347, 5862,   88124, 14, }, // America/Puerto_Rico
    {  347, 4049,   88138, 13, }, // America/Punta_Arenas
    {  347, 8442,   88151, 13, }, // America/Rankin_Inlet
    {  347, 8463,   88164,  5, }, // America/Recife
    {  347, 1997,   88169,  6, }, // America/Regina
    {  347, 8478,   88175,  7, }, // America/Resolute
    {  347,  695,   88182, 12, }, // America/Rio_Branco
    {  347, 8495,   88194,  9, }, // America/Santarem
    {  347, 2203,   88203,  9, }, // America/Santiago
    {  347, 6130,   88212, 13, }, // America/Santo_Domingo
    {  347, 1880,   88225,  9, }, // America/Sao_Paulo
    {  347, 6918,   88234, 14, }, // America/Scoresbysund
    {  347, 8512,   88248,  6, }, // America/Sitka
    {  347, 8526,   88254, 15, }, // America/St_Barthelemy
    {  347, 2063,   88269, 12, }, // America/St_Johns
    {  347, 5882,   88281, 10, }, // America/St_Kitts
    {  347, 5899,   88291, 11, }, // America/St_Lucia
    {  347,  855,   88302,  9, }, // America/St_Thomas
    {  347, 5932,   88311, 14, }, // America/St_Vincent
    {  347, 8548,   88325, 12, }, // America/Swift_Current
    {  347, 5480,   88337, 11, }, // America/Tegucigalpa
    {  347, 5775,   88348,  4, }, // America/Thule
    {  347,  313,   88352,  7, }, // America/Tijuana
    {  347,  608,   88359,  7, }, // America/Toronto
    {  347, 5707,   88366,  8, }, // America/Tortola
    {  347, 2095,   88374,  8, }, // America/Vancouver
    {  347, 2146,   88382, 11, }, // America/Whitehorse
    {  347,  734,   88393,  9, }, // America/Winnipeg
    {  347, 8570,   88402,  5, }, // America/Yakutat
    {  347, 6020,   88407,  4, }, // Antarctica/Casey
    {  347, 6113,   88411,  5, }, // Antarctica/Davis
    {  347, 6152,   88416, 17, }, // Antarctica/DumontDUrville
    {  347, 8586,   88433,  8, }, // Antarctica/Macquarie
    {  347, 7085,   88441,  4, }, // Antarctica/Mawson
    {  347,  932,   88445,  8, }, // Antarctica/McMurdo
    {  347, 8607,   88453,  6, }, // Antarctica/Palmer
    {  347, 7226,   88459,  6, }, // Antarctica/Rothera
    {  347, 7295,   88465,  6, }, // Antarctica/Syowa
    {  347, 8625,   88471,  5, }, // Antarctica/Troll
    {  347, 7374,   88476,  7, }, // Antarctica/Vostok
    {  347, 1431,   88483, 12, }, // Arctic/Longyearbyen
    {  347, 5589,   88495,  4, }, // Asia/Aden
    {  347, 5414,   88499,  7, }, // Asia/Almaty
    {  347, 3987,   88506,  6, }, // Asia/Amman
    {  347, 5530,   88512,  5, }, // Asia/Anadyr
    {  347, 5542,   88517,  5, }, // Asia/Aqtau
    {  347, 5387,   88522,  6, }, // Asia/Aqtobe
    {  347,  966,   88528,  6, }, // Asia/Ashgabat
    {  347, 8642,   88534,  7, }, // Asia/Atyrau
    {  347, 3626,   88541,  5, }, // Asia/Baghdad
    {  347, 5553,   88546,  6, }, // Asia/Bahrain
    {  347, 3672,   87395,  4, }, // Asia/Baku
    {  347, 4485,   88552,  7, }, // Asia/Bangkok
    {  347, 3590,   88559,  6, }, // Asia/Barnaul
    {  347, 4105,   88565,  5, }, // Asia/Beirut
    {  347, 3797,   88570,  6, }, // Asia/Bishkek
    {  347, 6008,   88576,  7, }, // Asia/Brunei
    {  347, 4620,   88583,  4, }, // Asia/Chita
    {  347, 4530,   88587,  6, }, // Asia/Colombo
    {  347, 4559,   88593,  7, }, // Asia/Damascus
    {  347, 1095,   88600,  4, }, // Asia/Dhaka
    {  347, 6211,   88604,  4, }, // Asia/Dili
    {  347, 3615,   88608,  4, }, // Asia/Dubai
    {  347, 6178,   88612,  8, }, // Asia/Dushanbe
    {  347, 8654,   88620, 10, }, // Asia/Famagusta
    {  347, 8669,   88630,  4, }, // Asia/Gaza
    {  347, 4814,   88634,  7, }, // Asia/Hebron
    {  347, 1261,   88641, 14, }, // Asia/Ho_Chi_Minh
    {  347, 2706,   88655,  8, }, // Asia/Hong_Kong
    {  347, 4790,   88663,  5, }, // Asia/Hovd
    {  347, 4203,   88668, 10, }, // Asia/Irkutsk
    {  347, 7025,   88678,  7, }, // Asia/Jakarta
    {  347, 7011,   88685,  7, }, // Asia/Jayapura
    {  347, 1292,   88692,  8, }, // Asia/Jerusalem
    {  347, 3579,   88700,  5, }, // Asia/Kabul
    {  347, 4335,   88705,  8, }, // Asia/Kamchatka
    {  347, 4258,   88713,  5, }, // Asia/Karachi
    {  347, 1187,   88718,  7, }, // Asia/Kathmandu
    {  347, 8679,   88725,  6, }, // Asia/Khandyga
    {  347,  994,   88731,  7, }, // Asia/Kolkata
    {  347, 4216,   88738, 15, }, // Asia/Krasnoyarsk
    {  347, 4878,   88753, 13, }, // Asia/Kuala_Lumpur
    {  347, 5995,   88766,  6, }, // Asia/Kuching
    {  347, 5566,   88772,  5, }, // Asia/Kuwait
    {  347, 1213,   88777,  4, }, // Asia/Macau
    {  347, 4036,   88781,  6, }, // Asia/Magadan
    {  347, 1351,   88787,  7, }, // Asia/Makassar
    {  347, 7182,   88794,  5, }, // Asia/Manila
    {  347, 6939,   88799,  5, }, // Asia/Muscat
    {  347, 2556,   88804,  8, }, // Asia/Nicosia
    {  347, 8693,   88812, 15, }, // Asia/Novokuznetsk
    {  347, 4154,   88827, 15, }, // Asia/Novosibirsk
    {  347, 4248,   88842,  6, }, // Asia/Omsk
    {  347, 7145,   88848,  3, }, // Asia/Oral
    {  347, 6980,   88851, 11, }, // Asia/Phnom_Penh
    {  347, 8711,   88862, 10, }, // Asia/Pontianak
    {  347, 4233,   88872, 10, }, // Asia/Pyongyang
    {  347, 5578,   88882,  4, }, // Asia/Qatar
    {  347, 8726,   88886,  8, }, // Asia/Qostanay
    {  347, 4288,   88894, 10, }, // Asia/Qyzylorda
    {  347, 3603,   88904,  5, }, // Asia/Riyadh
    {  347, 4427,   88909,  6, }, // Asia/Sakhalin
    {  347, 7245,   88915,  7, }, // Asia/Samarkand
    {  347, 3298,   88922,  4, }, // Asia/Seoul
    {  347, 1055,   88926,  6, }, // Asia/Shanghai
    {  347, 3319,   88932,  8, }, // Asia/Singapore
    {  347, 4316,   88940, 17, }, // Asia/Srednekolymsk
    {  347, 3282,   88957,  6, }, // Asia/Taipei
    {  347, 4800,   88963,  8, }, // Asia/Tashkent
    {  347, 3934,   88971,  6, }, // Asia/Tbilisi
    {  347, 2774,   88977,  6, }, // Asia/Tehran
    {  347, 1319,   88983,  6, }, // Asia/Thimphu
    {  347, 2823,   88989,  6, }, // Asia/Tokyo
    {  347, 4591,   88995,  6, }, // Asia/Tomsk
    {  347, 1023,   89001,  8, }, // Asia/Ulaanbaatar
    {  347, 1161,   89009,  7, }, // Asia/Urumqi
    {  347, 8740,   89016,  9, }, // Asia/Ust-Nera
    {  347, 6996,   89025, 10, }, // Asia/Vientiane
    {  347, 4729,   89035, 13, }, // Asia/Vladivostok
    {  347, 4847,   89048,  7, }, // Asia/Yakutsk
    {  347, 1237,   89055,  5, }, // Asia/Yangon
    {  347, 3902,   89060, 13, }, // Asia/Yekaterinburg
    {  347, 3766,   89073,  7, }, // Asia/Yerevan
    {  347, 3682,   89080,  6, }, // Atlantic/Azores
    {  347, 5690,   89086,  7, }, // Atlantic/Bermuda
    {  347, 6647,   89093,  6, }, // Atlantic/Canary
    {  347, 3746,   89099,  9, }, // Atlantic/Cape_Verde
    {  347, 1397,   89108,  4, }, // Atlantic/Faroe
    {  347, 8754,   89112,  5, }, // Atlantic/Madeira
    {  347, 2750,   89117,  8, }, // Atlantic/Reykjavik
    {  347, 7272,   89125, 17, }, // Atlantic/South_Georgia
    {  347, 6840,   89142, 11, }, // Atlantic/St_Helena
    {  347, 6663,   89153,  7, }, // Atlantic/Stanley
    {  347, 1672,   89160,  7, }, // Australia/Adelaide
    {  347, 1637,   89167,  8, }, // Australia/Brisbane
    {  347, 1801,   89175, 10, }, // Australia/Broken_Hill
    {  347, 1585,   89185,  7, }, // Australia/Darwin
    {  347, 3656,   89192,  5, }, // Australia/Eucla
    {  347, 1518,   89197,  7, }, // Australia/Hobart
    {  347, 8771,   89204,  9, }, // Australia/Lindeman
    {  347, 1549,   89213,  9, }, // Australia/Lord_Howe
    {  347, 1729,   89222,  8, }, // Australia/Melbourne
    {  347, 1764,   89230,  4, }, // Australia/Perth
    {  347, 1465,   89234,  5, }, // Australia/Sydney
    {  347, 6460,   89239, 10, }, // Europe/Amsterdam
    {  347, 6235,   89249,  6, }, // Europe/Andorra
    {  347, 3639,   89255,  8, }, // Europe/Astrakhan
    {  347, 2302,   89263,  5, }, // Europe/Athens
    {  347, 6355,   89268,  8, }, // Europe/Belgrade
    {  347, 4776,   89276,  6, }, // Europe/Berlin
    {  347, 6507,   89282, 11, }, // Europe/Bratislava
    {  347, 2169,   89293,  8, }, // Europe/Brussels
    {  347, 3947,   89301,  8, }, // Europe/Bucharest
    {  347, 3825,   89309,  9, }, // Europe/Budapest
    {  347, 8790,   89318,  8, }, // Europe/Busingen
    {  347, 2585,   89326,  7, }, // Europe/Chisinau
    {  347, 6308,   89333,  8, }, // Europe/Copenhagen
    {  347, 2340,   89341,  5, }, // Europe/Dublin
    {  347, 6326,   89346, 10, }, // Europe/Gibraltar
    {  347, 8806,   89356,  6, }, // Europe/Guernsey
    {  347, 6631,   89362,  8, }, // Europe/Helsinki
    {  347, 8822,   89370, 10, }, // Europe/Isle_of_Man
    {  347, 1132,   89380,  9, }, // Europe/Istanbul
    {  347, 8841,   89389,  5, }, // Europe/Jersey
    {  347, 3998,   89394, 12, }, // Europe/Kaliningrad
    {  347, 8855,   89406,  5, }, // Europe/Kirov
    {  347, 2529,   89411,  3, }, // Europe/Kyiv
    {  347, 3232,   89414,  6, }, // Europe/Lisbon
    {  347, 6525,   89420, 10, }, // Europe/Ljubljana
    {  347, 2503,   89430,  4, }, // Europe/London
    {  347, 6384,   89434,  9, }, // Europe/Luxembourg
    {  347, 4911,   89443,  7, }, // Europe/Madrid
    {  347, 6416,   89450,  6, }, // Europe/Malta
    {  347, 6601,   89456,  7, }, // Europe/Mariehamn
    {  347, 3712,   89463,  6, }, // Europe/Minsk
    {  347, 6429,   89469,  6, }, // Europe/Monaco
    {  347, 3556,   89475,  6, }, // Europe/Moscow
    {  347, 6477,   89481,  5, }, // Europe/Oslo
    {  347, 4303,   89486,  5, }, // Europe/Paris
    {  347, 6443,   89491,  9, }, // Europe/Podgorica
    {  347, 6294,   89500,  5, }, // Europe/Prague
    {  347, 8868,   89505,  4, }, // Europe/Riga
    {  347, 6343,   88243,  3, }, // Europe/Rome
    {  347, 4350,   89509,  5, }, // Europe/Samara
    {  347, 6489,   89514, 10, }, // Europe/San_Marino
    {  347, 6264,   89524,  8, }, // Europe/Sarajevo
    {  347, 4470,   89532,  7, }, // Europe/Saratov
    {  347, 8880,   89539, 11, }, // Europe/Simferopol
    {  347, 6402,   89550,  7, }, // Europe/Skopje
    {  347, 6618,   89557,  6, }, // Europe/Sofia
    {  347, 6542,   89563,  8, }, // Europe/Stockholm
    {  347, 8898,   89571,  6, }, // Europe/Tallinn
    {  347, 6221,   89577,  6, }, // Europe/Tirane
    {  347, 8913,   89583, 10, }, // Europe/Ulyanovsk
    {  347, 6371,   89593,  4, }, // Europe/Vaduz
    {  347, 6586,   89597,  6, }, // Europe/Vatican
    {  347, 6250,   89603,  6, }, // Europe/Vienna
    {  347, 8930,   89609,  8, }, // Europe/Vilnius
    {  347, 4746,   89617, 11, }, // Europe/Volgograd
    {  347, 3209,   89628,  5, }, // Europe/Warsaw
    {  347, 6280,   89633,  6, }, // Europe/Zagreb
    {  347, 6559,   89639,  5, }, // Europe/Zurich
    {  347, 5097,   89644, 12, }, // Indian/Antananarivo
    {  347, 6966,   89656,  5, }, // Indian/Chagos
    {  347, 6065,   89661,  7, }, // Indian/Christmas
    {  347, 6082,   89668,  5, }, // Indian/Cocos
    {  347, 5048,   89673,  6, }, // Indian/Comoro
    {  347, 6680,   89679, 10, }, // Indian/Kerguelen
    {  347, 7260,   89689,  4, }, // Indian/Mahe
    {  347, 7069,   89693,  8, }, // Indian/Maldives
    {  347, 4088,   89701,  8, }, // Indian/Mauritius
    {  347, 5117,   89709,  5, }, // Indian/Mayotte
    {  347, 7211,   89714,  8, }, // Indian/Reunion
    {  347, 4441,   89722,  5, }, // Pacific/Apia
    {  347, 3009,   89727,  7, }, // Pacific/Auckland
    {  347, 3725,   89734, 10, }, // Pacific/Bougainville
    {  347, 3034,   89744,  3, }, // Pacific/Chatham
    {  347, 3176,   89747,  3, }, // Pacific/Chuuk
    {  347, 2239,   89750,  5, }, // Pacific/Easter
    {  347, 7360,   89755,  4, }, // Pacific/Efate
    {  347, 7327,   89759,  7, }, // Pacific/Fakaofo
    {  347, 3921,   89766,  4, }, // Pacific/Fiji
    {  347, 7343,   89770,  8, }, // Pacific/Funafuti
    {  347, 6697,   89778,  9, }, // Pacific/Galapagos
    {  347, 6715,   89787,  8, }, // Pacific/Gambier
    {  347, 3841,   89795,  8, }, // Pacific/Guadalcanal
    {  347, 6037,   89803,  5, }, // Pacific/Guam
    {  347, 2725,   89808,  8, }, // Pacific/Honolulu
    {  347, 3068,   89816, 13, }, // Pacific/Kanton
    {  347, 4017,   89829, 10, }, // Pacific/Kiritimati
    {  347, 7038,   89839,  5, }, // Pacific/Kosrae
    {  347, 2844,   89844,  9, }, // Pacific/Kwajalein
    {  347, 4896,   89853,  6, }, // Pacific/Majuro
    {  347, 4070,   89859,  9, }, // Pacific/Marquesas
    {  347, 8945,   89868,  5, }, // Pacific/Midway
    {  347, 7103,   89873,  4, }, // Pacific/Nauru
    {  347, 7132,   89877,  4, }, // Pacific/Niue
    {  347, 4187,   89881,  6, }, // Pacific/Norfolk
    {  347, 7117,   89887,  5, }, // Pacific/Noumea
    {  347, 3145,   89892,  9, }, // Pacific/Pago_Pago
    {  347, 7155,   89901,  4, }, // Pacific/Palau
    {  347, 7194,   89905,  8, }, // Pacific/Pitcairn
    {  347, 3115,   89913,  6, }, // Pacific/Pohnpei
    {  347, 4826,   89919, 14, }, // Pacific/Port_Moresby
    {  347, 6095,   89933,  9, }, // Pacific/Rarotonga
    {  347, 6050,   89942,  5, }, // Pacific/Saipan
    {  347, 7312,   89947,  6, }, // Pacific/Tahiti
    {  347, 6731,   89953,  6, }, // Pacific/Tarawa
    {  347, 4602,   89959,  9, }, // Pacific/Tongatapu
    {  347, 7392,   89968,  3, }, // Pacific/Wake
    {  347, 7405,   89971,  5, }, // Pacific/Wallis
    {  348,   14,       0,  6, }, // Africa/Asmara Gusii/Latin/Kenya
    {  348, 5185,       6,  8, }, // Africa/El_Aaiun
    {  348, 6888,      14,  4, }, // Africa/Lome
    {  348, 5290,      18,  9, }, // Africa/Ndjamena
    {  348, 4454,      27,  8, }, // Africa/Sao_Tome
    {  348, 4573,      35,  9, }, // America/Araguaina
    {  348,  270,      44,  7, }, // America/Argentina/Cordoba
    {  348, 7489,      51, 12, }, // America/Argentina/Rio_Gallegos
    {  348, 7571,      63,  7, }, // America/Argentina/Tucuman
    {  348, 4271,      70,  8, }, // America/Asuncion
    {  348,  237,      78,  8, }, // America/Atikokan
    {  348, 7623,      86, 17, }, // America/Bahia_Banderas
    {  348, 7646,     103,  5, }, // America/Belem
    {  348, 4380,     108,  6, }, // America/Bogota
    {  348, 3887,     114,  6, }, // America/Cancun
    {  348, 7774,     120, 13, }, // America/Ciudad_Juarez
    {  348, 3810,     133,  6, }, // America/Cuiaba
    {  348, 5742,     139,  7, }, // America/Curacao
    {  348, 7887,     146,  8, }, // America/Eirunepe
    {  348,  481,     154, 13, }, // America/Indiana/Knox
    {  348, 7979,     167, 16, }, // America/Indiana/Marengo
    {  348, 8003,     183, 19, }, // America/Indiana/Petersburg
    {  348, 8030,     202, 18, }, // America/Indiana/Tell_City
    {  348, 8056,     220, 14, }, // America/Indiana/Vevay
    {  348, 8078,     234, 18, }, // America/Indiana/Vincennes
    {  348, 8104,     252, 16, }, // America/Indiana/Winamac
    {  348, 8143,     268, 20, }, // America/Kentucky/Monticello
    {  348, 5951,     288, 22, }, // America/Lower